package ebs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ApplyLensService invokes the ebs.ApplyLensService API synchronously
func (client *Client) ApplyLensService(request *ApplyLensServiceRequest) (response *ApplyLensServiceResponse, err error) {
	response = CreateApplyLensServiceResponse()
	err = client.DoAction(request, response)
	return
}

// ApplyLensServiceWithChan invokes the ebs.ApplyLensService API asynchronously
func (client *Client) ApplyLensServiceWithChan(request *ApplyLensServiceRequest) (<-chan *ApplyLensServiceResponse, <-chan error) {
	responseChan := make(chan *ApplyLensServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ApplyLensService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ApplyLensServiceWithCallback invokes the ebs.ApplyLensService API asynchronously
func (client *Client) ApplyLensServiceWithCallback(request *ApplyLensServiceRequest, callback func(response *ApplyLensServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ApplyLensServiceResponse
		var err error
		defer close(result)
		response, err = client.ApplyLensService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ApplyLensServiceRequest is the request struct for api ApplyLensService
type ApplyLensServiceRequest struct {
	*requests.RpcRequest
}

// ApplyLensServiceResponse is the response struct for api ApplyLensService
type ApplyLensServiceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateApplyLensServiceRequest creates a request to invoke ApplyLensService API
func CreateApplyLensServiceRequest() (request *ApplyLensServiceRequest) {
	request = &ApplyLensServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ebs", "2021-07-30", "ApplyLensService", "ebs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateApplyLensServiceResponse creates a response to parse from ApplyLensService response
func CreateApplyLensServiceResponse() (response *ApplyLensServiceResponse) {
	response = &ApplyLensServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
