package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UnlockVirtualMFADevice invokes the ecd.UnlockVirtualMFADevice API synchronously
func (client *Client) UnlockVirtualMFADevice(request *UnlockVirtualMFADeviceRequest) (response *UnlockVirtualMFADeviceResponse, err error) {
	response = CreateUnlockVirtualMFADeviceResponse()
	err = client.DoAction(request, response)
	return
}

// UnlockVirtualMFADeviceWithChan invokes the ecd.UnlockVirtualMFADevice API asynchronously
func (client *Client) UnlockVirtualMFADeviceWithChan(request *UnlockVirtualMFADeviceRequest) (<-chan *UnlockVirtualMFADeviceResponse, <-chan error) {
	responseChan := make(chan *UnlockVirtualMFADeviceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UnlockVirtualMFADevice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UnlockVirtualMFADeviceWithCallback invokes the ecd.UnlockVirtualMFADevice API asynchronously
func (client *Client) UnlockVirtualMFADeviceWithCallback(request *UnlockVirtualMFADeviceRequest, callback func(response *UnlockVirtualMFADeviceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UnlockVirtualMFADeviceResponse
		var err error
		defer close(result)
		response, err = client.UnlockVirtualMFADevice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UnlockVirtualMFADeviceRequest is the request struct for api UnlockVirtualMFADevice
type UnlockVirtualMFADeviceRequest struct {
	*requests.RpcRequest
	SerialNumber string `position:"Query" name:"SerialNumber"`
}

// UnlockVirtualMFADeviceResponse is the response struct for api UnlockVirtualMFADevice
type UnlockVirtualMFADeviceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUnlockVirtualMFADeviceRequest creates a request to invoke UnlockVirtualMFADevice API
func CreateUnlockVirtualMFADeviceRequest() (request *UnlockVirtualMFADeviceRequest) {
	request = &UnlockVirtualMFADeviceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "UnlockVirtualMFADevice", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUnlockVirtualMFADeviceResponse creates a response to parse from UnlockVirtualMFADevice response
func CreateUnlockVirtualMFADeviceResponse() (response *UnlockVirtualMFADeviceResponse) {
	response = &UnlockVirtualMFADeviceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
