package eflo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateEr invokes the eflo.UpdateEr API synchronously
func (client *Client) UpdateEr(request *UpdateErRequest) (response *UpdateErResponse, err error) {
	response = CreateUpdateErResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateErWithChan invokes the eflo.UpdateEr API asynchronously
func (client *Client) UpdateErWithChan(request *UpdateErRequest) (<-chan *UpdateErResponse, <-chan error) {
	responseChan := make(chan *UpdateErResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateEr(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateErWithCallback invokes the eflo.UpdateEr API asynchronously
func (client *Client) UpdateErWithCallback(request *UpdateErRequest, callback func(response *UpdateErResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateErResponse
		var err error
		defer close(result)
		response, err = client.UpdateEr(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateErRequest is the request struct for api UpdateEr
type UpdateErRequest struct {
	*requests.RpcRequest
	ErId        string `position:"Body" name:"ErId"`
	Description string `position:"Body" name:"Description"`
	ErName      string `position:"Body" name:"ErName"`
}

// UpdateErResponse is the response struct for api UpdateEr
type UpdateErResponse struct {
	*responses.BaseResponse
	Code      int                    `json:"Code" xml:"Code"`
	Message   string                 `json:"Message" xml:"Message"`
	RequestId string                 `json:"RequestId" xml:"RequestId"`
	Content   map[string]interface{} `json:"Content" xml:"Content"`
}

// CreateUpdateErRequest creates a request to invoke UpdateEr API
func CreateUpdateErRequest() (request *UpdateErRequest) {
	request = &UpdateErRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo", "2022-05-30", "UpdateEr", "eflo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateErResponse creates a response to parse from UpdateEr response
func CreateUpdateErResponse() (response *UpdateErResponse) {
	response = &UpdateErResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
