package faas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// PullCreateTask invokes the faas.PullCreateTask API synchronously
// api document: https://help.aliyun.com/api/faas/pullcreatetask.html
func (client *Client) PullCreateTask(request *PullCreateTaskRequest) (response *PullCreateTaskResponse, err error) {
	response = CreatePullCreateTaskResponse()
	err = client.DoAction(request, response)
	return
}

// PullCreateTaskWithChan invokes the faas.PullCreateTask API asynchronously
// api document: https://help.aliyun.com/api/faas/pullcreatetask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PullCreateTaskWithChan(request *PullCreateTaskRequest) (<-chan *PullCreateTaskResponse, <-chan error) {
	responseChan := make(chan *PullCreateTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.PullCreateTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// PullCreateTaskWithCallback invokes the faas.PullCreateTask API asynchronously
// api document: https://help.aliyun.com/api/faas/pullcreatetask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) PullCreateTaskWithCallback(request *PullCreateTaskRequest, callback func(response *PullCreateTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *PullCreateTaskResponse
		var err error
		defer close(result)
		response, err = client.PullCreateTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// PullCreateTaskRequest is the request struct for api PullCreateTask
type PullCreateTaskRequest struct {
	*requests.RpcRequest
}

// PullCreateTaskResponse is the response struct for api PullCreateTask
type PullCreateTaskResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Status    string `json:"Status" xml:"Status"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreatePullCreateTaskRequest creates a request to invoke PullCreateTask API
func CreatePullCreateTaskRequest() (request *PullCreateTaskRequest) {
	request = &PullCreateTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("faas", "2017-08-24", "PullCreateTask", "faas", "openAPI")
	request.Method = requests.POST
	return
}

// CreatePullCreateTaskResponse creates a response to parse from PullCreateTask response
func CreatePullCreateTaskResponse() (response *PullCreateTaskResponse) {
	response = &PullCreateTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
