package imageenhan

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GenerateImageWithTextAndImage invokes the imageenhan.GenerateImageWithTextAndImage API synchronously
func (client *Client) GenerateImageWithTextAndImage(request *GenerateImageWithTextAndImageRequest) (response *GenerateImageWithTextAndImageResponse, err error) {
	response = CreateGenerateImageWithTextAndImageResponse()
	err = client.DoAction(request, response)
	return
}

// GenerateImageWithTextAndImageWithChan invokes the imageenhan.GenerateImageWithTextAndImage API asynchronously
func (client *Client) GenerateImageWithTextAndImageWithChan(request *GenerateImageWithTextAndImageRequest) (<-chan *GenerateImageWithTextAndImageResponse, <-chan error) {
	responseChan := make(chan *GenerateImageWithTextAndImageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GenerateImageWithTextAndImage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GenerateImageWithTextAndImageWithCallback invokes the imageenhan.GenerateImageWithTextAndImage API asynchronously
func (client *Client) GenerateImageWithTextAndImageWithCallback(request *GenerateImageWithTextAndImageRequest, callback func(response *GenerateImageWithTextAndImageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GenerateImageWithTextAndImageResponse
		var err error
		defer close(result)
		response, err = client.GenerateImageWithTextAndImage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GenerateImageWithTextAndImageRequest is the request struct for api GenerateImageWithTextAndImage
type GenerateImageWithTextAndImageRequest struct {
	*requests.RpcRequest
	Resolution      string           `position:"Body" name:"Resolution"`
	Number          requests.Integer `position:"Body" name:"Number"`
	Similarity      requests.Float   `position:"Body" name:"Similarity"`
	AspectRatioMode string           `position:"Body" name:"AspectRatioMode"`
	Text            string           `position:"Body" name:"Text"`
	RefImageUrl     string           `position:"Body" name:"RefImageUrl"`
	Async           requests.Boolean `position:"Body" name:"Async"`
}

// GenerateImageWithTextAndImageResponse is the response struct for api GenerateImageWithTextAndImage
type GenerateImageWithTextAndImageResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateGenerateImageWithTextAndImageRequest creates a request to invoke GenerateImageWithTextAndImage API
func CreateGenerateImageWithTextAndImageRequest() (request *GenerateImageWithTextAndImageRequest) {
	request = &GenerateImageWithTextAndImageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imageenhan", "2019-09-30", "GenerateImageWithTextAndImage", "imageenhan", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGenerateImageWithTextAndImageResponse creates a response to parse from GenerateImageWithTextAndImage response
func CreateGenerateImageWithTextAndImageResponse() (response *GenerateImageWithTextAndImageResponse) {
	response = &GenerateImageWithTextAndImageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
