package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BindPictureSearchAppWithDevices invokes the linkvisual.BindPictureSearchAppWithDevices API synchronously
func (client *Client) BindPictureSearchAppWithDevices(request *BindPictureSearchAppWithDevicesRequest) (response *BindPictureSearchAppWithDevicesResponse, err error) {
	response = CreateBindPictureSearchAppWithDevicesResponse()
	err = client.DoAction(request, response)
	return
}

// BindPictureSearchAppWithDevicesWithChan invokes the linkvisual.BindPictureSearchAppWithDevices API asynchronously
func (client *Client) BindPictureSearchAppWithDevicesWithChan(request *BindPictureSearchAppWithDevicesRequest) (<-chan *BindPictureSearchAppWithDevicesResponse, <-chan error) {
	responseChan := make(chan *BindPictureSearchAppWithDevicesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BindPictureSearchAppWithDevices(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BindPictureSearchAppWithDevicesWithCallback invokes the linkvisual.BindPictureSearchAppWithDevices API asynchronously
func (client *Client) BindPictureSearchAppWithDevicesWithCallback(request *BindPictureSearchAppWithDevicesRequest, callback func(response *BindPictureSearchAppWithDevicesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BindPictureSearchAppWithDevicesResponse
		var err error
		defer close(result)
		response, err = client.BindPictureSearchAppWithDevices(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BindPictureSearchAppWithDevicesRequest is the request struct for api BindPictureSearchAppWithDevices
type BindPictureSearchAppWithDevicesRequest struct {
	*requests.RpcRequest
	IotInstanceId string    `position:"Query" name:"IotInstanceId"`
	DeviceIotIds  *[]string `position:"Query" name:"DeviceIotIds"  type:"Repeated"`
	ApiProduct    string    `position:"Body" name:"ApiProduct"`
	ApiRevision   string    `position:"Body" name:"ApiRevision"`
	AppInstanceId string    `position:"Query" name:"AppInstanceId"`
}

// BindPictureSearchAppWithDevicesResponse is the response struct for api BindPictureSearchAppWithDevices
type BindPictureSearchAppWithDevicesResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateBindPictureSearchAppWithDevicesRequest creates a request to invoke BindPictureSearchAppWithDevices API
func CreateBindPictureSearchAppWithDevicesRequest() (request *BindPictureSearchAppWithDevicesRequest) {
	request = &BindPictureSearchAppWithDevicesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "BindPictureSearchAppWithDevices", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateBindPictureSearchAppWithDevicesResponse creates a response to parse from BindPictureSearchAppWithDevices response
func CreateBindPictureSearchAppWithDevicesResponse() (response *BindPictureSearchAppWithDevicesResponse) {
	response = &BindPictureSearchAppWithDevicesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
