package linkvisual

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryMonthRecord invokes the linkvisual.QueryMonthRecord API synchronously
func (client *Client) QueryMonthRecord(request *QueryMonthRecordRequest) (response *QueryMonthRecordResponse, err error) {
	response = CreateQueryMonthRecordResponse()
	err = client.DoAction(request, response)
	return
}

// QueryMonthRecordWithChan invokes the linkvisual.QueryMonthRecord API asynchronously
func (client *Client) QueryMonthRecordWithChan(request *QueryMonthRecordRequest) (<-chan *QueryMonthRecordResponse, <-chan error) {
	responseChan := make(chan *QueryMonthRecordResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryMonthRecord(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryMonthRecordWithCallback invokes the linkvisual.QueryMonthRecord API asynchronously
func (client *Client) QueryMonthRecordWithCallback(request *QueryMonthRecordRequest, callback func(response *QueryMonthRecordResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryMonthRecordResponse
		var err error
		defer close(result)
		response, err = client.QueryMonthRecord(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryMonthRecordRequest is the request struct for api QueryMonthRecord
type QueryMonthRecordRequest struct {
	*requests.RpcRequest
	IotId         string `position:"Query" name:"IotId"`
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	ProductKey    string `position:"Query" name:"ProductKey"`
	Month         string `position:"Query" name:"Month"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
	DeviceName    string `position:"Query" name:"DeviceName"`
}

// QueryMonthRecordResponse is the response struct for api QueryMonthRecord
type QueryMonthRecordResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	Data         string `json:"Data" xml:"Data"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
}

// CreateQueryMonthRecordRequest creates a request to invoke QueryMonthRecord API
func CreateQueryMonthRecordRequest() (request *QueryMonthRecordRequest) {
	request = &QueryMonthRecordRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Linkvisual", "2018-01-20", "QueryMonthRecord", "Linkvisual", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryMonthRecordResponse creates a response to parse from QueryMonthRecord response
func CreateQueryMonthRecordResponse() (response *QueryMonthRecordResponse) {
	response = &QueryMonthRecordResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
