package ltl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyMPCoSPhaseGroup invokes the ltl.ModifyMPCoSPhaseGroup API synchronously
func (client *Client) ModifyMPCoSPhaseGroup(request *ModifyMPCoSPhaseGroupRequest) (response *ModifyMPCoSPhaseGroupResponse, err error) {
	response = CreateModifyMPCoSPhaseGroupResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyMPCoSPhaseGroupWithChan invokes the ltl.ModifyMPCoSPhaseGroup API asynchronously
func (client *Client) ModifyMPCoSPhaseGroupWithChan(request *ModifyMPCoSPhaseGroupRequest) (<-chan *ModifyMPCoSPhaseGroupResponse, <-chan error) {
	responseChan := make(chan *ModifyMPCoSPhaseGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyMPCoSPhaseGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyMPCoSPhaseGroupWithCallback invokes the ltl.ModifyMPCoSPhaseGroup API asynchronously
func (client *Client) ModifyMPCoSPhaseGroupWithCallback(request *ModifyMPCoSPhaseGroupRequest, callback func(response *ModifyMPCoSPhaseGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyMPCoSPhaseGroupResponse
		var err error
		defer close(result)
		response, err = client.ModifyMPCoSPhaseGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyMPCoSPhaseGroupRequest is the request struct for api ModifyMPCoSPhaseGroup
type ModifyMPCoSPhaseGroupRequest struct {
	*requests.RpcRequest
	Name         string `position:"Query" name:"Name"`
	PhaseGroupId string `position:"Query" name:"PhaseGroupId"`
	ApiVersion   string `position:"Query" name:"ApiVersion"`
	Remark       string `position:"Query" name:"Remark"`
	BizChainId   string `position:"Query" name:"BizChainId"`
}

// ModifyMPCoSPhaseGroupResponse is the response struct for api ModifyMPCoSPhaseGroup
type ModifyMPCoSPhaseGroupResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateModifyMPCoSPhaseGroupRequest creates a request to invoke ModifyMPCoSPhaseGroup API
func CreateModifyMPCoSPhaseGroupRequest() (request *ModifyMPCoSPhaseGroupRequest) {
	request = &ModifyMPCoSPhaseGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ltl", "2019-05-10", "ModifyMPCoSPhaseGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateModifyMPCoSPhaseGroupResponse creates a response to parse from ModifyMPCoSPhaseGroup response
func CreateModifyMPCoSPhaseGroupResponse() (response *ModifyMPCoSPhaseGroupResponse) {
	response = &ModifyMPCoSPhaseGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
