package nis

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetInternetTuple invokes the nis.GetInternetTuple API synchronously
func (client *Client) GetInternetTuple(request *GetInternetTupleRequest) (response *GetInternetTupleResponse, err error) {
	response = CreateGetInternetTupleResponse()
	err = client.DoAction(request, response)
	return
}

// GetInternetTupleWithChan invokes the nis.GetInternetTuple API asynchronously
func (client *Client) GetInternetTupleWithChan(request *GetInternetTupleRequest) (<-chan *GetInternetTupleResponse, <-chan error) {
	responseChan := make(chan *GetInternetTupleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetInternetTuple(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetInternetTupleWithCallback invokes the nis.GetInternetTuple API asynchronously
func (client *Client) GetInternetTupleWithCallback(request *GetInternetTupleRequest, callback func(response *GetInternetTupleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetInternetTupleResponse
		var err error
		defer close(result)
		response, err = client.GetInternetTuple(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetInternetTupleRequest is the request struct for api GetInternetTuple
type GetInternetTupleRequest struct {
	*requests.RpcRequest
	OtherPort       string           `position:"Query" name:"OtherPort"`
	CloudIsp        string           `position:"Query" name:"CloudIsp"`
	TopN            requests.Integer `position:"Query" name:"TopN"`
	CloudPort       string           `position:"Query" name:"CloudPort"`
	Protocol        string           `position:"Query" name:"Protocol"`
	OtherIp         string           `position:"Query" name:"OtherIp"`
	InstanceList    *[]string        `position:"Query" name:"InstanceList"  type:"Json"`
	OrderBy         string           `position:"Query" name:"OrderBy"`
	Sort            string           `position:"Query" name:"Sort"`
	UseMultiAccount requests.Boolean `position:"Query" name:"UseMultiAccount"`
	InstanceId      string           `position:"Query" name:"InstanceId"`
	TupleType       requests.Integer `position:"Query" name:"TupleType"`
	CloudIp         string           `position:"Query" name:"CloudIp"`
	CloudIpList     *[]string        `position:"Query" name:"CloudIpList"  type:"Json"`
	OtherIsp        string           `position:"Query" name:"OtherIsp"`
	OtherCountry    string           `position:"Query" name:"OtherCountry"`
	Direction       string           `position:"Query" name:"Direction"`
	EndTime         requests.Integer `position:"Query" name:"EndTime"`
	BeginTime       requests.Integer `position:"Query" name:"BeginTime"`
	OtherCity       string           `position:"Query" name:"OtherCity"`
	AccountIds      *[]string        `position:"Query" name:"AccountIds"  type:"Repeated"`
}

// GetInternetTupleResponse is the response struct for api GetInternetTuple
type GetInternetTupleResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateGetInternetTupleRequest creates a request to invoke GetInternetTuple API
func CreateGetInternetTupleRequest() (request *GetInternetTupleRequest) {
	request = &GetInternetTupleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("nis", "2021-12-16", "GetInternetTuple", "networkana", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetInternetTupleResponse creates a response to parse from GetInternetTuple response
func CreateGetInternetTupleResponse() (response *GetInternetTupleResponse) {
	response = &GetInternetTupleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
