package oceanbasepro

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeTenantUserRoles invokes the oceanbasepro.DescribeTenantUserRoles API synchronously
func (client *Client) DescribeTenantUserRoles(request *DescribeTenantUserRolesRequest) (response *DescribeTenantUserRolesResponse, err error) {
	response = CreateDescribeTenantUserRolesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeTenantUserRolesWithChan invokes the oceanbasepro.DescribeTenantUserRoles API asynchronously
func (client *Client) DescribeTenantUserRolesWithChan(request *DescribeTenantUserRolesRequest) (<-chan *DescribeTenantUserRolesResponse, <-chan error) {
	responseChan := make(chan *DescribeTenantUserRolesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeTenantUserRoles(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeTenantUserRolesWithCallback invokes the oceanbasepro.DescribeTenantUserRoles API asynchronously
func (client *Client) DescribeTenantUserRolesWithCallback(request *DescribeTenantUserRolesRequest, callback func(response *DescribeTenantUserRolesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeTenantUserRolesResponse
		var err error
		defer close(result)
		response, err = client.DescribeTenantUserRoles(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeTenantUserRolesRequest is the request struct for api DescribeTenantUserRoles
type DescribeTenantUserRolesRequest struct {
	*requests.RpcRequest
	TenantId string `position:"Body" name:"TenantId"`
}

// DescribeTenantUserRolesResponse is the response struct for api DescribeTenantUserRoles
type DescribeTenantUserRolesResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Role      []string `json:"Role" xml:"Role"`
}

// CreateDescribeTenantUserRolesRequest creates a request to invoke DescribeTenantUserRoles API
func CreateDescribeTenantUserRolesRequest() (request *DescribeTenantUserRolesRequest) {
	request = &DescribeTenantUserRolesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("OceanBasePro", "2019-09-01", "DescribeTenantUserRoles", "oceanbase", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeTenantUserRolesResponse creates a response to parse from DescribeTenantUserRoles response
func CreateDescribeTenantUserRolesResponse() (response *DescribeTenantUserRolesResponse) {
	response = &DescribeTenantUserRolesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
