package oos

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListApplicationGroups invokes the oos.ListApplicationGroups API synchronously
func (client *Client) ListApplicationGroups(request *ListApplicationGroupsRequest) (response *ListApplicationGroupsResponse, err error) {
	response = CreateListApplicationGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// ListApplicationGroupsWithChan invokes the oos.ListApplicationGroups API asynchronously
func (client *Client) ListApplicationGroupsWithChan(request *ListApplicationGroupsRequest) (<-chan *ListApplicationGroupsResponse, <-chan error) {
	responseChan := make(chan *ListApplicationGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListApplicationGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListApplicationGroupsWithCallback invokes the oos.ListApplicationGroups API asynchronously
func (client *Client) ListApplicationGroupsWithCallback(request *ListApplicationGroupsRequest, callback func(response *ListApplicationGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListApplicationGroupsResponse
		var err error
		defer close(result)
		response, err = client.ListApplicationGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListApplicationGroupsRequest is the request struct for api ListApplicationGroups
type ListApplicationGroupsRequest struct {
	*requests.RpcRequest
	ResourceProduct string           `position:"Query" name:"ResourceProduct"`
	NextToken       string           `position:"Query" name:"NextToken"`
	ResourceId      string           `position:"Query" name:"ResourceId"`
	DeployRegionId  string           `position:"Query" name:"DeployRegionId"`
	ResourceType    string           `position:"Query" name:"ResourceType"`
	ApplicationName string           `position:"Query" name:"ApplicationName"`
	MaxResults      requests.Integer `position:"Query" name:"MaxResults"`
}

// ListApplicationGroupsResponse is the response struct for api ListApplicationGroups
type ListApplicationGroupsResponse struct {
	*responses.BaseResponse
	NextToken         string             `json:"NextToken" xml:"NextToken"`
	RequestId         string             `json:"RequestId" xml:"RequestId"`
	MaxResults        int                `json:"MaxResults" xml:"MaxResults"`
	ApplicationGroups []ApplicationGroup `json:"ApplicationGroups" xml:"ApplicationGroups"`
}

// CreateListApplicationGroupsRequest creates a request to invoke ListApplicationGroups API
func CreateListApplicationGroupsRequest() (request *ListApplicationGroupsRequest) {
	request = &ListApplicationGroupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("oos", "2019-06-01", "ListApplicationGroups", "oos", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListApplicationGroupsResponse creates a response to parse from ListApplicationGroups response
func CreateListApplicationGroupsResponse() (response *ListApplicationGroupsResponse) {
	response = &ListApplicationGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
