package oos

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListInventoryEntries invokes the oos.ListInventoryEntries API synchronously
func (client *Client) ListInventoryEntries(request *ListInventoryEntriesRequest) (response *ListInventoryEntriesResponse, err error) {
	response = CreateListInventoryEntriesResponse()
	err = client.DoAction(request, response)
	return
}

// ListInventoryEntriesWithChan invokes the oos.ListInventoryEntries API asynchronously
func (client *Client) ListInventoryEntriesWithChan(request *ListInventoryEntriesRequest) (<-chan *ListInventoryEntriesResponse, <-chan error) {
	responseChan := make(chan *ListInventoryEntriesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListInventoryEntries(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListInventoryEntriesWithCallback invokes the oos.ListInventoryEntries API asynchronously
func (client *Client) ListInventoryEntriesWithCallback(request *ListInventoryEntriesRequest, callback func(response *ListInventoryEntriesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListInventoryEntriesResponse
		var err error
		defer close(result)
		response, err = client.ListInventoryEntries(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListInventoryEntriesRequest is the request struct for api ListInventoryEntries
type ListInventoryEntriesRequest struct {
	*requests.RpcRequest
	Filter     *[]ListInventoryEntriesFilter `position:"Query" name:"Filter"  type:"Repeated"`
	InstanceId string                        `position:"Query" name:"InstanceId"`
	NextToken  string                        `position:"Query" name:"NextToken"`
	MaxResults requests.Integer              `position:"Query" name:"MaxResults"`
	TypeName   string                        `position:"Query" name:"TypeName"`
}

// ListInventoryEntriesFilter is a repeated param struct in ListInventoryEntriesRequest
type ListInventoryEntriesFilter struct {
	Name     string    `name:"Name"`
	Value    *[]string `name:"Value" type:"Repeated"`
	Operator string    `name:"Operator"`
}

// ListInventoryEntriesResponse is the response struct for api ListInventoryEntries
type ListInventoryEntriesResponse struct {
	*responses.BaseResponse
	NextToken     string                   `json:"NextToken" xml:"NextToken"`
	RequestId     string                   `json:"RequestId" xml:"RequestId"`
	SchemaVersion string                   `json:"SchemaVersion" xml:"SchemaVersion"`
	MaxResults    int                      `json:"MaxResults" xml:"MaxResults"`
	CaptureTime   string                   `json:"CaptureTime" xml:"CaptureTime"`
	TypeName      string                   `json:"TypeName" xml:"TypeName"`
	InstanceId    string                   `json:"InstanceId" xml:"InstanceId"`
	Entries       []map[string]interface{} `json:"Entries" xml:"Entries"`
}

// CreateListInventoryEntriesRequest creates a request to invoke ListInventoryEntries API
func CreateListInventoryEntriesRequest() (request *ListInventoryEntriesRequest) {
	request = &ListInventoryEntriesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("oos", "2019-06-01", "ListInventoryEntries", "oos", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListInventoryEntriesResponse creates a response to parse from ListInventoryEntries response
func CreateListInventoryEntriesResponse() (response *ListInventoryEntriesResponse) {
	response = &ListInventoryEntriesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
