package opensearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UnbindESUserAnalyzer invokes the opensearch.UnbindESUserAnalyzer API synchronously
func (client *Client) UnbindESUserAnalyzer(request *UnbindESUserAnalyzerRequest) (response *UnbindESUserAnalyzerResponse, err error) {
	response = CreateUnbindESUserAnalyzerResponse()
	err = client.DoAction(request, response)
	return
}

// UnbindESUserAnalyzerWithChan invokes the opensearch.UnbindESUserAnalyzer API asynchronously
func (client *Client) UnbindESUserAnalyzerWithChan(request *UnbindESUserAnalyzerRequest) (<-chan *UnbindESUserAnalyzerResponse, <-chan error) {
	responseChan := make(chan *UnbindESUserAnalyzerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UnbindESUserAnalyzer(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UnbindESUserAnalyzerWithCallback invokes the opensearch.UnbindESUserAnalyzer API asynchronously
func (client *Client) UnbindESUserAnalyzerWithCallback(request *UnbindESUserAnalyzerRequest, callback func(response *UnbindESUserAnalyzerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UnbindESUserAnalyzerResponse
		var err error
		defer close(result)
		response, err = client.UnbindESUserAnalyzer(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UnbindESUserAnalyzerRequest is the request struct for api UnbindESUserAnalyzer
type UnbindESUserAnalyzerRequest struct {
	*requests.RoaRequest
	EsInstanceId     string `position:"Path" name:"esInstanceId"`
	AppGroupIdentity string `position:"Path" name:"appGroupIdentity"`
}

// UnbindESUserAnalyzerResponse is the response struct for api UnbindESUserAnalyzer
type UnbindESUserAnalyzerResponse struct {
	*responses.BaseResponse
	Result    map[string]interface{} `json:"result" xml:"result"`
	RequestId string                 `json:"requestId" xml:"requestId"`
}

// CreateUnbindESUserAnalyzerRequest creates a request to invoke UnbindESUserAnalyzer API
func CreateUnbindESUserAnalyzerRequest() (request *UnbindESUserAnalyzerRequest) {
	request = &UnbindESUserAnalyzerRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("OpenSearch", "2017-12-25", "UnbindESUserAnalyzer", "/v4/openapi/app-groups/[appGroupIdentity]/es/[esInstanceId]/actions/unbind-analyzer", "", "")
	request.Method = requests.POST
	return
}

// CreateUnbindESUserAnalyzerResponse creates a response to parse from UnbindESUserAnalyzer response
func CreateUnbindESUserAnalyzerResponse() (response *UnbindESUserAnalyzerResponse) {
	response = &UnbindESUserAnalyzerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
