package paifeaturestore

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteModelFeature invokes the paifeaturestore.DeleteModelFeature API synchronously
func (client *Client) DeleteModelFeature(request *DeleteModelFeatureRequest) (response *DeleteModelFeatureResponse, err error) {
	response = CreateDeleteModelFeatureResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteModelFeatureWithChan invokes the paifeaturestore.DeleteModelFeature API asynchronously
func (client *Client) DeleteModelFeatureWithChan(request *DeleteModelFeatureRequest) (<-chan *DeleteModelFeatureResponse, <-chan error) {
	responseChan := make(chan *DeleteModelFeatureResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteModelFeature(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteModelFeatureWithCallback invokes the paifeaturestore.DeleteModelFeature API asynchronously
func (client *Client) DeleteModelFeatureWithCallback(request *DeleteModelFeatureRequest, callback func(response *DeleteModelFeatureResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteModelFeatureResponse
		var err error
		defer close(result)
		response, err = client.DeleteModelFeature(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteModelFeatureRequest is the request struct for api DeleteModelFeature
type DeleteModelFeatureRequest struct {
	*requests.RoaRequest
	ModelFeatureId string `position:"Path" name:"ModelFeatureId"`
	InstanceId     string `position:"Path" name:"InstanceId"`
}

// DeleteModelFeatureResponse is the response struct for api DeleteModelFeature
type DeleteModelFeatureResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteModelFeatureRequest creates a request to invoke DeleteModelFeature API
func CreateDeleteModelFeatureRequest() (request *DeleteModelFeatureRequest) {
	request = &DeleteModelFeatureRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiFeatureStore", "2023-06-21", "DeleteModelFeature", "/api/v1/instances/[InstanceId]/modelfeatures/[ModelFeatureId]", "", "")
	request.Method = requests.DELETE
	return
}

// CreateDeleteModelFeatureResponse creates a response to parse from DeleteModelFeature response
func CreateDeleteModelFeatureResponse() (response *DeleteModelFeatureResponse) {
	response = &DeleteModelFeatureResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
