package pairecservice

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteSubCrowd invokes the pairecservice.DeleteSubCrowd API synchronously
func (client *Client) DeleteSubCrowd(request *DeleteSubCrowdRequest) (response *DeleteSubCrowdResponse, err error) {
	response = CreateDeleteSubCrowdResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteSubCrowdWithChan invokes the pairecservice.DeleteSubCrowd API asynchronously
func (client *Client) DeleteSubCrowdWithChan(request *DeleteSubCrowdRequest) (<-chan *DeleteSubCrowdResponse, <-chan error) {
	responseChan := make(chan *DeleteSubCrowdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteSubCrowd(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteSubCrowdWithCallback invokes the pairecservice.DeleteSubCrowd API asynchronously
func (client *Client) DeleteSubCrowdWithCallback(request *DeleteSubCrowdRequest, callback func(response *DeleteSubCrowdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteSubCrowdResponse
		var err error
		defer close(result)
		response, err = client.DeleteSubCrowd(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteSubCrowdRequest is the request struct for api DeleteSubCrowd
type DeleteSubCrowdRequest struct {
	*requests.RoaRequest
	CrowdId    string `position:"Path" name:"CrowdId"`
	InstanceId string `position:"Query" name:"InstanceId"`
	SubCrowdId string `position:"Path" name:"SubCrowdId"`
}

// DeleteSubCrowdResponse is the response struct for api DeleteSubCrowd
type DeleteSubCrowdResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteSubCrowdRequest creates a request to invoke DeleteSubCrowd API
func CreateDeleteSubCrowdRequest() (request *DeleteSubCrowdRequest) {
	request = &DeleteSubCrowdRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("PaiRecService", "2022-12-13", "DeleteSubCrowd", "/api/v1/crowds/[CrowdId]/subcrowds/[SubCrowdId]", "", "")
	request.Method = requests.DELETE
	return
}

// CreateDeleteSubCrowdResponse creates a response to parse from DeleteSubCrowd response
func CreateDeleteSubCrowdResponse() (response *DeleteSubCrowdResponse) {
	response = &DeleteSubCrowdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
