package quotas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListProductQuotas invokes the quotas.ListProductQuotas API synchronously
func (client *Client) ListProductQuotas(request *ListProductQuotasRequest) (response *ListProductQuotasResponse, err error) {
	response = CreateListProductQuotasResponse()
	err = client.DoAction(request, response)
	return
}

// ListProductQuotasWithChan invokes the quotas.ListProductQuotas API asynchronously
func (client *Client) ListProductQuotasWithChan(request *ListProductQuotasRequest) (<-chan *ListProductQuotasResponse, <-chan error) {
	responseChan := make(chan *ListProductQuotasResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListProductQuotas(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListProductQuotasWithCallback invokes the quotas.ListProductQuotas API asynchronously
func (client *Client) ListProductQuotasWithCallback(request *ListProductQuotasRequest, callback func(response *ListProductQuotasResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListProductQuotasResponse
		var err error
		defer close(result)
		response, err = client.ListProductQuotas(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListProductQuotasRequest is the request struct for api ListProductQuotas
type ListProductQuotasRequest struct {
	*requests.RpcRequest
	ProductCode     string                         `position:"Body" name:"ProductCode"`
	QuotaActionCode string                         `position:"Body" name:"QuotaActionCode"`
	GroupCode       string                         `position:"Body" name:"GroupCode"`
	NextToken       string                         `position:"Body" name:"NextToken"`
	SortOrder       string                         `position:"Body" name:"SortOrder"`
	KeyWord         string                         `position:"Body" name:"KeyWord"`
	QuotaCategory   string                         `position:"Body" name:"QuotaCategory"`
	OriginalContext string                         `position:"Body" name:"OriginalContext"`
	MaxResults      requests.Integer               `position:"Body" name:"MaxResults"`
	SortField       string                         `position:"Body" name:"SortField"`
	Dimensions      *[]ListProductQuotasDimensions `position:"Body" name:"Dimensions"  type:"Repeated"`
}

// ListProductQuotasDimensions is a repeated param struct in ListProductQuotasRequest
type ListProductQuotasDimensions struct {
	Key   string `name:"Key"`
	Value string `name:"Value"`
}

// ListProductQuotasResponse is the response struct for api ListProductQuotas
type ListProductQuotasResponse struct {
	*responses.BaseResponse
	TotalCount int                             `json:"TotalCount" xml:"TotalCount"`
	NextToken  string                          `json:"NextToken" xml:"NextToken"`
	RequestId  string                          `json:"RequestId" xml:"RequestId"`
	MaxResults int                             `json:"MaxResults" xml:"MaxResults"`
	Quotas     []QuotasItemInListProductQuotas `json:"Quotas" xml:"Quotas"`
}

// CreateListProductQuotasRequest creates a request to invoke ListProductQuotas API
func CreateListProductQuotasRequest() (request *ListProductQuotasRequest) {
	request = &ListProductQuotasRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quotas", "2020-05-10", "ListProductQuotas", "quotas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListProductQuotasResponse creates a response to parse from ListProductQuotas response
func CreateListProductQuotasResponse() (response *ListProductQuotasResponse) {
	response = &ListProductQuotasResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
