package safe

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryCustomer invokes the safe.QueryCustomer API synchronously
func (client *Client) QueryCustomer(request *QueryCustomerRequest) (response *QueryCustomerResponse, err error) {
	response = CreateQueryCustomerResponse()
	err = client.DoAction(request, response)
	return
}

// QueryCustomerWithChan invokes the safe.QueryCustomer API asynchronously
func (client *Client) QueryCustomerWithChan(request *QueryCustomerRequest) (<-chan *QueryCustomerResponse, <-chan error) {
	responseChan := make(chan *QueryCustomerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryCustomer(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryCustomerWithCallback invokes the safe.QueryCustomer API asynchronously
func (client *Client) QueryCustomerWithCallback(request *QueryCustomerRequest, callback func(response *QueryCustomerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryCustomerResponse
		var err error
		defer close(result)
		response, err = client.QueryCustomer(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryCustomerRequest is the request struct for api QueryCustomer
type QueryCustomerRequest struct {
	*requests.RpcRequest
	AuthKey      string           `position:"Body" name:"AuthKey"`
	ReqTimestamp requests.Integer `position:"Body" name:"ReqTimestamp"`
	Product      *[]string        `position:"Body" name:"Product"  type:"Repeated"`
	AuthSign     string           `position:"Body" name:"AuthSign"`
	Type         string           `position:"Body" name:"Type"`
}

// QueryCustomerResponse is the response struct for api QueryCustomer
type QueryCustomerResponse struct {
	*responses.BaseResponse
	Success   bool       `json:"Success" xml:"Success"`
	Code      int        `json:"Code" xml:"Code"`
	Message   string     `json:"Message" xml:"Message"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateQueryCustomerRequest creates a request to invoke QueryCustomer API
func CreateQueryCustomerRequest() (request *QueryCustomerRequest) {
	request = &QueryCustomerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Safe", "2022-01-17", "QueryCustomer", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryCustomerResponse creates a response to parse from QueryCustomer response
func CreateQueryCustomerResponse() (response *QueryCustomerResponse) {
	response = &QueryCustomerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
