package sas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeEmgVulItem invokes the sas.DescribeEmgVulItem API synchronously
func (client *Client) DescribeEmgVulItem(request *DescribeEmgVulItemRequest) (response *DescribeEmgVulItemResponse, err error) {
	response = CreateDescribeEmgVulItemResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeEmgVulItemWithChan invokes the sas.DescribeEmgVulItem API asynchronously
func (client *Client) DescribeEmgVulItemWithChan(request *DescribeEmgVulItemRequest) (<-chan *DescribeEmgVulItemResponse, <-chan error) {
	responseChan := make(chan *DescribeEmgVulItemResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeEmgVulItem(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeEmgVulItemWithCallback invokes the sas.DescribeEmgVulItem API asynchronously
func (client *Client) DescribeEmgVulItemWithCallback(request *DescribeEmgVulItemRequest, callback func(response *DescribeEmgVulItemResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeEmgVulItemResponse
		var err error
		defer close(result)
		response, err = client.DescribeEmgVulItem(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeEmgVulItemRequest is the request struct for api DescribeEmgVulItem
type DescribeEmgVulItemRequest struct {
	*requests.RpcRequest
	ScanType    string           `position:"Query" name:"ScanType"`
	CheckType   requests.Integer `position:"Query" name:"CheckType"`
	SourceIp    string           `position:"Query" name:"SourceIp"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	CheckStatus string           `position:"Query" name:"CheckStatus"`
	Lang        string           `position:"Query" name:"Lang"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	VulName     string           `position:"Query" name:"VulName"`
	RiskStatus  string           `position:"Query" name:"RiskStatus"`
}

// DescribeEmgVulItemResponse is the response struct for api DescribeEmgVulItem
type DescribeEmgVulItemResponse struct {
	*responses.BaseResponse
	CurrentPage     int              `json:"CurrentPage" xml:"CurrentPage"`
	RequestId       string           `json:"RequestId" xml:"RequestId"`
	PageSize        int              `json:"PageSize" xml:"PageSize"`
	TotalCount      int              `json:"TotalCount" xml:"TotalCount"`
	GroupedVulItems []GroupedVulItem `json:"GroupedVulItems" xml:"GroupedVulItems"`
}

// CreateDescribeEmgVulItemRequest creates a request to invoke DescribeEmgVulItem API
func CreateDescribeEmgVulItemRequest() (request *DescribeEmgVulItemRequest) {
	request = &DescribeEmgVulItemRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Sas", "2018-12-03", "DescribeEmgVulItem", "sas", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeEmgVulItemResponse creates a response to parse from DescribeEmgVulItem response
func CreateDescribeEmgVulItemResponse() (response *DescribeEmgVulItemResponse) {
	response = &DescribeEmgVulItemResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
