package selectdb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CheckCreateDBInstance invokes the selectdb.CheckCreateDBInstance API synchronously
func (client *Client) CheckCreateDBInstance(request *CheckCreateDBInstanceRequest) (response *CheckCreateDBInstanceResponse, err error) {
	response = CreateCheckCreateDBInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// CheckCreateDBInstanceWithChan invokes the selectdb.CheckCreateDBInstance API asynchronously
func (client *Client) CheckCreateDBInstanceWithChan(request *CheckCreateDBInstanceRequest) (<-chan *CheckCreateDBInstanceResponse, <-chan error) {
	responseChan := make(chan *CheckCreateDBInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CheckCreateDBInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CheckCreateDBInstanceWithCallback invokes the selectdb.CheckCreateDBInstance API asynchronously
func (client *Client) CheckCreateDBInstanceWithCallback(request *CheckCreateDBInstanceRequest, callback func(response *CheckCreateDBInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CheckCreateDBInstanceResponse
		var err error
		defer close(result)
		response, err = client.CheckCreateDBInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CheckCreateDBInstanceRequest is the request struct for api CheckCreateDBInstance
type CheckCreateDBInstanceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId       requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken           string           `position:"Query" name:"ClientToken"`
	ConnectionString      string           `position:"Query" name:"ConnectionString"`
	EngineVersion         string           `position:"Query" name:"EngineVersion"`
	CacheSize             requests.Integer `position:"Query" name:"CacheSize"`
	ResourceGroupId       string           `position:"Query" name:"ResourceGroupId"`
	Engine                string           `position:"Query" name:"Engine"`
	DBInstanceDescription string           `position:"Query" name:"DBInstanceDescription"`
	Period                string           `position:"Query" name:"Period"`
	UsedTime              requests.Integer `position:"Query" name:"UsedTime"`
	DBInstanceClass       string           `position:"Query" name:"DBInstanceClass"`
	VSwitchId             string           `position:"Query" name:"VSwitchId"`
	SecurityIPList        string           `position:"Query" name:"SecurityIPList"`
	VpcId                 string           `position:"Query" name:"VpcId"`
	ZoneId                string           `position:"Query" name:"ZoneId"`
	ChargeType            string           `position:"Query" name:"ChargeType"`
}

// CheckCreateDBInstanceResponse is the response struct for api CheckCreateDBInstance
type CheckCreateDBInstanceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCheckCreateDBInstanceRequest creates a request to invoke CheckCreateDBInstance API
func CreateCheckCreateDBInstanceRequest() (request *CheckCreateDBInstanceRequest) {
	request = &CheckCreateDBInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("selectdb", "2023-05-22", "CheckCreateDBInstance", "", "")
	request.Method = requests.POST
	return
}

// CreateCheckCreateDBInstanceResponse creates a response to parse from CheckCreateDBInstance response
func CreateCheckCreateDBInstanceResponse() (response *CheckCreateDBInstanceResponse) {
	response = &CheckCreateDBInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
