package sophonsoar

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeNodeUsedInfos invokes the sophonsoar.DescribeNodeUsedInfos API synchronously
func (client *Client) DescribeNodeUsedInfos(request *DescribeNodeUsedInfosRequest) (response *DescribeNodeUsedInfosResponse, err error) {
	response = CreateDescribeNodeUsedInfosResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeNodeUsedInfosWithChan invokes the sophonsoar.DescribeNodeUsedInfos API asynchronously
func (client *Client) DescribeNodeUsedInfosWithChan(request *DescribeNodeUsedInfosRequest) (<-chan *DescribeNodeUsedInfosResponse, <-chan error) {
	responseChan := make(chan *DescribeNodeUsedInfosResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeNodeUsedInfos(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeNodeUsedInfosWithCallback invokes the sophonsoar.DescribeNodeUsedInfos API asynchronously
func (client *Client) DescribeNodeUsedInfosWithCallback(request *DescribeNodeUsedInfosRequest, callback func(response *DescribeNodeUsedInfosResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeNodeUsedInfosResponse
		var err error
		defer close(result)
		response, err = client.DescribeNodeUsedInfos(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeNodeUsedInfosRequest is the request struct for api DescribeNodeUsedInfos
type DescribeNodeUsedInfosRequest struct {
	*requests.RpcRequest
	RoleFor      string `position:"Query" name:"RoleFor"`
	NodeName     string `position:"Query" name:"NodeName"`
	PlaybookUuid string `position:"Query" name:"PlaybookUuid"`
	RoleType     string `position:"Query" name:"RoleType"`
	Lang         string `position:"Query" name:"Lang"`
}

// DescribeNodeUsedInfosResponse is the response struct for api DescribeNodeUsedInfos
type DescribeNodeUsedInfosResponse struct {
	*responses.BaseResponse
	RequestId     string `json:"RequestId" xml:"RequestId"`
	NodeUsedInfos string `json:"NodeUsedInfos" xml:"NodeUsedInfos"`
}

// CreateDescribeNodeUsedInfosRequest creates a request to invoke DescribeNodeUsedInfos API
func CreateDescribeNodeUsedInfosRequest() (request *DescribeNodeUsedInfosRequest) {
	request = &DescribeNodeUsedInfosRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("sophonsoar", "2022-07-28", "DescribeNodeUsedInfos", "", "")
	request.Method = requests.GET
	return
}

// CreateDescribeNodeUsedInfosResponse creates a response to parse from DescribeNodeUsedInfos response
func CreateDescribeNodeUsedInfosResponse() (response *DescribeNodeUsedInfosResponse) {
	response = &DescribeNodeUsedInfosResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
