package swas_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDatabaseInstanceDescription invokes the swas_open.ModifyDatabaseInstanceDescription API synchronously
func (client *Client) ModifyDatabaseInstanceDescription(request *ModifyDatabaseInstanceDescriptionRequest) (response *ModifyDatabaseInstanceDescriptionResponse, err error) {
	response = CreateModifyDatabaseInstanceDescriptionResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDatabaseInstanceDescriptionWithChan invokes the swas_open.ModifyDatabaseInstanceDescription API asynchronously
func (client *Client) ModifyDatabaseInstanceDescriptionWithChan(request *ModifyDatabaseInstanceDescriptionRequest) (<-chan *ModifyDatabaseInstanceDescriptionResponse, <-chan error) {
	responseChan := make(chan *ModifyDatabaseInstanceDescriptionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDatabaseInstanceDescription(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDatabaseInstanceDescriptionWithCallback invokes the swas_open.ModifyDatabaseInstanceDescription API asynchronously
func (client *Client) ModifyDatabaseInstanceDescriptionWithCallback(request *ModifyDatabaseInstanceDescriptionRequest, callback func(response *ModifyDatabaseInstanceDescriptionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDatabaseInstanceDescriptionResponse
		var err error
		defer close(result)
		response, err = client.ModifyDatabaseInstanceDescription(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDatabaseInstanceDescriptionRequest is the request struct for api ModifyDatabaseInstanceDescription
type ModifyDatabaseInstanceDescriptionRequest struct {
	*requests.RpcRequest
	ClientToken                 string `position:"Query" name:"ClientToken"`
	DatabaseInstanceId          string `position:"Query" name:"DatabaseInstanceId"`
	DatabaseInstanceDescription string `position:"Query" name:"DatabaseInstanceDescription"`
}

// ModifyDatabaseInstanceDescriptionResponse is the response struct for api ModifyDatabaseInstanceDescription
type ModifyDatabaseInstanceDescriptionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyDatabaseInstanceDescriptionRequest creates a request to invoke ModifyDatabaseInstanceDescription API
func CreateModifyDatabaseInstanceDescriptionRequest() (request *ModifyDatabaseInstanceDescriptionRequest) {
	request = &ModifyDatabaseInstanceDescriptionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("SWAS-OPEN", "2020-06-01", "ModifyDatabaseInstanceDescription", "SWAS-OPEN", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyDatabaseInstanceDescriptionResponse creates a response to parse from ModifyDatabaseInstanceDescription response
func CreateModifyDatabaseInstanceDescriptionResponse() (response *ModifyDatabaseInstanceDescriptionResponse) {
	response = &ModifyDatabaseInstanceDescriptionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
