package vcs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BindUser invokes the vcs.BindUser API synchronously
func (client *Client) BindUser(request *BindUserRequest) (response *BindUserResponse, err error) {
	response = CreateBindUserResponse()
	err = client.DoAction(request, response)
	return
}

// BindUserWithChan invokes the vcs.BindUser API asynchronously
func (client *Client) BindUserWithChan(request *BindUserRequest) (<-chan *BindUserResponse, <-chan error) {
	responseChan := make(chan *BindUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BindUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BindUserWithCallback invokes the vcs.BindUser API asynchronously
func (client *Client) BindUserWithCallback(request *BindUserRequest, callback func(response *BindUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BindUserResponse
		var err error
		defer close(result)
		response, err = client.BindUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BindUserRequest is the request struct for api BindUser
type BindUserRequest struct {
	*requests.RpcRequest
	IsvSubId     string           `position:"Body" name:"IsvSubId"`
	CorpId       string           `position:"Body" name:"CorpId"`
	UserId       requests.Integer `position:"Body" name:"UserId"`
	MatchingRate string           `position:"Body" name:"MatchingRate"`
	PersonId     string           `position:"Body" name:"PersonId"`
}

// BindUserResponse is the response struct for api BindUser
type BindUserResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Data      bool   `json:"Data" xml:"Data"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateBindUserRequest creates a request to invoke BindUser API
func CreateBindUserRequest() (request *BindUserRequest) {
	request = &BindUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vcs", "2020-05-15", "BindUser", "", "")
	request.Method = requests.POST
	return
}

// CreateBindUserResponse creates a response to parse from BindUser response
func CreateBindUserResponse() (response *BindUserResponse) {
	response = &BindUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
