package vcs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDeviceGroups invokes the vcs.ListDeviceGroups API synchronously
func (client *Client) ListDeviceGroups(request *ListDeviceGroupsRequest) (response *ListDeviceGroupsResponse, err error) {
	response = CreateListDeviceGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// ListDeviceGroupsWithChan invokes the vcs.ListDeviceGroups API asynchronously
func (client *Client) ListDeviceGroupsWithChan(request *ListDeviceGroupsRequest) (<-chan *ListDeviceGroupsResponse, <-chan error) {
	responseChan := make(chan *ListDeviceGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDeviceGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDeviceGroupsWithCallback invokes the vcs.ListDeviceGroups API asynchronously
func (client *Client) ListDeviceGroupsWithCallback(request *ListDeviceGroupsRequest, callback func(response *ListDeviceGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDeviceGroupsResponse
		var err error
		defer close(result)
		response, err = client.ListDeviceGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDeviceGroupsRequest is the request struct for api ListDeviceGroups
type ListDeviceGroupsRequest struct {
	*requests.RpcRequest
	IsPage         requests.Integer `position:"Body" name:"IsPage"`
	PageNum        requests.Integer `position:"Body" name:"PageNum"`
	CorpIdList     string           `position:"Body" name:"CorpIdList"`
	DeviceCodeList string           `position:"Body" name:"DeviceCodeList"`
	Name           string           `position:"Body" name:"Name"`
	PageSize       requests.Integer `position:"Body" name:"PageSize"`
	Group          string           `position:"Body" name:"Group"`
}

// ListDeviceGroupsResponse is the response struct for api ListDeviceGroups
type ListDeviceGroupsResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Code      string     `json:"Code" xml:"Code"`
	Message   string     `json:"Message" xml:"Message"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateListDeviceGroupsRequest creates a request to invoke ListDeviceGroups API
func CreateListDeviceGroupsRequest() (request *ListDeviceGroupsRequest) {
	request = &ListDeviceGroupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vcs", "2020-05-15", "ListDeviceGroups", "", "")
	request.Method = requests.POST
	return
}

// CreateListDeviceGroupsResponse creates a response to parse from ListDeviceGroups response
func CreateListDeviceGroupsResponse() (response *ListDeviceGroupsResponse) {
	response = &ListDeviceGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
