package voicenavigator

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeNavigationConfig invokes the voicenavigator.DescribeNavigationConfig API synchronously
func (client *Client) DescribeNavigationConfig(request *DescribeNavigationConfigRequest) (response *DescribeNavigationConfigResponse, err error) {
	response = CreateDescribeNavigationConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeNavigationConfigWithChan invokes the voicenavigator.DescribeNavigationConfig API asynchronously
func (client *Client) DescribeNavigationConfigWithChan(request *DescribeNavigationConfigRequest) (<-chan *DescribeNavigationConfigResponse, <-chan error) {
	responseChan := make(chan *DescribeNavigationConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeNavigationConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeNavigationConfigWithCallback invokes the voicenavigator.DescribeNavigationConfig API asynchronously
func (client *Client) DescribeNavigationConfigWithCallback(request *DescribeNavigationConfigRequest, callback func(response *DescribeNavigationConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeNavigationConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeNavigationConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeNavigationConfigRequest is the request struct for api DescribeNavigationConfig
type DescribeNavigationConfigRequest struct {
	*requests.RpcRequest
	InstanceId string `position:"Query" name:"InstanceId"`
}

// DescribeNavigationConfigResponse is the response struct for api DescribeNavigationConfig
type DescribeNavigationConfigResponse struct {
	*responses.BaseResponse
	RequestId            string               `json:"RequestId" xml:"RequestId"`
	RepeatingConfig      RepeatingConfig      `json:"RepeatingConfig" xml:"RepeatingConfig"`
	AskingBackConfig     AskingBackConfig     `json:"AskingBackConfig" xml:"AskingBackConfig"`
	SilenceTimeoutConfig SilenceTimeoutConfig `json:"SilenceTimeoutConfig" xml:"SilenceTimeoutConfig"`
	GreetingConfig       GreetingConfig       `json:"GreetingConfig" xml:"GreetingConfig"`
	UnrecognizingConfig  UnrecognizingConfig  `json:"UnrecognizingConfig" xml:"UnrecognizingConfig"`
	ComplainingConfig    ComplainingConfig    `json:"ComplainingConfig" xml:"ComplainingConfig"`
}

// CreateDescribeNavigationConfigRequest creates a request to invoke DescribeNavigationConfig API
func CreateDescribeNavigationConfigRequest() (request *DescribeNavigationConfigRequest) {
	request = &DescribeNavigationConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("VoiceNavigator", "2018-06-12", "DescribeNavigationConfig", "voicebot", "openAPI")
	request.Method = requests.GET
	return
}

// CreateDescribeNavigationConfigResponse creates a response to parse from DescribeNavigationConfig response
func CreateDescribeNavigationConfigResponse() (response *DescribeNavigationConfigResponse) {
	response = &DescribeNavigationConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
