package xtrace

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetTagVal invokes the xtrace.GetTagVal API synchronously
func (client *Client) GetTagVal(request *GetTagValRequest) (response *GetTagValResponse, err error) {
	response = CreateGetTagValResponse()
	err = client.DoAction(request, response)
	return
}

// GetTagValWithChan invokes the xtrace.GetTagVal API asynchronously
func (client *Client) GetTagValWithChan(request *GetTagValRequest) (<-chan *GetTagValResponse, <-chan error) {
	responseChan := make(chan *GetTagValResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetTagVal(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetTagValWithCallback invokes the xtrace.GetTagVal API asynchronously
func (client *Client) GetTagValWithCallback(request *GetTagValRequest, callback func(response *GetTagValResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetTagValResponse
		var err error
		defer close(result)
		response, err = client.GetTagVal(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetTagValRequest is the request struct for api GetTagVal
type GetTagValRequest struct {
	*requests.RpcRequest
	EndTime     requests.Integer `position:"Query" name:"EndTime"`
	ServiceName string           `position:"Query" name:"ServiceName"`
	StartTime   requests.Integer `position:"Query" name:"StartTime"`
	TagKey      string           `position:"Query" name:"TagKey"`
	SpanName    string           `position:"Query" name:"SpanName"`
}

// GetTagValResponse is the response struct for api GetTagVal
type GetTagValResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	TagValues TagValues `json:"TagValues" xml:"TagValues"`
}

// CreateGetTagValRequest creates a request to invoke GetTagVal API
func CreateGetTagValRequest() (request *GetTagValRequest) {
	request = &GetTagValRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("xtrace", "2019-08-08", "GetTagVal", "", "")
	request.Method = requests.POST
	return
}

// CreateGetTagValResponse creates a response to parse from GetTagVal response
func CreateGetTagValResponse() (response *GetTagValResponse) {
	response = &GetTagValResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
