// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package ssmsapiface provides an interface to enable mocking the AWS Systems Manager for SAP service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package ssmsapiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/ssmsap"
)

// SsmSapAPI provides an interface to enable mocking the
// ssmsap.SsmSap service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// AWS Systems Manager for SAP.
//	func myFunc(svc ssmsapiface.SsmSapAPI) bool {
//	    // Make svc.DeleteResourcePermission request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := ssmsap.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockSsmSapClient struct {
//	    ssmsapiface.SsmSapAPI
//	}
//	func (m *mockSsmSapClient) DeleteResourcePermission(input *ssmsap.DeleteResourcePermissionInput) (*ssmsap.DeleteResourcePermissionOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockSsmSapClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type SsmSapAPI interface {
	DeleteResourcePermission(*ssmsap.DeleteResourcePermissionInput) (*ssmsap.DeleteResourcePermissionOutput, error)
	DeleteResourcePermissionWithContext(aws.Context, *ssmsap.DeleteResourcePermissionInput, ...request.Option) (*ssmsap.DeleteResourcePermissionOutput, error)
	DeleteResourcePermissionRequest(*ssmsap.DeleteResourcePermissionInput) (*request.Request, *ssmsap.DeleteResourcePermissionOutput)

	DeregisterApplication(*ssmsap.DeregisterApplicationInput) (*ssmsap.DeregisterApplicationOutput, error)
	DeregisterApplicationWithContext(aws.Context, *ssmsap.DeregisterApplicationInput, ...request.Option) (*ssmsap.DeregisterApplicationOutput, error)
	DeregisterApplicationRequest(*ssmsap.DeregisterApplicationInput) (*request.Request, *ssmsap.DeregisterApplicationOutput)

	GetApplication(*ssmsap.GetApplicationInput) (*ssmsap.GetApplicationOutput, error)
	GetApplicationWithContext(aws.Context, *ssmsap.GetApplicationInput, ...request.Option) (*ssmsap.GetApplicationOutput, error)
	GetApplicationRequest(*ssmsap.GetApplicationInput) (*request.Request, *ssmsap.GetApplicationOutput)

	GetComponent(*ssmsap.GetComponentInput) (*ssmsap.GetComponentOutput, error)
	GetComponentWithContext(aws.Context, *ssmsap.GetComponentInput, ...request.Option) (*ssmsap.GetComponentOutput, error)
	GetComponentRequest(*ssmsap.GetComponentInput) (*request.Request, *ssmsap.GetComponentOutput)

	GetDatabase(*ssmsap.GetDatabaseInput) (*ssmsap.GetDatabaseOutput, error)
	GetDatabaseWithContext(aws.Context, *ssmsap.GetDatabaseInput, ...request.Option) (*ssmsap.GetDatabaseOutput, error)
	GetDatabaseRequest(*ssmsap.GetDatabaseInput) (*request.Request, *ssmsap.GetDatabaseOutput)

	GetOperation(*ssmsap.GetOperationInput) (*ssmsap.GetOperationOutput, error)
	GetOperationWithContext(aws.Context, *ssmsap.GetOperationInput, ...request.Option) (*ssmsap.GetOperationOutput, error)
	GetOperationRequest(*ssmsap.GetOperationInput) (*request.Request, *ssmsap.GetOperationOutput)

	GetResourcePermission(*ssmsap.GetResourcePermissionInput) (*ssmsap.GetResourcePermissionOutput, error)
	GetResourcePermissionWithContext(aws.Context, *ssmsap.GetResourcePermissionInput, ...request.Option) (*ssmsap.GetResourcePermissionOutput, error)
	GetResourcePermissionRequest(*ssmsap.GetResourcePermissionInput) (*request.Request, *ssmsap.GetResourcePermissionOutput)

	ListApplications(*ssmsap.ListApplicationsInput) (*ssmsap.ListApplicationsOutput, error)
	ListApplicationsWithContext(aws.Context, *ssmsap.ListApplicationsInput, ...request.Option) (*ssmsap.ListApplicationsOutput, error)
	ListApplicationsRequest(*ssmsap.ListApplicationsInput) (*request.Request, *ssmsap.ListApplicationsOutput)

	ListApplicationsPages(*ssmsap.ListApplicationsInput, func(*ssmsap.ListApplicationsOutput, bool) bool) error
	ListApplicationsPagesWithContext(aws.Context, *ssmsap.ListApplicationsInput, func(*ssmsap.ListApplicationsOutput, bool) bool, ...request.Option) error

	ListComponents(*ssmsap.ListComponentsInput) (*ssmsap.ListComponentsOutput, error)
	ListComponentsWithContext(aws.Context, *ssmsap.ListComponentsInput, ...request.Option) (*ssmsap.ListComponentsOutput, error)
	ListComponentsRequest(*ssmsap.ListComponentsInput) (*request.Request, *ssmsap.ListComponentsOutput)

	ListComponentsPages(*ssmsap.ListComponentsInput, func(*ssmsap.ListComponentsOutput, bool) bool) error
	ListComponentsPagesWithContext(aws.Context, *ssmsap.ListComponentsInput, func(*ssmsap.ListComponentsOutput, bool) bool, ...request.Option) error

	ListDatabases(*ssmsap.ListDatabasesInput) (*ssmsap.ListDatabasesOutput, error)
	ListDatabasesWithContext(aws.Context, *ssmsap.ListDatabasesInput, ...request.Option) (*ssmsap.ListDatabasesOutput, error)
	ListDatabasesRequest(*ssmsap.ListDatabasesInput) (*request.Request, *ssmsap.ListDatabasesOutput)

	ListDatabasesPages(*ssmsap.ListDatabasesInput, func(*ssmsap.ListDatabasesOutput, bool) bool) error
	ListDatabasesPagesWithContext(aws.Context, *ssmsap.ListDatabasesInput, func(*ssmsap.ListDatabasesOutput, bool) bool, ...request.Option) error

	ListOperations(*ssmsap.ListOperationsInput) (*ssmsap.ListOperationsOutput, error)
	ListOperationsWithContext(aws.Context, *ssmsap.ListOperationsInput, ...request.Option) (*ssmsap.ListOperationsOutput, error)
	ListOperationsRequest(*ssmsap.ListOperationsInput) (*request.Request, *ssmsap.ListOperationsOutput)

	ListOperationsPages(*ssmsap.ListOperationsInput, func(*ssmsap.ListOperationsOutput, bool) bool) error
	ListOperationsPagesWithContext(aws.Context, *ssmsap.ListOperationsInput, func(*ssmsap.ListOperationsOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*ssmsap.ListTagsForResourceInput) (*ssmsap.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *ssmsap.ListTagsForResourceInput, ...request.Option) (*ssmsap.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*ssmsap.ListTagsForResourceInput) (*request.Request, *ssmsap.ListTagsForResourceOutput)

	PutResourcePermission(*ssmsap.PutResourcePermissionInput) (*ssmsap.PutResourcePermissionOutput, error)
	PutResourcePermissionWithContext(aws.Context, *ssmsap.PutResourcePermissionInput, ...request.Option) (*ssmsap.PutResourcePermissionOutput, error)
	PutResourcePermissionRequest(*ssmsap.PutResourcePermissionInput) (*request.Request, *ssmsap.PutResourcePermissionOutput)

	RegisterApplication(*ssmsap.RegisterApplicationInput) (*ssmsap.RegisterApplicationOutput, error)
	RegisterApplicationWithContext(aws.Context, *ssmsap.RegisterApplicationInput, ...request.Option) (*ssmsap.RegisterApplicationOutput, error)
	RegisterApplicationRequest(*ssmsap.RegisterApplicationInput) (*request.Request, *ssmsap.RegisterApplicationOutput)

	StartApplicationRefresh(*ssmsap.StartApplicationRefreshInput) (*ssmsap.StartApplicationRefreshOutput, error)
	StartApplicationRefreshWithContext(aws.Context, *ssmsap.StartApplicationRefreshInput, ...request.Option) (*ssmsap.StartApplicationRefreshOutput, error)
	StartApplicationRefreshRequest(*ssmsap.StartApplicationRefreshInput) (*request.Request, *ssmsap.StartApplicationRefreshOutput)

	TagResource(*ssmsap.TagResourceInput) (*ssmsap.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *ssmsap.TagResourceInput, ...request.Option) (*ssmsap.TagResourceOutput, error)
	TagResourceRequest(*ssmsap.TagResourceInput) (*request.Request, *ssmsap.TagResourceOutput)

	UntagResource(*ssmsap.UntagResourceInput) (*ssmsap.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *ssmsap.UntagResourceInput, ...request.Option) (*ssmsap.UntagResourceOutput, error)
	UntagResourceRequest(*ssmsap.UntagResourceInput) (*request.Request, *ssmsap.UntagResourceOutput)

	UpdateApplicationSettings(*ssmsap.UpdateApplicationSettingsInput) (*ssmsap.UpdateApplicationSettingsOutput, error)
	UpdateApplicationSettingsWithContext(aws.Context, *ssmsap.UpdateApplicationSettingsInput, ...request.Option) (*ssmsap.UpdateApplicationSettingsOutput, error)
	UpdateApplicationSettingsRequest(*ssmsap.UpdateApplicationSettingsInput) (*request.Request, *ssmsap.UpdateApplicationSettingsOutput)
}

var _ SsmSapAPI = (*ssmsap.SsmSap)(nil)
