// Package swagger Code generated by swaggo/swag. DO NOT EDIT
package swagger

import "github.com/swaggo/swag"

const docTemplate = `{
    "schemes": {{ marshal .Schemes }},
    "swagger": "2.0",
    "info": {
        "description": "{{escape .Description}}",
        "title": "{{.Title}}",
        "contact": {},
        "version": "{{.Version}}"
    },
    "host": "{{.Host}}",
    "basePath": "{{.BasePath}}",
    "paths": {
        "/api/v1/accounts": {
            "get": {
                "description": "List accounts",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "accounts"
                ],
                "summary": "List accounts",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/model.AccountDTO"
                            }
                        }
                    },
                    "500": {
                        "description": "Internal Server Error",
                        "schema": {
                            "type": "string"
                        }
                    }
                }
            },
            "post": {
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "accounts"
                ],
                "summary": "Create an account",
                "responses": {
                    "201": {
                        "description": "Created",
                        "schema": {
                            "$ref": "#/definitions/model.AccountDTO"
                        }
                    },
                    "400": {
                        "description": "Bad Request"
                    },
                    "409": {
                        "description": "Account already exists"
                    },
                    "500": {
                        "description": "Internal Server Error"
                    }
                }
            }
        },
        "/api/v1/accounts/{id}": {
            "delete": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "accounts"
                ],
                "summary": "Delete an account",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "Account ID",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No content"
                    },
                    "400": {
                        "description": "Invalid ID"
                    },
                    "404": {
                        "description": "Account not found"
                    },
                    "500": {
                        "description": "Internal Server Error"
                    }
                }
            },
            "patch": {
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "accounts"
                ],
                "summary": "Update an account",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "Account ID",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Account data",
                        "name": "account",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/api_v1.updateAccountPayload"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/model.AccountDTO"
                        }
                    },
                    "400": {
                        "description": "Invalid ID/data"
                    },
                    "404": {
                        "description": "Account not found"
                    },
                    "409": {
                        "description": "Account already exists"
                    },
                    "500": {
                        "description": "Internal Server Error"
                    }
                }
            }
        },
        "/api/v1/auth/account": {
            "patch": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Auth"
                ],
                "summary": "Update account information",
                "parameters": [
                    {
                        "description": "Account data",
                        "name": "payload",
                        "in": "body",
                        "schema": {
                            "$ref": "#/definitions/api_v1.updateAccountPayload"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/model.Account"
                        }
                    },
                    "403": {
                        "description": "Token not provided/invalid"
                    }
                }
            }
        },
        "/api/v1/auth/login": {
            "post": {
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Auth"
                ],
                "summary": "Login to an account using username and password",
                "parameters": [
                    {
                        "description": "Login data",
                        "name": "payload",
                        "in": "body",
                        "schema": {
                            "$ref": "#/definitions/api_v1.loginRequestPayload"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "Login successful",
                        "schema": {
                            "$ref": "#/definitions/api_v1.loginResponseMessage"
                        }
                    },
                    "400": {
                        "description": "Invalid login data"
                    }
                }
            }
        },
        "/api/v1/auth/logout": {
            "post": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Auth"
                ],
                "summary": "Logout from the current session",
                "responses": {
                    "200": {
                        "description": "Logout successful"
                    },
                    "403": {
                        "description": "Token not provided/invalid"
                    }
                }
            }
        },
        "/api/v1/auth/me": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Auth"
                ],
                "summary": "Get information for the current logged in user",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/model.Account"
                        }
                    },
                    "403": {
                        "description": "Token not provided/invalid"
                    }
                }
            }
        },
        "/api/v1/auth/refresh": {
            "post": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Auth"
                ],
                "summary": "Refresh a token for an account",
                "responses": {
                    "200": {
                        "description": "Refresh successful",
                        "schema": {
                            "$ref": "#/definitions/api_v1.loginResponseMessage"
                        }
                    },
                    "403": {
                        "description": "Token not provided/invalid"
                    }
                }
            }
        },
        "/api/v1/bookmarks/bulk/tags": {
            "put": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Auth"
                ],
                "summary": "Bulk update tags for multiple bookmarks.",
                "parameters": [
                    {
                        "description": "Bulk Update Bookmark Tags Payload",
                        "name": "payload",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/api_v1.bulkUpdateBookmarkTagsPayload"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/model.BookmarkDTO"
                            }
                        }
                    },
                    "400": {
                        "description": "Invalid request payload"
                    },
                    "403": {
                        "description": "Token not provided/invalid"
                    },
                    "404": {
                        "description": "No bookmarks found"
                    }
                }
            }
        },
        "/api/v1/bookmarks/cache": {
            "put": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Auth"
                ],
                "summary": "Update Cache and Ebook on server.",
                "parameters": [
                    {
                        "description": "Update Cache Payload",
                        "name": "payload",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/api_v1.updateCachePayload"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/model.BookmarkDTO"
                        }
                    },
                    "403": {
                        "description": "Token not provided/invalid"
                    }
                }
            }
        },
        "/api/v1/bookmarks/id/readable": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Auth"
                ],
                "summary": "Get readable version of bookmark.",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/api_v1.readableResponseMessage"
                        }
                    },
                    "403": {
                        "description": "Token not provided/invalid"
                    }
                }
            }
        },
        "/api/v1/bookmarks/{id}/tags": {
            "get": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Auth"
                ],
                "summary": "Get tags for a bookmark.",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "Bookmark ID",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/model.TagDTO"
                            }
                        }
                    },
                    "403": {
                        "description": "Token not provided/invalid"
                    },
                    "404": {
                        "description": "Bookmark not found"
                    }
                }
            },
            "post": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Auth"
                ],
                "summary": "Add a tag to a bookmark.",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "Bookmark ID",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Add Tag Payload",
                        "name": "payload",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/api_v1.bookmarkTagPayload"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    },
                    "403": {
                        "description": "Token not provided/invalid"
                    },
                    "404": {
                        "description": "Bookmark or tag not found"
                    }
                }
            },
            "delete": {
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Auth"
                ],
                "summary": "Remove a tag from a bookmark.",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "Bookmark ID",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Remove Tag Payload",
                        "name": "payload",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/api_v1.bookmarkTagPayload"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK"
                    },
                    "403": {
                        "description": "Token not provided/invalid"
                    },
                    "404": {
                        "description": "Bookmark not found"
                    }
                }
            }
        },
        "/api/v1/system/info": {
            "get": {
                "description": "Get general system information like Shiori version, database, and OS",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "System"
                ],
                "summary": "Get general system information",
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/api_v1.infoResponse"
                        }
                    },
                    "403": {
                        "description": "Only owners can access this endpoint"
                    }
                }
            }
        },
        "/api/v1/tags": {
            "get": {
                "description": "List all tags",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Tags"
                ],
                "summary": "List tags",
                "parameters": [
                    {
                        "type": "boolean",
                        "description": "Include bookmark count for each tag",
                        "name": "with_bookmark_count",
                        "in": "query"
                    },
                    {
                        "type": "integer",
                        "description": "Filter tags by bookmark ID",
                        "name": "bookmark_id",
                        "in": "query"
                    },
                    {
                        "type": "string",
                        "description": "Search tags by name",
                        "name": "search",
                        "in": "query"
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "type": "array",
                            "items": {
                                "$ref": "#/definitions/model.TagDTO"
                            }
                        }
                    },
                    "403": {
                        "description": "Authentication required"
                    },
                    "500": {
                        "description": "Internal server error"
                    }
                }
            },
            "post": {
                "description": "Create a new tag",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Tags"
                ],
                "summary": "Create tag",
                "parameters": [
                    {
                        "description": "Tag data",
                        "name": "tag",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/model.TagDTO"
                        }
                    }
                ],
                "responses": {
                    "201": {
                        "description": "Created",
                        "schema": {
                            "$ref": "#/definitions/model.TagDTO"
                        }
                    },
                    "400": {
                        "description": "Invalid request"
                    },
                    "403": {
                        "description": "Authentication required"
                    },
                    "500": {
                        "description": "Internal server error"
                    }
                }
            }
        },
        "/api/v1/tags/{id}": {
            "get": {
                "description": "Get a tag by ID",
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Tags"
                ],
                "summary": "Get tag",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "Tag ID",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/model.TagDTO"
                        }
                    },
                    "403": {
                        "description": "Authentication required"
                    },
                    "404": {
                        "description": "Tag not found"
                    },
                    "500": {
                        "description": "Internal server error"
                    }
                }
            },
            "put": {
                "description": "Update an existing tag",
                "consumes": [
                    "application/json"
                ],
                "produces": [
                    "application/json"
                ],
                "tags": [
                    "Tags"
                ],
                "summary": "Update tag",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "Tag ID",
                        "name": "id",
                        "in": "path",
                        "required": true
                    },
                    {
                        "description": "Tag data",
                        "name": "tag",
                        "in": "body",
                        "required": true,
                        "schema": {
                            "$ref": "#/definitions/model.TagDTO"
                        }
                    }
                ],
                "responses": {
                    "200": {
                        "description": "OK",
                        "schema": {
                            "$ref": "#/definitions/model.TagDTO"
                        }
                    },
                    "400": {
                        "description": "Invalid request"
                    },
                    "403": {
                        "description": "Authentication required"
                    },
                    "404": {
                        "description": "Tag not found"
                    },
                    "500": {
                        "description": "Internal server error"
                    }
                }
            },
            "delete": {
                "description": "Delete a tag",
                "tags": [
                    "Tags"
                ],
                "summary": "Delete tag",
                "parameters": [
                    {
                        "type": "integer",
                        "description": "Tag ID",
                        "name": "id",
                        "in": "path",
                        "required": true
                    }
                ],
                "responses": {
                    "204": {
                        "description": "No Content"
                    },
                    "403": {
                        "description": "Authentication required"
                    },
                    "404": {
                        "description": "Tag not found"
                    },
                    "500": {
                        "description": "Internal server error"
                    }
                }
            }
        }
    },
    "definitions": {
        "api_v1.bookmarkTagPayload": {
            "type": "object",
            "required": [
                "tag_id"
            ],
            "properties": {
                "tag_id": {
                    "type": "integer"
                }
            }
        },
        "api_v1.bulkUpdateBookmarkTagsPayload": {
            "type": "object",
            "required": [
                "bookmark_ids",
                "tag_ids"
            ],
            "properties": {
                "bookmark_ids": {
                    "type": "array",
                    "items": {
                        "type": "integer"
                    }
                },
                "tag_ids": {
                    "type": "array",
                    "items": {
                        "type": "integer"
                    }
                }
            }
        },
        "api_v1.infoResponse": {
            "type": "object",
            "properties": {
                "database": {
                    "type": "string"
                },
                "os": {
                    "type": "string"
                },
                "version": {
                    "type": "object",
                    "properties": {
                        "commit": {
                            "type": "string"
                        },
                        "date": {
                            "type": "string"
                        },
                        "tag": {
                            "type": "string"
                        }
                    }
                }
            }
        },
        "api_v1.loginRequestPayload": {
            "type": "object",
            "properties": {
                "password": {
                    "type": "string"
                },
                "remember_me": {
                    "type": "boolean"
                },
                "username": {
                    "type": "string"
                }
            }
        },
        "api_v1.loginResponseMessage": {
            "type": "object",
            "properties": {
                "expires": {
                    "type": "integer"
                },
                "token": {
                    "type": "string"
                }
            }
        },
        "api_v1.readableResponseMessage": {
            "type": "object",
            "properties": {
                "content": {
                    "type": "string"
                },
                "html": {
                    "type": "string"
                }
            }
        },
        "api_v1.updateAccountPayload": {
            "type": "object",
            "properties": {
                "config": {
                    "$ref": "#/definitions/model.UserConfig"
                },
                "new_password": {
                    "type": "string"
                },
                "old_password": {
                    "type": "string"
                },
                "owner": {
                    "type": "boolean"
                },
                "username": {
                    "type": "string"
                }
            }
        },
        "api_v1.updateCachePayload": {
            "type": "object",
            "required": [
                "ids"
            ],
            "properties": {
                "create_archive": {
                    "type": "boolean"
                },
                "create_ebook": {
                    "type": "boolean"
                },
                "ids": {
                    "type": "array",
                    "items": {
                        "type": "integer"
                    }
                },
                "keep_metadata": {
                    "type": "boolean"
                },
                "skip_exist": {
                    "type": "boolean"
                }
            }
        },
        "model.Account": {
            "type": "object",
            "properties": {
                "config": {
                    "$ref": "#/definitions/model.UserConfig"
                },
                "id": {
                    "type": "integer"
                },
                "owner": {
                    "type": "boolean"
                },
                "password": {
                    "type": "string"
                },
                "username": {
                    "type": "string"
                }
            }
        },
        "model.AccountDTO": {
            "type": "object",
            "properties": {
                "config": {
                    "$ref": "#/definitions/model.UserConfig"
                },
                "id": {
                    "type": "integer"
                },
                "owner": {
                    "type": "boolean"
                },
                "passowrd": {
                    "description": "Used only to store, not to retrieve",
                    "type": "string"
                },
                "username": {
                    "type": "string"
                }
            }
        },
        "model.BookmarkDTO": {
            "type": "object",
            "properties": {
                "author": {
                    "type": "string"
                },
                "create_archive": {
                    "description": "TODO: migrate outside the DTO",
                    "type": "boolean"
                },
                "create_ebook": {
                    "description": "TODO: migrate outside the DTO",
                    "type": "boolean"
                },
                "createdAt": {
                    "type": "string"
                },
                "excerpt": {
                    "type": "string"
                },
                "hasArchive": {
                    "type": "boolean"
                },
                "hasContent": {
                    "type": "boolean"
                },
                "hasEbook": {
                    "type": "boolean"
                },
                "html": {
                    "type": "string"
                },
                "id": {
                    "type": "integer"
                },
                "imageURL": {
                    "type": "string"
                },
                "modifiedAt": {
                    "type": "string"
                },
                "public": {
                    "type": "integer"
                },
                "tags": {
                    "type": "array",
                    "items": {
                        "$ref": "#/definitions/model.TagDTO"
                    }
                },
                "title": {
                    "type": "string"
                },
                "url": {
                    "type": "string"
                }
            }
        },
        "model.TagDTO": {
            "type": "object",
            "properties": {
                "bookmark_count": {
                    "description": "Number of bookmarks with this tag",
                    "type": "integer"
                },
                "deleted": {
                    "description": "Marks when a tag is deleted from a bookmark",
                    "type": "boolean"
                },
                "id": {
                    "type": "integer"
                },
                "name": {
                    "type": "string"
                }
            }
        },
        "model.UserConfig": {
            "type": "object",
            "properties": {
                "createEbook": {
                    "type": "boolean"
                },
                "hideExcerpt": {
                    "type": "boolean"
                },
                "hideThumbnail": {
                    "type": "boolean"
                },
                "keepMetadata": {
                    "type": "boolean"
                },
                "listMode": {
                    "type": "boolean"
                },
                "makePublic": {
                    "type": "boolean"
                },
                "showId": {
                    "type": "boolean"
                },
                "theme": {
                    "type": "string"
                },
                "useArchive": {
                    "type": "boolean"
                }
            }
        }
    }
}`

// SwaggerInfo holds exported Swagger Info so clients can modify it
var SwaggerInfo = &swag.Spec{
	Version:          "",
	Host:             "",
	BasePath:         "",
	Schemes:          []string{},
	Title:            "",
	Description:      "",
	InfoInstanceName: "swagger",
	SwaggerTemplate:  docTemplate,
	LeftDelim:        "{{",
	RightDelim:       "}}",
}

func init() {
	swag.Register(SwaggerInfo.InstanceName(), SwaggerInfo)
}
