/* SPDX-License-Identifier: GPL-2.0-only */

#include <memlayout.h>
#include <soc/addressmap.h>
#include <arch/header.ld>

SECTIONS
{
	DRAM_START(0x00000000)
	/* Secure region 0 - 1MiB */
	BL31(0, 0xe0000)
	REGION(sff8104, 0xe0000, 0x20000, 0x1000)

	/* Insecure region 1MiB - TOP OF DRAM */
	/* bootblock-custom.S does setup CAR from SRAM_START to SRAM_END */
	SRAM_START(BOOTROM_OFFSET)

	STACK(BOOTROM_OFFSET, 16K)
	TIMESTAMP(BOOTROM_OFFSET + 0x4000, 4K)
	PRERAM_CBFS_CACHE(BOOTROM_OFFSET + 0x6000, 6K)
	FMAP_CACHE(BOOTROM_OFFSET + 0x7800, 2K)
	PRERAM_CBMEM_CONSOLE(BOOTROM_OFFSET + 0x8000, 8K)
	BOOTBLOCK(BOOTROM_OFFSET + 0x20000, 56K)
	CBFS_MCACHE(BOOTROM_OFFSET + 0x2e000, 8K)
	VBOOT2_WORK(BOOTROM_OFFSET + 0x30000, 12K)
	TPM_LOG(BOOTROM_OFFSET + 0x33000, 2K)
	VERSTAGE(BOOTROM_OFFSET + 0x33800, 50K)
	ROMSTAGE(BOOTROM_OFFSET + 0x40000, 256K)

	SRAM_END(BOOTROM_OFFSET + 0x80000)

	TTB(BOOTROM_OFFSET + 0x80000, 512K)
	RAMSTAGE(BOOTROM_OFFSET + 0x100000, 512K)
	/* Stack for secondary CPUs */
	REGION(stack_sec, BOOTROM_OFFSET + 0x180000,
	       CONFIG_MAX_CPUS * CONFIG_STACK_SIZE, 0x1000)

	/* Leave some space for the payload */
	POSTRAM_CBFS_CACHE(0x2000000, 16M)
}
