// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/kms/inventory/v1/key_tracking_service.proto

package inventorypb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	KeyTrackingService_GetProtectedResourcesSummary_FullMethodName = "/google.cloud.kms.inventory.v1.KeyTrackingService/GetProtectedResourcesSummary"
	KeyTrackingService_SearchProtectedResources_FullMethodName     = "/google.cloud.kms.inventory.v1.KeyTrackingService/SearchProtectedResources"
)

// KeyTrackingServiceClient is the client API for KeyTrackingService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type KeyTrackingServiceClient interface {
	// Returns aggregate information about the resources protected by the given
	// Cloud KMS [CryptoKey][google.cloud.kms.v1.CryptoKey]. Only resources within
	// the same Cloud organization as the key will be returned. The project that
	// holds the key must be part of an organization in order for this call to
	// succeed.
	GetProtectedResourcesSummary(ctx context.Context, in *GetProtectedResourcesSummaryRequest, opts ...grpc.CallOption) (*ProtectedResourcesSummary, error)
	// Returns metadata about the resources protected by the given Cloud KMS
	// [CryptoKey][google.cloud.kms.v1.CryptoKey] in the given Cloud organization.
	SearchProtectedResources(ctx context.Context, in *SearchProtectedResourcesRequest, opts ...grpc.CallOption) (*SearchProtectedResourcesResponse, error)
}

type keyTrackingServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewKeyTrackingServiceClient(cc grpc.ClientConnInterface) KeyTrackingServiceClient {
	return &keyTrackingServiceClient{cc}
}

func (c *keyTrackingServiceClient) GetProtectedResourcesSummary(ctx context.Context, in *GetProtectedResourcesSummaryRequest, opts ...grpc.CallOption) (*ProtectedResourcesSummary, error) {
	out := new(ProtectedResourcesSummary)
	err := c.cc.Invoke(ctx, KeyTrackingService_GetProtectedResourcesSummary_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *keyTrackingServiceClient) SearchProtectedResources(ctx context.Context, in *SearchProtectedResourcesRequest, opts ...grpc.CallOption) (*SearchProtectedResourcesResponse, error) {
	out := new(SearchProtectedResourcesResponse)
	err := c.cc.Invoke(ctx, KeyTrackingService_SearchProtectedResources_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// KeyTrackingServiceServer is the server API for KeyTrackingService service.
// All implementations should embed UnimplementedKeyTrackingServiceServer
// for forward compatibility
type KeyTrackingServiceServer interface {
	// Returns aggregate information about the resources protected by the given
	// Cloud KMS [CryptoKey][google.cloud.kms.v1.CryptoKey]. Only resources within
	// the same Cloud organization as the key will be returned. The project that
	// holds the key must be part of an organization in order for this call to
	// succeed.
	GetProtectedResourcesSummary(context.Context, *GetProtectedResourcesSummaryRequest) (*ProtectedResourcesSummary, error)
	// Returns metadata about the resources protected by the given Cloud KMS
	// [CryptoKey][google.cloud.kms.v1.CryptoKey] in the given Cloud organization.
	SearchProtectedResources(context.Context, *SearchProtectedResourcesRequest) (*SearchProtectedResourcesResponse, error)
}

// UnimplementedKeyTrackingServiceServer should be embedded to have forward compatible implementations.
type UnimplementedKeyTrackingServiceServer struct {
}

func (UnimplementedKeyTrackingServiceServer) GetProtectedResourcesSummary(context.Context, *GetProtectedResourcesSummaryRequest) (*ProtectedResourcesSummary, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetProtectedResourcesSummary not implemented")
}
func (UnimplementedKeyTrackingServiceServer) SearchProtectedResources(context.Context, *SearchProtectedResourcesRequest) (*SearchProtectedResourcesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchProtectedResources not implemented")
}

// UnsafeKeyTrackingServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to KeyTrackingServiceServer will
// result in compilation errors.
type UnsafeKeyTrackingServiceServer interface {
	mustEmbedUnimplementedKeyTrackingServiceServer()
}

func RegisterKeyTrackingServiceServer(s grpc.ServiceRegistrar, srv KeyTrackingServiceServer) {
	s.RegisterService(&KeyTrackingService_ServiceDesc, srv)
}

func _KeyTrackingService_GetProtectedResourcesSummary_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetProtectedResourcesSummaryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyTrackingServiceServer).GetProtectedResourcesSummary(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: KeyTrackingService_GetProtectedResourcesSummary_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyTrackingServiceServer).GetProtectedResourcesSummary(ctx, req.(*GetProtectedResourcesSummaryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _KeyTrackingService_SearchProtectedResources_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchProtectedResourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(KeyTrackingServiceServer).SearchProtectedResources(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: KeyTrackingService_SearchProtectedResources_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(KeyTrackingServiceServer).SearchProtectedResources(ctx, req.(*SearchProtectedResourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// KeyTrackingService_ServiceDesc is the grpc.ServiceDesc for KeyTrackingService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var KeyTrackingService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.kms.inventory.v1.KeyTrackingService",
	HandlerType: (*KeyTrackingServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetProtectedResourcesSummary",
			Handler:    _KeyTrackingService_GetProtectedResourcesSummary_Handler,
		},
		{
			MethodName: "SearchProtectedResources",
			Handler:    _KeyTrackingService_SearchProtectedResources_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/kms/inventory/v1/key_tracking_service.proto",
}
