// Copyright 2018 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.31.0
// 	protoc        v4.25.1
// source: fswalker.proto

package fswalker

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Indicator for the severity of the notification.
type Notification_Severity int32

const (
	Notification_UNKNOWN Notification_Severity = 0
	Notification_INFO    Notification_Severity = 1
	Notification_WARNING Notification_Severity = 2
	Notification_ERROR   Notification_Severity = 3
)

// Enum value maps for Notification_Severity.
var (
	Notification_Severity_name = map[int32]string{
		0: "UNKNOWN",
		1: "INFO",
		2: "WARNING",
		3: "ERROR",
	}
	Notification_Severity_value = map[string]int32{
		"UNKNOWN": 0,
		"INFO":    1,
		"WARNING": 2,
		"ERROR":   3,
	}
)

func (x Notification_Severity) Enum() *Notification_Severity {
	p := new(Notification_Severity)
	*p = x
	return p
}

func (x Notification_Severity) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Notification_Severity) Descriptor() protoreflect.EnumDescriptor {
	return file_fswalker_proto_enumTypes[0].Descriptor()
}

func (Notification_Severity) Type() protoreflect.EnumType {
	return &file_fswalker_proto_enumTypes[0]
}

func (x Notification_Severity) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Notification_Severity.Descriptor instead.
func (Notification_Severity) EnumDescriptor() ([]byte, []int) {
	return file_fswalker_proto_rawDescGZIP(), []int{5, 0}
}

type Fingerprint_Method int32

const (
	Fingerprint_UNKNOWN Fingerprint_Method = 0
	Fingerprint_SHA256  Fingerprint_Method = 1
)

// Enum value maps for Fingerprint_Method.
var (
	Fingerprint_Method_name = map[int32]string{
		0: "UNKNOWN",
		1: "SHA256",
	}
	Fingerprint_Method_value = map[string]int32{
		"UNKNOWN": 0,
		"SHA256":  1,
	}
)

func (x Fingerprint_Method) Enum() *Fingerprint_Method {
	p := new(Fingerprint_Method)
	*p = x
	return p
}

func (x Fingerprint_Method) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Fingerprint_Method) Descriptor() protoreflect.EnumDescriptor {
	return file_fswalker_proto_enumTypes[1].Descriptor()
}

func (Fingerprint_Method) Type() protoreflect.EnumType {
	return &file_fswalker_proto_enumTypes[1]
}

func (x Fingerprint_Method) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Fingerprint_Method.Descriptor instead.
func (Fingerprint_Method) EnumDescriptor() ([]byte, []int) {
	return file_fswalker_proto_rawDescGZIP(), []int{8, 0}
}

// Reviews is a collection of "known good" states, one per host.
// It is used to keep the default to compare newer reports against.
type Reviews struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Review map[string]*Review `protobuf:"bytes,1,rep,name=review,proto3" json:"review,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"` // Keyed by the FQDN of the host.
}

func (x *Reviews) Reset() {
	*x = Reviews{}
	if protoimpl.UnsafeEnabled {
		mi := &file_fswalker_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Reviews) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Reviews) ProtoMessage() {}

func (x *Reviews) ProtoReflect() protoreflect.Message {
	mi := &file_fswalker_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Reviews.ProtoReflect.Descriptor instead.
func (*Reviews) Descriptor() ([]byte, []int) {
	return file_fswalker_proto_rawDescGZIP(), []int{0}
}

func (x *Reviews) GetReview() map[string]*Review {
	if x != nil {
		return x.Review
	}
	return nil
}

type Review struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the Walk that was reviewed and considered ok.
	// This will become the last known good.
	WalkId string `protobuf:"bytes,1,opt,name=walk_id,json=walkId,proto3" json:"walk_id,omitempty"`
	// Reference to the Walk source (e.g. absolute path).
	WalkReference string `protobuf:"bytes,2,opt,name=walk_reference,json=walkReference,proto3" json:"walk_reference,omitempty"`
	// Mandatory fingerprint of the walk file (to ensure integrity).
	Fingerprint *Fingerprint `protobuf:"bytes,3,opt,name=fingerprint,proto3" json:"fingerprint,omitempty"`
}

func (x *Review) Reset() {
	*x = Review{}
	if protoimpl.UnsafeEnabled {
		mi := &file_fswalker_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Review) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Review) ProtoMessage() {}

func (x *Review) ProtoReflect() protoreflect.Message {
	mi := &file_fswalker_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Review.ProtoReflect.Descriptor instead.
func (*Review) Descriptor() ([]byte, []int) {
	return file_fswalker_proto_rawDescGZIP(), []int{1}
}

func (x *Review) GetWalkId() string {
	if x != nil {
		return x.WalkId
	}
	return ""
}

func (x *Review) GetWalkReference() string {
	if x != nil {
		return x.WalkReference
	}
	return ""
}

func (x *Review) GetFingerprint() *Fingerprint {
	if x != nil {
		return x.Fingerprint
	}
	return nil
}

type ReportConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// version is the version of the proto structure.
	Version uint32 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	// exclude_pfx is a list of path prefixes which will be excluded from being
	// reported. Note that these are prefixes. Any path matching one of these
	// prefixes will be ignored. These are in addition to the exclusions in the
	// client policy so more things can be recorded (but ignored in the default
	// report).
	ExcludePfx []string `protobuf:"bytes,2,rep,name=exclude_pfx,json=excludePfx,proto3" json:"exclude_pfx,omitempty"`
}

func (x *ReportConfig) Reset() {
	*x = ReportConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_fswalker_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReportConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReportConfig) ProtoMessage() {}

func (x *ReportConfig) ProtoReflect() protoreflect.Message {
	mi := &file_fswalker_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReportConfig.ProtoReflect.Descriptor instead.
func (*ReportConfig) Descriptor() ([]byte, []int) {
	return file_fswalker_proto_rawDescGZIP(), []int{2}
}

func (x *ReportConfig) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *ReportConfig) GetExcludePfx() []string {
	if x != nil {
		return x.ExcludePfx
	}
	return nil
}

type Policy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// version is the version of the proto structure.
	Version uint32 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	// include is a list of paths to use as roots for file walks.
	// Each walk can be done by a separate Go routine (if an idle one is
	// available). Important to note that the include paths SHOULD NOT contain
	// each other because that will lead to paths being visited more than once.
	Include []string `protobuf:"bytes,2,rep,name=include,proto3" json:"include,omitempty"`
	// exclude_pfx is a list of path prefixes which will be excluded from being
	// walked. Note that these are prefixes. Any path matching one of these
	// prefixes will be ignored.
	ExcludePfx []string `protobuf:"bytes,3,rep,name=exclude_pfx,json=excludePfx,proto3" json:"exclude_pfx,omitempty"`
	// hash_pfx is a list of path prefixes. If the discovered File path is not a
	// directory, matches one of the prefixes and is not larger than
	// max_hash_file_size, the file will be opened and a file hash built over its
	// content.
	HashPfx         []string `protobuf:"bytes,4,rep,name=hash_pfx,json=hashPfx,proto3" json:"hash_pfx,omitempty"`
	MaxHashFileSize int64    `protobuf:"varint,5,opt,name=max_hash_file_size,json=maxHashFileSize,proto3" json:"max_hash_file_size,omitempty"`
	// walk_cross_device controls whether files on different devices from the
	// include directories should be walked. I.e. if "/" is included, "/tmp" will
	// only be walked if it is not a separate mount point.
	WalkCrossDevice bool `protobuf:"varint,30,opt,name=walk_cross_device,json=walkCrossDevice,proto3" json:"walk_cross_device,omitempty"`
	// ignore_irregular_files controls whether irregular files (i.e. symlinks,
	// sockets, devices, etc) should be ignored.
	// Note that symlinks are NOT followed either way.
	IgnoreIrregularFiles bool `protobuf:"varint,31,opt,name=ignore_irregular_files,json=ignoreIrregularFiles,proto3" json:"ignore_irregular_files,omitempty"`
	// max_directory_depth controls how many levels of directories Walker should
	// walk into an included directory.
	// Defaults to no restriction on depth (i.e. go all the way).
	MaxDirectoryDepth uint32 `protobuf:"varint,32,opt,name=max_directory_depth,json=maxDirectoryDepth,proto3" json:"max_directory_depth,omitempty"`
}

func (x *Policy) Reset() {
	*x = Policy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_fswalker_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Policy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Policy) ProtoMessage() {}

func (x *Policy) ProtoReflect() protoreflect.Message {
	mi := &file_fswalker_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Policy.ProtoReflect.Descriptor instead.
func (*Policy) Descriptor() ([]byte, []int) {
	return file_fswalker_proto_rawDescGZIP(), []int{3}
}

func (x *Policy) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *Policy) GetInclude() []string {
	if x != nil {
		return x.Include
	}
	return nil
}

func (x *Policy) GetExcludePfx() []string {
	if x != nil {
		return x.ExcludePfx
	}
	return nil
}

func (x *Policy) GetHashPfx() []string {
	if x != nil {
		return x.HashPfx
	}
	return nil
}

func (x *Policy) GetMaxHashFileSize() int64 {
	if x != nil {
		return x.MaxHashFileSize
	}
	return 0
}

func (x *Policy) GetWalkCrossDevice() bool {
	if x != nil {
		return x.WalkCrossDevice
	}
	return false
}

func (x *Policy) GetIgnoreIrregularFiles() bool {
	if x != nil {
		return x.IgnoreIrregularFiles
	}
	return false
}

func (x *Policy) GetMaxDirectoryDepth() uint32 {
	if x != nil {
		return x.MaxDirectoryDepth
	}
	return 0
}

type Walk struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// A unique string identifying this specific Walk.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// version is the version of the proto structure.
	Version uint32 `protobuf:"varint,2,opt,name=version,proto3" json:"version,omitempty"`
	// policy is the Policy that was used for the file walk.
	Policy *Policy `protobuf:"bytes,3,opt,name=policy,proto3" json:"policy,omitempty"`
	// file is a list of all files including metadata that were discovered.
	File []*File `protobuf:"bytes,4,rep,name=file,proto3" json:"file,omitempty"`
	// notification is a list of notifications that occurred during a walk.
	Notification []*Notification `protobuf:"bytes,5,rep,name=notification,proto3" json:"notification,omitempty"`
	// hostname of the machine the walk originates from.
	Hostname string `protobuf:"bytes,10,opt,name=hostname,proto3" json:"hostname,omitempty"`
	// start and stop time of the walk.
	StartWalk *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=start_walk,json=startWalk,proto3" json:"start_walk,omitempty"`
	StopWalk  *timestamppb.Timestamp `protobuf:"bytes,12,opt,name=stop_walk,json=stopWalk,proto3" json:"stop_walk,omitempty"`
}

func (x *Walk) Reset() {
	*x = Walk{}
	if protoimpl.UnsafeEnabled {
		mi := &file_fswalker_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Walk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Walk) ProtoMessage() {}

func (x *Walk) ProtoReflect() protoreflect.Message {
	mi := &file_fswalker_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Walk.ProtoReflect.Descriptor instead.
func (*Walk) Descriptor() ([]byte, []int) {
	return file_fswalker_proto_rawDescGZIP(), []int{4}
}

func (x *Walk) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Walk) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *Walk) GetPolicy() *Policy {
	if x != nil {
		return x.Policy
	}
	return nil
}

func (x *Walk) GetFile() []*File {
	if x != nil {
		return x.File
	}
	return nil
}

func (x *Walk) GetNotification() []*Notification {
	if x != nil {
		return x.Notification
	}
	return nil
}

func (x *Walk) GetHostname() string {
	if x != nil {
		return x.Hostname
	}
	return ""
}

func (x *Walk) GetStartWalk() *timestamppb.Timestamp {
	if x != nil {
		return x.StartWalk
	}
	return nil
}

func (x *Walk) GetStopWalk() *timestamppb.Timestamp {
	if x != nil {
		return x.StopWalk
	}
	return nil
}

type Notification struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Severity Notification_Severity `protobuf:"varint,1,opt,name=severity,proto3,enum=fswalker.Notification_Severity" json:"severity,omitempty"`
	// path where the notification occurred.
	Path string `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	// human readable message.
	Message string `protobuf:"bytes,3,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *Notification) Reset() {
	*x = Notification{}
	if protoimpl.UnsafeEnabled {
		mi := &file_fswalker_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Notification) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Notification) ProtoMessage() {}

func (x *Notification) ProtoReflect() protoreflect.Message {
	mi := &file_fswalker_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Notification.ProtoReflect.Descriptor instead.
func (*Notification) Descriptor() ([]byte, []int) {
	return file_fswalker_proto_rawDescGZIP(), []int{5}
}

func (x *Notification) GetSeverity() Notification_Severity {
	if x != nil {
		return x.Severity
	}
	return Notification_UNKNOWN
}

func (x *Notification) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *Notification) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

type FileInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// base name of the file
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// length in bytes for regular files; system-dependent for others
	Size int64 `protobuf:"varint,2,opt,name=size,proto3" json:"size,omitempty"`
	// file mode bits
	Mode uint32 `protobuf:"varint,3,opt,name=mode,proto3" json:"mode,omitempty"`
	// modification time
	Modified *timestamppb.Timestamp `protobuf:"bytes,4,opt,name=modified,proto3" json:"modified,omitempty"`
	// abbreviation for Mode().IsDir()
	IsDir bool `protobuf:"varint,5,opt,name=is_dir,json=isDir,proto3" json:"is_dir,omitempty"`
}

func (x *FileInfo) Reset() {
	*x = FileInfo{}
	if protoimpl.UnsafeEnabled {
		mi := &file_fswalker_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FileInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileInfo) ProtoMessage() {}

func (x *FileInfo) ProtoReflect() protoreflect.Message {
	mi := &file_fswalker_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FileInfo.ProtoReflect.Descriptor instead.
func (*FileInfo) Descriptor() ([]byte, []int) {
	return file_fswalker_proto_rawDescGZIP(), []int{6}
}

func (x *FileInfo) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FileInfo) GetSize() int64 {
	if x != nil {
		return x.Size
	}
	return 0
}

func (x *FileInfo) GetMode() uint32 {
	if x != nil {
		return x.Mode
	}
	return 0
}

func (x *FileInfo) GetModified() *timestamppb.Timestamp {
	if x != nil {
		return x.Modified
	}
	return nil
}

func (x *FileInfo) GetIsDir() bool {
	if x != nil {
		return x.IsDir
	}
	return false
}

type FileStat struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Dev     uint64                 `protobuf:"varint,1,opt,name=dev,proto3" json:"dev,omitempty"`
	Inode   uint64                 `protobuf:"varint,2,opt,name=inode,proto3" json:"inode,omitempty"`
	Nlink   uint64                 `protobuf:"varint,3,opt,name=nlink,proto3" json:"nlink,omitempty"`
	Mode    uint32                 `protobuf:"varint,4,opt,name=mode,proto3" json:"mode,omitempty"`
	Uid     uint32                 `protobuf:"varint,5,opt,name=uid,proto3" json:"uid,omitempty"`
	Gid     uint32                 `protobuf:"varint,6,opt,name=gid,proto3" json:"gid,omitempty"`
	Rdev    uint64                 `protobuf:"varint,7,opt,name=rdev,proto3" json:"rdev,omitempty"`
	Size    int64                  `protobuf:"varint,8,opt,name=size,proto3" json:"size,omitempty"`
	Blksize int64                  `protobuf:"varint,9,opt,name=blksize,proto3" json:"blksize,omitempty"`
	Blocks  int64                  `protobuf:"varint,10,opt,name=blocks,proto3" json:"blocks,omitempty"`
	Atime   *timestamppb.Timestamp `protobuf:"bytes,11,opt,name=atime,proto3" json:"atime,omitempty"`
	Mtime   *timestamppb.Timestamp `protobuf:"bytes,12,opt,name=mtime,proto3" json:"mtime,omitempty"`
	Ctime   *timestamppb.Timestamp `protobuf:"bytes,13,opt,name=ctime,proto3" json:"ctime,omitempty"`
}

func (x *FileStat) Reset() {
	*x = FileStat{}
	if protoimpl.UnsafeEnabled {
		mi := &file_fswalker_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FileStat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileStat) ProtoMessage() {}

func (x *FileStat) ProtoReflect() protoreflect.Message {
	mi := &file_fswalker_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FileStat.ProtoReflect.Descriptor instead.
func (*FileStat) Descriptor() ([]byte, []int) {
	return file_fswalker_proto_rawDescGZIP(), []int{7}
}

func (x *FileStat) GetDev() uint64 {
	if x != nil {
		return x.Dev
	}
	return 0
}

func (x *FileStat) GetInode() uint64 {
	if x != nil {
		return x.Inode
	}
	return 0
}

func (x *FileStat) GetNlink() uint64 {
	if x != nil {
		return x.Nlink
	}
	return 0
}

func (x *FileStat) GetMode() uint32 {
	if x != nil {
		return x.Mode
	}
	return 0
}

func (x *FileStat) GetUid() uint32 {
	if x != nil {
		return x.Uid
	}
	return 0
}

func (x *FileStat) GetGid() uint32 {
	if x != nil {
		return x.Gid
	}
	return 0
}

func (x *FileStat) GetRdev() uint64 {
	if x != nil {
		return x.Rdev
	}
	return 0
}

func (x *FileStat) GetSize() int64 {
	if x != nil {
		return x.Size
	}
	return 0
}

func (x *FileStat) GetBlksize() int64 {
	if x != nil {
		return x.Blksize
	}
	return 0
}

func (x *FileStat) GetBlocks() int64 {
	if x != nil {
		return x.Blocks
	}
	return 0
}

func (x *FileStat) GetAtime() *timestamppb.Timestamp {
	if x != nil {
		return x.Atime
	}
	return nil
}

func (x *FileStat) GetMtime() *timestamppb.Timestamp {
	if x != nil {
		return x.Mtime
	}
	return nil
}

func (x *FileStat) GetCtime() *timestamppb.Timestamp {
	if x != nil {
		return x.Ctime
	}
	return nil
}

// Fingerprint is a unique identifier for a given File.
// It consists of a Method (e.g. SHA256) and a value.
type Fingerprint struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Method Fingerprint_Method `protobuf:"varint,1,opt,name=method,proto3,enum=fswalker.Fingerprint_Method" json:"method,omitempty"`
	Value  string             `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *Fingerprint) Reset() {
	*x = Fingerprint{}
	if protoimpl.UnsafeEnabled {
		mi := &file_fswalker_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Fingerprint) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Fingerprint) ProtoMessage() {}

func (x *Fingerprint) ProtoReflect() protoreflect.Message {
	mi := &file_fswalker_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Fingerprint.ProtoReflect.Descriptor instead.
func (*Fingerprint) Descriptor() ([]byte, []int) {
	return file_fswalker_proto_rawDescGZIP(), []int{8}
}

func (x *Fingerprint) GetMethod() Fingerprint_Method {
	if x != nil {
		return x.Method
	}
	return Fingerprint_UNKNOWN
}

func (x *Fingerprint) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

type File struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// version is the version of the proto structure.
	Version uint32 `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	// path is the full file path including the file name.
	Path string    `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	Info *FileInfo `protobuf:"bytes,3,opt,name=info,proto3" json:"info,omitempty"`
	Stat *FileStat `protobuf:"bytes,4,opt,name=stat,proto3" json:"stat,omitempty"`
	// fingerprint is optionally set when requested for the specific file.
	Fingerprint []*Fingerprint `protobuf:"bytes,5,rep,name=fingerprint,proto3" json:"fingerprint,omitempty"`
}

func (x *File) Reset() {
	*x = File{}
	if protoimpl.UnsafeEnabled {
		mi := &file_fswalker_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *File) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*File) ProtoMessage() {}

func (x *File) ProtoReflect() protoreflect.Message {
	mi := &file_fswalker_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use File.ProtoReflect.Descriptor instead.
func (*File) Descriptor() ([]byte, []int) {
	return file_fswalker_proto_rawDescGZIP(), []int{9}
}

func (x *File) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *File) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *File) GetInfo() *FileInfo {
	if x != nil {
		return x.Info
	}
	return nil
}

func (x *File) GetStat() *FileStat {
	if x != nil {
		return x.Stat
	}
	return nil
}

func (x *File) GetFingerprint() []*Fingerprint {
	if x != nil {
		return x.Fingerprint
	}
	return nil
}

var File_fswalker_proto protoreflect.FileDescriptor

var file_fswalker_proto_rawDesc = []byte{
	0x0a, 0x0e, 0x66, 0x73, 0x77, 0x61, 0x6c, 0x6b, 0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x12, 0x08, 0x66, 0x73, 0x77, 0x61, 0x6c, 0x6b, 0x65, 0x72, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x8d, 0x01, 0x0a, 0x07,
	0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x12, 0x35, 0x0a, 0x06, 0x72, 0x65, 0x76, 0x69, 0x65,
	0x77, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x66, 0x73, 0x77, 0x61, 0x6c, 0x6b,
	0x65, 0x72, 0x2e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x73, 0x2e, 0x52, 0x65, 0x76, 0x69, 0x65,
	0x77, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x06, 0x72, 0x65, 0x76, 0x69, 0x65, 0x77, 0x1a, 0x4b,
	0x0a, 0x0b, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x26, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10,
	0x2e, 0x66, 0x73, 0x77, 0x61, 0x6c, 0x6b, 0x65, 0x72, 0x2e, 0x52, 0x65, 0x76, 0x69, 0x65, 0x77,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x81, 0x01, 0x0a, 0x06,
	0x52, 0x65, 0x76, 0x69, 0x65, 0x77, 0x12, 0x17, 0x0a, 0x07, 0x77, 0x61, 0x6c, 0x6b, 0x5f, 0x69,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x77, 0x61, 0x6c, 0x6b, 0x49, 0x64, 0x12,
	0x25, 0x0a, 0x0e, 0x77, 0x61, 0x6c, 0x6b, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x77, 0x61, 0x6c, 0x6b, 0x52, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x12, 0x37, 0x0a, 0x0b, 0x66, 0x69, 0x6e, 0x67, 0x65, 0x72,
	0x70, 0x72, 0x69, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x66, 0x73,
	0x77, 0x61, 0x6c, 0x6b, 0x65, 0x72, 0x2e, 0x46, 0x69, 0x6e, 0x67, 0x65, 0x72, 0x70, 0x72, 0x69,
	0x6e, 0x74, 0x52, 0x0b, 0x66, 0x69, 0x6e, 0x67, 0x65, 0x72, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x22,
	0x49, 0x0a, 0x0c, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12,
	0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d,
	0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x1f, 0x0a, 0x0b, 0x65, 0x78, 0x63,
	0x6c, 0x75, 0x64, 0x65, 0x5f, 0x70, 0x66, 0x78, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a,
	0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x50, 0x66, 0x78, 0x22, 0xb7, 0x02, 0x0a, 0x06, 0x50,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x18, 0x0a, 0x07, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x07, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x12, 0x1f, 0x0a, 0x0b, 0x65, 0x78, 0x63,
	0x6c, 0x75, 0x64, 0x65, 0x5f, 0x70, 0x66, 0x78, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a,
	0x65, 0x78, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x50, 0x66, 0x78, 0x12, 0x19, 0x0a, 0x08, 0x68, 0x61,
	0x73, 0x68, 0x5f, 0x70, 0x66, 0x78, 0x18, 0x04, 0x20, 0x03, 0x28, 0x09, 0x52, 0x07, 0x68, 0x61,
	0x73, 0x68, 0x50, 0x66, 0x78, 0x12, 0x2b, 0x0a, 0x12, 0x6d, 0x61, 0x78, 0x5f, 0x68, 0x61, 0x73,
	0x68, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x0f, 0x6d, 0x61, 0x78, 0x48, 0x61, 0x73, 0x68, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x2a, 0x0a, 0x11, 0x77, 0x61, 0x6c, 0x6b, 0x5f, 0x63, 0x72, 0x6f, 0x73, 0x73,
	0x5f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x18, 0x1e, 0x20, 0x01, 0x28, 0x08, 0x52, 0x0f, 0x77,
	0x61, 0x6c, 0x6b, 0x43, 0x72, 0x6f, 0x73, 0x73, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x12, 0x34,
	0x0a, 0x16, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x5f, 0x69, 0x72, 0x72, 0x65, 0x67, 0x75, 0x6c,
	0x61, 0x72, 0x5f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x18, 0x1f, 0x20, 0x01, 0x28, 0x08, 0x52, 0x14,
	0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x49, 0x72, 0x72, 0x65, 0x67, 0x75, 0x6c, 0x61, 0x72, 0x46,
	0x69, 0x6c, 0x65, 0x73, 0x12, 0x2e, 0x0a, 0x13, 0x6d, 0x61, 0x78, 0x5f, 0x64, 0x69, 0x72, 0x65,
	0x63, 0x74, 0x6f, 0x72, 0x79, 0x5f, 0x64, 0x65, 0x70, 0x74, 0x68, 0x18, 0x20, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x11, 0x6d, 0x61, 0x78, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x44,
	0x65, 0x70, 0x74, 0x68, 0x22, 0xca, 0x02, 0x0a, 0x04, 0x57, 0x61, 0x6c, 0x6b, 0x12, 0x0e, 0x0a,
	0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x18, 0x0a,
	0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12, 0x28, 0x0a, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x10, 0x2e, 0x66, 0x73, 0x77, 0x61, 0x6c, 0x6b,
	0x65, 0x72, 0x2e, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x06, 0x70, 0x6f, 0x6c, 0x69, 0x63,
	0x79, 0x12, 0x22, 0x0a, 0x04, 0x66, 0x69, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x0e, 0x2e, 0x66, 0x73, 0x77, 0x61, 0x6c, 0x6b, 0x65, 0x72, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x52,
	0x04, 0x66, 0x69, 0x6c, 0x65, 0x12, 0x3a, 0x0a, 0x0c, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x66, 0x73,
	0x77, 0x61, 0x6c, 0x6b, 0x65, 0x72, 0x2e, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x1a, 0x0a, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x39, 0x0a,
	0x0a, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x77, 0x61, 0x6c, 0x6b, 0x18, 0x0b, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x57, 0x61, 0x6c, 0x6b, 0x12, 0x37, 0x0a, 0x09, 0x73, 0x74, 0x6f, 0x70,
	0x5f, 0x77, 0x61, 0x6c, 0x6b, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x08, 0x73, 0x74, 0x6f, 0x70, 0x57, 0x61, 0x6c,
	0x6b, 0x22, 0xb4, 0x01, 0x0a, 0x0c, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x3b, 0x0a, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x66, 0x73, 0x77, 0x61, 0x6c, 0x6b, 0x65, 0x72, 0x2e,
	0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x53, 0x65, 0x76,
	0x65, 0x72, 0x69, 0x74, 0x79, 0x52, 0x08, 0x73, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x12,
	0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x70,
	0x61, 0x74, 0x68, 0x12, 0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0x39, 0x0a,
	0x08, 0x53, 0x65, 0x76, 0x65, 0x72, 0x69, 0x74, 0x79, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b,
	0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x08, 0x0a, 0x04, 0x49, 0x4e, 0x46, 0x4f, 0x10, 0x01,
	0x12, 0x0b, 0x0a, 0x07, 0x57, 0x41, 0x52, 0x4e, 0x49, 0x4e, 0x47, 0x10, 0x02, 0x12, 0x09, 0x0a,
	0x05, 0x45, 0x52, 0x52, 0x4f, 0x52, 0x10, 0x03, 0x22, 0x95, 0x01, 0x0a, 0x08, 0x46, 0x69, 0x6c,
	0x65, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x69, 0x7a,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x12, 0x12, 0x0a,
	0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x6d, 0x6f, 0x64,
	0x65, 0x12, 0x36, 0x0a, 0x08, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x64, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52,
	0x08, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x64, 0x12, 0x15, 0x0a, 0x06, 0x69, 0x73, 0x5f,
	0x64, 0x69, 0x72, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x05, 0x69, 0x73, 0x44, 0x69, 0x72,
	0x22, 0xf0, 0x02, 0x0a, 0x08, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x74, 0x61, 0x74, 0x12, 0x10, 0x0a,
	0x03, 0x64, 0x65, 0x76, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x52, 0x03, 0x64, 0x65, 0x76, 0x12,
	0x14, 0x0a, 0x05, 0x69, 0x6e, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x04, 0x52, 0x05,
	0x69, 0x6e, 0x6f, 0x64, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x04, 0x52, 0x05, 0x6e, 0x6c, 0x69, 0x6e, 0x6b, 0x12, 0x12, 0x0a, 0x04, 0x6d,
	0x6f, 0x64, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x12,
	0x10, 0x0a, 0x03, 0x75, 0x69, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x03, 0x75, 0x69,
	0x64, 0x12, 0x10, 0x0a, 0x03, 0x67, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x03,
	0x67, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x72, 0x64, 0x65, 0x76, 0x18, 0x07, 0x20, 0x01, 0x28,
	0x04, 0x52, 0x04, 0x72, 0x64, 0x65, 0x76, 0x12, 0x12, 0x0a, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x08, 0x20, 0x01, 0x28, 0x03, 0x52, 0x04, 0x73, 0x69, 0x7a, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x62,
	0x6c, 0x6b, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x03, 0x52, 0x07, 0x62, 0x6c,
	0x6b, 0x73, 0x69, 0x7a, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x18,
	0x0a, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x73, 0x12, 0x30, 0x0a,
	0x05, 0x61, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x05, 0x61, 0x74, 0x69, 0x6d, 0x65, 0x12,
	0x30, 0x0a, 0x05, 0x6d, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0c, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x05, 0x6d, 0x74, 0x69, 0x6d,
	0x65, 0x12, 0x30, 0x0a, 0x05, 0x63, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x05, 0x63, 0x74,
	0x69, 0x6d, 0x65, 0x22, 0x7c, 0x0a, 0x0b, 0x46, 0x69, 0x6e, 0x67, 0x65, 0x72, 0x70, 0x72, 0x69,
	0x6e, 0x74, 0x12, 0x34, 0x0a, 0x06, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x0e, 0x32, 0x1c, 0x2e, 0x66, 0x73, 0x77, 0x61, 0x6c, 0x6b, 0x65, 0x72, 0x2e, 0x46, 0x69,
	0x6e, 0x67, 0x65, 0x72, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x2e, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64,
	0x52, 0x06, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x21,
	0x0a, 0x06, 0x4d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e,
	0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x48, 0x41, 0x32, 0x35, 0x36, 0x10,
	0x01, 0x22, 0xbd, 0x01, 0x0a, 0x04, 0x46, 0x69, 0x6c, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x12, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x26, 0x0a, 0x04, 0x69, 0x6e, 0x66, 0x6f,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x66, 0x73, 0x77, 0x61, 0x6c, 0x6b, 0x65,
	0x72, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x49, 0x6e, 0x66, 0x6f, 0x52, 0x04, 0x69, 0x6e, 0x66, 0x6f,
	0x12, 0x26, 0x0a, 0x04, 0x73, 0x74, 0x61, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12,
	0x2e, 0x66, 0x73, 0x77, 0x61, 0x6c, 0x6b, 0x65, 0x72, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x53, 0x74,
	0x61, 0x74, 0x52, 0x04, 0x73, 0x74, 0x61, 0x74, 0x12, 0x37, 0x0a, 0x0b, 0x66, 0x69, 0x6e, 0x67,
	0x65, 0x72, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e,
	0x66, 0x73, 0x77, 0x61, 0x6c, 0x6b, 0x65, 0x72, 0x2e, 0x46, 0x69, 0x6e, 0x67, 0x65, 0x72, 0x70,
	0x72, 0x69, 0x6e, 0x74, 0x52, 0x0b, 0x66, 0x69, 0x6e, 0x67, 0x65, 0x72, 0x70, 0x72, 0x69, 0x6e,
	0x74, 0x42, 0x1c, 0x5a, 0x1a, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x66, 0x73, 0x77, 0x61, 0x6c, 0x6b, 0x65, 0x72, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_fswalker_proto_rawDescOnce sync.Once
	file_fswalker_proto_rawDescData = file_fswalker_proto_rawDesc
)

func file_fswalker_proto_rawDescGZIP() []byte {
	file_fswalker_proto_rawDescOnce.Do(func() {
		file_fswalker_proto_rawDescData = protoimpl.X.CompressGZIP(file_fswalker_proto_rawDescData)
	})
	return file_fswalker_proto_rawDescData
}

var file_fswalker_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_fswalker_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_fswalker_proto_goTypes = []interface{}{
	(Notification_Severity)(0),    // 0: fswalker.Notification.Severity
	(Fingerprint_Method)(0),       // 1: fswalker.Fingerprint.Method
	(*Reviews)(nil),               // 2: fswalker.Reviews
	(*Review)(nil),                // 3: fswalker.Review
	(*ReportConfig)(nil),          // 4: fswalker.ReportConfig
	(*Policy)(nil),                // 5: fswalker.Policy
	(*Walk)(nil),                  // 6: fswalker.Walk
	(*Notification)(nil),          // 7: fswalker.Notification
	(*FileInfo)(nil),              // 8: fswalker.FileInfo
	(*FileStat)(nil),              // 9: fswalker.FileStat
	(*Fingerprint)(nil),           // 10: fswalker.Fingerprint
	(*File)(nil),                  // 11: fswalker.File
	nil,                           // 12: fswalker.Reviews.ReviewEntry
	(*timestamppb.Timestamp)(nil), // 13: google.protobuf.Timestamp
}
var file_fswalker_proto_depIdxs = []int32{
	12, // 0: fswalker.Reviews.review:type_name -> fswalker.Reviews.ReviewEntry
	10, // 1: fswalker.Review.fingerprint:type_name -> fswalker.Fingerprint
	5,  // 2: fswalker.Walk.policy:type_name -> fswalker.Policy
	11, // 3: fswalker.Walk.file:type_name -> fswalker.File
	7,  // 4: fswalker.Walk.notification:type_name -> fswalker.Notification
	13, // 5: fswalker.Walk.start_walk:type_name -> google.protobuf.Timestamp
	13, // 6: fswalker.Walk.stop_walk:type_name -> google.protobuf.Timestamp
	0,  // 7: fswalker.Notification.severity:type_name -> fswalker.Notification.Severity
	13, // 8: fswalker.FileInfo.modified:type_name -> google.protobuf.Timestamp
	13, // 9: fswalker.FileStat.atime:type_name -> google.protobuf.Timestamp
	13, // 10: fswalker.FileStat.mtime:type_name -> google.protobuf.Timestamp
	13, // 11: fswalker.FileStat.ctime:type_name -> google.protobuf.Timestamp
	1,  // 12: fswalker.Fingerprint.method:type_name -> fswalker.Fingerprint.Method
	8,  // 13: fswalker.File.info:type_name -> fswalker.FileInfo
	9,  // 14: fswalker.File.stat:type_name -> fswalker.FileStat
	10, // 15: fswalker.File.fingerprint:type_name -> fswalker.Fingerprint
	3,  // 16: fswalker.Reviews.ReviewEntry.value:type_name -> fswalker.Review
	17, // [17:17] is the sub-list for method output_type
	17, // [17:17] is the sub-list for method input_type
	17, // [17:17] is the sub-list for extension type_name
	17, // [17:17] is the sub-list for extension extendee
	0,  // [0:17] is the sub-list for field type_name
}

func init() { file_fswalker_proto_init() }
func file_fswalker_proto_init() {
	if File_fswalker_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_fswalker_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Reviews); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_fswalker_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Review); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_fswalker_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReportConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_fswalker_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Policy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_fswalker_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Walk); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_fswalker_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Notification); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_fswalker_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FileInfo); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_fswalker_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FileStat); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_fswalker_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Fingerprint); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_fswalker_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*File); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_fswalker_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_fswalker_proto_goTypes,
		DependencyIndexes: file_fswalker_proto_depIdxs,
		EnumInfos:         file_fswalker_proto_enumTypes,
		MessageInfos:      file_fswalker_proto_msgTypes,
	}.Build()
	File_fswalker_proto = out.File
	file_fswalker_proto_rawDesc = nil
	file_fswalker_proto_goTypes = nil
	file_fswalker_proto_depIdxs = nil
}
