// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package prometheusservice

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateWorkspace = "CreateWorkspace"

// CreateWorkspaceRequest generates a "aws/request.Request" representing the
// client's request for the CreateWorkspace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWorkspace for more information on using the CreateWorkspace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateWorkspaceRequest method.
//    req, resp := client.CreateWorkspaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/CreateWorkspace
func (c *PrometheusService) CreateWorkspaceRequest(input *CreateWorkspaceInput) (req *request.Request, output *CreateWorkspaceOutput) {
	op := &request.Operation{
		Name:       opCreateWorkspace,
		HTTPMethod: "POST",
		HTTPPath:   "/workspaces",
	}

	if input == nil {
		input = &CreateWorkspaceInput{}
	}

	output = &CreateWorkspaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateWorkspace API operation for Amazon Prometheus Service.
//
// Creates a new AMP workspace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Prometheus Service's
// API operation CreateWorkspace for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   Request was denied due to request throttling.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
//   * AccessDeniedException
//   User does not have sufficient access to perform this action.
//
//   * InternalServerException
//   Unexpected error during processing of request.
//
//   * ServiceQuotaExceededException
//   Request would cause a service quota to be exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/CreateWorkspace
func (c *PrometheusService) CreateWorkspace(input *CreateWorkspaceInput) (*CreateWorkspaceOutput, error) {
	req, out := c.CreateWorkspaceRequest(input)
	return out, req.Send()
}

// CreateWorkspaceWithContext is the same as CreateWorkspace with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWorkspace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrometheusService) CreateWorkspaceWithContext(ctx aws.Context, input *CreateWorkspaceInput, opts ...request.Option) (*CreateWorkspaceOutput, error) {
	req, out := c.CreateWorkspaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWorkspace = "DeleteWorkspace"

// DeleteWorkspaceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWorkspace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWorkspace for more information on using the DeleteWorkspace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteWorkspaceRequest method.
//    req, resp := client.DeleteWorkspaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/DeleteWorkspace
func (c *PrometheusService) DeleteWorkspaceRequest(input *DeleteWorkspaceInput) (req *request.Request, output *DeleteWorkspaceOutput) {
	op := &request.Operation{
		Name:       opDeleteWorkspace,
		HTTPMethod: "DELETE",
		HTTPPath:   "/workspaces/{workspaceId}",
	}

	if input == nil {
		input = &DeleteWorkspaceInput{}
	}

	output = &DeleteWorkspaceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteWorkspace API operation for Amazon Prometheus Service.
//
// Deletes an AMP workspace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Prometheus Service's
// API operation DeleteWorkspace for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   Request was denied due to request throttling.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
//   * ResourceNotFoundException
//   Request references a resource which does not exist.
//
//   * AccessDeniedException
//   User does not have sufficient access to perform this action.
//
//   * InternalServerException
//   Unexpected error during processing of request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/DeleteWorkspace
func (c *PrometheusService) DeleteWorkspace(input *DeleteWorkspaceInput) (*DeleteWorkspaceOutput, error) {
	req, out := c.DeleteWorkspaceRequest(input)
	return out, req.Send()
}

// DeleteWorkspaceWithContext is the same as DeleteWorkspace with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWorkspace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrometheusService) DeleteWorkspaceWithContext(ctx aws.Context, input *DeleteWorkspaceInput, opts ...request.Option) (*DeleteWorkspaceOutput, error) {
	req, out := c.DeleteWorkspaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeWorkspace = "DescribeWorkspace"

// DescribeWorkspaceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkspace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorkspace for more information on using the DescribeWorkspace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeWorkspaceRequest method.
//    req, resp := client.DescribeWorkspaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/DescribeWorkspace
func (c *PrometheusService) DescribeWorkspaceRequest(input *DescribeWorkspaceInput) (req *request.Request, output *DescribeWorkspaceOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkspace,
		HTTPMethod: "GET",
		HTTPPath:   "/workspaces/{workspaceId}",
	}

	if input == nil {
		input = &DescribeWorkspaceInput{}
	}

	output = &DescribeWorkspaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkspace API operation for Amazon Prometheus Service.
//
// Describes an existing AMP workspace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Prometheus Service's
// API operation DescribeWorkspace for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   Request was denied due to request throttling.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
//   * ResourceNotFoundException
//   Request references a resource which does not exist.
//
//   * AccessDeniedException
//   User does not have sufficient access to perform this action.
//
//   * InternalServerException
//   Unexpected error during processing of request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/DescribeWorkspace
func (c *PrometheusService) DescribeWorkspace(input *DescribeWorkspaceInput) (*DescribeWorkspaceOutput, error) {
	req, out := c.DescribeWorkspaceRequest(input)
	return out, req.Send()
}

// DescribeWorkspaceWithContext is the same as DescribeWorkspace with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorkspace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrometheusService) DescribeWorkspaceWithContext(ctx aws.Context, input *DescribeWorkspaceInput, opts ...request.Option) (*DescribeWorkspaceOutput, error) {
	req, out := c.DescribeWorkspaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/ListTagsForResource
func (c *PrometheusService) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Prometheus Service.
//
// Lists the tags you have assigned to the resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Prometheus Service's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   Request was denied due to request throttling.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
//   * ResourceNotFoundException
//   Request references a resource which does not exist.
//
//   * AccessDeniedException
//   User does not have sufficient access to perform this action.
//
//   * InternalServerException
//   Unexpected error during processing of request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/ListTagsForResource
func (c *PrometheusService) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrometheusService) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListWorkspaces = "ListWorkspaces"

// ListWorkspacesRequest generates a "aws/request.Request" representing the
// client's request for the ListWorkspaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWorkspaces for more information on using the ListWorkspaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListWorkspacesRequest method.
//    req, resp := client.ListWorkspacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/ListWorkspaces
func (c *PrometheusService) ListWorkspacesRequest(input *ListWorkspacesInput) (req *request.Request, output *ListWorkspacesOutput) {
	op := &request.Operation{
		Name:       opListWorkspaces,
		HTTPMethod: "GET",
		HTTPPath:   "/workspaces",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListWorkspacesInput{}
	}

	output = &ListWorkspacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListWorkspaces API operation for Amazon Prometheus Service.
//
// Lists all AMP workspaces, including workspaces being created or deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Prometheus Service's
// API operation ListWorkspaces for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   Request was denied due to request throttling.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
//   * AccessDeniedException
//   User does not have sufficient access to perform this action.
//
//   * InternalServerException
//   Unexpected error during processing of request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/ListWorkspaces
func (c *PrometheusService) ListWorkspaces(input *ListWorkspacesInput) (*ListWorkspacesOutput, error) {
	req, out := c.ListWorkspacesRequest(input)
	return out, req.Send()
}

// ListWorkspacesWithContext is the same as ListWorkspaces with the addition of
// the ability to pass a context and additional request options.
//
// See ListWorkspaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrometheusService) ListWorkspacesWithContext(ctx aws.Context, input *ListWorkspacesInput, opts ...request.Option) (*ListWorkspacesOutput, error) {
	req, out := c.ListWorkspacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListWorkspacesPages iterates over the pages of a ListWorkspaces operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListWorkspaces method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListWorkspaces operation.
//    pageNum := 0
//    err := client.ListWorkspacesPages(params,
//        func(page *prometheusservice.ListWorkspacesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *PrometheusService) ListWorkspacesPages(input *ListWorkspacesInput, fn func(*ListWorkspacesOutput, bool) bool) error {
	return c.ListWorkspacesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListWorkspacesPagesWithContext same as ListWorkspacesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrometheusService) ListWorkspacesPagesWithContext(ctx aws.Context, input *ListWorkspacesInput, fn func(*ListWorkspacesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListWorkspacesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListWorkspacesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListWorkspacesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/TagResource
func (c *PrometheusService) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Prometheus Service.
//
// Creates tags for the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Prometheus Service's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   Request was denied due to request throttling.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
//   * ResourceNotFoundException
//   Request references a resource which does not exist.
//
//   * AccessDeniedException
//   User does not have sufficient access to perform this action.
//
//   * InternalServerException
//   Unexpected error during processing of request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/TagResource
func (c *PrometheusService) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrometheusService) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/UntagResource
func (c *PrometheusService) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Prometheus Service.
//
// Deletes tags from the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Prometheus Service's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   Request was denied due to request throttling.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
//   * ResourceNotFoundException
//   Request references a resource which does not exist.
//
//   * AccessDeniedException
//   User does not have sufficient access to perform this action.
//
//   * InternalServerException
//   Unexpected error during processing of request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/UntagResource
func (c *PrometheusService) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrometheusService) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateWorkspaceAlias = "UpdateWorkspaceAlias"

// UpdateWorkspaceAliasRequest generates a "aws/request.Request" representing the
// client's request for the UpdateWorkspaceAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateWorkspaceAlias for more information on using the UpdateWorkspaceAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateWorkspaceAliasRequest method.
//    req, resp := client.UpdateWorkspaceAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/UpdateWorkspaceAlias
func (c *PrometheusService) UpdateWorkspaceAliasRequest(input *UpdateWorkspaceAliasInput) (req *request.Request, output *UpdateWorkspaceAliasOutput) {
	op := &request.Operation{
		Name:       opUpdateWorkspaceAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/workspaces/{workspaceId}/alias",
	}

	if input == nil {
		input = &UpdateWorkspaceAliasInput{}
	}

	output = &UpdateWorkspaceAliasOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateWorkspaceAlias API operation for Amazon Prometheus Service.
//
// Updates an AMP workspace alias.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Prometheus Service's
// API operation UpdateWorkspaceAlias for usage and error information.
//
// Returned Error Types:
//   * ThrottlingException
//   Request was denied due to request throttling.
//
//   * ConflictException
//   Updating or deleting a resource can cause an inconsistent state.
//
//   * ValidationException
//   The input fails to satisfy the constraints specified by an AWS service.
//
//   * ResourceNotFoundException
//   Request references a resource which does not exist.
//
//   * AccessDeniedException
//   User does not have sufficient access to perform this action.
//
//   * InternalServerException
//   Unexpected error during processing of request.
//
//   * ServiceQuotaExceededException
//   Request would cause a service quota to be exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/amp-2020-08-01/UpdateWorkspaceAlias
func (c *PrometheusService) UpdateWorkspaceAlias(input *UpdateWorkspaceAliasInput) (*UpdateWorkspaceAliasOutput, error) {
	req, out := c.UpdateWorkspaceAliasRequest(input)
	return out, req.Send()
}

// UpdateWorkspaceAliasWithContext is the same as UpdateWorkspaceAlias with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateWorkspaceAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PrometheusService) UpdateWorkspaceAliasWithContext(ctx aws.Context, input *UpdateWorkspaceAliasInput, opts ...request.Option) (*UpdateWorkspaceAliasOutput, error) {
	req, out := c.UpdateWorkspaceAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// User does not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Description of the error.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Updating or deleting a resource can cause an inconsistent state.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Description of the error.
	Message_ *string `locationName:"message" type:"string"`

	// Identifier of the resource affected.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// Type of the resource affected.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Represents the input of a CreateWorkspace operation.
type CreateWorkspaceInput struct {
	_ struct{} `type:"structure"`

	// An optional user-assigned alias for this workspace. This alias is for user
	// reference and does not need to be unique.
	Alias *string `locationName:"alias" min:"1" type:"string"`

	// Optional, unique, case-sensitive, user-provided identifier to ensure the
	// idempotency of the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// Optional, user-provided tags for this workspace.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWorkspaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWorkspaceInput"}
	if s.Alias != nil && len(*s.Alias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Alias", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlias sets the Alias field's value.
func (s *CreateWorkspaceInput) SetAlias(v string) *CreateWorkspaceInput {
	s.Alias = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateWorkspaceInput) SetClientToken(v string) *CreateWorkspaceInput {
	s.ClientToken = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateWorkspaceInput) SetTags(v map[string]*string) *CreateWorkspaceInput {
	s.Tags = v
	return s
}

// Represents the output of a CreateWorkspace operation.
type CreateWorkspaceOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the workspace that was just created.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The status of the workspace that was just created (usually CREATING).
	//
	// Status is a required field
	Status *WorkspaceStatus `locationName:"status" type:"structure" required:"true"`

	// The tags of this workspace.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// The generated ID of the workspace that was just created.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspaceOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateWorkspaceOutput) SetArn(v string) *CreateWorkspaceOutput {
	s.Arn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateWorkspaceOutput) SetStatus(v *WorkspaceStatus) *CreateWorkspaceOutput {
	s.Status = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateWorkspaceOutput) SetTags(v map[string]*string) *CreateWorkspaceOutput {
	s.Tags = v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *CreateWorkspaceOutput) SetWorkspaceId(v string) *CreateWorkspaceOutput {
	s.WorkspaceId = &v
	return s
}

// Represents the input of a DeleteWorkspace operation.
type DeleteWorkspaceInput struct {
	_ struct{} `type:"structure"`

	// Optional, unique, case-sensitive, user-provided identifier to ensure the
	// idempotency of the request.
	ClientToken *string `location:"querystring" locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The ID of the workspace to delete.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkspaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkspaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteWorkspaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteWorkspaceInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *DeleteWorkspaceInput) SetClientToken(v string) *DeleteWorkspaceInput {
	s.ClientToken = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *DeleteWorkspaceInput) SetWorkspaceId(v string) *DeleteWorkspaceInput {
	s.WorkspaceId = &v
	return s
}

type DeleteWorkspaceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkspaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkspaceOutput) GoString() string {
	return s.String()
}

// Represents the input of a DescribeWorkspace operation.
type DescribeWorkspaceInput struct {
	_ struct{} `type:"structure"`

	// The ID of the workspace to describe.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkspaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkspaceInput"}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *DescribeWorkspaceInput) SetWorkspaceId(v string) *DescribeWorkspaceInput {
	s.WorkspaceId = &v
	return s
}

// Represents the output of a DescribeWorkspace operation.
type DescribeWorkspaceOutput struct {
	_ struct{} `type:"structure"`

	// The properties of the selected workspace.
	//
	// Workspace is a required field
	Workspace *WorkspaceDescription `locationName:"workspace" type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceOutput) GoString() string {
	return s.String()
}

// SetWorkspace sets the Workspace field's value.
func (s *DescribeWorkspaceOutput) SetWorkspace(v *WorkspaceDescription) *DescribeWorkspaceOutput {
	s.Workspace = v
	return s
}

// Unexpected error during processing of request.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Description of the error.
	Message_ *string `locationName:"message" type:"string"`

	// Advice to clients on when the call can be safely retried.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The list of tags assigned to the resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// Represents the input of a ListWorkspaces operation.
type ListWorkspacesInput struct {
	_ struct{} `type:"structure"`

	// Optional filter for workspace alias. Only the workspaces with aliases that
	// begin with this value will be returned.
	Alias *string `location:"querystring" locationName:"alias" min:"1" type:"string"`

	// Maximum results to return in response (default=100, maximum=1000).
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// Pagination token to request the next page in a paginated list. This token
	// is obtained from the output of the previous ListWorkspaces request.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkspacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListWorkspacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListWorkspacesInput"}
	if s.Alias != nil && len(*s.Alias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Alias", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlias sets the Alias field's value.
func (s *ListWorkspacesInput) SetAlias(v string) *ListWorkspacesInput {
	s.Alias = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListWorkspacesInput) SetMaxResults(v int64) *ListWorkspacesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkspacesInput) SetNextToken(v string) *ListWorkspacesInput {
	s.NextToken = &v
	return s
}

// Represents the output of a ListWorkspaces operation.
type ListWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// Pagination token to use when requesting the next page in this list.
	NextToken *string `locationName:"nextToken" type:"string"`

	// The list of existing workspaces, including those undergoing creation or deletion.
	//
	// Workspaces is a required field
	Workspaces []*WorkspaceSummary `locationName:"workspaces" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListWorkspacesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListWorkspacesOutput) SetNextToken(v string) *ListWorkspacesOutput {
	s.NextToken = &v
	return s
}

// SetWorkspaces sets the Workspaces field's value.
func (s *ListWorkspacesOutput) SetWorkspaces(v []*WorkspaceSummary) *ListWorkspacesOutput {
	s.Workspaces = v
	return s
}

// Request references a resource which does not exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Description of the error.
	Message_ *string `locationName:"message" type:"string"`

	// Identifier of the resource affected.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// Type of the resource affected.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Request would cause a service quota to be exceeded.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Description of the error.
	Message_ *string `locationName:"message" type:"string"`

	// Service Quotas requirement to identify originating quota.
	//
	// QuotaCode is a required field
	QuotaCode *string `locationName:"quotaCode" type:"string" required:"true"`

	// Identifier of the resource affected.
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" type:"string" required:"true"`

	// Type of the resource affected.
	//
	// ResourceType is a required field
	ResourceType *string `locationName:"resourceType" type:"string" required:"true"`

	// Service Quotas requirement to identify originating service.
	//
	// ServiceCode is a required field
	ServiceCode *string `locationName:"serviceCode" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// The list of tags assigned to the resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// Request was denied due to request throttling.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// Description of the error.
	Message_ *string `locationName:"message" type:"string"`

	// Service Quotas requirement to identify originating quota.
	QuotaCode *string `locationName:"quotaCode" type:"string"`

	// Advice to clients on when the call can be safely retried.
	RetryAfterSeconds *int64 `location:"header" locationName:"Retry-After" type:"integer"`

	// Service Quotas requirement to identify originating service.
	ServiceCode *string `locationName:"serviceCode" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" type:"string" required:"true"`

	// One or more tag keys
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

// Represents the input of an UpdateWorkspaceAlias operation.
type UpdateWorkspaceAliasInput struct {
	_ struct{} `type:"structure"`

	// The new alias of the workspace.
	Alias *string `locationName:"alias" min:"1" type:"string"`

	// Optional, unique, case-sensitive, user-provided identifier to ensure the
	// idempotency of the request.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The ID of the workspace being updated.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `location:"uri" locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspaceAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspaceAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateWorkspaceAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateWorkspaceAliasInput"}
	if s.Alias != nil && len(*s.Alias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Alias", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceId != nil && len(*s.WorkspaceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlias sets the Alias field's value.
func (s *UpdateWorkspaceAliasInput) SetAlias(v string) *UpdateWorkspaceAliasInput {
	s.Alias = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateWorkspaceAliasInput) SetClientToken(v string) *UpdateWorkspaceAliasInput {
	s.ClientToken = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *UpdateWorkspaceAliasInput) SetWorkspaceId(v string) *UpdateWorkspaceAliasInput {
	s.WorkspaceId = &v
	return s
}

type UpdateWorkspaceAliasOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspaceAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspaceAliasOutput) GoString() string {
	return s.String()
}

// The input fails to satisfy the constraints specified by an AWS service.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The field that caused the error, if applicable. If more than one field caused
	// the error, pick one and elaborate in the message.
	FieldList []*ValidationExceptionField `locationName:"fieldList" type:"list"`

	// Description of the error.
	Message_ *string `locationName:"message" type:"string"`

	// Reason the request failed validation.
	//
	// Reason is a required field
	Reason *string `locationName:"reason" type:"string" required:"true" enum:"ValidationExceptionReason"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Stores information about a field passed inside a request that resulted in
// an exception.
type ValidationExceptionField struct {
	_ struct{} `type:"structure"`

	// Message describing why the field failed validation.
	//
	// Message is a required field
	Message *string `locationName:"message" type:"string" required:"true"`

	// The field name.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationExceptionField) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ValidationExceptionField) SetMessage(v string) *ValidationExceptionField {
	s.Message = &v
	return s
}

// SetName sets the Name field's value.
func (s *ValidationExceptionField) SetName(v string) *ValidationExceptionField {
	s.Name = &v
	return s
}

// Represents the properties of a workspace.
type WorkspaceDescription struct {
	_ struct{} `type:"structure"`

	// Alias of this workspace.
	Alias *string `locationName:"alias" min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of this workspace.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time when the workspace was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// Prometheus endpoint URI.
	PrometheusEndpoint *string `locationName:"prometheusEndpoint" min:"1" type:"string"`

	// The status of this workspace.
	//
	// Status is a required field
	Status *WorkspaceStatus `locationName:"status" type:"structure" required:"true"`

	// The tags of this workspace.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// Unique string identifying this workspace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceDescription) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceDescription) GoString() string {
	return s.String()
}

// SetAlias sets the Alias field's value.
func (s *WorkspaceDescription) SetAlias(v string) *WorkspaceDescription {
	s.Alias = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *WorkspaceDescription) SetArn(v string) *WorkspaceDescription {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *WorkspaceDescription) SetCreatedAt(v time.Time) *WorkspaceDescription {
	s.CreatedAt = &v
	return s
}

// SetPrometheusEndpoint sets the PrometheusEndpoint field's value.
func (s *WorkspaceDescription) SetPrometheusEndpoint(v string) *WorkspaceDescription {
	s.PrometheusEndpoint = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *WorkspaceDescription) SetStatus(v *WorkspaceStatus) *WorkspaceDescription {
	s.Status = v
	return s
}

// SetTags sets the Tags field's value.
func (s *WorkspaceDescription) SetTags(v map[string]*string) *WorkspaceDescription {
	s.Tags = v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *WorkspaceDescription) SetWorkspaceId(v string) *WorkspaceDescription {
	s.WorkspaceId = &v
	return s
}

// Represents the status of a workspace.
type WorkspaceStatus struct {
	_ struct{} `type:"structure"`

	// Status code of this workspace.
	//
	// StatusCode is a required field
	StatusCode *string `locationName:"statusCode" type:"string" required:"true" enum:"WorkspaceStatusCode"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceStatus) GoString() string {
	return s.String()
}

// SetStatusCode sets the StatusCode field's value.
func (s *WorkspaceStatus) SetStatusCode(v string) *WorkspaceStatus {
	s.StatusCode = &v
	return s
}

// Represents a summary of the properties of a workspace.
type WorkspaceSummary struct {
	_ struct{} `type:"structure"`

	// Alias of this workspace.
	Alias *string `locationName:"alias" min:"1" type:"string"`

	// The AmazonResourceName of this workspace.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The time when the workspace was created.
	//
	// CreatedAt is a required field
	CreatedAt *time.Time `locationName:"createdAt" type:"timestamp" required:"true"`

	// The status of this workspace.
	//
	// Status is a required field
	Status *WorkspaceStatus `locationName:"status" type:"structure" required:"true"`

	// The tags of this workspace.
	Tags map[string]*string `locationName:"tags" type:"map"`

	// Unique string identifying this workspace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `locationName:"workspaceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceSummary) GoString() string {
	return s.String()
}

// SetAlias sets the Alias field's value.
func (s *WorkspaceSummary) SetAlias(v string) *WorkspaceSummary {
	s.Alias = &v
	return s
}

// SetArn sets the Arn field's value.
func (s *WorkspaceSummary) SetArn(v string) *WorkspaceSummary {
	s.Arn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *WorkspaceSummary) SetCreatedAt(v time.Time) *WorkspaceSummary {
	s.CreatedAt = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *WorkspaceSummary) SetStatus(v *WorkspaceStatus) *WorkspaceSummary {
	s.Status = v
	return s
}

// SetTags sets the Tags field's value.
func (s *WorkspaceSummary) SetTags(v map[string]*string) *WorkspaceSummary {
	s.Tags = v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *WorkspaceSummary) SetWorkspaceId(v string) *WorkspaceSummary {
	s.WorkspaceId = &v
	return s
}

// Possible reasons a request failed validation.
const (
	// ValidationExceptionReasonUnknownOperation is a ValidationExceptionReason enum value
	ValidationExceptionReasonUnknownOperation = "UNKNOWN_OPERATION"

	// ValidationExceptionReasonCannotParse is a ValidationExceptionReason enum value
	ValidationExceptionReasonCannotParse = "CANNOT_PARSE"

	// ValidationExceptionReasonFieldValidationFailed is a ValidationExceptionReason enum value
	ValidationExceptionReasonFieldValidationFailed = "FIELD_VALIDATION_FAILED"

	// ValidationExceptionReasonOther is a ValidationExceptionReason enum value
	ValidationExceptionReasonOther = "OTHER"
)

// ValidationExceptionReason_Values returns all elements of the ValidationExceptionReason enum
func ValidationExceptionReason_Values() []string {
	return []string{
		ValidationExceptionReasonUnknownOperation,
		ValidationExceptionReasonCannotParse,
		ValidationExceptionReasonFieldValidationFailed,
		ValidationExceptionReasonOther,
	}
}

// State of a workspace.
const (
	// WorkspaceStatusCodeCreating is a WorkspaceStatusCode enum value
	WorkspaceStatusCodeCreating = "CREATING"

	// WorkspaceStatusCodeActive is a WorkspaceStatusCode enum value
	WorkspaceStatusCodeActive = "ACTIVE"

	// WorkspaceStatusCodeUpdating is a WorkspaceStatusCode enum value
	WorkspaceStatusCodeUpdating = "UPDATING"

	// WorkspaceStatusCodeDeleting is a WorkspaceStatusCode enum value
	WorkspaceStatusCodeDeleting = "DELETING"

	// WorkspaceStatusCodeCreationFailed is a WorkspaceStatusCode enum value
	WorkspaceStatusCodeCreationFailed = "CREATION_FAILED"
)

// WorkspaceStatusCode_Values returns all elements of the WorkspaceStatusCode enum
func WorkspaceStatusCode_Values() []string {
	return []string{
		WorkspaceStatusCodeCreating,
		WorkspaceStatusCodeActive,
		WorkspaceStatusCodeUpdating,
		WorkspaceStatusCodeDeleting,
		WorkspaceStatusCodeCreationFailed,
	}
}
