// NOTE: Assertions have been autogenerated by utils/update_cc_test_checks.py UTC_ARGS: --include-generated-funcs --version 5
// RUN: %clang_cc1 -triple aarch64-none-linux-gnu -emit-llvm -o - %s | FileCheck %s

// Priority biskmasks after feature dependency expansion:
//
// MSB                                                    LSB
//
// sme2 | wfxt | sme | bf16 |       |      | fp16 | simd | fp
// -----+------+-----+------+-------+------+------+------+---
// sme2 |      | sme | bf16 | rcpc2 | rcpc | fp16 | simd | fp
//
// Dependencies should not affect priorities, since a
// feature can only depend on lower priority features:
// https://github.com/ARM-software/acle/pull/376

__attribute__((target_version("sme2+wfxt"))) int fn(void);
__attribute__((target_version("sme2+rcpc2"))) int fn(void);
__attribute__((target_version("default"))) int fn(void) { return 0; }

int call() { return fn(); }

// CHECK-LABEL: define dso_local i32 @fn.default(
// CHECK-SAME: ) #[[ATTR0:[0-9]+]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    ret i32 0
//
//
// CHECK-LABEL: define dso_local i32 @call(
// CHECK-SAME: ) #[[ATTR1:[0-9]+]] {
// CHECK-NEXT:  [[ENTRY:.*:]]
// CHECK-NEXT:    [[CALL:%.*]] = call i32 @fn()
// CHECK-NEXT:    ret i32 [[CALL]]
//
//
// CHECK-LABEL: define weak_odr ptr @fn.resolver() comdat {
// CHECK-NEXT:  [[RESOLVER_ENTRY:.*:]]
// CHECK-NEXT:    call void @__init_cpu_features_resolver()
// CHECK-NEXT:    [[TMP0:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP1:%.*]] = and i64 [[TMP0]], 162133984766132992
// CHECK-NEXT:    [[TMP2:%.*]] = icmp eq i64 [[TMP1]], 162133984766132992
// CHECK-NEXT:    [[TMP3:%.*]] = and i1 true, [[TMP2]]
// CHECK-NEXT:    br i1 [[TMP3]], label %[[RESOLVER_RETURN:.*]], label %[[RESOLVER_ELSE:.*]]
// CHECK:       [[RESOLVER_RETURN]]:
// CHECK-NEXT:    ret ptr @fn._Msme2Mwfxt
// CHECK:       [[RESOLVER_ELSE]]:
// CHECK-NEXT:    [[TMP4:%.*]] = load i64, ptr @__aarch64_cpu_features, align 8
// CHECK-NEXT:    [[TMP5:%.*]] = and i64 [[TMP4]], 144119586269233920
// CHECK-NEXT:    [[TMP6:%.*]] = icmp eq i64 [[TMP5]], 144119586269233920
// CHECK-NEXT:    [[TMP7:%.*]] = and i1 true, [[TMP6]]
// CHECK-NEXT:    br i1 [[TMP7]], label %[[RESOLVER_RETURN1:.*]], label %[[RESOLVER_ELSE2:.*]]
// CHECK:       [[RESOLVER_RETURN1]]:
// CHECK-NEXT:    ret ptr @fn._Mrcpc2Msme2
// CHECK:       [[RESOLVER_ELSE2]]:
// CHECK-NEXT:    ret ptr @fn.default
//
