// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.7
// source: google/bigtable/v2/peer_info.proto

package bigtablepb

import (
	reflect "reflect"
	sync "sync"

	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The transport type that the client used to connect to this peer.
type PeerInfo_TransportType int32

const (
	// The transport type is unknown.
	PeerInfo_TRANSPORT_TYPE_UNKNOWN PeerInfo_TransportType = 0
	// The client connected to this peer via an external network
	// (e.g. outside Google Coud).
	PeerInfo_TRANSPORT_TYPE_EXTERNAL PeerInfo_TransportType = 1
	// The client connected to this peer via CloudPath.
	PeerInfo_TRANSPORT_TYPE_CLOUD_PATH PeerInfo_TransportType = 2
	// The client connected to this peer via DirectAccess.
	PeerInfo_TRANSPORT_TYPE_DIRECT_ACCESS PeerInfo_TransportType = 3
	// The client connected to this peer via Bigtable Sessions using an unknown
	// transport type.
	PeerInfo_TRANSPORT_TYPE_SESSION_UNKNOWN PeerInfo_TransportType = 4
	// The client connected to this peer via Bigtable Sessions on an external
	// network (e.g. outside Google Cloud).
	PeerInfo_TRANSPORT_TYPE_SESSION_EXTERNAL PeerInfo_TransportType = 5
	// The client connected to this peer via Bigtable Sessions using CloudPath.
	PeerInfo_TRANSPORT_TYPE_SESSION_CLOUD_PATH PeerInfo_TransportType = 6
	// The client connected to this peer via Bigtable Sessions using
	// DirectAccess.
	PeerInfo_TRANSPORT_TYPE_SESSION_DIRECT_ACCESS PeerInfo_TransportType = 7
)

// Enum value maps for PeerInfo_TransportType.
var (
	PeerInfo_TransportType_name = map[int32]string{
		0: "TRANSPORT_TYPE_UNKNOWN",
		1: "TRANSPORT_TYPE_EXTERNAL",
		2: "TRANSPORT_TYPE_CLOUD_PATH",
		3: "TRANSPORT_TYPE_DIRECT_ACCESS",
		4: "TRANSPORT_TYPE_SESSION_UNKNOWN",
		5: "TRANSPORT_TYPE_SESSION_EXTERNAL",
		6: "TRANSPORT_TYPE_SESSION_CLOUD_PATH",
		7: "TRANSPORT_TYPE_SESSION_DIRECT_ACCESS",
	}
	PeerInfo_TransportType_value = map[string]int32{
		"TRANSPORT_TYPE_UNKNOWN":               0,
		"TRANSPORT_TYPE_EXTERNAL":              1,
		"TRANSPORT_TYPE_CLOUD_PATH":            2,
		"TRANSPORT_TYPE_DIRECT_ACCESS":         3,
		"TRANSPORT_TYPE_SESSION_UNKNOWN":       4,
		"TRANSPORT_TYPE_SESSION_EXTERNAL":      5,
		"TRANSPORT_TYPE_SESSION_CLOUD_PATH":    6,
		"TRANSPORT_TYPE_SESSION_DIRECT_ACCESS": 7,
	}
)

func (x PeerInfo_TransportType) Enum() *PeerInfo_TransportType {
	p := new(PeerInfo_TransportType)
	*p = x
	return p
}

func (x PeerInfo_TransportType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PeerInfo_TransportType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_bigtable_v2_peer_info_proto_enumTypes[0].Descriptor()
}

func (PeerInfo_TransportType) Type() protoreflect.EnumType {
	return &file_google_bigtable_v2_peer_info_proto_enumTypes[0]
}

func (x PeerInfo_TransportType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PeerInfo_TransportType.Descriptor instead.
func (PeerInfo_TransportType) EnumDescriptor() ([]byte, []int) {
	return file_google_bigtable_v2_peer_info_proto_rawDescGZIP(), []int{0, 0}
}

// PeerInfo contains information about the peer that the client is
// connecting to.
type PeerInfo struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An opaque identifier for the Google Frontend which serviced this request.
	// Only set when not using DirectAccess.
	GoogleFrontendId int64 `protobuf:"varint,1,opt,name=google_frontend_id,json=googleFrontendId,proto3" json:"google_frontend_id,omitempty"`
	// An opaque identifier for the application frontend which serviced this
	// request.
	ApplicationFrontendId int64 `protobuf:"varint,2,opt,name=application_frontend_id,json=applicationFrontendId,proto3" json:"application_frontend_id,omitempty"`
	// The Cloud zone of the application frontend that served this request.
	ApplicationFrontendZone string `protobuf:"bytes,3,opt,name=application_frontend_zone,json=applicationFrontendZone,proto3" json:"application_frontend_zone,omitempty"`
	// The subzone of the application frontend that served this request, e.g. an
	// identifier for where within the zone the application frontend is.
	ApplicationFrontendSubzone string                 `protobuf:"bytes,4,opt,name=application_frontend_subzone,json=applicationFrontendSubzone,proto3" json:"application_frontend_subzone,omitempty"`
	TransportType              PeerInfo_TransportType `protobuf:"varint,5,opt,name=transport_type,json=transportType,proto3,enum=google.bigtable.v2.PeerInfo_TransportType" json:"transport_type,omitempty"`
}

func (x *PeerInfo) Reset() {
	*x = PeerInfo{}
	mi := &file_google_bigtable_v2_peer_info_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PeerInfo) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PeerInfo) ProtoMessage() {}

func (x *PeerInfo) ProtoReflect() protoreflect.Message {
	mi := &file_google_bigtable_v2_peer_info_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PeerInfo.ProtoReflect.Descriptor instead.
func (*PeerInfo) Descriptor() ([]byte, []int) {
	return file_google_bigtable_v2_peer_info_proto_rawDescGZIP(), []int{0}
}

func (x *PeerInfo) GetGoogleFrontendId() int64 {
	if x != nil {
		return x.GoogleFrontendId
	}
	return 0
}

func (x *PeerInfo) GetApplicationFrontendId() int64 {
	if x != nil {
		return x.ApplicationFrontendId
	}
	return 0
}

func (x *PeerInfo) GetApplicationFrontendZone() string {
	if x != nil {
		return x.ApplicationFrontendZone
	}
	return ""
}

func (x *PeerInfo) GetApplicationFrontendSubzone() string {
	if x != nil {
		return x.ApplicationFrontendSubzone
	}
	return ""
}

func (x *PeerInfo) GetTransportType() PeerInfo_TransportType {
	if x != nil {
		return x.TransportType
	}
	return PeerInfo_TRANSPORT_TYPE_UNKNOWN
}

var File_google_bigtable_v2_peer_info_proto protoreflect.FileDescriptor

var file_google_bigtable_v2_peer_info_proto_rawDesc = []byte{
	0x0a, 0x22, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x2f, 0x76, 0x32, 0x2f, 0x70, 0x65, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x12, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67,
	0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x22, 0xe7, 0x04, 0x0a, 0x08, 0x50, 0x65, 0x65,
	0x72, 0x49, 0x6e, 0x66, 0x6f, 0x12, 0x2c, 0x0a, 0x12, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5f,
	0x66, 0x72, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x10, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x46, 0x72, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x64, 0x49, 0x64, 0x12, 0x36, 0x0a, 0x17, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x66, 0x72, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x5f, 0x69, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x15, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x46, 0x72, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x49, 0x64, 0x12, 0x3a, 0x0a, 0x19, 0x61,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x72, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x64, 0x5f, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x17,
	0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x72, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x64, 0x5a, 0x6f, 0x6e, 0x65, 0x12, 0x40, 0x0a, 0x1c, 0x61, 0x70, 0x70, 0x6c, 0x69,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x66, 0x72, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x5f,
	0x73, 0x75, 0x62, 0x7a, 0x6f, 0x6e, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x1a, 0x61,
	0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x72, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x64, 0x53, 0x75, 0x62, 0x7a, 0x6f, 0x6e, 0x65, 0x12, 0x51, 0x0a, 0x0e, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61,
	0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x2e, 0x50, 0x65, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x2e,
	0x54, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0d, 0x74,
	0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x79, 0x70, 0x65, 0x22, 0xa3, 0x02, 0x0a,
	0x0d, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1a,
	0x0a, 0x16, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45,
	0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x1b, 0x0a, 0x17, 0x54, 0x52,
	0x41, 0x4e, 0x53, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x45, 0x58, 0x54,
	0x45, 0x52, 0x4e, 0x41, 0x4c, 0x10, 0x01, 0x12, 0x1d, 0x0a, 0x19, 0x54, 0x52, 0x41, 0x4e, 0x53,
	0x50, 0x4f, 0x52, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f,
	0x50, 0x41, 0x54, 0x48, 0x10, 0x02, 0x12, 0x20, 0x0a, 0x1c, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x50,
	0x4f, 0x52, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x5f,
	0x41, 0x43, 0x43, 0x45, 0x53, 0x53, 0x10, 0x03, 0x12, 0x22, 0x0a, 0x1e, 0x54, 0x52, 0x41, 0x4e,
	0x53, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x45, 0x53, 0x53, 0x49,
	0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x04, 0x12, 0x23, 0x0a, 0x1f,
	0x54, 0x52, 0x41, 0x4e, 0x53, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53,
	0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x45, 0x58, 0x54, 0x45, 0x52, 0x4e, 0x41, 0x4c, 0x10,
	0x05, 0x12, 0x25, 0x0a, 0x21, 0x54, 0x52, 0x41, 0x4e, 0x53, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x53, 0x45, 0x53, 0x53, 0x49, 0x4f, 0x4e, 0x5f, 0x43, 0x4c, 0x4f, 0x55,
	0x44, 0x5f, 0x50, 0x41, 0x54, 0x48, 0x10, 0x06, 0x12, 0x28, 0x0a, 0x24, 0x54, 0x52, 0x41, 0x4e,
	0x53, 0x50, 0x4f, 0x52, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53, 0x45, 0x53, 0x53, 0x49,
	0x4f, 0x4e, 0x5f, 0x44, 0x49, 0x52, 0x45, 0x43, 0x54, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53, 0x53,
	0x10, 0x07, 0x42, 0xb7, 0x01, 0x0a, 0x16, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x76, 0x32, 0x42, 0x0d, 0x50,
	0x65, 0x65, 0x72, 0x49, 0x6e, 0x66, 0x6f, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x38,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x67, 0x6f, 0x2f, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69,
	0x76, 0x32, 0x2f, 0x62, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x70, 0x62, 0x3b, 0x62, 0x69,
	0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x70, 0x62, 0xaa, 0x02, 0x18, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x42, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x2e, 0x56, 0x32, 0xca, 0x02, 0x18, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x5c, 0x42, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5c, 0x56, 0x32, 0xea, 0x02,
	0x1b, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a,
	0x42, 0x69, 0x67, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x3a, 0x3a, 0x56, 0x32, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_bigtable_v2_peer_info_proto_rawDescOnce sync.Once
	file_google_bigtable_v2_peer_info_proto_rawDescData = file_google_bigtable_v2_peer_info_proto_rawDesc
)

func file_google_bigtable_v2_peer_info_proto_rawDescGZIP() []byte {
	file_google_bigtable_v2_peer_info_proto_rawDescOnce.Do(func() {
		file_google_bigtable_v2_peer_info_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_bigtable_v2_peer_info_proto_rawDescData)
	})
	return file_google_bigtable_v2_peer_info_proto_rawDescData
}

var file_google_bigtable_v2_peer_info_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_bigtable_v2_peer_info_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_bigtable_v2_peer_info_proto_goTypes = []any{
	(PeerInfo_TransportType)(0), // 0: google.bigtable.v2.PeerInfo.TransportType
	(*PeerInfo)(nil),            // 1: google.bigtable.v2.PeerInfo
}
var file_google_bigtable_v2_peer_info_proto_depIdxs = []int32{
	0, // 0: google.bigtable.v2.PeerInfo.transport_type:type_name -> google.bigtable.v2.PeerInfo.TransportType
	1, // [1:1] is the sub-list for method output_type
	1, // [1:1] is the sub-list for method input_type
	1, // [1:1] is the sub-list for extension type_name
	1, // [1:1] is the sub-list for extension extendee
	0, // [0:1] is the sub-list for field type_name
}

func init() { file_google_bigtable_v2_peer_info_proto_init() }
func file_google_bigtable_v2_peer_info_proto_init() {
	if File_google_bigtable_v2_peer_info_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_bigtable_v2_peer_info_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_bigtable_v2_peer_info_proto_goTypes,
		DependencyIndexes: file_google_bigtable_v2_peer_info_proto_depIdxs,
		EnumInfos:         file_google_bigtable_v2_peer_info_proto_enumTypes,
		MessageInfos:      file_google_bigtable_v2_peer_info_proto_msgTypes,
	}.Build()
	File_google_bigtable_v2_peer_info_proto = out.File
	file_google_bigtable_v2_peer_info_proto_rawDesc = nil
	file_google_bigtable_v2_peer_info_proto_goTypes = nil
	file_google_bigtable_v2_peer_info_proto_depIdxs = nil
}
