package stripe

// Currency is the list of supported currencies.
// For more details see https://support.stripe.com/questions/which-currencies-does-stripe-support.
type Currency string

// List of values that Currency can take.
const (
	CurrencyAED Currency = "aed" // United Arab Emirates Dirham
	CurrencyAFN Currency = "afn" // Afghan Afghani
	CurrencyALL Currency = "all" // Albanian Lek
	CurrencyAMD Currency = "amd" // Armenian Dram
	CurrencyANG Currency = "ang" // Netherlands Antillean Gulden
	CurrencyAOA Currency = "aoa" // Angolan Kwanza
	CurrencyARS Currency = "ars" // Argentine Peso
	CurrencyAUD Currency = "aud" // Australian Dollar
	CurrencyAWG Currency = "awg" // Aruban Florin
	CurrencyAZN Currency = "azn" // Azerbaijani Manat
	CurrencyBAM Currency = "bam" // Bosnia & Herzegovina Convertible Mark
	CurrencyBBD Currency = "bbd" // Barbadian Dollar
	CurrencyBDT Currency = "bdt" // Bangladeshi Taka
	CurrencyBGN Currency = "bgn" // Bulgarian Lev
	CurrencyBIF Currency = "bif" // Burundian Franc
	CurrencyBMD Currency = "bmd" // Bermudian Dollar
	CurrencyBND Currency = "bnd" // Brunei Dollar
	CurrencyBOB Currency = "bob" // Bolivian Boliviano
	CurrencyBRL Currency = "brl" // Brazilian Real
	CurrencyBSD Currency = "bsd" // Bahamian Dollar
	CurrencyBWP Currency = "bwp" // Botswana Pula
	CurrencyBZD Currency = "bzd" // Belize Dollar
	CurrencyCAD Currency = "cad" // Canadian Dollar
	CurrencyCDF Currency = "cdf" // Congolese Franc
	CurrencyCHF Currency = "chf" // Swiss Franc
	CurrencyCLP Currency = "clp" // Chilean Peso
	CurrencyCNY Currency = "cny" // Chinese Renminbi Yuan
	CurrencyCOP Currency = "cop" // Colombian Peso
	CurrencyCRC Currency = "crc" // Costa Rican Colón
	CurrencyCVE Currency = "cve" // Cape Verdean Escudo
	CurrencyCZK Currency = "czk" // Czech Koruna
	CurrencyDJF Currency = "djf" // Djiboutian Franc
	CurrencyDKK Currency = "dkk" // Danish Krone
	CurrencyDOP Currency = "dop" // Dominican Peso
	CurrencyDZD Currency = "dzd" // Algerian Dinar
	CurrencyEEK Currency = "eek" // Estonian Kroon
	CurrencyEGP Currency = "egp" // Egyptian Pound
	CurrencyETB Currency = "etb" // Ethiopian Birr
	CurrencyEUR Currency = "eur" // Euro
	CurrencyFJD Currency = "fjd" // Fijian Dollar
	CurrencyFKP Currency = "fkp" // Falkland Islands Pound
	CurrencyGBP Currency = "gbp" // British Pound
	CurrencyGEL Currency = "gel" // Georgian Lari
	CurrencyGIP Currency = "gip" // Gibraltar Pound
	CurrencyGMD Currency = "gmd" // Gambian Dalasi
	CurrencyGNF Currency = "gnf" // Guinean Franc
	CurrencyGTQ Currency = "gtq" // Guatemalan Quetzal
	CurrencyGYD Currency = "gyd" // Guyanese Dollar
	CurrencyHKD Currency = "hkd" // Hong Kong Dollar
	CurrencyHNL Currency = "hnl" // Honduran Lempira
	CurrencyHRK Currency = "hrk" // Croatian Kuna
	CurrencyHTG Currency = "htg" // Haitian Gourde
	CurrencyHUF Currency = "huf" // Hungarian Forint
	CurrencyIDR Currency = "idr" // Indonesian Rupiah
	CurrencyILS Currency = "ils" // Israeli New Sheqel
	CurrencyINR Currency = "inr" // Indian Rupee
	CurrencyISK Currency = "isk" // Icelandic Króna
	CurrencyJMD Currency = "jmd" // Jamaican Dollar
	CurrencyJPY Currency = "jpy" // Japanese Yen
	CurrencyKES Currency = "kes" // Kenyan Shilling
	CurrencyKGS Currency = "kgs" // Kyrgyzstani Som
	CurrencyKHR Currency = "khr" // Cambodian Riel
	CurrencyKMF Currency = "kmf" // Comorian Franc
	CurrencyKRW Currency = "krw" // South Korean Won
	CurrencyKYD Currency = "kyd" // Cayman Islands Dollar
	CurrencyKZT Currency = "kzt" // Kazakhstani Tenge
	CurrencyLAK Currency = "lak" // Lao Kip
	CurrencyLBP Currency = "lbp" // Lebanese Pound
	CurrencyLKR Currency = "lkr" // Sri Lankan Rupee
	CurrencyLRD Currency = "lrd" // Liberian Dollar
	CurrencyLSL Currency = "lsl" // Lesotho Loti
	CurrencyLTL Currency = "ltl" // Lithuanian Litas
	CurrencyLVL Currency = "lvl" // Latvian Lats
	CurrencyMAD Currency = "mad" // Moroccan Dirham
	CurrencyMDL Currency = "mdl" // Moldovan Leu
	CurrencyMGA Currency = "mga" // Malagasy Ariary
	CurrencyMKD Currency = "mkd" // Macedonian Denar
	CurrencyMNT Currency = "mnt" // Mongolian Tögrög
	CurrencyMOP Currency = "mop" // Macanese Pataca
	CurrencyMRO Currency = "mro" // Mauritanian Ouguiya
	CurrencyMUR Currency = "mur" // Mauritian Rupee
	CurrencyMVR Currency = "mvr" // Maldivian Rufiyaa
	CurrencyMWK Currency = "mwk" // Malawian Kwacha
	CurrencyMXN Currency = "mxn" // Mexican Peso
	CurrencyMYR Currency = "myr" // Malaysian Ringgit
	CurrencyMZN Currency = "mzn" // Mozambican Metical
	CurrencyNAD Currency = "nad" // Namibian Dollar
	CurrencyNGN Currency = "ngn" // Nigerian Naira
	CurrencyNIO Currency = "nio" // Nicaraguan Córdoba
	CurrencyNOK Currency = "nok" // Norwegian Krone
	CurrencyNPR Currency = "npr" // Nepalese Rupee
	CurrencyNZD Currency = "nzd" // New Zealand Dollar
	CurrencyPAB Currency = "pab" // Panamanian Balboa
	CurrencyPEN Currency = "pen" // Peruvian Nuevo Sol
	CurrencyPGK Currency = "pgk" // Papua New Guinean Kina
	CurrencyPHP Currency = "php" // Philippine Peso
	CurrencyPKR Currency = "pkr" // Pakistani Rupee
	CurrencyPLN Currency = "pln" // Polish Złoty
	CurrencyPYG Currency = "pyg" // Paraguayan Guaraní
	CurrencyQAR Currency = "qar" // Qatari Riyal
	CurrencyRON Currency = "ron" // Romanian Leu
	CurrencyRSD Currency = "rsd" // Serbian Dinar
	CurrencyRUB Currency = "rub" // Russian Ruble
	CurrencyRWF Currency = "rwf" // Rwandan Franc
	CurrencySAR Currency = "sar" // Saudi Riyal
	CurrencySBD Currency = "sbd" // Solomon Islands Dollar
	CurrencySCR Currency = "scr" // Seychellois Rupee
	CurrencySEK Currency = "sek" // Swedish Krona
	CurrencySGD Currency = "sgd" // Singapore Dollar
	CurrencySHP Currency = "shp" // Saint Helenian Pound
	CurrencySLL Currency = "sll" // Sierra Leonean Leone
	CurrencySOS Currency = "sos" // Somali Shilling
	CurrencySRD Currency = "srd" // Surinamese Dollar
	CurrencySTD Currency = "std" // São Tomé and Príncipe Dobra
	CurrencySVC Currency = "svc" // Salvadoran Colón
	CurrencySZL Currency = "szl" // Swazi Lilangeni
	CurrencyTHB Currency = "thb" // Thai Baht
	CurrencyTJS Currency = "tjs" // Tajikistani Somoni
	CurrencyTOP Currency = "top" // Tongan Paʻanga
	CurrencyTRY Currency = "try" // Turkish Lira
	CurrencyTTD Currency = "ttd" // Trinidad and Tobago Dollar
	CurrencyTWD Currency = "twd" // New Taiwan Dollar
	CurrencyTZS Currency = "tzs" // Tanzanian Shilling
	CurrencyUAH Currency = "uah" // Ukrainian Hryvnia
	CurrencyUGX Currency = "ugx" // Ugandan Shilling
	CurrencyUSD Currency = "usd" // United States Dollar
	CurrencyUYU Currency = "uyu" // Uruguayan Peso
	CurrencyUZS Currency = "uzs" // Uzbekistani Som
	CurrencyVEF Currency = "vef" // Venezuelan Bolívar
	CurrencyVND Currency = "vnd" // Vietnamese Đồng
	CurrencyVUV Currency = "vuv" // Vanuatu Vatu
	CurrencyWST Currency = "wst" // Samoan Tala
	CurrencyXAF Currency = "xaf" // Central African Cfa Franc
	CurrencyXCD Currency = "xcd" // East Caribbean Dollar
	CurrencyXOF Currency = "xof" // West African Cfa Franc
	CurrencyXPF Currency = "xpf" // Cfp Franc
	CurrencyYER Currency = "yer" // Yemeni Rial
	CurrencyZAR Currency = "zar" // South African Rand
	CurrencyZMW Currency = "zmw" // Zambian Kwacha
)
