// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the disco-to-proto3-converter. DO NOT EDIT!
// Source Discovery file: compute.v1beta.json
// Source file revision: 20250916
// API name: compute
// API version: v1beta

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/compute/v1beta/compute.proto

package computepb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	AcceleratorTypes_AggregatedList_FullMethodName = "/google.cloud.compute.v1beta.AcceleratorTypes/AggregatedList"
	AcceleratorTypes_Get_FullMethodName            = "/google.cloud.compute.v1beta.AcceleratorTypes/Get"
	AcceleratorTypes_List_FullMethodName           = "/google.cloud.compute.v1beta.AcceleratorTypes/List"
)

// AcceleratorTypesClient is the client API for AcceleratorTypes service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type AcceleratorTypesClient interface {
	// Retrieves an aggregated list of accelerator types. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(ctx context.Context, in *AggregatedListAcceleratorTypesRequest, opts ...grpc.CallOption) (*AcceleratorTypeAggregatedList, error)
	// Returns the specified accelerator type.
	Get(ctx context.Context, in *GetAcceleratorTypeRequest, opts ...grpc.CallOption) (*AcceleratorType, error)
	// Retrieves a list of accelerator types that are available to the specified project.
	List(ctx context.Context, in *ListAcceleratorTypesRequest, opts ...grpc.CallOption) (*AcceleratorTypeList, error)
}

type acceleratorTypesClient struct {
	cc grpc.ClientConnInterface
}

func NewAcceleratorTypesClient(cc grpc.ClientConnInterface) AcceleratorTypesClient {
	return &acceleratorTypesClient{cc}
}

func (c *acceleratorTypesClient) AggregatedList(ctx context.Context, in *AggregatedListAcceleratorTypesRequest, opts ...grpc.CallOption) (*AcceleratorTypeAggregatedList, error) {
	out := new(AcceleratorTypeAggregatedList)
	err := c.cc.Invoke(ctx, AcceleratorTypes_AggregatedList_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *acceleratorTypesClient) Get(ctx context.Context, in *GetAcceleratorTypeRequest, opts ...grpc.CallOption) (*AcceleratorType, error) {
	out := new(AcceleratorType)
	err := c.cc.Invoke(ctx, AcceleratorTypes_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *acceleratorTypesClient) List(ctx context.Context, in *ListAcceleratorTypesRequest, opts ...grpc.CallOption) (*AcceleratorTypeList, error) {
	out := new(AcceleratorTypeList)
	err := c.cc.Invoke(ctx, AcceleratorTypes_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AcceleratorTypesServer is the server API for AcceleratorTypes service.
// All implementations should embed UnimplementedAcceleratorTypesServer
// for forward compatibility
type AcceleratorTypesServer interface {
	// Retrieves an aggregated list of accelerator types. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(context.Context, *AggregatedListAcceleratorTypesRequest) (*AcceleratorTypeAggregatedList, error)
	// Returns the specified accelerator type.
	Get(context.Context, *GetAcceleratorTypeRequest) (*AcceleratorType, error)
	// Retrieves a list of accelerator types that are available to the specified project.
	List(context.Context, *ListAcceleratorTypesRequest) (*AcceleratorTypeList, error)
}

// UnimplementedAcceleratorTypesServer should be embedded to have forward compatible implementations.
type UnimplementedAcceleratorTypesServer struct {
}

func (UnimplementedAcceleratorTypesServer) AggregatedList(context.Context, *AggregatedListAcceleratorTypesRequest) (*AcceleratorTypeAggregatedList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AggregatedList not implemented")
}
func (UnimplementedAcceleratorTypesServer) Get(context.Context, *GetAcceleratorTypeRequest) (*AcceleratorType, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedAcceleratorTypesServer) List(context.Context, *ListAcceleratorTypesRequest) (*AcceleratorTypeList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}

// UnsafeAcceleratorTypesServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to AcceleratorTypesServer will
// result in compilation errors.
type UnsafeAcceleratorTypesServer interface {
	mustEmbedUnimplementedAcceleratorTypesServer()
}

func RegisterAcceleratorTypesServer(s grpc.ServiceRegistrar, srv AcceleratorTypesServer) {
	s.RegisterService(&AcceleratorTypes_ServiceDesc, srv)
}

func _AcceleratorTypes_AggregatedList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AggregatedListAcceleratorTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AcceleratorTypesServer).AggregatedList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AcceleratorTypes_AggregatedList_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AcceleratorTypesServer).AggregatedList(ctx, req.(*AggregatedListAcceleratorTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AcceleratorTypes_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAcceleratorTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AcceleratorTypesServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AcceleratorTypes_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AcceleratorTypesServer).Get(ctx, req.(*GetAcceleratorTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _AcceleratorTypes_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAcceleratorTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AcceleratorTypesServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: AcceleratorTypes_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AcceleratorTypesServer).List(ctx, req.(*ListAcceleratorTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// AcceleratorTypes_ServiceDesc is the grpc.ServiceDesc for AcceleratorTypes service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var AcceleratorTypes_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.AcceleratorTypes",
	HandlerType: (*AcceleratorTypesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AggregatedList",
			Handler:    _AcceleratorTypes_AggregatedList_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _AcceleratorTypes_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _AcceleratorTypes_List_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	Addresses_AggregatedList_FullMethodName     = "/google.cloud.compute.v1beta.Addresses/AggregatedList"
	Addresses_Delete_FullMethodName             = "/google.cloud.compute.v1beta.Addresses/Delete"
	Addresses_Get_FullMethodName                = "/google.cloud.compute.v1beta.Addresses/Get"
	Addresses_Insert_FullMethodName             = "/google.cloud.compute.v1beta.Addresses/Insert"
	Addresses_List_FullMethodName               = "/google.cloud.compute.v1beta.Addresses/List"
	Addresses_Move_FullMethodName               = "/google.cloud.compute.v1beta.Addresses/Move"
	Addresses_SetLabels_FullMethodName          = "/google.cloud.compute.v1beta.Addresses/SetLabels"
	Addresses_TestIamPermissions_FullMethodName = "/google.cloud.compute.v1beta.Addresses/TestIamPermissions"
)

// AddressesClient is the client API for Addresses service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type AddressesClient interface {
	// Retrieves an aggregated list of addresses. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(ctx context.Context, in *AggregatedListAddressesRequest, opts ...grpc.CallOption) (*AddressAggregatedList, error)
	// Deletes the specified address resource.
	Delete(ctx context.Context, in *DeleteAddressRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns the specified address resource.
	Get(ctx context.Context, in *GetAddressRequest, opts ...grpc.CallOption) (*Address, error)
	// Creates an address resource in the specified project by using the data included in the request.
	Insert(ctx context.Context, in *InsertAddressRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves a list of addresses contained within the specified region.
	List(ctx context.Context, in *ListAddressesRequest, opts ...grpc.CallOption) (*AddressList, error)
	// Moves the specified address resource.
	Move(ctx context.Context, in *MoveAddressRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the labels on an Address. To learn more about labels, read the Labeling Resources documentation.
	SetLabels(ctx context.Context, in *SetLabelsAddressRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(ctx context.Context, in *TestIamPermissionsAddressRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error)
}

type addressesClient struct {
	cc grpc.ClientConnInterface
}

func NewAddressesClient(cc grpc.ClientConnInterface) AddressesClient {
	return &addressesClient{cc}
}

func (c *addressesClient) AggregatedList(ctx context.Context, in *AggregatedListAddressesRequest, opts ...grpc.CallOption) (*AddressAggregatedList, error) {
	out := new(AddressAggregatedList)
	err := c.cc.Invoke(ctx, Addresses_AggregatedList_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *addressesClient) Delete(ctx context.Context, in *DeleteAddressRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Addresses_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *addressesClient) Get(ctx context.Context, in *GetAddressRequest, opts ...grpc.CallOption) (*Address, error) {
	out := new(Address)
	err := c.cc.Invoke(ctx, Addresses_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *addressesClient) Insert(ctx context.Context, in *InsertAddressRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Addresses_Insert_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *addressesClient) List(ctx context.Context, in *ListAddressesRequest, opts ...grpc.CallOption) (*AddressList, error) {
	out := new(AddressList)
	err := c.cc.Invoke(ctx, Addresses_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *addressesClient) Move(ctx context.Context, in *MoveAddressRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Addresses_Move_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *addressesClient) SetLabels(ctx context.Context, in *SetLabelsAddressRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Addresses_SetLabels_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *addressesClient) TestIamPermissions(ctx context.Context, in *TestIamPermissionsAddressRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error) {
	out := new(TestPermissionsResponse)
	err := c.cc.Invoke(ctx, Addresses_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AddressesServer is the server API for Addresses service.
// All implementations should embed UnimplementedAddressesServer
// for forward compatibility
type AddressesServer interface {
	// Retrieves an aggregated list of addresses. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(context.Context, *AggregatedListAddressesRequest) (*AddressAggregatedList, error)
	// Deletes the specified address resource.
	Delete(context.Context, *DeleteAddressRequest) (*Operation, error)
	// Returns the specified address resource.
	Get(context.Context, *GetAddressRequest) (*Address, error)
	// Creates an address resource in the specified project by using the data included in the request.
	Insert(context.Context, *InsertAddressRequest) (*Operation, error)
	// Retrieves a list of addresses contained within the specified region.
	List(context.Context, *ListAddressesRequest) (*AddressList, error)
	// Moves the specified address resource.
	Move(context.Context, *MoveAddressRequest) (*Operation, error)
	// Sets the labels on an Address. To learn more about labels, read the Labeling Resources documentation.
	SetLabels(context.Context, *SetLabelsAddressRequest) (*Operation, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(context.Context, *TestIamPermissionsAddressRequest) (*TestPermissionsResponse, error)
}

// UnimplementedAddressesServer should be embedded to have forward compatible implementations.
type UnimplementedAddressesServer struct {
}

func (UnimplementedAddressesServer) AggregatedList(context.Context, *AggregatedListAddressesRequest) (*AddressAggregatedList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AggregatedList not implemented")
}
func (UnimplementedAddressesServer) Delete(context.Context, *DeleteAddressRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedAddressesServer) Get(context.Context, *GetAddressRequest) (*Address, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedAddressesServer) Insert(context.Context, *InsertAddressRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (UnimplementedAddressesServer) List(context.Context, *ListAddressesRequest) (*AddressList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedAddressesServer) Move(context.Context, *MoveAddressRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Move not implemented")
}
func (UnimplementedAddressesServer) SetLabels(context.Context, *SetLabelsAddressRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetLabels not implemented")
}
func (UnimplementedAddressesServer) TestIamPermissions(context.Context, *TestIamPermissionsAddressRequest) (*TestPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

// UnsafeAddressesServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to AddressesServer will
// result in compilation errors.
type UnsafeAddressesServer interface {
	mustEmbedUnimplementedAddressesServer()
}

func RegisterAddressesServer(s grpc.ServiceRegistrar, srv AddressesServer) {
	s.RegisterService(&Addresses_ServiceDesc, srv)
}

func _Addresses_AggregatedList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AggregatedListAddressesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AddressesServer).AggregatedList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Addresses_AggregatedList_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AddressesServer).AggregatedList(ctx, req.(*AggregatedListAddressesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Addresses_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAddressRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AddressesServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Addresses_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AddressesServer).Delete(ctx, req.(*DeleteAddressRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Addresses_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAddressRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AddressesServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Addresses_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AddressesServer).Get(ctx, req.(*GetAddressRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Addresses_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertAddressRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AddressesServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Addresses_Insert_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AddressesServer).Insert(ctx, req.(*InsertAddressRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Addresses_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAddressesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AddressesServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Addresses_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AddressesServer).List(ctx, req.(*ListAddressesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Addresses_Move_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MoveAddressRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AddressesServer).Move(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Addresses_Move_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AddressesServer).Move(ctx, req.(*MoveAddressRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Addresses_SetLabels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetLabelsAddressRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AddressesServer).SetLabels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Addresses_SetLabels_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AddressesServer).SetLabels(ctx, req.(*SetLabelsAddressRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Addresses_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TestIamPermissionsAddressRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AddressesServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Addresses_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AddressesServer).TestIamPermissions(ctx, req.(*TestIamPermissionsAddressRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Addresses_ServiceDesc is the grpc.ServiceDesc for Addresses service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Addresses_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.Addresses",
	HandlerType: (*AddressesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AggregatedList",
			Handler:    _Addresses_AggregatedList_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _Addresses_Delete_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _Addresses_Get_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _Addresses_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _Addresses_List_Handler,
		},
		{
			MethodName: "Move",
			Handler:    _Addresses_Move_Handler,
		},
		{
			MethodName: "SetLabels",
			Handler:    _Addresses_SetLabels_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _Addresses_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	Advice_CalendarMode_FullMethodName = "/google.cloud.compute.v1beta.Advice/CalendarMode"
)

// AdviceClient is the client API for Advice service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type AdviceClient interface {
	// Advise how, where and when to create the requested amount of instances with specified accelerators, within the specified time and location limits. The method recommends creating future reservations for the requested resources.
	CalendarMode(ctx context.Context, in *CalendarModeAdviceRpcRequest, opts ...grpc.CallOption) (*CalendarModeAdviceResponse, error)
}

type adviceClient struct {
	cc grpc.ClientConnInterface
}

func NewAdviceClient(cc grpc.ClientConnInterface) AdviceClient {
	return &adviceClient{cc}
}

func (c *adviceClient) CalendarMode(ctx context.Context, in *CalendarModeAdviceRpcRequest, opts ...grpc.CallOption) (*CalendarModeAdviceResponse, error) {
	out := new(CalendarModeAdviceResponse)
	err := c.cc.Invoke(ctx, Advice_CalendarMode_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AdviceServer is the server API for Advice service.
// All implementations should embed UnimplementedAdviceServer
// for forward compatibility
type AdviceServer interface {
	// Advise how, where and when to create the requested amount of instances with specified accelerators, within the specified time and location limits. The method recommends creating future reservations for the requested resources.
	CalendarMode(context.Context, *CalendarModeAdviceRpcRequest) (*CalendarModeAdviceResponse, error)
}

// UnimplementedAdviceServer should be embedded to have forward compatible implementations.
type UnimplementedAdviceServer struct {
}

func (UnimplementedAdviceServer) CalendarMode(context.Context, *CalendarModeAdviceRpcRequest) (*CalendarModeAdviceResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CalendarMode not implemented")
}

// UnsafeAdviceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to AdviceServer will
// result in compilation errors.
type UnsafeAdviceServer interface {
	mustEmbedUnimplementedAdviceServer()
}

func RegisterAdviceServer(s grpc.ServiceRegistrar, srv AdviceServer) {
	s.RegisterService(&Advice_ServiceDesc, srv)
}

func _Advice_CalendarMode_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CalendarModeAdviceRpcRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AdviceServer).CalendarMode(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Advice_CalendarMode_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AdviceServer).CalendarMode(ctx, req.(*CalendarModeAdviceRpcRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Advice_ServiceDesc is the grpc.ServiceDesc for Advice service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Advice_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.Advice",
	HandlerType: (*AdviceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CalendarMode",
			Handler:    _Advice_CalendarMode_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	Autoscalers_AggregatedList_FullMethodName     = "/google.cloud.compute.v1beta.Autoscalers/AggregatedList"
	Autoscalers_Delete_FullMethodName             = "/google.cloud.compute.v1beta.Autoscalers/Delete"
	Autoscalers_Get_FullMethodName                = "/google.cloud.compute.v1beta.Autoscalers/Get"
	Autoscalers_Insert_FullMethodName             = "/google.cloud.compute.v1beta.Autoscalers/Insert"
	Autoscalers_List_FullMethodName               = "/google.cloud.compute.v1beta.Autoscalers/List"
	Autoscalers_Patch_FullMethodName              = "/google.cloud.compute.v1beta.Autoscalers/Patch"
	Autoscalers_TestIamPermissions_FullMethodName = "/google.cloud.compute.v1beta.Autoscalers/TestIamPermissions"
	Autoscalers_Update_FullMethodName             = "/google.cloud.compute.v1beta.Autoscalers/Update"
)

// AutoscalersClient is the client API for Autoscalers service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type AutoscalersClient interface {
	// Retrieves an aggregated list of autoscalers. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(ctx context.Context, in *AggregatedListAutoscalersRequest, opts ...grpc.CallOption) (*AutoscalerAggregatedList, error)
	// Deletes the specified autoscaler.
	Delete(ctx context.Context, in *DeleteAutoscalerRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns the specified autoscaler resource.
	Get(ctx context.Context, in *GetAutoscalerRequest, opts ...grpc.CallOption) (*Autoscaler, error)
	// Creates an autoscaler in the specified project using the data included in the request.
	Insert(ctx context.Context, in *InsertAutoscalerRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves a list of autoscalers contained within the specified zone.
	List(ctx context.Context, in *ListAutoscalersRequest, opts ...grpc.CallOption) (*AutoscalerList, error)
	// Updates an autoscaler in the specified project using the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
	Patch(ctx context.Context, in *PatchAutoscalerRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(ctx context.Context, in *TestIamPermissionsAutoscalerRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error)
	// Updates an autoscaler in the specified project using the data included in the request.
	Update(ctx context.Context, in *UpdateAutoscalerRequest, opts ...grpc.CallOption) (*Operation, error)
}

type autoscalersClient struct {
	cc grpc.ClientConnInterface
}

func NewAutoscalersClient(cc grpc.ClientConnInterface) AutoscalersClient {
	return &autoscalersClient{cc}
}

func (c *autoscalersClient) AggregatedList(ctx context.Context, in *AggregatedListAutoscalersRequest, opts ...grpc.CallOption) (*AutoscalerAggregatedList, error) {
	out := new(AutoscalerAggregatedList)
	err := c.cc.Invoke(ctx, Autoscalers_AggregatedList_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoscalersClient) Delete(ctx context.Context, in *DeleteAutoscalerRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Autoscalers_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoscalersClient) Get(ctx context.Context, in *GetAutoscalerRequest, opts ...grpc.CallOption) (*Autoscaler, error) {
	out := new(Autoscaler)
	err := c.cc.Invoke(ctx, Autoscalers_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoscalersClient) Insert(ctx context.Context, in *InsertAutoscalerRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Autoscalers_Insert_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoscalersClient) List(ctx context.Context, in *ListAutoscalersRequest, opts ...grpc.CallOption) (*AutoscalerList, error) {
	out := new(AutoscalerList)
	err := c.cc.Invoke(ctx, Autoscalers_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoscalersClient) Patch(ctx context.Context, in *PatchAutoscalerRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Autoscalers_Patch_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoscalersClient) TestIamPermissions(ctx context.Context, in *TestIamPermissionsAutoscalerRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error) {
	out := new(TestPermissionsResponse)
	err := c.cc.Invoke(ctx, Autoscalers_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *autoscalersClient) Update(ctx context.Context, in *UpdateAutoscalerRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Autoscalers_Update_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// AutoscalersServer is the server API for Autoscalers service.
// All implementations should embed UnimplementedAutoscalersServer
// for forward compatibility
type AutoscalersServer interface {
	// Retrieves an aggregated list of autoscalers. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(context.Context, *AggregatedListAutoscalersRequest) (*AutoscalerAggregatedList, error)
	// Deletes the specified autoscaler.
	Delete(context.Context, *DeleteAutoscalerRequest) (*Operation, error)
	// Returns the specified autoscaler resource.
	Get(context.Context, *GetAutoscalerRequest) (*Autoscaler, error)
	// Creates an autoscaler in the specified project using the data included in the request.
	Insert(context.Context, *InsertAutoscalerRequest) (*Operation, error)
	// Retrieves a list of autoscalers contained within the specified zone.
	List(context.Context, *ListAutoscalersRequest) (*AutoscalerList, error)
	// Updates an autoscaler in the specified project using the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
	Patch(context.Context, *PatchAutoscalerRequest) (*Operation, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(context.Context, *TestIamPermissionsAutoscalerRequest) (*TestPermissionsResponse, error)
	// Updates an autoscaler in the specified project using the data included in the request.
	Update(context.Context, *UpdateAutoscalerRequest) (*Operation, error)
}

// UnimplementedAutoscalersServer should be embedded to have forward compatible implementations.
type UnimplementedAutoscalersServer struct {
}

func (UnimplementedAutoscalersServer) AggregatedList(context.Context, *AggregatedListAutoscalersRequest) (*AutoscalerAggregatedList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AggregatedList not implemented")
}
func (UnimplementedAutoscalersServer) Delete(context.Context, *DeleteAutoscalerRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedAutoscalersServer) Get(context.Context, *GetAutoscalerRequest) (*Autoscaler, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedAutoscalersServer) Insert(context.Context, *InsertAutoscalerRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (UnimplementedAutoscalersServer) List(context.Context, *ListAutoscalersRequest) (*AutoscalerList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedAutoscalersServer) Patch(context.Context, *PatchAutoscalerRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Patch not implemented")
}
func (UnimplementedAutoscalersServer) TestIamPermissions(context.Context, *TestIamPermissionsAutoscalerRequest) (*TestPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}
func (UnimplementedAutoscalersServer) Update(context.Context, *UpdateAutoscalerRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}

// UnsafeAutoscalersServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to AutoscalersServer will
// result in compilation errors.
type UnsafeAutoscalersServer interface {
	mustEmbedUnimplementedAutoscalersServer()
}

func RegisterAutoscalersServer(s grpc.ServiceRegistrar, srv AutoscalersServer) {
	s.RegisterService(&Autoscalers_ServiceDesc, srv)
}

func _Autoscalers_AggregatedList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AggregatedListAutoscalersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoscalersServer).AggregatedList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Autoscalers_AggregatedList_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoscalersServer).AggregatedList(ctx, req.(*AggregatedListAutoscalersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Autoscalers_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAutoscalerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoscalersServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Autoscalers_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoscalersServer).Delete(ctx, req.(*DeleteAutoscalerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Autoscalers_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAutoscalerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoscalersServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Autoscalers_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoscalersServer).Get(ctx, req.(*GetAutoscalerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Autoscalers_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertAutoscalerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoscalersServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Autoscalers_Insert_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoscalersServer).Insert(ctx, req.(*InsertAutoscalerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Autoscalers_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAutoscalersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoscalersServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Autoscalers_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoscalersServer).List(ctx, req.(*ListAutoscalersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Autoscalers_Patch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchAutoscalerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoscalersServer).Patch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Autoscalers_Patch_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoscalersServer).Patch(ctx, req.(*PatchAutoscalerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Autoscalers_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TestIamPermissionsAutoscalerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoscalersServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Autoscalers_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoscalersServer).TestIamPermissions(ctx, req.(*TestIamPermissionsAutoscalerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Autoscalers_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAutoscalerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(AutoscalersServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Autoscalers_Update_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(AutoscalersServer).Update(ctx, req.(*UpdateAutoscalerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Autoscalers_ServiceDesc is the grpc.ServiceDesc for Autoscalers service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Autoscalers_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.Autoscalers",
	HandlerType: (*AutoscalersServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AggregatedList",
			Handler:    _Autoscalers_AggregatedList_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _Autoscalers_Delete_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _Autoscalers_Get_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _Autoscalers_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _Autoscalers_List_Handler,
		},
		{
			MethodName: "Patch",
			Handler:    _Autoscalers_Patch_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _Autoscalers_TestIamPermissions_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _Autoscalers_Update_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	BackendBuckets_AddSignedUrlKey_FullMethodName       = "/google.cloud.compute.v1beta.BackendBuckets/AddSignedUrlKey"
	BackendBuckets_Delete_FullMethodName                = "/google.cloud.compute.v1beta.BackendBuckets/Delete"
	BackendBuckets_DeleteSignedUrlKey_FullMethodName    = "/google.cloud.compute.v1beta.BackendBuckets/DeleteSignedUrlKey"
	BackendBuckets_Get_FullMethodName                   = "/google.cloud.compute.v1beta.BackendBuckets/Get"
	BackendBuckets_GetIamPolicy_FullMethodName          = "/google.cloud.compute.v1beta.BackendBuckets/GetIamPolicy"
	BackendBuckets_Insert_FullMethodName                = "/google.cloud.compute.v1beta.BackendBuckets/Insert"
	BackendBuckets_List_FullMethodName                  = "/google.cloud.compute.v1beta.BackendBuckets/List"
	BackendBuckets_ListUsable_FullMethodName            = "/google.cloud.compute.v1beta.BackendBuckets/ListUsable"
	BackendBuckets_Patch_FullMethodName                 = "/google.cloud.compute.v1beta.BackendBuckets/Patch"
	BackendBuckets_SetEdgeSecurityPolicy_FullMethodName = "/google.cloud.compute.v1beta.BackendBuckets/SetEdgeSecurityPolicy"
	BackendBuckets_SetIamPolicy_FullMethodName          = "/google.cloud.compute.v1beta.BackendBuckets/SetIamPolicy"
	BackendBuckets_TestIamPermissions_FullMethodName    = "/google.cloud.compute.v1beta.BackendBuckets/TestIamPermissions"
	BackendBuckets_Update_FullMethodName                = "/google.cloud.compute.v1beta.BackendBuckets/Update"
)

// BackendBucketsClient is the client API for BackendBuckets service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type BackendBucketsClient interface {
	// Adds a key for validating requests with signed URLs for this backend bucket.
	AddSignedUrlKey(ctx context.Context, in *AddSignedUrlKeyBackendBucketRequest, opts ...grpc.CallOption) (*Operation, error)
	// Deletes the specified BackendBucket resource.
	Delete(ctx context.Context, in *DeleteBackendBucketRequest, opts ...grpc.CallOption) (*Operation, error)
	// Deletes a key for validating requests with signed URLs for this backend bucket.
	DeleteSignedUrlKey(ctx context.Context, in *DeleteSignedUrlKeyBackendBucketRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns the specified BackendBucket resource.
	Get(ctx context.Context, in *GetBackendBucketRequest, opts ...grpc.CallOption) (*BackendBucket, error)
	// Gets the access control policy for a resource. May be empty if no such policy or resource exists.
	GetIamPolicy(ctx context.Context, in *GetIamPolicyBackendBucketRequest, opts ...grpc.CallOption) (*Policy, error)
	// Creates a BackendBucket resource in the specified project using the data included in the request.
	Insert(ctx context.Context, in *InsertBackendBucketRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves the list of BackendBucket resources available to the specified project.
	List(ctx context.Context, in *ListBackendBucketsRequest, opts ...grpc.CallOption) (*BackendBucketList, error)
	// Retrieves a list of all usable backend buckets in the specified project.
	ListUsable(ctx context.Context, in *ListUsableBackendBucketsRequest, opts ...grpc.CallOption) (*BackendBucketListUsable, error)
	// Updates the specified BackendBucket resource with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
	Patch(ctx context.Context, in *PatchBackendBucketRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the edge security policy for the specified backend bucket.
	SetEdgeSecurityPolicy(ctx context.Context, in *SetEdgeSecurityPolicyBackendBucketRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the access control policy on the specified resource. Replaces any existing policy.
	SetIamPolicy(ctx context.Context, in *SetIamPolicyBackendBucketRequest, opts ...grpc.CallOption) (*Policy, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(ctx context.Context, in *TestIamPermissionsBackendBucketRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error)
	// Updates the specified BackendBucket resource with the data included in the request.
	Update(ctx context.Context, in *UpdateBackendBucketRequest, opts ...grpc.CallOption) (*Operation, error)
}

type backendBucketsClient struct {
	cc grpc.ClientConnInterface
}

func NewBackendBucketsClient(cc grpc.ClientConnInterface) BackendBucketsClient {
	return &backendBucketsClient{cc}
}

func (c *backendBucketsClient) AddSignedUrlKey(ctx context.Context, in *AddSignedUrlKeyBackendBucketRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, BackendBuckets_AddSignedUrlKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backendBucketsClient) Delete(ctx context.Context, in *DeleteBackendBucketRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, BackendBuckets_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backendBucketsClient) DeleteSignedUrlKey(ctx context.Context, in *DeleteSignedUrlKeyBackendBucketRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, BackendBuckets_DeleteSignedUrlKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backendBucketsClient) Get(ctx context.Context, in *GetBackendBucketRequest, opts ...grpc.CallOption) (*BackendBucket, error) {
	out := new(BackendBucket)
	err := c.cc.Invoke(ctx, BackendBuckets_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backendBucketsClient) GetIamPolicy(ctx context.Context, in *GetIamPolicyBackendBucketRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, BackendBuckets_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backendBucketsClient) Insert(ctx context.Context, in *InsertBackendBucketRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, BackendBuckets_Insert_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backendBucketsClient) List(ctx context.Context, in *ListBackendBucketsRequest, opts ...grpc.CallOption) (*BackendBucketList, error) {
	out := new(BackendBucketList)
	err := c.cc.Invoke(ctx, BackendBuckets_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backendBucketsClient) ListUsable(ctx context.Context, in *ListUsableBackendBucketsRequest, opts ...grpc.CallOption) (*BackendBucketListUsable, error) {
	out := new(BackendBucketListUsable)
	err := c.cc.Invoke(ctx, BackendBuckets_ListUsable_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backendBucketsClient) Patch(ctx context.Context, in *PatchBackendBucketRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, BackendBuckets_Patch_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backendBucketsClient) SetEdgeSecurityPolicy(ctx context.Context, in *SetEdgeSecurityPolicyBackendBucketRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, BackendBuckets_SetEdgeSecurityPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backendBucketsClient) SetIamPolicy(ctx context.Context, in *SetIamPolicyBackendBucketRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, BackendBuckets_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backendBucketsClient) TestIamPermissions(ctx context.Context, in *TestIamPermissionsBackendBucketRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error) {
	out := new(TestPermissionsResponse)
	err := c.cc.Invoke(ctx, BackendBuckets_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backendBucketsClient) Update(ctx context.Context, in *UpdateBackendBucketRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, BackendBuckets_Update_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BackendBucketsServer is the server API for BackendBuckets service.
// All implementations should embed UnimplementedBackendBucketsServer
// for forward compatibility
type BackendBucketsServer interface {
	// Adds a key for validating requests with signed URLs for this backend bucket.
	AddSignedUrlKey(context.Context, *AddSignedUrlKeyBackendBucketRequest) (*Operation, error)
	// Deletes the specified BackendBucket resource.
	Delete(context.Context, *DeleteBackendBucketRequest) (*Operation, error)
	// Deletes a key for validating requests with signed URLs for this backend bucket.
	DeleteSignedUrlKey(context.Context, *DeleteSignedUrlKeyBackendBucketRequest) (*Operation, error)
	// Returns the specified BackendBucket resource.
	Get(context.Context, *GetBackendBucketRequest) (*BackendBucket, error)
	// Gets the access control policy for a resource. May be empty if no such policy or resource exists.
	GetIamPolicy(context.Context, *GetIamPolicyBackendBucketRequest) (*Policy, error)
	// Creates a BackendBucket resource in the specified project using the data included in the request.
	Insert(context.Context, *InsertBackendBucketRequest) (*Operation, error)
	// Retrieves the list of BackendBucket resources available to the specified project.
	List(context.Context, *ListBackendBucketsRequest) (*BackendBucketList, error)
	// Retrieves a list of all usable backend buckets in the specified project.
	ListUsable(context.Context, *ListUsableBackendBucketsRequest) (*BackendBucketListUsable, error)
	// Updates the specified BackendBucket resource with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
	Patch(context.Context, *PatchBackendBucketRequest) (*Operation, error)
	// Sets the edge security policy for the specified backend bucket.
	SetEdgeSecurityPolicy(context.Context, *SetEdgeSecurityPolicyBackendBucketRequest) (*Operation, error)
	// Sets the access control policy on the specified resource. Replaces any existing policy.
	SetIamPolicy(context.Context, *SetIamPolicyBackendBucketRequest) (*Policy, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(context.Context, *TestIamPermissionsBackendBucketRequest) (*TestPermissionsResponse, error)
	// Updates the specified BackendBucket resource with the data included in the request.
	Update(context.Context, *UpdateBackendBucketRequest) (*Operation, error)
}

// UnimplementedBackendBucketsServer should be embedded to have forward compatible implementations.
type UnimplementedBackendBucketsServer struct {
}

func (UnimplementedBackendBucketsServer) AddSignedUrlKey(context.Context, *AddSignedUrlKeyBackendBucketRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddSignedUrlKey not implemented")
}
func (UnimplementedBackendBucketsServer) Delete(context.Context, *DeleteBackendBucketRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedBackendBucketsServer) DeleteSignedUrlKey(context.Context, *DeleteSignedUrlKeyBackendBucketRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSignedUrlKey not implemented")
}
func (UnimplementedBackendBucketsServer) Get(context.Context, *GetBackendBucketRequest) (*BackendBucket, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedBackendBucketsServer) GetIamPolicy(context.Context, *GetIamPolicyBackendBucketRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedBackendBucketsServer) Insert(context.Context, *InsertBackendBucketRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (UnimplementedBackendBucketsServer) List(context.Context, *ListBackendBucketsRequest) (*BackendBucketList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedBackendBucketsServer) ListUsable(context.Context, *ListUsableBackendBucketsRequest) (*BackendBucketListUsable, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListUsable not implemented")
}
func (UnimplementedBackendBucketsServer) Patch(context.Context, *PatchBackendBucketRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Patch not implemented")
}
func (UnimplementedBackendBucketsServer) SetEdgeSecurityPolicy(context.Context, *SetEdgeSecurityPolicyBackendBucketRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetEdgeSecurityPolicy not implemented")
}
func (UnimplementedBackendBucketsServer) SetIamPolicy(context.Context, *SetIamPolicyBackendBucketRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedBackendBucketsServer) TestIamPermissions(context.Context, *TestIamPermissionsBackendBucketRequest) (*TestPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}
func (UnimplementedBackendBucketsServer) Update(context.Context, *UpdateBackendBucketRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}

// UnsafeBackendBucketsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to BackendBucketsServer will
// result in compilation errors.
type UnsafeBackendBucketsServer interface {
	mustEmbedUnimplementedBackendBucketsServer()
}

func RegisterBackendBucketsServer(s grpc.ServiceRegistrar, srv BackendBucketsServer) {
	s.RegisterService(&BackendBuckets_ServiceDesc, srv)
}

func _BackendBuckets_AddSignedUrlKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddSignedUrlKeyBackendBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendBucketsServer).AddSignedUrlKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackendBuckets_AddSignedUrlKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendBucketsServer).AddSignedUrlKey(ctx, req.(*AddSignedUrlKeyBackendBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackendBuckets_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBackendBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendBucketsServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackendBuckets_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendBucketsServer).Delete(ctx, req.(*DeleteBackendBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackendBuckets_DeleteSignedUrlKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSignedUrlKeyBackendBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendBucketsServer).DeleteSignedUrlKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackendBuckets_DeleteSignedUrlKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendBucketsServer).DeleteSignedUrlKey(ctx, req.(*DeleteSignedUrlKeyBackendBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackendBuckets_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBackendBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendBucketsServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackendBuckets_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendBucketsServer).Get(ctx, req.(*GetBackendBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackendBuckets_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIamPolicyBackendBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendBucketsServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackendBuckets_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendBucketsServer).GetIamPolicy(ctx, req.(*GetIamPolicyBackendBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackendBuckets_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertBackendBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendBucketsServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackendBuckets_Insert_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendBucketsServer).Insert(ctx, req.(*InsertBackendBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackendBuckets_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBackendBucketsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendBucketsServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackendBuckets_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendBucketsServer).List(ctx, req.(*ListBackendBucketsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackendBuckets_ListUsable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListUsableBackendBucketsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendBucketsServer).ListUsable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackendBuckets_ListUsable_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendBucketsServer).ListUsable(ctx, req.(*ListUsableBackendBucketsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackendBuckets_Patch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchBackendBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendBucketsServer).Patch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackendBuckets_Patch_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendBucketsServer).Patch(ctx, req.(*PatchBackendBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackendBuckets_SetEdgeSecurityPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetEdgeSecurityPolicyBackendBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendBucketsServer).SetEdgeSecurityPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackendBuckets_SetEdgeSecurityPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendBucketsServer).SetEdgeSecurityPolicy(ctx, req.(*SetEdgeSecurityPolicyBackendBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackendBuckets_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetIamPolicyBackendBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendBucketsServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackendBuckets_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendBucketsServer).SetIamPolicy(ctx, req.(*SetIamPolicyBackendBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackendBuckets_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TestIamPermissionsBackendBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendBucketsServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackendBuckets_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendBucketsServer).TestIamPermissions(ctx, req.(*TestIamPermissionsBackendBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackendBuckets_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBackendBucketRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendBucketsServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackendBuckets_Update_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendBucketsServer).Update(ctx, req.(*UpdateBackendBucketRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// BackendBuckets_ServiceDesc is the grpc.ServiceDesc for BackendBuckets service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var BackendBuckets_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.BackendBuckets",
	HandlerType: (*BackendBucketsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AddSignedUrlKey",
			Handler:    _BackendBuckets_AddSignedUrlKey_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _BackendBuckets_Delete_Handler,
		},
		{
			MethodName: "DeleteSignedUrlKey",
			Handler:    _BackendBuckets_DeleteSignedUrlKey_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _BackendBuckets_Get_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _BackendBuckets_GetIamPolicy_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _BackendBuckets_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _BackendBuckets_List_Handler,
		},
		{
			MethodName: "ListUsable",
			Handler:    _BackendBuckets_ListUsable_Handler,
		},
		{
			MethodName: "Patch",
			Handler:    _BackendBuckets_Patch_Handler,
		},
		{
			MethodName: "SetEdgeSecurityPolicy",
			Handler:    _BackendBuckets_SetEdgeSecurityPolicy_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _BackendBuckets_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _BackendBuckets_TestIamPermissions_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _BackendBuckets_Update_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	BackendServices_AddSignedUrlKey_FullMethodName              = "/google.cloud.compute.v1beta.BackendServices/AddSignedUrlKey"
	BackendServices_AggregatedList_FullMethodName               = "/google.cloud.compute.v1beta.BackendServices/AggregatedList"
	BackendServices_Delete_FullMethodName                       = "/google.cloud.compute.v1beta.BackendServices/Delete"
	BackendServices_DeleteSignedUrlKey_FullMethodName           = "/google.cloud.compute.v1beta.BackendServices/DeleteSignedUrlKey"
	BackendServices_Get_FullMethodName                          = "/google.cloud.compute.v1beta.BackendServices/Get"
	BackendServices_GetEffectiveSecurityPolicies_FullMethodName = "/google.cloud.compute.v1beta.BackendServices/GetEffectiveSecurityPolicies"
	BackendServices_GetHealth_FullMethodName                    = "/google.cloud.compute.v1beta.BackendServices/GetHealth"
	BackendServices_GetIamPolicy_FullMethodName                 = "/google.cloud.compute.v1beta.BackendServices/GetIamPolicy"
	BackendServices_Insert_FullMethodName                       = "/google.cloud.compute.v1beta.BackendServices/Insert"
	BackendServices_List_FullMethodName                         = "/google.cloud.compute.v1beta.BackendServices/List"
	BackendServices_ListUsable_FullMethodName                   = "/google.cloud.compute.v1beta.BackendServices/ListUsable"
	BackendServices_Patch_FullMethodName                        = "/google.cloud.compute.v1beta.BackendServices/Patch"
	BackendServices_SetEdgeSecurityPolicy_FullMethodName        = "/google.cloud.compute.v1beta.BackendServices/SetEdgeSecurityPolicy"
	BackendServices_SetIamPolicy_FullMethodName                 = "/google.cloud.compute.v1beta.BackendServices/SetIamPolicy"
	BackendServices_SetSecurityPolicy_FullMethodName            = "/google.cloud.compute.v1beta.BackendServices/SetSecurityPolicy"
	BackendServices_TestIamPermissions_FullMethodName           = "/google.cloud.compute.v1beta.BackendServices/TestIamPermissions"
	BackendServices_Update_FullMethodName                       = "/google.cloud.compute.v1beta.BackendServices/Update"
)

// BackendServicesClient is the client API for BackendServices service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type BackendServicesClient interface {
	// Adds a key for validating requests with signed URLs for this backend service.
	AddSignedUrlKey(ctx context.Context, in *AddSignedUrlKeyBackendServiceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves the list of all BackendService resources, regional and global, available to the specified project. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(ctx context.Context, in *AggregatedListBackendServicesRequest, opts ...grpc.CallOption) (*BackendServiceAggregatedList, error)
	// Deletes the specified BackendService resource.
	Delete(ctx context.Context, in *DeleteBackendServiceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Deletes a key for validating requests with signed URLs for this backend service.
	DeleteSignedUrlKey(ctx context.Context, in *DeleteSignedUrlKeyBackendServiceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns the specified BackendService resource.
	Get(ctx context.Context, in *GetBackendServiceRequest, opts ...grpc.CallOption) (*BackendService, error)
	// Returns effective security policies applied to this backend service.
	GetEffectiveSecurityPolicies(ctx context.Context, in *GetEffectiveSecurityPoliciesBackendServiceRequest, opts ...grpc.CallOption) (*BackendServicesGetEffectiveSecurityPoliciesResponse, error)
	// Gets the most recent health check results for this BackendService. Example request body: { "group": "/zones/us-east1-b/instanceGroups/lb-backend-example" }
	GetHealth(ctx context.Context, in *GetHealthBackendServiceRequest, opts ...grpc.CallOption) (*BackendServiceGroupHealth, error)
	// Gets the access control policy for a resource. May be empty if no such policy or resource exists.
	GetIamPolicy(ctx context.Context, in *GetIamPolicyBackendServiceRequest, opts ...grpc.CallOption) (*Policy, error)
	// Creates a BackendService resource in the specified project using the data included in the request. For more information, see Backend services overview .
	Insert(ctx context.Context, in *InsertBackendServiceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves the list of BackendService resources available to the specified project.
	List(ctx context.Context, in *ListBackendServicesRequest, opts ...grpc.CallOption) (*BackendServiceList, error)
	// Retrieves a list of all usable backend services in the specified project.
	ListUsable(ctx context.Context, in *ListUsableBackendServicesRequest, opts ...grpc.CallOption) (*BackendServiceListUsable, error)
	// Patches the specified BackendService resource with the data included in the request. For more information, see Backend services overview. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
	Patch(ctx context.Context, in *PatchBackendServiceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the edge security policy for the specified backend service.
	SetEdgeSecurityPolicy(ctx context.Context, in *SetEdgeSecurityPolicyBackendServiceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the access control policy on the specified resource. Replaces any existing policy.
	SetIamPolicy(ctx context.Context, in *SetIamPolicyBackendServiceRequest, opts ...grpc.CallOption) (*Policy, error)
	// Sets the Google Cloud Armor security policy for the specified backend service. For more information, see Google Cloud Armor Overview
	SetSecurityPolicy(ctx context.Context, in *SetSecurityPolicyBackendServiceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(ctx context.Context, in *TestIamPermissionsBackendServiceRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error)
	// Updates the specified BackendService resource with the data included in the request. For more information, see Backend services overview.
	Update(ctx context.Context, in *UpdateBackendServiceRequest, opts ...grpc.CallOption) (*Operation, error)
}

type backendServicesClient struct {
	cc grpc.ClientConnInterface
}

func NewBackendServicesClient(cc grpc.ClientConnInterface) BackendServicesClient {
	return &backendServicesClient{cc}
}

func (c *backendServicesClient) AddSignedUrlKey(ctx context.Context, in *AddSignedUrlKeyBackendServiceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, BackendServices_AddSignedUrlKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backendServicesClient) AggregatedList(ctx context.Context, in *AggregatedListBackendServicesRequest, opts ...grpc.CallOption) (*BackendServiceAggregatedList, error) {
	out := new(BackendServiceAggregatedList)
	err := c.cc.Invoke(ctx, BackendServices_AggregatedList_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backendServicesClient) Delete(ctx context.Context, in *DeleteBackendServiceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, BackendServices_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backendServicesClient) DeleteSignedUrlKey(ctx context.Context, in *DeleteSignedUrlKeyBackendServiceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, BackendServices_DeleteSignedUrlKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backendServicesClient) Get(ctx context.Context, in *GetBackendServiceRequest, opts ...grpc.CallOption) (*BackendService, error) {
	out := new(BackendService)
	err := c.cc.Invoke(ctx, BackendServices_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backendServicesClient) GetEffectiveSecurityPolicies(ctx context.Context, in *GetEffectiveSecurityPoliciesBackendServiceRequest, opts ...grpc.CallOption) (*BackendServicesGetEffectiveSecurityPoliciesResponse, error) {
	out := new(BackendServicesGetEffectiveSecurityPoliciesResponse)
	err := c.cc.Invoke(ctx, BackendServices_GetEffectiveSecurityPolicies_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backendServicesClient) GetHealth(ctx context.Context, in *GetHealthBackendServiceRequest, opts ...grpc.CallOption) (*BackendServiceGroupHealth, error) {
	out := new(BackendServiceGroupHealth)
	err := c.cc.Invoke(ctx, BackendServices_GetHealth_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backendServicesClient) GetIamPolicy(ctx context.Context, in *GetIamPolicyBackendServiceRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, BackendServices_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backendServicesClient) Insert(ctx context.Context, in *InsertBackendServiceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, BackendServices_Insert_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backendServicesClient) List(ctx context.Context, in *ListBackendServicesRequest, opts ...grpc.CallOption) (*BackendServiceList, error) {
	out := new(BackendServiceList)
	err := c.cc.Invoke(ctx, BackendServices_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backendServicesClient) ListUsable(ctx context.Context, in *ListUsableBackendServicesRequest, opts ...grpc.CallOption) (*BackendServiceListUsable, error) {
	out := new(BackendServiceListUsable)
	err := c.cc.Invoke(ctx, BackendServices_ListUsable_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backendServicesClient) Patch(ctx context.Context, in *PatchBackendServiceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, BackendServices_Patch_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backendServicesClient) SetEdgeSecurityPolicy(ctx context.Context, in *SetEdgeSecurityPolicyBackendServiceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, BackendServices_SetEdgeSecurityPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backendServicesClient) SetIamPolicy(ctx context.Context, in *SetIamPolicyBackendServiceRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, BackendServices_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backendServicesClient) SetSecurityPolicy(ctx context.Context, in *SetSecurityPolicyBackendServiceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, BackendServices_SetSecurityPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backendServicesClient) TestIamPermissions(ctx context.Context, in *TestIamPermissionsBackendServiceRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error) {
	out := new(TestPermissionsResponse)
	err := c.cc.Invoke(ctx, BackendServices_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *backendServicesClient) Update(ctx context.Context, in *UpdateBackendServiceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, BackendServices_Update_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// BackendServicesServer is the server API for BackendServices service.
// All implementations should embed UnimplementedBackendServicesServer
// for forward compatibility
type BackendServicesServer interface {
	// Adds a key for validating requests with signed URLs for this backend service.
	AddSignedUrlKey(context.Context, *AddSignedUrlKeyBackendServiceRequest) (*Operation, error)
	// Retrieves the list of all BackendService resources, regional and global, available to the specified project. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(context.Context, *AggregatedListBackendServicesRequest) (*BackendServiceAggregatedList, error)
	// Deletes the specified BackendService resource.
	Delete(context.Context, *DeleteBackendServiceRequest) (*Operation, error)
	// Deletes a key for validating requests with signed URLs for this backend service.
	DeleteSignedUrlKey(context.Context, *DeleteSignedUrlKeyBackendServiceRequest) (*Operation, error)
	// Returns the specified BackendService resource.
	Get(context.Context, *GetBackendServiceRequest) (*BackendService, error)
	// Returns effective security policies applied to this backend service.
	GetEffectiveSecurityPolicies(context.Context, *GetEffectiveSecurityPoliciesBackendServiceRequest) (*BackendServicesGetEffectiveSecurityPoliciesResponse, error)
	// Gets the most recent health check results for this BackendService. Example request body: { "group": "/zones/us-east1-b/instanceGroups/lb-backend-example" }
	GetHealth(context.Context, *GetHealthBackendServiceRequest) (*BackendServiceGroupHealth, error)
	// Gets the access control policy for a resource. May be empty if no such policy or resource exists.
	GetIamPolicy(context.Context, *GetIamPolicyBackendServiceRequest) (*Policy, error)
	// Creates a BackendService resource in the specified project using the data included in the request. For more information, see Backend services overview .
	Insert(context.Context, *InsertBackendServiceRequest) (*Operation, error)
	// Retrieves the list of BackendService resources available to the specified project.
	List(context.Context, *ListBackendServicesRequest) (*BackendServiceList, error)
	// Retrieves a list of all usable backend services in the specified project.
	ListUsable(context.Context, *ListUsableBackendServicesRequest) (*BackendServiceListUsable, error)
	// Patches the specified BackendService resource with the data included in the request. For more information, see Backend services overview. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
	Patch(context.Context, *PatchBackendServiceRequest) (*Operation, error)
	// Sets the edge security policy for the specified backend service.
	SetEdgeSecurityPolicy(context.Context, *SetEdgeSecurityPolicyBackendServiceRequest) (*Operation, error)
	// Sets the access control policy on the specified resource. Replaces any existing policy.
	SetIamPolicy(context.Context, *SetIamPolicyBackendServiceRequest) (*Policy, error)
	// Sets the Google Cloud Armor security policy for the specified backend service. For more information, see Google Cloud Armor Overview
	SetSecurityPolicy(context.Context, *SetSecurityPolicyBackendServiceRequest) (*Operation, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(context.Context, *TestIamPermissionsBackendServiceRequest) (*TestPermissionsResponse, error)
	// Updates the specified BackendService resource with the data included in the request. For more information, see Backend services overview.
	Update(context.Context, *UpdateBackendServiceRequest) (*Operation, error)
}

// UnimplementedBackendServicesServer should be embedded to have forward compatible implementations.
type UnimplementedBackendServicesServer struct {
}

func (UnimplementedBackendServicesServer) AddSignedUrlKey(context.Context, *AddSignedUrlKeyBackendServiceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddSignedUrlKey not implemented")
}
func (UnimplementedBackendServicesServer) AggregatedList(context.Context, *AggregatedListBackendServicesRequest) (*BackendServiceAggregatedList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AggregatedList not implemented")
}
func (UnimplementedBackendServicesServer) Delete(context.Context, *DeleteBackendServiceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedBackendServicesServer) DeleteSignedUrlKey(context.Context, *DeleteSignedUrlKeyBackendServiceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteSignedUrlKey not implemented")
}
func (UnimplementedBackendServicesServer) Get(context.Context, *GetBackendServiceRequest) (*BackendService, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedBackendServicesServer) GetEffectiveSecurityPolicies(context.Context, *GetEffectiveSecurityPoliciesBackendServiceRequest) (*BackendServicesGetEffectiveSecurityPoliciesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEffectiveSecurityPolicies not implemented")
}
func (UnimplementedBackendServicesServer) GetHealth(context.Context, *GetHealthBackendServiceRequest) (*BackendServiceGroupHealth, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetHealth not implemented")
}
func (UnimplementedBackendServicesServer) GetIamPolicy(context.Context, *GetIamPolicyBackendServiceRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedBackendServicesServer) Insert(context.Context, *InsertBackendServiceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (UnimplementedBackendServicesServer) List(context.Context, *ListBackendServicesRequest) (*BackendServiceList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedBackendServicesServer) ListUsable(context.Context, *ListUsableBackendServicesRequest) (*BackendServiceListUsable, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListUsable not implemented")
}
func (UnimplementedBackendServicesServer) Patch(context.Context, *PatchBackendServiceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Patch not implemented")
}
func (UnimplementedBackendServicesServer) SetEdgeSecurityPolicy(context.Context, *SetEdgeSecurityPolicyBackendServiceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetEdgeSecurityPolicy not implemented")
}
func (UnimplementedBackendServicesServer) SetIamPolicy(context.Context, *SetIamPolicyBackendServiceRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedBackendServicesServer) SetSecurityPolicy(context.Context, *SetSecurityPolicyBackendServiceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetSecurityPolicy not implemented")
}
func (UnimplementedBackendServicesServer) TestIamPermissions(context.Context, *TestIamPermissionsBackendServiceRequest) (*TestPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}
func (UnimplementedBackendServicesServer) Update(context.Context, *UpdateBackendServiceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}

// UnsafeBackendServicesServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to BackendServicesServer will
// result in compilation errors.
type UnsafeBackendServicesServer interface {
	mustEmbedUnimplementedBackendServicesServer()
}

func RegisterBackendServicesServer(s grpc.ServiceRegistrar, srv BackendServicesServer) {
	s.RegisterService(&BackendServices_ServiceDesc, srv)
}

func _BackendServices_AddSignedUrlKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddSignedUrlKeyBackendServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendServicesServer).AddSignedUrlKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackendServices_AddSignedUrlKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendServicesServer).AddSignedUrlKey(ctx, req.(*AddSignedUrlKeyBackendServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackendServices_AggregatedList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AggregatedListBackendServicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendServicesServer).AggregatedList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackendServices_AggregatedList_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendServicesServer).AggregatedList(ctx, req.(*AggregatedListBackendServicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackendServices_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteBackendServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendServicesServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackendServices_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendServicesServer).Delete(ctx, req.(*DeleteBackendServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackendServices_DeleteSignedUrlKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteSignedUrlKeyBackendServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendServicesServer).DeleteSignedUrlKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackendServices_DeleteSignedUrlKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendServicesServer).DeleteSignedUrlKey(ctx, req.(*DeleteSignedUrlKeyBackendServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackendServices_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetBackendServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendServicesServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackendServices_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendServicesServer).Get(ctx, req.(*GetBackendServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackendServices_GetEffectiveSecurityPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEffectiveSecurityPoliciesBackendServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendServicesServer).GetEffectiveSecurityPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackendServices_GetEffectiveSecurityPolicies_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendServicesServer).GetEffectiveSecurityPolicies(ctx, req.(*GetEffectiveSecurityPoliciesBackendServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackendServices_GetHealth_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetHealthBackendServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendServicesServer).GetHealth(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackendServices_GetHealth_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendServicesServer).GetHealth(ctx, req.(*GetHealthBackendServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackendServices_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIamPolicyBackendServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendServicesServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackendServices_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendServicesServer).GetIamPolicy(ctx, req.(*GetIamPolicyBackendServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackendServices_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertBackendServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendServicesServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackendServices_Insert_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendServicesServer).Insert(ctx, req.(*InsertBackendServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackendServices_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListBackendServicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendServicesServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackendServices_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendServicesServer).List(ctx, req.(*ListBackendServicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackendServices_ListUsable_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListUsableBackendServicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendServicesServer).ListUsable(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackendServices_ListUsable_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendServicesServer).ListUsable(ctx, req.(*ListUsableBackendServicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackendServices_Patch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchBackendServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendServicesServer).Patch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackendServices_Patch_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendServicesServer).Patch(ctx, req.(*PatchBackendServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackendServices_SetEdgeSecurityPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetEdgeSecurityPolicyBackendServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendServicesServer).SetEdgeSecurityPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackendServices_SetEdgeSecurityPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendServicesServer).SetEdgeSecurityPolicy(ctx, req.(*SetEdgeSecurityPolicyBackendServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackendServices_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetIamPolicyBackendServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendServicesServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackendServices_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendServicesServer).SetIamPolicy(ctx, req.(*SetIamPolicyBackendServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackendServices_SetSecurityPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetSecurityPolicyBackendServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendServicesServer).SetSecurityPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackendServices_SetSecurityPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendServicesServer).SetSecurityPolicy(ctx, req.(*SetSecurityPolicyBackendServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackendServices_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TestIamPermissionsBackendServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendServicesServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackendServices_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendServicesServer).TestIamPermissions(ctx, req.(*TestIamPermissionsBackendServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _BackendServices_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateBackendServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(BackendServicesServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: BackendServices_Update_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(BackendServicesServer).Update(ctx, req.(*UpdateBackendServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// BackendServices_ServiceDesc is the grpc.ServiceDesc for BackendServices service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var BackendServices_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.BackendServices",
	HandlerType: (*BackendServicesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AddSignedUrlKey",
			Handler:    _BackendServices_AddSignedUrlKey_Handler,
		},
		{
			MethodName: "AggregatedList",
			Handler:    _BackendServices_AggregatedList_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _BackendServices_Delete_Handler,
		},
		{
			MethodName: "DeleteSignedUrlKey",
			Handler:    _BackendServices_DeleteSignedUrlKey_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _BackendServices_Get_Handler,
		},
		{
			MethodName: "GetEffectiveSecurityPolicies",
			Handler:    _BackendServices_GetEffectiveSecurityPolicies_Handler,
		},
		{
			MethodName: "GetHealth",
			Handler:    _BackendServices_GetHealth_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _BackendServices_GetIamPolicy_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _BackendServices_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _BackendServices_List_Handler,
		},
		{
			MethodName: "ListUsable",
			Handler:    _BackendServices_ListUsable_Handler,
		},
		{
			MethodName: "Patch",
			Handler:    _BackendServices_Patch_Handler,
		},
		{
			MethodName: "SetEdgeSecurityPolicy",
			Handler:    _BackendServices_SetEdgeSecurityPolicy_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _BackendServices_SetIamPolicy_Handler,
		},
		{
			MethodName: "SetSecurityPolicy",
			Handler:    _BackendServices_SetSecurityPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _BackendServices_TestIamPermissions_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _BackendServices_Update_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	CrossSiteNetworks_Delete_FullMethodName = "/google.cloud.compute.v1beta.CrossSiteNetworks/Delete"
	CrossSiteNetworks_Get_FullMethodName    = "/google.cloud.compute.v1beta.CrossSiteNetworks/Get"
	CrossSiteNetworks_Insert_FullMethodName = "/google.cloud.compute.v1beta.CrossSiteNetworks/Insert"
	CrossSiteNetworks_List_FullMethodName   = "/google.cloud.compute.v1beta.CrossSiteNetworks/List"
	CrossSiteNetworks_Patch_FullMethodName  = "/google.cloud.compute.v1beta.CrossSiteNetworks/Patch"
)

// CrossSiteNetworksClient is the client API for CrossSiteNetworks service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type CrossSiteNetworksClient interface {
	// Deletes the specified cross-site network in the given scope.
	Delete(ctx context.Context, in *DeleteCrossSiteNetworkRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns the specified cross-site network in the given scope.
	Get(ctx context.Context, in *GetCrossSiteNetworkRequest, opts ...grpc.CallOption) (*CrossSiteNetwork, error)
	// Creates a cross-site network in the specified project in the given scope using the parameters that are included in the request.
	Insert(ctx context.Context, in *InsertCrossSiteNetworkRequest, opts ...grpc.CallOption) (*Operation, error)
	// Lists the cross-site networks for a project in the given scope.
	List(ctx context.Context, in *ListCrossSiteNetworksRequest, opts ...grpc.CallOption) (*CrossSiteNetworkList, error)
	// Updates the specified cross-site network with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
	Patch(ctx context.Context, in *PatchCrossSiteNetworkRequest, opts ...grpc.CallOption) (*Operation, error)
}

type crossSiteNetworksClient struct {
	cc grpc.ClientConnInterface
}

func NewCrossSiteNetworksClient(cc grpc.ClientConnInterface) CrossSiteNetworksClient {
	return &crossSiteNetworksClient{cc}
}

func (c *crossSiteNetworksClient) Delete(ctx context.Context, in *DeleteCrossSiteNetworkRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, CrossSiteNetworks_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *crossSiteNetworksClient) Get(ctx context.Context, in *GetCrossSiteNetworkRequest, opts ...grpc.CallOption) (*CrossSiteNetwork, error) {
	out := new(CrossSiteNetwork)
	err := c.cc.Invoke(ctx, CrossSiteNetworks_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *crossSiteNetworksClient) Insert(ctx context.Context, in *InsertCrossSiteNetworkRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, CrossSiteNetworks_Insert_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *crossSiteNetworksClient) List(ctx context.Context, in *ListCrossSiteNetworksRequest, opts ...grpc.CallOption) (*CrossSiteNetworkList, error) {
	out := new(CrossSiteNetworkList)
	err := c.cc.Invoke(ctx, CrossSiteNetworks_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *crossSiteNetworksClient) Patch(ctx context.Context, in *PatchCrossSiteNetworkRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, CrossSiteNetworks_Patch_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CrossSiteNetworksServer is the server API for CrossSiteNetworks service.
// All implementations should embed UnimplementedCrossSiteNetworksServer
// for forward compatibility
type CrossSiteNetworksServer interface {
	// Deletes the specified cross-site network in the given scope.
	Delete(context.Context, *DeleteCrossSiteNetworkRequest) (*Operation, error)
	// Returns the specified cross-site network in the given scope.
	Get(context.Context, *GetCrossSiteNetworkRequest) (*CrossSiteNetwork, error)
	// Creates a cross-site network in the specified project in the given scope using the parameters that are included in the request.
	Insert(context.Context, *InsertCrossSiteNetworkRequest) (*Operation, error)
	// Lists the cross-site networks for a project in the given scope.
	List(context.Context, *ListCrossSiteNetworksRequest) (*CrossSiteNetworkList, error)
	// Updates the specified cross-site network with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
	Patch(context.Context, *PatchCrossSiteNetworkRequest) (*Operation, error)
}

// UnimplementedCrossSiteNetworksServer should be embedded to have forward compatible implementations.
type UnimplementedCrossSiteNetworksServer struct {
}

func (UnimplementedCrossSiteNetworksServer) Delete(context.Context, *DeleteCrossSiteNetworkRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedCrossSiteNetworksServer) Get(context.Context, *GetCrossSiteNetworkRequest) (*CrossSiteNetwork, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedCrossSiteNetworksServer) Insert(context.Context, *InsertCrossSiteNetworkRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (UnimplementedCrossSiteNetworksServer) List(context.Context, *ListCrossSiteNetworksRequest) (*CrossSiteNetworkList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedCrossSiteNetworksServer) Patch(context.Context, *PatchCrossSiteNetworkRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Patch not implemented")
}

// UnsafeCrossSiteNetworksServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to CrossSiteNetworksServer will
// result in compilation errors.
type UnsafeCrossSiteNetworksServer interface {
	mustEmbedUnimplementedCrossSiteNetworksServer()
}

func RegisterCrossSiteNetworksServer(s grpc.ServiceRegistrar, srv CrossSiteNetworksServer) {
	s.RegisterService(&CrossSiteNetworks_ServiceDesc, srv)
}

func _CrossSiteNetworks_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCrossSiteNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CrossSiteNetworksServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CrossSiteNetworks_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CrossSiteNetworksServer).Delete(ctx, req.(*DeleteCrossSiteNetworkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CrossSiteNetworks_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCrossSiteNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CrossSiteNetworksServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CrossSiteNetworks_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CrossSiteNetworksServer).Get(ctx, req.(*GetCrossSiteNetworkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CrossSiteNetworks_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertCrossSiteNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CrossSiteNetworksServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CrossSiteNetworks_Insert_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CrossSiteNetworksServer).Insert(ctx, req.(*InsertCrossSiteNetworkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CrossSiteNetworks_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListCrossSiteNetworksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CrossSiteNetworksServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CrossSiteNetworks_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CrossSiteNetworksServer).List(ctx, req.(*ListCrossSiteNetworksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CrossSiteNetworks_Patch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchCrossSiteNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CrossSiteNetworksServer).Patch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: CrossSiteNetworks_Patch_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CrossSiteNetworksServer).Patch(ctx, req.(*PatchCrossSiteNetworkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// CrossSiteNetworks_ServiceDesc is the grpc.ServiceDesc for CrossSiteNetworks service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var CrossSiteNetworks_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.CrossSiteNetworks",
	HandlerType: (*CrossSiteNetworksServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Delete",
			Handler:    _CrossSiteNetworks_Delete_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _CrossSiteNetworks_Get_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _CrossSiteNetworks_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _CrossSiteNetworks_List_Handler,
		},
		{
			MethodName: "Patch",
			Handler:    _CrossSiteNetworks_Patch_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	DiskSettingsService_Get_FullMethodName   = "/google.cloud.compute.v1beta.DiskSettingsService/Get"
	DiskSettingsService_Patch_FullMethodName = "/google.cloud.compute.v1beta.DiskSettingsService/Patch"
)

// DiskSettingsServiceClient is the client API for DiskSettingsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type DiskSettingsServiceClient interface {
	// Get Zonal Disk Settings.
	Get(ctx context.Context, in *GetDiskSettingRequest, opts ...grpc.CallOption) (*DiskSettings, error)
	// Patch Zonal Disk Settings
	Patch(ctx context.Context, in *PatchDiskSettingRequest, opts ...grpc.CallOption) (*Operation, error)
}

type diskSettingsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewDiskSettingsServiceClient(cc grpc.ClientConnInterface) DiskSettingsServiceClient {
	return &diskSettingsServiceClient{cc}
}

func (c *diskSettingsServiceClient) Get(ctx context.Context, in *GetDiskSettingRequest, opts ...grpc.CallOption) (*DiskSettings, error) {
	out := new(DiskSettings)
	err := c.cc.Invoke(ctx, DiskSettingsService_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *diskSettingsServiceClient) Patch(ctx context.Context, in *PatchDiskSettingRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, DiskSettingsService_Patch_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DiskSettingsServiceServer is the server API for DiskSettingsService service.
// All implementations should embed UnimplementedDiskSettingsServiceServer
// for forward compatibility
type DiskSettingsServiceServer interface {
	// Get Zonal Disk Settings.
	Get(context.Context, *GetDiskSettingRequest) (*DiskSettings, error)
	// Patch Zonal Disk Settings
	Patch(context.Context, *PatchDiskSettingRequest) (*Operation, error)
}

// UnimplementedDiskSettingsServiceServer should be embedded to have forward compatible implementations.
type UnimplementedDiskSettingsServiceServer struct {
}

func (UnimplementedDiskSettingsServiceServer) Get(context.Context, *GetDiskSettingRequest) (*DiskSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedDiskSettingsServiceServer) Patch(context.Context, *PatchDiskSettingRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Patch not implemented")
}

// UnsafeDiskSettingsServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to DiskSettingsServiceServer will
// result in compilation errors.
type UnsafeDiskSettingsServiceServer interface {
	mustEmbedUnimplementedDiskSettingsServiceServer()
}

func RegisterDiskSettingsServiceServer(s grpc.ServiceRegistrar, srv DiskSettingsServiceServer) {
	s.RegisterService(&DiskSettingsService_ServiceDesc, srv)
}

func _DiskSettingsService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDiskSettingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DiskSettingsServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DiskSettingsService_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DiskSettingsServiceServer).Get(ctx, req.(*GetDiskSettingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DiskSettingsService_Patch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchDiskSettingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DiskSettingsServiceServer).Patch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DiskSettingsService_Patch_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DiskSettingsServiceServer).Patch(ctx, req.(*PatchDiskSettingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// DiskSettingsService_ServiceDesc is the grpc.ServiceDesc for DiskSettingsService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var DiskSettingsService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.DiskSettingsService",
	HandlerType: (*DiskSettingsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _DiskSettingsService_Get_Handler,
		},
		{
			MethodName: "Patch",
			Handler:    _DiskSettingsService_Patch_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	DiskTypes_AggregatedList_FullMethodName = "/google.cloud.compute.v1beta.DiskTypes/AggregatedList"
	DiskTypes_Get_FullMethodName            = "/google.cloud.compute.v1beta.DiskTypes/Get"
	DiskTypes_List_FullMethodName           = "/google.cloud.compute.v1beta.DiskTypes/List"
)

// DiskTypesClient is the client API for DiskTypes service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type DiskTypesClient interface {
	// Retrieves an aggregated list of disk types. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(ctx context.Context, in *AggregatedListDiskTypesRequest, opts ...grpc.CallOption) (*DiskTypeAggregatedList, error)
	// Returns the specified disk type.
	Get(ctx context.Context, in *GetDiskTypeRequest, opts ...grpc.CallOption) (*DiskType, error)
	// Retrieves a list of disk types available to the specified project.
	List(ctx context.Context, in *ListDiskTypesRequest, opts ...grpc.CallOption) (*DiskTypeList, error)
}

type diskTypesClient struct {
	cc grpc.ClientConnInterface
}

func NewDiskTypesClient(cc grpc.ClientConnInterface) DiskTypesClient {
	return &diskTypesClient{cc}
}

func (c *diskTypesClient) AggregatedList(ctx context.Context, in *AggregatedListDiskTypesRequest, opts ...grpc.CallOption) (*DiskTypeAggregatedList, error) {
	out := new(DiskTypeAggregatedList)
	err := c.cc.Invoke(ctx, DiskTypes_AggregatedList_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *diskTypesClient) Get(ctx context.Context, in *GetDiskTypeRequest, opts ...grpc.CallOption) (*DiskType, error) {
	out := new(DiskType)
	err := c.cc.Invoke(ctx, DiskTypes_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *diskTypesClient) List(ctx context.Context, in *ListDiskTypesRequest, opts ...grpc.CallOption) (*DiskTypeList, error) {
	out := new(DiskTypeList)
	err := c.cc.Invoke(ctx, DiskTypes_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DiskTypesServer is the server API for DiskTypes service.
// All implementations should embed UnimplementedDiskTypesServer
// for forward compatibility
type DiskTypesServer interface {
	// Retrieves an aggregated list of disk types. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(context.Context, *AggregatedListDiskTypesRequest) (*DiskTypeAggregatedList, error)
	// Returns the specified disk type.
	Get(context.Context, *GetDiskTypeRequest) (*DiskType, error)
	// Retrieves a list of disk types available to the specified project.
	List(context.Context, *ListDiskTypesRequest) (*DiskTypeList, error)
}

// UnimplementedDiskTypesServer should be embedded to have forward compatible implementations.
type UnimplementedDiskTypesServer struct {
}

func (UnimplementedDiskTypesServer) AggregatedList(context.Context, *AggregatedListDiskTypesRequest) (*DiskTypeAggregatedList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AggregatedList not implemented")
}
func (UnimplementedDiskTypesServer) Get(context.Context, *GetDiskTypeRequest) (*DiskType, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedDiskTypesServer) List(context.Context, *ListDiskTypesRequest) (*DiskTypeList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}

// UnsafeDiskTypesServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to DiskTypesServer will
// result in compilation errors.
type UnsafeDiskTypesServer interface {
	mustEmbedUnimplementedDiskTypesServer()
}

func RegisterDiskTypesServer(s grpc.ServiceRegistrar, srv DiskTypesServer) {
	s.RegisterService(&DiskTypes_ServiceDesc, srv)
}

func _DiskTypes_AggregatedList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AggregatedListDiskTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DiskTypesServer).AggregatedList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DiskTypes_AggregatedList_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DiskTypesServer).AggregatedList(ctx, req.(*AggregatedListDiskTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DiskTypes_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDiskTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DiskTypesServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DiskTypes_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DiskTypesServer).Get(ctx, req.(*GetDiskTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DiskTypes_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDiskTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DiskTypesServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: DiskTypes_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DiskTypesServer).List(ctx, req.(*ListDiskTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// DiskTypes_ServiceDesc is the grpc.ServiceDesc for DiskTypes service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var DiskTypes_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.DiskTypes",
	HandlerType: (*DiskTypesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AggregatedList",
			Handler:    _DiskTypes_AggregatedList_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _DiskTypes_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _DiskTypes_List_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	Disks_AddResourcePolicies_FullMethodName       = "/google.cloud.compute.v1beta.Disks/AddResourcePolicies"
	Disks_AggregatedList_FullMethodName            = "/google.cloud.compute.v1beta.Disks/AggregatedList"
	Disks_BulkInsert_FullMethodName                = "/google.cloud.compute.v1beta.Disks/BulkInsert"
	Disks_BulkSetLabels_FullMethodName             = "/google.cloud.compute.v1beta.Disks/BulkSetLabels"
	Disks_CreateSnapshot_FullMethodName            = "/google.cloud.compute.v1beta.Disks/CreateSnapshot"
	Disks_Delete_FullMethodName                    = "/google.cloud.compute.v1beta.Disks/Delete"
	Disks_Get_FullMethodName                       = "/google.cloud.compute.v1beta.Disks/Get"
	Disks_GetIamPolicy_FullMethodName              = "/google.cloud.compute.v1beta.Disks/GetIamPolicy"
	Disks_Insert_FullMethodName                    = "/google.cloud.compute.v1beta.Disks/Insert"
	Disks_List_FullMethodName                      = "/google.cloud.compute.v1beta.Disks/List"
	Disks_RemoveResourcePolicies_FullMethodName    = "/google.cloud.compute.v1beta.Disks/RemoveResourcePolicies"
	Disks_Resize_FullMethodName                    = "/google.cloud.compute.v1beta.Disks/Resize"
	Disks_SetIamPolicy_FullMethodName              = "/google.cloud.compute.v1beta.Disks/SetIamPolicy"
	Disks_SetLabels_FullMethodName                 = "/google.cloud.compute.v1beta.Disks/SetLabels"
	Disks_StartAsyncReplication_FullMethodName     = "/google.cloud.compute.v1beta.Disks/StartAsyncReplication"
	Disks_StopAsyncReplication_FullMethodName      = "/google.cloud.compute.v1beta.Disks/StopAsyncReplication"
	Disks_StopGroupAsyncReplication_FullMethodName = "/google.cloud.compute.v1beta.Disks/StopGroupAsyncReplication"
	Disks_TestIamPermissions_FullMethodName        = "/google.cloud.compute.v1beta.Disks/TestIamPermissions"
	Disks_Update_FullMethodName                    = "/google.cloud.compute.v1beta.Disks/Update"
)

// DisksClient is the client API for Disks service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type DisksClient interface {
	// Adds existing resource policies to a disk. You can only add one policy which will be applied to this disk for scheduling snapshot creation.
	AddResourcePolicies(ctx context.Context, in *AddResourcePoliciesDiskRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves an aggregated list of persistent disks. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(ctx context.Context, in *AggregatedListDisksRequest, opts ...grpc.CallOption) (*DiskAggregatedList, error)
	// Bulk create a set of disks.
	BulkInsert(ctx context.Context, in *BulkInsertDiskRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the labels on many disks at once. To learn more about labels, read the Labeling Resources documentation.
	BulkSetLabels(ctx context.Context, in *BulkSetLabelsDiskRequest, opts ...grpc.CallOption) (*Operation, error)
	// Creates a snapshot of a specified persistent disk. For regular snapshot creation, consider using snapshots.insert instead, as that method supports more features, such as creating snapshots in a project different from the source disk project.
	CreateSnapshot(ctx context.Context, in *CreateSnapshotDiskRequest, opts ...grpc.CallOption) (*Operation, error)
	// Deletes the specified persistent disk. Deleting a disk removes its data permanently and is irreversible. However, deleting a disk does not delete any snapshots previously made from the disk. You must separately delete snapshots.
	Delete(ctx context.Context, in *DeleteDiskRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns the specified persistent disk.
	Get(ctx context.Context, in *GetDiskRequest, opts ...grpc.CallOption) (*Disk, error)
	// Gets the access control policy for a resource. May be empty if no such policy or resource exists.
	GetIamPolicy(ctx context.Context, in *GetIamPolicyDiskRequest, opts ...grpc.CallOption) (*Policy, error)
	// Creates a persistent disk in the specified project using the data in the request. You can create a disk from a source (sourceImage, sourceSnapshot, or sourceDisk) or create an empty 500 GB data disk by omitting all properties. You can also create a disk that is larger than the default size by specifying the sizeGb property.
	Insert(ctx context.Context, in *InsertDiskRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves a list of persistent disks contained within the specified zone.
	List(ctx context.Context, in *ListDisksRequest, opts ...grpc.CallOption) (*DiskList, error)
	// Removes resource policies from a disk.
	RemoveResourcePolicies(ctx context.Context, in *RemoveResourcePoliciesDiskRequest, opts ...grpc.CallOption) (*Operation, error)
	// Resizes the specified persistent disk. You can only increase the size of the disk.
	Resize(ctx context.Context, in *ResizeDiskRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the access control policy on the specified resource. Replaces any existing policy.
	SetIamPolicy(ctx context.Context, in *SetIamPolicyDiskRequest, opts ...grpc.CallOption) (*Policy, error)
	// Sets the labels on a disk. To learn more about labels, read the Labeling Resources documentation.
	SetLabels(ctx context.Context, in *SetLabelsDiskRequest, opts ...grpc.CallOption) (*Operation, error)
	// Starts asynchronous replication. Must be invoked on the primary disk.
	StartAsyncReplication(ctx context.Context, in *StartAsyncReplicationDiskRequest, opts ...grpc.CallOption) (*Operation, error)
	// Stops asynchronous replication. Can be invoked either on the primary or on the secondary disk.
	StopAsyncReplication(ctx context.Context, in *StopAsyncReplicationDiskRequest, opts ...grpc.CallOption) (*Operation, error)
	// Stops asynchronous replication for a consistency group of disks. Can be invoked either in the primary or secondary scope.
	StopGroupAsyncReplication(ctx context.Context, in *StopGroupAsyncReplicationDiskRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(ctx context.Context, in *TestIamPermissionsDiskRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error)
	// Updates the specified disk with the data included in the request. The update is performed only on selected fields included as part of update-mask. Only the following fields can be modified: user_license.
	Update(ctx context.Context, in *UpdateDiskRequest, opts ...grpc.CallOption) (*Operation, error)
}

type disksClient struct {
	cc grpc.ClientConnInterface
}

func NewDisksClient(cc grpc.ClientConnInterface) DisksClient {
	return &disksClient{cc}
}

func (c *disksClient) AddResourcePolicies(ctx context.Context, in *AddResourcePoliciesDiskRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Disks_AddResourcePolicies_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *disksClient) AggregatedList(ctx context.Context, in *AggregatedListDisksRequest, opts ...grpc.CallOption) (*DiskAggregatedList, error) {
	out := new(DiskAggregatedList)
	err := c.cc.Invoke(ctx, Disks_AggregatedList_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *disksClient) BulkInsert(ctx context.Context, in *BulkInsertDiskRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Disks_BulkInsert_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *disksClient) BulkSetLabels(ctx context.Context, in *BulkSetLabelsDiskRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Disks_BulkSetLabels_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *disksClient) CreateSnapshot(ctx context.Context, in *CreateSnapshotDiskRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Disks_CreateSnapshot_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *disksClient) Delete(ctx context.Context, in *DeleteDiskRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Disks_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *disksClient) Get(ctx context.Context, in *GetDiskRequest, opts ...grpc.CallOption) (*Disk, error) {
	out := new(Disk)
	err := c.cc.Invoke(ctx, Disks_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *disksClient) GetIamPolicy(ctx context.Context, in *GetIamPolicyDiskRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, Disks_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *disksClient) Insert(ctx context.Context, in *InsertDiskRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Disks_Insert_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *disksClient) List(ctx context.Context, in *ListDisksRequest, opts ...grpc.CallOption) (*DiskList, error) {
	out := new(DiskList)
	err := c.cc.Invoke(ctx, Disks_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *disksClient) RemoveResourcePolicies(ctx context.Context, in *RemoveResourcePoliciesDiskRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Disks_RemoveResourcePolicies_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *disksClient) Resize(ctx context.Context, in *ResizeDiskRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Disks_Resize_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *disksClient) SetIamPolicy(ctx context.Context, in *SetIamPolicyDiskRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, Disks_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *disksClient) SetLabels(ctx context.Context, in *SetLabelsDiskRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Disks_SetLabels_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *disksClient) StartAsyncReplication(ctx context.Context, in *StartAsyncReplicationDiskRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Disks_StartAsyncReplication_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *disksClient) StopAsyncReplication(ctx context.Context, in *StopAsyncReplicationDiskRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Disks_StopAsyncReplication_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *disksClient) StopGroupAsyncReplication(ctx context.Context, in *StopGroupAsyncReplicationDiskRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Disks_StopGroupAsyncReplication_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *disksClient) TestIamPermissions(ctx context.Context, in *TestIamPermissionsDiskRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error) {
	out := new(TestPermissionsResponse)
	err := c.cc.Invoke(ctx, Disks_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *disksClient) Update(ctx context.Context, in *UpdateDiskRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Disks_Update_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DisksServer is the server API for Disks service.
// All implementations should embed UnimplementedDisksServer
// for forward compatibility
type DisksServer interface {
	// Adds existing resource policies to a disk. You can only add one policy which will be applied to this disk for scheduling snapshot creation.
	AddResourcePolicies(context.Context, *AddResourcePoliciesDiskRequest) (*Operation, error)
	// Retrieves an aggregated list of persistent disks. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(context.Context, *AggregatedListDisksRequest) (*DiskAggregatedList, error)
	// Bulk create a set of disks.
	BulkInsert(context.Context, *BulkInsertDiskRequest) (*Operation, error)
	// Sets the labels on many disks at once. To learn more about labels, read the Labeling Resources documentation.
	BulkSetLabels(context.Context, *BulkSetLabelsDiskRequest) (*Operation, error)
	// Creates a snapshot of a specified persistent disk. For regular snapshot creation, consider using snapshots.insert instead, as that method supports more features, such as creating snapshots in a project different from the source disk project.
	CreateSnapshot(context.Context, *CreateSnapshotDiskRequest) (*Operation, error)
	// Deletes the specified persistent disk. Deleting a disk removes its data permanently and is irreversible. However, deleting a disk does not delete any snapshots previously made from the disk. You must separately delete snapshots.
	Delete(context.Context, *DeleteDiskRequest) (*Operation, error)
	// Returns the specified persistent disk.
	Get(context.Context, *GetDiskRequest) (*Disk, error)
	// Gets the access control policy for a resource. May be empty if no such policy or resource exists.
	GetIamPolicy(context.Context, *GetIamPolicyDiskRequest) (*Policy, error)
	// Creates a persistent disk in the specified project using the data in the request. You can create a disk from a source (sourceImage, sourceSnapshot, or sourceDisk) or create an empty 500 GB data disk by omitting all properties. You can also create a disk that is larger than the default size by specifying the sizeGb property.
	Insert(context.Context, *InsertDiskRequest) (*Operation, error)
	// Retrieves a list of persistent disks contained within the specified zone.
	List(context.Context, *ListDisksRequest) (*DiskList, error)
	// Removes resource policies from a disk.
	RemoveResourcePolicies(context.Context, *RemoveResourcePoliciesDiskRequest) (*Operation, error)
	// Resizes the specified persistent disk. You can only increase the size of the disk.
	Resize(context.Context, *ResizeDiskRequest) (*Operation, error)
	// Sets the access control policy on the specified resource. Replaces any existing policy.
	SetIamPolicy(context.Context, *SetIamPolicyDiskRequest) (*Policy, error)
	// Sets the labels on a disk. To learn more about labels, read the Labeling Resources documentation.
	SetLabels(context.Context, *SetLabelsDiskRequest) (*Operation, error)
	// Starts asynchronous replication. Must be invoked on the primary disk.
	StartAsyncReplication(context.Context, *StartAsyncReplicationDiskRequest) (*Operation, error)
	// Stops asynchronous replication. Can be invoked either on the primary or on the secondary disk.
	StopAsyncReplication(context.Context, *StopAsyncReplicationDiskRequest) (*Operation, error)
	// Stops asynchronous replication for a consistency group of disks. Can be invoked either in the primary or secondary scope.
	StopGroupAsyncReplication(context.Context, *StopGroupAsyncReplicationDiskRequest) (*Operation, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(context.Context, *TestIamPermissionsDiskRequest) (*TestPermissionsResponse, error)
	// Updates the specified disk with the data included in the request. The update is performed only on selected fields included as part of update-mask. Only the following fields can be modified: user_license.
	Update(context.Context, *UpdateDiskRequest) (*Operation, error)
}

// UnimplementedDisksServer should be embedded to have forward compatible implementations.
type UnimplementedDisksServer struct {
}

func (UnimplementedDisksServer) AddResourcePolicies(context.Context, *AddResourcePoliciesDiskRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddResourcePolicies not implemented")
}
func (UnimplementedDisksServer) AggregatedList(context.Context, *AggregatedListDisksRequest) (*DiskAggregatedList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AggregatedList not implemented")
}
func (UnimplementedDisksServer) BulkInsert(context.Context, *BulkInsertDiskRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BulkInsert not implemented")
}
func (UnimplementedDisksServer) BulkSetLabels(context.Context, *BulkSetLabelsDiskRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BulkSetLabels not implemented")
}
func (UnimplementedDisksServer) CreateSnapshot(context.Context, *CreateSnapshotDiskRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateSnapshot not implemented")
}
func (UnimplementedDisksServer) Delete(context.Context, *DeleteDiskRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedDisksServer) Get(context.Context, *GetDiskRequest) (*Disk, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedDisksServer) GetIamPolicy(context.Context, *GetIamPolicyDiskRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedDisksServer) Insert(context.Context, *InsertDiskRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (UnimplementedDisksServer) List(context.Context, *ListDisksRequest) (*DiskList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedDisksServer) RemoveResourcePolicies(context.Context, *RemoveResourcePoliciesDiskRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveResourcePolicies not implemented")
}
func (UnimplementedDisksServer) Resize(context.Context, *ResizeDiskRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Resize not implemented")
}
func (UnimplementedDisksServer) SetIamPolicy(context.Context, *SetIamPolicyDiskRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedDisksServer) SetLabels(context.Context, *SetLabelsDiskRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetLabels not implemented")
}
func (UnimplementedDisksServer) StartAsyncReplication(context.Context, *StartAsyncReplicationDiskRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartAsyncReplication not implemented")
}
func (UnimplementedDisksServer) StopAsyncReplication(context.Context, *StopAsyncReplicationDiskRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopAsyncReplication not implemented")
}
func (UnimplementedDisksServer) StopGroupAsyncReplication(context.Context, *StopGroupAsyncReplicationDiskRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopGroupAsyncReplication not implemented")
}
func (UnimplementedDisksServer) TestIamPermissions(context.Context, *TestIamPermissionsDiskRequest) (*TestPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}
func (UnimplementedDisksServer) Update(context.Context, *UpdateDiskRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}

// UnsafeDisksServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to DisksServer will
// result in compilation errors.
type UnsafeDisksServer interface {
	mustEmbedUnimplementedDisksServer()
}

func RegisterDisksServer(s grpc.ServiceRegistrar, srv DisksServer) {
	s.RegisterService(&Disks_ServiceDesc, srv)
}

func _Disks_AddResourcePolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddResourcePoliciesDiskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DisksServer).AddResourcePolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Disks_AddResourcePolicies_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DisksServer).AddResourcePolicies(ctx, req.(*AddResourcePoliciesDiskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Disks_AggregatedList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AggregatedListDisksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DisksServer).AggregatedList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Disks_AggregatedList_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DisksServer).AggregatedList(ctx, req.(*AggregatedListDisksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Disks_BulkInsert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BulkInsertDiskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DisksServer).BulkInsert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Disks_BulkInsert_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DisksServer).BulkInsert(ctx, req.(*BulkInsertDiskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Disks_BulkSetLabels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BulkSetLabelsDiskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DisksServer).BulkSetLabels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Disks_BulkSetLabels_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DisksServer).BulkSetLabels(ctx, req.(*BulkSetLabelsDiskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Disks_CreateSnapshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSnapshotDiskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DisksServer).CreateSnapshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Disks_CreateSnapshot_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DisksServer).CreateSnapshot(ctx, req.(*CreateSnapshotDiskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Disks_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteDiskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DisksServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Disks_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DisksServer).Delete(ctx, req.(*DeleteDiskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Disks_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDiskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DisksServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Disks_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DisksServer).Get(ctx, req.(*GetDiskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Disks_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIamPolicyDiskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DisksServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Disks_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DisksServer).GetIamPolicy(ctx, req.(*GetIamPolicyDiskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Disks_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertDiskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DisksServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Disks_Insert_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DisksServer).Insert(ctx, req.(*InsertDiskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Disks_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDisksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DisksServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Disks_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DisksServer).List(ctx, req.(*ListDisksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Disks_RemoveResourcePolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveResourcePoliciesDiskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DisksServer).RemoveResourcePolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Disks_RemoveResourcePolicies_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DisksServer).RemoveResourcePolicies(ctx, req.(*RemoveResourcePoliciesDiskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Disks_Resize_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResizeDiskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DisksServer).Resize(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Disks_Resize_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DisksServer).Resize(ctx, req.(*ResizeDiskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Disks_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetIamPolicyDiskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DisksServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Disks_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DisksServer).SetIamPolicy(ctx, req.(*SetIamPolicyDiskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Disks_SetLabels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetLabelsDiskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DisksServer).SetLabels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Disks_SetLabels_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DisksServer).SetLabels(ctx, req.(*SetLabelsDiskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Disks_StartAsyncReplication_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartAsyncReplicationDiskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DisksServer).StartAsyncReplication(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Disks_StartAsyncReplication_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DisksServer).StartAsyncReplication(ctx, req.(*StartAsyncReplicationDiskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Disks_StopAsyncReplication_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopAsyncReplicationDiskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DisksServer).StopAsyncReplication(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Disks_StopAsyncReplication_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DisksServer).StopAsyncReplication(ctx, req.(*StopAsyncReplicationDiskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Disks_StopGroupAsyncReplication_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopGroupAsyncReplicationDiskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DisksServer).StopGroupAsyncReplication(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Disks_StopGroupAsyncReplication_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DisksServer).StopGroupAsyncReplication(ctx, req.(*StopGroupAsyncReplicationDiskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Disks_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TestIamPermissionsDiskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DisksServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Disks_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DisksServer).TestIamPermissions(ctx, req.(*TestIamPermissionsDiskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Disks_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDiskRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DisksServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Disks_Update_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DisksServer).Update(ctx, req.(*UpdateDiskRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Disks_ServiceDesc is the grpc.ServiceDesc for Disks service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Disks_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.Disks",
	HandlerType: (*DisksServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AddResourcePolicies",
			Handler:    _Disks_AddResourcePolicies_Handler,
		},
		{
			MethodName: "AggregatedList",
			Handler:    _Disks_AggregatedList_Handler,
		},
		{
			MethodName: "BulkInsert",
			Handler:    _Disks_BulkInsert_Handler,
		},
		{
			MethodName: "BulkSetLabels",
			Handler:    _Disks_BulkSetLabels_Handler,
		},
		{
			MethodName: "CreateSnapshot",
			Handler:    _Disks_CreateSnapshot_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _Disks_Delete_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _Disks_Get_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _Disks_GetIamPolicy_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _Disks_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _Disks_List_Handler,
		},
		{
			MethodName: "RemoveResourcePolicies",
			Handler:    _Disks_RemoveResourcePolicies_Handler,
		},
		{
			MethodName: "Resize",
			Handler:    _Disks_Resize_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _Disks_SetIamPolicy_Handler,
		},
		{
			MethodName: "SetLabels",
			Handler:    _Disks_SetLabels_Handler,
		},
		{
			MethodName: "StartAsyncReplication",
			Handler:    _Disks_StartAsyncReplication_Handler,
		},
		{
			MethodName: "StopAsyncReplication",
			Handler:    _Disks_StopAsyncReplication_Handler,
		},
		{
			MethodName: "StopGroupAsyncReplication",
			Handler:    _Disks_StopGroupAsyncReplication_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _Disks_TestIamPermissions_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _Disks_Update_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	ExternalVpnGateways_Delete_FullMethodName             = "/google.cloud.compute.v1beta.ExternalVpnGateways/Delete"
	ExternalVpnGateways_Get_FullMethodName                = "/google.cloud.compute.v1beta.ExternalVpnGateways/Get"
	ExternalVpnGateways_Insert_FullMethodName             = "/google.cloud.compute.v1beta.ExternalVpnGateways/Insert"
	ExternalVpnGateways_List_FullMethodName               = "/google.cloud.compute.v1beta.ExternalVpnGateways/List"
	ExternalVpnGateways_SetLabels_FullMethodName          = "/google.cloud.compute.v1beta.ExternalVpnGateways/SetLabels"
	ExternalVpnGateways_TestIamPermissions_FullMethodName = "/google.cloud.compute.v1beta.ExternalVpnGateways/TestIamPermissions"
)

// ExternalVpnGatewaysClient is the client API for ExternalVpnGateways service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ExternalVpnGatewaysClient interface {
	// Deletes the specified externalVpnGateway.
	Delete(ctx context.Context, in *DeleteExternalVpnGatewayRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns the specified externalVpnGateway. Get a list of available externalVpnGateways by making a list() request.
	Get(ctx context.Context, in *GetExternalVpnGatewayRequest, opts ...grpc.CallOption) (*ExternalVpnGateway, error)
	// Creates a ExternalVpnGateway in the specified project using the data included in the request.
	Insert(ctx context.Context, in *InsertExternalVpnGatewayRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves the list of ExternalVpnGateway available to the specified project.
	List(ctx context.Context, in *ListExternalVpnGatewaysRequest, opts ...grpc.CallOption) (*ExternalVpnGatewayList, error)
	// Sets the labels on an ExternalVpnGateway. To learn more about labels, read the Labeling Resources documentation.
	SetLabels(ctx context.Context, in *SetLabelsExternalVpnGatewayRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(ctx context.Context, in *TestIamPermissionsExternalVpnGatewayRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error)
}

type externalVpnGatewaysClient struct {
	cc grpc.ClientConnInterface
}

func NewExternalVpnGatewaysClient(cc grpc.ClientConnInterface) ExternalVpnGatewaysClient {
	return &externalVpnGatewaysClient{cc}
}

func (c *externalVpnGatewaysClient) Delete(ctx context.Context, in *DeleteExternalVpnGatewayRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, ExternalVpnGateways_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *externalVpnGatewaysClient) Get(ctx context.Context, in *GetExternalVpnGatewayRequest, opts ...grpc.CallOption) (*ExternalVpnGateway, error) {
	out := new(ExternalVpnGateway)
	err := c.cc.Invoke(ctx, ExternalVpnGateways_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *externalVpnGatewaysClient) Insert(ctx context.Context, in *InsertExternalVpnGatewayRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, ExternalVpnGateways_Insert_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *externalVpnGatewaysClient) List(ctx context.Context, in *ListExternalVpnGatewaysRequest, opts ...grpc.CallOption) (*ExternalVpnGatewayList, error) {
	out := new(ExternalVpnGatewayList)
	err := c.cc.Invoke(ctx, ExternalVpnGateways_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *externalVpnGatewaysClient) SetLabels(ctx context.Context, in *SetLabelsExternalVpnGatewayRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, ExternalVpnGateways_SetLabels_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *externalVpnGatewaysClient) TestIamPermissions(ctx context.Context, in *TestIamPermissionsExternalVpnGatewayRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error) {
	out := new(TestPermissionsResponse)
	err := c.cc.Invoke(ctx, ExternalVpnGateways_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ExternalVpnGatewaysServer is the server API for ExternalVpnGateways service.
// All implementations should embed UnimplementedExternalVpnGatewaysServer
// for forward compatibility
type ExternalVpnGatewaysServer interface {
	// Deletes the specified externalVpnGateway.
	Delete(context.Context, *DeleteExternalVpnGatewayRequest) (*Operation, error)
	// Returns the specified externalVpnGateway. Get a list of available externalVpnGateways by making a list() request.
	Get(context.Context, *GetExternalVpnGatewayRequest) (*ExternalVpnGateway, error)
	// Creates a ExternalVpnGateway in the specified project using the data included in the request.
	Insert(context.Context, *InsertExternalVpnGatewayRequest) (*Operation, error)
	// Retrieves the list of ExternalVpnGateway available to the specified project.
	List(context.Context, *ListExternalVpnGatewaysRequest) (*ExternalVpnGatewayList, error)
	// Sets the labels on an ExternalVpnGateway. To learn more about labels, read the Labeling Resources documentation.
	SetLabels(context.Context, *SetLabelsExternalVpnGatewayRequest) (*Operation, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(context.Context, *TestIamPermissionsExternalVpnGatewayRequest) (*TestPermissionsResponse, error)
}

// UnimplementedExternalVpnGatewaysServer should be embedded to have forward compatible implementations.
type UnimplementedExternalVpnGatewaysServer struct {
}

func (UnimplementedExternalVpnGatewaysServer) Delete(context.Context, *DeleteExternalVpnGatewayRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedExternalVpnGatewaysServer) Get(context.Context, *GetExternalVpnGatewayRequest) (*ExternalVpnGateway, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedExternalVpnGatewaysServer) Insert(context.Context, *InsertExternalVpnGatewayRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (UnimplementedExternalVpnGatewaysServer) List(context.Context, *ListExternalVpnGatewaysRequest) (*ExternalVpnGatewayList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedExternalVpnGatewaysServer) SetLabels(context.Context, *SetLabelsExternalVpnGatewayRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetLabels not implemented")
}
func (UnimplementedExternalVpnGatewaysServer) TestIamPermissions(context.Context, *TestIamPermissionsExternalVpnGatewayRequest) (*TestPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

// UnsafeExternalVpnGatewaysServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ExternalVpnGatewaysServer will
// result in compilation errors.
type UnsafeExternalVpnGatewaysServer interface {
	mustEmbedUnimplementedExternalVpnGatewaysServer()
}

func RegisterExternalVpnGatewaysServer(s grpc.ServiceRegistrar, srv ExternalVpnGatewaysServer) {
	s.RegisterService(&ExternalVpnGateways_ServiceDesc, srv)
}

func _ExternalVpnGateways_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteExternalVpnGatewayRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExternalVpnGatewaysServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ExternalVpnGateways_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExternalVpnGatewaysServer).Delete(ctx, req.(*DeleteExternalVpnGatewayRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ExternalVpnGateways_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetExternalVpnGatewayRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExternalVpnGatewaysServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ExternalVpnGateways_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExternalVpnGatewaysServer).Get(ctx, req.(*GetExternalVpnGatewayRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ExternalVpnGateways_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertExternalVpnGatewayRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExternalVpnGatewaysServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ExternalVpnGateways_Insert_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExternalVpnGatewaysServer).Insert(ctx, req.(*InsertExternalVpnGatewayRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ExternalVpnGateways_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListExternalVpnGatewaysRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExternalVpnGatewaysServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ExternalVpnGateways_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExternalVpnGatewaysServer).List(ctx, req.(*ListExternalVpnGatewaysRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ExternalVpnGateways_SetLabels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetLabelsExternalVpnGatewayRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExternalVpnGatewaysServer).SetLabels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ExternalVpnGateways_SetLabels_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExternalVpnGatewaysServer).SetLabels(ctx, req.(*SetLabelsExternalVpnGatewayRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ExternalVpnGateways_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TestIamPermissionsExternalVpnGatewayRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ExternalVpnGatewaysServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ExternalVpnGateways_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ExternalVpnGatewaysServer).TestIamPermissions(ctx, req.(*TestIamPermissionsExternalVpnGatewayRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ExternalVpnGateways_ServiceDesc is the grpc.ServiceDesc for ExternalVpnGateways service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ExternalVpnGateways_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.ExternalVpnGateways",
	HandlerType: (*ExternalVpnGatewaysServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Delete",
			Handler:    _ExternalVpnGateways_Delete_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _ExternalVpnGateways_Get_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _ExternalVpnGateways_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _ExternalVpnGateways_List_Handler,
		},
		{
			MethodName: "SetLabels",
			Handler:    _ExternalVpnGateways_SetLabels_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _ExternalVpnGateways_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	FirewallPolicies_AddAssociation_FullMethodName            = "/google.cloud.compute.v1beta.FirewallPolicies/AddAssociation"
	FirewallPolicies_AddPacketMirroringRule_FullMethodName    = "/google.cloud.compute.v1beta.FirewallPolicies/AddPacketMirroringRule"
	FirewallPolicies_AddRule_FullMethodName                   = "/google.cloud.compute.v1beta.FirewallPolicies/AddRule"
	FirewallPolicies_CloneRules_FullMethodName                = "/google.cloud.compute.v1beta.FirewallPolicies/CloneRules"
	FirewallPolicies_Delete_FullMethodName                    = "/google.cloud.compute.v1beta.FirewallPolicies/Delete"
	FirewallPolicies_Get_FullMethodName                       = "/google.cloud.compute.v1beta.FirewallPolicies/Get"
	FirewallPolicies_GetAssociation_FullMethodName            = "/google.cloud.compute.v1beta.FirewallPolicies/GetAssociation"
	FirewallPolicies_GetIamPolicy_FullMethodName              = "/google.cloud.compute.v1beta.FirewallPolicies/GetIamPolicy"
	FirewallPolicies_GetPacketMirroringRule_FullMethodName    = "/google.cloud.compute.v1beta.FirewallPolicies/GetPacketMirroringRule"
	FirewallPolicies_GetRule_FullMethodName                   = "/google.cloud.compute.v1beta.FirewallPolicies/GetRule"
	FirewallPolicies_Insert_FullMethodName                    = "/google.cloud.compute.v1beta.FirewallPolicies/Insert"
	FirewallPolicies_List_FullMethodName                      = "/google.cloud.compute.v1beta.FirewallPolicies/List"
	FirewallPolicies_ListAssociations_FullMethodName          = "/google.cloud.compute.v1beta.FirewallPolicies/ListAssociations"
	FirewallPolicies_Move_FullMethodName                      = "/google.cloud.compute.v1beta.FirewallPolicies/Move"
	FirewallPolicies_Patch_FullMethodName                     = "/google.cloud.compute.v1beta.FirewallPolicies/Patch"
	FirewallPolicies_PatchPacketMirroringRule_FullMethodName  = "/google.cloud.compute.v1beta.FirewallPolicies/PatchPacketMirroringRule"
	FirewallPolicies_PatchRule_FullMethodName                 = "/google.cloud.compute.v1beta.FirewallPolicies/PatchRule"
	FirewallPolicies_RemoveAssociation_FullMethodName         = "/google.cloud.compute.v1beta.FirewallPolicies/RemoveAssociation"
	FirewallPolicies_RemovePacketMirroringRule_FullMethodName = "/google.cloud.compute.v1beta.FirewallPolicies/RemovePacketMirroringRule"
	FirewallPolicies_RemoveRule_FullMethodName                = "/google.cloud.compute.v1beta.FirewallPolicies/RemoveRule"
	FirewallPolicies_SetIamPolicy_FullMethodName              = "/google.cloud.compute.v1beta.FirewallPolicies/SetIamPolicy"
	FirewallPolicies_TestIamPermissions_FullMethodName        = "/google.cloud.compute.v1beta.FirewallPolicies/TestIamPermissions"
)

// FirewallPoliciesClient is the client API for FirewallPolicies service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type FirewallPoliciesClient interface {
	// Inserts an association for the specified firewall policy.
	AddAssociation(ctx context.Context, in *AddAssociationFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error)
	// Inserts a packet mirroring rule into a firewall policy.
	AddPacketMirroringRule(ctx context.Context, in *AddPacketMirroringRuleFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error)
	// Inserts a rule into a firewall policy.
	AddRule(ctx context.Context, in *AddRuleFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error)
	// Copies rules to the specified firewall policy.
	CloneRules(ctx context.Context, in *CloneRulesFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error)
	// Deletes the specified policy.
	Delete(ctx context.Context, in *DeleteFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns the specified firewall policy.
	Get(ctx context.Context, in *GetFirewallPolicyRequest, opts ...grpc.CallOption) (*FirewallPolicy, error)
	// Gets an association with the specified name.
	GetAssociation(ctx context.Context, in *GetAssociationFirewallPolicyRequest, opts ...grpc.CallOption) (*FirewallPolicyAssociation, error)
	// Gets the access control policy for a resource. May be empty if no such policy or resource exists.
	GetIamPolicy(ctx context.Context, in *GetIamPolicyFirewallPolicyRequest, opts ...grpc.CallOption) (*Policy, error)
	// Gets a packet mirroring rule of the specified priority.
	GetPacketMirroringRule(ctx context.Context, in *GetPacketMirroringRuleFirewallPolicyRequest, opts ...grpc.CallOption) (*FirewallPolicyRule, error)
	// Gets a rule of the specified priority.
	GetRule(ctx context.Context, in *GetRuleFirewallPolicyRequest, opts ...grpc.CallOption) (*FirewallPolicyRule, error)
	// Creates a new policy in the specified project using the data included in the request.
	Insert(ctx context.Context, in *InsertFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error)
	// Lists all the policies that have been configured for the specified folder or organization.
	List(ctx context.Context, in *ListFirewallPoliciesRequest, opts ...grpc.CallOption) (*FirewallPolicyList, error)
	// Lists associations of a specified target, i.e., organization or folder.
	ListAssociations(ctx context.Context, in *ListAssociationsFirewallPolicyRequest, opts ...grpc.CallOption) (*FirewallPoliciesListAssociationsResponse, error)
	// Moves the specified firewall policy.
	Move(ctx context.Context, in *MoveFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error)
	// Patches the specified policy with the data included in the request.
	Patch(ctx context.Context, in *PatchFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error)
	// Patches a packet mirroring rule of the specified priority.
	PatchPacketMirroringRule(ctx context.Context, in *PatchPacketMirroringRuleFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error)
	// Patches a rule of the specified priority.
	PatchRule(ctx context.Context, in *PatchRuleFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error)
	// Removes an association for the specified firewall policy.
	RemoveAssociation(ctx context.Context, in *RemoveAssociationFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error)
	// Deletes a packet mirroring rule of the specified priority.
	RemovePacketMirroringRule(ctx context.Context, in *RemovePacketMirroringRuleFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error)
	// Deletes a rule of the specified priority.
	RemoveRule(ctx context.Context, in *RemoveRuleFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the access control policy on the specified resource. Replaces any existing policy.
	SetIamPolicy(ctx context.Context, in *SetIamPolicyFirewallPolicyRequest, opts ...grpc.CallOption) (*Policy, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(ctx context.Context, in *TestIamPermissionsFirewallPolicyRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error)
}

type firewallPoliciesClient struct {
	cc grpc.ClientConnInterface
}

func NewFirewallPoliciesClient(cc grpc.ClientConnInterface) FirewallPoliciesClient {
	return &firewallPoliciesClient{cc}
}

func (c *firewallPoliciesClient) AddAssociation(ctx context.Context, in *AddAssociationFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, FirewallPolicies_AddAssociation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firewallPoliciesClient) AddPacketMirroringRule(ctx context.Context, in *AddPacketMirroringRuleFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, FirewallPolicies_AddPacketMirroringRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firewallPoliciesClient) AddRule(ctx context.Context, in *AddRuleFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, FirewallPolicies_AddRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firewallPoliciesClient) CloneRules(ctx context.Context, in *CloneRulesFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, FirewallPolicies_CloneRules_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firewallPoliciesClient) Delete(ctx context.Context, in *DeleteFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, FirewallPolicies_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firewallPoliciesClient) Get(ctx context.Context, in *GetFirewallPolicyRequest, opts ...grpc.CallOption) (*FirewallPolicy, error) {
	out := new(FirewallPolicy)
	err := c.cc.Invoke(ctx, FirewallPolicies_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firewallPoliciesClient) GetAssociation(ctx context.Context, in *GetAssociationFirewallPolicyRequest, opts ...grpc.CallOption) (*FirewallPolicyAssociation, error) {
	out := new(FirewallPolicyAssociation)
	err := c.cc.Invoke(ctx, FirewallPolicies_GetAssociation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firewallPoliciesClient) GetIamPolicy(ctx context.Context, in *GetIamPolicyFirewallPolicyRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, FirewallPolicies_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firewallPoliciesClient) GetPacketMirroringRule(ctx context.Context, in *GetPacketMirroringRuleFirewallPolicyRequest, opts ...grpc.CallOption) (*FirewallPolicyRule, error) {
	out := new(FirewallPolicyRule)
	err := c.cc.Invoke(ctx, FirewallPolicies_GetPacketMirroringRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firewallPoliciesClient) GetRule(ctx context.Context, in *GetRuleFirewallPolicyRequest, opts ...grpc.CallOption) (*FirewallPolicyRule, error) {
	out := new(FirewallPolicyRule)
	err := c.cc.Invoke(ctx, FirewallPolicies_GetRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firewallPoliciesClient) Insert(ctx context.Context, in *InsertFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, FirewallPolicies_Insert_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firewallPoliciesClient) List(ctx context.Context, in *ListFirewallPoliciesRequest, opts ...grpc.CallOption) (*FirewallPolicyList, error) {
	out := new(FirewallPolicyList)
	err := c.cc.Invoke(ctx, FirewallPolicies_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firewallPoliciesClient) ListAssociations(ctx context.Context, in *ListAssociationsFirewallPolicyRequest, opts ...grpc.CallOption) (*FirewallPoliciesListAssociationsResponse, error) {
	out := new(FirewallPoliciesListAssociationsResponse)
	err := c.cc.Invoke(ctx, FirewallPolicies_ListAssociations_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firewallPoliciesClient) Move(ctx context.Context, in *MoveFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, FirewallPolicies_Move_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firewallPoliciesClient) Patch(ctx context.Context, in *PatchFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, FirewallPolicies_Patch_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firewallPoliciesClient) PatchPacketMirroringRule(ctx context.Context, in *PatchPacketMirroringRuleFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, FirewallPolicies_PatchPacketMirroringRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firewallPoliciesClient) PatchRule(ctx context.Context, in *PatchRuleFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, FirewallPolicies_PatchRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firewallPoliciesClient) RemoveAssociation(ctx context.Context, in *RemoveAssociationFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, FirewallPolicies_RemoveAssociation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firewallPoliciesClient) RemovePacketMirroringRule(ctx context.Context, in *RemovePacketMirroringRuleFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, FirewallPolicies_RemovePacketMirroringRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firewallPoliciesClient) RemoveRule(ctx context.Context, in *RemoveRuleFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, FirewallPolicies_RemoveRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firewallPoliciesClient) SetIamPolicy(ctx context.Context, in *SetIamPolicyFirewallPolicyRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, FirewallPolicies_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firewallPoliciesClient) TestIamPermissions(ctx context.Context, in *TestIamPermissionsFirewallPolicyRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error) {
	out := new(TestPermissionsResponse)
	err := c.cc.Invoke(ctx, FirewallPolicies_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// FirewallPoliciesServer is the server API for FirewallPolicies service.
// All implementations should embed UnimplementedFirewallPoliciesServer
// for forward compatibility
type FirewallPoliciesServer interface {
	// Inserts an association for the specified firewall policy.
	AddAssociation(context.Context, *AddAssociationFirewallPolicyRequest) (*Operation, error)
	// Inserts a packet mirroring rule into a firewall policy.
	AddPacketMirroringRule(context.Context, *AddPacketMirroringRuleFirewallPolicyRequest) (*Operation, error)
	// Inserts a rule into a firewall policy.
	AddRule(context.Context, *AddRuleFirewallPolicyRequest) (*Operation, error)
	// Copies rules to the specified firewall policy.
	CloneRules(context.Context, *CloneRulesFirewallPolicyRequest) (*Operation, error)
	// Deletes the specified policy.
	Delete(context.Context, *DeleteFirewallPolicyRequest) (*Operation, error)
	// Returns the specified firewall policy.
	Get(context.Context, *GetFirewallPolicyRequest) (*FirewallPolicy, error)
	// Gets an association with the specified name.
	GetAssociation(context.Context, *GetAssociationFirewallPolicyRequest) (*FirewallPolicyAssociation, error)
	// Gets the access control policy for a resource. May be empty if no such policy or resource exists.
	GetIamPolicy(context.Context, *GetIamPolicyFirewallPolicyRequest) (*Policy, error)
	// Gets a packet mirroring rule of the specified priority.
	GetPacketMirroringRule(context.Context, *GetPacketMirroringRuleFirewallPolicyRequest) (*FirewallPolicyRule, error)
	// Gets a rule of the specified priority.
	GetRule(context.Context, *GetRuleFirewallPolicyRequest) (*FirewallPolicyRule, error)
	// Creates a new policy in the specified project using the data included in the request.
	Insert(context.Context, *InsertFirewallPolicyRequest) (*Operation, error)
	// Lists all the policies that have been configured for the specified folder or organization.
	List(context.Context, *ListFirewallPoliciesRequest) (*FirewallPolicyList, error)
	// Lists associations of a specified target, i.e., organization or folder.
	ListAssociations(context.Context, *ListAssociationsFirewallPolicyRequest) (*FirewallPoliciesListAssociationsResponse, error)
	// Moves the specified firewall policy.
	Move(context.Context, *MoveFirewallPolicyRequest) (*Operation, error)
	// Patches the specified policy with the data included in the request.
	Patch(context.Context, *PatchFirewallPolicyRequest) (*Operation, error)
	// Patches a packet mirroring rule of the specified priority.
	PatchPacketMirroringRule(context.Context, *PatchPacketMirroringRuleFirewallPolicyRequest) (*Operation, error)
	// Patches a rule of the specified priority.
	PatchRule(context.Context, *PatchRuleFirewallPolicyRequest) (*Operation, error)
	// Removes an association for the specified firewall policy.
	RemoveAssociation(context.Context, *RemoveAssociationFirewallPolicyRequest) (*Operation, error)
	// Deletes a packet mirroring rule of the specified priority.
	RemovePacketMirroringRule(context.Context, *RemovePacketMirroringRuleFirewallPolicyRequest) (*Operation, error)
	// Deletes a rule of the specified priority.
	RemoveRule(context.Context, *RemoveRuleFirewallPolicyRequest) (*Operation, error)
	// Sets the access control policy on the specified resource. Replaces any existing policy.
	SetIamPolicy(context.Context, *SetIamPolicyFirewallPolicyRequest) (*Policy, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(context.Context, *TestIamPermissionsFirewallPolicyRequest) (*TestPermissionsResponse, error)
}

// UnimplementedFirewallPoliciesServer should be embedded to have forward compatible implementations.
type UnimplementedFirewallPoliciesServer struct {
}

func (UnimplementedFirewallPoliciesServer) AddAssociation(context.Context, *AddAssociationFirewallPolicyRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddAssociation not implemented")
}
func (UnimplementedFirewallPoliciesServer) AddPacketMirroringRule(context.Context, *AddPacketMirroringRuleFirewallPolicyRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddPacketMirroringRule not implemented")
}
func (UnimplementedFirewallPoliciesServer) AddRule(context.Context, *AddRuleFirewallPolicyRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddRule not implemented")
}
func (UnimplementedFirewallPoliciesServer) CloneRules(context.Context, *CloneRulesFirewallPolicyRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CloneRules not implemented")
}
func (UnimplementedFirewallPoliciesServer) Delete(context.Context, *DeleteFirewallPolicyRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedFirewallPoliciesServer) Get(context.Context, *GetFirewallPolicyRequest) (*FirewallPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedFirewallPoliciesServer) GetAssociation(context.Context, *GetAssociationFirewallPolicyRequest) (*FirewallPolicyAssociation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAssociation not implemented")
}
func (UnimplementedFirewallPoliciesServer) GetIamPolicy(context.Context, *GetIamPolicyFirewallPolicyRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedFirewallPoliciesServer) GetPacketMirroringRule(context.Context, *GetPacketMirroringRuleFirewallPolicyRequest) (*FirewallPolicyRule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPacketMirroringRule not implemented")
}
func (UnimplementedFirewallPoliciesServer) GetRule(context.Context, *GetRuleFirewallPolicyRequest) (*FirewallPolicyRule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRule not implemented")
}
func (UnimplementedFirewallPoliciesServer) Insert(context.Context, *InsertFirewallPolicyRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (UnimplementedFirewallPoliciesServer) List(context.Context, *ListFirewallPoliciesRequest) (*FirewallPolicyList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedFirewallPoliciesServer) ListAssociations(context.Context, *ListAssociationsFirewallPolicyRequest) (*FirewallPoliciesListAssociationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAssociations not implemented")
}
func (UnimplementedFirewallPoliciesServer) Move(context.Context, *MoveFirewallPolicyRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Move not implemented")
}
func (UnimplementedFirewallPoliciesServer) Patch(context.Context, *PatchFirewallPolicyRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Patch not implemented")
}
func (UnimplementedFirewallPoliciesServer) PatchPacketMirroringRule(context.Context, *PatchPacketMirroringRuleFirewallPolicyRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PatchPacketMirroringRule not implemented")
}
func (UnimplementedFirewallPoliciesServer) PatchRule(context.Context, *PatchRuleFirewallPolicyRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PatchRule not implemented")
}
func (UnimplementedFirewallPoliciesServer) RemoveAssociation(context.Context, *RemoveAssociationFirewallPolicyRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveAssociation not implemented")
}
func (UnimplementedFirewallPoliciesServer) RemovePacketMirroringRule(context.Context, *RemovePacketMirroringRuleFirewallPolicyRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemovePacketMirroringRule not implemented")
}
func (UnimplementedFirewallPoliciesServer) RemoveRule(context.Context, *RemoveRuleFirewallPolicyRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveRule not implemented")
}
func (UnimplementedFirewallPoliciesServer) SetIamPolicy(context.Context, *SetIamPolicyFirewallPolicyRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedFirewallPoliciesServer) TestIamPermissions(context.Context, *TestIamPermissionsFirewallPolicyRequest) (*TestPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

// UnsafeFirewallPoliciesServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to FirewallPoliciesServer will
// result in compilation errors.
type UnsafeFirewallPoliciesServer interface {
	mustEmbedUnimplementedFirewallPoliciesServer()
}

func RegisterFirewallPoliciesServer(s grpc.ServiceRegistrar, srv FirewallPoliciesServer) {
	s.RegisterService(&FirewallPolicies_ServiceDesc, srv)
}

func _FirewallPolicies_AddAssociation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddAssociationFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirewallPoliciesServer).AddAssociation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirewallPolicies_AddAssociation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirewallPoliciesServer).AddAssociation(ctx, req.(*AddAssociationFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirewallPolicies_AddPacketMirroringRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddPacketMirroringRuleFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirewallPoliciesServer).AddPacketMirroringRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirewallPolicies_AddPacketMirroringRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirewallPoliciesServer).AddPacketMirroringRule(ctx, req.(*AddPacketMirroringRuleFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirewallPolicies_AddRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddRuleFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirewallPoliciesServer).AddRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirewallPolicies_AddRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirewallPoliciesServer).AddRule(ctx, req.(*AddRuleFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirewallPolicies_CloneRules_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CloneRulesFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirewallPoliciesServer).CloneRules(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirewallPolicies_CloneRules_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirewallPoliciesServer).CloneRules(ctx, req.(*CloneRulesFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirewallPolicies_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirewallPoliciesServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirewallPolicies_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirewallPoliciesServer).Delete(ctx, req.(*DeleteFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirewallPolicies_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirewallPoliciesServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirewallPolicies_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirewallPoliciesServer).Get(ctx, req.(*GetFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirewallPolicies_GetAssociation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAssociationFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirewallPoliciesServer).GetAssociation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirewallPolicies_GetAssociation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirewallPoliciesServer).GetAssociation(ctx, req.(*GetAssociationFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirewallPolicies_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIamPolicyFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirewallPoliciesServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirewallPolicies_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirewallPoliciesServer).GetIamPolicy(ctx, req.(*GetIamPolicyFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirewallPolicies_GetPacketMirroringRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPacketMirroringRuleFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirewallPoliciesServer).GetPacketMirroringRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirewallPolicies_GetPacketMirroringRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirewallPoliciesServer).GetPacketMirroringRule(ctx, req.(*GetPacketMirroringRuleFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirewallPolicies_GetRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRuleFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirewallPoliciesServer).GetRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirewallPolicies_GetRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirewallPoliciesServer).GetRule(ctx, req.(*GetRuleFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirewallPolicies_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirewallPoliciesServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirewallPolicies_Insert_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirewallPoliciesServer).Insert(ctx, req.(*InsertFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirewallPolicies_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFirewallPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirewallPoliciesServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirewallPolicies_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirewallPoliciesServer).List(ctx, req.(*ListFirewallPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirewallPolicies_ListAssociations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAssociationsFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirewallPoliciesServer).ListAssociations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirewallPolicies_ListAssociations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirewallPoliciesServer).ListAssociations(ctx, req.(*ListAssociationsFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirewallPolicies_Move_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MoveFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirewallPoliciesServer).Move(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirewallPolicies_Move_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirewallPoliciesServer).Move(ctx, req.(*MoveFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirewallPolicies_Patch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirewallPoliciesServer).Patch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirewallPolicies_Patch_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirewallPoliciesServer).Patch(ctx, req.(*PatchFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirewallPolicies_PatchPacketMirroringRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchPacketMirroringRuleFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirewallPoliciesServer).PatchPacketMirroringRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirewallPolicies_PatchPacketMirroringRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirewallPoliciesServer).PatchPacketMirroringRule(ctx, req.(*PatchPacketMirroringRuleFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirewallPolicies_PatchRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchRuleFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirewallPoliciesServer).PatchRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirewallPolicies_PatchRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirewallPoliciesServer).PatchRule(ctx, req.(*PatchRuleFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirewallPolicies_RemoveAssociation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveAssociationFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirewallPoliciesServer).RemoveAssociation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirewallPolicies_RemoveAssociation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirewallPoliciesServer).RemoveAssociation(ctx, req.(*RemoveAssociationFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirewallPolicies_RemovePacketMirroringRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemovePacketMirroringRuleFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirewallPoliciesServer).RemovePacketMirroringRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirewallPolicies_RemovePacketMirroringRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirewallPoliciesServer).RemovePacketMirroringRule(ctx, req.(*RemovePacketMirroringRuleFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirewallPolicies_RemoveRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveRuleFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirewallPoliciesServer).RemoveRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirewallPolicies_RemoveRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirewallPoliciesServer).RemoveRule(ctx, req.(*RemoveRuleFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirewallPolicies_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetIamPolicyFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirewallPoliciesServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirewallPolicies_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirewallPoliciesServer).SetIamPolicy(ctx, req.(*SetIamPolicyFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FirewallPolicies_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TestIamPermissionsFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirewallPoliciesServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FirewallPolicies_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirewallPoliciesServer).TestIamPermissions(ctx, req.(*TestIamPermissionsFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// FirewallPolicies_ServiceDesc is the grpc.ServiceDesc for FirewallPolicies service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var FirewallPolicies_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.FirewallPolicies",
	HandlerType: (*FirewallPoliciesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AddAssociation",
			Handler:    _FirewallPolicies_AddAssociation_Handler,
		},
		{
			MethodName: "AddPacketMirroringRule",
			Handler:    _FirewallPolicies_AddPacketMirroringRule_Handler,
		},
		{
			MethodName: "AddRule",
			Handler:    _FirewallPolicies_AddRule_Handler,
		},
		{
			MethodName: "CloneRules",
			Handler:    _FirewallPolicies_CloneRules_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _FirewallPolicies_Delete_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _FirewallPolicies_Get_Handler,
		},
		{
			MethodName: "GetAssociation",
			Handler:    _FirewallPolicies_GetAssociation_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _FirewallPolicies_GetIamPolicy_Handler,
		},
		{
			MethodName: "GetPacketMirroringRule",
			Handler:    _FirewallPolicies_GetPacketMirroringRule_Handler,
		},
		{
			MethodName: "GetRule",
			Handler:    _FirewallPolicies_GetRule_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _FirewallPolicies_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _FirewallPolicies_List_Handler,
		},
		{
			MethodName: "ListAssociations",
			Handler:    _FirewallPolicies_ListAssociations_Handler,
		},
		{
			MethodName: "Move",
			Handler:    _FirewallPolicies_Move_Handler,
		},
		{
			MethodName: "Patch",
			Handler:    _FirewallPolicies_Patch_Handler,
		},
		{
			MethodName: "PatchPacketMirroringRule",
			Handler:    _FirewallPolicies_PatchPacketMirroringRule_Handler,
		},
		{
			MethodName: "PatchRule",
			Handler:    _FirewallPolicies_PatchRule_Handler,
		},
		{
			MethodName: "RemoveAssociation",
			Handler:    _FirewallPolicies_RemoveAssociation_Handler,
		},
		{
			MethodName: "RemovePacketMirroringRule",
			Handler:    _FirewallPolicies_RemovePacketMirroringRule_Handler,
		},
		{
			MethodName: "RemoveRule",
			Handler:    _FirewallPolicies_RemoveRule_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _FirewallPolicies_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _FirewallPolicies_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	Firewalls_Delete_FullMethodName             = "/google.cloud.compute.v1beta.Firewalls/Delete"
	Firewalls_Get_FullMethodName                = "/google.cloud.compute.v1beta.Firewalls/Get"
	Firewalls_Insert_FullMethodName             = "/google.cloud.compute.v1beta.Firewalls/Insert"
	Firewalls_List_FullMethodName               = "/google.cloud.compute.v1beta.Firewalls/List"
	Firewalls_Patch_FullMethodName              = "/google.cloud.compute.v1beta.Firewalls/Patch"
	Firewalls_TestIamPermissions_FullMethodName = "/google.cloud.compute.v1beta.Firewalls/TestIamPermissions"
	Firewalls_Update_FullMethodName             = "/google.cloud.compute.v1beta.Firewalls/Update"
)

// FirewallsClient is the client API for Firewalls service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type FirewallsClient interface {
	// Deletes the specified firewall.
	Delete(ctx context.Context, in *DeleteFirewallRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns the specified firewall.
	Get(ctx context.Context, in *GetFirewallRequest, opts ...grpc.CallOption) (*Firewall, error)
	// Creates a firewall rule in the specified project using the data included in the request.
	Insert(ctx context.Context, in *InsertFirewallRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves the list of firewall rules available to the specified project.
	List(ctx context.Context, in *ListFirewallsRequest, opts ...grpc.CallOption) (*FirewallList, error)
	// Updates the specified firewall rule with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
	Patch(ctx context.Context, in *PatchFirewallRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(ctx context.Context, in *TestIamPermissionsFirewallRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error)
	// Updates the specified firewall rule with the data included in the request. Note that all fields will be updated if using PUT, even fields that are not specified. To update individual fields, please use PATCH instead.
	Update(ctx context.Context, in *UpdateFirewallRequest, opts ...grpc.CallOption) (*Operation, error)
}

type firewallsClient struct {
	cc grpc.ClientConnInterface
}

func NewFirewallsClient(cc grpc.ClientConnInterface) FirewallsClient {
	return &firewallsClient{cc}
}

func (c *firewallsClient) Delete(ctx context.Context, in *DeleteFirewallRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Firewalls_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firewallsClient) Get(ctx context.Context, in *GetFirewallRequest, opts ...grpc.CallOption) (*Firewall, error) {
	out := new(Firewall)
	err := c.cc.Invoke(ctx, Firewalls_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firewallsClient) Insert(ctx context.Context, in *InsertFirewallRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Firewalls_Insert_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firewallsClient) List(ctx context.Context, in *ListFirewallsRequest, opts ...grpc.CallOption) (*FirewallList, error) {
	out := new(FirewallList)
	err := c.cc.Invoke(ctx, Firewalls_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firewallsClient) Patch(ctx context.Context, in *PatchFirewallRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Firewalls_Patch_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firewallsClient) TestIamPermissions(ctx context.Context, in *TestIamPermissionsFirewallRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error) {
	out := new(TestPermissionsResponse)
	err := c.cc.Invoke(ctx, Firewalls_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *firewallsClient) Update(ctx context.Context, in *UpdateFirewallRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Firewalls_Update_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// FirewallsServer is the server API for Firewalls service.
// All implementations should embed UnimplementedFirewallsServer
// for forward compatibility
type FirewallsServer interface {
	// Deletes the specified firewall.
	Delete(context.Context, *DeleteFirewallRequest) (*Operation, error)
	// Returns the specified firewall.
	Get(context.Context, *GetFirewallRequest) (*Firewall, error)
	// Creates a firewall rule in the specified project using the data included in the request.
	Insert(context.Context, *InsertFirewallRequest) (*Operation, error)
	// Retrieves the list of firewall rules available to the specified project.
	List(context.Context, *ListFirewallsRequest) (*FirewallList, error)
	// Updates the specified firewall rule with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
	Patch(context.Context, *PatchFirewallRequest) (*Operation, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(context.Context, *TestIamPermissionsFirewallRequest) (*TestPermissionsResponse, error)
	// Updates the specified firewall rule with the data included in the request. Note that all fields will be updated if using PUT, even fields that are not specified. To update individual fields, please use PATCH instead.
	Update(context.Context, *UpdateFirewallRequest) (*Operation, error)
}

// UnimplementedFirewallsServer should be embedded to have forward compatible implementations.
type UnimplementedFirewallsServer struct {
}

func (UnimplementedFirewallsServer) Delete(context.Context, *DeleteFirewallRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedFirewallsServer) Get(context.Context, *GetFirewallRequest) (*Firewall, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedFirewallsServer) Insert(context.Context, *InsertFirewallRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (UnimplementedFirewallsServer) List(context.Context, *ListFirewallsRequest) (*FirewallList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedFirewallsServer) Patch(context.Context, *PatchFirewallRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Patch not implemented")
}
func (UnimplementedFirewallsServer) TestIamPermissions(context.Context, *TestIamPermissionsFirewallRequest) (*TestPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}
func (UnimplementedFirewallsServer) Update(context.Context, *UpdateFirewallRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}

// UnsafeFirewallsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to FirewallsServer will
// result in compilation errors.
type UnsafeFirewallsServer interface {
	mustEmbedUnimplementedFirewallsServer()
}

func RegisterFirewallsServer(s grpc.ServiceRegistrar, srv FirewallsServer) {
	s.RegisterService(&Firewalls_ServiceDesc, srv)
}

func _Firewalls_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFirewallRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirewallsServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Firewalls_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirewallsServer).Delete(ctx, req.(*DeleteFirewallRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firewalls_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFirewallRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirewallsServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Firewalls_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirewallsServer).Get(ctx, req.(*GetFirewallRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firewalls_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertFirewallRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirewallsServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Firewalls_Insert_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirewallsServer).Insert(ctx, req.(*InsertFirewallRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firewalls_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFirewallsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirewallsServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Firewalls_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirewallsServer).List(ctx, req.(*ListFirewallsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firewalls_Patch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchFirewallRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirewallsServer).Patch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Firewalls_Patch_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirewallsServer).Patch(ctx, req.(*PatchFirewallRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firewalls_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TestIamPermissionsFirewallRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirewallsServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Firewalls_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirewallsServer).TestIamPermissions(ctx, req.(*TestIamPermissionsFirewallRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Firewalls_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFirewallRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FirewallsServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Firewalls_Update_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FirewallsServer).Update(ctx, req.(*UpdateFirewallRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Firewalls_ServiceDesc is the grpc.ServiceDesc for Firewalls service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Firewalls_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.Firewalls",
	HandlerType: (*FirewallsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Delete",
			Handler:    _Firewalls_Delete_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _Firewalls_Get_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _Firewalls_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _Firewalls_List_Handler,
		},
		{
			MethodName: "Patch",
			Handler:    _Firewalls_Patch_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _Firewalls_TestIamPermissions_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _Firewalls_Update_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	ForwardingRules_AggregatedList_FullMethodName     = "/google.cloud.compute.v1beta.ForwardingRules/AggregatedList"
	ForwardingRules_Delete_FullMethodName             = "/google.cloud.compute.v1beta.ForwardingRules/Delete"
	ForwardingRules_Get_FullMethodName                = "/google.cloud.compute.v1beta.ForwardingRules/Get"
	ForwardingRules_Insert_FullMethodName             = "/google.cloud.compute.v1beta.ForwardingRules/Insert"
	ForwardingRules_List_FullMethodName               = "/google.cloud.compute.v1beta.ForwardingRules/List"
	ForwardingRules_Patch_FullMethodName              = "/google.cloud.compute.v1beta.ForwardingRules/Patch"
	ForwardingRules_SetLabels_FullMethodName          = "/google.cloud.compute.v1beta.ForwardingRules/SetLabels"
	ForwardingRules_SetTarget_FullMethodName          = "/google.cloud.compute.v1beta.ForwardingRules/SetTarget"
	ForwardingRules_TestIamPermissions_FullMethodName = "/google.cloud.compute.v1beta.ForwardingRules/TestIamPermissions"
)

// ForwardingRulesClient is the client API for ForwardingRules service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ForwardingRulesClient interface {
	// Retrieves an aggregated list of forwarding rules. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(ctx context.Context, in *AggregatedListForwardingRulesRequest, opts ...grpc.CallOption) (*ForwardingRuleAggregatedList, error)
	// Deletes the specified ForwardingRule resource.
	Delete(ctx context.Context, in *DeleteForwardingRuleRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns the specified ForwardingRule resource.
	Get(ctx context.Context, in *GetForwardingRuleRequest, opts ...grpc.CallOption) (*ForwardingRule, error)
	// Creates a ForwardingRule resource in the specified project and region using the data included in the request.
	Insert(ctx context.Context, in *InsertForwardingRuleRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves a list of ForwardingRule resources available to the specified project and region.
	List(ctx context.Context, in *ListForwardingRulesRequest, opts ...grpc.CallOption) (*ForwardingRuleList, error)
	// Updates the specified forwarding rule with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules. Currently, you can only patch the network_tier field.
	Patch(ctx context.Context, in *PatchForwardingRuleRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the labels on the specified resource. To learn more about labels, read the Labeling Resources documentation.
	SetLabels(ctx context.Context, in *SetLabelsForwardingRuleRequest, opts ...grpc.CallOption) (*Operation, error)
	// Changes target URL for forwarding rule. The new target should be of the same type as the old target.
	SetTarget(ctx context.Context, in *SetTargetForwardingRuleRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(ctx context.Context, in *TestIamPermissionsForwardingRuleRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error)
}

type forwardingRulesClient struct {
	cc grpc.ClientConnInterface
}

func NewForwardingRulesClient(cc grpc.ClientConnInterface) ForwardingRulesClient {
	return &forwardingRulesClient{cc}
}

func (c *forwardingRulesClient) AggregatedList(ctx context.Context, in *AggregatedListForwardingRulesRequest, opts ...grpc.CallOption) (*ForwardingRuleAggregatedList, error) {
	out := new(ForwardingRuleAggregatedList)
	err := c.cc.Invoke(ctx, ForwardingRules_AggregatedList_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *forwardingRulesClient) Delete(ctx context.Context, in *DeleteForwardingRuleRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, ForwardingRules_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *forwardingRulesClient) Get(ctx context.Context, in *GetForwardingRuleRequest, opts ...grpc.CallOption) (*ForwardingRule, error) {
	out := new(ForwardingRule)
	err := c.cc.Invoke(ctx, ForwardingRules_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *forwardingRulesClient) Insert(ctx context.Context, in *InsertForwardingRuleRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, ForwardingRules_Insert_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *forwardingRulesClient) List(ctx context.Context, in *ListForwardingRulesRequest, opts ...grpc.CallOption) (*ForwardingRuleList, error) {
	out := new(ForwardingRuleList)
	err := c.cc.Invoke(ctx, ForwardingRules_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *forwardingRulesClient) Patch(ctx context.Context, in *PatchForwardingRuleRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, ForwardingRules_Patch_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *forwardingRulesClient) SetLabels(ctx context.Context, in *SetLabelsForwardingRuleRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, ForwardingRules_SetLabels_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *forwardingRulesClient) SetTarget(ctx context.Context, in *SetTargetForwardingRuleRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, ForwardingRules_SetTarget_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *forwardingRulesClient) TestIamPermissions(ctx context.Context, in *TestIamPermissionsForwardingRuleRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error) {
	out := new(TestPermissionsResponse)
	err := c.cc.Invoke(ctx, ForwardingRules_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ForwardingRulesServer is the server API for ForwardingRules service.
// All implementations should embed UnimplementedForwardingRulesServer
// for forward compatibility
type ForwardingRulesServer interface {
	// Retrieves an aggregated list of forwarding rules. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(context.Context, *AggregatedListForwardingRulesRequest) (*ForwardingRuleAggregatedList, error)
	// Deletes the specified ForwardingRule resource.
	Delete(context.Context, *DeleteForwardingRuleRequest) (*Operation, error)
	// Returns the specified ForwardingRule resource.
	Get(context.Context, *GetForwardingRuleRequest) (*ForwardingRule, error)
	// Creates a ForwardingRule resource in the specified project and region using the data included in the request.
	Insert(context.Context, *InsertForwardingRuleRequest) (*Operation, error)
	// Retrieves a list of ForwardingRule resources available to the specified project and region.
	List(context.Context, *ListForwardingRulesRequest) (*ForwardingRuleList, error)
	// Updates the specified forwarding rule with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules. Currently, you can only patch the network_tier field.
	Patch(context.Context, *PatchForwardingRuleRequest) (*Operation, error)
	// Sets the labels on the specified resource. To learn more about labels, read the Labeling Resources documentation.
	SetLabels(context.Context, *SetLabelsForwardingRuleRequest) (*Operation, error)
	// Changes target URL for forwarding rule. The new target should be of the same type as the old target.
	SetTarget(context.Context, *SetTargetForwardingRuleRequest) (*Operation, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(context.Context, *TestIamPermissionsForwardingRuleRequest) (*TestPermissionsResponse, error)
}

// UnimplementedForwardingRulesServer should be embedded to have forward compatible implementations.
type UnimplementedForwardingRulesServer struct {
}

func (UnimplementedForwardingRulesServer) AggregatedList(context.Context, *AggregatedListForwardingRulesRequest) (*ForwardingRuleAggregatedList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AggregatedList not implemented")
}
func (UnimplementedForwardingRulesServer) Delete(context.Context, *DeleteForwardingRuleRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedForwardingRulesServer) Get(context.Context, *GetForwardingRuleRequest) (*ForwardingRule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedForwardingRulesServer) Insert(context.Context, *InsertForwardingRuleRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (UnimplementedForwardingRulesServer) List(context.Context, *ListForwardingRulesRequest) (*ForwardingRuleList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedForwardingRulesServer) Patch(context.Context, *PatchForwardingRuleRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Patch not implemented")
}
func (UnimplementedForwardingRulesServer) SetLabels(context.Context, *SetLabelsForwardingRuleRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetLabels not implemented")
}
func (UnimplementedForwardingRulesServer) SetTarget(context.Context, *SetTargetForwardingRuleRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetTarget not implemented")
}
func (UnimplementedForwardingRulesServer) TestIamPermissions(context.Context, *TestIamPermissionsForwardingRuleRequest) (*TestPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

// UnsafeForwardingRulesServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ForwardingRulesServer will
// result in compilation errors.
type UnsafeForwardingRulesServer interface {
	mustEmbedUnimplementedForwardingRulesServer()
}

func RegisterForwardingRulesServer(s grpc.ServiceRegistrar, srv ForwardingRulesServer) {
	s.RegisterService(&ForwardingRules_ServiceDesc, srv)
}

func _ForwardingRules_AggregatedList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AggregatedListForwardingRulesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ForwardingRulesServer).AggregatedList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ForwardingRules_AggregatedList_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ForwardingRulesServer).AggregatedList(ctx, req.(*AggregatedListForwardingRulesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ForwardingRules_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteForwardingRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ForwardingRulesServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ForwardingRules_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ForwardingRulesServer).Delete(ctx, req.(*DeleteForwardingRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ForwardingRules_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetForwardingRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ForwardingRulesServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ForwardingRules_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ForwardingRulesServer).Get(ctx, req.(*GetForwardingRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ForwardingRules_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertForwardingRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ForwardingRulesServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ForwardingRules_Insert_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ForwardingRulesServer).Insert(ctx, req.(*InsertForwardingRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ForwardingRules_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListForwardingRulesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ForwardingRulesServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ForwardingRules_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ForwardingRulesServer).List(ctx, req.(*ListForwardingRulesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ForwardingRules_Patch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchForwardingRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ForwardingRulesServer).Patch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ForwardingRules_Patch_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ForwardingRulesServer).Patch(ctx, req.(*PatchForwardingRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ForwardingRules_SetLabels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetLabelsForwardingRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ForwardingRulesServer).SetLabels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ForwardingRules_SetLabels_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ForwardingRulesServer).SetLabels(ctx, req.(*SetLabelsForwardingRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ForwardingRules_SetTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetTargetForwardingRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ForwardingRulesServer).SetTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ForwardingRules_SetTarget_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ForwardingRulesServer).SetTarget(ctx, req.(*SetTargetForwardingRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _ForwardingRules_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TestIamPermissionsForwardingRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ForwardingRulesServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ForwardingRules_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ForwardingRulesServer).TestIamPermissions(ctx, req.(*TestIamPermissionsForwardingRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ForwardingRules_ServiceDesc is the grpc.ServiceDesc for ForwardingRules service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ForwardingRules_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.ForwardingRules",
	HandlerType: (*ForwardingRulesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AggregatedList",
			Handler:    _ForwardingRules_AggregatedList_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _ForwardingRules_Delete_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _ForwardingRules_Get_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _ForwardingRules_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _ForwardingRules_List_Handler,
		},
		{
			MethodName: "Patch",
			Handler:    _ForwardingRules_Patch_Handler,
		},
		{
			MethodName: "SetLabels",
			Handler:    _ForwardingRules_SetLabels_Handler,
		},
		{
			MethodName: "SetTarget",
			Handler:    _ForwardingRules_SetTarget_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _ForwardingRules_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	FutureReservations_AggregatedList_FullMethodName = "/google.cloud.compute.v1beta.FutureReservations/AggregatedList"
	FutureReservations_Cancel_FullMethodName         = "/google.cloud.compute.v1beta.FutureReservations/Cancel"
	FutureReservations_Delete_FullMethodName         = "/google.cloud.compute.v1beta.FutureReservations/Delete"
	FutureReservations_Get_FullMethodName            = "/google.cloud.compute.v1beta.FutureReservations/Get"
	FutureReservations_Insert_FullMethodName         = "/google.cloud.compute.v1beta.FutureReservations/Insert"
	FutureReservations_List_FullMethodName           = "/google.cloud.compute.v1beta.FutureReservations/List"
	FutureReservations_Update_FullMethodName         = "/google.cloud.compute.v1beta.FutureReservations/Update"
)

// FutureReservationsClient is the client API for FutureReservations service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type FutureReservationsClient interface {
	// Retrieves an aggregated list of future reservations. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(ctx context.Context, in *AggregatedListFutureReservationsRequest, opts ...grpc.CallOption) (*FutureReservationsAggregatedListResponse, error)
	// Cancel the specified future reservation.
	Cancel(ctx context.Context, in *CancelFutureReservationRequest, opts ...grpc.CallOption) (*Operation, error)
	// Deletes the specified future reservation.
	Delete(ctx context.Context, in *DeleteFutureReservationRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves information about the specified future reservation.
	Get(ctx context.Context, in *GetFutureReservationRequest, opts ...grpc.CallOption) (*FutureReservation, error)
	// Creates a new Future Reservation.
	Insert(ctx context.Context, in *InsertFutureReservationRequest, opts ...grpc.CallOption) (*Operation, error)
	// A list of all the future reservations that have been configured for the specified project in specified zone.
	List(ctx context.Context, in *ListFutureReservationsRequest, opts ...grpc.CallOption) (*FutureReservationsListResponse, error)
	// Updates the specified future reservation.
	Update(ctx context.Context, in *UpdateFutureReservationRequest, opts ...grpc.CallOption) (*Operation, error)
}

type futureReservationsClient struct {
	cc grpc.ClientConnInterface
}

func NewFutureReservationsClient(cc grpc.ClientConnInterface) FutureReservationsClient {
	return &futureReservationsClient{cc}
}

func (c *futureReservationsClient) AggregatedList(ctx context.Context, in *AggregatedListFutureReservationsRequest, opts ...grpc.CallOption) (*FutureReservationsAggregatedListResponse, error) {
	out := new(FutureReservationsAggregatedListResponse)
	err := c.cc.Invoke(ctx, FutureReservations_AggregatedList_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *futureReservationsClient) Cancel(ctx context.Context, in *CancelFutureReservationRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, FutureReservations_Cancel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *futureReservationsClient) Delete(ctx context.Context, in *DeleteFutureReservationRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, FutureReservations_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *futureReservationsClient) Get(ctx context.Context, in *GetFutureReservationRequest, opts ...grpc.CallOption) (*FutureReservation, error) {
	out := new(FutureReservation)
	err := c.cc.Invoke(ctx, FutureReservations_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *futureReservationsClient) Insert(ctx context.Context, in *InsertFutureReservationRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, FutureReservations_Insert_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *futureReservationsClient) List(ctx context.Context, in *ListFutureReservationsRequest, opts ...grpc.CallOption) (*FutureReservationsListResponse, error) {
	out := new(FutureReservationsListResponse)
	err := c.cc.Invoke(ctx, FutureReservations_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *futureReservationsClient) Update(ctx context.Context, in *UpdateFutureReservationRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, FutureReservations_Update_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// FutureReservationsServer is the server API for FutureReservations service.
// All implementations should embed UnimplementedFutureReservationsServer
// for forward compatibility
type FutureReservationsServer interface {
	// Retrieves an aggregated list of future reservations. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(context.Context, *AggregatedListFutureReservationsRequest) (*FutureReservationsAggregatedListResponse, error)
	// Cancel the specified future reservation.
	Cancel(context.Context, *CancelFutureReservationRequest) (*Operation, error)
	// Deletes the specified future reservation.
	Delete(context.Context, *DeleteFutureReservationRequest) (*Operation, error)
	// Retrieves information about the specified future reservation.
	Get(context.Context, *GetFutureReservationRequest) (*FutureReservation, error)
	// Creates a new Future Reservation.
	Insert(context.Context, *InsertFutureReservationRequest) (*Operation, error)
	// A list of all the future reservations that have been configured for the specified project in specified zone.
	List(context.Context, *ListFutureReservationsRequest) (*FutureReservationsListResponse, error)
	// Updates the specified future reservation.
	Update(context.Context, *UpdateFutureReservationRequest) (*Operation, error)
}

// UnimplementedFutureReservationsServer should be embedded to have forward compatible implementations.
type UnimplementedFutureReservationsServer struct {
}

func (UnimplementedFutureReservationsServer) AggregatedList(context.Context, *AggregatedListFutureReservationsRequest) (*FutureReservationsAggregatedListResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AggregatedList not implemented")
}
func (UnimplementedFutureReservationsServer) Cancel(context.Context, *CancelFutureReservationRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Cancel not implemented")
}
func (UnimplementedFutureReservationsServer) Delete(context.Context, *DeleteFutureReservationRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedFutureReservationsServer) Get(context.Context, *GetFutureReservationRequest) (*FutureReservation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedFutureReservationsServer) Insert(context.Context, *InsertFutureReservationRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (UnimplementedFutureReservationsServer) List(context.Context, *ListFutureReservationsRequest) (*FutureReservationsListResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedFutureReservationsServer) Update(context.Context, *UpdateFutureReservationRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}

// UnsafeFutureReservationsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to FutureReservationsServer will
// result in compilation errors.
type UnsafeFutureReservationsServer interface {
	mustEmbedUnimplementedFutureReservationsServer()
}

func RegisterFutureReservationsServer(s grpc.ServiceRegistrar, srv FutureReservationsServer) {
	s.RegisterService(&FutureReservations_ServiceDesc, srv)
}

func _FutureReservations_AggregatedList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AggregatedListFutureReservationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FutureReservationsServer).AggregatedList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FutureReservations_AggregatedList_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FutureReservationsServer).AggregatedList(ctx, req.(*AggregatedListFutureReservationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FutureReservations_Cancel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelFutureReservationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FutureReservationsServer).Cancel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FutureReservations_Cancel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FutureReservationsServer).Cancel(ctx, req.(*CancelFutureReservationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FutureReservations_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteFutureReservationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FutureReservationsServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FutureReservations_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FutureReservationsServer).Delete(ctx, req.(*DeleteFutureReservationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FutureReservations_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFutureReservationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FutureReservationsServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FutureReservations_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FutureReservationsServer).Get(ctx, req.(*GetFutureReservationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FutureReservations_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertFutureReservationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FutureReservationsServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FutureReservations_Insert_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FutureReservationsServer).Insert(ctx, req.(*InsertFutureReservationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FutureReservations_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFutureReservationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FutureReservationsServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FutureReservations_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FutureReservationsServer).List(ctx, req.(*ListFutureReservationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _FutureReservations_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFutureReservationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(FutureReservationsServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: FutureReservations_Update_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(FutureReservationsServer).Update(ctx, req.(*UpdateFutureReservationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// FutureReservations_ServiceDesc is the grpc.ServiceDesc for FutureReservations service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var FutureReservations_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.FutureReservations",
	HandlerType: (*FutureReservationsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AggregatedList",
			Handler:    _FutureReservations_AggregatedList_Handler,
		},
		{
			MethodName: "Cancel",
			Handler:    _FutureReservations_Cancel_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _FutureReservations_Delete_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _FutureReservations_Get_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _FutureReservations_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _FutureReservations_List_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _FutureReservations_Update_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	GlobalAddresses_Delete_FullMethodName             = "/google.cloud.compute.v1beta.GlobalAddresses/Delete"
	GlobalAddresses_Get_FullMethodName                = "/google.cloud.compute.v1beta.GlobalAddresses/Get"
	GlobalAddresses_Insert_FullMethodName             = "/google.cloud.compute.v1beta.GlobalAddresses/Insert"
	GlobalAddresses_List_FullMethodName               = "/google.cloud.compute.v1beta.GlobalAddresses/List"
	GlobalAddresses_Move_FullMethodName               = "/google.cloud.compute.v1beta.GlobalAddresses/Move"
	GlobalAddresses_SetLabels_FullMethodName          = "/google.cloud.compute.v1beta.GlobalAddresses/SetLabels"
	GlobalAddresses_TestIamPermissions_FullMethodName = "/google.cloud.compute.v1beta.GlobalAddresses/TestIamPermissions"
)

// GlobalAddressesClient is the client API for GlobalAddresses service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type GlobalAddressesClient interface {
	// Deletes the specified address resource.
	Delete(ctx context.Context, in *DeleteGlobalAddressRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns the specified address resource.
	Get(ctx context.Context, in *GetGlobalAddressRequest, opts ...grpc.CallOption) (*Address, error)
	// Creates an address resource in the specified project by using the data included in the request.
	Insert(ctx context.Context, in *InsertGlobalAddressRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves a list of global addresses.
	List(ctx context.Context, in *ListGlobalAddressesRequest, opts ...grpc.CallOption) (*AddressList, error)
	// Moves the specified address resource from one project to another project.
	Move(ctx context.Context, in *MoveGlobalAddressRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the labels on a GlobalAddress. To learn more about labels, read the Labeling Resources documentation.
	SetLabels(ctx context.Context, in *SetLabelsGlobalAddressRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(ctx context.Context, in *TestIamPermissionsGlobalAddressRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error)
}

type globalAddressesClient struct {
	cc grpc.ClientConnInterface
}

func NewGlobalAddressesClient(cc grpc.ClientConnInterface) GlobalAddressesClient {
	return &globalAddressesClient{cc}
}

func (c *globalAddressesClient) Delete(ctx context.Context, in *DeleteGlobalAddressRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, GlobalAddresses_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *globalAddressesClient) Get(ctx context.Context, in *GetGlobalAddressRequest, opts ...grpc.CallOption) (*Address, error) {
	out := new(Address)
	err := c.cc.Invoke(ctx, GlobalAddresses_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *globalAddressesClient) Insert(ctx context.Context, in *InsertGlobalAddressRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, GlobalAddresses_Insert_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *globalAddressesClient) List(ctx context.Context, in *ListGlobalAddressesRequest, opts ...grpc.CallOption) (*AddressList, error) {
	out := new(AddressList)
	err := c.cc.Invoke(ctx, GlobalAddresses_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *globalAddressesClient) Move(ctx context.Context, in *MoveGlobalAddressRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, GlobalAddresses_Move_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *globalAddressesClient) SetLabels(ctx context.Context, in *SetLabelsGlobalAddressRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, GlobalAddresses_SetLabels_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *globalAddressesClient) TestIamPermissions(ctx context.Context, in *TestIamPermissionsGlobalAddressRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error) {
	out := new(TestPermissionsResponse)
	err := c.cc.Invoke(ctx, GlobalAddresses_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// GlobalAddressesServer is the server API for GlobalAddresses service.
// All implementations should embed UnimplementedGlobalAddressesServer
// for forward compatibility
type GlobalAddressesServer interface {
	// Deletes the specified address resource.
	Delete(context.Context, *DeleteGlobalAddressRequest) (*Operation, error)
	// Returns the specified address resource.
	Get(context.Context, *GetGlobalAddressRequest) (*Address, error)
	// Creates an address resource in the specified project by using the data included in the request.
	Insert(context.Context, *InsertGlobalAddressRequest) (*Operation, error)
	// Retrieves a list of global addresses.
	List(context.Context, *ListGlobalAddressesRequest) (*AddressList, error)
	// Moves the specified address resource from one project to another project.
	Move(context.Context, *MoveGlobalAddressRequest) (*Operation, error)
	// Sets the labels on a GlobalAddress. To learn more about labels, read the Labeling Resources documentation.
	SetLabels(context.Context, *SetLabelsGlobalAddressRequest) (*Operation, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(context.Context, *TestIamPermissionsGlobalAddressRequest) (*TestPermissionsResponse, error)
}

// UnimplementedGlobalAddressesServer should be embedded to have forward compatible implementations.
type UnimplementedGlobalAddressesServer struct {
}

func (UnimplementedGlobalAddressesServer) Delete(context.Context, *DeleteGlobalAddressRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedGlobalAddressesServer) Get(context.Context, *GetGlobalAddressRequest) (*Address, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedGlobalAddressesServer) Insert(context.Context, *InsertGlobalAddressRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (UnimplementedGlobalAddressesServer) List(context.Context, *ListGlobalAddressesRequest) (*AddressList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedGlobalAddressesServer) Move(context.Context, *MoveGlobalAddressRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Move not implemented")
}
func (UnimplementedGlobalAddressesServer) SetLabels(context.Context, *SetLabelsGlobalAddressRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetLabels not implemented")
}
func (UnimplementedGlobalAddressesServer) TestIamPermissions(context.Context, *TestIamPermissionsGlobalAddressRequest) (*TestPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

// UnsafeGlobalAddressesServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to GlobalAddressesServer will
// result in compilation errors.
type UnsafeGlobalAddressesServer interface {
	mustEmbedUnimplementedGlobalAddressesServer()
}

func RegisterGlobalAddressesServer(s grpc.ServiceRegistrar, srv GlobalAddressesServer) {
	s.RegisterService(&GlobalAddresses_ServiceDesc, srv)
}

func _GlobalAddresses_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteGlobalAddressRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GlobalAddressesServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GlobalAddresses_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GlobalAddressesServer).Delete(ctx, req.(*DeleteGlobalAddressRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GlobalAddresses_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGlobalAddressRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GlobalAddressesServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GlobalAddresses_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GlobalAddressesServer).Get(ctx, req.(*GetGlobalAddressRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GlobalAddresses_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertGlobalAddressRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GlobalAddressesServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GlobalAddresses_Insert_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GlobalAddressesServer).Insert(ctx, req.(*InsertGlobalAddressRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GlobalAddresses_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListGlobalAddressesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GlobalAddressesServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GlobalAddresses_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GlobalAddressesServer).List(ctx, req.(*ListGlobalAddressesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GlobalAddresses_Move_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MoveGlobalAddressRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GlobalAddressesServer).Move(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GlobalAddresses_Move_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GlobalAddressesServer).Move(ctx, req.(*MoveGlobalAddressRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GlobalAddresses_SetLabels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetLabelsGlobalAddressRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GlobalAddressesServer).SetLabels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GlobalAddresses_SetLabels_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GlobalAddressesServer).SetLabels(ctx, req.(*SetLabelsGlobalAddressRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GlobalAddresses_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TestIamPermissionsGlobalAddressRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GlobalAddressesServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GlobalAddresses_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GlobalAddressesServer).TestIamPermissions(ctx, req.(*TestIamPermissionsGlobalAddressRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// GlobalAddresses_ServiceDesc is the grpc.ServiceDesc for GlobalAddresses service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var GlobalAddresses_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.GlobalAddresses",
	HandlerType: (*GlobalAddressesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Delete",
			Handler:    _GlobalAddresses_Delete_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _GlobalAddresses_Get_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _GlobalAddresses_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _GlobalAddresses_List_Handler,
		},
		{
			MethodName: "Move",
			Handler:    _GlobalAddresses_Move_Handler,
		},
		{
			MethodName: "SetLabels",
			Handler:    _GlobalAddresses_SetLabels_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _GlobalAddresses_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	GlobalForwardingRules_Delete_FullMethodName             = "/google.cloud.compute.v1beta.GlobalForwardingRules/Delete"
	GlobalForwardingRules_Get_FullMethodName                = "/google.cloud.compute.v1beta.GlobalForwardingRules/Get"
	GlobalForwardingRules_Insert_FullMethodName             = "/google.cloud.compute.v1beta.GlobalForwardingRules/Insert"
	GlobalForwardingRules_List_FullMethodName               = "/google.cloud.compute.v1beta.GlobalForwardingRules/List"
	GlobalForwardingRules_Patch_FullMethodName              = "/google.cloud.compute.v1beta.GlobalForwardingRules/Patch"
	GlobalForwardingRules_SetLabels_FullMethodName          = "/google.cloud.compute.v1beta.GlobalForwardingRules/SetLabels"
	GlobalForwardingRules_SetTarget_FullMethodName          = "/google.cloud.compute.v1beta.GlobalForwardingRules/SetTarget"
	GlobalForwardingRules_TestIamPermissions_FullMethodName = "/google.cloud.compute.v1beta.GlobalForwardingRules/TestIamPermissions"
)

// GlobalForwardingRulesClient is the client API for GlobalForwardingRules service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type GlobalForwardingRulesClient interface {
	// Deletes the specified GlobalForwardingRule resource.
	Delete(ctx context.Context, in *DeleteGlobalForwardingRuleRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns the specified GlobalForwardingRule resource. Gets a list of available forwarding rules by making a list() request.
	Get(ctx context.Context, in *GetGlobalForwardingRuleRequest, opts ...grpc.CallOption) (*ForwardingRule, error)
	// Creates a GlobalForwardingRule resource in the specified project using the data included in the request.
	Insert(ctx context.Context, in *InsertGlobalForwardingRuleRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves a list of GlobalForwardingRule resources available to the specified project.
	List(ctx context.Context, in *ListGlobalForwardingRulesRequest, opts ...grpc.CallOption) (*ForwardingRuleList, error)
	// Updates the specified forwarding rule with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules. Currently, you can only patch the network_tier field.
	Patch(ctx context.Context, in *PatchGlobalForwardingRuleRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the labels on the specified resource. To learn more about labels, read the Labeling resources documentation.
	SetLabels(ctx context.Context, in *SetLabelsGlobalForwardingRuleRequest, opts ...grpc.CallOption) (*Operation, error)
	// Changes target URL for the GlobalForwardingRule resource. The new target should be of the same type as the old target.
	SetTarget(ctx context.Context, in *SetTargetGlobalForwardingRuleRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(ctx context.Context, in *TestIamPermissionsGlobalForwardingRuleRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error)
}

type globalForwardingRulesClient struct {
	cc grpc.ClientConnInterface
}

func NewGlobalForwardingRulesClient(cc grpc.ClientConnInterface) GlobalForwardingRulesClient {
	return &globalForwardingRulesClient{cc}
}

func (c *globalForwardingRulesClient) Delete(ctx context.Context, in *DeleteGlobalForwardingRuleRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, GlobalForwardingRules_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *globalForwardingRulesClient) Get(ctx context.Context, in *GetGlobalForwardingRuleRequest, opts ...grpc.CallOption) (*ForwardingRule, error) {
	out := new(ForwardingRule)
	err := c.cc.Invoke(ctx, GlobalForwardingRules_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *globalForwardingRulesClient) Insert(ctx context.Context, in *InsertGlobalForwardingRuleRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, GlobalForwardingRules_Insert_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *globalForwardingRulesClient) List(ctx context.Context, in *ListGlobalForwardingRulesRequest, opts ...grpc.CallOption) (*ForwardingRuleList, error) {
	out := new(ForwardingRuleList)
	err := c.cc.Invoke(ctx, GlobalForwardingRules_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *globalForwardingRulesClient) Patch(ctx context.Context, in *PatchGlobalForwardingRuleRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, GlobalForwardingRules_Patch_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *globalForwardingRulesClient) SetLabels(ctx context.Context, in *SetLabelsGlobalForwardingRuleRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, GlobalForwardingRules_SetLabels_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *globalForwardingRulesClient) SetTarget(ctx context.Context, in *SetTargetGlobalForwardingRuleRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, GlobalForwardingRules_SetTarget_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *globalForwardingRulesClient) TestIamPermissions(ctx context.Context, in *TestIamPermissionsGlobalForwardingRuleRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error) {
	out := new(TestPermissionsResponse)
	err := c.cc.Invoke(ctx, GlobalForwardingRules_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// GlobalForwardingRulesServer is the server API for GlobalForwardingRules service.
// All implementations should embed UnimplementedGlobalForwardingRulesServer
// for forward compatibility
type GlobalForwardingRulesServer interface {
	// Deletes the specified GlobalForwardingRule resource.
	Delete(context.Context, *DeleteGlobalForwardingRuleRequest) (*Operation, error)
	// Returns the specified GlobalForwardingRule resource. Gets a list of available forwarding rules by making a list() request.
	Get(context.Context, *GetGlobalForwardingRuleRequest) (*ForwardingRule, error)
	// Creates a GlobalForwardingRule resource in the specified project using the data included in the request.
	Insert(context.Context, *InsertGlobalForwardingRuleRequest) (*Operation, error)
	// Retrieves a list of GlobalForwardingRule resources available to the specified project.
	List(context.Context, *ListGlobalForwardingRulesRequest) (*ForwardingRuleList, error)
	// Updates the specified forwarding rule with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules. Currently, you can only patch the network_tier field.
	Patch(context.Context, *PatchGlobalForwardingRuleRequest) (*Operation, error)
	// Sets the labels on the specified resource. To learn more about labels, read the Labeling resources documentation.
	SetLabels(context.Context, *SetLabelsGlobalForwardingRuleRequest) (*Operation, error)
	// Changes target URL for the GlobalForwardingRule resource. The new target should be of the same type as the old target.
	SetTarget(context.Context, *SetTargetGlobalForwardingRuleRequest) (*Operation, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(context.Context, *TestIamPermissionsGlobalForwardingRuleRequest) (*TestPermissionsResponse, error)
}

// UnimplementedGlobalForwardingRulesServer should be embedded to have forward compatible implementations.
type UnimplementedGlobalForwardingRulesServer struct {
}

func (UnimplementedGlobalForwardingRulesServer) Delete(context.Context, *DeleteGlobalForwardingRuleRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedGlobalForwardingRulesServer) Get(context.Context, *GetGlobalForwardingRuleRequest) (*ForwardingRule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedGlobalForwardingRulesServer) Insert(context.Context, *InsertGlobalForwardingRuleRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (UnimplementedGlobalForwardingRulesServer) List(context.Context, *ListGlobalForwardingRulesRequest) (*ForwardingRuleList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedGlobalForwardingRulesServer) Patch(context.Context, *PatchGlobalForwardingRuleRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Patch not implemented")
}
func (UnimplementedGlobalForwardingRulesServer) SetLabels(context.Context, *SetLabelsGlobalForwardingRuleRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetLabels not implemented")
}
func (UnimplementedGlobalForwardingRulesServer) SetTarget(context.Context, *SetTargetGlobalForwardingRuleRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetTarget not implemented")
}
func (UnimplementedGlobalForwardingRulesServer) TestIamPermissions(context.Context, *TestIamPermissionsGlobalForwardingRuleRequest) (*TestPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

// UnsafeGlobalForwardingRulesServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to GlobalForwardingRulesServer will
// result in compilation errors.
type UnsafeGlobalForwardingRulesServer interface {
	mustEmbedUnimplementedGlobalForwardingRulesServer()
}

func RegisterGlobalForwardingRulesServer(s grpc.ServiceRegistrar, srv GlobalForwardingRulesServer) {
	s.RegisterService(&GlobalForwardingRules_ServiceDesc, srv)
}

func _GlobalForwardingRules_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteGlobalForwardingRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GlobalForwardingRulesServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GlobalForwardingRules_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GlobalForwardingRulesServer).Delete(ctx, req.(*DeleteGlobalForwardingRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GlobalForwardingRules_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGlobalForwardingRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GlobalForwardingRulesServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GlobalForwardingRules_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GlobalForwardingRulesServer).Get(ctx, req.(*GetGlobalForwardingRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GlobalForwardingRules_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertGlobalForwardingRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GlobalForwardingRulesServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GlobalForwardingRules_Insert_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GlobalForwardingRulesServer).Insert(ctx, req.(*InsertGlobalForwardingRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GlobalForwardingRules_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListGlobalForwardingRulesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GlobalForwardingRulesServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GlobalForwardingRules_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GlobalForwardingRulesServer).List(ctx, req.(*ListGlobalForwardingRulesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GlobalForwardingRules_Patch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchGlobalForwardingRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GlobalForwardingRulesServer).Patch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GlobalForwardingRules_Patch_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GlobalForwardingRulesServer).Patch(ctx, req.(*PatchGlobalForwardingRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GlobalForwardingRules_SetLabels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetLabelsGlobalForwardingRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GlobalForwardingRulesServer).SetLabels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GlobalForwardingRules_SetLabels_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GlobalForwardingRulesServer).SetLabels(ctx, req.(*SetLabelsGlobalForwardingRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GlobalForwardingRules_SetTarget_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetTargetGlobalForwardingRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GlobalForwardingRulesServer).SetTarget(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GlobalForwardingRules_SetTarget_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GlobalForwardingRulesServer).SetTarget(ctx, req.(*SetTargetGlobalForwardingRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GlobalForwardingRules_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TestIamPermissionsGlobalForwardingRuleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GlobalForwardingRulesServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GlobalForwardingRules_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GlobalForwardingRulesServer).TestIamPermissions(ctx, req.(*TestIamPermissionsGlobalForwardingRuleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// GlobalForwardingRules_ServiceDesc is the grpc.ServiceDesc for GlobalForwardingRules service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var GlobalForwardingRules_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.GlobalForwardingRules",
	HandlerType: (*GlobalForwardingRulesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Delete",
			Handler:    _GlobalForwardingRules_Delete_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _GlobalForwardingRules_Get_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _GlobalForwardingRules_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _GlobalForwardingRules_List_Handler,
		},
		{
			MethodName: "Patch",
			Handler:    _GlobalForwardingRules_Patch_Handler,
		},
		{
			MethodName: "SetLabels",
			Handler:    _GlobalForwardingRules_SetLabels_Handler,
		},
		{
			MethodName: "SetTarget",
			Handler:    _GlobalForwardingRules_SetTarget_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _GlobalForwardingRules_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	GlobalNetworkEndpointGroups_AttachNetworkEndpoints_FullMethodName = "/google.cloud.compute.v1beta.GlobalNetworkEndpointGroups/AttachNetworkEndpoints"
	GlobalNetworkEndpointGroups_Delete_FullMethodName                 = "/google.cloud.compute.v1beta.GlobalNetworkEndpointGroups/Delete"
	GlobalNetworkEndpointGroups_DetachNetworkEndpoints_FullMethodName = "/google.cloud.compute.v1beta.GlobalNetworkEndpointGroups/DetachNetworkEndpoints"
	GlobalNetworkEndpointGroups_Get_FullMethodName                    = "/google.cloud.compute.v1beta.GlobalNetworkEndpointGroups/Get"
	GlobalNetworkEndpointGroups_Insert_FullMethodName                 = "/google.cloud.compute.v1beta.GlobalNetworkEndpointGroups/Insert"
	GlobalNetworkEndpointGroups_List_FullMethodName                   = "/google.cloud.compute.v1beta.GlobalNetworkEndpointGroups/List"
	GlobalNetworkEndpointGroups_ListNetworkEndpoints_FullMethodName   = "/google.cloud.compute.v1beta.GlobalNetworkEndpointGroups/ListNetworkEndpoints"
)

// GlobalNetworkEndpointGroupsClient is the client API for GlobalNetworkEndpointGroups service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type GlobalNetworkEndpointGroupsClient interface {
	// Attach a network endpoint to the specified network endpoint group.
	AttachNetworkEndpoints(ctx context.Context, in *AttachNetworkEndpointsGlobalNetworkEndpointGroupRequest, opts ...grpc.CallOption) (*Operation, error)
	// Deletes the specified network endpoint group.Note that the NEG cannot be deleted if there are backend services referencing it.
	Delete(ctx context.Context, in *DeleteGlobalNetworkEndpointGroupRequest, opts ...grpc.CallOption) (*Operation, error)
	// Detach the network endpoint from the specified network endpoint group.
	DetachNetworkEndpoints(ctx context.Context, in *DetachNetworkEndpointsGlobalNetworkEndpointGroupRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns the specified network endpoint group.
	Get(ctx context.Context, in *GetGlobalNetworkEndpointGroupRequest, opts ...grpc.CallOption) (*NetworkEndpointGroup, error)
	// Creates a network endpoint group in the specified project using the parameters that are included in the request.
	Insert(ctx context.Context, in *InsertGlobalNetworkEndpointGroupRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves the list of network endpoint groups that are located in the specified project.
	List(ctx context.Context, in *ListGlobalNetworkEndpointGroupsRequest, opts ...grpc.CallOption) (*NetworkEndpointGroupList, error)
	// Lists the network endpoints in the specified network endpoint group.
	ListNetworkEndpoints(ctx context.Context, in *ListNetworkEndpointsGlobalNetworkEndpointGroupsRequest, opts ...grpc.CallOption) (*NetworkEndpointGroupsListNetworkEndpoints, error)
}

type globalNetworkEndpointGroupsClient struct {
	cc grpc.ClientConnInterface
}

func NewGlobalNetworkEndpointGroupsClient(cc grpc.ClientConnInterface) GlobalNetworkEndpointGroupsClient {
	return &globalNetworkEndpointGroupsClient{cc}
}

func (c *globalNetworkEndpointGroupsClient) AttachNetworkEndpoints(ctx context.Context, in *AttachNetworkEndpointsGlobalNetworkEndpointGroupRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, GlobalNetworkEndpointGroups_AttachNetworkEndpoints_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *globalNetworkEndpointGroupsClient) Delete(ctx context.Context, in *DeleteGlobalNetworkEndpointGroupRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, GlobalNetworkEndpointGroups_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *globalNetworkEndpointGroupsClient) DetachNetworkEndpoints(ctx context.Context, in *DetachNetworkEndpointsGlobalNetworkEndpointGroupRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, GlobalNetworkEndpointGroups_DetachNetworkEndpoints_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *globalNetworkEndpointGroupsClient) Get(ctx context.Context, in *GetGlobalNetworkEndpointGroupRequest, opts ...grpc.CallOption) (*NetworkEndpointGroup, error) {
	out := new(NetworkEndpointGroup)
	err := c.cc.Invoke(ctx, GlobalNetworkEndpointGroups_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *globalNetworkEndpointGroupsClient) Insert(ctx context.Context, in *InsertGlobalNetworkEndpointGroupRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, GlobalNetworkEndpointGroups_Insert_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *globalNetworkEndpointGroupsClient) List(ctx context.Context, in *ListGlobalNetworkEndpointGroupsRequest, opts ...grpc.CallOption) (*NetworkEndpointGroupList, error) {
	out := new(NetworkEndpointGroupList)
	err := c.cc.Invoke(ctx, GlobalNetworkEndpointGroups_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *globalNetworkEndpointGroupsClient) ListNetworkEndpoints(ctx context.Context, in *ListNetworkEndpointsGlobalNetworkEndpointGroupsRequest, opts ...grpc.CallOption) (*NetworkEndpointGroupsListNetworkEndpoints, error) {
	out := new(NetworkEndpointGroupsListNetworkEndpoints)
	err := c.cc.Invoke(ctx, GlobalNetworkEndpointGroups_ListNetworkEndpoints_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// GlobalNetworkEndpointGroupsServer is the server API for GlobalNetworkEndpointGroups service.
// All implementations should embed UnimplementedGlobalNetworkEndpointGroupsServer
// for forward compatibility
type GlobalNetworkEndpointGroupsServer interface {
	// Attach a network endpoint to the specified network endpoint group.
	AttachNetworkEndpoints(context.Context, *AttachNetworkEndpointsGlobalNetworkEndpointGroupRequest) (*Operation, error)
	// Deletes the specified network endpoint group.Note that the NEG cannot be deleted if there are backend services referencing it.
	Delete(context.Context, *DeleteGlobalNetworkEndpointGroupRequest) (*Operation, error)
	// Detach the network endpoint from the specified network endpoint group.
	DetachNetworkEndpoints(context.Context, *DetachNetworkEndpointsGlobalNetworkEndpointGroupRequest) (*Operation, error)
	// Returns the specified network endpoint group.
	Get(context.Context, *GetGlobalNetworkEndpointGroupRequest) (*NetworkEndpointGroup, error)
	// Creates a network endpoint group in the specified project using the parameters that are included in the request.
	Insert(context.Context, *InsertGlobalNetworkEndpointGroupRequest) (*Operation, error)
	// Retrieves the list of network endpoint groups that are located in the specified project.
	List(context.Context, *ListGlobalNetworkEndpointGroupsRequest) (*NetworkEndpointGroupList, error)
	// Lists the network endpoints in the specified network endpoint group.
	ListNetworkEndpoints(context.Context, *ListNetworkEndpointsGlobalNetworkEndpointGroupsRequest) (*NetworkEndpointGroupsListNetworkEndpoints, error)
}

// UnimplementedGlobalNetworkEndpointGroupsServer should be embedded to have forward compatible implementations.
type UnimplementedGlobalNetworkEndpointGroupsServer struct {
}

func (UnimplementedGlobalNetworkEndpointGroupsServer) AttachNetworkEndpoints(context.Context, *AttachNetworkEndpointsGlobalNetworkEndpointGroupRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AttachNetworkEndpoints not implemented")
}
func (UnimplementedGlobalNetworkEndpointGroupsServer) Delete(context.Context, *DeleteGlobalNetworkEndpointGroupRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedGlobalNetworkEndpointGroupsServer) DetachNetworkEndpoints(context.Context, *DetachNetworkEndpointsGlobalNetworkEndpointGroupRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DetachNetworkEndpoints not implemented")
}
func (UnimplementedGlobalNetworkEndpointGroupsServer) Get(context.Context, *GetGlobalNetworkEndpointGroupRequest) (*NetworkEndpointGroup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedGlobalNetworkEndpointGroupsServer) Insert(context.Context, *InsertGlobalNetworkEndpointGroupRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (UnimplementedGlobalNetworkEndpointGroupsServer) List(context.Context, *ListGlobalNetworkEndpointGroupsRequest) (*NetworkEndpointGroupList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedGlobalNetworkEndpointGroupsServer) ListNetworkEndpoints(context.Context, *ListNetworkEndpointsGlobalNetworkEndpointGroupsRequest) (*NetworkEndpointGroupsListNetworkEndpoints, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNetworkEndpoints not implemented")
}

// UnsafeGlobalNetworkEndpointGroupsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to GlobalNetworkEndpointGroupsServer will
// result in compilation errors.
type UnsafeGlobalNetworkEndpointGroupsServer interface {
	mustEmbedUnimplementedGlobalNetworkEndpointGroupsServer()
}

func RegisterGlobalNetworkEndpointGroupsServer(s grpc.ServiceRegistrar, srv GlobalNetworkEndpointGroupsServer) {
	s.RegisterService(&GlobalNetworkEndpointGroups_ServiceDesc, srv)
}

func _GlobalNetworkEndpointGroups_AttachNetworkEndpoints_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AttachNetworkEndpointsGlobalNetworkEndpointGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GlobalNetworkEndpointGroupsServer).AttachNetworkEndpoints(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GlobalNetworkEndpointGroups_AttachNetworkEndpoints_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GlobalNetworkEndpointGroupsServer).AttachNetworkEndpoints(ctx, req.(*AttachNetworkEndpointsGlobalNetworkEndpointGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GlobalNetworkEndpointGroups_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteGlobalNetworkEndpointGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GlobalNetworkEndpointGroupsServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GlobalNetworkEndpointGroups_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GlobalNetworkEndpointGroupsServer).Delete(ctx, req.(*DeleteGlobalNetworkEndpointGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GlobalNetworkEndpointGroups_DetachNetworkEndpoints_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DetachNetworkEndpointsGlobalNetworkEndpointGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GlobalNetworkEndpointGroupsServer).DetachNetworkEndpoints(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GlobalNetworkEndpointGroups_DetachNetworkEndpoints_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GlobalNetworkEndpointGroupsServer).DetachNetworkEndpoints(ctx, req.(*DetachNetworkEndpointsGlobalNetworkEndpointGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GlobalNetworkEndpointGroups_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGlobalNetworkEndpointGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GlobalNetworkEndpointGroupsServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GlobalNetworkEndpointGroups_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GlobalNetworkEndpointGroupsServer).Get(ctx, req.(*GetGlobalNetworkEndpointGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GlobalNetworkEndpointGroups_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertGlobalNetworkEndpointGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GlobalNetworkEndpointGroupsServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GlobalNetworkEndpointGroups_Insert_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GlobalNetworkEndpointGroupsServer).Insert(ctx, req.(*InsertGlobalNetworkEndpointGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GlobalNetworkEndpointGroups_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListGlobalNetworkEndpointGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GlobalNetworkEndpointGroupsServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GlobalNetworkEndpointGroups_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GlobalNetworkEndpointGroupsServer).List(ctx, req.(*ListGlobalNetworkEndpointGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GlobalNetworkEndpointGroups_ListNetworkEndpoints_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNetworkEndpointsGlobalNetworkEndpointGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GlobalNetworkEndpointGroupsServer).ListNetworkEndpoints(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GlobalNetworkEndpointGroups_ListNetworkEndpoints_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GlobalNetworkEndpointGroupsServer).ListNetworkEndpoints(ctx, req.(*ListNetworkEndpointsGlobalNetworkEndpointGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// GlobalNetworkEndpointGroups_ServiceDesc is the grpc.ServiceDesc for GlobalNetworkEndpointGroups service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var GlobalNetworkEndpointGroups_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.GlobalNetworkEndpointGroups",
	HandlerType: (*GlobalNetworkEndpointGroupsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AttachNetworkEndpoints",
			Handler:    _GlobalNetworkEndpointGroups_AttachNetworkEndpoints_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _GlobalNetworkEndpointGroups_Delete_Handler,
		},
		{
			MethodName: "DetachNetworkEndpoints",
			Handler:    _GlobalNetworkEndpointGroups_DetachNetworkEndpoints_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _GlobalNetworkEndpointGroups_Get_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _GlobalNetworkEndpointGroups_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _GlobalNetworkEndpointGroups_List_Handler,
		},
		{
			MethodName: "ListNetworkEndpoints",
			Handler:    _GlobalNetworkEndpointGroups_ListNetworkEndpoints_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	GlobalOperations_AggregatedList_FullMethodName = "/google.cloud.compute.v1beta.GlobalOperations/AggregatedList"
	GlobalOperations_Delete_FullMethodName         = "/google.cloud.compute.v1beta.GlobalOperations/Delete"
	GlobalOperations_Get_FullMethodName            = "/google.cloud.compute.v1beta.GlobalOperations/Get"
	GlobalOperations_List_FullMethodName           = "/google.cloud.compute.v1beta.GlobalOperations/List"
	GlobalOperations_Wait_FullMethodName           = "/google.cloud.compute.v1beta.GlobalOperations/Wait"
)

// GlobalOperationsClient is the client API for GlobalOperations service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type GlobalOperationsClient interface {
	// Retrieves an aggregated list of all operations. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(ctx context.Context, in *AggregatedListGlobalOperationsRequest, opts ...grpc.CallOption) (*OperationAggregatedList, error)
	// Deletes the specified Operations resource.
	Delete(ctx context.Context, in *DeleteGlobalOperationRequest, opts ...grpc.CallOption) (*DeleteGlobalOperationResponse, error)
	// Retrieves the specified Operations resource.
	Get(ctx context.Context, in *GetGlobalOperationRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves a list of Operation resources contained within the specified project.
	List(ctx context.Context, in *ListGlobalOperationsRequest, opts ...grpc.CallOption) (*OperationList, error)
	// Waits for the specified Operation resource to return as `DONE` or for the request to approach the 2 minute deadline, and retrieves the specified Operation resource. This method differs from the `GET` method in that it waits for no more than the default deadline (2 minutes) and then returns the current state of the operation, which might be `DONE` or still in progress. This method is called on a best-effort basis. Specifically: - In uncommon cases, when the server is overloaded, the request might return before the default deadline is reached, or might return after zero seconds. - If the default deadline is reached, there is no guarantee that the operation is actually done when the method returns. Be prepared to retry if the operation is not `DONE`.
	Wait(ctx context.Context, in *WaitGlobalOperationRequest, opts ...grpc.CallOption) (*Operation, error)
}

type globalOperationsClient struct {
	cc grpc.ClientConnInterface
}

func NewGlobalOperationsClient(cc grpc.ClientConnInterface) GlobalOperationsClient {
	return &globalOperationsClient{cc}
}

func (c *globalOperationsClient) AggregatedList(ctx context.Context, in *AggregatedListGlobalOperationsRequest, opts ...grpc.CallOption) (*OperationAggregatedList, error) {
	out := new(OperationAggregatedList)
	err := c.cc.Invoke(ctx, GlobalOperations_AggregatedList_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *globalOperationsClient) Delete(ctx context.Context, in *DeleteGlobalOperationRequest, opts ...grpc.CallOption) (*DeleteGlobalOperationResponse, error) {
	out := new(DeleteGlobalOperationResponse)
	err := c.cc.Invoke(ctx, GlobalOperations_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *globalOperationsClient) Get(ctx context.Context, in *GetGlobalOperationRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, GlobalOperations_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *globalOperationsClient) List(ctx context.Context, in *ListGlobalOperationsRequest, opts ...grpc.CallOption) (*OperationList, error) {
	out := new(OperationList)
	err := c.cc.Invoke(ctx, GlobalOperations_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *globalOperationsClient) Wait(ctx context.Context, in *WaitGlobalOperationRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, GlobalOperations_Wait_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// GlobalOperationsServer is the server API for GlobalOperations service.
// All implementations should embed UnimplementedGlobalOperationsServer
// for forward compatibility
type GlobalOperationsServer interface {
	// Retrieves an aggregated list of all operations. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(context.Context, *AggregatedListGlobalOperationsRequest) (*OperationAggregatedList, error)
	// Deletes the specified Operations resource.
	Delete(context.Context, *DeleteGlobalOperationRequest) (*DeleteGlobalOperationResponse, error)
	// Retrieves the specified Operations resource.
	Get(context.Context, *GetGlobalOperationRequest) (*Operation, error)
	// Retrieves a list of Operation resources contained within the specified project.
	List(context.Context, *ListGlobalOperationsRequest) (*OperationList, error)
	// Waits for the specified Operation resource to return as `DONE` or for the request to approach the 2 minute deadline, and retrieves the specified Operation resource. This method differs from the `GET` method in that it waits for no more than the default deadline (2 minutes) and then returns the current state of the operation, which might be `DONE` or still in progress. This method is called on a best-effort basis. Specifically: - In uncommon cases, when the server is overloaded, the request might return before the default deadline is reached, or might return after zero seconds. - If the default deadline is reached, there is no guarantee that the operation is actually done when the method returns. Be prepared to retry if the operation is not `DONE`.
	Wait(context.Context, *WaitGlobalOperationRequest) (*Operation, error)
}

// UnimplementedGlobalOperationsServer should be embedded to have forward compatible implementations.
type UnimplementedGlobalOperationsServer struct {
}

func (UnimplementedGlobalOperationsServer) AggregatedList(context.Context, *AggregatedListGlobalOperationsRequest) (*OperationAggregatedList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AggregatedList not implemented")
}
func (UnimplementedGlobalOperationsServer) Delete(context.Context, *DeleteGlobalOperationRequest) (*DeleteGlobalOperationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedGlobalOperationsServer) Get(context.Context, *GetGlobalOperationRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedGlobalOperationsServer) List(context.Context, *ListGlobalOperationsRequest) (*OperationList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedGlobalOperationsServer) Wait(context.Context, *WaitGlobalOperationRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Wait not implemented")
}

// UnsafeGlobalOperationsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to GlobalOperationsServer will
// result in compilation errors.
type UnsafeGlobalOperationsServer interface {
	mustEmbedUnimplementedGlobalOperationsServer()
}

func RegisterGlobalOperationsServer(s grpc.ServiceRegistrar, srv GlobalOperationsServer) {
	s.RegisterService(&GlobalOperations_ServiceDesc, srv)
}

func _GlobalOperations_AggregatedList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AggregatedListGlobalOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GlobalOperationsServer).AggregatedList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GlobalOperations_AggregatedList_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GlobalOperationsServer).AggregatedList(ctx, req.(*AggregatedListGlobalOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GlobalOperations_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteGlobalOperationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GlobalOperationsServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GlobalOperations_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GlobalOperationsServer).Delete(ctx, req.(*DeleteGlobalOperationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GlobalOperations_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGlobalOperationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GlobalOperationsServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GlobalOperations_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GlobalOperationsServer).Get(ctx, req.(*GetGlobalOperationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GlobalOperations_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListGlobalOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GlobalOperationsServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GlobalOperations_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GlobalOperationsServer).List(ctx, req.(*ListGlobalOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GlobalOperations_Wait_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(WaitGlobalOperationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GlobalOperationsServer).Wait(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GlobalOperations_Wait_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GlobalOperationsServer).Wait(ctx, req.(*WaitGlobalOperationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// GlobalOperations_ServiceDesc is the grpc.ServiceDesc for GlobalOperations service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var GlobalOperations_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.GlobalOperations",
	HandlerType: (*GlobalOperationsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AggregatedList",
			Handler:    _GlobalOperations_AggregatedList_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _GlobalOperations_Delete_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _GlobalOperations_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _GlobalOperations_List_Handler,
		},
		{
			MethodName: "Wait",
			Handler:    _GlobalOperations_Wait_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	GlobalOrganizationOperations_Delete_FullMethodName = "/google.cloud.compute.v1beta.GlobalOrganizationOperations/Delete"
	GlobalOrganizationOperations_Get_FullMethodName    = "/google.cloud.compute.v1beta.GlobalOrganizationOperations/Get"
	GlobalOrganizationOperations_List_FullMethodName   = "/google.cloud.compute.v1beta.GlobalOrganizationOperations/List"
)

// GlobalOrganizationOperationsClient is the client API for GlobalOrganizationOperations service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type GlobalOrganizationOperationsClient interface {
	// Deletes the specified Operations resource.
	Delete(ctx context.Context, in *DeleteGlobalOrganizationOperationRequest, opts ...grpc.CallOption) (*DeleteGlobalOrganizationOperationResponse, error)
	// Retrieves the specified Operations resource. Gets a list of operations by making a `list()` request.
	Get(ctx context.Context, in *GetGlobalOrganizationOperationRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves a list of Operation resources contained within the specified organization.
	List(ctx context.Context, in *ListGlobalOrganizationOperationsRequest, opts ...grpc.CallOption) (*OperationList, error)
}

type globalOrganizationOperationsClient struct {
	cc grpc.ClientConnInterface
}

func NewGlobalOrganizationOperationsClient(cc grpc.ClientConnInterface) GlobalOrganizationOperationsClient {
	return &globalOrganizationOperationsClient{cc}
}

func (c *globalOrganizationOperationsClient) Delete(ctx context.Context, in *DeleteGlobalOrganizationOperationRequest, opts ...grpc.CallOption) (*DeleteGlobalOrganizationOperationResponse, error) {
	out := new(DeleteGlobalOrganizationOperationResponse)
	err := c.cc.Invoke(ctx, GlobalOrganizationOperations_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *globalOrganizationOperationsClient) Get(ctx context.Context, in *GetGlobalOrganizationOperationRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, GlobalOrganizationOperations_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *globalOrganizationOperationsClient) List(ctx context.Context, in *ListGlobalOrganizationOperationsRequest, opts ...grpc.CallOption) (*OperationList, error) {
	out := new(OperationList)
	err := c.cc.Invoke(ctx, GlobalOrganizationOperations_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// GlobalOrganizationOperationsServer is the server API for GlobalOrganizationOperations service.
// All implementations should embed UnimplementedGlobalOrganizationOperationsServer
// for forward compatibility
type GlobalOrganizationOperationsServer interface {
	// Deletes the specified Operations resource.
	Delete(context.Context, *DeleteGlobalOrganizationOperationRequest) (*DeleteGlobalOrganizationOperationResponse, error)
	// Retrieves the specified Operations resource. Gets a list of operations by making a `list()` request.
	Get(context.Context, *GetGlobalOrganizationOperationRequest) (*Operation, error)
	// Retrieves a list of Operation resources contained within the specified organization.
	List(context.Context, *ListGlobalOrganizationOperationsRequest) (*OperationList, error)
}

// UnimplementedGlobalOrganizationOperationsServer should be embedded to have forward compatible implementations.
type UnimplementedGlobalOrganizationOperationsServer struct {
}

func (UnimplementedGlobalOrganizationOperationsServer) Delete(context.Context, *DeleteGlobalOrganizationOperationRequest) (*DeleteGlobalOrganizationOperationResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedGlobalOrganizationOperationsServer) Get(context.Context, *GetGlobalOrganizationOperationRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedGlobalOrganizationOperationsServer) List(context.Context, *ListGlobalOrganizationOperationsRequest) (*OperationList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}

// UnsafeGlobalOrganizationOperationsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to GlobalOrganizationOperationsServer will
// result in compilation errors.
type UnsafeGlobalOrganizationOperationsServer interface {
	mustEmbedUnimplementedGlobalOrganizationOperationsServer()
}

func RegisterGlobalOrganizationOperationsServer(s grpc.ServiceRegistrar, srv GlobalOrganizationOperationsServer) {
	s.RegisterService(&GlobalOrganizationOperations_ServiceDesc, srv)
}

func _GlobalOrganizationOperations_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteGlobalOrganizationOperationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GlobalOrganizationOperationsServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GlobalOrganizationOperations_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GlobalOrganizationOperationsServer).Delete(ctx, req.(*DeleteGlobalOrganizationOperationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GlobalOrganizationOperations_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGlobalOrganizationOperationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GlobalOrganizationOperationsServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GlobalOrganizationOperations_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GlobalOrganizationOperationsServer).Get(ctx, req.(*GetGlobalOrganizationOperationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GlobalOrganizationOperations_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListGlobalOrganizationOperationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GlobalOrganizationOperationsServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GlobalOrganizationOperations_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GlobalOrganizationOperationsServer).List(ctx, req.(*ListGlobalOrganizationOperationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// GlobalOrganizationOperations_ServiceDesc is the grpc.ServiceDesc for GlobalOrganizationOperations service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var GlobalOrganizationOperations_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.GlobalOrganizationOperations",
	HandlerType: (*GlobalOrganizationOperationsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Delete",
			Handler:    _GlobalOrganizationOperations_Delete_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _GlobalOrganizationOperations_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _GlobalOrganizationOperations_List_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	GlobalPublicDelegatedPrefixes_Delete_FullMethodName = "/google.cloud.compute.v1beta.GlobalPublicDelegatedPrefixes/Delete"
	GlobalPublicDelegatedPrefixes_Get_FullMethodName    = "/google.cloud.compute.v1beta.GlobalPublicDelegatedPrefixes/Get"
	GlobalPublicDelegatedPrefixes_Insert_FullMethodName = "/google.cloud.compute.v1beta.GlobalPublicDelegatedPrefixes/Insert"
	GlobalPublicDelegatedPrefixes_List_FullMethodName   = "/google.cloud.compute.v1beta.GlobalPublicDelegatedPrefixes/List"
	GlobalPublicDelegatedPrefixes_Patch_FullMethodName  = "/google.cloud.compute.v1beta.GlobalPublicDelegatedPrefixes/Patch"
)

// GlobalPublicDelegatedPrefixesClient is the client API for GlobalPublicDelegatedPrefixes service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type GlobalPublicDelegatedPrefixesClient interface {
	// Deletes the specified global PublicDelegatedPrefix.
	Delete(ctx context.Context, in *DeleteGlobalPublicDelegatedPrefixeRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns the specified global PublicDelegatedPrefix resource.
	Get(ctx context.Context, in *GetGlobalPublicDelegatedPrefixeRequest, opts ...grpc.CallOption) (*PublicDelegatedPrefix, error)
	// Creates a global PublicDelegatedPrefix in the specified project using the parameters that are included in the request.
	Insert(ctx context.Context, in *InsertGlobalPublicDelegatedPrefixeRequest, opts ...grpc.CallOption) (*Operation, error)
	// Lists the global PublicDelegatedPrefixes for a project.
	List(ctx context.Context, in *ListGlobalPublicDelegatedPrefixesRequest, opts ...grpc.CallOption) (*PublicDelegatedPrefixList, error)
	// Patches the specified global PublicDelegatedPrefix resource with the data included in the request. This method supports PATCH semantics and uses JSON merge patch format and processing rules.
	Patch(ctx context.Context, in *PatchGlobalPublicDelegatedPrefixeRequest, opts ...grpc.CallOption) (*Operation, error)
}

type globalPublicDelegatedPrefixesClient struct {
	cc grpc.ClientConnInterface
}

func NewGlobalPublicDelegatedPrefixesClient(cc grpc.ClientConnInterface) GlobalPublicDelegatedPrefixesClient {
	return &globalPublicDelegatedPrefixesClient{cc}
}

func (c *globalPublicDelegatedPrefixesClient) Delete(ctx context.Context, in *DeleteGlobalPublicDelegatedPrefixeRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, GlobalPublicDelegatedPrefixes_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *globalPublicDelegatedPrefixesClient) Get(ctx context.Context, in *GetGlobalPublicDelegatedPrefixeRequest, opts ...grpc.CallOption) (*PublicDelegatedPrefix, error) {
	out := new(PublicDelegatedPrefix)
	err := c.cc.Invoke(ctx, GlobalPublicDelegatedPrefixes_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *globalPublicDelegatedPrefixesClient) Insert(ctx context.Context, in *InsertGlobalPublicDelegatedPrefixeRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, GlobalPublicDelegatedPrefixes_Insert_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *globalPublicDelegatedPrefixesClient) List(ctx context.Context, in *ListGlobalPublicDelegatedPrefixesRequest, opts ...grpc.CallOption) (*PublicDelegatedPrefixList, error) {
	out := new(PublicDelegatedPrefixList)
	err := c.cc.Invoke(ctx, GlobalPublicDelegatedPrefixes_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *globalPublicDelegatedPrefixesClient) Patch(ctx context.Context, in *PatchGlobalPublicDelegatedPrefixeRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, GlobalPublicDelegatedPrefixes_Patch_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// GlobalPublicDelegatedPrefixesServer is the server API for GlobalPublicDelegatedPrefixes service.
// All implementations should embed UnimplementedGlobalPublicDelegatedPrefixesServer
// for forward compatibility
type GlobalPublicDelegatedPrefixesServer interface {
	// Deletes the specified global PublicDelegatedPrefix.
	Delete(context.Context, *DeleteGlobalPublicDelegatedPrefixeRequest) (*Operation, error)
	// Returns the specified global PublicDelegatedPrefix resource.
	Get(context.Context, *GetGlobalPublicDelegatedPrefixeRequest) (*PublicDelegatedPrefix, error)
	// Creates a global PublicDelegatedPrefix in the specified project using the parameters that are included in the request.
	Insert(context.Context, *InsertGlobalPublicDelegatedPrefixeRequest) (*Operation, error)
	// Lists the global PublicDelegatedPrefixes for a project.
	List(context.Context, *ListGlobalPublicDelegatedPrefixesRequest) (*PublicDelegatedPrefixList, error)
	// Patches the specified global PublicDelegatedPrefix resource with the data included in the request. This method supports PATCH semantics and uses JSON merge patch format and processing rules.
	Patch(context.Context, *PatchGlobalPublicDelegatedPrefixeRequest) (*Operation, error)
}

// UnimplementedGlobalPublicDelegatedPrefixesServer should be embedded to have forward compatible implementations.
type UnimplementedGlobalPublicDelegatedPrefixesServer struct {
}

func (UnimplementedGlobalPublicDelegatedPrefixesServer) Delete(context.Context, *DeleteGlobalPublicDelegatedPrefixeRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedGlobalPublicDelegatedPrefixesServer) Get(context.Context, *GetGlobalPublicDelegatedPrefixeRequest) (*PublicDelegatedPrefix, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedGlobalPublicDelegatedPrefixesServer) Insert(context.Context, *InsertGlobalPublicDelegatedPrefixeRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (UnimplementedGlobalPublicDelegatedPrefixesServer) List(context.Context, *ListGlobalPublicDelegatedPrefixesRequest) (*PublicDelegatedPrefixList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedGlobalPublicDelegatedPrefixesServer) Patch(context.Context, *PatchGlobalPublicDelegatedPrefixeRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Patch not implemented")
}

// UnsafeGlobalPublicDelegatedPrefixesServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to GlobalPublicDelegatedPrefixesServer will
// result in compilation errors.
type UnsafeGlobalPublicDelegatedPrefixesServer interface {
	mustEmbedUnimplementedGlobalPublicDelegatedPrefixesServer()
}

func RegisterGlobalPublicDelegatedPrefixesServer(s grpc.ServiceRegistrar, srv GlobalPublicDelegatedPrefixesServer) {
	s.RegisterService(&GlobalPublicDelegatedPrefixes_ServiceDesc, srv)
}

func _GlobalPublicDelegatedPrefixes_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteGlobalPublicDelegatedPrefixeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GlobalPublicDelegatedPrefixesServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GlobalPublicDelegatedPrefixes_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GlobalPublicDelegatedPrefixesServer).Delete(ctx, req.(*DeleteGlobalPublicDelegatedPrefixeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GlobalPublicDelegatedPrefixes_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGlobalPublicDelegatedPrefixeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GlobalPublicDelegatedPrefixesServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GlobalPublicDelegatedPrefixes_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GlobalPublicDelegatedPrefixesServer).Get(ctx, req.(*GetGlobalPublicDelegatedPrefixeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GlobalPublicDelegatedPrefixes_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertGlobalPublicDelegatedPrefixeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GlobalPublicDelegatedPrefixesServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GlobalPublicDelegatedPrefixes_Insert_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GlobalPublicDelegatedPrefixesServer).Insert(ctx, req.(*InsertGlobalPublicDelegatedPrefixeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GlobalPublicDelegatedPrefixes_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListGlobalPublicDelegatedPrefixesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GlobalPublicDelegatedPrefixesServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GlobalPublicDelegatedPrefixes_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GlobalPublicDelegatedPrefixesServer).List(ctx, req.(*ListGlobalPublicDelegatedPrefixesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _GlobalPublicDelegatedPrefixes_Patch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchGlobalPublicDelegatedPrefixeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GlobalPublicDelegatedPrefixesServer).Patch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: GlobalPublicDelegatedPrefixes_Patch_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GlobalPublicDelegatedPrefixesServer).Patch(ctx, req.(*PatchGlobalPublicDelegatedPrefixeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// GlobalPublicDelegatedPrefixes_ServiceDesc is the grpc.ServiceDesc for GlobalPublicDelegatedPrefixes service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var GlobalPublicDelegatedPrefixes_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.GlobalPublicDelegatedPrefixes",
	HandlerType: (*GlobalPublicDelegatedPrefixesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Delete",
			Handler:    _GlobalPublicDelegatedPrefixes_Delete_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _GlobalPublicDelegatedPrefixes_Get_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _GlobalPublicDelegatedPrefixes_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _GlobalPublicDelegatedPrefixes_List_Handler,
		},
		{
			MethodName: "Patch",
			Handler:    _GlobalPublicDelegatedPrefixes_Patch_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	HealthChecks_AggregatedList_FullMethodName     = "/google.cloud.compute.v1beta.HealthChecks/AggregatedList"
	HealthChecks_Delete_FullMethodName             = "/google.cloud.compute.v1beta.HealthChecks/Delete"
	HealthChecks_Get_FullMethodName                = "/google.cloud.compute.v1beta.HealthChecks/Get"
	HealthChecks_Insert_FullMethodName             = "/google.cloud.compute.v1beta.HealthChecks/Insert"
	HealthChecks_List_FullMethodName               = "/google.cloud.compute.v1beta.HealthChecks/List"
	HealthChecks_Patch_FullMethodName              = "/google.cloud.compute.v1beta.HealthChecks/Patch"
	HealthChecks_TestIamPermissions_FullMethodName = "/google.cloud.compute.v1beta.HealthChecks/TestIamPermissions"
	HealthChecks_Update_FullMethodName             = "/google.cloud.compute.v1beta.HealthChecks/Update"
)

// HealthChecksClient is the client API for HealthChecks service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type HealthChecksClient interface {
	// Retrieves the list of all HealthCheck resources, regional and global, available to the specified project. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(ctx context.Context, in *AggregatedListHealthChecksRequest, opts ...grpc.CallOption) (*HealthChecksAggregatedList, error)
	// Deletes the specified HealthCheck resource.
	Delete(ctx context.Context, in *DeleteHealthCheckRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns the specified HealthCheck resource.
	Get(ctx context.Context, in *GetHealthCheckRequest, opts ...grpc.CallOption) (*HealthCheck, error)
	// Creates a HealthCheck resource in the specified project using the data included in the request.
	Insert(ctx context.Context, in *InsertHealthCheckRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves the list of HealthCheck resources available to the specified project.
	List(ctx context.Context, in *ListHealthChecksRequest, opts ...grpc.CallOption) (*HealthCheckList, error)
	// Updates a HealthCheck resource in the specified project using the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
	Patch(ctx context.Context, in *PatchHealthCheckRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(ctx context.Context, in *TestIamPermissionsHealthCheckRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error)
	// Updates a HealthCheck resource in the specified project using the data included in the request.
	Update(ctx context.Context, in *UpdateHealthCheckRequest, opts ...grpc.CallOption) (*Operation, error)
}

type healthChecksClient struct {
	cc grpc.ClientConnInterface
}

func NewHealthChecksClient(cc grpc.ClientConnInterface) HealthChecksClient {
	return &healthChecksClient{cc}
}

func (c *healthChecksClient) AggregatedList(ctx context.Context, in *AggregatedListHealthChecksRequest, opts ...grpc.CallOption) (*HealthChecksAggregatedList, error) {
	out := new(HealthChecksAggregatedList)
	err := c.cc.Invoke(ctx, HealthChecks_AggregatedList_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *healthChecksClient) Delete(ctx context.Context, in *DeleteHealthCheckRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, HealthChecks_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *healthChecksClient) Get(ctx context.Context, in *GetHealthCheckRequest, opts ...grpc.CallOption) (*HealthCheck, error) {
	out := new(HealthCheck)
	err := c.cc.Invoke(ctx, HealthChecks_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *healthChecksClient) Insert(ctx context.Context, in *InsertHealthCheckRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, HealthChecks_Insert_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *healthChecksClient) List(ctx context.Context, in *ListHealthChecksRequest, opts ...grpc.CallOption) (*HealthCheckList, error) {
	out := new(HealthCheckList)
	err := c.cc.Invoke(ctx, HealthChecks_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *healthChecksClient) Patch(ctx context.Context, in *PatchHealthCheckRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, HealthChecks_Patch_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *healthChecksClient) TestIamPermissions(ctx context.Context, in *TestIamPermissionsHealthCheckRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error) {
	out := new(TestPermissionsResponse)
	err := c.cc.Invoke(ctx, HealthChecks_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *healthChecksClient) Update(ctx context.Context, in *UpdateHealthCheckRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, HealthChecks_Update_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// HealthChecksServer is the server API for HealthChecks service.
// All implementations should embed UnimplementedHealthChecksServer
// for forward compatibility
type HealthChecksServer interface {
	// Retrieves the list of all HealthCheck resources, regional and global, available to the specified project. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(context.Context, *AggregatedListHealthChecksRequest) (*HealthChecksAggregatedList, error)
	// Deletes the specified HealthCheck resource.
	Delete(context.Context, *DeleteHealthCheckRequest) (*Operation, error)
	// Returns the specified HealthCheck resource.
	Get(context.Context, *GetHealthCheckRequest) (*HealthCheck, error)
	// Creates a HealthCheck resource in the specified project using the data included in the request.
	Insert(context.Context, *InsertHealthCheckRequest) (*Operation, error)
	// Retrieves the list of HealthCheck resources available to the specified project.
	List(context.Context, *ListHealthChecksRequest) (*HealthCheckList, error)
	// Updates a HealthCheck resource in the specified project using the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
	Patch(context.Context, *PatchHealthCheckRequest) (*Operation, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(context.Context, *TestIamPermissionsHealthCheckRequest) (*TestPermissionsResponse, error)
	// Updates a HealthCheck resource in the specified project using the data included in the request.
	Update(context.Context, *UpdateHealthCheckRequest) (*Operation, error)
}

// UnimplementedHealthChecksServer should be embedded to have forward compatible implementations.
type UnimplementedHealthChecksServer struct {
}

func (UnimplementedHealthChecksServer) AggregatedList(context.Context, *AggregatedListHealthChecksRequest) (*HealthChecksAggregatedList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AggregatedList not implemented")
}
func (UnimplementedHealthChecksServer) Delete(context.Context, *DeleteHealthCheckRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedHealthChecksServer) Get(context.Context, *GetHealthCheckRequest) (*HealthCheck, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedHealthChecksServer) Insert(context.Context, *InsertHealthCheckRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (UnimplementedHealthChecksServer) List(context.Context, *ListHealthChecksRequest) (*HealthCheckList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedHealthChecksServer) Patch(context.Context, *PatchHealthCheckRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Patch not implemented")
}
func (UnimplementedHealthChecksServer) TestIamPermissions(context.Context, *TestIamPermissionsHealthCheckRequest) (*TestPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}
func (UnimplementedHealthChecksServer) Update(context.Context, *UpdateHealthCheckRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}

// UnsafeHealthChecksServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to HealthChecksServer will
// result in compilation errors.
type UnsafeHealthChecksServer interface {
	mustEmbedUnimplementedHealthChecksServer()
}

func RegisterHealthChecksServer(s grpc.ServiceRegistrar, srv HealthChecksServer) {
	s.RegisterService(&HealthChecks_ServiceDesc, srv)
}

func _HealthChecks_AggregatedList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AggregatedListHealthChecksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HealthChecksServer).AggregatedList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HealthChecks_AggregatedList_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HealthChecksServer).AggregatedList(ctx, req.(*AggregatedListHealthChecksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HealthChecks_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteHealthCheckRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HealthChecksServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HealthChecks_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HealthChecksServer).Delete(ctx, req.(*DeleteHealthCheckRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HealthChecks_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetHealthCheckRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HealthChecksServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HealthChecks_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HealthChecksServer).Get(ctx, req.(*GetHealthCheckRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HealthChecks_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertHealthCheckRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HealthChecksServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HealthChecks_Insert_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HealthChecksServer).Insert(ctx, req.(*InsertHealthCheckRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HealthChecks_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListHealthChecksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HealthChecksServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HealthChecks_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HealthChecksServer).List(ctx, req.(*ListHealthChecksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HealthChecks_Patch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchHealthCheckRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HealthChecksServer).Patch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HealthChecks_Patch_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HealthChecksServer).Patch(ctx, req.(*PatchHealthCheckRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HealthChecks_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TestIamPermissionsHealthCheckRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HealthChecksServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HealthChecks_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HealthChecksServer).TestIamPermissions(ctx, req.(*TestIamPermissionsHealthCheckRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _HealthChecks_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateHealthCheckRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(HealthChecksServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: HealthChecks_Update_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(HealthChecksServer).Update(ctx, req.(*UpdateHealthCheckRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// HealthChecks_ServiceDesc is the grpc.ServiceDesc for HealthChecks service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var HealthChecks_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.HealthChecks",
	HandlerType: (*HealthChecksServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AggregatedList",
			Handler:    _HealthChecks_AggregatedList_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _HealthChecks_Delete_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _HealthChecks_Get_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _HealthChecks_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _HealthChecks_List_Handler,
		},
		{
			MethodName: "Patch",
			Handler:    _HealthChecks_Patch_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _HealthChecks_TestIamPermissions_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _HealthChecks_Update_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	ImageFamilyViews_Get_FullMethodName = "/google.cloud.compute.v1beta.ImageFamilyViews/Get"
)

// ImageFamilyViewsClient is the client API for ImageFamilyViews service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ImageFamilyViewsClient interface {
	// Returns the latest image that is part of an image family, is not deprecated and is rolled out in the specified zone.
	Get(ctx context.Context, in *GetImageFamilyViewRequest, opts ...grpc.CallOption) (*ImageFamilyView, error)
}

type imageFamilyViewsClient struct {
	cc grpc.ClientConnInterface
}

func NewImageFamilyViewsClient(cc grpc.ClientConnInterface) ImageFamilyViewsClient {
	return &imageFamilyViewsClient{cc}
}

func (c *imageFamilyViewsClient) Get(ctx context.Context, in *GetImageFamilyViewRequest, opts ...grpc.CallOption) (*ImageFamilyView, error) {
	out := new(ImageFamilyView)
	err := c.cc.Invoke(ctx, ImageFamilyViews_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ImageFamilyViewsServer is the server API for ImageFamilyViews service.
// All implementations should embed UnimplementedImageFamilyViewsServer
// for forward compatibility
type ImageFamilyViewsServer interface {
	// Returns the latest image that is part of an image family, is not deprecated and is rolled out in the specified zone.
	Get(context.Context, *GetImageFamilyViewRequest) (*ImageFamilyView, error)
}

// UnimplementedImageFamilyViewsServer should be embedded to have forward compatible implementations.
type UnimplementedImageFamilyViewsServer struct {
}

func (UnimplementedImageFamilyViewsServer) Get(context.Context, *GetImageFamilyViewRequest) (*ImageFamilyView, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}

// UnsafeImageFamilyViewsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ImageFamilyViewsServer will
// result in compilation errors.
type UnsafeImageFamilyViewsServer interface {
	mustEmbedUnimplementedImageFamilyViewsServer()
}

func RegisterImageFamilyViewsServer(s grpc.ServiceRegistrar, srv ImageFamilyViewsServer) {
	s.RegisterService(&ImageFamilyViews_ServiceDesc, srv)
}

func _ImageFamilyViews_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetImageFamilyViewRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImageFamilyViewsServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: ImageFamilyViews_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImageFamilyViewsServer).Get(ctx, req.(*GetImageFamilyViewRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// ImageFamilyViews_ServiceDesc is the grpc.ServiceDesc for ImageFamilyViews service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var ImageFamilyViews_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.ImageFamilyViews",
	HandlerType: (*ImageFamilyViewsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _ImageFamilyViews_Get_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	Images_Delete_FullMethodName             = "/google.cloud.compute.v1beta.Images/Delete"
	Images_Deprecate_FullMethodName          = "/google.cloud.compute.v1beta.Images/Deprecate"
	Images_Get_FullMethodName                = "/google.cloud.compute.v1beta.Images/Get"
	Images_GetFromFamily_FullMethodName      = "/google.cloud.compute.v1beta.Images/GetFromFamily"
	Images_GetIamPolicy_FullMethodName       = "/google.cloud.compute.v1beta.Images/GetIamPolicy"
	Images_Insert_FullMethodName             = "/google.cloud.compute.v1beta.Images/Insert"
	Images_List_FullMethodName               = "/google.cloud.compute.v1beta.Images/List"
	Images_Patch_FullMethodName              = "/google.cloud.compute.v1beta.Images/Patch"
	Images_SetIamPolicy_FullMethodName       = "/google.cloud.compute.v1beta.Images/SetIamPolicy"
	Images_SetLabels_FullMethodName          = "/google.cloud.compute.v1beta.Images/SetLabels"
	Images_TestIamPermissions_FullMethodName = "/google.cloud.compute.v1beta.Images/TestIamPermissions"
)

// ImagesClient is the client API for Images service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type ImagesClient interface {
	// Deletes the specified image.
	Delete(ctx context.Context, in *DeleteImageRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the deprecation status of an image. If an empty request body is given, clears the deprecation status instead.
	Deprecate(ctx context.Context, in *DeprecateImageRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns the specified image.
	Get(ctx context.Context, in *GetImageRequest, opts ...grpc.CallOption) (*Image, error)
	// Returns the latest image that is part of an image family and is not deprecated. For more information on image families, see Public image families documentation.
	GetFromFamily(ctx context.Context, in *GetFromFamilyImageRequest, opts ...grpc.CallOption) (*Image, error)
	// Gets the access control policy for a resource. May be empty if no such policy or resource exists.
	GetIamPolicy(ctx context.Context, in *GetIamPolicyImageRequest, opts ...grpc.CallOption) (*Policy, error)
	// Creates an image in the specified project using the data included in the request.
	Insert(ctx context.Context, in *InsertImageRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves the list of custom images available to the specified project. Custom images are images you create that belong to your project. This method does not get any images that belong to other projects, including publicly-available images, like Debian 8. If you want to get a list of publicly-available images, use this method to make a request to the respective image project, such as debian-cloud or windows-cloud.
	List(ctx context.Context, in *ListImagesRequest, opts ...grpc.CallOption) (*ImageList, error)
	// Patches the specified image with the data included in the request. Only the following fields can be modified: family, description, deprecation status.
	Patch(ctx context.Context, in *PatchImageRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the access control policy on the specified resource. Replaces any existing policy.
	SetIamPolicy(ctx context.Context, in *SetIamPolicyImageRequest, opts ...grpc.CallOption) (*Policy, error)
	// Sets the labels on an image. To learn more about labels, read the Labeling Resources documentation.
	SetLabels(ctx context.Context, in *SetLabelsImageRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(ctx context.Context, in *TestIamPermissionsImageRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error)
}

type imagesClient struct {
	cc grpc.ClientConnInterface
}

func NewImagesClient(cc grpc.ClientConnInterface) ImagesClient {
	return &imagesClient{cc}
}

func (c *imagesClient) Delete(ctx context.Context, in *DeleteImageRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Images_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imagesClient) Deprecate(ctx context.Context, in *DeprecateImageRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Images_Deprecate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imagesClient) Get(ctx context.Context, in *GetImageRequest, opts ...grpc.CallOption) (*Image, error) {
	out := new(Image)
	err := c.cc.Invoke(ctx, Images_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imagesClient) GetFromFamily(ctx context.Context, in *GetFromFamilyImageRequest, opts ...grpc.CallOption) (*Image, error) {
	out := new(Image)
	err := c.cc.Invoke(ctx, Images_GetFromFamily_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imagesClient) GetIamPolicy(ctx context.Context, in *GetIamPolicyImageRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, Images_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imagesClient) Insert(ctx context.Context, in *InsertImageRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Images_Insert_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imagesClient) List(ctx context.Context, in *ListImagesRequest, opts ...grpc.CallOption) (*ImageList, error) {
	out := new(ImageList)
	err := c.cc.Invoke(ctx, Images_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imagesClient) Patch(ctx context.Context, in *PatchImageRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Images_Patch_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imagesClient) SetIamPolicy(ctx context.Context, in *SetIamPolicyImageRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, Images_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imagesClient) SetLabels(ctx context.Context, in *SetLabelsImageRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Images_SetLabels_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *imagesClient) TestIamPermissions(ctx context.Context, in *TestIamPermissionsImageRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error) {
	out := new(TestPermissionsResponse)
	err := c.cc.Invoke(ctx, Images_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// ImagesServer is the server API for Images service.
// All implementations should embed UnimplementedImagesServer
// for forward compatibility
type ImagesServer interface {
	// Deletes the specified image.
	Delete(context.Context, *DeleteImageRequest) (*Operation, error)
	// Sets the deprecation status of an image. If an empty request body is given, clears the deprecation status instead.
	Deprecate(context.Context, *DeprecateImageRequest) (*Operation, error)
	// Returns the specified image.
	Get(context.Context, *GetImageRequest) (*Image, error)
	// Returns the latest image that is part of an image family and is not deprecated. For more information on image families, see Public image families documentation.
	GetFromFamily(context.Context, *GetFromFamilyImageRequest) (*Image, error)
	// Gets the access control policy for a resource. May be empty if no such policy or resource exists.
	GetIamPolicy(context.Context, *GetIamPolicyImageRequest) (*Policy, error)
	// Creates an image in the specified project using the data included in the request.
	Insert(context.Context, *InsertImageRequest) (*Operation, error)
	// Retrieves the list of custom images available to the specified project. Custom images are images you create that belong to your project. This method does not get any images that belong to other projects, including publicly-available images, like Debian 8. If you want to get a list of publicly-available images, use this method to make a request to the respective image project, such as debian-cloud or windows-cloud.
	List(context.Context, *ListImagesRequest) (*ImageList, error)
	// Patches the specified image with the data included in the request. Only the following fields can be modified: family, description, deprecation status.
	Patch(context.Context, *PatchImageRequest) (*Operation, error)
	// Sets the access control policy on the specified resource. Replaces any existing policy.
	SetIamPolicy(context.Context, *SetIamPolicyImageRequest) (*Policy, error)
	// Sets the labels on an image. To learn more about labels, read the Labeling Resources documentation.
	SetLabels(context.Context, *SetLabelsImageRequest) (*Operation, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(context.Context, *TestIamPermissionsImageRequest) (*TestPermissionsResponse, error)
}

// UnimplementedImagesServer should be embedded to have forward compatible implementations.
type UnimplementedImagesServer struct {
}

func (UnimplementedImagesServer) Delete(context.Context, *DeleteImageRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedImagesServer) Deprecate(context.Context, *DeprecateImageRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Deprecate not implemented")
}
func (UnimplementedImagesServer) Get(context.Context, *GetImageRequest) (*Image, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedImagesServer) GetFromFamily(context.Context, *GetFromFamilyImageRequest) (*Image, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetFromFamily not implemented")
}
func (UnimplementedImagesServer) GetIamPolicy(context.Context, *GetIamPolicyImageRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedImagesServer) Insert(context.Context, *InsertImageRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (UnimplementedImagesServer) List(context.Context, *ListImagesRequest) (*ImageList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedImagesServer) Patch(context.Context, *PatchImageRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Patch not implemented")
}
func (UnimplementedImagesServer) SetIamPolicy(context.Context, *SetIamPolicyImageRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedImagesServer) SetLabels(context.Context, *SetLabelsImageRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetLabels not implemented")
}
func (UnimplementedImagesServer) TestIamPermissions(context.Context, *TestIamPermissionsImageRequest) (*TestPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

// UnsafeImagesServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to ImagesServer will
// result in compilation errors.
type UnsafeImagesServer interface {
	mustEmbedUnimplementedImagesServer()
}

func RegisterImagesServer(s grpc.ServiceRegistrar, srv ImagesServer) {
	s.RegisterService(&Images_ServiceDesc, srv)
}

func _Images_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImagesServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Images_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImagesServer).Delete(ctx, req.(*DeleteImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Images_Deprecate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeprecateImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImagesServer).Deprecate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Images_Deprecate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImagesServer).Deprecate(ctx, req.(*DeprecateImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Images_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImagesServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Images_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImagesServer).Get(ctx, req.(*GetImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Images_GetFromFamily_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetFromFamilyImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImagesServer).GetFromFamily(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Images_GetFromFamily_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImagesServer).GetFromFamily(ctx, req.(*GetFromFamilyImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Images_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIamPolicyImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImagesServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Images_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImagesServer).GetIamPolicy(ctx, req.(*GetIamPolicyImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Images_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImagesServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Images_Insert_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImagesServer).Insert(ctx, req.(*InsertImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Images_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListImagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImagesServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Images_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImagesServer).List(ctx, req.(*ListImagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Images_Patch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImagesServer).Patch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Images_Patch_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImagesServer).Patch(ctx, req.(*PatchImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Images_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetIamPolicyImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImagesServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Images_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImagesServer).SetIamPolicy(ctx, req.(*SetIamPolicyImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Images_SetLabels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetLabelsImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImagesServer).SetLabels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Images_SetLabels_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImagesServer).SetLabels(ctx, req.(*SetLabelsImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Images_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TestIamPermissionsImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(ImagesServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Images_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(ImagesServer).TestIamPermissions(ctx, req.(*TestIamPermissionsImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Images_ServiceDesc is the grpc.ServiceDesc for Images service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Images_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.Images",
	HandlerType: (*ImagesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Delete",
			Handler:    _Images_Delete_Handler,
		},
		{
			MethodName: "Deprecate",
			Handler:    _Images_Deprecate_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _Images_Get_Handler,
		},
		{
			MethodName: "GetFromFamily",
			Handler:    _Images_GetFromFamily_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _Images_GetIamPolicy_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _Images_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _Images_List_Handler,
		},
		{
			MethodName: "Patch",
			Handler:    _Images_Patch_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _Images_SetIamPolicy_Handler,
		},
		{
			MethodName: "SetLabels",
			Handler:    _Images_SetLabels_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _Images_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	InstanceGroupManagerResizeRequests_Cancel_FullMethodName = "/google.cloud.compute.v1beta.InstanceGroupManagerResizeRequests/Cancel"
	InstanceGroupManagerResizeRequests_Delete_FullMethodName = "/google.cloud.compute.v1beta.InstanceGroupManagerResizeRequests/Delete"
	InstanceGroupManagerResizeRequests_Get_FullMethodName    = "/google.cloud.compute.v1beta.InstanceGroupManagerResizeRequests/Get"
	InstanceGroupManagerResizeRequests_Insert_FullMethodName = "/google.cloud.compute.v1beta.InstanceGroupManagerResizeRequests/Insert"
	InstanceGroupManagerResizeRequests_List_FullMethodName   = "/google.cloud.compute.v1beta.InstanceGroupManagerResizeRequests/List"
)

// InstanceGroupManagerResizeRequestsClient is the client API for InstanceGroupManagerResizeRequests service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type InstanceGroupManagerResizeRequestsClient interface {
	// Cancels the specified resize request and removes it from the queue. Cancelled resize request does no longer wait for the resources to be provisioned. Cancel is only possible for requests that are accepted in the queue.
	Cancel(ctx context.Context, in *CancelInstanceGroupManagerResizeRequestRequest, opts ...grpc.CallOption) (*Operation, error)
	// Deletes the specified, inactive resize request. Requests that are still active cannot be deleted. Deleting request does not delete instances that were provisioned previously.
	Delete(ctx context.Context, in *DeleteInstanceGroupManagerResizeRequestRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns all of the details about the specified resize request.
	Get(ctx context.Context, in *GetInstanceGroupManagerResizeRequestRequest, opts ...grpc.CallOption) (*InstanceGroupManagerResizeRequest, error)
	// Creates a new resize request that starts provisioning VMs immediately or queues VM creation.
	Insert(ctx context.Context, in *InsertInstanceGroupManagerResizeRequestRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves a list of resize requests that are contained in the managed instance group.
	List(ctx context.Context, in *ListInstanceGroupManagerResizeRequestsRequest, opts ...grpc.CallOption) (*InstanceGroupManagerResizeRequestsListResponse, error)
}

type instanceGroupManagerResizeRequestsClient struct {
	cc grpc.ClientConnInterface
}

func NewInstanceGroupManagerResizeRequestsClient(cc grpc.ClientConnInterface) InstanceGroupManagerResizeRequestsClient {
	return &instanceGroupManagerResizeRequestsClient{cc}
}

func (c *instanceGroupManagerResizeRequestsClient) Cancel(ctx context.Context, in *CancelInstanceGroupManagerResizeRequestRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InstanceGroupManagerResizeRequests_Cancel_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupManagerResizeRequestsClient) Delete(ctx context.Context, in *DeleteInstanceGroupManagerResizeRequestRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InstanceGroupManagerResizeRequests_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupManagerResizeRequestsClient) Get(ctx context.Context, in *GetInstanceGroupManagerResizeRequestRequest, opts ...grpc.CallOption) (*InstanceGroupManagerResizeRequest, error) {
	out := new(InstanceGroupManagerResizeRequest)
	err := c.cc.Invoke(ctx, InstanceGroupManagerResizeRequests_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupManagerResizeRequestsClient) Insert(ctx context.Context, in *InsertInstanceGroupManagerResizeRequestRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InstanceGroupManagerResizeRequests_Insert_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupManagerResizeRequestsClient) List(ctx context.Context, in *ListInstanceGroupManagerResizeRequestsRequest, opts ...grpc.CallOption) (*InstanceGroupManagerResizeRequestsListResponse, error) {
	out := new(InstanceGroupManagerResizeRequestsListResponse)
	err := c.cc.Invoke(ctx, InstanceGroupManagerResizeRequests_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// InstanceGroupManagerResizeRequestsServer is the server API for InstanceGroupManagerResizeRequests service.
// All implementations should embed UnimplementedInstanceGroupManagerResizeRequestsServer
// for forward compatibility
type InstanceGroupManagerResizeRequestsServer interface {
	// Cancels the specified resize request and removes it from the queue. Cancelled resize request does no longer wait for the resources to be provisioned. Cancel is only possible for requests that are accepted in the queue.
	Cancel(context.Context, *CancelInstanceGroupManagerResizeRequestRequest) (*Operation, error)
	// Deletes the specified, inactive resize request. Requests that are still active cannot be deleted. Deleting request does not delete instances that were provisioned previously.
	Delete(context.Context, *DeleteInstanceGroupManagerResizeRequestRequest) (*Operation, error)
	// Returns all of the details about the specified resize request.
	Get(context.Context, *GetInstanceGroupManagerResizeRequestRequest) (*InstanceGroupManagerResizeRequest, error)
	// Creates a new resize request that starts provisioning VMs immediately or queues VM creation.
	Insert(context.Context, *InsertInstanceGroupManagerResizeRequestRequest) (*Operation, error)
	// Retrieves a list of resize requests that are contained in the managed instance group.
	List(context.Context, *ListInstanceGroupManagerResizeRequestsRequest) (*InstanceGroupManagerResizeRequestsListResponse, error)
}

// UnimplementedInstanceGroupManagerResizeRequestsServer should be embedded to have forward compatible implementations.
type UnimplementedInstanceGroupManagerResizeRequestsServer struct {
}

func (UnimplementedInstanceGroupManagerResizeRequestsServer) Cancel(context.Context, *CancelInstanceGroupManagerResizeRequestRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Cancel not implemented")
}
func (UnimplementedInstanceGroupManagerResizeRequestsServer) Delete(context.Context, *DeleteInstanceGroupManagerResizeRequestRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedInstanceGroupManagerResizeRequestsServer) Get(context.Context, *GetInstanceGroupManagerResizeRequestRequest) (*InstanceGroupManagerResizeRequest, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedInstanceGroupManagerResizeRequestsServer) Insert(context.Context, *InsertInstanceGroupManagerResizeRequestRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (UnimplementedInstanceGroupManagerResizeRequestsServer) List(context.Context, *ListInstanceGroupManagerResizeRequestsRequest) (*InstanceGroupManagerResizeRequestsListResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}

// UnsafeInstanceGroupManagerResizeRequestsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to InstanceGroupManagerResizeRequestsServer will
// result in compilation errors.
type UnsafeInstanceGroupManagerResizeRequestsServer interface {
	mustEmbedUnimplementedInstanceGroupManagerResizeRequestsServer()
}

func RegisterInstanceGroupManagerResizeRequestsServer(s grpc.ServiceRegistrar, srv InstanceGroupManagerResizeRequestsServer) {
	s.RegisterService(&InstanceGroupManagerResizeRequests_ServiceDesc, srv)
}

func _InstanceGroupManagerResizeRequests_Cancel_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelInstanceGroupManagerResizeRequestRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupManagerResizeRequestsServer).Cancel(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceGroupManagerResizeRequests_Cancel_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupManagerResizeRequestsServer).Cancel(ctx, req.(*CancelInstanceGroupManagerResizeRequestRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroupManagerResizeRequests_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInstanceGroupManagerResizeRequestRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupManagerResizeRequestsServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceGroupManagerResizeRequests_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupManagerResizeRequestsServer).Delete(ctx, req.(*DeleteInstanceGroupManagerResizeRequestRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroupManagerResizeRequests_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstanceGroupManagerResizeRequestRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupManagerResizeRequestsServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceGroupManagerResizeRequests_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupManagerResizeRequestsServer).Get(ctx, req.(*GetInstanceGroupManagerResizeRequestRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroupManagerResizeRequests_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertInstanceGroupManagerResizeRequestRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupManagerResizeRequestsServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceGroupManagerResizeRequests_Insert_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupManagerResizeRequestsServer).Insert(ctx, req.(*InsertInstanceGroupManagerResizeRequestRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroupManagerResizeRequests_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstanceGroupManagerResizeRequestsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupManagerResizeRequestsServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceGroupManagerResizeRequests_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupManagerResizeRequestsServer).List(ctx, req.(*ListInstanceGroupManagerResizeRequestsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// InstanceGroupManagerResizeRequests_ServiceDesc is the grpc.ServiceDesc for InstanceGroupManagerResizeRequests service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var InstanceGroupManagerResizeRequests_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.InstanceGroupManagerResizeRequests",
	HandlerType: (*InstanceGroupManagerResizeRequestsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Cancel",
			Handler:    _InstanceGroupManagerResizeRequests_Cancel_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _InstanceGroupManagerResizeRequests_Delete_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _InstanceGroupManagerResizeRequests_Get_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _InstanceGroupManagerResizeRequests_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _InstanceGroupManagerResizeRequests_List_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	InstanceGroupManagers_AbandonInstances_FullMethodName         = "/google.cloud.compute.v1beta.InstanceGroupManagers/AbandonInstances"
	InstanceGroupManagers_AggregatedList_FullMethodName           = "/google.cloud.compute.v1beta.InstanceGroupManagers/AggregatedList"
	InstanceGroupManagers_ApplyUpdatesToInstances_FullMethodName  = "/google.cloud.compute.v1beta.InstanceGroupManagers/ApplyUpdatesToInstances"
	InstanceGroupManagers_CreateInstances_FullMethodName          = "/google.cloud.compute.v1beta.InstanceGroupManagers/CreateInstances"
	InstanceGroupManagers_Delete_FullMethodName                   = "/google.cloud.compute.v1beta.InstanceGroupManagers/Delete"
	InstanceGroupManagers_DeleteInstances_FullMethodName          = "/google.cloud.compute.v1beta.InstanceGroupManagers/DeleteInstances"
	InstanceGroupManagers_DeletePerInstanceConfigs_FullMethodName = "/google.cloud.compute.v1beta.InstanceGroupManagers/DeletePerInstanceConfigs"
	InstanceGroupManagers_Get_FullMethodName                      = "/google.cloud.compute.v1beta.InstanceGroupManagers/Get"
	InstanceGroupManagers_Insert_FullMethodName                   = "/google.cloud.compute.v1beta.InstanceGroupManagers/Insert"
	InstanceGroupManagers_List_FullMethodName                     = "/google.cloud.compute.v1beta.InstanceGroupManagers/List"
	InstanceGroupManagers_ListErrors_FullMethodName               = "/google.cloud.compute.v1beta.InstanceGroupManagers/ListErrors"
	InstanceGroupManagers_ListManagedInstances_FullMethodName     = "/google.cloud.compute.v1beta.InstanceGroupManagers/ListManagedInstances"
	InstanceGroupManagers_ListPerInstanceConfigs_FullMethodName   = "/google.cloud.compute.v1beta.InstanceGroupManagers/ListPerInstanceConfigs"
	InstanceGroupManagers_Patch_FullMethodName                    = "/google.cloud.compute.v1beta.InstanceGroupManagers/Patch"
	InstanceGroupManagers_PatchPerInstanceConfigs_FullMethodName  = "/google.cloud.compute.v1beta.InstanceGroupManagers/PatchPerInstanceConfigs"
	InstanceGroupManagers_RecreateInstances_FullMethodName        = "/google.cloud.compute.v1beta.InstanceGroupManagers/RecreateInstances"
	InstanceGroupManagers_Resize_FullMethodName                   = "/google.cloud.compute.v1beta.InstanceGroupManagers/Resize"
	InstanceGroupManagers_ResizeAdvanced_FullMethodName           = "/google.cloud.compute.v1beta.InstanceGroupManagers/ResizeAdvanced"
	InstanceGroupManagers_ResumeInstances_FullMethodName          = "/google.cloud.compute.v1beta.InstanceGroupManagers/ResumeInstances"
	InstanceGroupManagers_SetAutoHealingPolicies_FullMethodName   = "/google.cloud.compute.v1beta.InstanceGroupManagers/SetAutoHealingPolicies"
	InstanceGroupManagers_SetInstanceTemplate_FullMethodName      = "/google.cloud.compute.v1beta.InstanceGroupManagers/SetInstanceTemplate"
	InstanceGroupManagers_SetTargetPools_FullMethodName           = "/google.cloud.compute.v1beta.InstanceGroupManagers/SetTargetPools"
	InstanceGroupManagers_StartInstances_FullMethodName           = "/google.cloud.compute.v1beta.InstanceGroupManagers/StartInstances"
	InstanceGroupManagers_StopInstances_FullMethodName            = "/google.cloud.compute.v1beta.InstanceGroupManagers/StopInstances"
	InstanceGroupManagers_SuspendInstances_FullMethodName         = "/google.cloud.compute.v1beta.InstanceGroupManagers/SuspendInstances"
	InstanceGroupManagers_TestIamPermissions_FullMethodName       = "/google.cloud.compute.v1beta.InstanceGroupManagers/TestIamPermissions"
	InstanceGroupManagers_Update_FullMethodName                   = "/google.cloud.compute.v1beta.InstanceGroupManagers/Update"
	InstanceGroupManagers_UpdatePerInstanceConfigs_FullMethodName = "/google.cloud.compute.v1beta.InstanceGroupManagers/UpdatePerInstanceConfigs"
)

// InstanceGroupManagersClient is the client API for InstanceGroupManagers service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type InstanceGroupManagersClient interface {
	// Flags the specified instances to be removed from the managed instance group. Abandoning an instance does not delete the instance, but it does remove the instance from any target pools that are applied by the managed instance group. This method reduces the targetSize of the managed instance group by the number of instances that you abandon. This operation is marked as DONE when the action is scheduled even if the instances have not yet been removed from the group. You must separately verify the status of the abandoning action with the listmanagedinstances method. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted. You can specify a maximum of 1000 instances with this method per request.
	AbandonInstances(ctx context.Context, in *AbandonInstancesInstanceGroupManagerRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves the list of managed instance groups and groups them by zone. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(ctx context.Context, in *AggregatedListInstanceGroupManagersRequest, opts ...grpc.CallOption) (*InstanceGroupManagerAggregatedList, error)
	// Applies changes to selected instances on the managed instance group. This method can be used to apply new overrides and/or new versions.
	ApplyUpdatesToInstances(ctx context.Context, in *ApplyUpdatesToInstancesInstanceGroupManagerRequest, opts ...grpc.CallOption) (*Operation, error)
	// Creates instances with per-instance configurations in this managed instance group. Instances are created using the current instance template. The create instances operation is marked DONE if the createInstances request is successful. The underlying actions take additional time. You must separately verify the status of the creating or actions with the listmanagedinstances method.
	CreateInstances(ctx context.Context, in *CreateInstancesInstanceGroupManagerRequest, opts ...grpc.CallOption) (*Operation, error)
	// Deletes the specified managed instance group and all of the instances in that group. Note that the instance group must not belong to a backend service. Read Deleting an instance group for more information.
	Delete(ctx context.Context, in *DeleteInstanceGroupManagerRequest, opts ...grpc.CallOption) (*Operation, error)
	// Flags the specified instances in the managed instance group for immediate deletion. The instances are also removed from any target pools of which they were a member. This method reduces the targetSize of the managed instance group by the number of instances that you delete. This operation is marked as DONE when the action is scheduled even if the instances are still being deleted. You must separately verify the status of the deleting action with the listmanagedinstances method. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted. You can specify a maximum of 1000 instances with this method per request.
	DeleteInstances(ctx context.Context, in *DeleteInstancesInstanceGroupManagerRequest, opts ...grpc.CallOption) (*Operation, error)
	// Deletes selected per-instance configurations for the managed instance group.
	DeletePerInstanceConfigs(ctx context.Context, in *DeletePerInstanceConfigsInstanceGroupManagerRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns all of the details about the specified managed instance group.
	Get(ctx context.Context, in *GetInstanceGroupManagerRequest, opts ...grpc.CallOption) (*InstanceGroupManager, error)
	// Creates a managed instance group using the information that you specify in the request. After the group is created, instances in the group are created using the specified instance template. This operation is marked as DONE when the group is created even if the instances in the group have not yet been created. You must separately verify the status of the individual instances with the listmanagedinstances method. A managed instance group can have up to 1000 VM instances per group. Please contact Cloud Support if you need an increase in this limit.
	Insert(ctx context.Context, in *InsertInstanceGroupManagerRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves a list of managed instance groups that are contained within the specified project and zone.
	List(ctx context.Context, in *ListInstanceGroupManagersRequest, opts ...grpc.CallOption) (*InstanceGroupManagerList, error)
	// Lists all errors thrown by actions on instances for a given managed instance group. The filter and orderBy query parameters are not supported.
	ListErrors(ctx context.Context, in *ListErrorsInstanceGroupManagersRequest, opts ...grpc.CallOption) (*InstanceGroupManagersListErrorsResponse, error)
	// Lists all of the instances in the managed instance group. Each instance in the list has a currentAction, which indicates the action that the managed instance group is performing on the instance. For example, if the group is still creating an instance, the currentAction is CREATING. If a previous action failed, the list displays the errors for that failed action. The orderBy query parameter is not supported. The `pageToken` query parameter is supported only if the group's `listManagedInstancesResults` field is set to `PAGINATED`.
	ListManagedInstances(ctx context.Context, in *ListManagedInstancesInstanceGroupManagersRequest, opts ...grpc.CallOption) (*InstanceGroupManagersListManagedInstancesResponse, error)
	// Lists all of the per-instance configurations defined for the managed instance group. The orderBy query parameter is not supported.
	ListPerInstanceConfigs(ctx context.Context, in *ListPerInstanceConfigsInstanceGroupManagersRequest, opts ...grpc.CallOption) (*InstanceGroupManagersListPerInstanceConfigsResp, error)
	// Updates a managed instance group using the information that you specify in the request. This operation is marked as DONE when the group is patched even if the instances in the group are still in the process of being patched. You must separately verify the status of the individual instances with the listManagedInstances method. This method supports PATCH semantics and uses the JSON merge patch format and processing rules. If you update your group to specify a new template or instance configuration, it's possible that your intended specification for each VM in the group is different from the current state of that VM. To learn how to apply an updated configuration to the VMs in a MIG, see Updating instances in a MIG.
	Patch(ctx context.Context, in *PatchInstanceGroupManagerRequest, opts ...grpc.CallOption) (*Operation, error)
	// Inserts or patches per-instance configurations for the managed instance group. perInstanceConfig.name serves as a key used to distinguish whether to perform insert or patch.
	PatchPerInstanceConfigs(ctx context.Context, in *PatchPerInstanceConfigsInstanceGroupManagerRequest, opts ...grpc.CallOption) (*Operation, error)
	// Flags the specified VM instances in the managed instance group to be immediately recreated. Each instance is recreated using the group's current configuration. This operation is marked as DONE when the flag is set even if the instances have not yet been recreated. You must separately verify the status of each instance by checking its currentAction field; for more information, see Checking the status of managed instances. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted. You can specify a maximum of 1000 instances with this method per request.
	RecreateInstances(ctx context.Context, in *RecreateInstancesInstanceGroupManagerRequest, opts ...grpc.CallOption) (*Operation, error)
	// Resizes the managed instance group. If you increase the size, the group creates new instances using the current instance template. If you decrease the size, the group deletes instances. The resize operation is marked DONE when the resize actions are scheduled even if the group has not yet added or deleted any instances. You must separately verify the status of the creating or deleting actions with the listmanagedinstances method. When resizing down, the instance group arbitrarily chooses the order in which VMs are deleted. The group takes into account some VM attributes when making the selection including: + The status of the VM instance. + The health of the VM instance. + The instance template version the VM is based on. + For regional managed instance groups, the location of the VM instance. This list is subject to change. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted.
	Resize(ctx context.Context, in *ResizeInstanceGroupManagerRequest, opts ...grpc.CallOption) (*Operation, error)
	// Resizes the managed instance group with advanced configuration options like disabling creation retries. This is an extended version of the resize method. If you increase the size of the instance group, the group creates new instances using the current instance template. If you decrease the size, the group deletes instances. The resize operation is marked DONE when the resize actions are scheduled even if the group has not yet added or deleted any instances. You must separately verify the status of the creating, creatingWithoutRetries, or deleting actions with the get or listmanagedinstances method. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted.
	ResizeAdvanced(ctx context.Context, in *ResizeAdvancedInstanceGroupManagerRequest, opts ...grpc.CallOption) (*Operation, error)
	// Flags the specified instances in the managed instance group to be resumed. This method increases the targetSize and decreases the targetSuspendedSize of the managed instance group by the number of instances that you resume. The resumeInstances operation is marked DONE if the resumeInstances request is successful. The underlying actions take additional time. You must separately verify the status of the RESUMING action with the listmanagedinstances method. In this request, you can only specify instances that are suspended. For example, if an instance was previously suspended using the suspendInstances method, it can be resumed using the resumeInstances method. If a health check is attached to the managed instance group, the specified instances will be verified as healthy after they are resumed. You can specify a maximum of 1000 instances with this method per request.
	ResumeInstances(ctx context.Context, in *ResumeInstancesInstanceGroupManagerRequest, opts ...grpc.CallOption) (*Operation, error)
	// Motifies the autohealing policy for the instances in this managed instance group. [Deprecated] This method is deprecated. Use instanceGroupManagers.patch instead.
	SetAutoHealingPolicies(ctx context.Context, in *SetAutoHealingPoliciesInstanceGroupManagerRequest, opts ...grpc.CallOption) (*Operation, error)
	// Specifies the instance template to use when creating new instances in this group. The templates for existing instances in the group do not change unless you run recreateInstances, run applyUpdatesToInstances, or set the group's updatePolicy.type to PROACTIVE.
	SetInstanceTemplate(ctx context.Context, in *SetInstanceTemplateInstanceGroupManagerRequest, opts ...grpc.CallOption) (*Operation, error)
	// Modifies the target pools to which all instances in this managed instance group are assigned. The target pools automatically apply to all of the instances in the managed instance group. This operation is marked DONE when you make the request even if the instances have not yet been added to their target pools. The change might take some time to apply to all of the instances in the group depending on the size of the group.
	SetTargetPools(ctx context.Context, in *SetTargetPoolsInstanceGroupManagerRequest, opts ...grpc.CallOption) (*Operation, error)
	// Flags the specified instances in the managed instance group to be started. This method increases the targetSize and decreases the targetStoppedSize of the managed instance group by the number of instances that you start. The startInstances operation is marked DONE if the startInstances request is successful. The underlying actions take additional time. You must separately verify the status of the STARTING action with the listmanagedinstances method. In this request, you can only specify instances that are stopped. For example, if an instance was previously stopped using the stopInstances method, it can be started using the startInstances method. If a health check is attached to the managed instance group, the specified instances will be verified as healthy after they are started. You can specify a maximum of 1000 instances with this method per request.
	StartInstances(ctx context.Context, in *StartInstancesInstanceGroupManagerRequest, opts ...grpc.CallOption) (*Operation, error)
	// Flags the specified instances in the managed instance group to be immediately stopped. You can only specify instances that are running in this request. This method reduces the targetSize and increases the targetStoppedSize of the managed instance group by the number of instances that you stop. The stopInstances operation is marked DONE if the stopInstances request is successful. The underlying actions take additional time. You must separately verify the status of the STOPPING action with the listmanagedinstances method. If the standbyPolicy.initialDelaySec field is set, the group delays stopping the instances until initialDelaySec have passed from instance.creationTimestamp (that is, when the instance was created). This delay gives your application time to set itself up and initialize on the instance. If more than initialDelaySec seconds have passed since instance.creationTimestamp when this method is called, there will be zero delay. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is stopped. Stopped instances can be started using the startInstances method. You can specify a maximum of 1000 instances with this method per request.
	StopInstances(ctx context.Context, in *StopInstancesInstanceGroupManagerRequest, opts ...grpc.CallOption) (*Operation, error)
	// Flags the specified instances in the managed instance group to be immediately suspended. You can only specify instances that are running in this request. This method reduces the targetSize and increases the targetSuspendedSize of the managed instance group by the number of instances that you suspend. The suspendInstances operation is marked DONE if the suspendInstances request is successful. The underlying actions take additional time. You must separately verify the status of the SUSPENDING action with the listmanagedinstances method. If the standbyPolicy.initialDelaySec field is set, the group delays suspension of the instances until initialDelaySec have passed from instance.creationTimestamp (that is, when the instance was created). This delay gives your application time to set itself up and initialize on the instance. If more than initialDelaySec seconds have passed since instance.creationTimestamp when this method is called, there will be zero delay. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is suspended. Suspended instances can be resumed using the resumeInstances method. You can specify a maximum of 1000 instances with this method per request.
	SuspendInstances(ctx context.Context, in *SuspendInstancesInstanceGroupManagerRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(ctx context.Context, in *TestIamPermissionsInstanceGroupManagerRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error)
	// Updates a managed instance group using the information that you specify in the request. This operation is marked as DONE when the group is updated even if the instances in the group have not yet been updated. You must separately verify the status of the individual instances with the listManagedInstances method. If you update your group to specify a new template or instance configuration, it's possible that your intended specification for each VM in the group is different from the current state of that VM. To learn how to apply an updated configuration to the VMs in a MIG, see Updating instances in a MIG.
	Update(ctx context.Context, in *UpdateInstanceGroupManagerRequest, opts ...grpc.CallOption) (*Operation, error)
	// Inserts or updates per-instance configurations for the managed instance group. perInstanceConfig.name serves as a key used to distinguish whether to perform insert or patch.
	UpdatePerInstanceConfigs(ctx context.Context, in *UpdatePerInstanceConfigsInstanceGroupManagerRequest, opts ...grpc.CallOption) (*Operation, error)
}

type instanceGroupManagersClient struct {
	cc grpc.ClientConnInterface
}

func NewInstanceGroupManagersClient(cc grpc.ClientConnInterface) InstanceGroupManagersClient {
	return &instanceGroupManagersClient{cc}
}

func (c *instanceGroupManagersClient) AbandonInstances(ctx context.Context, in *AbandonInstancesInstanceGroupManagerRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InstanceGroupManagers_AbandonInstances_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupManagersClient) AggregatedList(ctx context.Context, in *AggregatedListInstanceGroupManagersRequest, opts ...grpc.CallOption) (*InstanceGroupManagerAggregatedList, error) {
	out := new(InstanceGroupManagerAggregatedList)
	err := c.cc.Invoke(ctx, InstanceGroupManagers_AggregatedList_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupManagersClient) ApplyUpdatesToInstances(ctx context.Context, in *ApplyUpdatesToInstancesInstanceGroupManagerRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InstanceGroupManagers_ApplyUpdatesToInstances_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupManagersClient) CreateInstances(ctx context.Context, in *CreateInstancesInstanceGroupManagerRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InstanceGroupManagers_CreateInstances_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupManagersClient) Delete(ctx context.Context, in *DeleteInstanceGroupManagerRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InstanceGroupManagers_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupManagersClient) DeleteInstances(ctx context.Context, in *DeleteInstancesInstanceGroupManagerRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InstanceGroupManagers_DeleteInstances_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupManagersClient) DeletePerInstanceConfigs(ctx context.Context, in *DeletePerInstanceConfigsInstanceGroupManagerRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InstanceGroupManagers_DeletePerInstanceConfigs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupManagersClient) Get(ctx context.Context, in *GetInstanceGroupManagerRequest, opts ...grpc.CallOption) (*InstanceGroupManager, error) {
	out := new(InstanceGroupManager)
	err := c.cc.Invoke(ctx, InstanceGroupManagers_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupManagersClient) Insert(ctx context.Context, in *InsertInstanceGroupManagerRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InstanceGroupManagers_Insert_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupManagersClient) List(ctx context.Context, in *ListInstanceGroupManagersRequest, opts ...grpc.CallOption) (*InstanceGroupManagerList, error) {
	out := new(InstanceGroupManagerList)
	err := c.cc.Invoke(ctx, InstanceGroupManagers_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupManagersClient) ListErrors(ctx context.Context, in *ListErrorsInstanceGroupManagersRequest, opts ...grpc.CallOption) (*InstanceGroupManagersListErrorsResponse, error) {
	out := new(InstanceGroupManagersListErrorsResponse)
	err := c.cc.Invoke(ctx, InstanceGroupManagers_ListErrors_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupManagersClient) ListManagedInstances(ctx context.Context, in *ListManagedInstancesInstanceGroupManagersRequest, opts ...grpc.CallOption) (*InstanceGroupManagersListManagedInstancesResponse, error) {
	out := new(InstanceGroupManagersListManagedInstancesResponse)
	err := c.cc.Invoke(ctx, InstanceGroupManagers_ListManagedInstances_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupManagersClient) ListPerInstanceConfigs(ctx context.Context, in *ListPerInstanceConfigsInstanceGroupManagersRequest, opts ...grpc.CallOption) (*InstanceGroupManagersListPerInstanceConfigsResp, error) {
	out := new(InstanceGroupManagersListPerInstanceConfigsResp)
	err := c.cc.Invoke(ctx, InstanceGroupManagers_ListPerInstanceConfigs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupManagersClient) Patch(ctx context.Context, in *PatchInstanceGroupManagerRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InstanceGroupManagers_Patch_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupManagersClient) PatchPerInstanceConfigs(ctx context.Context, in *PatchPerInstanceConfigsInstanceGroupManagerRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InstanceGroupManagers_PatchPerInstanceConfigs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupManagersClient) RecreateInstances(ctx context.Context, in *RecreateInstancesInstanceGroupManagerRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InstanceGroupManagers_RecreateInstances_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupManagersClient) Resize(ctx context.Context, in *ResizeInstanceGroupManagerRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InstanceGroupManagers_Resize_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupManagersClient) ResizeAdvanced(ctx context.Context, in *ResizeAdvancedInstanceGroupManagerRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InstanceGroupManagers_ResizeAdvanced_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupManagersClient) ResumeInstances(ctx context.Context, in *ResumeInstancesInstanceGroupManagerRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InstanceGroupManagers_ResumeInstances_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupManagersClient) SetAutoHealingPolicies(ctx context.Context, in *SetAutoHealingPoliciesInstanceGroupManagerRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InstanceGroupManagers_SetAutoHealingPolicies_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupManagersClient) SetInstanceTemplate(ctx context.Context, in *SetInstanceTemplateInstanceGroupManagerRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InstanceGroupManagers_SetInstanceTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupManagersClient) SetTargetPools(ctx context.Context, in *SetTargetPoolsInstanceGroupManagerRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InstanceGroupManagers_SetTargetPools_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupManagersClient) StartInstances(ctx context.Context, in *StartInstancesInstanceGroupManagerRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InstanceGroupManagers_StartInstances_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupManagersClient) StopInstances(ctx context.Context, in *StopInstancesInstanceGroupManagerRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InstanceGroupManagers_StopInstances_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupManagersClient) SuspendInstances(ctx context.Context, in *SuspendInstancesInstanceGroupManagerRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InstanceGroupManagers_SuspendInstances_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupManagersClient) TestIamPermissions(ctx context.Context, in *TestIamPermissionsInstanceGroupManagerRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error) {
	out := new(TestPermissionsResponse)
	err := c.cc.Invoke(ctx, InstanceGroupManagers_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupManagersClient) Update(ctx context.Context, in *UpdateInstanceGroupManagerRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InstanceGroupManagers_Update_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupManagersClient) UpdatePerInstanceConfigs(ctx context.Context, in *UpdatePerInstanceConfigsInstanceGroupManagerRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InstanceGroupManagers_UpdatePerInstanceConfigs_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// InstanceGroupManagersServer is the server API for InstanceGroupManagers service.
// All implementations should embed UnimplementedInstanceGroupManagersServer
// for forward compatibility
type InstanceGroupManagersServer interface {
	// Flags the specified instances to be removed from the managed instance group. Abandoning an instance does not delete the instance, but it does remove the instance from any target pools that are applied by the managed instance group. This method reduces the targetSize of the managed instance group by the number of instances that you abandon. This operation is marked as DONE when the action is scheduled even if the instances have not yet been removed from the group. You must separately verify the status of the abandoning action with the listmanagedinstances method. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted. You can specify a maximum of 1000 instances with this method per request.
	AbandonInstances(context.Context, *AbandonInstancesInstanceGroupManagerRequest) (*Operation, error)
	// Retrieves the list of managed instance groups and groups them by zone. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(context.Context, *AggregatedListInstanceGroupManagersRequest) (*InstanceGroupManagerAggregatedList, error)
	// Applies changes to selected instances on the managed instance group. This method can be used to apply new overrides and/or new versions.
	ApplyUpdatesToInstances(context.Context, *ApplyUpdatesToInstancesInstanceGroupManagerRequest) (*Operation, error)
	// Creates instances with per-instance configurations in this managed instance group. Instances are created using the current instance template. The create instances operation is marked DONE if the createInstances request is successful. The underlying actions take additional time. You must separately verify the status of the creating or actions with the listmanagedinstances method.
	CreateInstances(context.Context, *CreateInstancesInstanceGroupManagerRequest) (*Operation, error)
	// Deletes the specified managed instance group and all of the instances in that group. Note that the instance group must not belong to a backend service. Read Deleting an instance group for more information.
	Delete(context.Context, *DeleteInstanceGroupManagerRequest) (*Operation, error)
	// Flags the specified instances in the managed instance group for immediate deletion. The instances are also removed from any target pools of which they were a member. This method reduces the targetSize of the managed instance group by the number of instances that you delete. This operation is marked as DONE when the action is scheduled even if the instances are still being deleted. You must separately verify the status of the deleting action with the listmanagedinstances method. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted. You can specify a maximum of 1000 instances with this method per request.
	DeleteInstances(context.Context, *DeleteInstancesInstanceGroupManagerRequest) (*Operation, error)
	// Deletes selected per-instance configurations for the managed instance group.
	DeletePerInstanceConfigs(context.Context, *DeletePerInstanceConfigsInstanceGroupManagerRequest) (*Operation, error)
	// Returns all of the details about the specified managed instance group.
	Get(context.Context, *GetInstanceGroupManagerRequest) (*InstanceGroupManager, error)
	// Creates a managed instance group using the information that you specify in the request. After the group is created, instances in the group are created using the specified instance template. This operation is marked as DONE when the group is created even if the instances in the group have not yet been created. You must separately verify the status of the individual instances with the listmanagedinstances method. A managed instance group can have up to 1000 VM instances per group. Please contact Cloud Support if you need an increase in this limit.
	Insert(context.Context, *InsertInstanceGroupManagerRequest) (*Operation, error)
	// Retrieves a list of managed instance groups that are contained within the specified project and zone.
	List(context.Context, *ListInstanceGroupManagersRequest) (*InstanceGroupManagerList, error)
	// Lists all errors thrown by actions on instances for a given managed instance group. The filter and orderBy query parameters are not supported.
	ListErrors(context.Context, *ListErrorsInstanceGroupManagersRequest) (*InstanceGroupManagersListErrorsResponse, error)
	// Lists all of the instances in the managed instance group. Each instance in the list has a currentAction, which indicates the action that the managed instance group is performing on the instance. For example, if the group is still creating an instance, the currentAction is CREATING. If a previous action failed, the list displays the errors for that failed action. The orderBy query parameter is not supported. The `pageToken` query parameter is supported only if the group's `listManagedInstancesResults` field is set to `PAGINATED`.
	ListManagedInstances(context.Context, *ListManagedInstancesInstanceGroupManagersRequest) (*InstanceGroupManagersListManagedInstancesResponse, error)
	// Lists all of the per-instance configurations defined for the managed instance group. The orderBy query parameter is not supported.
	ListPerInstanceConfigs(context.Context, *ListPerInstanceConfigsInstanceGroupManagersRequest) (*InstanceGroupManagersListPerInstanceConfigsResp, error)
	// Updates a managed instance group using the information that you specify in the request. This operation is marked as DONE when the group is patched even if the instances in the group are still in the process of being patched. You must separately verify the status of the individual instances with the listManagedInstances method. This method supports PATCH semantics and uses the JSON merge patch format and processing rules. If you update your group to specify a new template or instance configuration, it's possible that your intended specification for each VM in the group is different from the current state of that VM. To learn how to apply an updated configuration to the VMs in a MIG, see Updating instances in a MIG.
	Patch(context.Context, *PatchInstanceGroupManagerRequest) (*Operation, error)
	// Inserts or patches per-instance configurations for the managed instance group. perInstanceConfig.name serves as a key used to distinguish whether to perform insert or patch.
	PatchPerInstanceConfigs(context.Context, *PatchPerInstanceConfigsInstanceGroupManagerRequest) (*Operation, error)
	// Flags the specified VM instances in the managed instance group to be immediately recreated. Each instance is recreated using the group's current configuration. This operation is marked as DONE when the flag is set even if the instances have not yet been recreated. You must separately verify the status of each instance by checking its currentAction field; for more information, see Checking the status of managed instances. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted. You can specify a maximum of 1000 instances with this method per request.
	RecreateInstances(context.Context, *RecreateInstancesInstanceGroupManagerRequest) (*Operation, error)
	// Resizes the managed instance group. If you increase the size, the group creates new instances using the current instance template. If you decrease the size, the group deletes instances. The resize operation is marked DONE when the resize actions are scheduled even if the group has not yet added or deleted any instances. You must separately verify the status of the creating or deleting actions with the listmanagedinstances method. When resizing down, the instance group arbitrarily chooses the order in which VMs are deleted. The group takes into account some VM attributes when making the selection including: + The status of the VM instance. + The health of the VM instance. + The instance template version the VM is based on. + For regional managed instance groups, the location of the VM instance. This list is subject to change. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted.
	Resize(context.Context, *ResizeInstanceGroupManagerRequest) (*Operation, error)
	// Resizes the managed instance group with advanced configuration options like disabling creation retries. This is an extended version of the resize method. If you increase the size of the instance group, the group creates new instances using the current instance template. If you decrease the size, the group deletes instances. The resize operation is marked DONE when the resize actions are scheduled even if the group has not yet added or deleted any instances. You must separately verify the status of the creating, creatingWithoutRetries, or deleting actions with the get or listmanagedinstances method. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is removed or deleted.
	ResizeAdvanced(context.Context, *ResizeAdvancedInstanceGroupManagerRequest) (*Operation, error)
	// Flags the specified instances in the managed instance group to be resumed. This method increases the targetSize and decreases the targetSuspendedSize of the managed instance group by the number of instances that you resume. The resumeInstances operation is marked DONE if the resumeInstances request is successful. The underlying actions take additional time. You must separately verify the status of the RESUMING action with the listmanagedinstances method. In this request, you can only specify instances that are suspended. For example, if an instance was previously suspended using the suspendInstances method, it can be resumed using the resumeInstances method. If a health check is attached to the managed instance group, the specified instances will be verified as healthy after they are resumed. You can specify a maximum of 1000 instances with this method per request.
	ResumeInstances(context.Context, *ResumeInstancesInstanceGroupManagerRequest) (*Operation, error)
	// Motifies the autohealing policy for the instances in this managed instance group. [Deprecated] This method is deprecated. Use instanceGroupManagers.patch instead.
	SetAutoHealingPolicies(context.Context, *SetAutoHealingPoliciesInstanceGroupManagerRequest) (*Operation, error)
	// Specifies the instance template to use when creating new instances in this group. The templates for existing instances in the group do not change unless you run recreateInstances, run applyUpdatesToInstances, or set the group's updatePolicy.type to PROACTIVE.
	SetInstanceTemplate(context.Context, *SetInstanceTemplateInstanceGroupManagerRequest) (*Operation, error)
	// Modifies the target pools to which all instances in this managed instance group are assigned. The target pools automatically apply to all of the instances in the managed instance group. This operation is marked DONE when you make the request even if the instances have not yet been added to their target pools. The change might take some time to apply to all of the instances in the group depending on the size of the group.
	SetTargetPools(context.Context, *SetTargetPoolsInstanceGroupManagerRequest) (*Operation, error)
	// Flags the specified instances in the managed instance group to be started. This method increases the targetSize and decreases the targetStoppedSize of the managed instance group by the number of instances that you start. The startInstances operation is marked DONE if the startInstances request is successful. The underlying actions take additional time. You must separately verify the status of the STARTING action with the listmanagedinstances method. In this request, you can only specify instances that are stopped. For example, if an instance was previously stopped using the stopInstances method, it can be started using the startInstances method. If a health check is attached to the managed instance group, the specified instances will be verified as healthy after they are started. You can specify a maximum of 1000 instances with this method per request.
	StartInstances(context.Context, *StartInstancesInstanceGroupManagerRequest) (*Operation, error)
	// Flags the specified instances in the managed instance group to be immediately stopped. You can only specify instances that are running in this request. This method reduces the targetSize and increases the targetStoppedSize of the managed instance group by the number of instances that you stop. The stopInstances operation is marked DONE if the stopInstances request is successful. The underlying actions take additional time. You must separately verify the status of the STOPPING action with the listmanagedinstances method. If the standbyPolicy.initialDelaySec field is set, the group delays stopping the instances until initialDelaySec have passed from instance.creationTimestamp (that is, when the instance was created). This delay gives your application time to set itself up and initialize on the instance. If more than initialDelaySec seconds have passed since instance.creationTimestamp when this method is called, there will be zero delay. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is stopped. Stopped instances can be started using the startInstances method. You can specify a maximum of 1000 instances with this method per request.
	StopInstances(context.Context, *StopInstancesInstanceGroupManagerRequest) (*Operation, error)
	// Flags the specified instances in the managed instance group to be immediately suspended. You can only specify instances that are running in this request. This method reduces the targetSize and increases the targetSuspendedSize of the managed instance group by the number of instances that you suspend. The suspendInstances operation is marked DONE if the suspendInstances request is successful. The underlying actions take additional time. You must separately verify the status of the SUSPENDING action with the listmanagedinstances method. If the standbyPolicy.initialDelaySec field is set, the group delays suspension of the instances until initialDelaySec have passed from instance.creationTimestamp (that is, when the instance was created). This delay gives your application time to set itself up and initialize on the instance. If more than initialDelaySec seconds have passed since instance.creationTimestamp when this method is called, there will be zero delay. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration has elapsed before the VM instance is suspended. Suspended instances can be resumed using the resumeInstances method. You can specify a maximum of 1000 instances with this method per request.
	SuspendInstances(context.Context, *SuspendInstancesInstanceGroupManagerRequest) (*Operation, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(context.Context, *TestIamPermissionsInstanceGroupManagerRequest) (*TestPermissionsResponse, error)
	// Updates a managed instance group using the information that you specify in the request. This operation is marked as DONE when the group is updated even if the instances in the group have not yet been updated. You must separately verify the status of the individual instances with the listManagedInstances method. If you update your group to specify a new template or instance configuration, it's possible that your intended specification for each VM in the group is different from the current state of that VM. To learn how to apply an updated configuration to the VMs in a MIG, see Updating instances in a MIG.
	Update(context.Context, *UpdateInstanceGroupManagerRequest) (*Operation, error)
	// Inserts or updates per-instance configurations for the managed instance group. perInstanceConfig.name serves as a key used to distinguish whether to perform insert or patch.
	UpdatePerInstanceConfigs(context.Context, *UpdatePerInstanceConfigsInstanceGroupManagerRequest) (*Operation, error)
}

// UnimplementedInstanceGroupManagersServer should be embedded to have forward compatible implementations.
type UnimplementedInstanceGroupManagersServer struct {
}

func (UnimplementedInstanceGroupManagersServer) AbandonInstances(context.Context, *AbandonInstancesInstanceGroupManagerRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AbandonInstances not implemented")
}
func (UnimplementedInstanceGroupManagersServer) AggregatedList(context.Context, *AggregatedListInstanceGroupManagersRequest) (*InstanceGroupManagerAggregatedList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AggregatedList not implemented")
}
func (UnimplementedInstanceGroupManagersServer) ApplyUpdatesToInstances(context.Context, *ApplyUpdatesToInstancesInstanceGroupManagerRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ApplyUpdatesToInstances not implemented")
}
func (UnimplementedInstanceGroupManagersServer) CreateInstances(context.Context, *CreateInstancesInstanceGroupManagerRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateInstances not implemented")
}
func (UnimplementedInstanceGroupManagersServer) Delete(context.Context, *DeleteInstanceGroupManagerRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedInstanceGroupManagersServer) DeleteInstances(context.Context, *DeleteInstancesInstanceGroupManagerRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteInstances not implemented")
}
func (UnimplementedInstanceGroupManagersServer) DeletePerInstanceConfigs(context.Context, *DeletePerInstanceConfigsInstanceGroupManagerRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeletePerInstanceConfigs not implemented")
}
func (UnimplementedInstanceGroupManagersServer) Get(context.Context, *GetInstanceGroupManagerRequest) (*InstanceGroupManager, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedInstanceGroupManagersServer) Insert(context.Context, *InsertInstanceGroupManagerRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (UnimplementedInstanceGroupManagersServer) List(context.Context, *ListInstanceGroupManagersRequest) (*InstanceGroupManagerList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedInstanceGroupManagersServer) ListErrors(context.Context, *ListErrorsInstanceGroupManagersRequest) (*InstanceGroupManagersListErrorsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListErrors not implemented")
}
func (UnimplementedInstanceGroupManagersServer) ListManagedInstances(context.Context, *ListManagedInstancesInstanceGroupManagersRequest) (*InstanceGroupManagersListManagedInstancesResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListManagedInstances not implemented")
}
func (UnimplementedInstanceGroupManagersServer) ListPerInstanceConfigs(context.Context, *ListPerInstanceConfigsInstanceGroupManagersRequest) (*InstanceGroupManagersListPerInstanceConfigsResp, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPerInstanceConfigs not implemented")
}
func (UnimplementedInstanceGroupManagersServer) Patch(context.Context, *PatchInstanceGroupManagerRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Patch not implemented")
}
func (UnimplementedInstanceGroupManagersServer) PatchPerInstanceConfigs(context.Context, *PatchPerInstanceConfigsInstanceGroupManagerRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PatchPerInstanceConfigs not implemented")
}
func (UnimplementedInstanceGroupManagersServer) RecreateInstances(context.Context, *RecreateInstancesInstanceGroupManagerRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RecreateInstances not implemented")
}
func (UnimplementedInstanceGroupManagersServer) Resize(context.Context, *ResizeInstanceGroupManagerRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Resize not implemented")
}
func (UnimplementedInstanceGroupManagersServer) ResizeAdvanced(context.Context, *ResizeAdvancedInstanceGroupManagerRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResizeAdvanced not implemented")
}
func (UnimplementedInstanceGroupManagersServer) ResumeInstances(context.Context, *ResumeInstancesInstanceGroupManagerRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ResumeInstances not implemented")
}
func (UnimplementedInstanceGroupManagersServer) SetAutoHealingPolicies(context.Context, *SetAutoHealingPoliciesInstanceGroupManagerRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetAutoHealingPolicies not implemented")
}
func (UnimplementedInstanceGroupManagersServer) SetInstanceTemplate(context.Context, *SetInstanceTemplateInstanceGroupManagerRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetInstanceTemplate not implemented")
}
func (UnimplementedInstanceGroupManagersServer) SetTargetPools(context.Context, *SetTargetPoolsInstanceGroupManagerRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetTargetPools not implemented")
}
func (UnimplementedInstanceGroupManagersServer) StartInstances(context.Context, *StartInstancesInstanceGroupManagerRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartInstances not implemented")
}
func (UnimplementedInstanceGroupManagersServer) StopInstances(context.Context, *StopInstancesInstanceGroupManagerRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StopInstances not implemented")
}
func (UnimplementedInstanceGroupManagersServer) SuspendInstances(context.Context, *SuspendInstancesInstanceGroupManagerRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SuspendInstances not implemented")
}
func (UnimplementedInstanceGroupManagersServer) TestIamPermissions(context.Context, *TestIamPermissionsInstanceGroupManagerRequest) (*TestPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}
func (UnimplementedInstanceGroupManagersServer) Update(context.Context, *UpdateInstanceGroupManagerRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (UnimplementedInstanceGroupManagersServer) UpdatePerInstanceConfigs(context.Context, *UpdatePerInstanceConfigsInstanceGroupManagerRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdatePerInstanceConfigs not implemented")
}

// UnsafeInstanceGroupManagersServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to InstanceGroupManagersServer will
// result in compilation errors.
type UnsafeInstanceGroupManagersServer interface {
	mustEmbedUnimplementedInstanceGroupManagersServer()
}

func RegisterInstanceGroupManagersServer(s grpc.ServiceRegistrar, srv InstanceGroupManagersServer) {
	s.RegisterService(&InstanceGroupManagers_ServiceDesc, srv)
}

func _InstanceGroupManagers_AbandonInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AbandonInstancesInstanceGroupManagerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupManagersServer).AbandonInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceGroupManagers_AbandonInstances_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupManagersServer).AbandonInstances(ctx, req.(*AbandonInstancesInstanceGroupManagerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroupManagers_AggregatedList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AggregatedListInstanceGroupManagersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupManagersServer).AggregatedList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceGroupManagers_AggregatedList_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupManagersServer).AggregatedList(ctx, req.(*AggregatedListInstanceGroupManagersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroupManagers_ApplyUpdatesToInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApplyUpdatesToInstancesInstanceGroupManagerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupManagersServer).ApplyUpdatesToInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceGroupManagers_ApplyUpdatesToInstances_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupManagersServer).ApplyUpdatesToInstances(ctx, req.(*ApplyUpdatesToInstancesInstanceGroupManagerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroupManagers_CreateInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateInstancesInstanceGroupManagerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupManagersServer).CreateInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceGroupManagers_CreateInstances_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupManagersServer).CreateInstances(ctx, req.(*CreateInstancesInstanceGroupManagerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroupManagers_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInstanceGroupManagerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupManagersServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceGroupManagers_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupManagersServer).Delete(ctx, req.(*DeleteInstanceGroupManagerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroupManagers_DeleteInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInstancesInstanceGroupManagerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupManagersServer).DeleteInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceGroupManagers_DeleteInstances_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupManagersServer).DeleteInstances(ctx, req.(*DeleteInstancesInstanceGroupManagerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroupManagers_DeletePerInstanceConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeletePerInstanceConfigsInstanceGroupManagerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupManagersServer).DeletePerInstanceConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceGroupManagers_DeletePerInstanceConfigs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupManagersServer).DeletePerInstanceConfigs(ctx, req.(*DeletePerInstanceConfigsInstanceGroupManagerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroupManagers_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstanceGroupManagerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupManagersServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceGroupManagers_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupManagersServer).Get(ctx, req.(*GetInstanceGroupManagerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroupManagers_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertInstanceGroupManagerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupManagersServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceGroupManagers_Insert_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupManagersServer).Insert(ctx, req.(*InsertInstanceGroupManagerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroupManagers_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstanceGroupManagersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupManagersServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceGroupManagers_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupManagersServer).List(ctx, req.(*ListInstanceGroupManagersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroupManagers_ListErrors_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListErrorsInstanceGroupManagersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupManagersServer).ListErrors(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceGroupManagers_ListErrors_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupManagersServer).ListErrors(ctx, req.(*ListErrorsInstanceGroupManagersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroupManagers_ListManagedInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListManagedInstancesInstanceGroupManagersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupManagersServer).ListManagedInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceGroupManagers_ListManagedInstances_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupManagersServer).ListManagedInstances(ctx, req.(*ListManagedInstancesInstanceGroupManagersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroupManagers_ListPerInstanceConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPerInstanceConfigsInstanceGroupManagersRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupManagersServer).ListPerInstanceConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceGroupManagers_ListPerInstanceConfigs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupManagersServer).ListPerInstanceConfigs(ctx, req.(*ListPerInstanceConfigsInstanceGroupManagersRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroupManagers_Patch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchInstanceGroupManagerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupManagersServer).Patch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceGroupManagers_Patch_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupManagersServer).Patch(ctx, req.(*PatchInstanceGroupManagerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroupManagers_PatchPerInstanceConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchPerInstanceConfigsInstanceGroupManagerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupManagersServer).PatchPerInstanceConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceGroupManagers_PatchPerInstanceConfigs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupManagersServer).PatchPerInstanceConfigs(ctx, req.(*PatchPerInstanceConfigsInstanceGroupManagerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroupManagers_RecreateInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RecreateInstancesInstanceGroupManagerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupManagersServer).RecreateInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceGroupManagers_RecreateInstances_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupManagersServer).RecreateInstances(ctx, req.(*RecreateInstancesInstanceGroupManagerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroupManagers_Resize_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResizeInstanceGroupManagerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupManagersServer).Resize(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceGroupManagers_Resize_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupManagersServer).Resize(ctx, req.(*ResizeInstanceGroupManagerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroupManagers_ResizeAdvanced_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResizeAdvancedInstanceGroupManagerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupManagersServer).ResizeAdvanced(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceGroupManagers_ResizeAdvanced_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupManagersServer).ResizeAdvanced(ctx, req.(*ResizeAdvancedInstanceGroupManagerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroupManagers_ResumeInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResumeInstancesInstanceGroupManagerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupManagersServer).ResumeInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceGroupManagers_ResumeInstances_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupManagersServer).ResumeInstances(ctx, req.(*ResumeInstancesInstanceGroupManagerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroupManagers_SetAutoHealingPolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetAutoHealingPoliciesInstanceGroupManagerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupManagersServer).SetAutoHealingPolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceGroupManagers_SetAutoHealingPolicies_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupManagersServer).SetAutoHealingPolicies(ctx, req.(*SetAutoHealingPoliciesInstanceGroupManagerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroupManagers_SetInstanceTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetInstanceTemplateInstanceGroupManagerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupManagersServer).SetInstanceTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceGroupManagers_SetInstanceTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupManagersServer).SetInstanceTemplate(ctx, req.(*SetInstanceTemplateInstanceGroupManagerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroupManagers_SetTargetPools_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetTargetPoolsInstanceGroupManagerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupManagersServer).SetTargetPools(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceGroupManagers_SetTargetPools_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupManagersServer).SetTargetPools(ctx, req.(*SetTargetPoolsInstanceGroupManagerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroupManagers_StartInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartInstancesInstanceGroupManagerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupManagersServer).StartInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceGroupManagers_StartInstances_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupManagersServer).StartInstances(ctx, req.(*StartInstancesInstanceGroupManagerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroupManagers_StopInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopInstancesInstanceGroupManagerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupManagersServer).StopInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceGroupManagers_StopInstances_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupManagersServer).StopInstances(ctx, req.(*StopInstancesInstanceGroupManagerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroupManagers_SuspendInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SuspendInstancesInstanceGroupManagerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupManagersServer).SuspendInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceGroupManagers_SuspendInstances_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupManagersServer).SuspendInstances(ctx, req.(*SuspendInstancesInstanceGroupManagerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroupManagers_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TestIamPermissionsInstanceGroupManagerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupManagersServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceGroupManagers_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupManagersServer).TestIamPermissions(ctx, req.(*TestIamPermissionsInstanceGroupManagerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroupManagers_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateInstanceGroupManagerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupManagersServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceGroupManagers_Update_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupManagersServer).Update(ctx, req.(*UpdateInstanceGroupManagerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroupManagers_UpdatePerInstanceConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePerInstanceConfigsInstanceGroupManagerRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupManagersServer).UpdatePerInstanceConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceGroupManagers_UpdatePerInstanceConfigs_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupManagersServer).UpdatePerInstanceConfigs(ctx, req.(*UpdatePerInstanceConfigsInstanceGroupManagerRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// InstanceGroupManagers_ServiceDesc is the grpc.ServiceDesc for InstanceGroupManagers service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var InstanceGroupManagers_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.InstanceGroupManagers",
	HandlerType: (*InstanceGroupManagersServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AbandonInstances",
			Handler:    _InstanceGroupManagers_AbandonInstances_Handler,
		},
		{
			MethodName: "AggregatedList",
			Handler:    _InstanceGroupManagers_AggregatedList_Handler,
		},
		{
			MethodName: "ApplyUpdatesToInstances",
			Handler:    _InstanceGroupManagers_ApplyUpdatesToInstances_Handler,
		},
		{
			MethodName: "CreateInstances",
			Handler:    _InstanceGroupManagers_CreateInstances_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _InstanceGroupManagers_Delete_Handler,
		},
		{
			MethodName: "DeleteInstances",
			Handler:    _InstanceGroupManagers_DeleteInstances_Handler,
		},
		{
			MethodName: "DeletePerInstanceConfigs",
			Handler:    _InstanceGroupManagers_DeletePerInstanceConfigs_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _InstanceGroupManagers_Get_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _InstanceGroupManagers_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _InstanceGroupManagers_List_Handler,
		},
		{
			MethodName: "ListErrors",
			Handler:    _InstanceGroupManagers_ListErrors_Handler,
		},
		{
			MethodName: "ListManagedInstances",
			Handler:    _InstanceGroupManagers_ListManagedInstances_Handler,
		},
		{
			MethodName: "ListPerInstanceConfigs",
			Handler:    _InstanceGroupManagers_ListPerInstanceConfigs_Handler,
		},
		{
			MethodName: "Patch",
			Handler:    _InstanceGroupManagers_Patch_Handler,
		},
		{
			MethodName: "PatchPerInstanceConfigs",
			Handler:    _InstanceGroupManagers_PatchPerInstanceConfigs_Handler,
		},
		{
			MethodName: "RecreateInstances",
			Handler:    _InstanceGroupManagers_RecreateInstances_Handler,
		},
		{
			MethodName: "Resize",
			Handler:    _InstanceGroupManagers_Resize_Handler,
		},
		{
			MethodName: "ResizeAdvanced",
			Handler:    _InstanceGroupManagers_ResizeAdvanced_Handler,
		},
		{
			MethodName: "ResumeInstances",
			Handler:    _InstanceGroupManagers_ResumeInstances_Handler,
		},
		{
			MethodName: "SetAutoHealingPolicies",
			Handler:    _InstanceGroupManagers_SetAutoHealingPolicies_Handler,
		},
		{
			MethodName: "SetInstanceTemplate",
			Handler:    _InstanceGroupManagers_SetInstanceTemplate_Handler,
		},
		{
			MethodName: "SetTargetPools",
			Handler:    _InstanceGroupManagers_SetTargetPools_Handler,
		},
		{
			MethodName: "StartInstances",
			Handler:    _InstanceGroupManagers_StartInstances_Handler,
		},
		{
			MethodName: "StopInstances",
			Handler:    _InstanceGroupManagers_StopInstances_Handler,
		},
		{
			MethodName: "SuspendInstances",
			Handler:    _InstanceGroupManagers_SuspendInstances_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _InstanceGroupManagers_TestIamPermissions_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _InstanceGroupManagers_Update_Handler,
		},
		{
			MethodName: "UpdatePerInstanceConfigs",
			Handler:    _InstanceGroupManagers_UpdatePerInstanceConfigs_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	InstanceGroups_AddInstances_FullMethodName       = "/google.cloud.compute.v1beta.InstanceGroups/AddInstances"
	InstanceGroups_AggregatedList_FullMethodName     = "/google.cloud.compute.v1beta.InstanceGroups/AggregatedList"
	InstanceGroups_Delete_FullMethodName             = "/google.cloud.compute.v1beta.InstanceGroups/Delete"
	InstanceGroups_Get_FullMethodName                = "/google.cloud.compute.v1beta.InstanceGroups/Get"
	InstanceGroups_Insert_FullMethodName             = "/google.cloud.compute.v1beta.InstanceGroups/Insert"
	InstanceGroups_List_FullMethodName               = "/google.cloud.compute.v1beta.InstanceGroups/List"
	InstanceGroups_ListInstances_FullMethodName      = "/google.cloud.compute.v1beta.InstanceGroups/ListInstances"
	InstanceGroups_RemoveInstances_FullMethodName    = "/google.cloud.compute.v1beta.InstanceGroups/RemoveInstances"
	InstanceGroups_SetNamedPorts_FullMethodName      = "/google.cloud.compute.v1beta.InstanceGroups/SetNamedPorts"
	InstanceGroups_TestIamPermissions_FullMethodName = "/google.cloud.compute.v1beta.InstanceGroups/TestIamPermissions"
)

// InstanceGroupsClient is the client API for InstanceGroups service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type InstanceGroupsClient interface {
	// Adds a list of instances to the specified instance group. All of the instances in the instance group must be in the same network/subnetwork. Read Adding instances for more information.
	AddInstances(ctx context.Context, in *AddInstancesInstanceGroupRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves the list of instance groups and sorts them by zone. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(ctx context.Context, in *AggregatedListInstanceGroupsRequest, opts ...grpc.CallOption) (*InstanceGroupAggregatedList, error)
	// Deletes the specified instance group. The instances in the group are not deleted. Note that instance group must not belong to a backend service. Read Deleting an instance group for more information.
	Delete(ctx context.Context, in *DeleteInstanceGroupRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns the specified zonal instance group. Get a list of available zonal instance groups by making a list() request. For managed instance groups, use the instanceGroupManagers or regionInstanceGroupManagers methods instead.
	Get(ctx context.Context, in *GetInstanceGroupRequest, opts ...grpc.CallOption) (*InstanceGroup, error)
	// Creates an instance group in the specified project using the parameters that are included in the request.
	Insert(ctx context.Context, in *InsertInstanceGroupRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves the list of zonal instance group resources contained within the specified zone. For managed instance groups, use the instanceGroupManagers or regionInstanceGroupManagers methods instead.
	List(ctx context.Context, in *ListInstanceGroupsRequest, opts ...grpc.CallOption) (*InstanceGroupList, error)
	// Lists the instances in the specified instance group. The orderBy query parameter is not supported. The filter query parameter is supported, but only for expressions that use `eq` (equal) or `ne` (not equal) operators.
	ListInstances(ctx context.Context, in *ListInstancesInstanceGroupsRequest, opts ...grpc.CallOption) (*InstanceGroupsListInstances, error)
	// Removes one or more instances from the specified instance group, but does not delete those instances. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration before the VM instance is removed or deleted.
	RemoveInstances(ctx context.Context, in *RemoveInstancesInstanceGroupRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the named ports for the specified instance group.
	SetNamedPorts(ctx context.Context, in *SetNamedPortsInstanceGroupRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(ctx context.Context, in *TestIamPermissionsInstanceGroupRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error)
}

type instanceGroupsClient struct {
	cc grpc.ClientConnInterface
}

func NewInstanceGroupsClient(cc grpc.ClientConnInterface) InstanceGroupsClient {
	return &instanceGroupsClient{cc}
}

func (c *instanceGroupsClient) AddInstances(ctx context.Context, in *AddInstancesInstanceGroupRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InstanceGroups_AddInstances_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupsClient) AggregatedList(ctx context.Context, in *AggregatedListInstanceGroupsRequest, opts ...grpc.CallOption) (*InstanceGroupAggregatedList, error) {
	out := new(InstanceGroupAggregatedList)
	err := c.cc.Invoke(ctx, InstanceGroups_AggregatedList_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupsClient) Delete(ctx context.Context, in *DeleteInstanceGroupRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InstanceGroups_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupsClient) Get(ctx context.Context, in *GetInstanceGroupRequest, opts ...grpc.CallOption) (*InstanceGroup, error) {
	out := new(InstanceGroup)
	err := c.cc.Invoke(ctx, InstanceGroups_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupsClient) Insert(ctx context.Context, in *InsertInstanceGroupRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InstanceGroups_Insert_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupsClient) List(ctx context.Context, in *ListInstanceGroupsRequest, opts ...grpc.CallOption) (*InstanceGroupList, error) {
	out := new(InstanceGroupList)
	err := c.cc.Invoke(ctx, InstanceGroups_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupsClient) ListInstances(ctx context.Context, in *ListInstancesInstanceGroupsRequest, opts ...grpc.CallOption) (*InstanceGroupsListInstances, error) {
	out := new(InstanceGroupsListInstances)
	err := c.cc.Invoke(ctx, InstanceGroups_ListInstances_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupsClient) RemoveInstances(ctx context.Context, in *RemoveInstancesInstanceGroupRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InstanceGroups_RemoveInstances_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupsClient) SetNamedPorts(ctx context.Context, in *SetNamedPortsInstanceGroupRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InstanceGroups_SetNamedPorts_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceGroupsClient) TestIamPermissions(ctx context.Context, in *TestIamPermissionsInstanceGroupRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error) {
	out := new(TestPermissionsResponse)
	err := c.cc.Invoke(ctx, InstanceGroups_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// InstanceGroupsServer is the server API for InstanceGroups service.
// All implementations should embed UnimplementedInstanceGroupsServer
// for forward compatibility
type InstanceGroupsServer interface {
	// Adds a list of instances to the specified instance group. All of the instances in the instance group must be in the same network/subnetwork. Read Adding instances for more information.
	AddInstances(context.Context, *AddInstancesInstanceGroupRequest) (*Operation, error)
	// Retrieves the list of instance groups and sorts them by zone. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(context.Context, *AggregatedListInstanceGroupsRequest) (*InstanceGroupAggregatedList, error)
	// Deletes the specified instance group. The instances in the group are not deleted. Note that instance group must not belong to a backend service. Read Deleting an instance group for more information.
	Delete(context.Context, *DeleteInstanceGroupRequest) (*Operation, error)
	// Returns the specified zonal instance group. Get a list of available zonal instance groups by making a list() request. For managed instance groups, use the instanceGroupManagers or regionInstanceGroupManagers methods instead.
	Get(context.Context, *GetInstanceGroupRequest) (*InstanceGroup, error)
	// Creates an instance group in the specified project using the parameters that are included in the request.
	Insert(context.Context, *InsertInstanceGroupRequest) (*Operation, error)
	// Retrieves the list of zonal instance group resources contained within the specified zone. For managed instance groups, use the instanceGroupManagers or regionInstanceGroupManagers methods instead.
	List(context.Context, *ListInstanceGroupsRequest) (*InstanceGroupList, error)
	// Lists the instances in the specified instance group. The orderBy query parameter is not supported. The filter query parameter is supported, but only for expressions that use `eq` (equal) or `ne` (not equal) operators.
	ListInstances(context.Context, *ListInstancesInstanceGroupsRequest) (*InstanceGroupsListInstances, error)
	// Removes one or more instances from the specified instance group, but does not delete those instances. If the group is part of a backend service that has enabled connection draining, it can take up to 60 seconds after the connection draining duration before the VM instance is removed or deleted.
	RemoveInstances(context.Context, *RemoveInstancesInstanceGroupRequest) (*Operation, error)
	// Sets the named ports for the specified instance group.
	SetNamedPorts(context.Context, *SetNamedPortsInstanceGroupRequest) (*Operation, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(context.Context, *TestIamPermissionsInstanceGroupRequest) (*TestPermissionsResponse, error)
}

// UnimplementedInstanceGroupsServer should be embedded to have forward compatible implementations.
type UnimplementedInstanceGroupsServer struct {
}

func (UnimplementedInstanceGroupsServer) AddInstances(context.Context, *AddInstancesInstanceGroupRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddInstances not implemented")
}
func (UnimplementedInstanceGroupsServer) AggregatedList(context.Context, *AggregatedListInstanceGroupsRequest) (*InstanceGroupAggregatedList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AggregatedList not implemented")
}
func (UnimplementedInstanceGroupsServer) Delete(context.Context, *DeleteInstanceGroupRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedInstanceGroupsServer) Get(context.Context, *GetInstanceGroupRequest) (*InstanceGroup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedInstanceGroupsServer) Insert(context.Context, *InsertInstanceGroupRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (UnimplementedInstanceGroupsServer) List(context.Context, *ListInstanceGroupsRequest) (*InstanceGroupList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedInstanceGroupsServer) ListInstances(context.Context, *ListInstancesInstanceGroupsRequest) (*InstanceGroupsListInstances, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListInstances not implemented")
}
func (UnimplementedInstanceGroupsServer) RemoveInstances(context.Context, *RemoveInstancesInstanceGroupRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveInstances not implemented")
}
func (UnimplementedInstanceGroupsServer) SetNamedPorts(context.Context, *SetNamedPortsInstanceGroupRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetNamedPorts not implemented")
}
func (UnimplementedInstanceGroupsServer) TestIamPermissions(context.Context, *TestIamPermissionsInstanceGroupRequest) (*TestPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

// UnsafeInstanceGroupsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to InstanceGroupsServer will
// result in compilation errors.
type UnsafeInstanceGroupsServer interface {
	mustEmbedUnimplementedInstanceGroupsServer()
}

func RegisterInstanceGroupsServer(s grpc.ServiceRegistrar, srv InstanceGroupsServer) {
	s.RegisterService(&InstanceGroups_ServiceDesc, srv)
}

func _InstanceGroups_AddInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddInstancesInstanceGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupsServer).AddInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceGroups_AddInstances_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupsServer).AddInstances(ctx, req.(*AddInstancesInstanceGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroups_AggregatedList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AggregatedListInstanceGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupsServer).AggregatedList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceGroups_AggregatedList_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupsServer).AggregatedList(ctx, req.(*AggregatedListInstanceGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroups_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInstanceGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupsServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceGroups_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupsServer).Delete(ctx, req.(*DeleteInstanceGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroups_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstanceGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupsServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceGroups_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupsServer).Get(ctx, req.(*GetInstanceGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroups_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertInstanceGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupsServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceGroups_Insert_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupsServer).Insert(ctx, req.(*InsertInstanceGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroups_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstanceGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupsServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceGroups_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupsServer).List(ctx, req.(*ListInstanceGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroups_ListInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstancesInstanceGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupsServer).ListInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceGroups_ListInstances_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupsServer).ListInstances(ctx, req.(*ListInstancesInstanceGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroups_RemoveInstances_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveInstancesInstanceGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupsServer).RemoveInstances(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceGroups_RemoveInstances_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupsServer).RemoveInstances(ctx, req.(*RemoveInstancesInstanceGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroups_SetNamedPorts_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetNamedPortsInstanceGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupsServer).SetNamedPorts(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceGroups_SetNamedPorts_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupsServer).SetNamedPorts(ctx, req.(*SetNamedPortsInstanceGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceGroups_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TestIamPermissionsInstanceGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceGroupsServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceGroups_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceGroupsServer).TestIamPermissions(ctx, req.(*TestIamPermissionsInstanceGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// InstanceGroups_ServiceDesc is the grpc.ServiceDesc for InstanceGroups service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var InstanceGroups_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.InstanceGroups",
	HandlerType: (*InstanceGroupsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AddInstances",
			Handler:    _InstanceGroups_AddInstances_Handler,
		},
		{
			MethodName: "AggregatedList",
			Handler:    _InstanceGroups_AggregatedList_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _InstanceGroups_Delete_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _InstanceGroups_Get_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _InstanceGroups_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _InstanceGroups_List_Handler,
		},
		{
			MethodName: "ListInstances",
			Handler:    _InstanceGroups_ListInstances_Handler,
		},
		{
			MethodName: "RemoveInstances",
			Handler:    _InstanceGroups_RemoveInstances_Handler,
		},
		{
			MethodName: "SetNamedPorts",
			Handler:    _InstanceGroups_SetNamedPorts_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _InstanceGroups_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	InstanceSettingsService_Get_FullMethodName   = "/google.cloud.compute.v1beta.InstanceSettingsService/Get"
	InstanceSettingsService_Patch_FullMethodName = "/google.cloud.compute.v1beta.InstanceSettingsService/Patch"
)

// InstanceSettingsServiceClient is the client API for InstanceSettingsService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type InstanceSettingsServiceClient interface {
	// Get Instance settings.
	Get(ctx context.Context, in *GetInstanceSettingRequest, opts ...grpc.CallOption) (*InstanceSettings, error)
	// Patch Instance settings
	Patch(ctx context.Context, in *PatchInstanceSettingRequest, opts ...grpc.CallOption) (*Operation, error)
}

type instanceSettingsServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewInstanceSettingsServiceClient(cc grpc.ClientConnInterface) InstanceSettingsServiceClient {
	return &instanceSettingsServiceClient{cc}
}

func (c *instanceSettingsServiceClient) Get(ctx context.Context, in *GetInstanceSettingRequest, opts ...grpc.CallOption) (*InstanceSettings, error) {
	out := new(InstanceSettings)
	err := c.cc.Invoke(ctx, InstanceSettingsService_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceSettingsServiceClient) Patch(ctx context.Context, in *PatchInstanceSettingRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InstanceSettingsService_Patch_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// InstanceSettingsServiceServer is the server API for InstanceSettingsService service.
// All implementations should embed UnimplementedInstanceSettingsServiceServer
// for forward compatibility
type InstanceSettingsServiceServer interface {
	// Get Instance settings.
	Get(context.Context, *GetInstanceSettingRequest) (*InstanceSettings, error)
	// Patch Instance settings
	Patch(context.Context, *PatchInstanceSettingRequest) (*Operation, error)
}

// UnimplementedInstanceSettingsServiceServer should be embedded to have forward compatible implementations.
type UnimplementedInstanceSettingsServiceServer struct {
}

func (UnimplementedInstanceSettingsServiceServer) Get(context.Context, *GetInstanceSettingRequest) (*InstanceSettings, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedInstanceSettingsServiceServer) Patch(context.Context, *PatchInstanceSettingRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Patch not implemented")
}

// UnsafeInstanceSettingsServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to InstanceSettingsServiceServer will
// result in compilation errors.
type UnsafeInstanceSettingsServiceServer interface {
	mustEmbedUnimplementedInstanceSettingsServiceServer()
}

func RegisterInstanceSettingsServiceServer(s grpc.ServiceRegistrar, srv InstanceSettingsServiceServer) {
	s.RegisterService(&InstanceSettingsService_ServiceDesc, srv)
}

func _InstanceSettingsService_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstanceSettingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceSettingsServiceServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceSettingsService_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceSettingsServiceServer).Get(ctx, req.(*GetInstanceSettingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceSettingsService_Patch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchInstanceSettingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceSettingsServiceServer).Patch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceSettingsService_Patch_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceSettingsServiceServer).Patch(ctx, req.(*PatchInstanceSettingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// InstanceSettingsService_ServiceDesc is the grpc.ServiceDesc for InstanceSettingsService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var InstanceSettingsService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.InstanceSettingsService",
	HandlerType: (*InstanceSettingsServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _InstanceSettingsService_Get_Handler,
		},
		{
			MethodName: "Patch",
			Handler:    _InstanceSettingsService_Patch_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	InstanceTemplates_AggregatedList_FullMethodName     = "/google.cloud.compute.v1beta.InstanceTemplates/AggregatedList"
	InstanceTemplates_Delete_FullMethodName             = "/google.cloud.compute.v1beta.InstanceTemplates/Delete"
	InstanceTemplates_Get_FullMethodName                = "/google.cloud.compute.v1beta.InstanceTemplates/Get"
	InstanceTemplates_GetIamPolicy_FullMethodName       = "/google.cloud.compute.v1beta.InstanceTemplates/GetIamPolicy"
	InstanceTemplates_Insert_FullMethodName             = "/google.cloud.compute.v1beta.InstanceTemplates/Insert"
	InstanceTemplates_List_FullMethodName               = "/google.cloud.compute.v1beta.InstanceTemplates/List"
	InstanceTemplates_SetIamPolicy_FullMethodName       = "/google.cloud.compute.v1beta.InstanceTemplates/SetIamPolicy"
	InstanceTemplates_TestIamPermissions_FullMethodName = "/google.cloud.compute.v1beta.InstanceTemplates/TestIamPermissions"
)

// InstanceTemplatesClient is the client API for InstanceTemplates service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type InstanceTemplatesClient interface {
	// Retrieves the list of all InstanceTemplates resources, regional and global, available to the specified project. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(ctx context.Context, in *AggregatedListInstanceTemplatesRequest, opts ...grpc.CallOption) (*InstanceTemplateAggregatedList, error)
	// Deletes the specified instance template. Deleting an instance template is permanent and cannot be undone. It is not possible to delete templates that are already in use by a managed instance group.
	Delete(ctx context.Context, in *DeleteInstanceTemplateRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns the specified instance template.
	Get(ctx context.Context, in *GetInstanceTemplateRequest, opts ...grpc.CallOption) (*InstanceTemplate, error)
	// Gets the access control policy for a resource. May be empty if no such policy or resource exists.
	GetIamPolicy(ctx context.Context, in *GetIamPolicyInstanceTemplateRequest, opts ...grpc.CallOption) (*Policy, error)
	// Creates an instance template in the specified project using the data that is included in the request. If you are creating a new template to update an existing instance group, your new instance template must use the same network or, if applicable, the same subnetwork as the original template.
	Insert(ctx context.Context, in *InsertInstanceTemplateRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves a list of instance templates that are contained within the specified project.
	List(ctx context.Context, in *ListInstanceTemplatesRequest, opts ...grpc.CallOption) (*InstanceTemplateList, error)
	// Sets the access control policy on the specified resource. Replaces any existing policy.
	SetIamPolicy(ctx context.Context, in *SetIamPolicyInstanceTemplateRequest, opts ...grpc.CallOption) (*Policy, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(ctx context.Context, in *TestIamPermissionsInstanceTemplateRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error)
}

type instanceTemplatesClient struct {
	cc grpc.ClientConnInterface
}

func NewInstanceTemplatesClient(cc grpc.ClientConnInterface) InstanceTemplatesClient {
	return &instanceTemplatesClient{cc}
}

func (c *instanceTemplatesClient) AggregatedList(ctx context.Context, in *AggregatedListInstanceTemplatesRequest, opts ...grpc.CallOption) (*InstanceTemplateAggregatedList, error) {
	out := new(InstanceTemplateAggregatedList)
	err := c.cc.Invoke(ctx, InstanceTemplates_AggregatedList_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceTemplatesClient) Delete(ctx context.Context, in *DeleteInstanceTemplateRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InstanceTemplates_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceTemplatesClient) Get(ctx context.Context, in *GetInstanceTemplateRequest, opts ...grpc.CallOption) (*InstanceTemplate, error) {
	out := new(InstanceTemplate)
	err := c.cc.Invoke(ctx, InstanceTemplates_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceTemplatesClient) GetIamPolicy(ctx context.Context, in *GetIamPolicyInstanceTemplateRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, InstanceTemplates_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceTemplatesClient) Insert(ctx context.Context, in *InsertInstanceTemplateRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InstanceTemplates_Insert_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceTemplatesClient) List(ctx context.Context, in *ListInstanceTemplatesRequest, opts ...grpc.CallOption) (*InstanceTemplateList, error) {
	out := new(InstanceTemplateList)
	err := c.cc.Invoke(ctx, InstanceTemplates_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceTemplatesClient) SetIamPolicy(ctx context.Context, in *SetIamPolicyInstanceTemplateRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, InstanceTemplates_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instanceTemplatesClient) TestIamPermissions(ctx context.Context, in *TestIamPermissionsInstanceTemplateRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error) {
	out := new(TestPermissionsResponse)
	err := c.cc.Invoke(ctx, InstanceTemplates_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// InstanceTemplatesServer is the server API for InstanceTemplates service.
// All implementations should embed UnimplementedInstanceTemplatesServer
// for forward compatibility
type InstanceTemplatesServer interface {
	// Retrieves the list of all InstanceTemplates resources, regional and global, available to the specified project. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(context.Context, *AggregatedListInstanceTemplatesRequest) (*InstanceTemplateAggregatedList, error)
	// Deletes the specified instance template. Deleting an instance template is permanent and cannot be undone. It is not possible to delete templates that are already in use by a managed instance group.
	Delete(context.Context, *DeleteInstanceTemplateRequest) (*Operation, error)
	// Returns the specified instance template.
	Get(context.Context, *GetInstanceTemplateRequest) (*InstanceTemplate, error)
	// Gets the access control policy for a resource. May be empty if no such policy or resource exists.
	GetIamPolicy(context.Context, *GetIamPolicyInstanceTemplateRequest) (*Policy, error)
	// Creates an instance template in the specified project using the data that is included in the request. If you are creating a new template to update an existing instance group, your new instance template must use the same network or, if applicable, the same subnetwork as the original template.
	Insert(context.Context, *InsertInstanceTemplateRequest) (*Operation, error)
	// Retrieves a list of instance templates that are contained within the specified project.
	List(context.Context, *ListInstanceTemplatesRequest) (*InstanceTemplateList, error)
	// Sets the access control policy on the specified resource. Replaces any existing policy.
	SetIamPolicy(context.Context, *SetIamPolicyInstanceTemplateRequest) (*Policy, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(context.Context, *TestIamPermissionsInstanceTemplateRequest) (*TestPermissionsResponse, error)
}

// UnimplementedInstanceTemplatesServer should be embedded to have forward compatible implementations.
type UnimplementedInstanceTemplatesServer struct {
}

func (UnimplementedInstanceTemplatesServer) AggregatedList(context.Context, *AggregatedListInstanceTemplatesRequest) (*InstanceTemplateAggregatedList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AggregatedList not implemented")
}
func (UnimplementedInstanceTemplatesServer) Delete(context.Context, *DeleteInstanceTemplateRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedInstanceTemplatesServer) Get(context.Context, *GetInstanceTemplateRequest) (*InstanceTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedInstanceTemplatesServer) GetIamPolicy(context.Context, *GetIamPolicyInstanceTemplateRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedInstanceTemplatesServer) Insert(context.Context, *InsertInstanceTemplateRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (UnimplementedInstanceTemplatesServer) List(context.Context, *ListInstanceTemplatesRequest) (*InstanceTemplateList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedInstanceTemplatesServer) SetIamPolicy(context.Context, *SetIamPolicyInstanceTemplateRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedInstanceTemplatesServer) TestIamPermissions(context.Context, *TestIamPermissionsInstanceTemplateRequest) (*TestPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

// UnsafeInstanceTemplatesServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to InstanceTemplatesServer will
// result in compilation errors.
type UnsafeInstanceTemplatesServer interface {
	mustEmbedUnimplementedInstanceTemplatesServer()
}

func RegisterInstanceTemplatesServer(s grpc.ServiceRegistrar, srv InstanceTemplatesServer) {
	s.RegisterService(&InstanceTemplates_ServiceDesc, srv)
}

func _InstanceTemplates_AggregatedList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AggregatedListInstanceTemplatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceTemplatesServer).AggregatedList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceTemplates_AggregatedList_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceTemplatesServer).AggregatedList(ctx, req.(*AggregatedListInstanceTemplatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceTemplates_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInstanceTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceTemplatesServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceTemplates_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceTemplatesServer).Delete(ctx, req.(*DeleteInstanceTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceTemplates_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstanceTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceTemplatesServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceTemplates_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceTemplatesServer).Get(ctx, req.(*GetInstanceTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceTemplates_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIamPolicyInstanceTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceTemplatesServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceTemplates_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceTemplatesServer).GetIamPolicy(ctx, req.(*GetIamPolicyInstanceTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceTemplates_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertInstanceTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceTemplatesServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceTemplates_Insert_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceTemplatesServer).Insert(ctx, req.(*InsertInstanceTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceTemplates_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstanceTemplatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceTemplatesServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceTemplates_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceTemplatesServer).List(ctx, req.(*ListInstanceTemplatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceTemplates_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetIamPolicyInstanceTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceTemplatesServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceTemplates_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceTemplatesServer).SetIamPolicy(ctx, req.(*SetIamPolicyInstanceTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstanceTemplates_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TestIamPermissionsInstanceTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstanceTemplatesServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstanceTemplates_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstanceTemplatesServer).TestIamPermissions(ctx, req.(*TestIamPermissionsInstanceTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// InstanceTemplates_ServiceDesc is the grpc.ServiceDesc for InstanceTemplates service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var InstanceTemplates_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.InstanceTemplates",
	HandlerType: (*InstanceTemplatesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AggregatedList",
			Handler:    _InstanceTemplates_AggregatedList_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _InstanceTemplates_Delete_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _InstanceTemplates_Get_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _InstanceTemplates_GetIamPolicy_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _InstanceTemplates_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _InstanceTemplates_List_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _InstanceTemplates_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _InstanceTemplates_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	Instances_AddAccessConfig_FullMethodName                    = "/google.cloud.compute.v1beta.Instances/AddAccessConfig"
	Instances_AddNetworkInterface_FullMethodName                = "/google.cloud.compute.v1beta.Instances/AddNetworkInterface"
	Instances_AddResourcePolicies_FullMethodName                = "/google.cloud.compute.v1beta.Instances/AddResourcePolicies"
	Instances_AggregatedList_FullMethodName                     = "/google.cloud.compute.v1beta.Instances/AggregatedList"
	Instances_AttachDisk_FullMethodName                         = "/google.cloud.compute.v1beta.Instances/AttachDisk"
	Instances_BulkInsert_FullMethodName                         = "/google.cloud.compute.v1beta.Instances/BulkInsert"
	Instances_Delete_FullMethodName                             = "/google.cloud.compute.v1beta.Instances/Delete"
	Instances_DeleteAccessConfig_FullMethodName                 = "/google.cloud.compute.v1beta.Instances/DeleteAccessConfig"
	Instances_DeleteNetworkInterface_FullMethodName             = "/google.cloud.compute.v1beta.Instances/DeleteNetworkInterface"
	Instances_DetachDisk_FullMethodName                         = "/google.cloud.compute.v1beta.Instances/DetachDisk"
	Instances_Get_FullMethodName                                = "/google.cloud.compute.v1beta.Instances/Get"
	Instances_GetEffectiveFirewalls_FullMethodName              = "/google.cloud.compute.v1beta.Instances/GetEffectiveFirewalls"
	Instances_GetGuestAttributes_FullMethodName                 = "/google.cloud.compute.v1beta.Instances/GetGuestAttributes"
	Instances_GetIamPolicy_FullMethodName                       = "/google.cloud.compute.v1beta.Instances/GetIamPolicy"
	Instances_GetPartnerMetadata_FullMethodName                 = "/google.cloud.compute.v1beta.Instances/GetPartnerMetadata"
	Instances_GetScreenshot_FullMethodName                      = "/google.cloud.compute.v1beta.Instances/GetScreenshot"
	Instances_GetSerialPortOutput_FullMethodName                = "/google.cloud.compute.v1beta.Instances/GetSerialPortOutput"
	Instances_GetShieldedInstanceIdentity_FullMethodName        = "/google.cloud.compute.v1beta.Instances/GetShieldedInstanceIdentity"
	Instances_GetShieldedVmIdentity_FullMethodName              = "/google.cloud.compute.v1beta.Instances/GetShieldedVmIdentity"
	Instances_Insert_FullMethodName                             = "/google.cloud.compute.v1beta.Instances/Insert"
	Instances_List_FullMethodName                               = "/google.cloud.compute.v1beta.Instances/List"
	Instances_ListReferrers_FullMethodName                      = "/google.cloud.compute.v1beta.Instances/ListReferrers"
	Instances_PatchPartnerMetadata_FullMethodName               = "/google.cloud.compute.v1beta.Instances/PatchPartnerMetadata"
	Instances_PerformMaintenance_FullMethodName                 = "/google.cloud.compute.v1beta.Instances/PerformMaintenance"
	Instances_RemoveResourcePolicies_FullMethodName             = "/google.cloud.compute.v1beta.Instances/RemoveResourcePolicies"
	Instances_ReportHostAsFaulty_FullMethodName                 = "/google.cloud.compute.v1beta.Instances/ReportHostAsFaulty"
	Instances_Reset_FullMethodName                              = "/google.cloud.compute.v1beta.Instances/Reset"
	Instances_Resume_FullMethodName                             = "/google.cloud.compute.v1beta.Instances/Resume"
	Instances_SendDiagnosticInterrupt_FullMethodName            = "/google.cloud.compute.v1beta.Instances/SendDiagnosticInterrupt"
	Instances_SetDeletionProtection_FullMethodName              = "/google.cloud.compute.v1beta.Instances/SetDeletionProtection"
	Instances_SetDiskAutoDelete_FullMethodName                  = "/google.cloud.compute.v1beta.Instances/SetDiskAutoDelete"
	Instances_SetIamPolicy_FullMethodName                       = "/google.cloud.compute.v1beta.Instances/SetIamPolicy"
	Instances_SetLabels_FullMethodName                          = "/google.cloud.compute.v1beta.Instances/SetLabels"
	Instances_SetMachineResources_FullMethodName                = "/google.cloud.compute.v1beta.Instances/SetMachineResources"
	Instances_SetMachineType_FullMethodName                     = "/google.cloud.compute.v1beta.Instances/SetMachineType"
	Instances_SetMetadata_FullMethodName                        = "/google.cloud.compute.v1beta.Instances/SetMetadata"
	Instances_SetMinCpuPlatform_FullMethodName                  = "/google.cloud.compute.v1beta.Instances/SetMinCpuPlatform"
	Instances_SetName_FullMethodName                            = "/google.cloud.compute.v1beta.Instances/SetName"
	Instances_SetScheduling_FullMethodName                      = "/google.cloud.compute.v1beta.Instances/SetScheduling"
	Instances_SetSecurityPolicy_FullMethodName                  = "/google.cloud.compute.v1beta.Instances/SetSecurityPolicy"
	Instances_SetServiceAccount_FullMethodName                  = "/google.cloud.compute.v1beta.Instances/SetServiceAccount"
	Instances_SetShieldedInstanceIntegrityPolicy_FullMethodName = "/google.cloud.compute.v1beta.Instances/SetShieldedInstanceIntegrityPolicy"
	Instances_SetShieldedVmIntegrityPolicy_FullMethodName       = "/google.cloud.compute.v1beta.Instances/SetShieldedVmIntegrityPolicy"
	Instances_SetTags_FullMethodName                            = "/google.cloud.compute.v1beta.Instances/SetTags"
	Instances_SimulateMaintenanceEvent_FullMethodName           = "/google.cloud.compute.v1beta.Instances/SimulateMaintenanceEvent"
	Instances_Start_FullMethodName                              = "/google.cloud.compute.v1beta.Instances/Start"
	Instances_StartWithEncryptionKey_FullMethodName             = "/google.cloud.compute.v1beta.Instances/StartWithEncryptionKey"
	Instances_Stop_FullMethodName                               = "/google.cloud.compute.v1beta.Instances/Stop"
	Instances_Suspend_FullMethodName                            = "/google.cloud.compute.v1beta.Instances/Suspend"
	Instances_TestIamPermissions_FullMethodName                 = "/google.cloud.compute.v1beta.Instances/TestIamPermissions"
	Instances_Update_FullMethodName                             = "/google.cloud.compute.v1beta.Instances/Update"
	Instances_UpdateAccessConfig_FullMethodName                 = "/google.cloud.compute.v1beta.Instances/UpdateAccessConfig"
	Instances_UpdateDisplayDevice_FullMethodName                = "/google.cloud.compute.v1beta.Instances/UpdateDisplayDevice"
	Instances_UpdateNetworkInterface_FullMethodName             = "/google.cloud.compute.v1beta.Instances/UpdateNetworkInterface"
	Instances_UpdateShieldedInstanceConfig_FullMethodName       = "/google.cloud.compute.v1beta.Instances/UpdateShieldedInstanceConfig"
	Instances_UpdateShieldedVmConfig_FullMethodName             = "/google.cloud.compute.v1beta.Instances/UpdateShieldedVmConfig"
)

// InstancesClient is the client API for Instances service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type InstancesClient interface {
	// Adds an access config to an instance's network interface.
	AddAccessConfig(ctx context.Context, in *AddAccessConfigInstanceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Adds one dynamic network interface to an active instance.
	AddNetworkInterface(ctx context.Context, in *AddNetworkInterfaceInstanceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Adds existing resource policies to an instance. You can only add one policy right now which will be applied to this instance for scheduling live migrations.
	AddResourcePolicies(ctx context.Context, in *AddResourcePoliciesInstanceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves an aggregated list of all of the instances in your project across all regions and zones. The performance of this method degrades when a filter is specified on a project that has a very large number of instances. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(ctx context.Context, in *AggregatedListInstancesRequest, opts ...grpc.CallOption) (*InstanceAggregatedList, error)
	// Attaches an existing Disk resource to an instance. You must first create the disk before you can attach it. It is not possible to create and attach a disk at the same time. For more information, read Adding a persistent disk to your instance.
	AttachDisk(ctx context.Context, in *AttachDiskInstanceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Creates multiple instances. Count specifies the number of instances to create. For more information, see About bulk creation of VMs.
	BulkInsert(ctx context.Context, in *BulkInsertInstanceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Deletes the specified Instance resource. For more information, see Deleting an instance.
	Delete(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Deletes an access config from an instance's network interface.
	DeleteAccessConfig(ctx context.Context, in *DeleteAccessConfigInstanceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Deletes one dynamic network interface from an active instance. InstancesDeleteNetworkInterfaceRequest indicates: - instance from which to delete, using project+zone+resource_id fields; - dynamic network interface to be deleted, using network_interface_name field;
	DeleteNetworkInterface(ctx context.Context, in *DeleteNetworkInterfaceInstanceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Detaches a disk from an instance.
	DetachDisk(ctx context.Context, in *DetachDiskInstanceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns the specified Instance resource.
	Get(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error)
	// Returns effective firewalls applied to an interface of the instance.
	GetEffectiveFirewalls(ctx context.Context, in *GetEffectiveFirewallsInstanceRequest, opts ...grpc.CallOption) (*InstancesGetEffectiveFirewallsResponse, error)
	// Returns the specified guest attributes entry.
	GetGuestAttributes(ctx context.Context, in *GetGuestAttributesInstanceRequest, opts ...grpc.CallOption) (*GuestAttributes, error)
	// Gets the access control policy for a resource. May be empty if no such policy or resource exists.
	GetIamPolicy(ctx context.Context, in *GetIamPolicyInstanceRequest, opts ...grpc.CallOption) (*Policy, error)
	// Gets partner metadata of the specified instance and namespaces.
	GetPartnerMetadata(ctx context.Context, in *GetPartnerMetadataInstanceRequest, opts ...grpc.CallOption) (*PartnerMetadata, error)
	// Returns the screenshot from the specified instance.
	GetScreenshot(ctx context.Context, in *GetScreenshotInstanceRequest, opts ...grpc.CallOption) (*Screenshot, error)
	// Returns the last 1 MB of serial port output from the specified instance.
	GetSerialPortOutput(ctx context.Context, in *GetSerialPortOutputInstanceRequest, opts ...grpc.CallOption) (*SerialPortOutput, error)
	// Returns the Shielded Instance Identity of an instance
	GetShieldedInstanceIdentity(ctx context.Context, in *GetShieldedInstanceIdentityInstanceRequest, opts ...grpc.CallOption) (*ShieldedInstanceIdentity, error)
	// Returns the Shielded VM Identity of an instance
	GetShieldedVmIdentity(ctx context.Context, in *GetShieldedVmIdentityInstanceRequest, opts ...grpc.CallOption) (*ShieldedVmIdentity, error)
	// Creates an instance resource in the specified project using the data included in the request.
	Insert(ctx context.Context, in *InsertInstanceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves the list of instances contained within the specified zone.
	List(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*InstanceList, error)
	// Retrieves a list of resources that refer to the VM instance specified in the request. For example, if the VM instance is part of a managed or unmanaged instance group, the referrers list includes the instance group. For more information, read Viewing referrers to VM instances.
	ListReferrers(ctx context.Context, in *ListReferrersInstancesRequest, opts ...grpc.CallOption) (*InstanceListReferrers, error)
	// Patches partner metadata of the specified instance.
	PatchPartnerMetadata(ctx context.Context, in *PatchPartnerMetadataInstanceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Perform a manual maintenance on the instance.
	PerformMaintenance(ctx context.Context, in *PerformMaintenanceInstanceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Removes resource policies from an instance.
	RemoveResourcePolicies(ctx context.Context, in *RemoveResourcePoliciesInstanceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Mark the host as faulty and try to restart the instance on a new host.
	ReportHostAsFaulty(ctx context.Context, in *ReportHostAsFaultyInstanceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Performs a reset on the instance. This is a hard reset. The VM does not do a graceful shutdown. For more information, see Resetting an instance.
	Reset(ctx context.Context, in *ResetInstanceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Resumes an instance that was suspended using the instances().suspend method.
	Resume(ctx context.Context, in *ResumeInstanceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sends diagnostic interrupt to the instance.
	SendDiagnosticInterrupt(ctx context.Context, in *SendDiagnosticInterruptInstanceRequest, opts ...grpc.CallOption) (*SendDiagnosticInterruptInstanceResponse, error)
	// Sets deletion protection on the instance.
	SetDeletionProtection(ctx context.Context, in *SetDeletionProtectionInstanceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the auto-delete flag for a disk attached to an instance.
	SetDiskAutoDelete(ctx context.Context, in *SetDiskAutoDeleteInstanceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the access control policy on the specified resource. Replaces any existing policy.
	SetIamPolicy(ctx context.Context, in *SetIamPolicyInstanceRequest, opts ...grpc.CallOption) (*Policy, error)
	// Sets labels on an instance. To learn more about labels, read the Labeling Resources documentation.
	SetLabels(ctx context.Context, in *SetLabelsInstanceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Changes the number and/or type of accelerator for a stopped instance to the values specified in the request.
	SetMachineResources(ctx context.Context, in *SetMachineResourcesInstanceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Changes the machine type for a stopped instance to the machine type specified in the request.
	SetMachineType(ctx context.Context, in *SetMachineTypeInstanceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets metadata for the specified instance to the data included in the request.
	SetMetadata(ctx context.Context, in *SetMetadataInstanceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Changes the minimum CPU platform that this instance should use. This method can only be called on a stopped instance. For more information, read Specifying a Minimum CPU Platform.
	SetMinCpuPlatform(ctx context.Context, in *SetMinCpuPlatformInstanceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets name of an instance.
	SetName(ctx context.Context, in *SetNameInstanceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets an instance's scheduling options. You can only call this method on a stopped instance, that is, a VM instance that is in a `TERMINATED` state. See Instance Life Cycle for more information on the possible instance states. For more information about setting scheduling options for a VM, see Set VM host maintenance policy.
	SetScheduling(ctx context.Context, in *SetSchedulingInstanceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the Google Cloud Armor security policy for the specified instance. For more information, see Google Cloud Armor Overview
	SetSecurityPolicy(ctx context.Context, in *SetSecurityPolicyInstanceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the service account on the instance. For more information, read Changing the service account and access scopes for an instance.
	SetServiceAccount(ctx context.Context, in *SetServiceAccountInstanceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the Shielded Instance integrity policy for an instance. You can only use this method on a running instance. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
	SetShieldedInstanceIntegrityPolicy(ctx context.Context, in *SetShieldedInstanceIntegrityPolicyInstanceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the Shielded VM integrity policy for a VM instance. You can only use this method on a running VM instance. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
	SetShieldedVmIntegrityPolicy(ctx context.Context, in *SetShieldedVmIntegrityPolicyInstanceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets network tags for the specified instance to the data included in the request.
	SetTags(ctx context.Context, in *SetTagsInstanceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Simulates a host maintenance event on a VM. For more information, see Simulate a host maintenance event.
	SimulateMaintenanceEvent(ctx context.Context, in *SimulateMaintenanceEventInstanceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Starts an instance that was stopped using the instances().stop method. For more information, see Restart an instance.
	Start(ctx context.Context, in *StartInstanceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Starts an instance that was stopped using the instances().stop method. For more information, see Restart an instance.
	StartWithEncryptionKey(ctx context.Context, in *StartWithEncryptionKeyInstanceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Stops a running instance, shutting it down cleanly, and allows you to restart the instance at a later time. Stopped instances do not incur VM usage charges while they are stopped. However, resources that the VM is using, such as persistent disks and static IP addresses, will continue to be charged until they are deleted. For more information, see Stopping an instance.
	Stop(ctx context.Context, in *StopInstanceRequest, opts ...grpc.CallOption) (*Operation, error)
	// This method suspends a running instance, saving its state to persistent storage, and allows you to resume the instance at a later time. Suspended instances have no compute costs (cores or RAM), and incur only storage charges for the saved VM memory and localSSD data. Any charged resources the virtual machine was using, such as persistent disks and static IP addresses, will continue to be charged while the instance is suspended. For more information, see Suspending and resuming an instance.
	Suspend(ctx context.Context, in *SuspendInstanceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(ctx context.Context, in *TestIamPermissionsInstanceRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error)
	// Updates an instance only if the necessary resources are available. This method can update only a specific set of instance properties. See Updating a running instance for a list of updatable instance properties.
	Update(ctx context.Context, in *UpdateInstanceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Updates the specified access config from an instance's network interface with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
	UpdateAccessConfig(ctx context.Context, in *UpdateAccessConfigInstanceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Updates the Display config for a VM instance. You can only use this method on a stopped VM instance. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
	UpdateDisplayDevice(ctx context.Context, in *UpdateDisplayDeviceInstanceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Updates an instance's network interface. This method can only update an interface's alias IP range and attached network. See Modifying alias IP ranges for an existing instance for instructions on changing alias IP ranges. See Migrating a VM between networks for instructions on migrating an interface. This method follows PATCH semantics.
	UpdateNetworkInterface(ctx context.Context, in *UpdateNetworkInterfaceInstanceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Updates the Shielded Instance config for an instance. You can only use this method on a stopped instance. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
	UpdateShieldedInstanceConfig(ctx context.Context, in *UpdateShieldedInstanceConfigInstanceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Updates the Shielded VM config for a VM instance. You can only use this method on a stopped VM instance. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
	UpdateShieldedVmConfig(ctx context.Context, in *UpdateShieldedVmConfigInstanceRequest, opts ...grpc.CallOption) (*Operation, error)
}

type instancesClient struct {
	cc grpc.ClientConnInterface
}

func NewInstancesClient(cc grpc.ClientConnInterface) InstancesClient {
	return &instancesClient{cc}
}

func (c *instancesClient) AddAccessConfig(ctx context.Context, in *AddAccessConfigInstanceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Instances_AddAccessConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) AddNetworkInterface(ctx context.Context, in *AddNetworkInterfaceInstanceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Instances_AddNetworkInterface_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) AddResourcePolicies(ctx context.Context, in *AddResourcePoliciesInstanceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Instances_AddResourcePolicies_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) AggregatedList(ctx context.Context, in *AggregatedListInstancesRequest, opts ...grpc.CallOption) (*InstanceAggregatedList, error) {
	out := new(InstanceAggregatedList)
	err := c.cc.Invoke(ctx, Instances_AggregatedList_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) AttachDisk(ctx context.Context, in *AttachDiskInstanceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Instances_AttachDisk_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) BulkInsert(ctx context.Context, in *BulkInsertInstanceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Instances_BulkInsert_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) Delete(ctx context.Context, in *DeleteInstanceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Instances_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) DeleteAccessConfig(ctx context.Context, in *DeleteAccessConfigInstanceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Instances_DeleteAccessConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) DeleteNetworkInterface(ctx context.Context, in *DeleteNetworkInterfaceInstanceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Instances_DeleteNetworkInterface_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) DetachDisk(ctx context.Context, in *DetachDiskInstanceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Instances_DetachDisk_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) Get(ctx context.Context, in *GetInstanceRequest, opts ...grpc.CallOption) (*Instance, error) {
	out := new(Instance)
	err := c.cc.Invoke(ctx, Instances_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) GetEffectiveFirewalls(ctx context.Context, in *GetEffectiveFirewallsInstanceRequest, opts ...grpc.CallOption) (*InstancesGetEffectiveFirewallsResponse, error) {
	out := new(InstancesGetEffectiveFirewallsResponse)
	err := c.cc.Invoke(ctx, Instances_GetEffectiveFirewalls_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) GetGuestAttributes(ctx context.Context, in *GetGuestAttributesInstanceRequest, opts ...grpc.CallOption) (*GuestAttributes, error) {
	out := new(GuestAttributes)
	err := c.cc.Invoke(ctx, Instances_GetGuestAttributes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) GetIamPolicy(ctx context.Context, in *GetIamPolicyInstanceRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, Instances_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) GetPartnerMetadata(ctx context.Context, in *GetPartnerMetadataInstanceRequest, opts ...grpc.CallOption) (*PartnerMetadata, error) {
	out := new(PartnerMetadata)
	err := c.cc.Invoke(ctx, Instances_GetPartnerMetadata_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) GetScreenshot(ctx context.Context, in *GetScreenshotInstanceRequest, opts ...grpc.CallOption) (*Screenshot, error) {
	out := new(Screenshot)
	err := c.cc.Invoke(ctx, Instances_GetScreenshot_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) GetSerialPortOutput(ctx context.Context, in *GetSerialPortOutputInstanceRequest, opts ...grpc.CallOption) (*SerialPortOutput, error) {
	out := new(SerialPortOutput)
	err := c.cc.Invoke(ctx, Instances_GetSerialPortOutput_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) GetShieldedInstanceIdentity(ctx context.Context, in *GetShieldedInstanceIdentityInstanceRequest, opts ...grpc.CallOption) (*ShieldedInstanceIdentity, error) {
	out := new(ShieldedInstanceIdentity)
	err := c.cc.Invoke(ctx, Instances_GetShieldedInstanceIdentity_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) GetShieldedVmIdentity(ctx context.Context, in *GetShieldedVmIdentityInstanceRequest, opts ...grpc.CallOption) (*ShieldedVmIdentity, error) {
	out := new(ShieldedVmIdentity)
	err := c.cc.Invoke(ctx, Instances_GetShieldedVmIdentity_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) Insert(ctx context.Context, in *InsertInstanceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Instances_Insert_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) List(ctx context.Context, in *ListInstancesRequest, opts ...grpc.CallOption) (*InstanceList, error) {
	out := new(InstanceList)
	err := c.cc.Invoke(ctx, Instances_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) ListReferrers(ctx context.Context, in *ListReferrersInstancesRequest, opts ...grpc.CallOption) (*InstanceListReferrers, error) {
	out := new(InstanceListReferrers)
	err := c.cc.Invoke(ctx, Instances_ListReferrers_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) PatchPartnerMetadata(ctx context.Context, in *PatchPartnerMetadataInstanceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Instances_PatchPartnerMetadata_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) PerformMaintenance(ctx context.Context, in *PerformMaintenanceInstanceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Instances_PerformMaintenance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) RemoveResourcePolicies(ctx context.Context, in *RemoveResourcePoliciesInstanceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Instances_RemoveResourcePolicies_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) ReportHostAsFaulty(ctx context.Context, in *ReportHostAsFaultyInstanceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Instances_ReportHostAsFaulty_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) Reset(ctx context.Context, in *ResetInstanceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Instances_Reset_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) Resume(ctx context.Context, in *ResumeInstanceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Instances_Resume_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) SendDiagnosticInterrupt(ctx context.Context, in *SendDiagnosticInterruptInstanceRequest, opts ...grpc.CallOption) (*SendDiagnosticInterruptInstanceResponse, error) {
	out := new(SendDiagnosticInterruptInstanceResponse)
	err := c.cc.Invoke(ctx, Instances_SendDiagnosticInterrupt_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) SetDeletionProtection(ctx context.Context, in *SetDeletionProtectionInstanceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Instances_SetDeletionProtection_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) SetDiskAutoDelete(ctx context.Context, in *SetDiskAutoDeleteInstanceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Instances_SetDiskAutoDelete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) SetIamPolicy(ctx context.Context, in *SetIamPolicyInstanceRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, Instances_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) SetLabels(ctx context.Context, in *SetLabelsInstanceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Instances_SetLabels_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) SetMachineResources(ctx context.Context, in *SetMachineResourcesInstanceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Instances_SetMachineResources_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) SetMachineType(ctx context.Context, in *SetMachineTypeInstanceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Instances_SetMachineType_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) SetMetadata(ctx context.Context, in *SetMetadataInstanceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Instances_SetMetadata_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) SetMinCpuPlatform(ctx context.Context, in *SetMinCpuPlatformInstanceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Instances_SetMinCpuPlatform_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) SetName(ctx context.Context, in *SetNameInstanceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Instances_SetName_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) SetScheduling(ctx context.Context, in *SetSchedulingInstanceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Instances_SetScheduling_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) SetSecurityPolicy(ctx context.Context, in *SetSecurityPolicyInstanceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Instances_SetSecurityPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) SetServiceAccount(ctx context.Context, in *SetServiceAccountInstanceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Instances_SetServiceAccount_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) SetShieldedInstanceIntegrityPolicy(ctx context.Context, in *SetShieldedInstanceIntegrityPolicyInstanceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Instances_SetShieldedInstanceIntegrityPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) SetShieldedVmIntegrityPolicy(ctx context.Context, in *SetShieldedVmIntegrityPolicyInstanceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Instances_SetShieldedVmIntegrityPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) SetTags(ctx context.Context, in *SetTagsInstanceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Instances_SetTags_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) SimulateMaintenanceEvent(ctx context.Context, in *SimulateMaintenanceEventInstanceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Instances_SimulateMaintenanceEvent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) Start(ctx context.Context, in *StartInstanceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Instances_Start_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) StartWithEncryptionKey(ctx context.Context, in *StartWithEncryptionKeyInstanceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Instances_StartWithEncryptionKey_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) Stop(ctx context.Context, in *StopInstanceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Instances_Stop_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) Suspend(ctx context.Context, in *SuspendInstanceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Instances_Suspend_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) TestIamPermissions(ctx context.Context, in *TestIamPermissionsInstanceRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error) {
	out := new(TestPermissionsResponse)
	err := c.cc.Invoke(ctx, Instances_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) Update(ctx context.Context, in *UpdateInstanceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Instances_Update_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) UpdateAccessConfig(ctx context.Context, in *UpdateAccessConfigInstanceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Instances_UpdateAccessConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) UpdateDisplayDevice(ctx context.Context, in *UpdateDisplayDeviceInstanceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Instances_UpdateDisplayDevice_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) UpdateNetworkInterface(ctx context.Context, in *UpdateNetworkInterfaceInstanceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Instances_UpdateNetworkInterface_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) UpdateShieldedInstanceConfig(ctx context.Context, in *UpdateShieldedInstanceConfigInstanceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Instances_UpdateShieldedInstanceConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instancesClient) UpdateShieldedVmConfig(ctx context.Context, in *UpdateShieldedVmConfigInstanceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Instances_UpdateShieldedVmConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// InstancesServer is the server API for Instances service.
// All implementations should embed UnimplementedInstancesServer
// for forward compatibility
type InstancesServer interface {
	// Adds an access config to an instance's network interface.
	AddAccessConfig(context.Context, *AddAccessConfigInstanceRequest) (*Operation, error)
	// Adds one dynamic network interface to an active instance.
	AddNetworkInterface(context.Context, *AddNetworkInterfaceInstanceRequest) (*Operation, error)
	// Adds existing resource policies to an instance. You can only add one policy right now which will be applied to this instance for scheduling live migrations.
	AddResourcePolicies(context.Context, *AddResourcePoliciesInstanceRequest) (*Operation, error)
	// Retrieves an aggregated list of all of the instances in your project across all regions and zones. The performance of this method degrades when a filter is specified on a project that has a very large number of instances. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(context.Context, *AggregatedListInstancesRequest) (*InstanceAggregatedList, error)
	// Attaches an existing Disk resource to an instance. You must first create the disk before you can attach it. It is not possible to create and attach a disk at the same time. For more information, read Adding a persistent disk to your instance.
	AttachDisk(context.Context, *AttachDiskInstanceRequest) (*Operation, error)
	// Creates multiple instances. Count specifies the number of instances to create. For more information, see About bulk creation of VMs.
	BulkInsert(context.Context, *BulkInsertInstanceRequest) (*Operation, error)
	// Deletes the specified Instance resource. For more information, see Deleting an instance.
	Delete(context.Context, *DeleteInstanceRequest) (*Operation, error)
	// Deletes an access config from an instance's network interface.
	DeleteAccessConfig(context.Context, *DeleteAccessConfigInstanceRequest) (*Operation, error)
	// Deletes one dynamic network interface from an active instance. InstancesDeleteNetworkInterfaceRequest indicates: - instance from which to delete, using project+zone+resource_id fields; - dynamic network interface to be deleted, using network_interface_name field;
	DeleteNetworkInterface(context.Context, *DeleteNetworkInterfaceInstanceRequest) (*Operation, error)
	// Detaches a disk from an instance.
	DetachDisk(context.Context, *DetachDiskInstanceRequest) (*Operation, error)
	// Returns the specified Instance resource.
	Get(context.Context, *GetInstanceRequest) (*Instance, error)
	// Returns effective firewalls applied to an interface of the instance.
	GetEffectiveFirewalls(context.Context, *GetEffectiveFirewallsInstanceRequest) (*InstancesGetEffectiveFirewallsResponse, error)
	// Returns the specified guest attributes entry.
	GetGuestAttributes(context.Context, *GetGuestAttributesInstanceRequest) (*GuestAttributes, error)
	// Gets the access control policy for a resource. May be empty if no such policy or resource exists.
	GetIamPolicy(context.Context, *GetIamPolicyInstanceRequest) (*Policy, error)
	// Gets partner metadata of the specified instance and namespaces.
	GetPartnerMetadata(context.Context, *GetPartnerMetadataInstanceRequest) (*PartnerMetadata, error)
	// Returns the screenshot from the specified instance.
	GetScreenshot(context.Context, *GetScreenshotInstanceRequest) (*Screenshot, error)
	// Returns the last 1 MB of serial port output from the specified instance.
	GetSerialPortOutput(context.Context, *GetSerialPortOutputInstanceRequest) (*SerialPortOutput, error)
	// Returns the Shielded Instance Identity of an instance
	GetShieldedInstanceIdentity(context.Context, *GetShieldedInstanceIdentityInstanceRequest) (*ShieldedInstanceIdentity, error)
	// Returns the Shielded VM Identity of an instance
	GetShieldedVmIdentity(context.Context, *GetShieldedVmIdentityInstanceRequest) (*ShieldedVmIdentity, error)
	// Creates an instance resource in the specified project using the data included in the request.
	Insert(context.Context, *InsertInstanceRequest) (*Operation, error)
	// Retrieves the list of instances contained within the specified zone.
	List(context.Context, *ListInstancesRequest) (*InstanceList, error)
	// Retrieves a list of resources that refer to the VM instance specified in the request. For example, if the VM instance is part of a managed or unmanaged instance group, the referrers list includes the instance group. For more information, read Viewing referrers to VM instances.
	ListReferrers(context.Context, *ListReferrersInstancesRequest) (*InstanceListReferrers, error)
	// Patches partner metadata of the specified instance.
	PatchPartnerMetadata(context.Context, *PatchPartnerMetadataInstanceRequest) (*Operation, error)
	// Perform a manual maintenance on the instance.
	PerformMaintenance(context.Context, *PerformMaintenanceInstanceRequest) (*Operation, error)
	// Removes resource policies from an instance.
	RemoveResourcePolicies(context.Context, *RemoveResourcePoliciesInstanceRequest) (*Operation, error)
	// Mark the host as faulty and try to restart the instance on a new host.
	ReportHostAsFaulty(context.Context, *ReportHostAsFaultyInstanceRequest) (*Operation, error)
	// Performs a reset on the instance. This is a hard reset. The VM does not do a graceful shutdown. For more information, see Resetting an instance.
	Reset(context.Context, *ResetInstanceRequest) (*Operation, error)
	// Resumes an instance that was suspended using the instances().suspend method.
	Resume(context.Context, *ResumeInstanceRequest) (*Operation, error)
	// Sends diagnostic interrupt to the instance.
	SendDiagnosticInterrupt(context.Context, *SendDiagnosticInterruptInstanceRequest) (*SendDiagnosticInterruptInstanceResponse, error)
	// Sets deletion protection on the instance.
	SetDeletionProtection(context.Context, *SetDeletionProtectionInstanceRequest) (*Operation, error)
	// Sets the auto-delete flag for a disk attached to an instance.
	SetDiskAutoDelete(context.Context, *SetDiskAutoDeleteInstanceRequest) (*Operation, error)
	// Sets the access control policy on the specified resource. Replaces any existing policy.
	SetIamPolicy(context.Context, *SetIamPolicyInstanceRequest) (*Policy, error)
	// Sets labels on an instance. To learn more about labels, read the Labeling Resources documentation.
	SetLabels(context.Context, *SetLabelsInstanceRequest) (*Operation, error)
	// Changes the number and/or type of accelerator for a stopped instance to the values specified in the request.
	SetMachineResources(context.Context, *SetMachineResourcesInstanceRequest) (*Operation, error)
	// Changes the machine type for a stopped instance to the machine type specified in the request.
	SetMachineType(context.Context, *SetMachineTypeInstanceRequest) (*Operation, error)
	// Sets metadata for the specified instance to the data included in the request.
	SetMetadata(context.Context, *SetMetadataInstanceRequest) (*Operation, error)
	// Changes the minimum CPU platform that this instance should use. This method can only be called on a stopped instance. For more information, read Specifying a Minimum CPU Platform.
	SetMinCpuPlatform(context.Context, *SetMinCpuPlatformInstanceRequest) (*Operation, error)
	// Sets name of an instance.
	SetName(context.Context, *SetNameInstanceRequest) (*Operation, error)
	// Sets an instance's scheduling options. You can only call this method on a stopped instance, that is, a VM instance that is in a `TERMINATED` state. See Instance Life Cycle for more information on the possible instance states. For more information about setting scheduling options for a VM, see Set VM host maintenance policy.
	SetScheduling(context.Context, *SetSchedulingInstanceRequest) (*Operation, error)
	// Sets the Google Cloud Armor security policy for the specified instance. For more information, see Google Cloud Armor Overview
	SetSecurityPolicy(context.Context, *SetSecurityPolicyInstanceRequest) (*Operation, error)
	// Sets the service account on the instance. For more information, read Changing the service account and access scopes for an instance.
	SetServiceAccount(context.Context, *SetServiceAccountInstanceRequest) (*Operation, error)
	// Sets the Shielded Instance integrity policy for an instance. You can only use this method on a running instance. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
	SetShieldedInstanceIntegrityPolicy(context.Context, *SetShieldedInstanceIntegrityPolicyInstanceRequest) (*Operation, error)
	// Sets the Shielded VM integrity policy for a VM instance. You can only use this method on a running VM instance. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
	SetShieldedVmIntegrityPolicy(context.Context, *SetShieldedVmIntegrityPolicyInstanceRequest) (*Operation, error)
	// Sets network tags for the specified instance to the data included in the request.
	SetTags(context.Context, *SetTagsInstanceRequest) (*Operation, error)
	// Simulates a host maintenance event on a VM. For more information, see Simulate a host maintenance event.
	SimulateMaintenanceEvent(context.Context, *SimulateMaintenanceEventInstanceRequest) (*Operation, error)
	// Starts an instance that was stopped using the instances().stop method. For more information, see Restart an instance.
	Start(context.Context, *StartInstanceRequest) (*Operation, error)
	// Starts an instance that was stopped using the instances().stop method. For more information, see Restart an instance.
	StartWithEncryptionKey(context.Context, *StartWithEncryptionKeyInstanceRequest) (*Operation, error)
	// Stops a running instance, shutting it down cleanly, and allows you to restart the instance at a later time. Stopped instances do not incur VM usage charges while they are stopped. However, resources that the VM is using, such as persistent disks and static IP addresses, will continue to be charged until they are deleted. For more information, see Stopping an instance.
	Stop(context.Context, *StopInstanceRequest) (*Operation, error)
	// This method suspends a running instance, saving its state to persistent storage, and allows you to resume the instance at a later time. Suspended instances have no compute costs (cores or RAM), and incur only storage charges for the saved VM memory and localSSD data. Any charged resources the virtual machine was using, such as persistent disks and static IP addresses, will continue to be charged while the instance is suspended. For more information, see Suspending and resuming an instance.
	Suspend(context.Context, *SuspendInstanceRequest) (*Operation, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(context.Context, *TestIamPermissionsInstanceRequest) (*TestPermissionsResponse, error)
	// Updates an instance only if the necessary resources are available. This method can update only a specific set of instance properties. See Updating a running instance for a list of updatable instance properties.
	Update(context.Context, *UpdateInstanceRequest) (*Operation, error)
	// Updates the specified access config from an instance's network interface with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
	UpdateAccessConfig(context.Context, *UpdateAccessConfigInstanceRequest) (*Operation, error)
	// Updates the Display config for a VM instance. You can only use this method on a stopped VM instance. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
	UpdateDisplayDevice(context.Context, *UpdateDisplayDeviceInstanceRequest) (*Operation, error)
	// Updates an instance's network interface. This method can only update an interface's alias IP range and attached network. See Modifying alias IP ranges for an existing instance for instructions on changing alias IP ranges. See Migrating a VM between networks for instructions on migrating an interface. This method follows PATCH semantics.
	UpdateNetworkInterface(context.Context, *UpdateNetworkInterfaceInstanceRequest) (*Operation, error)
	// Updates the Shielded Instance config for an instance. You can only use this method on a stopped instance. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
	UpdateShieldedInstanceConfig(context.Context, *UpdateShieldedInstanceConfigInstanceRequest) (*Operation, error)
	// Updates the Shielded VM config for a VM instance. You can only use this method on a stopped VM instance. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
	UpdateShieldedVmConfig(context.Context, *UpdateShieldedVmConfigInstanceRequest) (*Operation, error)
}

// UnimplementedInstancesServer should be embedded to have forward compatible implementations.
type UnimplementedInstancesServer struct {
}

func (UnimplementedInstancesServer) AddAccessConfig(context.Context, *AddAccessConfigInstanceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddAccessConfig not implemented")
}
func (UnimplementedInstancesServer) AddNetworkInterface(context.Context, *AddNetworkInterfaceInstanceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddNetworkInterface not implemented")
}
func (UnimplementedInstancesServer) AddResourcePolicies(context.Context, *AddResourcePoliciesInstanceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddResourcePolicies not implemented")
}
func (UnimplementedInstancesServer) AggregatedList(context.Context, *AggregatedListInstancesRequest) (*InstanceAggregatedList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AggregatedList not implemented")
}
func (UnimplementedInstancesServer) AttachDisk(context.Context, *AttachDiskInstanceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AttachDisk not implemented")
}
func (UnimplementedInstancesServer) BulkInsert(context.Context, *BulkInsertInstanceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BulkInsert not implemented")
}
func (UnimplementedInstancesServer) Delete(context.Context, *DeleteInstanceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedInstancesServer) DeleteAccessConfig(context.Context, *DeleteAccessConfigInstanceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteAccessConfig not implemented")
}
func (UnimplementedInstancesServer) DeleteNetworkInterface(context.Context, *DeleteNetworkInterfaceInstanceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteNetworkInterface not implemented")
}
func (UnimplementedInstancesServer) DetachDisk(context.Context, *DetachDiskInstanceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DetachDisk not implemented")
}
func (UnimplementedInstancesServer) Get(context.Context, *GetInstanceRequest) (*Instance, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedInstancesServer) GetEffectiveFirewalls(context.Context, *GetEffectiveFirewallsInstanceRequest) (*InstancesGetEffectiveFirewallsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEffectiveFirewalls not implemented")
}
func (UnimplementedInstancesServer) GetGuestAttributes(context.Context, *GetGuestAttributesInstanceRequest) (*GuestAttributes, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetGuestAttributes not implemented")
}
func (UnimplementedInstancesServer) GetIamPolicy(context.Context, *GetIamPolicyInstanceRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedInstancesServer) GetPartnerMetadata(context.Context, *GetPartnerMetadataInstanceRequest) (*PartnerMetadata, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPartnerMetadata not implemented")
}
func (UnimplementedInstancesServer) GetScreenshot(context.Context, *GetScreenshotInstanceRequest) (*Screenshot, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetScreenshot not implemented")
}
func (UnimplementedInstancesServer) GetSerialPortOutput(context.Context, *GetSerialPortOutputInstanceRequest) (*SerialPortOutput, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetSerialPortOutput not implemented")
}
func (UnimplementedInstancesServer) GetShieldedInstanceIdentity(context.Context, *GetShieldedInstanceIdentityInstanceRequest) (*ShieldedInstanceIdentity, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetShieldedInstanceIdentity not implemented")
}
func (UnimplementedInstancesServer) GetShieldedVmIdentity(context.Context, *GetShieldedVmIdentityInstanceRequest) (*ShieldedVmIdentity, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetShieldedVmIdentity not implemented")
}
func (UnimplementedInstancesServer) Insert(context.Context, *InsertInstanceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (UnimplementedInstancesServer) List(context.Context, *ListInstancesRequest) (*InstanceList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedInstancesServer) ListReferrers(context.Context, *ListReferrersInstancesRequest) (*InstanceListReferrers, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListReferrers not implemented")
}
func (UnimplementedInstancesServer) PatchPartnerMetadata(context.Context, *PatchPartnerMetadataInstanceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PatchPartnerMetadata not implemented")
}
func (UnimplementedInstancesServer) PerformMaintenance(context.Context, *PerformMaintenanceInstanceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PerformMaintenance not implemented")
}
func (UnimplementedInstancesServer) RemoveResourcePolicies(context.Context, *RemoveResourcePoliciesInstanceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveResourcePolicies not implemented")
}
func (UnimplementedInstancesServer) ReportHostAsFaulty(context.Context, *ReportHostAsFaultyInstanceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ReportHostAsFaulty not implemented")
}
func (UnimplementedInstancesServer) Reset(context.Context, *ResetInstanceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Reset not implemented")
}
func (UnimplementedInstancesServer) Resume(context.Context, *ResumeInstanceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Resume not implemented")
}
func (UnimplementedInstancesServer) SendDiagnosticInterrupt(context.Context, *SendDiagnosticInterruptInstanceRequest) (*SendDiagnosticInterruptInstanceResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SendDiagnosticInterrupt not implemented")
}
func (UnimplementedInstancesServer) SetDeletionProtection(context.Context, *SetDeletionProtectionInstanceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetDeletionProtection not implemented")
}
func (UnimplementedInstancesServer) SetDiskAutoDelete(context.Context, *SetDiskAutoDeleteInstanceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetDiskAutoDelete not implemented")
}
func (UnimplementedInstancesServer) SetIamPolicy(context.Context, *SetIamPolicyInstanceRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedInstancesServer) SetLabels(context.Context, *SetLabelsInstanceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetLabels not implemented")
}
func (UnimplementedInstancesServer) SetMachineResources(context.Context, *SetMachineResourcesInstanceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetMachineResources not implemented")
}
func (UnimplementedInstancesServer) SetMachineType(context.Context, *SetMachineTypeInstanceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetMachineType not implemented")
}
func (UnimplementedInstancesServer) SetMetadata(context.Context, *SetMetadataInstanceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetMetadata not implemented")
}
func (UnimplementedInstancesServer) SetMinCpuPlatform(context.Context, *SetMinCpuPlatformInstanceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetMinCpuPlatform not implemented")
}
func (UnimplementedInstancesServer) SetName(context.Context, *SetNameInstanceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetName not implemented")
}
func (UnimplementedInstancesServer) SetScheduling(context.Context, *SetSchedulingInstanceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetScheduling not implemented")
}
func (UnimplementedInstancesServer) SetSecurityPolicy(context.Context, *SetSecurityPolicyInstanceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetSecurityPolicy not implemented")
}
func (UnimplementedInstancesServer) SetServiceAccount(context.Context, *SetServiceAccountInstanceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetServiceAccount not implemented")
}
func (UnimplementedInstancesServer) SetShieldedInstanceIntegrityPolicy(context.Context, *SetShieldedInstanceIntegrityPolicyInstanceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetShieldedInstanceIntegrityPolicy not implemented")
}
func (UnimplementedInstancesServer) SetShieldedVmIntegrityPolicy(context.Context, *SetShieldedVmIntegrityPolicyInstanceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetShieldedVmIntegrityPolicy not implemented")
}
func (UnimplementedInstancesServer) SetTags(context.Context, *SetTagsInstanceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetTags not implemented")
}
func (UnimplementedInstancesServer) SimulateMaintenanceEvent(context.Context, *SimulateMaintenanceEventInstanceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SimulateMaintenanceEvent not implemented")
}
func (UnimplementedInstancesServer) Start(context.Context, *StartInstanceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Start not implemented")
}
func (UnimplementedInstancesServer) StartWithEncryptionKey(context.Context, *StartWithEncryptionKeyInstanceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method StartWithEncryptionKey not implemented")
}
func (UnimplementedInstancesServer) Stop(context.Context, *StopInstanceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Stop not implemented")
}
func (UnimplementedInstancesServer) Suspend(context.Context, *SuspendInstanceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Suspend not implemented")
}
func (UnimplementedInstancesServer) TestIamPermissions(context.Context, *TestIamPermissionsInstanceRequest) (*TestPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}
func (UnimplementedInstancesServer) Update(context.Context, *UpdateInstanceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}
func (UnimplementedInstancesServer) UpdateAccessConfig(context.Context, *UpdateAccessConfigInstanceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateAccessConfig not implemented")
}
func (UnimplementedInstancesServer) UpdateDisplayDevice(context.Context, *UpdateDisplayDeviceInstanceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateDisplayDevice not implemented")
}
func (UnimplementedInstancesServer) UpdateNetworkInterface(context.Context, *UpdateNetworkInterfaceInstanceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateNetworkInterface not implemented")
}
func (UnimplementedInstancesServer) UpdateShieldedInstanceConfig(context.Context, *UpdateShieldedInstanceConfigInstanceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateShieldedInstanceConfig not implemented")
}
func (UnimplementedInstancesServer) UpdateShieldedVmConfig(context.Context, *UpdateShieldedVmConfigInstanceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateShieldedVmConfig not implemented")
}

// UnsafeInstancesServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to InstancesServer will
// result in compilation errors.
type UnsafeInstancesServer interface {
	mustEmbedUnimplementedInstancesServer()
}

func RegisterInstancesServer(s grpc.ServiceRegistrar, srv InstancesServer) {
	s.RegisterService(&Instances_ServiceDesc, srv)
}

func _Instances_AddAccessConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddAccessConfigInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).AddAccessConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_AddAccessConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).AddAccessConfig(ctx, req.(*AddAccessConfigInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_AddNetworkInterface_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddNetworkInterfaceInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).AddNetworkInterface(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_AddNetworkInterface_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).AddNetworkInterface(ctx, req.(*AddNetworkInterfaceInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_AddResourcePolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddResourcePoliciesInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).AddResourcePolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_AddResourcePolicies_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).AddResourcePolicies(ctx, req.(*AddResourcePoliciesInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_AggregatedList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AggregatedListInstancesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).AggregatedList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_AggregatedList_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).AggregatedList(ctx, req.(*AggregatedListInstancesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_AttachDisk_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AttachDiskInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).AttachDisk(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_AttachDisk_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).AttachDisk(ctx, req.(*AttachDiskInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_BulkInsert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BulkInsertInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).BulkInsert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_BulkInsert_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).BulkInsert(ctx, req.(*BulkInsertInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).Delete(ctx, req.(*DeleteInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_DeleteAccessConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteAccessConfigInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).DeleteAccessConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_DeleteAccessConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).DeleteAccessConfig(ctx, req.(*DeleteAccessConfigInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_DeleteNetworkInterface_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNetworkInterfaceInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).DeleteNetworkInterface(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_DeleteNetworkInterface_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).DeleteNetworkInterface(ctx, req.(*DeleteNetworkInterfaceInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_DetachDisk_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DetachDiskInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).DetachDisk(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_DetachDisk_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).DetachDisk(ctx, req.(*DetachDiskInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).Get(ctx, req.(*GetInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_GetEffectiveFirewalls_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEffectiveFirewallsInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).GetEffectiveFirewalls(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_GetEffectiveFirewalls_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).GetEffectiveFirewalls(ctx, req.(*GetEffectiveFirewallsInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_GetGuestAttributes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGuestAttributesInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).GetGuestAttributes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_GetGuestAttributes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).GetGuestAttributes(ctx, req.(*GetGuestAttributesInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIamPolicyInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).GetIamPolicy(ctx, req.(*GetIamPolicyInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_GetPartnerMetadata_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPartnerMetadataInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).GetPartnerMetadata(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_GetPartnerMetadata_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).GetPartnerMetadata(ctx, req.(*GetPartnerMetadataInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_GetScreenshot_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetScreenshotInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).GetScreenshot(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_GetScreenshot_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).GetScreenshot(ctx, req.(*GetScreenshotInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_GetSerialPortOutput_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSerialPortOutputInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).GetSerialPortOutput(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_GetSerialPortOutput_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).GetSerialPortOutput(ctx, req.(*GetSerialPortOutputInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_GetShieldedInstanceIdentity_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetShieldedInstanceIdentityInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).GetShieldedInstanceIdentity(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_GetShieldedInstanceIdentity_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).GetShieldedInstanceIdentity(ctx, req.(*GetShieldedInstanceIdentityInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_GetShieldedVmIdentity_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetShieldedVmIdentityInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).GetShieldedVmIdentity(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_GetShieldedVmIdentity_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).GetShieldedVmIdentity(ctx, req.(*GetShieldedVmIdentityInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_Insert_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).Insert(ctx, req.(*InsertInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstancesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).List(ctx, req.(*ListInstancesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_ListReferrers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListReferrersInstancesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).ListReferrers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_ListReferrers_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).ListReferrers(ctx, req.(*ListReferrersInstancesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_PatchPartnerMetadata_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchPartnerMetadataInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).PatchPartnerMetadata(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_PatchPartnerMetadata_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).PatchPartnerMetadata(ctx, req.(*PatchPartnerMetadataInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_PerformMaintenance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PerformMaintenanceInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).PerformMaintenance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_PerformMaintenance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).PerformMaintenance(ctx, req.(*PerformMaintenanceInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_RemoveResourcePolicies_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveResourcePoliciesInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).RemoveResourcePolicies(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_RemoveResourcePolicies_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).RemoveResourcePolicies(ctx, req.(*RemoveResourcePoliciesInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_ReportHostAsFaulty_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ReportHostAsFaultyInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).ReportHostAsFaulty(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_ReportHostAsFaulty_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).ReportHostAsFaulty(ctx, req.(*ReportHostAsFaultyInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_Reset_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResetInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).Reset(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_Reset_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).Reset(ctx, req.(*ResetInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_Resume_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ResumeInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).Resume(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_Resume_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).Resume(ctx, req.(*ResumeInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_SendDiagnosticInterrupt_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SendDiagnosticInterruptInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).SendDiagnosticInterrupt(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_SendDiagnosticInterrupt_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).SendDiagnosticInterrupt(ctx, req.(*SendDiagnosticInterruptInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_SetDeletionProtection_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetDeletionProtectionInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).SetDeletionProtection(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_SetDeletionProtection_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).SetDeletionProtection(ctx, req.(*SetDeletionProtectionInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_SetDiskAutoDelete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetDiskAutoDeleteInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).SetDiskAutoDelete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_SetDiskAutoDelete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).SetDiskAutoDelete(ctx, req.(*SetDiskAutoDeleteInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetIamPolicyInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).SetIamPolicy(ctx, req.(*SetIamPolicyInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_SetLabels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetLabelsInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).SetLabels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_SetLabels_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).SetLabels(ctx, req.(*SetLabelsInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_SetMachineResources_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetMachineResourcesInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).SetMachineResources(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_SetMachineResources_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).SetMachineResources(ctx, req.(*SetMachineResourcesInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_SetMachineType_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetMachineTypeInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).SetMachineType(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_SetMachineType_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).SetMachineType(ctx, req.(*SetMachineTypeInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_SetMetadata_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetMetadataInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).SetMetadata(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_SetMetadata_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).SetMetadata(ctx, req.(*SetMetadataInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_SetMinCpuPlatform_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetMinCpuPlatformInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).SetMinCpuPlatform(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_SetMinCpuPlatform_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).SetMinCpuPlatform(ctx, req.(*SetMinCpuPlatformInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_SetName_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetNameInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).SetName(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_SetName_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).SetName(ctx, req.(*SetNameInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_SetScheduling_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetSchedulingInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).SetScheduling(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_SetScheduling_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).SetScheduling(ctx, req.(*SetSchedulingInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_SetSecurityPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetSecurityPolicyInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).SetSecurityPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_SetSecurityPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).SetSecurityPolicy(ctx, req.(*SetSecurityPolicyInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_SetServiceAccount_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetServiceAccountInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).SetServiceAccount(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_SetServiceAccount_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).SetServiceAccount(ctx, req.(*SetServiceAccountInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_SetShieldedInstanceIntegrityPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetShieldedInstanceIntegrityPolicyInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).SetShieldedInstanceIntegrityPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_SetShieldedInstanceIntegrityPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).SetShieldedInstanceIntegrityPolicy(ctx, req.(*SetShieldedInstanceIntegrityPolicyInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_SetShieldedVmIntegrityPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetShieldedVmIntegrityPolicyInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).SetShieldedVmIntegrityPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_SetShieldedVmIntegrityPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).SetShieldedVmIntegrityPolicy(ctx, req.(*SetShieldedVmIntegrityPolicyInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_SetTags_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetTagsInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).SetTags(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_SetTags_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).SetTags(ctx, req.(*SetTagsInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_SimulateMaintenanceEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SimulateMaintenanceEventInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).SimulateMaintenanceEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_SimulateMaintenanceEvent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).SimulateMaintenanceEvent(ctx, req.(*SimulateMaintenanceEventInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_Start_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).Start(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_Start_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).Start(ctx, req.(*StartInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_StartWithEncryptionKey_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartWithEncryptionKeyInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).StartWithEncryptionKey(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_StartWithEncryptionKey_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).StartWithEncryptionKey(ctx, req.(*StartWithEncryptionKeyInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_Stop_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StopInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).Stop(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_Stop_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).Stop(ctx, req.(*StopInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_Suspend_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SuspendInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).Suspend(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_Suspend_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).Suspend(ctx, req.(*SuspendInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TestIamPermissionsInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).TestIamPermissions(ctx, req.(*TestIamPermissionsInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_Update_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).Update(ctx, req.(*UpdateInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_UpdateAccessConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateAccessConfigInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).UpdateAccessConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_UpdateAccessConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).UpdateAccessConfig(ctx, req.(*UpdateAccessConfigInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_UpdateDisplayDevice_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateDisplayDeviceInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).UpdateDisplayDevice(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_UpdateDisplayDevice_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).UpdateDisplayDevice(ctx, req.(*UpdateDisplayDeviceInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_UpdateNetworkInterface_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateNetworkInterfaceInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).UpdateNetworkInterface(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_UpdateNetworkInterface_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).UpdateNetworkInterface(ctx, req.(*UpdateNetworkInterfaceInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_UpdateShieldedInstanceConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateShieldedInstanceConfigInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).UpdateShieldedInstanceConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_UpdateShieldedInstanceConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).UpdateShieldedInstanceConfig(ctx, req.(*UpdateShieldedInstanceConfigInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Instances_UpdateShieldedVmConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateShieldedVmConfigInstanceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstancesServer).UpdateShieldedVmConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Instances_UpdateShieldedVmConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstancesServer).UpdateShieldedVmConfig(ctx, req.(*UpdateShieldedVmConfigInstanceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Instances_ServiceDesc is the grpc.ServiceDesc for Instances service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Instances_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.Instances",
	HandlerType: (*InstancesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AddAccessConfig",
			Handler:    _Instances_AddAccessConfig_Handler,
		},
		{
			MethodName: "AddNetworkInterface",
			Handler:    _Instances_AddNetworkInterface_Handler,
		},
		{
			MethodName: "AddResourcePolicies",
			Handler:    _Instances_AddResourcePolicies_Handler,
		},
		{
			MethodName: "AggregatedList",
			Handler:    _Instances_AggregatedList_Handler,
		},
		{
			MethodName: "AttachDisk",
			Handler:    _Instances_AttachDisk_Handler,
		},
		{
			MethodName: "BulkInsert",
			Handler:    _Instances_BulkInsert_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _Instances_Delete_Handler,
		},
		{
			MethodName: "DeleteAccessConfig",
			Handler:    _Instances_DeleteAccessConfig_Handler,
		},
		{
			MethodName: "DeleteNetworkInterface",
			Handler:    _Instances_DeleteNetworkInterface_Handler,
		},
		{
			MethodName: "DetachDisk",
			Handler:    _Instances_DetachDisk_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _Instances_Get_Handler,
		},
		{
			MethodName: "GetEffectiveFirewalls",
			Handler:    _Instances_GetEffectiveFirewalls_Handler,
		},
		{
			MethodName: "GetGuestAttributes",
			Handler:    _Instances_GetGuestAttributes_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _Instances_GetIamPolicy_Handler,
		},
		{
			MethodName: "GetPartnerMetadata",
			Handler:    _Instances_GetPartnerMetadata_Handler,
		},
		{
			MethodName: "GetScreenshot",
			Handler:    _Instances_GetScreenshot_Handler,
		},
		{
			MethodName: "GetSerialPortOutput",
			Handler:    _Instances_GetSerialPortOutput_Handler,
		},
		{
			MethodName: "GetShieldedInstanceIdentity",
			Handler:    _Instances_GetShieldedInstanceIdentity_Handler,
		},
		{
			MethodName: "GetShieldedVmIdentity",
			Handler:    _Instances_GetShieldedVmIdentity_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _Instances_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _Instances_List_Handler,
		},
		{
			MethodName: "ListReferrers",
			Handler:    _Instances_ListReferrers_Handler,
		},
		{
			MethodName: "PatchPartnerMetadata",
			Handler:    _Instances_PatchPartnerMetadata_Handler,
		},
		{
			MethodName: "PerformMaintenance",
			Handler:    _Instances_PerformMaintenance_Handler,
		},
		{
			MethodName: "RemoveResourcePolicies",
			Handler:    _Instances_RemoveResourcePolicies_Handler,
		},
		{
			MethodName: "ReportHostAsFaulty",
			Handler:    _Instances_ReportHostAsFaulty_Handler,
		},
		{
			MethodName: "Reset",
			Handler:    _Instances_Reset_Handler,
		},
		{
			MethodName: "Resume",
			Handler:    _Instances_Resume_Handler,
		},
		{
			MethodName: "SendDiagnosticInterrupt",
			Handler:    _Instances_SendDiagnosticInterrupt_Handler,
		},
		{
			MethodName: "SetDeletionProtection",
			Handler:    _Instances_SetDeletionProtection_Handler,
		},
		{
			MethodName: "SetDiskAutoDelete",
			Handler:    _Instances_SetDiskAutoDelete_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _Instances_SetIamPolicy_Handler,
		},
		{
			MethodName: "SetLabels",
			Handler:    _Instances_SetLabels_Handler,
		},
		{
			MethodName: "SetMachineResources",
			Handler:    _Instances_SetMachineResources_Handler,
		},
		{
			MethodName: "SetMachineType",
			Handler:    _Instances_SetMachineType_Handler,
		},
		{
			MethodName: "SetMetadata",
			Handler:    _Instances_SetMetadata_Handler,
		},
		{
			MethodName: "SetMinCpuPlatform",
			Handler:    _Instances_SetMinCpuPlatform_Handler,
		},
		{
			MethodName: "SetName",
			Handler:    _Instances_SetName_Handler,
		},
		{
			MethodName: "SetScheduling",
			Handler:    _Instances_SetScheduling_Handler,
		},
		{
			MethodName: "SetSecurityPolicy",
			Handler:    _Instances_SetSecurityPolicy_Handler,
		},
		{
			MethodName: "SetServiceAccount",
			Handler:    _Instances_SetServiceAccount_Handler,
		},
		{
			MethodName: "SetShieldedInstanceIntegrityPolicy",
			Handler:    _Instances_SetShieldedInstanceIntegrityPolicy_Handler,
		},
		{
			MethodName: "SetShieldedVmIntegrityPolicy",
			Handler:    _Instances_SetShieldedVmIntegrityPolicy_Handler,
		},
		{
			MethodName: "SetTags",
			Handler:    _Instances_SetTags_Handler,
		},
		{
			MethodName: "SimulateMaintenanceEvent",
			Handler:    _Instances_SimulateMaintenanceEvent_Handler,
		},
		{
			MethodName: "Start",
			Handler:    _Instances_Start_Handler,
		},
		{
			MethodName: "StartWithEncryptionKey",
			Handler:    _Instances_StartWithEncryptionKey_Handler,
		},
		{
			MethodName: "Stop",
			Handler:    _Instances_Stop_Handler,
		},
		{
			MethodName: "Suspend",
			Handler:    _Instances_Suspend_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _Instances_TestIamPermissions_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _Instances_Update_Handler,
		},
		{
			MethodName: "UpdateAccessConfig",
			Handler:    _Instances_UpdateAccessConfig_Handler,
		},
		{
			MethodName: "UpdateDisplayDevice",
			Handler:    _Instances_UpdateDisplayDevice_Handler,
		},
		{
			MethodName: "UpdateNetworkInterface",
			Handler:    _Instances_UpdateNetworkInterface_Handler,
		},
		{
			MethodName: "UpdateShieldedInstanceConfig",
			Handler:    _Instances_UpdateShieldedInstanceConfig_Handler,
		},
		{
			MethodName: "UpdateShieldedVmConfig",
			Handler:    _Instances_UpdateShieldedVmConfig_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	InstantSnapshots_AggregatedList_FullMethodName     = "/google.cloud.compute.v1beta.InstantSnapshots/AggregatedList"
	InstantSnapshots_Delete_FullMethodName             = "/google.cloud.compute.v1beta.InstantSnapshots/Delete"
	InstantSnapshots_Get_FullMethodName                = "/google.cloud.compute.v1beta.InstantSnapshots/Get"
	InstantSnapshots_GetIamPolicy_FullMethodName       = "/google.cloud.compute.v1beta.InstantSnapshots/GetIamPolicy"
	InstantSnapshots_Insert_FullMethodName             = "/google.cloud.compute.v1beta.InstantSnapshots/Insert"
	InstantSnapshots_List_FullMethodName               = "/google.cloud.compute.v1beta.InstantSnapshots/List"
	InstantSnapshots_SetIamPolicy_FullMethodName       = "/google.cloud.compute.v1beta.InstantSnapshots/SetIamPolicy"
	InstantSnapshots_SetLabels_FullMethodName          = "/google.cloud.compute.v1beta.InstantSnapshots/SetLabels"
	InstantSnapshots_TestIamPermissions_FullMethodName = "/google.cloud.compute.v1beta.InstantSnapshots/TestIamPermissions"
)

// InstantSnapshotsClient is the client API for InstantSnapshots service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type InstantSnapshotsClient interface {
	// Retrieves an aggregated list of instantSnapshots. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(ctx context.Context, in *AggregatedListInstantSnapshotsRequest, opts ...grpc.CallOption) (*InstantSnapshotAggregatedList, error)
	// Deletes the specified InstantSnapshot resource. Keep in mind that deleting a single instantSnapshot might not necessarily delete all the data on that instantSnapshot. If any data on the instantSnapshot that is marked for deletion is needed for subsequent instantSnapshots, the data will be moved to the next corresponding instantSnapshot. For more information, see Deleting instantSnapshots.
	Delete(ctx context.Context, in *DeleteInstantSnapshotRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns the specified InstantSnapshot resource in the specified zone.
	Get(ctx context.Context, in *GetInstantSnapshotRequest, opts ...grpc.CallOption) (*InstantSnapshot, error)
	// Gets the access control policy for a resource. May be empty if no such policy or resource exists.
	GetIamPolicy(ctx context.Context, in *GetIamPolicyInstantSnapshotRequest, opts ...grpc.CallOption) (*Policy, error)
	// Creates an instant snapshot in the specified zone.
	Insert(ctx context.Context, in *InsertInstantSnapshotRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves the list of InstantSnapshot resources contained within the specified zone.
	List(ctx context.Context, in *ListInstantSnapshotsRequest, opts ...grpc.CallOption) (*InstantSnapshotList, error)
	// Sets the access control policy on the specified resource. Replaces any existing policy.
	SetIamPolicy(ctx context.Context, in *SetIamPolicyInstantSnapshotRequest, opts ...grpc.CallOption) (*Policy, error)
	// Sets the labels on a instantSnapshot in the given zone. To learn more about labels, read the Labeling Resources documentation.
	SetLabels(ctx context.Context, in *SetLabelsInstantSnapshotRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(ctx context.Context, in *TestIamPermissionsInstantSnapshotRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error)
}

type instantSnapshotsClient struct {
	cc grpc.ClientConnInterface
}

func NewInstantSnapshotsClient(cc grpc.ClientConnInterface) InstantSnapshotsClient {
	return &instantSnapshotsClient{cc}
}

func (c *instantSnapshotsClient) AggregatedList(ctx context.Context, in *AggregatedListInstantSnapshotsRequest, opts ...grpc.CallOption) (*InstantSnapshotAggregatedList, error) {
	out := new(InstantSnapshotAggregatedList)
	err := c.cc.Invoke(ctx, InstantSnapshots_AggregatedList_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instantSnapshotsClient) Delete(ctx context.Context, in *DeleteInstantSnapshotRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InstantSnapshots_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instantSnapshotsClient) Get(ctx context.Context, in *GetInstantSnapshotRequest, opts ...grpc.CallOption) (*InstantSnapshot, error) {
	out := new(InstantSnapshot)
	err := c.cc.Invoke(ctx, InstantSnapshots_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instantSnapshotsClient) GetIamPolicy(ctx context.Context, in *GetIamPolicyInstantSnapshotRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, InstantSnapshots_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instantSnapshotsClient) Insert(ctx context.Context, in *InsertInstantSnapshotRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InstantSnapshots_Insert_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instantSnapshotsClient) List(ctx context.Context, in *ListInstantSnapshotsRequest, opts ...grpc.CallOption) (*InstantSnapshotList, error) {
	out := new(InstantSnapshotList)
	err := c.cc.Invoke(ctx, InstantSnapshots_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instantSnapshotsClient) SetIamPolicy(ctx context.Context, in *SetIamPolicyInstantSnapshotRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, InstantSnapshots_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instantSnapshotsClient) SetLabels(ctx context.Context, in *SetLabelsInstantSnapshotRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InstantSnapshots_SetLabels_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *instantSnapshotsClient) TestIamPermissions(ctx context.Context, in *TestIamPermissionsInstantSnapshotRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error) {
	out := new(TestPermissionsResponse)
	err := c.cc.Invoke(ctx, InstantSnapshots_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// InstantSnapshotsServer is the server API for InstantSnapshots service.
// All implementations should embed UnimplementedInstantSnapshotsServer
// for forward compatibility
type InstantSnapshotsServer interface {
	// Retrieves an aggregated list of instantSnapshots. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(context.Context, *AggregatedListInstantSnapshotsRequest) (*InstantSnapshotAggregatedList, error)
	// Deletes the specified InstantSnapshot resource. Keep in mind that deleting a single instantSnapshot might not necessarily delete all the data on that instantSnapshot. If any data on the instantSnapshot that is marked for deletion is needed for subsequent instantSnapshots, the data will be moved to the next corresponding instantSnapshot. For more information, see Deleting instantSnapshots.
	Delete(context.Context, *DeleteInstantSnapshotRequest) (*Operation, error)
	// Returns the specified InstantSnapshot resource in the specified zone.
	Get(context.Context, *GetInstantSnapshotRequest) (*InstantSnapshot, error)
	// Gets the access control policy for a resource. May be empty if no such policy or resource exists.
	GetIamPolicy(context.Context, *GetIamPolicyInstantSnapshotRequest) (*Policy, error)
	// Creates an instant snapshot in the specified zone.
	Insert(context.Context, *InsertInstantSnapshotRequest) (*Operation, error)
	// Retrieves the list of InstantSnapshot resources contained within the specified zone.
	List(context.Context, *ListInstantSnapshotsRequest) (*InstantSnapshotList, error)
	// Sets the access control policy on the specified resource. Replaces any existing policy.
	SetIamPolicy(context.Context, *SetIamPolicyInstantSnapshotRequest) (*Policy, error)
	// Sets the labels on a instantSnapshot in the given zone. To learn more about labels, read the Labeling Resources documentation.
	SetLabels(context.Context, *SetLabelsInstantSnapshotRequest) (*Operation, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(context.Context, *TestIamPermissionsInstantSnapshotRequest) (*TestPermissionsResponse, error)
}

// UnimplementedInstantSnapshotsServer should be embedded to have forward compatible implementations.
type UnimplementedInstantSnapshotsServer struct {
}

func (UnimplementedInstantSnapshotsServer) AggregatedList(context.Context, *AggregatedListInstantSnapshotsRequest) (*InstantSnapshotAggregatedList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AggregatedList not implemented")
}
func (UnimplementedInstantSnapshotsServer) Delete(context.Context, *DeleteInstantSnapshotRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedInstantSnapshotsServer) Get(context.Context, *GetInstantSnapshotRequest) (*InstantSnapshot, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedInstantSnapshotsServer) GetIamPolicy(context.Context, *GetIamPolicyInstantSnapshotRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedInstantSnapshotsServer) Insert(context.Context, *InsertInstantSnapshotRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (UnimplementedInstantSnapshotsServer) List(context.Context, *ListInstantSnapshotsRequest) (*InstantSnapshotList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedInstantSnapshotsServer) SetIamPolicy(context.Context, *SetIamPolicyInstantSnapshotRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedInstantSnapshotsServer) SetLabels(context.Context, *SetLabelsInstantSnapshotRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetLabels not implemented")
}
func (UnimplementedInstantSnapshotsServer) TestIamPermissions(context.Context, *TestIamPermissionsInstantSnapshotRequest) (*TestPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

// UnsafeInstantSnapshotsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to InstantSnapshotsServer will
// result in compilation errors.
type UnsafeInstantSnapshotsServer interface {
	mustEmbedUnimplementedInstantSnapshotsServer()
}

func RegisterInstantSnapshotsServer(s grpc.ServiceRegistrar, srv InstantSnapshotsServer) {
	s.RegisterService(&InstantSnapshots_ServiceDesc, srv)
}

func _InstantSnapshots_AggregatedList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AggregatedListInstantSnapshotsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstantSnapshotsServer).AggregatedList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstantSnapshots_AggregatedList_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstantSnapshotsServer).AggregatedList(ctx, req.(*AggregatedListInstantSnapshotsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstantSnapshots_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInstantSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstantSnapshotsServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstantSnapshots_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstantSnapshotsServer).Delete(ctx, req.(*DeleteInstantSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstantSnapshots_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInstantSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstantSnapshotsServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstantSnapshots_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstantSnapshotsServer).Get(ctx, req.(*GetInstantSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstantSnapshots_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIamPolicyInstantSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstantSnapshotsServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstantSnapshots_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstantSnapshotsServer).GetIamPolicy(ctx, req.(*GetIamPolicyInstantSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstantSnapshots_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertInstantSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstantSnapshotsServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstantSnapshots_Insert_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstantSnapshotsServer).Insert(ctx, req.(*InsertInstantSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstantSnapshots_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInstantSnapshotsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstantSnapshotsServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstantSnapshots_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstantSnapshotsServer).List(ctx, req.(*ListInstantSnapshotsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstantSnapshots_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetIamPolicyInstantSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstantSnapshotsServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstantSnapshots_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstantSnapshotsServer).SetIamPolicy(ctx, req.(*SetIamPolicyInstantSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstantSnapshots_SetLabels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetLabelsInstantSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstantSnapshotsServer).SetLabels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstantSnapshots_SetLabels_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstantSnapshotsServer).SetLabels(ctx, req.(*SetLabelsInstantSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InstantSnapshots_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TestIamPermissionsInstantSnapshotRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InstantSnapshotsServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InstantSnapshots_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InstantSnapshotsServer).TestIamPermissions(ctx, req.(*TestIamPermissionsInstantSnapshotRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// InstantSnapshots_ServiceDesc is the grpc.ServiceDesc for InstantSnapshots service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var InstantSnapshots_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.InstantSnapshots",
	HandlerType: (*InstantSnapshotsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AggregatedList",
			Handler:    _InstantSnapshots_AggregatedList_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _InstantSnapshots_Delete_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _InstantSnapshots_Get_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _InstantSnapshots_GetIamPolicy_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _InstantSnapshots_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _InstantSnapshots_List_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _InstantSnapshots_SetIamPolicy_Handler,
		},
		{
			MethodName: "SetLabels",
			Handler:    _InstantSnapshots_SetLabels_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _InstantSnapshots_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	InterconnectAttachmentGroups_Delete_FullMethodName               = "/google.cloud.compute.v1beta.InterconnectAttachmentGroups/Delete"
	InterconnectAttachmentGroups_Get_FullMethodName                  = "/google.cloud.compute.v1beta.InterconnectAttachmentGroups/Get"
	InterconnectAttachmentGroups_GetIamPolicy_FullMethodName         = "/google.cloud.compute.v1beta.InterconnectAttachmentGroups/GetIamPolicy"
	InterconnectAttachmentGroups_GetOperationalStatus_FullMethodName = "/google.cloud.compute.v1beta.InterconnectAttachmentGroups/GetOperationalStatus"
	InterconnectAttachmentGroups_Insert_FullMethodName               = "/google.cloud.compute.v1beta.InterconnectAttachmentGroups/Insert"
	InterconnectAttachmentGroups_List_FullMethodName                 = "/google.cloud.compute.v1beta.InterconnectAttachmentGroups/List"
	InterconnectAttachmentGroups_Patch_FullMethodName                = "/google.cloud.compute.v1beta.InterconnectAttachmentGroups/Patch"
	InterconnectAttachmentGroups_SetIamPolicy_FullMethodName         = "/google.cloud.compute.v1beta.InterconnectAttachmentGroups/SetIamPolicy"
	InterconnectAttachmentGroups_TestIamPermissions_FullMethodName   = "/google.cloud.compute.v1beta.InterconnectAttachmentGroups/TestIamPermissions"
)

// InterconnectAttachmentGroupsClient is the client API for InterconnectAttachmentGroups service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type InterconnectAttachmentGroupsClient interface {
	// Deletes the specified InterconnectAttachmentGroup in the given scope
	Delete(ctx context.Context, in *DeleteInterconnectAttachmentGroupRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns the specified InterconnectAttachmentGroup resource in the given scope.
	Get(ctx context.Context, in *GetInterconnectAttachmentGroupRequest, opts ...grpc.CallOption) (*InterconnectAttachmentGroup, error)
	// Gets the access control policy for a resource. May be empty if no such policy or resource exists.
	GetIamPolicy(ctx context.Context, in *GetIamPolicyInterconnectAttachmentGroupRequest, opts ...grpc.CallOption) (*Policy, error)
	// Returns the InterconnectAttachmentStatuses for the specified InterconnectAttachmentGroup resource.
	GetOperationalStatus(ctx context.Context, in *GetOperationalStatusInterconnectAttachmentGroupRequest, opts ...grpc.CallOption) (*InterconnectAttachmentGroupsGetOperationalStatusResponse, error)
	// Creates a InterconnectAttachmentGroup in the specified project in the given scope using the parameters that are included in the request.
	Insert(ctx context.Context, in *InsertInterconnectAttachmentGroupRequest, opts ...grpc.CallOption) (*Operation, error)
	// Lists the InterconnectAttachmentGroups for a project in the given scope.
	List(ctx context.Context, in *ListInterconnectAttachmentGroupsRequest, opts ...grpc.CallOption) (*InterconnectAttachmentGroupsListResponse, error)
	// Patches the specified InterconnectAttachmentGroup resource with the data included in the request. This method supports PATCH semantics and uses JSON merge patch format and processing rules.
	Patch(ctx context.Context, in *PatchInterconnectAttachmentGroupRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the access control policy on the specified resource. Replaces any existing policy.
	SetIamPolicy(ctx context.Context, in *SetIamPolicyInterconnectAttachmentGroupRequest, opts ...grpc.CallOption) (*Policy, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(ctx context.Context, in *TestIamPermissionsInterconnectAttachmentGroupRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error)
}

type interconnectAttachmentGroupsClient struct {
	cc grpc.ClientConnInterface
}

func NewInterconnectAttachmentGroupsClient(cc grpc.ClientConnInterface) InterconnectAttachmentGroupsClient {
	return &interconnectAttachmentGroupsClient{cc}
}

func (c *interconnectAttachmentGroupsClient) Delete(ctx context.Context, in *DeleteInterconnectAttachmentGroupRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InterconnectAttachmentGroups_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *interconnectAttachmentGroupsClient) Get(ctx context.Context, in *GetInterconnectAttachmentGroupRequest, opts ...grpc.CallOption) (*InterconnectAttachmentGroup, error) {
	out := new(InterconnectAttachmentGroup)
	err := c.cc.Invoke(ctx, InterconnectAttachmentGroups_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *interconnectAttachmentGroupsClient) GetIamPolicy(ctx context.Context, in *GetIamPolicyInterconnectAttachmentGroupRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, InterconnectAttachmentGroups_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *interconnectAttachmentGroupsClient) GetOperationalStatus(ctx context.Context, in *GetOperationalStatusInterconnectAttachmentGroupRequest, opts ...grpc.CallOption) (*InterconnectAttachmentGroupsGetOperationalStatusResponse, error) {
	out := new(InterconnectAttachmentGroupsGetOperationalStatusResponse)
	err := c.cc.Invoke(ctx, InterconnectAttachmentGroups_GetOperationalStatus_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *interconnectAttachmentGroupsClient) Insert(ctx context.Context, in *InsertInterconnectAttachmentGroupRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InterconnectAttachmentGroups_Insert_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *interconnectAttachmentGroupsClient) List(ctx context.Context, in *ListInterconnectAttachmentGroupsRequest, opts ...grpc.CallOption) (*InterconnectAttachmentGroupsListResponse, error) {
	out := new(InterconnectAttachmentGroupsListResponse)
	err := c.cc.Invoke(ctx, InterconnectAttachmentGroups_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *interconnectAttachmentGroupsClient) Patch(ctx context.Context, in *PatchInterconnectAttachmentGroupRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InterconnectAttachmentGroups_Patch_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *interconnectAttachmentGroupsClient) SetIamPolicy(ctx context.Context, in *SetIamPolicyInterconnectAttachmentGroupRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, InterconnectAttachmentGroups_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *interconnectAttachmentGroupsClient) TestIamPermissions(ctx context.Context, in *TestIamPermissionsInterconnectAttachmentGroupRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error) {
	out := new(TestPermissionsResponse)
	err := c.cc.Invoke(ctx, InterconnectAttachmentGroups_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// InterconnectAttachmentGroupsServer is the server API for InterconnectAttachmentGroups service.
// All implementations should embed UnimplementedInterconnectAttachmentGroupsServer
// for forward compatibility
type InterconnectAttachmentGroupsServer interface {
	// Deletes the specified InterconnectAttachmentGroup in the given scope
	Delete(context.Context, *DeleteInterconnectAttachmentGroupRequest) (*Operation, error)
	// Returns the specified InterconnectAttachmentGroup resource in the given scope.
	Get(context.Context, *GetInterconnectAttachmentGroupRequest) (*InterconnectAttachmentGroup, error)
	// Gets the access control policy for a resource. May be empty if no such policy or resource exists.
	GetIamPolicy(context.Context, *GetIamPolicyInterconnectAttachmentGroupRequest) (*Policy, error)
	// Returns the InterconnectAttachmentStatuses for the specified InterconnectAttachmentGroup resource.
	GetOperationalStatus(context.Context, *GetOperationalStatusInterconnectAttachmentGroupRequest) (*InterconnectAttachmentGroupsGetOperationalStatusResponse, error)
	// Creates a InterconnectAttachmentGroup in the specified project in the given scope using the parameters that are included in the request.
	Insert(context.Context, *InsertInterconnectAttachmentGroupRequest) (*Operation, error)
	// Lists the InterconnectAttachmentGroups for a project in the given scope.
	List(context.Context, *ListInterconnectAttachmentGroupsRequest) (*InterconnectAttachmentGroupsListResponse, error)
	// Patches the specified InterconnectAttachmentGroup resource with the data included in the request. This method supports PATCH semantics and uses JSON merge patch format and processing rules.
	Patch(context.Context, *PatchInterconnectAttachmentGroupRequest) (*Operation, error)
	// Sets the access control policy on the specified resource. Replaces any existing policy.
	SetIamPolicy(context.Context, *SetIamPolicyInterconnectAttachmentGroupRequest) (*Policy, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(context.Context, *TestIamPermissionsInterconnectAttachmentGroupRequest) (*TestPermissionsResponse, error)
}

// UnimplementedInterconnectAttachmentGroupsServer should be embedded to have forward compatible implementations.
type UnimplementedInterconnectAttachmentGroupsServer struct {
}

func (UnimplementedInterconnectAttachmentGroupsServer) Delete(context.Context, *DeleteInterconnectAttachmentGroupRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedInterconnectAttachmentGroupsServer) Get(context.Context, *GetInterconnectAttachmentGroupRequest) (*InterconnectAttachmentGroup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedInterconnectAttachmentGroupsServer) GetIamPolicy(context.Context, *GetIamPolicyInterconnectAttachmentGroupRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedInterconnectAttachmentGroupsServer) GetOperationalStatus(context.Context, *GetOperationalStatusInterconnectAttachmentGroupRequest) (*InterconnectAttachmentGroupsGetOperationalStatusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetOperationalStatus not implemented")
}
func (UnimplementedInterconnectAttachmentGroupsServer) Insert(context.Context, *InsertInterconnectAttachmentGroupRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (UnimplementedInterconnectAttachmentGroupsServer) List(context.Context, *ListInterconnectAttachmentGroupsRequest) (*InterconnectAttachmentGroupsListResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedInterconnectAttachmentGroupsServer) Patch(context.Context, *PatchInterconnectAttachmentGroupRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Patch not implemented")
}
func (UnimplementedInterconnectAttachmentGroupsServer) SetIamPolicy(context.Context, *SetIamPolicyInterconnectAttachmentGroupRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedInterconnectAttachmentGroupsServer) TestIamPermissions(context.Context, *TestIamPermissionsInterconnectAttachmentGroupRequest) (*TestPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

// UnsafeInterconnectAttachmentGroupsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to InterconnectAttachmentGroupsServer will
// result in compilation errors.
type UnsafeInterconnectAttachmentGroupsServer interface {
	mustEmbedUnimplementedInterconnectAttachmentGroupsServer()
}

func RegisterInterconnectAttachmentGroupsServer(s grpc.ServiceRegistrar, srv InterconnectAttachmentGroupsServer) {
	s.RegisterService(&InterconnectAttachmentGroups_ServiceDesc, srv)
}

func _InterconnectAttachmentGroups_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInterconnectAttachmentGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InterconnectAttachmentGroupsServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InterconnectAttachmentGroups_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InterconnectAttachmentGroupsServer).Delete(ctx, req.(*DeleteInterconnectAttachmentGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InterconnectAttachmentGroups_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInterconnectAttachmentGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InterconnectAttachmentGroupsServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InterconnectAttachmentGroups_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InterconnectAttachmentGroupsServer).Get(ctx, req.(*GetInterconnectAttachmentGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InterconnectAttachmentGroups_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIamPolicyInterconnectAttachmentGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InterconnectAttachmentGroupsServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InterconnectAttachmentGroups_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InterconnectAttachmentGroupsServer).GetIamPolicy(ctx, req.(*GetIamPolicyInterconnectAttachmentGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InterconnectAttachmentGroups_GetOperationalStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOperationalStatusInterconnectAttachmentGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InterconnectAttachmentGroupsServer).GetOperationalStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InterconnectAttachmentGroups_GetOperationalStatus_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InterconnectAttachmentGroupsServer).GetOperationalStatus(ctx, req.(*GetOperationalStatusInterconnectAttachmentGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InterconnectAttachmentGroups_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertInterconnectAttachmentGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InterconnectAttachmentGroupsServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InterconnectAttachmentGroups_Insert_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InterconnectAttachmentGroupsServer).Insert(ctx, req.(*InsertInterconnectAttachmentGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InterconnectAttachmentGroups_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInterconnectAttachmentGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InterconnectAttachmentGroupsServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InterconnectAttachmentGroups_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InterconnectAttachmentGroupsServer).List(ctx, req.(*ListInterconnectAttachmentGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InterconnectAttachmentGroups_Patch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchInterconnectAttachmentGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InterconnectAttachmentGroupsServer).Patch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InterconnectAttachmentGroups_Patch_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InterconnectAttachmentGroupsServer).Patch(ctx, req.(*PatchInterconnectAttachmentGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InterconnectAttachmentGroups_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetIamPolicyInterconnectAttachmentGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InterconnectAttachmentGroupsServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InterconnectAttachmentGroups_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InterconnectAttachmentGroupsServer).SetIamPolicy(ctx, req.(*SetIamPolicyInterconnectAttachmentGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InterconnectAttachmentGroups_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TestIamPermissionsInterconnectAttachmentGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InterconnectAttachmentGroupsServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InterconnectAttachmentGroups_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InterconnectAttachmentGroupsServer).TestIamPermissions(ctx, req.(*TestIamPermissionsInterconnectAttachmentGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// InterconnectAttachmentGroups_ServiceDesc is the grpc.ServiceDesc for InterconnectAttachmentGroups service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var InterconnectAttachmentGroups_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.InterconnectAttachmentGroups",
	HandlerType: (*InterconnectAttachmentGroupsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Delete",
			Handler:    _InterconnectAttachmentGroups_Delete_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _InterconnectAttachmentGroups_Get_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _InterconnectAttachmentGroups_GetIamPolicy_Handler,
		},
		{
			MethodName: "GetOperationalStatus",
			Handler:    _InterconnectAttachmentGroups_GetOperationalStatus_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _InterconnectAttachmentGroups_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _InterconnectAttachmentGroups_List_Handler,
		},
		{
			MethodName: "Patch",
			Handler:    _InterconnectAttachmentGroups_Patch_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _InterconnectAttachmentGroups_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _InterconnectAttachmentGroups_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	InterconnectAttachments_AggregatedList_FullMethodName     = "/google.cloud.compute.v1beta.InterconnectAttachments/AggregatedList"
	InterconnectAttachments_Delete_FullMethodName             = "/google.cloud.compute.v1beta.InterconnectAttachments/Delete"
	InterconnectAttachments_Get_FullMethodName                = "/google.cloud.compute.v1beta.InterconnectAttachments/Get"
	InterconnectAttachments_Insert_FullMethodName             = "/google.cloud.compute.v1beta.InterconnectAttachments/Insert"
	InterconnectAttachments_List_FullMethodName               = "/google.cloud.compute.v1beta.InterconnectAttachments/List"
	InterconnectAttachments_Patch_FullMethodName              = "/google.cloud.compute.v1beta.InterconnectAttachments/Patch"
	InterconnectAttachments_SetLabels_FullMethodName          = "/google.cloud.compute.v1beta.InterconnectAttachments/SetLabels"
	InterconnectAttachments_TestIamPermissions_FullMethodName = "/google.cloud.compute.v1beta.InterconnectAttachments/TestIamPermissions"
)

// InterconnectAttachmentsClient is the client API for InterconnectAttachments service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type InterconnectAttachmentsClient interface {
	// Retrieves an aggregated list of interconnect attachments. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(ctx context.Context, in *AggregatedListInterconnectAttachmentsRequest, opts ...grpc.CallOption) (*InterconnectAttachmentAggregatedList, error)
	// Deletes the specified interconnect attachment.
	Delete(ctx context.Context, in *DeleteInterconnectAttachmentRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns the specified interconnect attachment.
	Get(ctx context.Context, in *GetInterconnectAttachmentRequest, opts ...grpc.CallOption) (*InterconnectAttachment, error)
	// Creates an InterconnectAttachment in the specified project using the data included in the request.
	Insert(ctx context.Context, in *InsertInterconnectAttachmentRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves the list of interconnect attachments contained within the specified region.
	List(ctx context.Context, in *ListInterconnectAttachmentsRequest, opts ...grpc.CallOption) (*InterconnectAttachmentList, error)
	// Updates the specified interconnect attachment with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
	Patch(ctx context.Context, in *PatchInterconnectAttachmentRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the labels on an InterconnectAttachment. To learn more about labels, read the Labeling Resources documentation.
	SetLabels(ctx context.Context, in *SetLabelsInterconnectAttachmentRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(ctx context.Context, in *TestIamPermissionsInterconnectAttachmentRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error)
}

type interconnectAttachmentsClient struct {
	cc grpc.ClientConnInterface
}

func NewInterconnectAttachmentsClient(cc grpc.ClientConnInterface) InterconnectAttachmentsClient {
	return &interconnectAttachmentsClient{cc}
}

func (c *interconnectAttachmentsClient) AggregatedList(ctx context.Context, in *AggregatedListInterconnectAttachmentsRequest, opts ...grpc.CallOption) (*InterconnectAttachmentAggregatedList, error) {
	out := new(InterconnectAttachmentAggregatedList)
	err := c.cc.Invoke(ctx, InterconnectAttachments_AggregatedList_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *interconnectAttachmentsClient) Delete(ctx context.Context, in *DeleteInterconnectAttachmentRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InterconnectAttachments_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *interconnectAttachmentsClient) Get(ctx context.Context, in *GetInterconnectAttachmentRequest, opts ...grpc.CallOption) (*InterconnectAttachment, error) {
	out := new(InterconnectAttachment)
	err := c.cc.Invoke(ctx, InterconnectAttachments_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *interconnectAttachmentsClient) Insert(ctx context.Context, in *InsertInterconnectAttachmentRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InterconnectAttachments_Insert_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *interconnectAttachmentsClient) List(ctx context.Context, in *ListInterconnectAttachmentsRequest, opts ...grpc.CallOption) (*InterconnectAttachmentList, error) {
	out := new(InterconnectAttachmentList)
	err := c.cc.Invoke(ctx, InterconnectAttachments_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *interconnectAttachmentsClient) Patch(ctx context.Context, in *PatchInterconnectAttachmentRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InterconnectAttachments_Patch_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *interconnectAttachmentsClient) SetLabels(ctx context.Context, in *SetLabelsInterconnectAttachmentRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InterconnectAttachments_SetLabels_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *interconnectAttachmentsClient) TestIamPermissions(ctx context.Context, in *TestIamPermissionsInterconnectAttachmentRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error) {
	out := new(TestPermissionsResponse)
	err := c.cc.Invoke(ctx, InterconnectAttachments_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// InterconnectAttachmentsServer is the server API for InterconnectAttachments service.
// All implementations should embed UnimplementedInterconnectAttachmentsServer
// for forward compatibility
type InterconnectAttachmentsServer interface {
	// Retrieves an aggregated list of interconnect attachments. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(context.Context, *AggregatedListInterconnectAttachmentsRequest) (*InterconnectAttachmentAggregatedList, error)
	// Deletes the specified interconnect attachment.
	Delete(context.Context, *DeleteInterconnectAttachmentRequest) (*Operation, error)
	// Returns the specified interconnect attachment.
	Get(context.Context, *GetInterconnectAttachmentRequest) (*InterconnectAttachment, error)
	// Creates an InterconnectAttachment in the specified project using the data included in the request.
	Insert(context.Context, *InsertInterconnectAttachmentRequest) (*Operation, error)
	// Retrieves the list of interconnect attachments contained within the specified region.
	List(context.Context, *ListInterconnectAttachmentsRequest) (*InterconnectAttachmentList, error)
	// Updates the specified interconnect attachment with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
	Patch(context.Context, *PatchInterconnectAttachmentRequest) (*Operation, error)
	// Sets the labels on an InterconnectAttachment. To learn more about labels, read the Labeling Resources documentation.
	SetLabels(context.Context, *SetLabelsInterconnectAttachmentRequest) (*Operation, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(context.Context, *TestIamPermissionsInterconnectAttachmentRequest) (*TestPermissionsResponse, error)
}

// UnimplementedInterconnectAttachmentsServer should be embedded to have forward compatible implementations.
type UnimplementedInterconnectAttachmentsServer struct {
}

func (UnimplementedInterconnectAttachmentsServer) AggregatedList(context.Context, *AggregatedListInterconnectAttachmentsRequest) (*InterconnectAttachmentAggregatedList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AggregatedList not implemented")
}
func (UnimplementedInterconnectAttachmentsServer) Delete(context.Context, *DeleteInterconnectAttachmentRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedInterconnectAttachmentsServer) Get(context.Context, *GetInterconnectAttachmentRequest) (*InterconnectAttachment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedInterconnectAttachmentsServer) Insert(context.Context, *InsertInterconnectAttachmentRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (UnimplementedInterconnectAttachmentsServer) List(context.Context, *ListInterconnectAttachmentsRequest) (*InterconnectAttachmentList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedInterconnectAttachmentsServer) Patch(context.Context, *PatchInterconnectAttachmentRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Patch not implemented")
}
func (UnimplementedInterconnectAttachmentsServer) SetLabels(context.Context, *SetLabelsInterconnectAttachmentRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetLabels not implemented")
}
func (UnimplementedInterconnectAttachmentsServer) TestIamPermissions(context.Context, *TestIamPermissionsInterconnectAttachmentRequest) (*TestPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

// UnsafeInterconnectAttachmentsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to InterconnectAttachmentsServer will
// result in compilation errors.
type UnsafeInterconnectAttachmentsServer interface {
	mustEmbedUnimplementedInterconnectAttachmentsServer()
}

func RegisterInterconnectAttachmentsServer(s grpc.ServiceRegistrar, srv InterconnectAttachmentsServer) {
	s.RegisterService(&InterconnectAttachments_ServiceDesc, srv)
}

func _InterconnectAttachments_AggregatedList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AggregatedListInterconnectAttachmentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InterconnectAttachmentsServer).AggregatedList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InterconnectAttachments_AggregatedList_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InterconnectAttachmentsServer).AggregatedList(ctx, req.(*AggregatedListInterconnectAttachmentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InterconnectAttachments_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInterconnectAttachmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InterconnectAttachmentsServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InterconnectAttachments_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InterconnectAttachmentsServer).Delete(ctx, req.(*DeleteInterconnectAttachmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InterconnectAttachments_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInterconnectAttachmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InterconnectAttachmentsServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InterconnectAttachments_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InterconnectAttachmentsServer).Get(ctx, req.(*GetInterconnectAttachmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InterconnectAttachments_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertInterconnectAttachmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InterconnectAttachmentsServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InterconnectAttachments_Insert_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InterconnectAttachmentsServer).Insert(ctx, req.(*InsertInterconnectAttachmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InterconnectAttachments_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInterconnectAttachmentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InterconnectAttachmentsServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InterconnectAttachments_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InterconnectAttachmentsServer).List(ctx, req.(*ListInterconnectAttachmentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InterconnectAttachments_Patch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchInterconnectAttachmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InterconnectAttachmentsServer).Patch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InterconnectAttachments_Patch_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InterconnectAttachmentsServer).Patch(ctx, req.(*PatchInterconnectAttachmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InterconnectAttachments_SetLabels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetLabelsInterconnectAttachmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InterconnectAttachmentsServer).SetLabels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InterconnectAttachments_SetLabels_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InterconnectAttachmentsServer).SetLabels(ctx, req.(*SetLabelsInterconnectAttachmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InterconnectAttachments_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TestIamPermissionsInterconnectAttachmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InterconnectAttachmentsServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InterconnectAttachments_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InterconnectAttachmentsServer).TestIamPermissions(ctx, req.(*TestIamPermissionsInterconnectAttachmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// InterconnectAttachments_ServiceDesc is the grpc.ServiceDesc for InterconnectAttachments service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var InterconnectAttachments_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.InterconnectAttachments",
	HandlerType: (*InterconnectAttachmentsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AggregatedList",
			Handler:    _InterconnectAttachments_AggregatedList_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _InterconnectAttachments_Delete_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _InterconnectAttachments_Get_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _InterconnectAttachments_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _InterconnectAttachments_List_Handler,
		},
		{
			MethodName: "Patch",
			Handler:    _InterconnectAttachments_Patch_Handler,
		},
		{
			MethodName: "SetLabels",
			Handler:    _InterconnectAttachments_SetLabels_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _InterconnectAttachments_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	InterconnectGroups_CreateMembers_FullMethodName        = "/google.cloud.compute.v1beta.InterconnectGroups/CreateMembers"
	InterconnectGroups_Delete_FullMethodName               = "/google.cloud.compute.v1beta.InterconnectGroups/Delete"
	InterconnectGroups_Get_FullMethodName                  = "/google.cloud.compute.v1beta.InterconnectGroups/Get"
	InterconnectGroups_GetIamPolicy_FullMethodName         = "/google.cloud.compute.v1beta.InterconnectGroups/GetIamPolicy"
	InterconnectGroups_GetOperationalStatus_FullMethodName = "/google.cloud.compute.v1beta.InterconnectGroups/GetOperationalStatus"
	InterconnectGroups_Insert_FullMethodName               = "/google.cloud.compute.v1beta.InterconnectGroups/Insert"
	InterconnectGroups_List_FullMethodName                 = "/google.cloud.compute.v1beta.InterconnectGroups/List"
	InterconnectGroups_Patch_FullMethodName                = "/google.cloud.compute.v1beta.InterconnectGroups/Patch"
	InterconnectGroups_SetIamPolicy_FullMethodName         = "/google.cloud.compute.v1beta.InterconnectGroups/SetIamPolicy"
	InterconnectGroups_TestIamPermissions_FullMethodName   = "/google.cloud.compute.v1beta.InterconnectGroups/TestIamPermissions"
)

// InterconnectGroupsClient is the client API for InterconnectGroups service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type InterconnectGroupsClient interface {
	// Create Interconnects with redundancy by creating them in a specified interconnect group.
	CreateMembers(ctx context.Context, in *CreateMembersInterconnectGroupRequest, opts ...grpc.CallOption) (*Operation, error)
	// Deletes the specified InterconnectGroup in the given scope
	Delete(ctx context.Context, in *DeleteInterconnectGroupRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns the specified InterconnectGroup resource in the given scope.
	Get(ctx context.Context, in *GetInterconnectGroupRequest, opts ...grpc.CallOption) (*InterconnectGroup, error)
	// Gets the access control policy for a resource. May be empty if no such policy or resource exists.
	GetIamPolicy(ctx context.Context, in *GetIamPolicyInterconnectGroupRequest, opts ...grpc.CallOption) (*Policy, error)
	// Returns the interconnectStatuses for the specified InterconnectGroup.
	GetOperationalStatus(ctx context.Context, in *GetOperationalStatusInterconnectGroupRequest, opts ...grpc.CallOption) (*InterconnectGroupsGetOperationalStatusResponse, error)
	// Creates a InterconnectGroup in the specified project in the given scope using the parameters that are included in the request.
	Insert(ctx context.Context, in *InsertInterconnectGroupRequest, opts ...grpc.CallOption) (*Operation, error)
	// Lists the InterconnectGroups for a project in the given scope.
	List(ctx context.Context, in *ListInterconnectGroupsRequest, opts ...grpc.CallOption) (*InterconnectGroupsListResponse, error)
	// Patches the specified InterconnectGroup resource with the data included in the request. This method supports PATCH semantics and uses JSON merge patch format and processing rules.
	Patch(ctx context.Context, in *PatchInterconnectGroupRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the access control policy on the specified resource. Replaces any existing policy.
	SetIamPolicy(ctx context.Context, in *SetIamPolicyInterconnectGroupRequest, opts ...grpc.CallOption) (*Policy, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(ctx context.Context, in *TestIamPermissionsInterconnectGroupRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error)
}

type interconnectGroupsClient struct {
	cc grpc.ClientConnInterface
}

func NewInterconnectGroupsClient(cc grpc.ClientConnInterface) InterconnectGroupsClient {
	return &interconnectGroupsClient{cc}
}

func (c *interconnectGroupsClient) CreateMembers(ctx context.Context, in *CreateMembersInterconnectGroupRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InterconnectGroups_CreateMembers_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *interconnectGroupsClient) Delete(ctx context.Context, in *DeleteInterconnectGroupRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InterconnectGroups_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *interconnectGroupsClient) Get(ctx context.Context, in *GetInterconnectGroupRequest, opts ...grpc.CallOption) (*InterconnectGroup, error) {
	out := new(InterconnectGroup)
	err := c.cc.Invoke(ctx, InterconnectGroups_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *interconnectGroupsClient) GetIamPolicy(ctx context.Context, in *GetIamPolicyInterconnectGroupRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, InterconnectGroups_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *interconnectGroupsClient) GetOperationalStatus(ctx context.Context, in *GetOperationalStatusInterconnectGroupRequest, opts ...grpc.CallOption) (*InterconnectGroupsGetOperationalStatusResponse, error) {
	out := new(InterconnectGroupsGetOperationalStatusResponse)
	err := c.cc.Invoke(ctx, InterconnectGroups_GetOperationalStatus_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *interconnectGroupsClient) Insert(ctx context.Context, in *InsertInterconnectGroupRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InterconnectGroups_Insert_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *interconnectGroupsClient) List(ctx context.Context, in *ListInterconnectGroupsRequest, opts ...grpc.CallOption) (*InterconnectGroupsListResponse, error) {
	out := new(InterconnectGroupsListResponse)
	err := c.cc.Invoke(ctx, InterconnectGroups_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *interconnectGroupsClient) Patch(ctx context.Context, in *PatchInterconnectGroupRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, InterconnectGroups_Patch_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *interconnectGroupsClient) SetIamPolicy(ctx context.Context, in *SetIamPolicyInterconnectGroupRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, InterconnectGroups_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *interconnectGroupsClient) TestIamPermissions(ctx context.Context, in *TestIamPermissionsInterconnectGroupRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error) {
	out := new(TestPermissionsResponse)
	err := c.cc.Invoke(ctx, InterconnectGroups_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// InterconnectGroupsServer is the server API for InterconnectGroups service.
// All implementations should embed UnimplementedInterconnectGroupsServer
// for forward compatibility
type InterconnectGroupsServer interface {
	// Create Interconnects with redundancy by creating them in a specified interconnect group.
	CreateMembers(context.Context, *CreateMembersInterconnectGroupRequest) (*Operation, error)
	// Deletes the specified InterconnectGroup in the given scope
	Delete(context.Context, *DeleteInterconnectGroupRequest) (*Operation, error)
	// Returns the specified InterconnectGroup resource in the given scope.
	Get(context.Context, *GetInterconnectGroupRequest) (*InterconnectGroup, error)
	// Gets the access control policy for a resource. May be empty if no such policy or resource exists.
	GetIamPolicy(context.Context, *GetIamPolicyInterconnectGroupRequest) (*Policy, error)
	// Returns the interconnectStatuses for the specified InterconnectGroup.
	GetOperationalStatus(context.Context, *GetOperationalStatusInterconnectGroupRequest) (*InterconnectGroupsGetOperationalStatusResponse, error)
	// Creates a InterconnectGroup in the specified project in the given scope using the parameters that are included in the request.
	Insert(context.Context, *InsertInterconnectGroupRequest) (*Operation, error)
	// Lists the InterconnectGroups for a project in the given scope.
	List(context.Context, *ListInterconnectGroupsRequest) (*InterconnectGroupsListResponse, error)
	// Patches the specified InterconnectGroup resource with the data included in the request. This method supports PATCH semantics and uses JSON merge patch format and processing rules.
	Patch(context.Context, *PatchInterconnectGroupRequest) (*Operation, error)
	// Sets the access control policy on the specified resource. Replaces any existing policy.
	SetIamPolicy(context.Context, *SetIamPolicyInterconnectGroupRequest) (*Policy, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(context.Context, *TestIamPermissionsInterconnectGroupRequest) (*TestPermissionsResponse, error)
}

// UnimplementedInterconnectGroupsServer should be embedded to have forward compatible implementations.
type UnimplementedInterconnectGroupsServer struct {
}

func (UnimplementedInterconnectGroupsServer) CreateMembers(context.Context, *CreateMembersInterconnectGroupRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateMembers not implemented")
}
func (UnimplementedInterconnectGroupsServer) Delete(context.Context, *DeleteInterconnectGroupRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedInterconnectGroupsServer) Get(context.Context, *GetInterconnectGroupRequest) (*InterconnectGroup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedInterconnectGroupsServer) GetIamPolicy(context.Context, *GetIamPolicyInterconnectGroupRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedInterconnectGroupsServer) GetOperationalStatus(context.Context, *GetOperationalStatusInterconnectGroupRequest) (*InterconnectGroupsGetOperationalStatusResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetOperationalStatus not implemented")
}
func (UnimplementedInterconnectGroupsServer) Insert(context.Context, *InsertInterconnectGroupRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (UnimplementedInterconnectGroupsServer) List(context.Context, *ListInterconnectGroupsRequest) (*InterconnectGroupsListResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedInterconnectGroupsServer) Patch(context.Context, *PatchInterconnectGroupRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Patch not implemented")
}
func (UnimplementedInterconnectGroupsServer) SetIamPolicy(context.Context, *SetIamPolicyInterconnectGroupRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedInterconnectGroupsServer) TestIamPermissions(context.Context, *TestIamPermissionsInterconnectGroupRequest) (*TestPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

// UnsafeInterconnectGroupsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to InterconnectGroupsServer will
// result in compilation errors.
type UnsafeInterconnectGroupsServer interface {
	mustEmbedUnimplementedInterconnectGroupsServer()
}

func RegisterInterconnectGroupsServer(s grpc.ServiceRegistrar, srv InterconnectGroupsServer) {
	s.RegisterService(&InterconnectGroups_ServiceDesc, srv)
}

func _InterconnectGroups_CreateMembers_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateMembersInterconnectGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InterconnectGroupsServer).CreateMembers(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InterconnectGroups_CreateMembers_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InterconnectGroupsServer).CreateMembers(ctx, req.(*CreateMembersInterconnectGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InterconnectGroups_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInterconnectGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InterconnectGroupsServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InterconnectGroups_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InterconnectGroupsServer).Delete(ctx, req.(*DeleteInterconnectGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InterconnectGroups_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInterconnectGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InterconnectGroupsServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InterconnectGroups_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InterconnectGroupsServer).Get(ctx, req.(*GetInterconnectGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InterconnectGroups_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIamPolicyInterconnectGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InterconnectGroupsServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InterconnectGroups_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InterconnectGroupsServer).GetIamPolicy(ctx, req.(*GetIamPolicyInterconnectGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InterconnectGroups_GetOperationalStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOperationalStatusInterconnectGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InterconnectGroupsServer).GetOperationalStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InterconnectGroups_GetOperationalStatus_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InterconnectGroupsServer).GetOperationalStatus(ctx, req.(*GetOperationalStatusInterconnectGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InterconnectGroups_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertInterconnectGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InterconnectGroupsServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InterconnectGroups_Insert_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InterconnectGroupsServer).Insert(ctx, req.(*InsertInterconnectGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InterconnectGroups_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInterconnectGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InterconnectGroupsServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InterconnectGroups_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InterconnectGroupsServer).List(ctx, req.(*ListInterconnectGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InterconnectGroups_Patch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchInterconnectGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InterconnectGroupsServer).Patch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InterconnectGroups_Patch_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InterconnectGroupsServer).Patch(ctx, req.(*PatchInterconnectGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InterconnectGroups_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetIamPolicyInterconnectGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InterconnectGroupsServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InterconnectGroups_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InterconnectGroupsServer).SetIamPolicy(ctx, req.(*SetIamPolicyInterconnectGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InterconnectGroups_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TestIamPermissionsInterconnectGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InterconnectGroupsServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InterconnectGroups_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InterconnectGroupsServer).TestIamPermissions(ctx, req.(*TestIamPermissionsInterconnectGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// InterconnectGroups_ServiceDesc is the grpc.ServiceDesc for InterconnectGroups service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var InterconnectGroups_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.InterconnectGroups",
	HandlerType: (*InterconnectGroupsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateMembers",
			Handler:    _InterconnectGroups_CreateMembers_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _InterconnectGroups_Delete_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _InterconnectGroups_Get_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _InterconnectGroups_GetIamPolicy_Handler,
		},
		{
			MethodName: "GetOperationalStatus",
			Handler:    _InterconnectGroups_GetOperationalStatus_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _InterconnectGroups_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _InterconnectGroups_List_Handler,
		},
		{
			MethodName: "Patch",
			Handler:    _InterconnectGroups_Patch_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _InterconnectGroups_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _InterconnectGroups_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	InterconnectLocations_Get_FullMethodName  = "/google.cloud.compute.v1beta.InterconnectLocations/Get"
	InterconnectLocations_List_FullMethodName = "/google.cloud.compute.v1beta.InterconnectLocations/List"
)

// InterconnectLocationsClient is the client API for InterconnectLocations service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type InterconnectLocationsClient interface {
	// Returns the details for the specified interconnect location. Gets a list of available interconnect locations by making a list() request.
	Get(ctx context.Context, in *GetInterconnectLocationRequest, opts ...grpc.CallOption) (*InterconnectLocation, error)
	// Retrieves the list of interconnect locations available to the specified project.
	List(ctx context.Context, in *ListInterconnectLocationsRequest, opts ...grpc.CallOption) (*InterconnectLocationList, error)
}

type interconnectLocationsClient struct {
	cc grpc.ClientConnInterface
}

func NewInterconnectLocationsClient(cc grpc.ClientConnInterface) InterconnectLocationsClient {
	return &interconnectLocationsClient{cc}
}

func (c *interconnectLocationsClient) Get(ctx context.Context, in *GetInterconnectLocationRequest, opts ...grpc.CallOption) (*InterconnectLocation, error) {
	out := new(InterconnectLocation)
	err := c.cc.Invoke(ctx, InterconnectLocations_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *interconnectLocationsClient) List(ctx context.Context, in *ListInterconnectLocationsRequest, opts ...grpc.CallOption) (*InterconnectLocationList, error) {
	out := new(InterconnectLocationList)
	err := c.cc.Invoke(ctx, InterconnectLocations_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// InterconnectLocationsServer is the server API for InterconnectLocations service.
// All implementations should embed UnimplementedInterconnectLocationsServer
// for forward compatibility
type InterconnectLocationsServer interface {
	// Returns the details for the specified interconnect location. Gets a list of available interconnect locations by making a list() request.
	Get(context.Context, *GetInterconnectLocationRequest) (*InterconnectLocation, error)
	// Retrieves the list of interconnect locations available to the specified project.
	List(context.Context, *ListInterconnectLocationsRequest) (*InterconnectLocationList, error)
}

// UnimplementedInterconnectLocationsServer should be embedded to have forward compatible implementations.
type UnimplementedInterconnectLocationsServer struct {
}

func (UnimplementedInterconnectLocationsServer) Get(context.Context, *GetInterconnectLocationRequest) (*InterconnectLocation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedInterconnectLocationsServer) List(context.Context, *ListInterconnectLocationsRequest) (*InterconnectLocationList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}

// UnsafeInterconnectLocationsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to InterconnectLocationsServer will
// result in compilation errors.
type UnsafeInterconnectLocationsServer interface {
	mustEmbedUnimplementedInterconnectLocationsServer()
}

func RegisterInterconnectLocationsServer(s grpc.ServiceRegistrar, srv InterconnectLocationsServer) {
	s.RegisterService(&InterconnectLocations_ServiceDesc, srv)
}

func _InterconnectLocations_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInterconnectLocationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InterconnectLocationsServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InterconnectLocations_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InterconnectLocationsServer).Get(ctx, req.(*GetInterconnectLocationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InterconnectLocations_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInterconnectLocationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InterconnectLocationsServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InterconnectLocations_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InterconnectLocationsServer).List(ctx, req.(*ListInterconnectLocationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// InterconnectLocations_ServiceDesc is the grpc.ServiceDesc for InterconnectLocations service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var InterconnectLocations_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.InterconnectLocations",
	HandlerType: (*InterconnectLocationsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _InterconnectLocations_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _InterconnectLocations_List_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	InterconnectRemoteLocations_Get_FullMethodName  = "/google.cloud.compute.v1beta.InterconnectRemoteLocations/Get"
	InterconnectRemoteLocations_List_FullMethodName = "/google.cloud.compute.v1beta.InterconnectRemoteLocations/List"
)

// InterconnectRemoteLocationsClient is the client API for InterconnectRemoteLocations service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type InterconnectRemoteLocationsClient interface {
	// Returns the details for the specified interconnect remote location. Gets a list of available interconnect remote locations by making a list() request.
	Get(ctx context.Context, in *GetInterconnectRemoteLocationRequest, opts ...grpc.CallOption) (*InterconnectRemoteLocation, error)
	// Retrieves the list of interconnect remote locations available to the specified project.
	List(ctx context.Context, in *ListInterconnectRemoteLocationsRequest, opts ...grpc.CallOption) (*InterconnectRemoteLocationList, error)
}

type interconnectRemoteLocationsClient struct {
	cc grpc.ClientConnInterface
}

func NewInterconnectRemoteLocationsClient(cc grpc.ClientConnInterface) InterconnectRemoteLocationsClient {
	return &interconnectRemoteLocationsClient{cc}
}

func (c *interconnectRemoteLocationsClient) Get(ctx context.Context, in *GetInterconnectRemoteLocationRequest, opts ...grpc.CallOption) (*InterconnectRemoteLocation, error) {
	out := new(InterconnectRemoteLocation)
	err := c.cc.Invoke(ctx, InterconnectRemoteLocations_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *interconnectRemoteLocationsClient) List(ctx context.Context, in *ListInterconnectRemoteLocationsRequest, opts ...grpc.CallOption) (*InterconnectRemoteLocationList, error) {
	out := new(InterconnectRemoteLocationList)
	err := c.cc.Invoke(ctx, InterconnectRemoteLocations_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// InterconnectRemoteLocationsServer is the server API for InterconnectRemoteLocations service.
// All implementations should embed UnimplementedInterconnectRemoteLocationsServer
// for forward compatibility
type InterconnectRemoteLocationsServer interface {
	// Returns the details for the specified interconnect remote location. Gets a list of available interconnect remote locations by making a list() request.
	Get(context.Context, *GetInterconnectRemoteLocationRequest) (*InterconnectRemoteLocation, error)
	// Retrieves the list of interconnect remote locations available to the specified project.
	List(context.Context, *ListInterconnectRemoteLocationsRequest) (*InterconnectRemoteLocationList, error)
}

// UnimplementedInterconnectRemoteLocationsServer should be embedded to have forward compatible implementations.
type UnimplementedInterconnectRemoteLocationsServer struct {
}

func (UnimplementedInterconnectRemoteLocationsServer) Get(context.Context, *GetInterconnectRemoteLocationRequest) (*InterconnectRemoteLocation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedInterconnectRemoteLocationsServer) List(context.Context, *ListInterconnectRemoteLocationsRequest) (*InterconnectRemoteLocationList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}

// UnsafeInterconnectRemoteLocationsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to InterconnectRemoteLocationsServer will
// result in compilation errors.
type UnsafeInterconnectRemoteLocationsServer interface {
	mustEmbedUnimplementedInterconnectRemoteLocationsServer()
}

func RegisterInterconnectRemoteLocationsServer(s grpc.ServiceRegistrar, srv InterconnectRemoteLocationsServer) {
	s.RegisterService(&InterconnectRemoteLocations_ServiceDesc, srv)
}

func _InterconnectRemoteLocations_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInterconnectRemoteLocationRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InterconnectRemoteLocationsServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InterconnectRemoteLocations_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InterconnectRemoteLocationsServer).Get(ctx, req.(*GetInterconnectRemoteLocationRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _InterconnectRemoteLocations_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInterconnectRemoteLocationsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InterconnectRemoteLocationsServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: InterconnectRemoteLocations_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InterconnectRemoteLocationsServer).List(ctx, req.(*ListInterconnectRemoteLocationsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// InterconnectRemoteLocations_ServiceDesc is the grpc.ServiceDesc for InterconnectRemoteLocations service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var InterconnectRemoteLocations_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.InterconnectRemoteLocations",
	HandlerType: (*InterconnectRemoteLocationsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _InterconnectRemoteLocations_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _InterconnectRemoteLocations_List_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	Interconnects_Delete_FullMethodName             = "/google.cloud.compute.v1beta.Interconnects/Delete"
	Interconnects_Get_FullMethodName                = "/google.cloud.compute.v1beta.Interconnects/Get"
	Interconnects_GetDiagnostics_FullMethodName     = "/google.cloud.compute.v1beta.Interconnects/GetDiagnostics"
	Interconnects_GetMacsecConfig_FullMethodName    = "/google.cloud.compute.v1beta.Interconnects/GetMacsecConfig"
	Interconnects_Insert_FullMethodName             = "/google.cloud.compute.v1beta.Interconnects/Insert"
	Interconnects_List_FullMethodName               = "/google.cloud.compute.v1beta.Interconnects/List"
	Interconnects_Patch_FullMethodName              = "/google.cloud.compute.v1beta.Interconnects/Patch"
	Interconnects_SetLabels_FullMethodName          = "/google.cloud.compute.v1beta.Interconnects/SetLabels"
	Interconnects_TestIamPermissions_FullMethodName = "/google.cloud.compute.v1beta.Interconnects/TestIamPermissions"
)

// InterconnectsClient is the client API for Interconnects service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type InterconnectsClient interface {
	// Deletes the specified Interconnect.
	Delete(ctx context.Context, in *DeleteInterconnectRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns the specified Interconnect. Get a list of available Interconnects by making a list() request.
	Get(ctx context.Context, in *GetInterconnectRequest, opts ...grpc.CallOption) (*Interconnect, error)
	// Returns the interconnectDiagnostics for the specified Interconnect. In the event of a global outage, do not use this API to make decisions about where to redirect your network traffic. Unlike a VLAN attachment, which is regional, a Cloud Interconnect connection is a global resource. A global outage can prevent this API from functioning properly.
	GetDiagnostics(ctx context.Context, in *GetDiagnosticsInterconnectRequest, opts ...grpc.CallOption) (*InterconnectsGetDiagnosticsResponse, error)
	// Returns the interconnectMacsecConfig for the specified Interconnect.
	GetMacsecConfig(ctx context.Context, in *GetMacsecConfigInterconnectRequest, opts ...grpc.CallOption) (*InterconnectsGetMacsecConfigResponse, error)
	// Creates an Interconnect in the specified project using the data included in the request.
	Insert(ctx context.Context, in *InsertInterconnectRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves the list of Interconnects available to the specified project.
	List(ctx context.Context, in *ListInterconnectsRequest, opts ...grpc.CallOption) (*InterconnectList, error)
	// Updates the specified Interconnect with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
	Patch(ctx context.Context, in *PatchInterconnectRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the labels on an Interconnect. To learn more about labels, read the Labeling Resources documentation.
	SetLabels(ctx context.Context, in *SetLabelsInterconnectRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(ctx context.Context, in *TestIamPermissionsInterconnectRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error)
}

type interconnectsClient struct {
	cc grpc.ClientConnInterface
}

func NewInterconnectsClient(cc grpc.ClientConnInterface) InterconnectsClient {
	return &interconnectsClient{cc}
}

func (c *interconnectsClient) Delete(ctx context.Context, in *DeleteInterconnectRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Interconnects_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *interconnectsClient) Get(ctx context.Context, in *GetInterconnectRequest, opts ...grpc.CallOption) (*Interconnect, error) {
	out := new(Interconnect)
	err := c.cc.Invoke(ctx, Interconnects_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *interconnectsClient) GetDiagnostics(ctx context.Context, in *GetDiagnosticsInterconnectRequest, opts ...grpc.CallOption) (*InterconnectsGetDiagnosticsResponse, error) {
	out := new(InterconnectsGetDiagnosticsResponse)
	err := c.cc.Invoke(ctx, Interconnects_GetDiagnostics_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *interconnectsClient) GetMacsecConfig(ctx context.Context, in *GetMacsecConfigInterconnectRequest, opts ...grpc.CallOption) (*InterconnectsGetMacsecConfigResponse, error) {
	out := new(InterconnectsGetMacsecConfigResponse)
	err := c.cc.Invoke(ctx, Interconnects_GetMacsecConfig_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *interconnectsClient) Insert(ctx context.Context, in *InsertInterconnectRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Interconnects_Insert_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *interconnectsClient) List(ctx context.Context, in *ListInterconnectsRequest, opts ...grpc.CallOption) (*InterconnectList, error) {
	out := new(InterconnectList)
	err := c.cc.Invoke(ctx, Interconnects_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *interconnectsClient) Patch(ctx context.Context, in *PatchInterconnectRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Interconnects_Patch_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *interconnectsClient) SetLabels(ctx context.Context, in *SetLabelsInterconnectRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Interconnects_SetLabels_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *interconnectsClient) TestIamPermissions(ctx context.Context, in *TestIamPermissionsInterconnectRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error) {
	out := new(TestPermissionsResponse)
	err := c.cc.Invoke(ctx, Interconnects_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// InterconnectsServer is the server API for Interconnects service.
// All implementations should embed UnimplementedInterconnectsServer
// for forward compatibility
type InterconnectsServer interface {
	// Deletes the specified Interconnect.
	Delete(context.Context, *DeleteInterconnectRequest) (*Operation, error)
	// Returns the specified Interconnect. Get a list of available Interconnects by making a list() request.
	Get(context.Context, *GetInterconnectRequest) (*Interconnect, error)
	// Returns the interconnectDiagnostics for the specified Interconnect. In the event of a global outage, do not use this API to make decisions about where to redirect your network traffic. Unlike a VLAN attachment, which is regional, a Cloud Interconnect connection is a global resource. A global outage can prevent this API from functioning properly.
	GetDiagnostics(context.Context, *GetDiagnosticsInterconnectRequest) (*InterconnectsGetDiagnosticsResponse, error)
	// Returns the interconnectMacsecConfig for the specified Interconnect.
	GetMacsecConfig(context.Context, *GetMacsecConfigInterconnectRequest) (*InterconnectsGetMacsecConfigResponse, error)
	// Creates an Interconnect in the specified project using the data included in the request.
	Insert(context.Context, *InsertInterconnectRequest) (*Operation, error)
	// Retrieves the list of Interconnects available to the specified project.
	List(context.Context, *ListInterconnectsRequest) (*InterconnectList, error)
	// Updates the specified Interconnect with the data included in the request. This method supports PATCH semantics and uses the JSON merge patch format and processing rules.
	Patch(context.Context, *PatchInterconnectRequest) (*Operation, error)
	// Sets the labels on an Interconnect. To learn more about labels, read the Labeling Resources documentation.
	SetLabels(context.Context, *SetLabelsInterconnectRequest) (*Operation, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(context.Context, *TestIamPermissionsInterconnectRequest) (*TestPermissionsResponse, error)
}

// UnimplementedInterconnectsServer should be embedded to have forward compatible implementations.
type UnimplementedInterconnectsServer struct {
}

func (UnimplementedInterconnectsServer) Delete(context.Context, *DeleteInterconnectRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedInterconnectsServer) Get(context.Context, *GetInterconnectRequest) (*Interconnect, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedInterconnectsServer) GetDiagnostics(context.Context, *GetDiagnosticsInterconnectRequest) (*InterconnectsGetDiagnosticsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetDiagnostics not implemented")
}
func (UnimplementedInterconnectsServer) GetMacsecConfig(context.Context, *GetMacsecConfigInterconnectRequest) (*InterconnectsGetMacsecConfigResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetMacsecConfig not implemented")
}
func (UnimplementedInterconnectsServer) Insert(context.Context, *InsertInterconnectRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (UnimplementedInterconnectsServer) List(context.Context, *ListInterconnectsRequest) (*InterconnectList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedInterconnectsServer) Patch(context.Context, *PatchInterconnectRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Patch not implemented")
}
func (UnimplementedInterconnectsServer) SetLabels(context.Context, *SetLabelsInterconnectRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetLabels not implemented")
}
func (UnimplementedInterconnectsServer) TestIamPermissions(context.Context, *TestIamPermissionsInterconnectRequest) (*TestPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

// UnsafeInterconnectsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to InterconnectsServer will
// result in compilation errors.
type UnsafeInterconnectsServer interface {
	mustEmbedUnimplementedInterconnectsServer()
}

func RegisterInterconnectsServer(s grpc.ServiceRegistrar, srv InterconnectsServer) {
	s.RegisterService(&Interconnects_ServiceDesc, srv)
}

func _Interconnects_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteInterconnectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InterconnectsServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Interconnects_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InterconnectsServer).Delete(ctx, req.(*DeleteInterconnectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Interconnects_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetInterconnectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InterconnectsServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Interconnects_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InterconnectsServer).Get(ctx, req.(*GetInterconnectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Interconnects_GetDiagnostics_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDiagnosticsInterconnectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InterconnectsServer).GetDiagnostics(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Interconnects_GetDiagnostics_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InterconnectsServer).GetDiagnostics(ctx, req.(*GetDiagnosticsInterconnectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Interconnects_GetMacsecConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMacsecConfigInterconnectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InterconnectsServer).GetMacsecConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Interconnects_GetMacsecConfig_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InterconnectsServer).GetMacsecConfig(ctx, req.(*GetMacsecConfigInterconnectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Interconnects_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertInterconnectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InterconnectsServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Interconnects_Insert_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InterconnectsServer).Insert(ctx, req.(*InsertInterconnectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Interconnects_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListInterconnectsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InterconnectsServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Interconnects_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InterconnectsServer).List(ctx, req.(*ListInterconnectsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Interconnects_Patch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchInterconnectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InterconnectsServer).Patch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Interconnects_Patch_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InterconnectsServer).Patch(ctx, req.(*PatchInterconnectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Interconnects_SetLabels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetLabelsInterconnectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InterconnectsServer).SetLabels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Interconnects_SetLabels_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InterconnectsServer).SetLabels(ctx, req.(*SetLabelsInterconnectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Interconnects_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TestIamPermissionsInterconnectRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(InterconnectsServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Interconnects_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(InterconnectsServer).TestIamPermissions(ctx, req.(*TestIamPermissionsInterconnectRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Interconnects_ServiceDesc is the grpc.ServiceDesc for Interconnects service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Interconnects_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.Interconnects",
	HandlerType: (*InterconnectsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Delete",
			Handler:    _Interconnects_Delete_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _Interconnects_Get_Handler,
		},
		{
			MethodName: "GetDiagnostics",
			Handler:    _Interconnects_GetDiagnostics_Handler,
		},
		{
			MethodName: "GetMacsecConfig",
			Handler:    _Interconnects_GetMacsecConfig_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _Interconnects_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _Interconnects_List_Handler,
		},
		{
			MethodName: "Patch",
			Handler:    _Interconnects_Patch_Handler,
		},
		{
			MethodName: "SetLabels",
			Handler:    _Interconnects_SetLabels_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _Interconnects_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	LicenseCodes_Get_FullMethodName                = "/google.cloud.compute.v1beta.LicenseCodes/Get"
	LicenseCodes_TestIamPermissions_FullMethodName = "/google.cloud.compute.v1beta.LicenseCodes/TestIamPermissions"
)

// LicenseCodesClient is the client API for LicenseCodes service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type LicenseCodesClient interface {
	// Return a specified license code. License codes are mirrored across all projects that have permissions to read the License Code. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images.
	Get(ctx context.Context, in *GetLicenseCodeRequest, opts ...grpc.CallOption) (*LicenseCode, error)
	// Returns permissions that a caller has on the specified resource. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images.
	TestIamPermissions(ctx context.Context, in *TestIamPermissionsLicenseCodeRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error)
}

type licenseCodesClient struct {
	cc grpc.ClientConnInterface
}

func NewLicenseCodesClient(cc grpc.ClientConnInterface) LicenseCodesClient {
	return &licenseCodesClient{cc}
}

func (c *licenseCodesClient) Get(ctx context.Context, in *GetLicenseCodeRequest, opts ...grpc.CallOption) (*LicenseCode, error) {
	out := new(LicenseCode)
	err := c.cc.Invoke(ctx, LicenseCodes_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *licenseCodesClient) TestIamPermissions(ctx context.Context, in *TestIamPermissionsLicenseCodeRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error) {
	out := new(TestPermissionsResponse)
	err := c.cc.Invoke(ctx, LicenseCodes_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// LicenseCodesServer is the server API for LicenseCodes service.
// All implementations should embed UnimplementedLicenseCodesServer
// for forward compatibility
type LicenseCodesServer interface {
	// Return a specified license code. License codes are mirrored across all projects that have permissions to read the License Code. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images.
	Get(context.Context, *GetLicenseCodeRequest) (*LicenseCode, error)
	// Returns permissions that a caller has on the specified resource. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images.
	TestIamPermissions(context.Context, *TestIamPermissionsLicenseCodeRequest) (*TestPermissionsResponse, error)
}

// UnimplementedLicenseCodesServer should be embedded to have forward compatible implementations.
type UnimplementedLicenseCodesServer struct {
}

func (UnimplementedLicenseCodesServer) Get(context.Context, *GetLicenseCodeRequest) (*LicenseCode, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedLicenseCodesServer) TestIamPermissions(context.Context, *TestIamPermissionsLicenseCodeRequest) (*TestPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

// UnsafeLicenseCodesServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to LicenseCodesServer will
// result in compilation errors.
type UnsafeLicenseCodesServer interface {
	mustEmbedUnimplementedLicenseCodesServer()
}

func RegisterLicenseCodesServer(s grpc.ServiceRegistrar, srv LicenseCodesServer) {
	s.RegisterService(&LicenseCodes_ServiceDesc, srv)
}

func _LicenseCodes_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLicenseCodeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LicenseCodesServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LicenseCodes_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LicenseCodesServer).Get(ctx, req.(*GetLicenseCodeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _LicenseCodes_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TestIamPermissionsLicenseCodeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LicenseCodesServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: LicenseCodes_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LicenseCodesServer).TestIamPermissions(ctx, req.(*TestIamPermissionsLicenseCodeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// LicenseCodes_ServiceDesc is the grpc.ServiceDesc for LicenseCodes service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var LicenseCodes_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.LicenseCodes",
	HandlerType: (*LicenseCodesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _LicenseCodes_Get_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _LicenseCodes_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	Licenses_Delete_FullMethodName             = "/google.cloud.compute.v1beta.Licenses/Delete"
	Licenses_Get_FullMethodName                = "/google.cloud.compute.v1beta.Licenses/Get"
	Licenses_GetIamPolicy_FullMethodName       = "/google.cloud.compute.v1beta.Licenses/GetIamPolicy"
	Licenses_Insert_FullMethodName             = "/google.cloud.compute.v1beta.Licenses/Insert"
	Licenses_List_FullMethodName               = "/google.cloud.compute.v1beta.Licenses/List"
	Licenses_SetIamPolicy_FullMethodName       = "/google.cloud.compute.v1beta.Licenses/SetIamPolicy"
	Licenses_TestIamPermissions_FullMethodName = "/google.cloud.compute.v1beta.Licenses/TestIamPermissions"
	Licenses_Update_FullMethodName             = "/google.cloud.compute.v1beta.Licenses/Update"
)

// LicensesClient is the client API for Licenses service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type LicensesClient interface {
	// Deletes the specified license. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images.
	Delete(ctx context.Context, in *DeleteLicenseRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns the specified License resource. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images.
	Get(ctx context.Context, in *GetLicenseRequest, opts ...grpc.CallOption) (*License, error)
	// Gets the access control policy for a resource. May be empty if no such policy or resource exists. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images.
	GetIamPolicy(ctx context.Context, in *GetIamPolicyLicenseRequest, opts ...grpc.CallOption) (*Policy, error)
	// Create a License resource in the specified project. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images.
	Insert(ctx context.Context, in *InsertLicenseRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves the list of licenses available in the specified project. This method does not get any licenses that belong to other projects, including licenses attached to publicly-available images, like Debian 9. If you want to get a list of publicly-available licenses, use this method to make a request to the respective image project, such as debian-cloud or windows-cloud. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images.
	List(ctx context.Context, in *ListLicensesRequest, opts ...grpc.CallOption) (*LicensesListResponse, error)
	// Sets the access control policy on the specified resource. Replaces any existing policy. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images.
	SetIamPolicy(ctx context.Context, in *SetIamPolicyLicenseRequest, opts ...grpc.CallOption) (*Policy, error)
	// Returns permissions that a caller has on the specified resource. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images.
	TestIamPermissions(ctx context.Context, in *TestIamPermissionsLicenseRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error)
	// Updates a License resource in the specified project. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images.
	Update(ctx context.Context, in *UpdateLicenseRequest, opts ...grpc.CallOption) (*Operation, error)
}

type licensesClient struct {
	cc grpc.ClientConnInterface
}

func NewLicensesClient(cc grpc.ClientConnInterface) LicensesClient {
	return &licensesClient{cc}
}

func (c *licensesClient) Delete(ctx context.Context, in *DeleteLicenseRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Licenses_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *licensesClient) Get(ctx context.Context, in *GetLicenseRequest, opts ...grpc.CallOption) (*License, error) {
	out := new(License)
	err := c.cc.Invoke(ctx, Licenses_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *licensesClient) GetIamPolicy(ctx context.Context, in *GetIamPolicyLicenseRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, Licenses_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *licensesClient) Insert(ctx context.Context, in *InsertLicenseRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Licenses_Insert_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *licensesClient) List(ctx context.Context, in *ListLicensesRequest, opts ...grpc.CallOption) (*LicensesListResponse, error) {
	out := new(LicensesListResponse)
	err := c.cc.Invoke(ctx, Licenses_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *licensesClient) SetIamPolicy(ctx context.Context, in *SetIamPolicyLicenseRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, Licenses_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *licensesClient) TestIamPermissions(ctx context.Context, in *TestIamPermissionsLicenseRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error) {
	out := new(TestPermissionsResponse)
	err := c.cc.Invoke(ctx, Licenses_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *licensesClient) Update(ctx context.Context, in *UpdateLicenseRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Licenses_Update_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// LicensesServer is the server API for Licenses service.
// All implementations should embed UnimplementedLicensesServer
// for forward compatibility
type LicensesServer interface {
	// Deletes the specified license. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images.
	Delete(context.Context, *DeleteLicenseRequest) (*Operation, error)
	// Returns the specified License resource. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images.
	Get(context.Context, *GetLicenseRequest) (*License, error)
	// Gets the access control policy for a resource. May be empty if no such policy or resource exists. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images.
	GetIamPolicy(context.Context, *GetIamPolicyLicenseRequest) (*Policy, error)
	// Create a License resource in the specified project. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images.
	Insert(context.Context, *InsertLicenseRequest) (*Operation, error)
	// Retrieves the list of licenses available in the specified project. This method does not get any licenses that belong to other projects, including licenses attached to publicly-available images, like Debian 9. If you want to get a list of publicly-available licenses, use this method to make a request to the respective image project, such as debian-cloud or windows-cloud. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images.
	List(context.Context, *ListLicensesRequest) (*LicensesListResponse, error)
	// Sets the access control policy on the specified resource. Replaces any existing policy. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images.
	SetIamPolicy(context.Context, *SetIamPolicyLicenseRequest) (*Policy, error)
	// Returns permissions that a caller has on the specified resource. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images.
	TestIamPermissions(context.Context, *TestIamPermissionsLicenseRequest) (*TestPermissionsResponse, error)
	// Updates a License resource in the specified project. *Caution* This resource is intended for use only by third-party partners who are creating Cloud Marketplace images.
	Update(context.Context, *UpdateLicenseRequest) (*Operation, error)
}

// UnimplementedLicensesServer should be embedded to have forward compatible implementations.
type UnimplementedLicensesServer struct {
}

func (UnimplementedLicensesServer) Delete(context.Context, *DeleteLicenseRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedLicensesServer) Get(context.Context, *GetLicenseRequest) (*License, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedLicensesServer) GetIamPolicy(context.Context, *GetIamPolicyLicenseRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedLicensesServer) Insert(context.Context, *InsertLicenseRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (UnimplementedLicensesServer) List(context.Context, *ListLicensesRequest) (*LicensesListResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedLicensesServer) SetIamPolicy(context.Context, *SetIamPolicyLicenseRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedLicensesServer) TestIamPermissions(context.Context, *TestIamPermissionsLicenseRequest) (*TestPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}
func (UnimplementedLicensesServer) Update(context.Context, *UpdateLicenseRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Update not implemented")
}

// UnsafeLicensesServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to LicensesServer will
// result in compilation errors.
type UnsafeLicensesServer interface {
	mustEmbedUnimplementedLicensesServer()
}

func RegisterLicensesServer(s grpc.ServiceRegistrar, srv LicensesServer) {
	s.RegisterService(&Licenses_ServiceDesc, srv)
}

func _Licenses_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteLicenseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LicensesServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Licenses_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LicensesServer).Delete(ctx, req.(*DeleteLicenseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Licenses_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetLicenseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LicensesServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Licenses_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LicensesServer).Get(ctx, req.(*GetLicenseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Licenses_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIamPolicyLicenseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LicensesServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Licenses_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LicensesServer).GetIamPolicy(ctx, req.(*GetIamPolicyLicenseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Licenses_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertLicenseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LicensesServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Licenses_Insert_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LicensesServer).Insert(ctx, req.(*InsertLicenseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Licenses_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListLicensesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LicensesServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Licenses_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LicensesServer).List(ctx, req.(*ListLicensesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Licenses_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetIamPolicyLicenseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LicensesServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Licenses_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LicensesServer).SetIamPolicy(ctx, req.(*SetIamPolicyLicenseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Licenses_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TestIamPermissionsLicenseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LicensesServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Licenses_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LicensesServer).TestIamPermissions(ctx, req.(*TestIamPermissionsLicenseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Licenses_Update_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateLicenseRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(LicensesServer).Update(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Licenses_Update_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(LicensesServer).Update(ctx, req.(*UpdateLicenseRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Licenses_ServiceDesc is the grpc.ServiceDesc for Licenses service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Licenses_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.Licenses",
	HandlerType: (*LicensesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Delete",
			Handler:    _Licenses_Delete_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _Licenses_Get_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _Licenses_GetIamPolicy_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _Licenses_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _Licenses_List_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _Licenses_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _Licenses_TestIamPermissions_Handler,
		},
		{
			MethodName: "Update",
			Handler:    _Licenses_Update_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	MachineImages_Delete_FullMethodName             = "/google.cloud.compute.v1beta.MachineImages/Delete"
	MachineImages_Get_FullMethodName                = "/google.cloud.compute.v1beta.MachineImages/Get"
	MachineImages_GetIamPolicy_FullMethodName       = "/google.cloud.compute.v1beta.MachineImages/GetIamPolicy"
	MachineImages_Insert_FullMethodName             = "/google.cloud.compute.v1beta.MachineImages/Insert"
	MachineImages_List_FullMethodName               = "/google.cloud.compute.v1beta.MachineImages/List"
	MachineImages_SetIamPolicy_FullMethodName       = "/google.cloud.compute.v1beta.MachineImages/SetIamPolicy"
	MachineImages_SetLabels_FullMethodName          = "/google.cloud.compute.v1beta.MachineImages/SetLabels"
	MachineImages_TestIamPermissions_FullMethodName = "/google.cloud.compute.v1beta.MachineImages/TestIamPermissions"
)

// MachineImagesClient is the client API for MachineImages service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type MachineImagesClient interface {
	// Deletes the specified machine image. Deleting a machine image is permanent and cannot be undone.
	Delete(ctx context.Context, in *DeleteMachineImageRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns the specified machine image.
	Get(ctx context.Context, in *GetMachineImageRequest, opts ...grpc.CallOption) (*MachineImage, error)
	// Gets the access control policy for a resource. May be empty if no such policy or resource exists.
	GetIamPolicy(ctx context.Context, in *GetIamPolicyMachineImageRequest, opts ...grpc.CallOption) (*Policy, error)
	// Creates a machine image in the specified project using the data that is included in the request. If you are creating a new machine image to update an existing instance, your new machine image should use the same network or, if applicable, the same subnetwork as the original instance.
	Insert(ctx context.Context, in *InsertMachineImageRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves a list of machine images that are contained within the specified project.
	List(ctx context.Context, in *ListMachineImagesRequest, opts ...grpc.CallOption) (*MachineImageList, error)
	// Sets the access control policy on the specified resource. Replaces any existing policy.
	SetIamPolicy(ctx context.Context, in *SetIamPolicyMachineImageRequest, opts ...grpc.CallOption) (*Policy, error)
	// Sets the labels on a machine image. To learn more about labels, read the Labeling Resources documentation.
	SetLabels(ctx context.Context, in *SetLabelsMachineImageRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(ctx context.Context, in *TestIamPermissionsMachineImageRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error)
}

type machineImagesClient struct {
	cc grpc.ClientConnInterface
}

func NewMachineImagesClient(cc grpc.ClientConnInterface) MachineImagesClient {
	return &machineImagesClient{cc}
}

func (c *machineImagesClient) Delete(ctx context.Context, in *DeleteMachineImageRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, MachineImages_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *machineImagesClient) Get(ctx context.Context, in *GetMachineImageRequest, opts ...grpc.CallOption) (*MachineImage, error) {
	out := new(MachineImage)
	err := c.cc.Invoke(ctx, MachineImages_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *machineImagesClient) GetIamPolicy(ctx context.Context, in *GetIamPolicyMachineImageRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, MachineImages_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *machineImagesClient) Insert(ctx context.Context, in *InsertMachineImageRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, MachineImages_Insert_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *machineImagesClient) List(ctx context.Context, in *ListMachineImagesRequest, opts ...grpc.CallOption) (*MachineImageList, error) {
	out := new(MachineImageList)
	err := c.cc.Invoke(ctx, MachineImages_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *machineImagesClient) SetIamPolicy(ctx context.Context, in *SetIamPolicyMachineImageRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, MachineImages_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *machineImagesClient) SetLabels(ctx context.Context, in *SetLabelsMachineImageRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, MachineImages_SetLabels_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *machineImagesClient) TestIamPermissions(ctx context.Context, in *TestIamPermissionsMachineImageRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error) {
	out := new(TestPermissionsResponse)
	err := c.cc.Invoke(ctx, MachineImages_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// MachineImagesServer is the server API for MachineImages service.
// All implementations should embed UnimplementedMachineImagesServer
// for forward compatibility
type MachineImagesServer interface {
	// Deletes the specified machine image. Deleting a machine image is permanent and cannot be undone.
	Delete(context.Context, *DeleteMachineImageRequest) (*Operation, error)
	// Returns the specified machine image.
	Get(context.Context, *GetMachineImageRequest) (*MachineImage, error)
	// Gets the access control policy for a resource. May be empty if no such policy or resource exists.
	GetIamPolicy(context.Context, *GetIamPolicyMachineImageRequest) (*Policy, error)
	// Creates a machine image in the specified project using the data that is included in the request. If you are creating a new machine image to update an existing instance, your new machine image should use the same network or, if applicable, the same subnetwork as the original instance.
	Insert(context.Context, *InsertMachineImageRequest) (*Operation, error)
	// Retrieves a list of machine images that are contained within the specified project.
	List(context.Context, *ListMachineImagesRequest) (*MachineImageList, error)
	// Sets the access control policy on the specified resource. Replaces any existing policy.
	SetIamPolicy(context.Context, *SetIamPolicyMachineImageRequest) (*Policy, error)
	// Sets the labels on a machine image. To learn more about labels, read the Labeling Resources documentation.
	SetLabels(context.Context, *SetLabelsMachineImageRequest) (*Operation, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(context.Context, *TestIamPermissionsMachineImageRequest) (*TestPermissionsResponse, error)
}

// UnimplementedMachineImagesServer should be embedded to have forward compatible implementations.
type UnimplementedMachineImagesServer struct {
}

func (UnimplementedMachineImagesServer) Delete(context.Context, *DeleteMachineImageRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedMachineImagesServer) Get(context.Context, *GetMachineImageRequest) (*MachineImage, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedMachineImagesServer) GetIamPolicy(context.Context, *GetIamPolicyMachineImageRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedMachineImagesServer) Insert(context.Context, *InsertMachineImageRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (UnimplementedMachineImagesServer) List(context.Context, *ListMachineImagesRequest) (*MachineImageList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedMachineImagesServer) SetIamPolicy(context.Context, *SetIamPolicyMachineImageRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedMachineImagesServer) SetLabels(context.Context, *SetLabelsMachineImageRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetLabels not implemented")
}
func (UnimplementedMachineImagesServer) TestIamPermissions(context.Context, *TestIamPermissionsMachineImageRequest) (*TestPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

// UnsafeMachineImagesServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to MachineImagesServer will
// result in compilation errors.
type UnsafeMachineImagesServer interface {
	mustEmbedUnimplementedMachineImagesServer()
}

func RegisterMachineImagesServer(s grpc.ServiceRegistrar, srv MachineImagesServer) {
	s.RegisterService(&MachineImages_ServiceDesc, srv)
}

func _MachineImages_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteMachineImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MachineImagesServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MachineImages_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MachineImagesServer).Delete(ctx, req.(*DeleteMachineImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MachineImages_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMachineImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MachineImagesServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MachineImages_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MachineImagesServer).Get(ctx, req.(*GetMachineImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MachineImages_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIamPolicyMachineImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MachineImagesServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MachineImages_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MachineImagesServer).GetIamPolicy(ctx, req.(*GetIamPolicyMachineImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MachineImages_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertMachineImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MachineImagesServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MachineImages_Insert_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MachineImagesServer).Insert(ctx, req.(*InsertMachineImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MachineImages_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMachineImagesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MachineImagesServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MachineImages_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MachineImagesServer).List(ctx, req.(*ListMachineImagesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MachineImages_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetIamPolicyMachineImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MachineImagesServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MachineImages_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MachineImagesServer).SetIamPolicy(ctx, req.(*SetIamPolicyMachineImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MachineImages_SetLabels_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetLabelsMachineImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MachineImagesServer).SetLabels(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MachineImages_SetLabels_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MachineImagesServer).SetLabels(ctx, req.(*SetLabelsMachineImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MachineImages_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TestIamPermissionsMachineImageRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MachineImagesServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MachineImages_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MachineImagesServer).TestIamPermissions(ctx, req.(*TestIamPermissionsMachineImageRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// MachineImages_ServiceDesc is the grpc.ServiceDesc for MachineImages service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var MachineImages_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.MachineImages",
	HandlerType: (*MachineImagesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Delete",
			Handler:    _MachineImages_Delete_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _MachineImages_Get_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _MachineImages_GetIamPolicy_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _MachineImages_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _MachineImages_List_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _MachineImages_SetIamPolicy_Handler,
		},
		{
			MethodName: "SetLabels",
			Handler:    _MachineImages_SetLabels_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _MachineImages_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	MachineTypes_AggregatedList_FullMethodName = "/google.cloud.compute.v1beta.MachineTypes/AggregatedList"
	MachineTypes_Get_FullMethodName            = "/google.cloud.compute.v1beta.MachineTypes/Get"
	MachineTypes_List_FullMethodName           = "/google.cloud.compute.v1beta.MachineTypes/List"
)

// MachineTypesClient is the client API for MachineTypes service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type MachineTypesClient interface {
	// Retrieves an aggregated list of machine types. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(ctx context.Context, in *AggregatedListMachineTypesRequest, opts ...grpc.CallOption) (*MachineTypeAggregatedList, error)
	// Returns the specified machine type.
	Get(ctx context.Context, in *GetMachineTypeRequest, opts ...grpc.CallOption) (*MachineType, error)
	// Retrieves a list of machine types available to the specified project.
	List(ctx context.Context, in *ListMachineTypesRequest, opts ...grpc.CallOption) (*MachineTypeList, error)
}

type machineTypesClient struct {
	cc grpc.ClientConnInterface
}

func NewMachineTypesClient(cc grpc.ClientConnInterface) MachineTypesClient {
	return &machineTypesClient{cc}
}

func (c *machineTypesClient) AggregatedList(ctx context.Context, in *AggregatedListMachineTypesRequest, opts ...grpc.CallOption) (*MachineTypeAggregatedList, error) {
	out := new(MachineTypeAggregatedList)
	err := c.cc.Invoke(ctx, MachineTypes_AggregatedList_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *machineTypesClient) Get(ctx context.Context, in *GetMachineTypeRequest, opts ...grpc.CallOption) (*MachineType, error) {
	out := new(MachineType)
	err := c.cc.Invoke(ctx, MachineTypes_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *machineTypesClient) List(ctx context.Context, in *ListMachineTypesRequest, opts ...grpc.CallOption) (*MachineTypeList, error) {
	out := new(MachineTypeList)
	err := c.cc.Invoke(ctx, MachineTypes_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// MachineTypesServer is the server API for MachineTypes service.
// All implementations should embed UnimplementedMachineTypesServer
// for forward compatibility
type MachineTypesServer interface {
	// Retrieves an aggregated list of machine types. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(context.Context, *AggregatedListMachineTypesRequest) (*MachineTypeAggregatedList, error)
	// Returns the specified machine type.
	Get(context.Context, *GetMachineTypeRequest) (*MachineType, error)
	// Retrieves a list of machine types available to the specified project.
	List(context.Context, *ListMachineTypesRequest) (*MachineTypeList, error)
}

// UnimplementedMachineTypesServer should be embedded to have forward compatible implementations.
type UnimplementedMachineTypesServer struct {
}

func (UnimplementedMachineTypesServer) AggregatedList(context.Context, *AggregatedListMachineTypesRequest) (*MachineTypeAggregatedList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AggregatedList not implemented")
}
func (UnimplementedMachineTypesServer) Get(context.Context, *GetMachineTypeRequest) (*MachineType, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedMachineTypesServer) List(context.Context, *ListMachineTypesRequest) (*MachineTypeList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}

// UnsafeMachineTypesServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to MachineTypesServer will
// result in compilation errors.
type UnsafeMachineTypesServer interface {
	mustEmbedUnimplementedMachineTypesServer()
}

func RegisterMachineTypesServer(s grpc.ServiceRegistrar, srv MachineTypesServer) {
	s.RegisterService(&MachineTypes_ServiceDesc, srv)
}

func _MachineTypes_AggregatedList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AggregatedListMachineTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MachineTypesServer).AggregatedList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MachineTypes_AggregatedList_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MachineTypesServer).AggregatedList(ctx, req.(*AggregatedListMachineTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MachineTypes_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMachineTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MachineTypesServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MachineTypes_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MachineTypesServer).Get(ctx, req.(*GetMachineTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MachineTypes_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMachineTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MachineTypesServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: MachineTypes_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MachineTypesServer).List(ctx, req.(*ListMachineTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// MachineTypes_ServiceDesc is the grpc.ServiceDesc for MachineTypes service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var MachineTypes_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.MachineTypes",
	HandlerType: (*MachineTypesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AggregatedList",
			Handler:    _MachineTypes_AggregatedList_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _MachineTypes_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _MachineTypes_List_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	NetworkAttachments_AggregatedList_FullMethodName     = "/google.cloud.compute.v1beta.NetworkAttachments/AggregatedList"
	NetworkAttachments_Delete_FullMethodName             = "/google.cloud.compute.v1beta.NetworkAttachments/Delete"
	NetworkAttachments_Get_FullMethodName                = "/google.cloud.compute.v1beta.NetworkAttachments/Get"
	NetworkAttachments_GetIamPolicy_FullMethodName       = "/google.cloud.compute.v1beta.NetworkAttachments/GetIamPolicy"
	NetworkAttachments_Insert_FullMethodName             = "/google.cloud.compute.v1beta.NetworkAttachments/Insert"
	NetworkAttachments_List_FullMethodName               = "/google.cloud.compute.v1beta.NetworkAttachments/List"
	NetworkAttachments_Patch_FullMethodName              = "/google.cloud.compute.v1beta.NetworkAttachments/Patch"
	NetworkAttachments_SetIamPolicy_FullMethodName       = "/google.cloud.compute.v1beta.NetworkAttachments/SetIamPolicy"
	NetworkAttachments_TestIamPermissions_FullMethodName = "/google.cloud.compute.v1beta.NetworkAttachments/TestIamPermissions"
)

// NetworkAttachmentsClient is the client API for NetworkAttachments service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type NetworkAttachmentsClient interface {
	// Retrieves the list of all NetworkAttachment resources, regional and global, available to the specified project. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(ctx context.Context, in *AggregatedListNetworkAttachmentsRequest, opts ...grpc.CallOption) (*NetworkAttachmentAggregatedList, error)
	// Deletes the specified NetworkAttachment in the given scope
	Delete(ctx context.Context, in *DeleteNetworkAttachmentRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns the specified NetworkAttachment resource in the given scope.
	Get(ctx context.Context, in *GetNetworkAttachmentRequest, opts ...grpc.CallOption) (*NetworkAttachment, error)
	// Gets the access control policy for a resource. May be empty if no such policy or resource exists.
	GetIamPolicy(ctx context.Context, in *GetIamPolicyNetworkAttachmentRequest, opts ...grpc.CallOption) (*Policy, error)
	// Creates a NetworkAttachment in the specified project in the given scope using the parameters that are included in the request.
	Insert(ctx context.Context, in *InsertNetworkAttachmentRequest, opts ...grpc.CallOption) (*Operation, error)
	// Lists the NetworkAttachments for a project in the given scope.
	List(ctx context.Context, in *ListNetworkAttachmentsRequest, opts ...grpc.CallOption) (*NetworkAttachmentList, error)
	// Patches the specified NetworkAttachment resource with the data included in the request. This method supports PATCH semantics and uses JSON merge patch format and processing rules.
	Patch(ctx context.Context, in *PatchNetworkAttachmentRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the access control policy on the specified resource. Replaces any existing policy.
	SetIamPolicy(ctx context.Context, in *SetIamPolicyNetworkAttachmentRequest, opts ...grpc.CallOption) (*Policy, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(ctx context.Context, in *TestIamPermissionsNetworkAttachmentRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error)
}

type networkAttachmentsClient struct {
	cc grpc.ClientConnInterface
}

func NewNetworkAttachmentsClient(cc grpc.ClientConnInterface) NetworkAttachmentsClient {
	return &networkAttachmentsClient{cc}
}

func (c *networkAttachmentsClient) AggregatedList(ctx context.Context, in *AggregatedListNetworkAttachmentsRequest, opts ...grpc.CallOption) (*NetworkAttachmentAggregatedList, error) {
	out := new(NetworkAttachmentAggregatedList)
	err := c.cc.Invoke(ctx, NetworkAttachments_AggregatedList_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkAttachmentsClient) Delete(ctx context.Context, in *DeleteNetworkAttachmentRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, NetworkAttachments_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkAttachmentsClient) Get(ctx context.Context, in *GetNetworkAttachmentRequest, opts ...grpc.CallOption) (*NetworkAttachment, error) {
	out := new(NetworkAttachment)
	err := c.cc.Invoke(ctx, NetworkAttachments_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkAttachmentsClient) GetIamPolicy(ctx context.Context, in *GetIamPolicyNetworkAttachmentRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, NetworkAttachments_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkAttachmentsClient) Insert(ctx context.Context, in *InsertNetworkAttachmentRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, NetworkAttachments_Insert_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkAttachmentsClient) List(ctx context.Context, in *ListNetworkAttachmentsRequest, opts ...grpc.CallOption) (*NetworkAttachmentList, error) {
	out := new(NetworkAttachmentList)
	err := c.cc.Invoke(ctx, NetworkAttachments_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkAttachmentsClient) Patch(ctx context.Context, in *PatchNetworkAttachmentRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, NetworkAttachments_Patch_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkAttachmentsClient) SetIamPolicy(ctx context.Context, in *SetIamPolicyNetworkAttachmentRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, NetworkAttachments_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkAttachmentsClient) TestIamPermissions(ctx context.Context, in *TestIamPermissionsNetworkAttachmentRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error) {
	out := new(TestPermissionsResponse)
	err := c.cc.Invoke(ctx, NetworkAttachments_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// NetworkAttachmentsServer is the server API for NetworkAttachments service.
// All implementations should embed UnimplementedNetworkAttachmentsServer
// for forward compatibility
type NetworkAttachmentsServer interface {
	// Retrieves the list of all NetworkAttachment resources, regional and global, available to the specified project. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(context.Context, *AggregatedListNetworkAttachmentsRequest) (*NetworkAttachmentAggregatedList, error)
	// Deletes the specified NetworkAttachment in the given scope
	Delete(context.Context, *DeleteNetworkAttachmentRequest) (*Operation, error)
	// Returns the specified NetworkAttachment resource in the given scope.
	Get(context.Context, *GetNetworkAttachmentRequest) (*NetworkAttachment, error)
	// Gets the access control policy for a resource. May be empty if no such policy or resource exists.
	GetIamPolicy(context.Context, *GetIamPolicyNetworkAttachmentRequest) (*Policy, error)
	// Creates a NetworkAttachment in the specified project in the given scope using the parameters that are included in the request.
	Insert(context.Context, *InsertNetworkAttachmentRequest) (*Operation, error)
	// Lists the NetworkAttachments for a project in the given scope.
	List(context.Context, *ListNetworkAttachmentsRequest) (*NetworkAttachmentList, error)
	// Patches the specified NetworkAttachment resource with the data included in the request. This method supports PATCH semantics and uses JSON merge patch format and processing rules.
	Patch(context.Context, *PatchNetworkAttachmentRequest) (*Operation, error)
	// Sets the access control policy on the specified resource. Replaces any existing policy.
	SetIamPolicy(context.Context, *SetIamPolicyNetworkAttachmentRequest) (*Policy, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(context.Context, *TestIamPermissionsNetworkAttachmentRequest) (*TestPermissionsResponse, error)
}

// UnimplementedNetworkAttachmentsServer should be embedded to have forward compatible implementations.
type UnimplementedNetworkAttachmentsServer struct {
}

func (UnimplementedNetworkAttachmentsServer) AggregatedList(context.Context, *AggregatedListNetworkAttachmentsRequest) (*NetworkAttachmentAggregatedList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AggregatedList not implemented")
}
func (UnimplementedNetworkAttachmentsServer) Delete(context.Context, *DeleteNetworkAttachmentRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedNetworkAttachmentsServer) Get(context.Context, *GetNetworkAttachmentRequest) (*NetworkAttachment, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedNetworkAttachmentsServer) GetIamPolicy(context.Context, *GetIamPolicyNetworkAttachmentRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedNetworkAttachmentsServer) Insert(context.Context, *InsertNetworkAttachmentRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (UnimplementedNetworkAttachmentsServer) List(context.Context, *ListNetworkAttachmentsRequest) (*NetworkAttachmentList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedNetworkAttachmentsServer) Patch(context.Context, *PatchNetworkAttachmentRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Patch not implemented")
}
func (UnimplementedNetworkAttachmentsServer) SetIamPolicy(context.Context, *SetIamPolicyNetworkAttachmentRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedNetworkAttachmentsServer) TestIamPermissions(context.Context, *TestIamPermissionsNetworkAttachmentRequest) (*TestPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

// UnsafeNetworkAttachmentsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to NetworkAttachmentsServer will
// result in compilation errors.
type UnsafeNetworkAttachmentsServer interface {
	mustEmbedUnimplementedNetworkAttachmentsServer()
}

func RegisterNetworkAttachmentsServer(s grpc.ServiceRegistrar, srv NetworkAttachmentsServer) {
	s.RegisterService(&NetworkAttachments_ServiceDesc, srv)
}

func _NetworkAttachments_AggregatedList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AggregatedListNetworkAttachmentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkAttachmentsServer).AggregatedList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkAttachments_AggregatedList_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkAttachmentsServer).AggregatedList(ctx, req.(*AggregatedListNetworkAttachmentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkAttachments_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNetworkAttachmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkAttachmentsServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkAttachments_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkAttachmentsServer).Delete(ctx, req.(*DeleteNetworkAttachmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkAttachments_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNetworkAttachmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkAttachmentsServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkAttachments_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkAttachmentsServer).Get(ctx, req.(*GetNetworkAttachmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkAttachments_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIamPolicyNetworkAttachmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkAttachmentsServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkAttachments_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkAttachmentsServer).GetIamPolicy(ctx, req.(*GetIamPolicyNetworkAttachmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkAttachments_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertNetworkAttachmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkAttachmentsServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkAttachments_Insert_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkAttachmentsServer).Insert(ctx, req.(*InsertNetworkAttachmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkAttachments_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNetworkAttachmentsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkAttachmentsServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkAttachments_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkAttachmentsServer).List(ctx, req.(*ListNetworkAttachmentsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkAttachments_Patch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchNetworkAttachmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkAttachmentsServer).Patch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkAttachments_Patch_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkAttachmentsServer).Patch(ctx, req.(*PatchNetworkAttachmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkAttachments_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetIamPolicyNetworkAttachmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkAttachmentsServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkAttachments_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkAttachmentsServer).SetIamPolicy(ctx, req.(*SetIamPolicyNetworkAttachmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkAttachments_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TestIamPermissionsNetworkAttachmentRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkAttachmentsServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkAttachments_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkAttachmentsServer).TestIamPermissions(ctx, req.(*TestIamPermissionsNetworkAttachmentRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// NetworkAttachments_ServiceDesc is the grpc.ServiceDesc for NetworkAttachments service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var NetworkAttachments_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.NetworkAttachments",
	HandlerType: (*NetworkAttachmentsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AggregatedList",
			Handler:    _NetworkAttachments_AggregatedList_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _NetworkAttachments_Delete_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _NetworkAttachments_Get_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _NetworkAttachments_GetIamPolicy_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _NetworkAttachments_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _NetworkAttachments_List_Handler,
		},
		{
			MethodName: "Patch",
			Handler:    _NetworkAttachments_Patch_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _NetworkAttachments_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _NetworkAttachments_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	NetworkEdgeSecurityServices_AggregatedList_FullMethodName = "/google.cloud.compute.v1beta.NetworkEdgeSecurityServices/AggregatedList"
	NetworkEdgeSecurityServices_Delete_FullMethodName         = "/google.cloud.compute.v1beta.NetworkEdgeSecurityServices/Delete"
	NetworkEdgeSecurityServices_Get_FullMethodName            = "/google.cloud.compute.v1beta.NetworkEdgeSecurityServices/Get"
	NetworkEdgeSecurityServices_Insert_FullMethodName         = "/google.cloud.compute.v1beta.NetworkEdgeSecurityServices/Insert"
	NetworkEdgeSecurityServices_Patch_FullMethodName          = "/google.cloud.compute.v1beta.NetworkEdgeSecurityServices/Patch"
)

// NetworkEdgeSecurityServicesClient is the client API for NetworkEdgeSecurityServices service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type NetworkEdgeSecurityServicesClient interface {
	// Retrieves the list of all NetworkEdgeSecurityService resources available to the specified project. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(ctx context.Context, in *AggregatedListNetworkEdgeSecurityServicesRequest, opts ...grpc.CallOption) (*NetworkEdgeSecurityServiceAggregatedList, error)
	// Deletes the specified service.
	Delete(ctx context.Context, in *DeleteNetworkEdgeSecurityServiceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Gets a specified NetworkEdgeSecurityService.
	Get(ctx context.Context, in *GetNetworkEdgeSecurityServiceRequest, opts ...grpc.CallOption) (*NetworkEdgeSecurityService, error)
	// Creates a new service in the specified project using the data included in the request.
	Insert(ctx context.Context, in *InsertNetworkEdgeSecurityServiceRequest, opts ...grpc.CallOption) (*Operation, error)
	// Patches the specified policy with the data included in the request.
	Patch(ctx context.Context, in *PatchNetworkEdgeSecurityServiceRequest, opts ...grpc.CallOption) (*Operation, error)
}

type networkEdgeSecurityServicesClient struct {
	cc grpc.ClientConnInterface
}

func NewNetworkEdgeSecurityServicesClient(cc grpc.ClientConnInterface) NetworkEdgeSecurityServicesClient {
	return &networkEdgeSecurityServicesClient{cc}
}

func (c *networkEdgeSecurityServicesClient) AggregatedList(ctx context.Context, in *AggregatedListNetworkEdgeSecurityServicesRequest, opts ...grpc.CallOption) (*NetworkEdgeSecurityServiceAggregatedList, error) {
	out := new(NetworkEdgeSecurityServiceAggregatedList)
	err := c.cc.Invoke(ctx, NetworkEdgeSecurityServices_AggregatedList_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkEdgeSecurityServicesClient) Delete(ctx context.Context, in *DeleteNetworkEdgeSecurityServiceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, NetworkEdgeSecurityServices_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkEdgeSecurityServicesClient) Get(ctx context.Context, in *GetNetworkEdgeSecurityServiceRequest, opts ...grpc.CallOption) (*NetworkEdgeSecurityService, error) {
	out := new(NetworkEdgeSecurityService)
	err := c.cc.Invoke(ctx, NetworkEdgeSecurityServices_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkEdgeSecurityServicesClient) Insert(ctx context.Context, in *InsertNetworkEdgeSecurityServiceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, NetworkEdgeSecurityServices_Insert_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkEdgeSecurityServicesClient) Patch(ctx context.Context, in *PatchNetworkEdgeSecurityServiceRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, NetworkEdgeSecurityServices_Patch_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// NetworkEdgeSecurityServicesServer is the server API for NetworkEdgeSecurityServices service.
// All implementations should embed UnimplementedNetworkEdgeSecurityServicesServer
// for forward compatibility
type NetworkEdgeSecurityServicesServer interface {
	// Retrieves the list of all NetworkEdgeSecurityService resources available to the specified project. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(context.Context, *AggregatedListNetworkEdgeSecurityServicesRequest) (*NetworkEdgeSecurityServiceAggregatedList, error)
	// Deletes the specified service.
	Delete(context.Context, *DeleteNetworkEdgeSecurityServiceRequest) (*Operation, error)
	// Gets a specified NetworkEdgeSecurityService.
	Get(context.Context, *GetNetworkEdgeSecurityServiceRequest) (*NetworkEdgeSecurityService, error)
	// Creates a new service in the specified project using the data included in the request.
	Insert(context.Context, *InsertNetworkEdgeSecurityServiceRequest) (*Operation, error)
	// Patches the specified policy with the data included in the request.
	Patch(context.Context, *PatchNetworkEdgeSecurityServiceRequest) (*Operation, error)
}

// UnimplementedNetworkEdgeSecurityServicesServer should be embedded to have forward compatible implementations.
type UnimplementedNetworkEdgeSecurityServicesServer struct {
}

func (UnimplementedNetworkEdgeSecurityServicesServer) AggregatedList(context.Context, *AggregatedListNetworkEdgeSecurityServicesRequest) (*NetworkEdgeSecurityServiceAggregatedList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AggregatedList not implemented")
}
func (UnimplementedNetworkEdgeSecurityServicesServer) Delete(context.Context, *DeleteNetworkEdgeSecurityServiceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedNetworkEdgeSecurityServicesServer) Get(context.Context, *GetNetworkEdgeSecurityServiceRequest) (*NetworkEdgeSecurityService, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedNetworkEdgeSecurityServicesServer) Insert(context.Context, *InsertNetworkEdgeSecurityServiceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (UnimplementedNetworkEdgeSecurityServicesServer) Patch(context.Context, *PatchNetworkEdgeSecurityServiceRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Patch not implemented")
}

// UnsafeNetworkEdgeSecurityServicesServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to NetworkEdgeSecurityServicesServer will
// result in compilation errors.
type UnsafeNetworkEdgeSecurityServicesServer interface {
	mustEmbedUnimplementedNetworkEdgeSecurityServicesServer()
}

func RegisterNetworkEdgeSecurityServicesServer(s grpc.ServiceRegistrar, srv NetworkEdgeSecurityServicesServer) {
	s.RegisterService(&NetworkEdgeSecurityServices_ServiceDesc, srv)
}

func _NetworkEdgeSecurityServices_AggregatedList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AggregatedListNetworkEdgeSecurityServicesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkEdgeSecurityServicesServer).AggregatedList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkEdgeSecurityServices_AggregatedList_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkEdgeSecurityServicesServer).AggregatedList(ctx, req.(*AggregatedListNetworkEdgeSecurityServicesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkEdgeSecurityServices_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNetworkEdgeSecurityServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkEdgeSecurityServicesServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkEdgeSecurityServices_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkEdgeSecurityServicesServer).Delete(ctx, req.(*DeleteNetworkEdgeSecurityServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkEdgeSecurityServices_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNetworkEdgeSecurityServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkEdgeSecurityServicesServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkEdgeSecurityServices_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkEdgeSecurityServicesServer).Get(ctx, req.(*GetNetworkEdgeSecurityServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkEdgeSecurityServices_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertNetworkEdgeSecurityServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkEdgeSecurityServicesServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkEdgeSecurityServices_Insert_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkEdgeSecurityServicesServer).Insert(ctx, req.(*InsertNetworkEdgeSecurityServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkEdgeSecurityServices_Patch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchNetworkEdgeSecurityServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkEdgeSecurityServicesServer).Patch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkEdgeSecurityServices_Patch_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkEdgeSecurityServicesServer).Patch(ctx, req.(*PatchNetworkEdgeSecurityServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// NetworkEdgeSecurityServices_ServiceDesc is the grpc.ServiceDesc for NetworkEdgeSecurityServices service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var NetworkEdgeSecurityServices_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.NetworkEdgeSecurityServices",
	HandlerType: (*NetworkEdgeSecurityServicesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AggregatedList",
			Handler:    _NetworkEdgeSecurityServices_AggregatedList_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _NetworkEdgeSecurityServices_Delete_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _NetworkEdgeSecurityServices_Get_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _NetworkEdgeSecurityServices_Insert_Handler,
		},
		{
			MethodName: "Patch",
			Handler:    _NetworkEdgeSecurityServices_Patch_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	NetworkEndpointGroups_AggregatedList_FullMethodName         = "/google.cloud.compute.v1beta.NetworkEndpointGroups/AggregatedList"
	NetworkEndpointGroups_AttachNetworkEndpoints_FullMethodName = "/google.cloud.compute.v1beta.NetworkEndpointGroups/AttachNetworkEndpoints"
	NetworkEndpointGroups_Delete_FullMethodName                 = "/google.cloud.compute.v1beta.NetworkEndpointGroups/Delete"
	NetworkEndpointGroups_DetachNetworkEndpoints_FullMethodName = "/google.cloud.compute.v1beta.NetworkEndpointGroups/DetachNetworkEndpoints"
	NetworkEndpointGroups_Get_FullMethodName                    = "/google.cloud.compute.v1beta.NetworkEndpointGroups/Get"
	NetworkEndpointGroups_Insert_FullMethodName                 = "/google.cloud.compute.v1beta.NetworkEndpointGroups/Insert"
	NetworkEndpointGroups_List_FullMethodName                   = "/google.cloud.compute.v1beta.NetworkEndpointGroups/List"
	NetworkEndpointGroups_ListNetworkEndpoints_FullMethodName   = "/google.cloud.compute.v1beta.NetworkEndpointGroups/ListNetworkEndpoints"
	NetworkEndpointGroups_TestIamPermissions_FullMethodName     = "/google.cloud.compute.v1beta.NetworkEndpointGroups/TestIamPermissions"
)

// NetworkEndpointGroupsClient is the client API for NetworkEndpointGroups service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type NetworkEndpointGroupsClient interface {
	// Retrieves the list of network endpoint groups and sorts them by zone. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(ctx context.Context, in *AggregatedListNetworkEndpointGroupsRequest, opts ...grpc.CallOption) (*NetworkEndpointGroupAggregatedList, error)
	// Attach a list of network endpoints to the specified network endpoint group.
	AttachNetworkEndpoints(ctx context.Context, in *AttachNetworkEndpointsNetworkEndpointGroupRequest, opts ...grpc.CallOption) (*Operation, error)
	// Deletes the specified network endpoint group. The network endpoints in the NEG and the VM instances they belong to are not terminated when the NEG is deleted. Note that the NEG cannot be deleted if there are backend services referencing it.
	Delete(ctx context.Context, in *DeleteNetworkEndpointGroupRequest, opts ...grpc.CallOption) (*Operation, error)
	// Detach a list of network endpoints from the specified network endpoint group.
	DetachNetworkEndpoints(ctx context.Context, in *DetachNetworkEndpointsNetworkEndpointGroupRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns the specified network endpoint group.
	Get(ctx context.Context, in *GetNetworkEndpointGroupRequest, opts ...grpc.CallOption) (*NetworkEndpointGroup, error)
	// Creates a network endpoint group in the specified project using the parameters that are included in the request.
	Insert(ctx context.Context, in *InsertNetworkEndpointGroupRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves the list of network endpoint groups that are located in the specified project and zone.
	List(ctx context.Context, in *ListNetworkEndpointGroupsRequest, opts ...grpc.CallOption) (*NetworkEndpointGroupList, error)
	// Lists the network endpoints in the specified network endpoint group.
	ListNetworkEndpoints(ctx context.Context, in *ListNetworkEndpointsNetworkEndpointGroupsRequest, opts ...grpc.CallOption) (*NetworkEndpointGroupsListNetworkEndpoints, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(ctx context.Context, in *TestIamPermissionsNetworkEndpointGroupRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error)
}

type networkEndpointGroupsClient struct {
	cc grpc.ClientConnInterface
}

func NewNetworkEndpointGroupsClient(cc grpc.ClientConnInterface) NetworkEndpointGroupsClient {
	return &networkEndpointGroupsClient{cc}
}

func (c *networkEndpointGroupsClient) AggregatedList(ctx context.Context, in *AggregatedListNetworkEndpointGroupsRequest, opts ...grpc.CallOption) (*NetworkEndpointGroupAggregatedList, error) {
	out := new(NetworkEndpointGroupAggregatedList)
	err := c.cc.Invoke(ctx, NetworkEndpointGroups_AggregatedList_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkEndpointGroupsClient) AttachNetworkEndpoints(ctx context.Context, in *AttachNetworkEndpointsNetworkEndpointGroupRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, NetworkEndpointGroups_AttachNetworkEndpoints_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkEndpointGroupsClient) Delete(ctx context.Context, in *DeleteNetworkEndpointGroupRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, NetworkEndpointGroups_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkEndpointGroupsClient) DetachNetworkEndpoints(ctx context.Context, in *DetachNetworkEndpointsNetworkEndpointGroupRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, NetworkEndpointGroups_DetachNetworkEndpoints_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkEndpointGroupsClient) Get(ctx context.Context, in *GetNetworkEndpointGroupRequest, opts ...grpc.CallOption) (*NetworkEndpointGroup, error) {
	out := new(NetworkEndpointGroup)
	err := c.cc.Invoke(ctx, NetworkEndpointGroups_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkEndpointGroupsClient) Insert(ctx context.Context, in *InsertNetworkEndpointGroupRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, NetworkEndpointGroups_Insert_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkEndpointGroupsClient) List(ctx context.Context, in *ListNetworkEndpointGroupsRequest, opts ...grpc.CallOption) (*NetworkEndpointGroupList, error) {
	out := new(NetworkEndpointGroupList)
	err := c.cc.Invoke(ctx, NetworkEndpointGroups_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkEndpointGroupsClient) ListNetworkEndpoints(ctx context.Context, in *ListNetworkEndpointsNetworkEndpointGroupsRequest, opts ...grpc.CallOption) (*NetworkEndpointGroupsListNetworkEndpoints, error) {
	out := new(NetworkEndpointGroupsListNetworkEndpoints)
	err := c.cc.Invoke(ctx, NetworkEndpointGroups_ListNetworkEndpoints_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkEndpointGroupsClient) TestIamPermissions(ctx context.Context, in *TestIamPermissionsNetworkEndpointGroupRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error) {
	out := new(TestPermissionsResponse)
	err := c.cc.Invoke(ctx, NetworkEndpointGroups_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// NetworkEndpointGroupsServer is the server API for NetworkEndpointGroups service.
// All implementations should embed UnimplementedNetworkEndpointGroupsServer
// for forward compatibility
type NetworkEndpointGroupsServer interface {
	// Retrieves the list of network endpoint groups and sorts them by zone. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(context.Context, *AggregatedListNetworkEndpointGroupsRequest) (*NetworkEndpointGroupAggregatedList, error)
	// Attach a list of network endpoints to the specified network endpoint group.
	AttachNetworkEndpoints(context.Context, *AttachNetworkEndpointsNetworkEndpointGroupRequest) (*Operation, error)
	// Deletes the specified network endpoint group. The network endpoints in the NEG and the VM instances they belong to are not terminated when the NEG is deleted. Note that the NEG cannot be deleted if there are backend services referencing it.
	Delete(context.Context, *DeleteNetworkEndpointGroupRequest) (*Operation, error)
	// Detach a list of network endpoints from the specified network endpoint group.
	DetachNetworkEndpoints(context.Context, *DetachNetworkEndpointsNetworkEndpointGroupRequest) (*Operation, error)
	// Returns the specified network endpoint group.
	Get(context.Context, *GetNetworkEndpointGroupRequest) (*NetworkEndpointGroup, error)
	// Creates a network endpoint group in the specified project using the parameters that are included in the request.
	Insert(context.Context, *InsertNetworkEndpointGroupRequest) (*Operation, error)
	// Retrieves the list of network endpoint groups that are located in the specified project and zone.
	List(context.Context, *ListNetworkEndpointGroupsRequest) (*NetworkEndpointGroupList, error)
	// Lists the network endpoints in the specified network endpoint group.
	ListNetworkEndpoints(context.Context, *ListNetworkEndpointsNetworkEndpointGroupsRequest) (*NetworkEndpointGroupsListNetworkEndpoints, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(context.Context, *TestIamPermissionsNetworkEndpointGroupRequest) (*TestPermissionsResponse, error)
}

// UnimplementedNetworkEndpointGroupsServer should be embedded to have forward compatible implementations.
type UnimplementedNetworkEndpointGroupsServer struct {
}

func (UnimplementedNetworkEndpointGroupsServer) AggregatedList(context.Context, *AggregatedListNetworkEndpointGroupsRequest) (*NetworkEndpointGroupAggregatedList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AggregatedList not implemented")
}
func (UnimplementedNetworkEndpointGroupsServer) AttachNetworkEndpoints(context.Context, *AttachNetworkEndpointsNetworkEndpointGroupRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AttachNetworkEndpoints not implemented")
}
func (UnimplementedNetworkEndpointGroupsServer) Delete(context.Context, *DeleteNetworkEndpointGroupRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedNetworkEndpointGroupsServer) DetachNetworkEndpoints(context.Context, *DetachNetworkEndpointsNetworkEndpointGroupRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DetachNetworkEndpoints not implemented")
}
func (UnimplementedNetworkEndpointGroupsServer) Get(context.Context, *GetNetworkEndpointGroupRequest) (*NetworkEndpointGroup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedNetworkEndpointGroupsServer) Insert(context.Context, *InsertNetworkEndpointGroupRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (UnimplementedNetworkEndpointGroupsServer) List(context.Context, *ListNetworkEndpointGroupsRequest) (*NetworkEndpointGroupList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedNetworkEndpointGroupsServer) ListNetworkEndpoints(context.Context, *ListNetworkEndpointsNetworkEndpointGroupsRequest) (*NetworkEndpointGroupsListNetworkEndpoints, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNetworkEndpoints not implemented")
}
func (UnimplementedNetworkEndpointGroupsServer) TestIamPermissions(context.Context, *TestIamPermissionsNetworkEndpointGroupRequest) (*TestPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

// UnsafeNetworkEndpointGroupsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to NetworkEndpointGroupsServer will
// result in compilation errors.
type UnsafeNetworkEndpointGroupsServer interface {
	mustEmbedUnimplementedNetworkEndpointGroupsServer()
}

func RegisterNetworkEndpointGroupsServer(s grpc.ServiceRegistrar, srv NetworkEndpointGroupsServer) {
	s.RegisterService(&NetworkEndpointGroups_ServiceDesc, srv)
}

func _NetworkEndpointGroups_AggregatedList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AggregatedListNetworkEndpointGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkEndpointGroupsServer).AggregatedList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkEndpointGroups_AggregatedList_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkEndpointGroupsServer).AggregatedList(ctx, req.(*AggregatedListNetworkEndpointGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkEndpointGroups_AttachNetworkEndpoints_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AttachNetworkEndpointsNetworkEndpointGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkEndpointGroupsServer).AttachNetworkEndpoints(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkEndpointGroups_AttachNetworkEndpoints_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkEndpointGroupsServer).AttachNetworkEndpoints(ctx, req.(*AttachNetworkEndpointsNetworkEndpointGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkEndpointGroups_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNetworkEndpointGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkEndpointGroupsServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkEndpointGroups_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkEndpointGroupsServer).Delete(ctx, req.(*DeleteNetworkEndpointGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkEndpointGroups_DetachNetworkEndpoints_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DetachNetworkEndpointsNetworkEndpointGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkEndpointGroupsServer).DetachNetworkEndpoints(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkEndpointGroups_DetachNetworkEndpoints_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkEndpointGroupsServer).DetachNetworkEndpoints(ctx, req.(*DetachNetworkEndpointsNetworkEndpointGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkEndpointGroups_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNetworkEndpointGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkEndpointGroupsServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkEndpointGroups_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkEndpointGroupsServer).Get(ctx, req.(*GetNetworkEndpointGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkEndpointGroups_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertNetworkEndpointGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkEndpointGroupsServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkEndpointGroups_Insert_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkEndpointGroupsServer).Insert(ctx, req.(*InsertNetworkEndpointGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkEndpointGroups_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNetworkEndpointGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkEndpointGroupsServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkEndpointGroups_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkEndpointGroupsServer).List(ctx, req.(*ListNetworkEndpointGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkEndpointGroups_ListNetworkEndpoints_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNetworkEndpointsNetworkEndpointGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkEndpointGroupsServer).ListNetworkEndpoints(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkEndpointGroups_ListNetworkEndpoints_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkEndpointGroupsServer).ListNetworkEndpoints(ctx, req.(*ListNetworkEndpointsNetworkEndpointGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkEndpointGroups_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TestIamPermissionsNetworkEndpointGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkEndpointGroupsServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkEndpointGroups_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkEndpointGroupsServer).TestIamPermissions(ctx, req.(*TestIamPermissionsNetworkEndpointGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// NetworkEndpointGroups_ServiceDesc is the grpc.ServiceDesc for NetworkEndpointGroups service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var NetworkEndpointGroups_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.NetworkEndpointGroups",
	HandlerType: (*NetworkEndpointGroupsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AggregatedList",
			Handler:    _NetworkEndpointGroups_AggregatedList_Handler,
		},
		{
			MethodName: "AttachNetworkEndpoints",
			Handler:    _NetworkEndpointGroups_AttachNetworkEndpoints_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _NetworkEndpointGroups_Delete_Handler,
		},
		{
			MethodName: "DetachNetworkEndpoints",
			Handler:    _NetworkEndpointGroups_DetachNetworkEndpoints_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _NetworkEndpointGroups_Get_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _NetworkEndpointGroups_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _NetworkEndpointGroups_List_Handler,
		},
		{
			MethodName: "ListNetworkEndpoints",
			Handler:    _NetworkEndpointGroups_ListNetworkEndpoints_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _NetworkEndpointGroups_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	NetworkFirewallPolicies_AddAssociation_FullMethodName            = "/google.cloud.compute.v1beta.NetworkFirewallPolicies/AddAssociation"
	NetworkFirewallPolicies_AddPacketMirroringRule_FullMethodName    = "/google.cloud.compute.v1beta.NetworkFirewallPolicies/AddPacketMirroringRule"
	NetworkFirewallPolicies_AddRule_FullMethodName                   = "/google.cloud.compute.v1beta.NetworkFirewallPolicies/AddRule"
	NetworkFirewallPolicies_AggregatedList_FullMethodName            = "/google.cloud.compute.v1beta.NetworkFirewallPolicies/AggregatedList"
	NetworkFirewallPolicies_CloneRules_FullMethodName                = "/google.cloud.compute.v1beta.NetworkFirewallPolicies/CloneRules"
	NetworkFirewallPolicies_Delete_FullMethodName                    = "/google.cloud.compute.v1beta.NetworkFirewallPolicies/Delete"
	NetworkFirewallPolicies_Get_FullMethodName                       = "/google.cloud.compute.v1beta.NetworkFirewallPolicies/Get"
	NetworkFirewallPolicies_GetAssociation_FullMethodName            = "/google.cloud.compute.v1beta.NetworkFirewallPolicies/GetAssociation"
	NetworkFirewallPolicies_GetIamPolicy_FullMethodName              = "/google.cloud.compute.v1beta.NetworkFirewallPolicies/GetIamPolicy"
	NetworkFirewallPolicies_GetPacketMirroringRule_FullMethodName    = "/google.cloud.compute.v1beta.NetworkFirewallPolicies/GetPacketMirroringRule"
	NetworkFirewallPolicies_GetRule_FullMethodName                   = "/google.cloud.compute.v1beta.NetworkFirewallPolicies/GetRule"
	NetworkFirewallPolicies_Insert_FullMethodName                    = "/google.cloud.compute.v1beta.NetworkFirewallPolicies/Insert"
	NetworkFirewallPolicies_List_FullMethodName                      = "/google.cloud.compute.v1beta.NetworkFirewallPolicies/List"
	NetworkFirewallPolicies_Patch_FullMethodName                     = "/google.cloud.compute.v1beta.NetworkFirewallPolicies/Patch"
	NetworkFirewallPolicies_PatchPacketMirroringRule_FullMethodName  = "/google.cloud.compute.v1beta.NetworkFirewallPolicies/PatchPacketMirroringRule"
	NetworkFirewallPolicies_PatchRule_FullMethodName                 = "/google.cloud.compute.v1beta.NetworkFirewallPolicies/PatchRule"
	NetworkFirewallPolicies_RemoveAssociation_FullMethodName         = "/google.cloud.compute.v1beta.NetworkFirewallPolicies/RemoveAssociation"
	NetworkFirewallPolicies_RemovePacketMirroringRule_FullMethodName = "/google.cloud.compute.v1beta.NetworkFirewallPolicies/RemovePacketMirroringRule"
	NetworkFirewallPolicies_RemoveRule_FullMethodName                = "/google.cloud.compute.v1beta.NetworkFirewallPolicies/RemoveRule"
	NetworkFirewallPolicies_SetIamPolicy_FullMethodName              = "/google.cloud.compute.v1beta.NetworkFirewallPolicies/SetIamPolicy"
	NetworkFirewallPolicies_TestIamPermissions_FullMethodName        = "/google.cloud.compute.v1beta.NetworkFirewallPolicies/TestIamPermissions"
)

// NetworkFirewallPoliciesClient is the client API for NetworkFirewallPolicies service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type NetworkFirewallPoliciesClient interface {
	// Inserts an association for the specified firewall policy.
	AddAssociation(ctx context.Context, in *AddAssociationNetworkFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error)
	// Inserts a packet mirroring rule into a firewall policy.
	AddPacketMirroringRule(ctx context.Context, in *AddPacketMirroringRuleNetworkFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error)
	// Inserts a rule into a firewall policy.
	AddRule(ctx context.Context, in *AddRuleNetworkFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves an aggregated list of network firewall policies, listing network firewall policies from all applicable scopes (global and regional) and grouping the results per scope. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(ctx context.Context, in *AggregatedListNetworkFirewallPoliciesRequest, opts ...grpc.CallOption) (*NetworkFirewallPolicyAggregatedList, error)
	// Copies rules to the specified firewall policy.
	CloneRules(ctx context.Context, in *CloneRulesNetworkFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error)
	// Deletes the specified policy.
	Delete(ctx context.Context, in *DeleteNetworkFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns the specified network firewall policy.
	Get(ctx context.Context, in *GetNetworkFirewallPolicyRequest, opts ...grpc.CallOption) (*FirewallPolicy, error)
	// Gets an association with the specified name.
	GetAssociation(ctx context.Context, in *GetAssociationNetworkFirewallPolicyRequest, opts ...grpc.CallOption) (*FirewallPolicyAssociation, error)
	// Gets the access control policy for a resource. May be empty if no such policy or resource exists.
	GetIamPolicy(ctx context.Context, in *GetIamPolicyNetworkFirewallPolicyRequest, opts ...grpc.CallOption) (*Policy, error)
	// Gets a packet mirroring rule of the specified priority.
	GetPacketMirroringRule(ctx context.Context, in *GetPacketMirroringRuleNetworkFirewallPolicyRequest, opts ...grpc.CallOption) (*FirewallPolicyRule, error)
	// Gets a rule of the specified priority.
	GetRule(ctx context.Context, in *GetRuleNetworkFirewallPolicyRequest, opts ...grpc.CallOption) (*FirewallPolicyRule, error)
	// Creates a new policy in the specified project using the data included in the request.
	Insert(ctx context.Context, in *InsertNetworkFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error)
	// Lists all the policies that have been configured for the specified project.
	List(ctx context.Context, in *ListNetworkFirewallPoliciesRequest, opts ...grpc.CallOption) (*FirewallPolicyList, error)
	// Patches the specified policy with the data included in the request.
	Patch(ctx context.Context, in *PatchNetworkFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error)
	// Patches a packet mirroring rule of the specified priority.
	PatchPacketMirroringRule(ctx context.Context, in *PatchPacketMirroringRuleNetworkFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error)
	// Patches a rule of the specified priority.
	PatchRule(ctx context.Context, in *PatchRuleNetworkFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error)
	// Removes an association for the specified firewall policy.
	RemoveAssociation(ctx context.Context, in *RemoveAssociationNetworkFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error)
	// Deletes a packet mirroring rule of the specified priority.
	RemovePacketMirroringRule(ctx context.Context, in *RemovePacketMirroringRuleNetworkFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error)
	// Deletes a rule of the specified priority.
	RemoveRule(ctx context.Context, in *RemoveRuleNetworkFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the access control policy on the specified resource. Replaces any existing policy.
	SetIamPolicy(ctx context.Context, in *SetIamPolicyNetworkFirewallPolicyRequest, opts ...grpc.CallOption) (*Policy, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(ctx context.Context, in *TestIamPermissionsNetworkFirewallPolicyRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error)
}

type networkFirewallPoliciesClient struct {
	cc grpc.ClientConnInterface
}

func NewNetworkFirewallPoliciesClient(cc grpc.ClientConnInterface) NetworkFirewallPoliciesClient {
	return &networkFirewallPoliciesClient{cc}
}

func (c *networkFirewallPoliciesClient) AddAssociation(ctx context.Context, in *AddAssociationNetworkFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, NetworkFirewallPolicies_AddAssociation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkFirewallPoliciesClient) AddPacketMirroringRule(ctx context.Context, in *AddPacketMirroringRuleNetworkFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, NetworkFirewallPolicies_AddPacketMirroringRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkFirewallPoliciesClient) AddRule(ctx context.Context, in *AddRuleNetworkFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, NetworkFirewallPolicies_AddRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkFirewallPoliciesClient) AggregatedList(ctx context.Context, in *AggregatedListNetworkFirewallPoliciesRequest, opts ...grpc.CallOption) (*NetworkFirewallPolicyAggregatedList, error) {
	out := new(NetworkFirewallPolicyAggregatedList)
	err := c.cc.Invoke(ctx, NetworkFirewallPolicies_AggregatedList_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkFirewallPoliciesClient) CloneRules(ctx context.Context, in *CloneRulesNetworkFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, NetworkFirewallPolicies_CloneRules_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkFirewallPoliciesClient) Delete(ctx context.Context, in *DeleteNetworkFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, NetworkFirewallPolicies_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkFirewallPoliciesClient) Get(ctx context.Context, in *GetNetworkFirewallPolicyRequest, opts ...grpc.CallOption) (*FirewallPolicy, error) {
	out := new(FirewallPolicy)
	err := c.cc.Invoke(ctx, NetworkFirewallPolicies_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkFirewallPoliciesClient) GetAssociation(ctx context.Context, in *GetAssociationNetworkFirewallPolicyRequest, opts ...grpc.CallOption) (*FirewallPolicyAssociation, error) {
	out := new(FirewallPolicyAssociation)
	err := c.cc.Invoke(ctx, NetworkFirewallPolicies_GetAssociation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkFirewallPoliciesClient) GetIamPolicy(ctx context.Context, in *GetIamPolicyNetworkFirewallPolicyRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, NetworkFirewallPolicies_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkFirewallPoliciesClient) GetPacketMirroringRule(ctx context.Context, in *GetPacketMirroringRuleNetworkFirewallPolicyRequest, opts ...grpc.CallOption) (*FirewallPolicyRule, error) {
	out := new(FirewallPolicyRule)
	err := c.cc.Invoke(ctx, NetworkFirewallPolicies_GetPacketMirroringRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkFirewallPoliciesClient) GetRule(ctx context.Context, in *GetRuleNetworkFirewallPolicyRequest, opts ...grpc.CallOption) (*FirewallPolicyRule, error) {
	out := new(FirewallPolicyRule)
	err := c.cc.Invoke(ctx, NetworkFirewallPolicies_GetRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkFirewallPoliciesClient) Insert(ctx context.Context, in *InsertNetworkFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, NetworkFirewallPolicies_Insert_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkFirewallPoliciesClient) List(ctx context.Context, in *ListNetworkFirewallPoliciesRequest, opts ...grpc.CallOption) (*FirewallPolicyList, error) {
	out := new(FirewallPolicyList)
	err := c.cc.Invoke(ctx, NetworkFirewallPolicies_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkFirewallPoliciesClient) Patch(ctx context.Context, in *PatchNetworkFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, NetworkFirewallPolicies_Patch_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkFirewallPoliciesClient) PatchPacketMirroringRule(ctx context.Context, in *PatchPacketMirroringRuleNetworkFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, NetworkFirewallPolicies_PatchPacketMirroringRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkFirewallPoliciesClient) PatchRule(ctx context.Context, in *PatchRuleNetworkFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, NetworkFirewallPolicies_PatchRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkFirewallPoliciesClient) RemoveAssociation(ctx context.Context, in *RemoveAssociationNetworkFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, NetworkFirewallPolicies_RemoveAssociation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkFirewallPoliciesClient) RemovePacketMirroringRule(ctx context.Context, in *RemovePacketMirroringRuleNetworkFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, NetworkFirewallPolicies_RemovePacketMirroringRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkFirewallPoliciesClient) RemoveRule(ctx context.Context, in *RemoveRuleNetworkFirewallPolicyRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, NetworkFirewallPolicies_RemoveRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkFirewallPoliciesClient) SetIamPolicy(ctx context.Context, in *SetIamPolicyNetworkFirewallPolicyRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, NetworkFirewallPolicies_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkFirewallPoliciesClient) TestIamPermissions(ctx context.Context, in *TestIamPermissionsNetworkFirewallPolicyRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error) {
	out := new(TestPermissionsResponse)
	err := c.cc.Invoke(ctx, NetworkFirewallPolicies_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// NetworkFirewallPoliciesServer is the server API for NetworkFirewallPolicies service.
// All implementations should embed UnimplementedNetworkFirewallPoliciesServer
// for forward compatibility
type NetworkFirewallPoliciesServer interface {
	// Inserts an association for the specified firewall policy.
	AddAssociation(context.Context, *AddAssociationNetworkFirewallPolicyRequest) (*Operation, error)
	// Inserts a packet mirroring rule into a firewall policy.
	AddPacketMirroringRule(context.Context, *AddPacketMirroringRuleNetworkFirewallPolicyRequest) (*Operation, error)
	// Inserts a rule into a firewall policy.
	AddRule(context.Context, *AddRuleNetworkFirewallPolicyRequest) (*Operation, error)
	// Retrieves an aggregated list of network firewall policies, listing network firewall policies from all applicable scopes (global and regional) and grouping the results per scope. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(context.Context, *AggregatedListNetworkFirewallPoliciesRequest) (*NetworkFirewallPolicyAggregatedList, error)
	// Copies rules to the specified firewall policy.
	CloneRules(context.Context, *CloneRulesNetworkFirewallPolicyRequest) (*Operation, error)
	// Deletes the specified policy.
	Delete(context.Context, *DeleteNetworkFirewallPolicyRequest) (*Operation, error)
	// Returns the specified network firewall policy.
	Get(context.Context, *GetNetworkFirewallPolicyRequest) (*FirewallPolicy, error)
	// Gets an association with the specified name.
	GetAssociation(context.Context, *GetAssociationNetworkFirewallPolicyRequest) (*FirewallPolicyAssociation, error)
	// Gets the access control policy for a resource. May be empty if no such policy or resource exists.
	GetIamPolicy(context.Context, *GetIamPolicyNetworkFirewallPolicyRequest) (*Policy, error)
	// Gets a packet mirroring rule of the specified priority.
	GetPacketMirroringRule(context.Context, *GetPacketMirroringRuleNetworkFirewallPolicyRequest) (*FirewallPolicyRule, error)
	// Gets a rule of the specified priority.
	GetRule(context.Context, *GetRuleNetworkFirewallPolicyRequest) (*FirewallPolicyRule, error)
	// Creates a new policy in the specified project using the data included in the request.
	Insert(context.Context, *InsertNetworkFirewallPolicyRequest) (*Operation, error)
	// Lists all the policies that have been configured for the specified project.
	List(context.Context, *ListNetworkFirewallPoliciesRequest) (*FirewallPolicyList, error)
	// Patches the specified policy with the data included in the request.
	Patch(context.Context, *PatchNetworkFirewallPolicyRequest) (*Operation, error)
	// Patches a packet mirroring rule of the specified priority.
	PatchPacketMirroringRule(context.Context, *PatchPacketMirroringRuleNetworkFirewallPolicyRequest) (*Operation, error)
	// Patches a rule of the specified priority.
	PatchRule(context.Context, *PatchRuleNetworkFirewallPolicyRequest) (*Operation, error)
	// Removes an association for the specified firewall policy.
	RemoveAssociation(context.Context, *RemoveAssociationNetworkFirewallPolicyRequest) (*Operation, error)
	// Deletes a packet mirroring rule of the specified priority.
	RemovePacketMirroringRule(context.Context, *RemovePacketMirroringRuleNetworkFirewallPolicyRequest) (*Operation, error)
	// Deletes a rule of the specified priority.
	RemoveRule(context.Context, *RemoveRuleNetworkFirewallPolicyRequest) (*Operation, error)
	// Sets the access control policy on the specified resource. Replaces any existing policy.
	SetIamPolicy(context.Context, *SetIamPolicyNetworkFirewallPolicyRequest) (*Policy, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(context.Context, *TestIamPermissionsNetworkFirewallPolicyRequest) (*TestPermissionsResponse, error)
}

// UnimplementedNetworkFirewallPoliciesServer should be embedded to have forward compatible implementations.
type UnimplementedNetworkFirewallPoliciesServer struct {
}

func (UnimplementedNetworkFirewallPoliciesServer) AddAssociation(context.Context, *AddAssociationNetworkFirewallPolicyRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddAssociation not implemented")
}
func (UnimplementedNetworkFirewallPoliciesServer) AddPacketMirroringRule(context.Context, *AddPacketMirroringRuleNetworkFirewallPolicyRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddPacketMirroringRule not implemented")
}
func (UnimplementedNetworkFirewallPoliciesServer) AddRule(context.Context, *AddRuleNetworkFirewallPolicyRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddRule not implemented")
}
func (UnimplementedNetworkFirewallPoliciesServer) AggregatedList(context.Context, *AggregatedListNetworkFirewallPoliciesRequest) (*NetworkFirewallPolicyAggregatedList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AggregatedList not implemented")
}
func (UnimplementedNetworkFirewallPoliciesServer) CloneRules(context.Context, *CloneRulesNetworkFirewallPolicyRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CloneRules not implemented")
}
func (UnimplementedNetworkFirewallPoliciesServer) Delete(context.Context, *DeleteNetworkFirewallPolicyRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedNetworkFirewallPoliciesServer) Get(context.Context, *GetNetworkFirewallPolicyRequest) (*FirewallPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedNetworkFirewallPoliciesServer) GetAssociation(context.Context, *GetAssociationNetworkFirewallPolicyRequest) (*FirewallPolicyAssociation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAssociation not implemented")
}
func (UnimplementedNetworkFirewallPoliciesServer) GetIamPolicy(context.Context, *GetIamPolicyNetworkFirewallPolicyRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedNetworkFirewallPoliciesServer) GetPacketMirroringRule(context.Context, *GetPacketMirroringRuleNetworkFirewallPolicyRequest) (*FirewallPolicyRule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetPacketMirroringRule not implemented")
}
func (UnimplementedNetworkFirewallPoliciesServer) GetRule(context.Context, *GetRuleNetworkFirewallPolicyRequest) (*FirewallPolicyRule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRule not implemented")
}
func (UnimplementedNetworkFirewallPoliciesServer) Insert(context.Context, *InsertNetworkFirewallPolicyRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (UnimplementedNetworkFirewallPoliciesServer) List(context.Context, *ListNetworkFirewallPoliciesRequest) (*FirewallPolicyList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedNetworkFirewallPoliciesServer) Patch(context.Context, *PatchNetworkFirewallPolicyRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Patch not implemented")
}
func (UnimplementedNetworkFirewallPoliciesServer) PatchPacketMirroringRule(context.Context, *PatchPacketMirroringRuleNetworkFirewallPolicyRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PatchPacketMirroringRule not implemented")
}
func (UnimplementedNetworkFirewallPoliciesServer) PatchRule(context.Context, *PatchRuleNetworkFirewallPolicyRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PatchRule not implemented")
}
func (UnimplementedNetworkFirewallPoliciesServer) RemoveAssociation(context.Context, *RemoveAssociationNetworkFirewallPolicyRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveAssociation not implemented")
}
func (UnimplementedNetworkFirewallPoliciesServer) RemovePacketMirroringRule(context.Context, *RemovePacketMirroringRuleNetworkFirewallPolicyRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemovePacketMirroringRule not implemented")
}
func (UnimplementedNetworkFirewallPoliciesServer) RemoveRule(context.Context, *RemoveRuleNetworkFirewallPolicyRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveRule not implemented")
}
func (UnimplementedNetworkFirewallPoliciesServer) SetIamPolicy(context.Context, *SetIamPolicyNetworkFirewallPolicyRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedNetworkFirewallPoliciesServer) TestIamPermissions(context.Context, *TestIamPermissionsNetworkFirewallPolicyRequest) (*TestPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

// UnsafeNetworkFirewallPoliciesServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to NetworkFirewallPoliciesServer will
// result in compilation errors.
type UnsafeNetworkFirewallPoliciesServer interface {
	mustEmbedUnimplementedNetworkFirewallPoliciesServer()
}

func RegisterNetworkFirewallPoliciesServer(s grpc.ServiceRegistrar, srv NetworkFirewallPoliciesServer) {
	s.RegisterService(&NetworkFirewallPolicies_ServiceDesc, srv)
}

func _NetworkFirewallPolicies_AddAssociation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddAssociationNetworkFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkFirewallPoliciesServer).AddAssociation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkFirewallPolicies_AddAssociation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkFirewallPoliciesServer).AddAssociation(ctx, req.(*AddAssociationNetworkFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkFirewallPolicies_AddPacketMirroringRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddPacketMirroringRuleNetworkFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkFirewallPoliciesServer).AddPacketMirroringRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkFirewallPolicies_AddPacketMirroringRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkFirewallPoliciesServer).AddPacketMirroringRule(ctx, req.(*AddPacketMirroringRuleNetworkFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkFirewallPolicies_AddRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddRuleNetworkFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkFirewallPoliciesServer).AddRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkFirewallPolicies_AddRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkFirewallPoliciesServer).AddRule(ctx, req.(*AddRuleNetworkFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkFirewallPolicies_AggregatedList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AggregatedListNetworkFirewallPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkFirewallPoliciesServer).AggregatedList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkFirewallPolicies_AggregatedList_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkFirewallPoliciesServer).AggregatedList(ctx, req.(*AggregatedListNetworkFirewallPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkFirewallPolicies_CloneRules_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CloneRulesNetworkFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkFirewallPoliciesServer).CloneRules(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkFirewallPolicies_CloneRules_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkFirewallPoliciesServer).CloneRules(ctx, req.(*CloneRulesNetworkFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkFirewallPolicies_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNetworkFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkFirewallPoliciesServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkFirewallPolicies_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkFirewallPoliciesServer).Delete(ctx, req.(*DeleteNetworkFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkFirewallPolicies_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNetworkFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkFirewallPoliciesServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkFirewallPolicies_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkFirewallPoliciesServer).Get(ctx, req.(*GetNetworkFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkFirewallPolicies_GetAssociation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAssociationNetworkFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkFirewallPoliciesServer).GetAssociation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkFirewallPolicies_GetAssociation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkFirewallPoliciesServer).GetAssociation(ctx, req.(*GetAssociationNetworkFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkFirewallPolicies_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIamPolicyNetworkFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkFirewallPoliciesServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkFirewallPolicies_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkFirewallPoliciesServer).GetIamPolicy(ctx, req.(*GetIamPolicyNetworkFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkFirewallPolicies_GetPacketMirroringRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetPacketMirroringRuleNetworkFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkFirewallPoliciesServer).GetPacketMirroringRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkFirewallPolicies_GetPacketMirroringRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkFirewallPoliciesServer).GetPacketMirroringRule(ctx, req.(*GetPacketMirroringRuleNetworkFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkFirewallPolicies_GetRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRuleNetworkFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkFirewallPoliciesServer).GetRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkFirewallPolicies_GetRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkFirewallPoliciesServer).GetRule(ctx, req.(*GetRuleNetworkFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkFirewallPolicies_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertNetworkFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkFirewallPoliciesServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkFirewallPolicies_Insert_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkFirewallPoliciesServer).Insert(ctx, req.(*InsertNetworkFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkFirewallPolicies_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNetworkFirewallPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkFirewallPoliciesServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkFirewallPolicies_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkFirewallPoliciesServer).List(ctx, req.(*ListNetworkFirewallPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkFirewallPolicies_Patch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchNetworkFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkFirewallPoliciesServer).Patch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkFirewallPolicies_Patch_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkFirewallPoliciesServer).Patch(ctx, req.(*PatchNetworkFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkFirewallPolicies_PatchPacketMirroringRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchPacketMirroringRuleNetworkFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkFirewallPoliciesServer).PatchPacketMirroringRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkFirewallPolicies_PatchPacketMirroringRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkFirewallPoliciesServer).PatchPacketMirroringRule(ctx, req.(*PatchPacketMirroringRuleNetworkFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkFirewallPolicies_PatchRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchRuleNetworkFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkFirewallPoliciesServer).PatchRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkFirewallPolicies_PatchRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkFirewallPoliciesServer).PatchRule(ctx, req.(*PatchRuleNetworkFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkFirewallPolicies_RemoveAssociation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveAssociationNetworkFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkFirewallPoliciesServer).RemoveAssociation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkFirewallPolicies_RemoveAssociation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkFirewallPoliciesServer).RemoveAssociation(ctx, req.(*RemoveAssociationNetworkFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkFirewallPolicies_RemovePacketMirroringRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemovePacketMirroringRuleNetworkFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkFirewallPoliciesServer).RemovePacketMirroringRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkFirewallPolicies_RemovePacketMirroringRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkFirewallPoliciesServer).RemovePacketMirroringRule(ctx, req.(*RemovePacketMirroringRuleNetworkFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkFirewallPolicies_RemoveRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveRuleNetworkFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkFirewallPoliciesServer).RemoveRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkFirewallPolicies_RemoveRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkFirewallPoliciesServer).RemoveRule(ctx, req.(*RemoveRuleNetworkFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkFirewallPolicies_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetIamPolicyNetworkFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkFirewallPoliciesServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkFirewallPolicies_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkFirewallPoliciesServer).SetIamPolicy(ctx, req.(*SetIamPolicyNetworkFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkFirewallPolicies_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TestIamPermissionsNetworkFirewallPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkFirewallPoliciesServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkFirewallPolicies_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkFirewallPoliciesServer).TestIamPermissions(ctx, req.(*TestIamPermissionsNetworkFirewallPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// NetworkFirewallPolicies_ServiceDesc is the grpc.ServiceDesc for NetworkFirewallPolicies service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var NetworkFirewallPolicies_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.NetworkFirewallPolicies",
	HandlerType: (*NetworkFirewallPoliciesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AddAssociation",
			Handler:    _NetworkFirewallPolicies_AddAssociation_Handler,
		},
		{
			MethodName: "AddPacketMirroringRule",
			Handler:    _NetworkFirewallPolicies_AddPacketMirroringRule_Handler,
		},
		{
			MethodName: "AddRule",
			Handler:    _NetworkFirewallPolicies_AddRule_Handler,
		},
		{
			MethodName: "AggregatedList",
			Handler:    _NetworkFirewallPolicies_AggregatedList_Handler,
		},
		{
			MethodName: "CloneRules",
			Handler:    _NetworkFirewallPolicies_CloneRules_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _NetworkFirewallPolicies_Delete_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _NetworkFirewallPolicies_Get_Handler,
		},
		{
			MethodName: "GetAssociation",
			Handler:    _NetworkFirewallPolicies_GetAssociation_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _NetworkFirewallPolicies_GetIamPolicy_Handler,
		},
		{
			MethodName: "GetPacketMirroringRule",
			Handler:    _NetworkFirewallPolicies_GetPacketMirroringRule_Handler,
		},
		{
			MethodName: "GetRule",
			Handler:    _NetworkFirewallPolicies_GetRule_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _NetworkFirewallPolicies_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _NetworkFirewallPolicies_List_Handler,
		},
		{
			MethodName: "Patch",
			Handler:    _NetworkFirewallPolicies_Patch_Handler,
		},
		{
			MethodName: "PatchPacketMirroringRule",
			Handler:    _NetworkFirewallPolicies_PatchPacketMirroringRule_Handler,
		},
		{
			MethodName: "PatchRule",
			Handler:    _NetworkFirewallPolicies_PatchRule_Handler,
		},
		{
			MethodName: "RemoveAssociation",
			Handler:    _NetworkFirewallPolicies_RemoveAssociation_Handler,
		},
		{
			MethodName: "RemovePacketMirroringRule",
			Handler:    _NetworkFirewallPolicies_RemovePacketMirroringRule_Handler,
		},
		{
			MethodName: "RemoveRule",
			Handler:    _NetworkFirewallPolicies_RemoveRule_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _NetworkFirewallPolicies_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _NetworkFirewallPolicies_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	NetworkProfiles_Get_FullMethodName  = "/google.cloud.compute.v1beta.NetworkProfiles/Get"
	NetworkProfiles_List_FullMethodName = "/google.cloud.compute.v1beta.NetworkProfiles/List"
)

// NetworkProfilesClient is the client API for NetworkProfiles service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type NetworkProfilesClient interface {
	// Returns the specified network profile.
	Get(ctx context.Context, in *GetNetworkProfileRequest, opts ...grpc.CallOption) (*NetworkProfile, error)
	// Retrieves a list of network profiles available to the specified project.
	List(ctx context.Context, in *ListNetworkProfilesRequest, opts ...grpc.CallOption) (*NetworkProfilesListResponse, error)
}

type networkProfilesClient struct {
	cc grpc.ClientConnInterface
}

func NewNetworkProfilesClient(cc grpc.ClientConnInterface) NetworkProfilesClient {
	return &networkProfilesClient{cc}
}

func (c *networkProfilesClient) Get(ctx context.Context, in *GetNetworkProfileRequest, opts ...grpc.CallOption) (*NetworkProfile, error) {
	out := new(NetworkProfile)
	err := c.cc.Invoke(ctx, NetworkProfiles_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networkProfilesClient) List(ctx context.Context, in *ListNetworkProfilesRequest, opts ...grpc.CallOption) (*NetworkProfilesListResponse, error) {
	out := new(NetworkProfilesListResponse)
	err := c.cc.Invoke(ctx, NetworkProfiles_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// NetworkProfilesServer is the server API for NetworkProfiles service.
// All implementations should embed UnimplementedNetworkProfilesServer
// for forward compatibility
type NetworkProfilesServer interface {
	// Returns the specified network profile.
	Get(context.Context, *GetNetworkProfileRequest) (*NetworkProfile, error)
	// Retrieves a list of network profiles available to the specified project.
	List(context.Context, *ListNetworkProfilesRequest) (*NetworkProfilesListResponse, error)
}

// UnimplementedNetworkProfilesServer should be embedded to have forward compatible implementations.
type UnimplementedNetworkProfilesServer struct {
}

func (UnimplementedNetworkProfilesServer) Get(context.Context, *GetNetworkProfileRequest) (*NetworkProfile, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedNetworkProfilesServer) List(context.Context, *ListNetworkProfilesRequest) (*NetworkProfilesListResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}

// UnsafeNetworkProfilesServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to NetworkProfilesServer will
// result in compilation errors.
type UnsafeNetworkProfilesServer interface {
	mustEmbedUnimplementedNetworkProfilesServer()
}

func RegisterNetworkProfilesServer(s grpc.ServiceRegistrar, srv NetworkProfilesServer) {
	s.RegisterService(&NetworkProfiles_ServiceDesc, srv)
}

func _NetworkProfiles_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNetworkProfileRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkProfilesServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkProfiles_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkProfilesServer).Get(ctx, req.(*GetNetworkProfileRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NetworkProfiles_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNetworkProfilesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworkProfilesServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NetworkProfiles_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworkProfilesServer).List(ctx, req.(*ListNetworkProfilesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// NetworkProfiles_ServiceDesc is the grpc.ServiceDesc for NetworkProfiles service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var NetworkProfiles_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.NetworkProfiles",
	HandlerType: (*NetworkProfilesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Get",
			Handler:    _NetworkProfiles_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _NetworkProfiles_List_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	Networks_AddPeering_FullMethodName            = "/google.cloud.compute.v1beta.Networks/AddPeering"
	Networks_Delete_FullMethodName                = "/google.cloud.compute.v1beta.Networks/Delete"
	Networks_Get_FullMethodName                   = "/google.cloud.compute.v1beta.Networks/Get"
	Networks_GetEffectiveFirewalls_FullMethodName = "/google.cloud.compute.v1beta.Networks/GetEffectiveFirewalls"
	Networks_Insert_FullMethodName                = "/google.cloud.compute.v1beta.Networks/Insert"
	Networks_List_FullMethodName                  = "/google.cloud.compute.v1beta.Networks/List"
	Networks_ListPeeringRoutes_FullMethodName     = "/google.cloud.compute.v1beta.Networks/ListPeeringRoutes"
	Networks_Patch_FullMethodName                 = "/google.cloud.compute.v1beta.Networks/Patch"
	Networks_RemovePeering_FullMethodName         = "/google.cloud.compute.v1beta.Networks/RemovePeering"
	Networks_RequestRemovePeering_FullMethodName  = "/google.cloud.compute.v1beta.Networks/RequestRemovePeering"
	Networks_SwitchToCustomMode_FullMethodName    = "/google.cloud.compute.v1beta.Networks/SwitchToCustomMode"
	Networks_TestIamPermissions_FullMethodName    = "/google.cloud.compute.v1beta.Networks/TestIamPermissions"
	Networks_UpdatePeering_FullMethodName         = "/google.cloud.compute.v1beta.Networks/UpdatePeering"
)

// NetworksClient is the client API for Networks service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type NetworksClient interface {
	// Adds a peering to the specified network.
	AddPeering(ctx context.Context, in *AddPeeringNetworkRequest, opts ...grpc.CallOption) (*Operation, error)
	// Deletes the specified network.
	Delete(ctx context.Context, in *DeleteNetworkRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns the specified network.
	Get(ctx context.Context, in *GetNetworkRequest, opts ...grpc.CallOption) (*Network, error)
	// Returns the effective firewalls on a given network.
	GetEffectiveFirewalls(ctx context.Context, in *GetEffectiveFirewallsNetworkRequest, opts ...grpc.CallOption) (*NetworksGetEffectiveFirewallsResponse, error)
	// Creates a network in the specified project using the data included in the request.
	Insert(ctx context.Context, in *InsertNetworkRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves the list of networks available to the specified project.
	List(ctx context.Context, in *ListNetworksRequest, opts ...grpc.CallOption) (*NetworkList, error)
	// Lists the peering routes exchanged over peering connection.
	ListPeeringRoutes(ctx context.Context, in *ListPeeringRoutesNetworksRequest, opts ...grpc.CallOption) (*ExchangedPeeringRoutesList, error)
	// Patches the specified network with the data included in the request. Only routingConfig can be modified.
	Patch(ctx context.Context, in *PatchNetworkRequest, opts ...grpc.CallOption) (*Operation, error)
	// Removes a peering from the specified network.
	RemovePeering(ctx context.Context, in *RemovePeeringNetworkRequest, opts ...grpc.CallOption) (*Operation, error)
	// Requests to remove a peering from the specified network. Applicable only for PeeringConnection with update_strategy=CONSENSUS.
	RequestRemovePeering(ctx context.Context, in *RequestRemovePeeringNetworkRequest, opts ...grpc.CallOption) (*Operation, error)
	// Switches the network mode from auto subnet mode to custom subnet mode.
	SwitchToCustomMode(ctx context.Context, in *SwitchToCustomModeNetworkRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(ctx context.Context, in *TestIamPermissionsNetworkRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error)
	// Updates the specified network peering with the data included in the request. You can only modify the NetworkPeering.export_custom_routes field and the NetworkPeering.import_custom_routes field.
	UpdatePeering(ctx context.Context, in *UpdatePeeringNetworkRequest, opts ...grpc.CallOption) (*Operation, error)
}

type networksClient struct {
	cc grpc.ClientConnInterface
}

func NewNetworksClient(cc grpc.ClientConnInterface) NetworksClient {
	return &networksClient{cc}
}

func (c *networksClient) AddPeering(ctx context.Context, in *AddPeeringNetworkRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Networks_AddPeering_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networksClient) Delete(ctx context.Context, in *DeleteNetworkRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Networks_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networksClient) Get(ctx context.Context, in *GetNetworkRequest, opts ...grpc.CallOption) (*Network, error) {
	out := new(Network)
	err := c.cc.Invoke(ctx, Networks_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networksClient) GetEffectiveFirewalls(ctx context.Context, in *GetEffectiveFirewallsNetworkRequest, opts ...grpc.CallOption) (*NetworksGetEffectiveFirewallsResponse, error) {
	out := new(NetworksGetEffectiveFirewallsResponse)
	err := c.cc.Invoke(ctx, Networks_GetEffectiveFirewalls_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networksClient) Insert(ctx context.Context, in *InsertNetworkRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Networks_Insert_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networksClient) List(ctx context.Context, in *ListNetworksRequest, opts ...grpc.CallOption) (*NetworkList, error) {
	out := new(NetworkList)
	err := c.cc.Invoke(ctx, Networks_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networksClient) ListPeeringRoutes(ctx context.Context, in *ListPeeringRoutesNetworksRequest, opts ...grpc.CallOption) (*ExchangedPeeringRoutesList, error) {
	out := new(ExchangedPeeringRoutesList)
	err := c.cc.Invoke(ctx, Networks_ListPeeringRoutes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networksClient) Patch(ctx context.Context, in *PatchNetworkRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Networks_Patch_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networksClient) RemovePeering(ctx context.Context, in *RemovePeeringNetworkRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Networks_RemovePeering_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networksClient) RequestRemovePeering(ctx context.Context, in *RequestRemovePeeringNetworkRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Networks_RequestRemovePeering_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networksClient) SwitchToCustomMode(ctx context.Context, in *SwitchToCustomModeNetworkRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Networks_SwitchToCustomMode_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networksClient) TestIamPermissions(ctx context.Context, in *TestIamPermissionsNetworkRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error) {
	out := new(TestPermissionsResponse)
	err := c.cc.Invoke(ctx, Networks_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *networksClient) UpdatePeering(ctx context.Context, in *UpdatePeeringNetworkRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, Networks_UpdatePeering_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// NetworksServer is the server API for Networks service.
// All implementations should embed UnimplementedNetworksServer
// for forward compatibility
type NetworksServer interface {
	// Adds a peering to the specified network.
	AddPeering(context.Context, *AddPeeringNetworkRequest) (*Operation, error)
	// Deletes the specified network.
	Delete(context.Context, *DeleteNetworkRequest) (*Operation, error)
	// Returns the specified network.
	Get(context.Context, *GetNetworkRequest) (*Network, error)
	// Returns the effective firewalls on a given network.
	GetEffectiveFirewalls(context.Context, *GetEffectiveFirewallsNetworkRequest) (*NetworksGetEffectiveFirewallsResponse, error)
	// Creates a network in the specified project using the data included in the request.
	Insert(context.Context, *InsertNetworkRequest) (*Operation, error)
	// Retrieves the list of networks available to the specified project.
	List(context.Context, *ListNetworksRequest) (*NetworkList, error)
	// Lists the peering routes exchanged over peering connection.
	ListPeeringRoutes(context.Context, *ListPeeringRoutesNetworksRequest) (*ExchangedPeeringRoutesList, error)
	// Patches the specified network with the data included in the request. Only routingConfig can be modified.
	Patch(context.Context, *PatchNetworkRequest) (*Operation, error)
	// Removes a peering from the specified network.
	RemovePeering(context.Context, *RemovePeeringNetworkRequest) (*Operation, error)
	// Requests to remove a peering from the specified network. Applicable only for PeeringConnection with update_strategy=CONSENSUS.
	RequestRemovePeering(context.Context, *RequestRemovePeeringNetworkRequest) (*Operation, error)
	// Switches the network mode from auto subnet mode to custom subnet mode.
	SwitchToCustomMode(context.Context, *SwitchToCustomModeNetworkRequest) (*Operation, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(context.Context, *TestIamPermissionsNetworkRequest) (*TestPermissionsResponse, error)
	// Updates the specified network peering with the data included in the request. You can only modify the NetworkPeering.export_custom_routes field and the NetworkPeering.import_custom_routes field.
	UpdatePeering(context.Context, *UpdatePeeringNetworkRequest) (*Operation, error)
}

// UnimplementedNetworksServer should be embedded to have forward compatible implementations.
type UnimplementedNetworksServer struct {
}

func (UnimplementedNetworksServer) AddPeering(context.Context, *AddPeeringNetworkRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddPeering not implemented")
}
func (UnimplementedNetworksServer) Delete(context.Context, *DeleteNetworkRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedNetworksServer) Get(context.Context, *GetNetworkRequest) (*Network, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedNetworksServer) GetEffectiveFirewalls(context.Context, *GetEffectiveFirewallsNetworkRequest) (*NetworksGetEffectiveFirewallsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetEffectiveFirewalls not implemented")
}
func (UnimplementedNetworksServer) Insert(context.Context, *InsertNetworkRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (UnimplementedNetworksServer) List(context.Context, *ListNetworksRequest) (*NetworkList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedNetworksServer) ListPeeringRoutes(context.Context, *ListPeeringRoutesNetworksRequest) (*ExchangedPeeringRoutesList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPeeringRoutes not implemented")
}
func (UnimplementedNetworksServer) Patch(context.Context, *PatchNetworkRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Patch not implemented")
}
func (UnimplementedNetworksServer) RemovePeering(context.Context, *RemovePeeringNetworkRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemovePeering not implemented")
}
func (UnimplementedNetworksServer) RequestRemovePeering(context.Context, *RequestRemovePeeringNetworkRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RequestRemovePeering not implemented")
}
func (UnimplementedNetworksServer) SwitchToCustomMode(context.Context, *SwitchToCustomModeNetworkRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SwitchToCustomMode not implemented")
}
func (UnimplementedNetworksServer) TestIamPermissions(context.Context, *TestIamPermissionsNetworkRequest) (*TestPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}
func (UnimplementedNetworksServer) UpdatePeering(context.Context, *UpdatePeeringNetworkRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdatePeering not implemented")
}

// UnsafeNetworksServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to NetworksServer will
// result in compilation errors.
type UnsafeNetworksServer interface {
	mustEmbedUnimplementedNetworksServer()
}

func RegisterNetworksServer(s grpc.ServiceRegistrar, srv NetworksServer) {
	s.RegisterService(&Networks_ServiceDesc, srv)
}

func _Networks_AddPeering_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddPeeringNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworksServer).AddPeering(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Networks_AddPeering_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworksServer).AddPeering(ctx, req.(*AddPeeringNetworkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Networks_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworksServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Networks_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworksServer).Delete(ctx, req.(*DeleteNetworkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Networks_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworksServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Networks_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworksServer).Get(ctx, req.(*GetNetworkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Networks_GetEffectiveFirewalls_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEffectiveFirewallsNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworksServer).GetEffectiveFirewalls(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Networks_GetEffectiveFirewalls_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworksServer).GetEffectiveFirewalls(ctx, req.(*GetEffectiveFirewallsNetworkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Networks_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworksServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Networks_Insert_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworksServer).Insert(ctx, req.(*InsertNetworkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Networks_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNetworksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworksServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Networks_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworksServer).List(ctx, req.(*ListNetworksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Networks_ListPeeringRoutes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPeeringRoutesNetworksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworksServer).ListPeeringRoutes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Networks_ListPeeringRoutes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworksServer).ListPeeringRoutes(ctx, req.(*ListPeeringRoutesNetworksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Networks_Patch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworksServer).Patch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Networks_Patch_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworksServer).Patch(ctx, req.(*PatchNetworkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Networks_RemovePeering_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemovePeeringNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworksServer).RemovePeering(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Networks_RemovePeering_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworksServer).RemovePeering(ctx, req.(*RemovePeeringNetworkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Networks_RequestRemovePeering_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RequestRemovePeeringNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworksServer).RequestRemovePeering(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Networks_RequestRemovePeering_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworksServer).RequestRemovePeering(ctx, req.(*RequestRemovePeeringNetworkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Networks_SwitchToCustomMode_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SwitchToCustomModeNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworksServer).SwitchToCustomMode(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Networks_SwitchToCustomMode_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworksServer).SwitchToCustomMode(ctx, req.(*SwitchToCustomModeNetworkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Networks_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TestIamPermissionsNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworksServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Networks_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworksServer).TestIamPermissions(ctx, req.(*TestIamPermissionsNetworkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Networks_UpdatePeering_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdatePeeringNetworkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NetworksServer).UpdatePeering(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: Networks_UpdatePeering_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NetworksServer).UpdatePeering(ctx, req.(*UpdatePeeringNetworkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// Networks_ServiceDesc is the grpc.ServiceDesc for Networks service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var Networks_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.Networks",
	HandlerType: (*NetworksServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AddPeering",
			Handler:    _Networks_AddPeering_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _Networks_Delete_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _Networks_Get_Handler,
		},
		{
			MethodName: "GetEffectiveFirewalls",
			Handler:    _Networks_GetEffectiveFirewalls_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _Networks_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _Networks_List_Handler,
		},
		{
			MethodName: "ListPeeringRoutes",
			Handler:    _Networks_ListPeeringRoutes_Handler,
		},
		{
			MethodName: "Patch",
			Handler:    _Networks_Patch_Handler,
		},
		{
			MethodName: "RemovePeering",
			Handler:    _Networks_RemovePeering_Handler,
		},
		{
			MethodName: "RequestRemovePeering",
			Handler:    _Networks_RequestRemovePeering_Handler,
		},
		{
			MethodName: "SwitchToCustomMode",
			Handler:    _Networks_SwitchToCustomMode_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _Networks_TestIamPermissions_Handler,
		},
		{
			MethodName: "UpdatePeering",
			Handler:    _Networks_UpdatePeering_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	NodeGroups_AddNodes_FullMethodName                 = "/google.cloud.compute.v1beta.NodeGroups/AddNodes"
	NodeGroups_AggregatedList_FullMethodName           = "/google.cloud.compute.v1beta.NodeGroups/AggregatedList"
	NodeGroups_Delete_FullMethodName                   = "/google.cloud.compute.v1beta.NodeGroups/Delete"
	NodeGroups_DeleteNodes_FullMethodName              = "/google.cloud.compute.v1beta.NodeGroups/DeleteNodes"
	NodeGroups_Get_FullMethodName                      = "/google.cloud.compute.v1beta.NodeGroups/Get"
	NodeGroups_GetIamPolicy_FullMethodName             = "/google.cloud.compute.v1beta.NodeGroups/GetIamPolicy"
	NodeGroups_Insert_FullMethodName                   = "/google.cloud.compute.v1beta.NodeGroups/Insert"
	NodeGroups_List_FullMethodName                     = "/google.cloud.compute.v1beta.NodeGroups/List"
	NodeGroups_ListNodes_FullMethodName                = "/google.cloud.compute.v1beta.NodeGroups/ListNodes"
	NodeGroups_Patch_FullMethodName                    = "/google.cloud.compute.v1beta.NodeGroups/Patch"
	NodeGroups_PerformMaintenance_FullMethodName       = "/google.cloud.compute.v1beta.NodeGroups/PerformMaintenance"
	NodeGroups_SetIamPolicy_FullMethodName             = "/google.cloud.compute.v1beta.NodeGroups/SetIamPolicy"
	NodeGroups_SetNodeTemplate_FullMethodName          = "/google.cloud.compute.v1beta.NodeGroups/SetNodeTemplate"
	NodeGroups_SimulateMaintenanceEvent_FullMethodName = "/google.cloud.compute.v1beta.NodeGroups/SimulateMaintenanceEvent"
	NodeGroups_TestIamPermissions_FullMethodName       = "/google.cloud.compute.v1beta.NodeGroups/TestIamPermissions"
)

// NodeGroupsClient is the client API for NodeGroups service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type NodeGroupsClient interface {
	// Adds specified number of nodes to the node group.
	AddNodes(ctx context.Context, in *AddNodesNodeGroupRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves an aggregated list of node groups. Note: use nodeGroups.listNodes for more details about each group. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(ctx context.Context, in *AggregatedListNodeGroupsRequest, opts ...grpc.CallOption) (*NodeGroupAggregatedList, error)
	// Deletes the specified NodeGroup resource.
	Delete(ctx context.Context, in *DeleteNodeGroupRequest, opts ...grpc.CallOption) (*Operation, error)
	// Deletes specified nodes from the node group.
	DeleteNodes(ctx context.Context, in *DeleteNodesNodeGroupRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns the specified NodeGroup. Get a list of available NodeGroups by making a list() request. Note: the "nodes" field should not be used. Use nodeGroups.listNodes instead.
	Get(ctx context.Context, in *GetNodeGroupRequest, opts ...grpc.CallOption) (*NodeGroup, error)
	// Gets the access control policy for a resource. May be empty if no such policy or resource exists.
	GetIamPolicy(ctx context.Context, in *GetIamPolicyNodeGroupRequest, opts ...grpc.CallOption) (*Policy, error)
	// Creates a NodeGroup resource in the specified project using the data included in the request.
	Insert(ctx context.Context, in *InsertNodeGroupRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves a list of node groups available to the specified project. Note: use nodeGroups.listNodes for more details about each group.
	List(ctx context.Context, in *ListNodeGroupsRequest, opts ...grpc.CallOption) (*NodeGroupList, error)
	// Lists nodes in the node group.
	ListNodes(ctx context.Context, in *ListNodesNodeGroupsRequest, opts ...grpc.CallOption) (*NodeGroupsListNodes, error)
	// Updates the specified node group.
	Patch(ctx context.Context, in *PatchNodeGroupRequest, opts ...grpc.CallOption) (*Operation, error)
	// Perform maintenance on a subset of nodes in the node group.
	PerformMaintenance(ctx context.Context, in *PerformMaintenanceNodeGroupRequest, opts ...grpc.CallOption) (*Operation, error)
	// Sets the access control policy on the specified resource. Replaces any existing policy.
	SetIamPolicy(ctx context.Context, in *SetIamPolicyNodeGroupRequest, opts ...grpc.CallOption) (*Policy, error)
	// Updates the node template of the node group.
	SetNodeTemplate(ctx context.Context, in *SetNodeTemplateNodeGroupRequest, opts ...grpc.CallOption) (*Operation, error)
	// Simulates maintenance event on specified nodes from the node group.
	SimulateMaintenanceEvent(ctx context.Context, in *SimulateMaintenanceEventNodeGroupRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(ctx context.Context, in *TestIamPermissionsNodeGroupRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error)
}

type nodeGroupsClient struct {
	cc grpc.ClientConnInterface
}

func NewNodeGroupsClient(cc grpc.ClientConnInterface) NodeGroupsClient {
	return &nodeGroupsClient{cc}
}

func (c *nodeGroupsClient) AddNodes(ctx context.Context, in *AddNodesNodeGroupRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, NodeGroups_AddNodes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeGroupsClient) AggregatedList(ctx context.Context, in *AggregatedListNodeGroupsRequest, opts ...grpc.CallOption) (*NodeGroupAggregatedList, error) {
	out := new(NodeGroupAggregatedList)
	err := c.cc.Invoke(ctx, NodeGroups_AggregatedList_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeGroupsClient) Delete(ctx context.Context, in *DeleteNodeGroupRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, NodeGroups_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeGroupsClient) DeleteNodes(ctx context.Context, in *DeleteNodesNodeGroupRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, NodeGroups_DeleteNodes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeGroupsClient) Get(ctx context.Context, in *GetNodeGroupRequest, opts ...grpc.CallOption) (*NodeGroup, error) {
	out := new(NodeGroup)
	err := c.cc.Invoke(ctx, NodeGroups_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeGroupsClient) GetIamPolicy(ctx context.Context, in *GetIamPolicyNodeGroupRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, NodeGroups_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeGroupsClient) Insert(ctx context.Context, in *InsertNodeGroupRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, NodeGroups_Insert_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeGroupsClient) List(ctx context.Context, in *ListNodeGroupsRequest, opts ...grpc.CallOption) (*NodeGroupList, error) {
	out := new(NodeGroupList)
	err := c.cc.Invoke(ctx, NodeGroups_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeGroupsClient) ListNodes(ctx context.Context, in *ListNodesNodeGroupsRequest, opts ...grpc.CallOption) (*NodeGroupsListNodes, error) {
	out := new(NodeGroupsListNodes)
	err := c.cc.Invoke(ctx, NodeGroups_ListNodes_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeGroupsClient) Patch(ctx context.Context, in *PatchNodeGroupRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, NodeGroups_Patch_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeGroupsClient) PerformMaintenance(ctx context.Context, in *PerformMaintenanceNodeGroupRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, NodeGroups_PerformMaintenance_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeGroupsClient) SetIamPolicy(ctx context.Context, in *SetIamPolicyNodeGroupRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, NodeGroups_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeGroupsClient) SetNodeTemplate(ctx context.Context, in *SetNodeTemplateNodeGroupRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, NodeGroups_SetNodeTemplate_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeGroupsClient) SimulateMaintenanceEvent(ctx context.Context, in *SimulateMaintenanceEventNodeGroupRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, NodeGroups_SimulateMaintenanceEvent_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeGroupsClient) TestIamPermissions(ctx context.Context, in *TestIamPermissionsNodeGroupRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error) {
	out := new(TestPermissionsResponse)
	err := c.cc.Invoke(ctx, NodeGroups_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// NodeGroupsServer is the server API for NodeGroups service.
// All implementations should embed UnimplementedNodeGroupsServer
// for forward compatibility
type NodeGroupsServer interface {
	// Adds specified number of nodes to the node group.
	AddNodes(context.Context, *AddNodesNodeGroupRequest) (*Operation, error)
	// Retrieves an aggregated list of node groups. Note: use nodeGroups.listNodes for more details about each group. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(context.Context, *AggregatedListNodeGroupsRequest) (*NodeGroupAggregatedList, error)
	// Deletes the specified NodeGroup resource.
	Delete(context.Context, *DeleteNodeGroupRequest) (*Operation, error)
	// Deletes specified nodes from the node group.
	DeleteNodes(context.Context, *DeleteNodesNodeGroupRequest) (*Operation, error)
	// Returns the specified NodeGroup. Get a list of available NodeGroups by making a list() request. Note: the "nodes" field should not be used. Use nodeGroups.listNodes instead.
	Get(context.Context, *GetNodeGroupRequest) (*NodeGroup, error)
	// Gets the access control policy for a resource. May be empty if no such policy or resource exists.
	GetIamPolicy(context.Context, *GetIamPolicyNodeGroupRequest) (*Policy, error)
	// Creates a NodeGroup resource in the specified project using the data included in the request.
	Insert(context.Context, *InsertNodeGroupRequest) (*Operation, error)
	// Retrieves a list of node groups available to the specified project. Note: use nodeGroups.listNodes for more details about each group.
	List(context.Context, *ListNodeGroupsRequest) (*NodeGroupList, error)
	// Lists nodes in the node group.
	ListNodes(context.Context, *ListNodesNodeGroupsRequest) (*NodeGroupsListNodes, error)
	// Updates the specified node group.
	Patch(context.Context, *PatchNodeGroupRequest) (*Operation, error)
	// Perform maintenance on a subset of nodes in the node group.
	PerformMaintenance(context.Context, *PerformMaintenanceNodeGroupRequest) (*Operation, error)
	// Sets the access control policy on the specified resource. Replaces any existing policy.
	SetIamPolicy(context.Context, *SetIamPolicyNodeGroupRequest) (*Policy, error)
	// Updates the node template of the node group.
	SetNodeTemplate(context.Context, *SetNodeTemplateNodeGroupRequest) (*Operation, error)
	// Simulates maintenance event on specified nodes from the node group.
	SimulateMaintenanceEvent(context.Context, *SimulateMaintenanceEventNodeGroupRequest) (*Operation, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(context.Context, *TestIamPermissionsNodeGroupRequest) (*TestPermissionsResponse, error)
}

// UnimplementedNodeGroupsServer should be embedded to have forward compatible implementations.
type UnimplementedNodeGroupsServer struct {
}

func (UnimplementedNodeGroupsServer) AddNodes(context.Context, *AddNodesNodeGroupRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddNodes not implemented")
}
func (UnimplementedNodeGroupsServer) AggregatedList(context.Context, *AggregatedListNodeGroupsRequest) (*NodeGroupAggregatedList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AggregatedList not implemented")
}
func (UnimplementedNodeGroupsServer) Delete(context.Context, *DeleteNodeGroupRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedNodeGroupsServer) DeleteNodes(context.Context, *DeleteNodesNodeGroupRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteNodes not implemented")
}
func (UnimplementedNodeGroupsServer) Get(context.Context, *GetNodeGroupRequest) (*NodeGroup, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedNodeGroupsServer) GetIamPolicy(context.Context, *GetIamPolicyNodeGroupRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedNodeGroupsServer) Insert(context.Context, *InsertNodeGroupRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (UnimplementedNodeGroupsServer) List(context.Context, *ListNodeGroupsRequest) (*NodeGroupList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedNodeGroupsServer) ListNodes(context.Context, *ListNodesNodeGroupsRequest) (*NodeGroupsListNodes, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListNodes not implemented")
}
func (UnimplementedNodeGroupsServer) Patch(context.Context, *PatchNodeGroupRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Patch not implemented")
}
func (UnimplementedNodeGroupsServer) PerformMaintenance(context.Context, *PerformMaintenanceNodeGroupRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PerformMaintenance not implemented")
}
func (UnimplementedNodeGroupsServer) SetIamPolicy(context.Context, *SetIamPolicyNodeGroupRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedNodeGroupsServer) SetNodeTemplate(context.Context, *SetNodeTemplateNodeGroupRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetNodeTemplate not implemented")
}
func (UnimplementedNodeGroupsServer) SimulateMaintenanceEvent(context.Context, *SimulateMaintenanceEventNodeGroupRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SimulateMaintenanceEvent not implemented")
}
func (UnimplementedNodeGroupsServer) TestIamPermissions(context.Context, *TestIamPermissionsNodeGroupRequest) (*TestPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

// UnsafeNodeGroupsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to NodeGroupsServer will
// result in compilation errors.
type UnsafeNodeGroupsServer interface {
	mustEmbedUnimplementedNodeGroupsServer()
}

func RegisterNodeGroupsServer(s grpc.ServiceRegistrar, srv NodeGroupsServer) {
	s.RegisterService(&NodeGroups_ServiceDesc, srv)
}

func _NodeGroups_AddNodes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddNodesNodeGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeGroupsServer).AddNodes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NodeGroups_AddNodes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeGroupsServer).AddNodes(ctx, req.(*AddNodesNodeGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NodeGroups_AggregatedList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AggregatedListNodeGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeGroupsServer).AggregatedList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NodeGroups_AggregatedList_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeGroupsServer).AggregatedList(ctx, req.(*AggregatedListNodeGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NodeGroups_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNodeGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeGroupsServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NodeGroups_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeGroupsServer).Delete(ctx, req.(*DeleteNodeGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NodeGroups_DeleteNodes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNodesNodeGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeGroupsServer).DeleteNodes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NodeGroups_DeleteNodes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeGroupsServer).DeleteNodes(ctx, req.(*DeleteNodesNodeGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NodeGroups_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNodeGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeGroupsServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NodeGroups_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeGroupsServer).Get(ctx, req.(*GetNodeGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NodeGroups_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIamPolicyNodeGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeGroupsServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NodeGroups_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeGroupsServer).GetIamPolicy(ctx, req.(*GetIamPolicyNodeGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NodeGroups_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertNodeGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeGroupsServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NodeGroups_Insert_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeGroupsServer).Insert(ctx, req.(*InsertNodeGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NodeGroups_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNodeGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeGroupsServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NodeGroups_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeGroupsServer).List(ctx, req.(*ListNodeGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NodeGroups_ListNodes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNodesNodeGroupsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeGroupsServer).ListNodes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NodeGroups_ListNodes_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeGroupsServer).ListNodes(ctx, req.(*ListNodesNodeGroupsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NodeGroups_Patch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchNodeGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeGroupsServer).Patch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NodeGroups_Patch_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeGroupsServer).Patch(ctx, req.(*PatchNodeGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NodeGroups_PerformMaintenance_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PerformMaintenanceNodeGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeGroupsServer).PerformMaintenance(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NodeGroups_PerformMaintenance_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeGroupsServer).PerformMaintenance(ctx, req.(*PerformMaintenanceNodeGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NodeGroups_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetIamPolicyNodeGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeGroupsServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NodeGroups_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeGroupsServer).SetIamPolicy(ctx, req.(*SetIamPolicyNodeGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NodeGroups_SetNodeTemplate_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetNodeTemplateNodeGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeGroupsServer).SetNodeTemplate(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NodeGroups_SetNodeTemplate_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeGroupsServer).SetNodeTemplate(ctx, req.(*SetNodeTemplateNodeGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NodeGroups_SimulateMaintenanceEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SimulateMaintenanceEventNodeGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeGroupsServer).SimulateMaintenanceEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NodeGroups_SimulateMaintenanceEvent_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeGroupsServer).SimulateMaintenanceEvent(ctx, req.(*SimulateMaintenanceEventNodeGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NodeGroups_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TestIamPermissionsNodeGroupRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeGroupsServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NodeGroups_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeGroupsServer).TestIamPermissions(ctx, req.(*TestIamPermissionsNodeGroupRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// NodeGroups_ServiceDesc is the grpc.ServiceDesc for NodeGroups service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var NodeGroups_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.NodeGroups",
	HandlerType: (*NodeGroupsServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AddNodes",
			Handler:    _NodeGroups_AddNodes_Handler,
		},
		{
			MethodName: "AggregatedList",
			Handler:    _NodeGroups_AggregatedList_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _NodeGroups_Delete_Handler,
		},
		{
			MethodName: "DeleteNodes",
			Handler:    _NodeGroups_DeleteNodes_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _NodeGroups_Get_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _NodeGroups_GetIamPolicy_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _NodeGroups_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _NodeGroups_List_Handler,
		},
		{
			MethodName: "ListNodes",
			Handler:    _NodeGroups_ListNodes_Handler,
		},
		{
			MethodName: "Patch",
			Handler:    _NodeGroups_Patch_Handler,
		},
		{
			MethodName: "PerformMaintenance",
			Handler:    _NodeGroups_PerformMaintenance_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _NodeGroups_SetIamPolicy_Handler,
		},
		{
			MethodName: "SetNodeTemplate",
			Handler:    _NodeGroups_SetNodeTemplate_Handler,
		},
		{
			MethodName: "SimulateMaintenanceEvent",
			Handler:    _NodeGroups_SimulateMaintenanceEvent_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _NodeGroups_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	NodeTemplates_AggregatedList_FullMethodName     = "/google.cloud.compute.v1beta.NodeTemplates/AggregatedList"
	NodeTemplates_Delete_FullMethodName             = "/google.cloud.compute.v1beta.NodeTemplates/Delete"
	NodeTemplates_Get_FullMethodName                = "/google.cloud.compute.v1beta.NodeTemplates/Get"
	NodeTemplates_GetIamPolicy_FullMethodName       = "/google.cloud.compute.v1beta.NodeTemplates/GetIamPolicy"
	NodeTemplates_Insert_FullMethodName             = "/google.cloud.compute.v1beta.NodeTemplates/Insert"
	NodeTemplates_List_FullMethodName               = "/google.cloud.compute.v1beta.NodeTemplates/List"
	NodeTemplates_SetIamPolicy_FullMethodName       = "/google.cloud.compute.v1beta.NodeTemplates/SetIamPolicy"
	NodeTemplates_TestIamPermissions_FullMethodName = "/google.cloud.compute.v1beta.NodeTemplates/TestIamPermissions"
)

// NodeTemplatesClient is the client API for NodeTemplates service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type NodeTemplatesClient interface {
	// Retrieves an aggregated list of node templates. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(ctx context.Context, in *AggregatedListNodeTemplatesRequest, opts ...grpc.CallOption) (*NodeTemplateAggregatedList, error)
	// Deletes the specified NodeTemplate resource.
	Delete(ctx context.Context, in *DeleteNodeTemplateRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns the specified node template.
	Get(ctx context.Context, in *GetNodeTemplateRequest, opts ...grpc.CallOption) (*NodeTemplate, error)
	// Gets the access control policy for a resource. May be empty if no such policy or resource exists.
	GetIamPolicy(ctx context.Context, in *GetIamPolicyNodeTemplateRequest, opts ...grpc.CallOption) (*Policy, error)
	// Creates a NodeTemplate resource in the specified project using the data included in the request.
	Insert(ctx context.Context, in *InsertNodeTemplateRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves a list of node templates available to the specified project.
	List(ctx context.Context, in *ListNodeTemplatesRequest, opts ...grpc.CallOption) (*NodeTemplateList, error)
	// Sets the access control policy on the specified resource. Replaces any existing policy.
	SetIamPolicy(ctx context.Context, in *SetIamPolicyNodeTemplateRequest, opts ...grpc.CallOption) (*Policy, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(ctx context.Context, in *TestIamPermissionsNodeTemplateRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error)
}

type nodeTemplatesClient struct {
	cc grpc.ClientConnInterface
}

func NewNodeTemplatesClient(cc grpc.ClientConnInterface) NodeTemplatesClient {
	return &nodeTemplatesClient{cc}
}

func (c *nodeTemplatesClient) AggregatedList(ctx context.Context, in *AggregatedListNodeTemplatesRequest, opts ...grpc.CallOption) (*NodeTemplateAggregatedList, error) {
	out := new(NodeTemplateAggregatedList)
	err := c.cc.Invoke(ctx, NodeTemplates_AggregatedList_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeTemplatesClient) Delete(ctx context.Context, in *DeleteNodeTemplateRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, NodeTemplates_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeTemplatesClient) Get(ctx context.Context, in *GetNodeTemplateRequest, opts ...grpc.CallOption) (*NodeTemplate, error) {
	out := new(NodeTemplate)
	err := c.cc.Invoke(ctx, NodeTemplates_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeTemplatesClient) GetIamPolicy(ctx context.Context, in *GetIamPolicyNodeTemplateRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, NodeTemplates_GetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeTemplatesClient) Insert(ctx context.Context, in *InsertNodeTemplateRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, NodeTemplates_Insert_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeTemplatesClient) List(ctx context.Context, in *ListNodeTemplatesRequest, opts ...grpc.CallOption) (*NodeTemplateList, error) {
	out := new(NodeTemplateList)
	err := c.cc.Invoke(ctx, NodeTemplates_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeTemplatesClient) SetIamPolicy(ctx context.Context, in *SetIamPolicyNodeTemplateRequest, opts ...grpc.CallOption) (*Policy, error) {
	out := new(Policy)
	err := c.cc.Invoke(ctx, NodeTemplates_SetIamPolicy_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeTemplatesClient) TestIamPermissions(ctx context.Context, in *TestIamPermissionsNodeTemplateRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error) {
	out := new(TestPermissionsResponse)
	err := c.cc.Invoke(ctx, NodeTemplates_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// NodeTemplatesServer is the server API for NodeTemplates service.
// All implementations should embed UnimplementedNodeTemplatesServer
// for forward compatibility
type NodeTemplatesServer interface {
	// Retrieves an aggregated list of node templates. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(context.Context, *AggregatedListNodeTemplatesRequest) (*NodeTemplateAggregatedList, error)
	// Deletes the specified NodeTemplate resource.
	Delete(context.Context, *DeleteNodeTemplateRequest) (*Operation, error)
	// Returns the specified node template.
	Get(context.Context, *GetNodeTemplateRequest) (*NodeTemplate, error)
	// Gets the access control policy for a resource. May be empty if no such policy or resource exists.
	GetIamPolicy(context.Context, *GetIamPolicyNodeTemplateRequest) (*Policy, error)
	// Creates a NodeTemplate resource in the specified project using the data included in the request.
	Insert(context.Context, *InsertNodeTemplateRequest) (*Operation, error)
	// Retrieves a list of node templates available to the specified project.
	List(context.Context, *ListNodeTemplatesRequest) (*NodeTemplateList, error)
	// Sets the access control policy on the specified resource. Replaces any existing policy.
	SetIamPolicy(context.Context, *SetIamPolicyNodeTemplateRequest) (*Policy, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(context.Context, *TestIamPermissionsNodeTemplateRequest) (*TestPermissionsResponse, error)
}

// UnimplementedNodeTemplatesServer should be embedded to have forward compatible implementations.
type UnimplementedNodeTemplatesServer struct {
}

func (UnimplementedNodeTemplatesServer) AggregatedList(context.Context, *AggregatedListNodeTemplatesRequest) (*NodeTemplateAggregatedList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AggregatedList not implemented")
}
func (UnimplementedNodeTemplatesServer) Delete(context.Context, *DeleteNodeTemplateRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedNodeTemplatesServer) Get(context.Context, *GetNodeTemplateRequest) (*NodeTemplate, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedNodeTemplatesServer) GetIamPolicy(context.Context, *GetIamPolicyNodeTemplateRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetIamPolicy not implemented")
}
func (UnimplementedNodeTemplatesServer) Insert(context.Context, *InsertNodeTemplateRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (UnimplementedNodeTemplatesServer) List(context.Context, *ListNodeTemplatesRequest) (*NodeTemplateList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedNodeTemplatesServer) SetIamPolicy(context.Context, *SetIamPolicyNodeTemplateRequest) (*Policy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SetIamPolicy not implemented")
}
func (UnimplementedNodeTemplatesServer) TestIamPermissions(context.Context, *TestIamPermissionsNodeTemplateRequest) (*TestPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

// UnsafeNodeTemplatesServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to NodeTemplatesServer will
// result in compilation errors.
type UnsafeNodeTemplatesServer interface {
	mustEmbedUnimplementedNodeTemplatesServer()
}

func RegisterNodeTemplatesServer(s grpc.ServiceRegistrar, srv NodeTemplatesServer) {
	s.RegisterService(&NodeTemplates_ServiceDesc, srv)
}

func _NodeTemplates_AggregatedList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AggregatedListNodeTemplatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeTemplatesServer).AggregatedList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NodeTemplates_AggregatedList_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeTemplatesServer).AggregatedList(ctx, req.(*AggregatedListNodeTemplatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NodeTemplates_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteNodeTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeTemplatesServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NodeTemplates_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeTemplatesServer).Delete(ctx, req.(*DeleteNodeTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NodeTemplates_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNodeTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeTemplatesServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NodeTemplates_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeTemplatesServer).Get(ctx, req.(*GetNodeTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NodeTemplates_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIamPolicyNodeTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeTemplatesServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NodeTemplates_GetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeTemplatesServer).GetIamPolicy(ctx, req.(*GetIamPolicyNodeTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NodeTemplates_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertNodeTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeTemplatesServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NodeTemplates_Insert_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeTemplatesServer).Insert(ctx, req.(*InsertNodeTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NodeTemplates_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNodeTemplatesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeTemplatesServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NodeTemplates_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeTemplatesServer).List(ctx, req.(*ListNodeTemplatesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NodeTemplates_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetIamPolicyNodeTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeTemplatesServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NodeTemplates_SetIamPolicy_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeTemplatesServer).SetIamPolicy(ctx, req.(*SetIamPolicyNodeTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NodeTemplates_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(TestIamPermissionsNodeTemplateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeTemplatesServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NodeTemplates_TestIamPermissions_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeTemplatesServer).TestIamPermissions(ctx, req.(*TestIamPermissionsNodeTemplateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// NodeTemplates_ServiceDesc is the grpc.ServiceDesc for NodeTemplates service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var NodeTemplates_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.NodeTemplates",
	HandlerType: (*NodeTemplatesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AggregatedList",
			Handler:    _NodeTemplates_AggregatedList_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _NodeTemplates_Delete_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _NodeTemplates_Get_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _NodeTemplates_GetIamPolicy_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _NodeTemplates_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _NodeTemplates_List_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _NodeTemplates_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _NodeTemplates_TestIamPermissions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	NodeTypes_AggregatedList_FullMethodName = "/google.cloud.compute.v1beta.NodeTypes/AggregatedList"
	NodeTypes_Get_FullMethodName            = "/google.cloud.compute.v1beta.NodeTypes/Get"
	NodeTypes_List_FullMethodName           = "/google.cloud.compute.v1beta.NodeTypes/List"
)

// NodeTypesClient is the client API for NodeTypes service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type NodeTypesClient interface {
	// Retrieves an aggregated list of node types. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(ctx context.Context, in *AggregatedListNodeTypesRequest, opts ...grpc.CallOption) (*NodeTypeAggregatedList, error)
	// Returns the specified node type.
	Get(ctx context.Context, in *GetNodeTypeRequest, opts ...grpc.CallOption) (*NodeType, error)
	// Retrieves a list of node types available to the specified project.
	List(ctx context.Context, in *ListNodeTypesRequest, opts ...grpc.CallOption) (*NodeTypeList, error)
}

type nodeTypesClient struct {
	cc grpc.ClientConnInterface
}

func NewNodeTypesClient(cc grpc.ClientConnInterface) NodeTypesClient {
	return &nodeTypesClient{cc}
}

func (c *nodeTypesClient) AggregatedList(ctx context.Context, in *AggregatedListNodeTypesRequest, opts ...grpc.CallOption) (*NodeTypeAggregatedList, error) {
	out := new(NodeTypeAggregatedList)
	err := c.cc.Invoke(ctx, NodeTypes_AggregatedList_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeTypesClient) Get(ctx context.Context, in *GetNodeTypeRequest, opts ...grpc.CallOption) (*NodeType, error) {
	out := new(NodeType)
	err := c.cc.Invoke(ctx, NodeTypes_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *nodeTypesClient) List(ctx context.Context, in *ListNodeTypesRequest, opts ...grpc.CallOption) (*NodeTypeList, error) {
	out := new(NodeTypeList)
	err := c.cc.Invoke(ctx, NodeTypes_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// NodeTypesServer is the server API for NodeTypes service.
// All implementations should embed UnimplementedNodeTypesServer
// for forward compatibility
type NodeTypesServer interface {
	// Retrieves an aggregated list of node types. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(context.Context, *AggregatedListNodeTypesRequest) (*NodeTypeAggregatedList, error)
	// Returns the specified node type.
	Get(context.Context, *GetNodeTypeRequest) (*NodeType, error)
	// Retrieves a list of node types available to the specified project.
	List(context.Context, *ListNodeTypesRequest) (*NodeTypeList, error)
}

// UnimplementedNodeTypesServer should be embedded to have forward compatible implementations.
type UnimplementedNodeTypesServer struct {
}

func (UnimplementedNodeTypesServer) AggregatedList(context.Context, *AggregatedListNodeTypesRequest) (*NodeTypeAggregatedList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AggregatedList not implemented")
}
func (UnimplementedNodeTypesServer) Get(context.Context, *GetNodeTypeRequest) (*NodeType, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedNodeTypesServer) List(context.Context, *ListNodeTypesRequest) (*NodeTypeList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}

// UnsafeNodeTypesServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to NodeTypesServer will
// result in compilation errors.
type UnsafeNodeTypesServer interface {
	mustEmbedUnimplementedNodeTypesServer()
}

func RegisterNodeTypesServer(s grpc.ServiceRegistrar, srv NodeTypesServer) {
	s.RegisterService(&NodeTypes_ServiceDesc, srv)
}

func _NodeTypes_AggregatedList_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AggregatedListNodeTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeTypesServer).AggregatedList(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NodeTypes_AggregatedList_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeTypesServer).AggregatedList(ctx, req.(*AggregatedListNodeTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NodeTypes_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetNodeTypeRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeTypesServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NodeTypes_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeTypesServer).Get(ctx, req.(*GetNodeTypeRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _NodeTypes_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListNodeTypesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(NodeTypesServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: NodeTypes_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(NodeTypesServer).List(ctx, req.(*ListNodeTypesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// NodeTypes_ServiceDesc is the grpc.ServiceDesc for NodeTypes service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var NodeTypes_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.NodeTypes",
	HandlerType: (*NodeTypesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AggregatedList",
			Handler:    _NodeTypes_AggregatedList_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _NodeTypes_Get_Handler,
		},
		{
			MethodName: "List",
			Handler:    _NodeTypes_List_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	OrganizationSecurityPolicies_AddAssociation_FullMethodName                  = "/google.cloud.compute.v1beta.OrganizationSecurityPolicies/AddAssociation"
	OrganizationSecurityPolicies_AddRule_FullMethodName                         = "/google.cloud.compute.v1beta.OrganizationSecurityPolicies/AddRule"
	OrganizationSecurityPolicies_CopyRules_FullMethodName                       = "/google.cloud.compute.v1beta.OrganizationSecurityPolicies/CopyRules"
	OrganizationSecurityPolicies_Delete_FullMethodName                          = "/google.cloud.compute.v1beta.OrganizationSecurityPolicies/Delete"
	OrganizationSecurityPolicies_Get_FullMethodName                             = "/google.cloud.compute.v1beta.OrganizationSecurityPolicies/Get"
	OrganizationSecurityPolicies_GetAssociation_FullMethodName                  = "/google.cloud.compute.v1beta.OrganizationSecurityPolicies/GetAssociation"
	OrganizationSecurityPolicies_GetRule_FullMethodName                         = "/google.cloud.compute.v1beta.OrganizationSecurityPolicies/GetRule"
	OrganizationSecurityPolicies_Insert_FullMethodName                          = "/google.cloud.compute.v1beta.OrganizationSecurityPolicies/Insert"
	OrganizationSecurityPolicies_List_FullMethodName                            = "/google.cloud.compute.v1beta.OrganizationSecurityPolicies/List"
	OrganizationSecurityPolicies_ListAssociations_FullMethodName                = "/google.cloud.compute.v1beta.OrganizationSecurityPolicies/ListAssociations"
	OrganizationSecurityPolicies_ListPreconfiguredExpressionSets_FullMethodName = "/google.cloud.compute.v1beta.OrganizationSecurityPolicies/ListPreconfiguredExpressionSets"
	OrganizationSecurityPolicies_Move_FullMethodName                            = "/google.cloud.compute.v1beta.OrganizationSecurityPolicies/Move"
	OrganizationSecurityPolicies_Patch_FullMethodName                           = "/google.cloud.compute.v1beta.OrganizationSecurityPolicies/Patch"
	OrganizationSecurityPolicies_PatchRule_FullMethodName                       = "/google.cloud.compute.v1beta.OrganizationSecurityPolicies/PatchRule"
	OrganizationSecurityPolicies_RemoveAssociation_FullMethodName               = "/google.cloud.compute.v1beta.OrganizationSecurityPolicies/RemoveAssociation"
	OrganizationSecurityPolicies_RemoveRule_FullMethodName                      = "/google.cloud.compute.v1beta.OrganizationSecurityPolicies/RemoveRule"
)

// OrganizationSecurityPoliciesClient is the client API for OrganizationSecurityPolicies service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type OrganizationSecurityPoliciesClient interface {
	// Inserts an association for the specified security policy. This has billing implications. Projects in the hierarchy with effective hierarchical security policies will be automatically enrolled into Cloud Armor Enterprise if not already enrolled. Use of this API to modify firewall policies is deprecated. Use firewallPolicies.addAssociation instead if possible.
	AddAssociation(ctx context.Context, in *AddAssociationOrganizationSecurityPolicyRequest, opts ...grpc.CallOption) (*Operation, error)
	// Inserts a rule into a security policy.
	AddRule(ctx context.Context, in *AddRuleOrganizationSecurityPolicyRequest, opts ...grpc.CallOption) (*Operation, error)
	// Copies rules to the specified security policy. Use of this API to modify firewall policies is deprecated. Use firewallPolicies.copyRules instead.
	CopyRules(ctx context.Context, in *CopyRulesOrganizationSecurityPolicyRequest, opts ...grpc.CallOption) (*Operation, error)
	// Deletes the specified policy. Use of this API to remove firewall policies is deprecated. Use firewallPolicies.delete instead.
	Delete(ctx context.Context, in *DeleteOrganizationSecurityPolicyRequest, opts ...grpc.CallOption) (*Operation, error)
	// List all of the ordered rules present in a single specified policy. Use of this API to read firewall policies is deprecated. Use firewallPolicies.get instead.
	Get(ctx context.Context, in *GetOrganizationSecurityPolicyRequest, opts ...grpc.CallOption) (*SecurityPolicy, error)
	// Gets an association with the specified name. Use of this API to read firewall policies is deprecated. Use firewallPolicies.getAssociation instead if possible.
	GetAssociation(ctx context.Context, in *GetAssociationOrganizationSecurityPolicyRequest, opts ...grpc.CallOption) (*SecurityPolicyAssociation, error)
	// Gets a rule at the specified priority. Use of this API to read firewall policies is deprecated. Use firewallPolicies.getRule instead.
	GetRule(ctx context.Context, in *GetRuleOrganizationSecurityPolicyRequest, opts ...grpc.CallOption) (*SecurityPolicyRule, error)
	// Creates a new policy in the specified project using the data included in the request. Use of this API to insert firewall policies is deprecated. Use firewallPolicies.insert instead.
	Insert(ctx context.Context, in *InsertOrganizationSecurityPolicyRequest, opts ...grpc.CallOption) (*Operation, error)
	// List all the policies that have been configured for the specified project. Use of this API to read firewall policies is deprecated. Use firewallPolicies.list instead.
	List(ctx context.Context, in *ListOrganizationSecurityPoliciesRequest, opts ...grpc.CallOption) (*SecurityPolicyList, error)
	// Lists associations of a specified target, i.e., organization or folder. Use of this API to read firewall policies is deprecated. Use firewallPolicies.listAssociations instead if possible.
	ListAssociations(ctx context.Context, in *ListAssociationsOrganizationSecurityPolicyRequest, opts ...grpc.CallOption) (*OrganizationSecurityPoliciesListAssociationsResponse, error)
	// Gets the current list of preconfigured Web Application Firewall (WAF) expressions.
	ListPreconfiguredExpressionSets(ctx context.Context, in *ListPreconfiguredExpressionSetsOrganizationSecurityPoliciesRequest, opts ...grpc.CallOption) (*SecurityPoliciesListPreconfiguredExpressionSetsResponse, error)
	// Moves the specified security policy. Use of this API to modify firewall policies is deprecated. Use firewallPolicies.move instead.
	Move(ctx context.Context, in *MoveOrganizationSecurityPolicyRequest, opts ...grpc.CallOption) (*Operation, error)
	// Patches the specified policy with the data included in the request. Use of this API to modify firewall policies is deprecated. Use firewallPolicies.patch instead.
	Patch(ctx context.Context, in *PatchOrganizationSecurityPolicyRequest, opts ...grpc.CallOption) (*Operation, error)
	// Patches a rule at the specified priority. Use of this API to modify firewall policies is deprecated. Use firewallPolicies.patchRule instead.
	PatchRule(ctx context.Context, in *PatchRuleOrganizationSecurityPolicyRequest, opts ...grpc.CallOption) (*Operation, error)
	// Removes an association for the specified security policy. Use of this API to modify firewall policies is deprecated. Use firewallPolicies.removeAssociation instead if possible.
	RemoveAssociation(ctx context.Context, in *RemoveAssociationOrganizationSecurityPolicyRequest, opts ...grpc.CallOption) (*Operation, error)
	// Deletes a rule at the specified priority.
	RemoveRule(ctx context.Context, in *RemoveRuleOrganizationSecurityPolicyRequest, opts ...grpc.CallOption) (*Operation, error)
}

type organizationSecurityPoliciesClient struct {
	cc grpc.ClientConnInterface
}

func NewOrganizationSecurityPoliciesClient(cc grpc.ClientConnInterface) OrganizationSecurityPoliciesClient {
	return &organizationSecurityPoliciesClient{cc}
}

func (c *organizationSecurityPoliciesClient) AddAssociation(ctx context.Context, in *AddAssociationOrganizationSecurityPolicyRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, OrganizationSecurityPolicies_AddAssociation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *organizationSecurityPoliciesClient) AddRule(ctx context.Context, in *AddRuleOrganizationSecurityPolicyRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, OrganizationSecurityPolicies_AddRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *organizationSecurityPoliciesClient) CopyRules(ctx context.Context, in *CopyRulesOrganizationSecurityPolicyRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, OrganizationSecurityPolicies_CopyRules_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *organizationSecurityPoliciesClient) Delete(ctx context.Context, in *DeleteOrganizationSecurityPolicyRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, OrganizationSecurityPolicies_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *organizationSecurityPoliciesClient) Get(ctx context.Context, in *GetOrganizationSecurityPolicyRequest, opts ...grpc.CallOption) (*SecurityPolicy, error) {
	out := new(SecurityPolicy)
	err := c.cc.Invoke(ctx, OrganizationSecurityPolicies_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *organizationSecurityPoliciesClient) GetAssociation(ctx context.Context, in *GetAssociationOrganizationSecurityPolicyRequest, opts ...grpc.CallOption) (*SecurityPolicyAssociation, error) {
	out := new(SecurityPolicyAssociation)
	err := c.cc.Invoke(ctx, OrganizationSecurityPolicies_GetAssociation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *organizationSecurityPoliciesClient) GetRule(ctx context.Context, in *GetRuleOrganizationSecurityPolicyRequest, opts ...grpc.CallOption) (*SecurityPolicyRule, error) {
	out := new(SecurityPolicyRule)
	err := c.cc.Invoke(ctx, OrganizationSecurityPolicies_GetRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *organizationSecurityPoliciesClient) Insert(ctx context.Context, in *InsertOrganizationSecurityPolicyRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, OrganizationSecurityPolicies_Insert_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *organizationSecurityPoliciesClient) List(ctx context.Context, in *ListOrganizationSecurityPoliciesRequest, opts ...grpc.CallOption) (*SecurityPolicyList, error) {
	out := new(SecurityPolicyList)
	err := c.cc.Invoke(ctx, OrganizationSecurityPolicies_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *organizationSecurityPoliciesClient) ListAssociations(ctx context.Context, in *ListAssociationsOrganizationSecurityPolicyRequest, opts ...grpc.CallOption) (*OrganizationSecurityPoliciesListAssociationsResponse, error) {
	out := new(OrganizationSecurityPoliciesListAssociationsResponse)
	err := c.cc.Invoke(ctx, OrganizationSecurityPolicies_ListAssociations_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *organizationSecurityPoliciesClient) ListPreconfiguredExpressionSets(ctx context.Context, in *ListPreconfiguredExpressionSetsOrganizationSecurityPoliciesRequest, opts ...grpc.CallOption) (*SecurityPoliciesListPreconfiguredExpressionSetsResponse, error) {
	out := new(SecurityPoliciesListPreconfiguredExpressionSetsResponse)
	err := c.cc.Invoke(ctx, OrganizationSecurityPolicies_ListPreconfiguredExpressionSets_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *organizationSecurityPoliciesClient) Move(ctx context.Context, in *MoveOrganizationSecurityPolicyRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, OrganizationSecurityPolicies_Move_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *organizationSecurityPoliciesClient) Patch(ctx context.Context, in *PatchOrganizationSecurityPolicyRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, OrganizationSecurityPolicies_Patch_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *organizationSecurityPoliciesClient) PatchRule(ctx context.Context, in *PatchRuleOrganizationSecurityPolicyRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, OrganizationSecurityPolicies_PatchRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *organizationSecurityPoliciesClient) RemoveAssociation(ctx context.Context, in *RemoveAssociationOrganizationSecurityPolicyRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, OrganizationSecurityPolicies_RemoveAssociation_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *organizationSecurityPoliciesClient) RemoveRule(ctx context.Context, in *RemoveRuleOrganizationSecurityPolicyRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, OrganizationSecurityPolicies_RemoveRule_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// OrganizationSecurityPoliciesServer is the server API for OrganizationSecurityPolicies service.
// All implementations should embed UnimplementedOrganizationSecurityPoliciesServer
// for forward compatibility
type OrganizationSecurityPoliciesServer interface {
	// Inserts an association for the specified security policy. This has billing implications. Projects in the hierarchy with effective hierarchical security policies will be automatically enrolled into Cloud Armor Enterprise if not already enrolled. Use of this API to modify firewall policies is deprecated. Use firewallPolicies.addAssociation instead if possible.
	AddAssociation(context.Context, *AddAssociationOrganizationSecurityPolicyRequest) (*Operation, error)
	// Inserts a rule into a security policy.
	AddRule(context.Context, *AddRuleOrganizationSecurityPolicyRequest) (*Operation, error)
	// Copies rules to the specified security policy. Use of this API to modify firewall policies is deprecated. Use firewallPolicies.copyRules instead.
	CopyRules(context.Context, *CopyRulesOrganizationSecurityPolicyRequest) (*Operation, error)
	// Deletes the specified policy. Use of this API to remove firewall policies is deprecated. Use firewallPolicies.delete instead.
	Delete(context.Context, *DeleteOrganizationSecurityPolicyRequest) (*Operation, error)
	// List all of the ordered rules present in a single specified policy. Use of this API to read firewall policies is deprecated. Use firewallPolicies.get instead.
	Get(context.Context, *GetOrganizationSecurityPolicyRequest) (*SecurityPolicy, error)
	// Gets an association with the specified name. Use of this API to read firewall policies is deprecated. Use firewallPolicies.getAssociation instead if possible.
	GetAssociation(context.Context, *GetAssociationOrganizationSecurityPolicyRequest) (*SecurityPolicyAssociation, error)
	// Gets a rule at the specified priority. Use of this API to read firewall policies is deprecated. Use firewallPolicies.getRule instead.
	GetRule(context.Context, *GetRuleOrganizationSecurityPolicyRequest) (*SecurityPolicyRule, error)
	// Creates a new policy in the specified project using the data included in the request. Use of this API to insert firewall policies is deprecated. Use firewallPolicies.insert instead.
	Insert(context.Context, *InsertOrganizationSecurityPolicyRequest) (*Operation, error)
	// List all the policies that have been configured for the specified project. Use of this API to read firewall policies is deprecated. Use firewallPolicies.list instead.
	List(context.Context, *ListOrganizationSecurityPoliciesRequest) (*SecurityPolicyList, error)
	// Lists associations of a specified target, i.e., organization or folder. Use of this API to read firewall policies is deprecated. Use firewallPolicies.listAssociations instead if possible.
	ListAssociations(context.Context, *ListAssociationsOrganizationSecurityPolicyRequest) (*OrganizationSecurityPoliciesListAssociationsResponse, error)
	// Gets the current list of preconfigured Web Application Firewall (WAF) expressions.
	ListPreconfiguredExpressionSets(context.Context, *ListPreconfiguredExpressionSetsOrganizationSecurityPoliciesRequest) (*SecurityPoliciesListPreconfiguredExpressionSetsResponse, error)
	// Moves the specified security policy. Use of this API to modify firewall policies is deprecated. Use firewallPolicies.move instead.
	Move(context.Context, *MoveOrganizationSecurityPolicyRequest) (*Operation, error)
	// Patches the specified policy with the data included in the request. Use of this API to modify firewall policies is deprecated. Use firewallPolicies.patch instead.
	Patch(context.Context, *PatchOrganizationSecurityPolicyRequest) (*Operation, error)
	// Patches a rule at the specified priority. Use of this API to modify firewall policies is deprecated. Use firewallPolicies.patchRule instead.
	PatchRule(context.Context, *PatchRuleOrganizationSecurityPolicyRequest) (*Operation, error)
	// Removes an association for the specified security policy. Use of this API to modify firewall policies is deprecated. Use firewallPolicies.removeAssociation instead if possible.
	RemoveAssociation(context.Context, *RemoveAssociationOrganizationSecurityPolicyRequest) (*Operation, error)
	// Deletes a rule at the specified priority.
	RemoveRule(context.Context, *RemoveRuleOrganizationSecurityPolicyRequest) (*Operation, error)
}

// UnimplementedOrganizationSecurityPoliciesServer should be embedded to have forward compatible implementations.
type UnimplementedOrganizationSecurityPoliciesServer struct {
}

func (UnimplementedOrganizationSecurityPoliciesServer) AddAssociation(context.Context, *AddAssociationOrganizationSecurityPolicyRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddAssociation not implemented")
}
func (UnimplementedOrganizationSecurityPoliciesServer) AddRule(context.Context, *AddRuleOrganizationSecurityPolicyRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AddRule not implemented")
}
func (UnimplementedOrganizationSecurityPoliciesServer) CopyRules(context.Context, *CopyRulesOrganizationSecurityPolicyRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CopyRules not implemented")
}
func (UnimplementedOrganizationSecurityPoliciesServer) Delete(context.Context, *DeleteOrganizationSecurityPolicyRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedOrganizationSecurityPoliciesServer) Get(context.Context, *GetOrganizationSecurityPolicyRequest) (*SecurityPolicy, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedOrganizationSecurityPoliciesServer) GetAssociation(context.Context, *GetAssociationOrganizationSecurityPolicyRequest) (*SecurityPolicyAssociation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetAssociation not implemented")
}
func (UnimplementedOrganizationSecurityPoliciesServer) GetRule(context.Context, *GetRuleOrganizationSecurityPolicyRequest) (*SecurityPolicyRule, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetRule not implemented")
}
func (UnimplementedOrganizationSecurityPoliciesServer) Insert(context.Context, *InsertOrganizationSecurityPolicyRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (UnimplementedOrganizationSecurityPoliciesServer) List(context.Context, *ListOrganizationSecurityPoliciesRequest) (*SecurityPolicyList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedOrganizationSecurityPoliciesServer) ListAssociations(context.Context, *ListAssociationsOrganizationSecurityPolicyRequest) (*OrganizationSecurityPoliciesListAssociationsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListAssociations not implemented")
}
func (UnimplementedOrganizationSecurityPoliciesServer) ListPreconfiguredExpressionSets(context.Context, *ListPreconfiguredExpressionSetsOrganizationSecurityPoliciesRequest) (*SecurityPoliciesListPreconfiguredExpressionSetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ListPreconfiguredExpressionSets not implemented")
}
func (UnimplementedOrganizationSecurityPoliciesServer) Move(context.Context, *MoveOrganizationSecurityPolicyRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Move not implemented")
}
func (UnimplementedOrganizationSecurityPoliciesServer) Patch(context.Context, *PatchOrganizationSecurityPolicyRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Patch not implemented")
}
func (UnimplementedOrganizationSecurityPoliciesServer) PatchRule(context.Context, *PatchRuleOrganizationSecurityPolicyRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PatchRule not implemented")
}
func (UnimplementedOrganizationSecurityPoliciesServer) RemoveAssociation(context.Context, *RemoveAssociationOrganizationSecurityPolicyRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveAssociation not implemented")
}
func (UnimplementedOrganizationSecurityPoliciesServer) RemoveRule(context.Context, *RemoveRuleOrganizationSecurityPolicyRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method RemoveRule not implemented")
}

// UnsafeOrganizationSecurityPoliciesServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to OrganizationSecurityPoliciesServer will
// result in compilation errors.
type UnsafeOrganizationSecurityPoliciesServer interface {
	mustEmbedUnimplementedOrganizationSecurityPoliciesServer()
}

func RegisterOrganizationSecurityPoliciesServer(s grpc.ServiceRegistrar, srv OrganizationSecurityPoliciesServer) {
	s.RegisterService(&OrganizationSecurityPolicies_ServiceDesc, srv)
}

func _OrganizationSecurityPolicies_AddAssociation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddAssociationOrganizationSecurityPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OrganizationSecurityPoliciesServer).AddAssociation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OrganizationSecurityPolicies_AddAssociation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OrganizationSecurityPoliciesServer).AddAssociation(ctx, req.(*AddAssociationOrganizationSecurityPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OrganizationSecurityPolicies_AddRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AddRuleOrganizationSecurityPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OrganizationSecurityPoliciesServer).AddRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OrganizationSecurityPolicies_AddRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OrganizationSecurityPoliciesServer).AddRule(ctx, req.(*AddRuleOrganizationSecurityPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OrganizationSecurityPolicies_CopyRules_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CopyRulesOrganizationSecurityPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OrganizationSecurityPoliciesServer).CopyRules(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OrganizationSecurityPolicies_CopyRules_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OrganizationSecurityPoliciesServer).CopyRules(ctx, req.(*CopyRulesOrganizationSecurityPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OrganizationSecurityPolicies_Delete_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteOrganizationSecurityPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OrganizationSecurityPoliciesServer).Delete(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OrganizationSecurityPolicies_Delete_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OrganizationSecurityPoliciesServer).Delete(ctx, req.(*DeleteOrganizationSecurityPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OrganizationSecurityPolicies_Get_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOrganizationSecurityPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OrganizationSecurityPoliciesServer).Get(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OrganizationSecurityPolicies_Get_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OrganizationSecurityPoliciesServer).Get(ctx, req.(*GetOrganizationSecurityPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OrganizationSecurityPolicies_GetAssociation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetAssociationOrganizationSecurityPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OrganizationSecurityPoliciesServer).GetAssociation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OrganizationSecurityPolicies_GetAssociation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OrganizationSecurityPoliciesServer).GetAssociation(ctx, req.(*GetAssociationOrganizationSecurityPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OrganizationSecurityPolicies_GetRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetRuleOrganizationSecurityPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OrganizationSecurityPoliciesServer).GetRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OrganizationSecurityPolicies_GetRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OrganizationSecurityPoliciesServer).GetRule(ctx, req.(*GetRuleOrganizationSecurityPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OrganizationSecurityPolicies_Insert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(InsertOrganizationSecurityPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OrganizationSecurityPoliciesServer).Insert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OrganizationSecurityPolicies_Insert_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OrganizationSecurityPoliciesServer).Insert(ctx, req.(*InsertOrganizationSecurityPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OrganizationSecurityPolicies_List_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListOrganizationSecurityPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OrganizationSecurityPoliciesServer).List(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OrganizationSecurityPolicies_List_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OrganizationSecurityPoliciesServer).List(ctx, req.(*ListOrganizationSecurityPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OrganizationSecurityPolicies_ListAssociations_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAssociationsOrganizationSecurityPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OrganizationSecurityPoliciesServer).ListAssociations(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OrganizationSecurityPolicies_ListAssociations_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OrganizationSecurityPoliciesServer).ListAssociations(ctx, req.(*ListAssociationsOrganizationSecurityPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OrganizationSecurityPolicies_ListPreconfiguredExpressionSets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListPreconfiguredExpressionSetsOrganizationSecurityPoliciesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OrganizationSecurityPoliciesServer).ListPreconfiguredExpressionSets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OrganizationSecurityPolicies_ListPreconfiguredExpressionSets_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OrganizationSecurityPoliciesServer).ListPreconfiguredExpressionSets(ctx, req.(*ListPreconfiguredExpressionSetsOrganizationSecurityPoliciesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OrganizationSecurityPolicies_Move_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MoveOrganizationSecurityPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OrganizationSecurityPoliciesServer).Move(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OrganizationSecurityPolicies_Move_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OrganizationSecurityPoliciesServer).Move(ctx, req.(*MoveOrganizationSecurityPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OrganizationSecurityPolicies_Patch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchOrganizationSecurityPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OrganizationSecurityPoliciesServer).Patch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OrganizationSecurityPolicies_Patch_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OrganizationSecurityPoliciesServer).Patch(ctx, req.(*PatchOrganizationSecurityPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OrganizationSecurityPolicies_PatchRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PatchRuleOrganizationSecurityPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OrganizationSecurityPoliciesServer).PatchRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OrganizationSecurityPolicies_PatchRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OrganizationSecurityPoliciesServer).PatchRule(ctx, req.(*PatchRuleOrganizationSecurityPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OrganizationSecurityPolicies_RemoveAssociation_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveAssociationOrganizationSecurityPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OrganizationSecurityPoliciesServer).RemoveAssociation(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OrganizationSecurityPolicies_RemoveAssociation_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OrganizationSecurityPoliciesServer).RemoveAssociation(ctx, req.(*RemoveAssociationOrganizationSecurityPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OrganizationSecurityPolicies_RemoveRule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RemoveRuleOrganizationSecurityPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OrganizationSecurityPoliciesServer).RemoveRule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OrganizationSecurityPolicies_RemoveRule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OrganizationSecurityPoliciesServer).RemoveRule(ctx, req.(*RemoveRuleOrganizationSecurityPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// OrganizationSecurityPolicies_ServiceDesc is the grpc.ServiceDesc for OrganizationSecurityPolicies service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var OrganizationSecurityPolicies_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.compute.v1beta.OrganizationSecurityPolicies",
	HandlerType: (*OrganizationSecurityPoliciesServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "AddAssociation",
			Handler:    _OrganizationSecurityPolicies_AddAssociation_Handler,
		},
		{
			MethodName: "AddRule",
			Handler:    _OrganizationSecurityPolicies_AddRule_Handler,
		},
		{
			MethodName: "CopyRules",
			Handler:    _OrganizationSecurityPolicies_CopyRules_Handler,
		},
		{
			MethodName: "Delete",
			Handler:    _OrganizationSecurityPolicies_Delete_Handler,
		},
		{
			MethodName: "Get",
			Handler:    _OrganizationSecurityPolicies_Get_Handler,
		},
		{
			MethodName: "GetAssociation",
			Handler:    _OrganizationSecurityPolicies_GetAssociation_Handler,
		},
		{
			MethodName: "GetRule",
			Handler:    _OrganizationSecurityPolicies_GetRule_Handler,
		},
		{
			MethodName: "Insert",
			Handler:    _OrganizationSecurityPolicies_Insert_Handler,
		},
		{
			MethodName: "List",
			Handler:    _OrganizationSecurityPolicies_List_Handler,
		},
		{
			MethodName: "ListAssociations",
			Handler:    _OrganizationSecurityPolicies_ListAssociations_Handler,
		},
		{
			MethodName: "ListPreconfiguredExpressionSets",
			Handler:    _OrganizationSecurityPolicies_ListPreconfiguredExpressionSets_Handler,
		},
		{
			MethodName: "Move",
			Handler:    _OrganizationSecurityPolicies_Move_Handler,
		},
		{
			MethodName: "Patch",
			Handler:    _OrganizationSecurityPolicies_Patch_Handler,
		},
		{
			MethodName: "PatchRule",
			Handler:    _OrganizationSecurityPolicies_PatchRule_Handler,
		},
		{
			MethodName: "RemoveAssociation",
			Handler:    _OrganizationSecurityPolicies_RemoveAssociation_Handler,
		},
		{
			MethodName: "RemoveRule",
			Handler:    _OrganizationSecurityPolicies_RemoveRule_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/compute/v1beta/compute.proto",
}

const (
	PacketMirrorings_AggregatedList_FullMethodName     = "/google.cloud.compute.v1beta.PacketMirrorings/AggregatedList"
	PacketMirrorings_Delete_FullMethodName             = "/google.cloud.compute.v1beta.PacketMirrorings/Delete"
	PacketMirrorings_Get_FullMethodName                = "/google.cloud.compute.v1beta.PacketMirrorings/Get"
	PacketMirrorings_Insert_FullMethodName             = "/google.cloud.compute.v1beta.PacketMirrorings/Insert"
	PacketMirrorings_List_FullMethodName               = "/google.cloud.compute.v1beta.PacketMirrorings/List"
	PacketMirrorings_Patch_FullMethodName              = "/google.cloud.compute.v1beta.PacketMirrorings/Patch"
	PacketMirrorings_TestIamPermissions_FullMethodName = "/google.cloud.compute.v1beta.PacketMirrorings/TestIamPermissions"
)

// PacketMirroringsClient is the client API for PacketMirrorings service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type PacketMirroringsClient interface {
	// Retrieves an aggregated list of packetMirrorings. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(ctx context.Context, in *AggregatedListPacketMirroringsRequest, opts ...grpc.CallOption) (*PacketMirroringAggregatedList, error)
	// Deletes the specified PacketMirroring resource.
	Delete(ctx context.Context, in *DeletePacketMirroringRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns the specified PacketMirroring resource.
	Get(ctx context.Context, in *GetPacketMirroringRequest, opts ...grpc.CallOption) (*PacketMirroring, error)
	// Creates a PacketMirroring resource in the specified project and region using the data included in the request.
	Insert(ctx context.Context, in *InsertPacketMirroringRequest, opts ...grpc.CallOption) (*Operation, error)
	// Retrieves a list of PacketMirroring resources available to the specified project and region.
	List(ctx context.Context, in *ListPacketMirroringsRequest, opts ...grpc.CallOption) (*PacketMirroringList, error)
	// Patches the specified PacketMirroring resource with the data included in the request. This method supports PATCH semantics and uses JSON merge patch format and processing rules.
	Patch(ctx context.Context, in *PatchPacketMirroringRequest, opts ...grpc.CallOption) (*Operation, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(ctx context.Context, in *TestIamPermissionsPacketMirroringRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error)
}

type packetMirroringsClient struct {
	cc grpc.ClientConnInterface
}

func NewPacketMirroringsClient(cc grpc.ClientConnInterface) PacketMirroringsClient {
	return &packetMirroringsClient{cc}
}

func (c *packetMirroringsClient) AggregatedList(ctx context.Context, in *AggregatedListPacketMirroringsRequest, opts ...grpc.CallOption) (*PacketMirroringAggregatedList, error) {
	out := new(PacketMirroringAggregatedList)
	err := c.cc.Invoke(ctx, PacketMirrorings_AggregatedList_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *packetMirroringsClient) Delete(ctx context.Context, in *DeletePacketMirroringRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, PacketMirrorings_Delete_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *packetMirroringsClient) Get(ctx context.Context, in *GetPacketMirroringRequest, opts ...grpc.CallOption) (*PacketMirroring, error) {
	out := new(PacketMirroring)
	err := c.cc.Invoke(ctx, PacketMirrorings_Get_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *packetMirroringsClient) Insert(ctx context.Context, in *InsertPacketMirroringRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, PacketMirrorings_Insert_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *packetMirroringsClient) List(ctx context.Context, in *ListPacketMirroringsRequest, opts ...grpc.CallOption) (*PacketMirroringList, error) {
	out := new(PacketMirroringList)
	err := c.cc.Invoke(ctx, PacketMirrorings_List_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *packetMirroringsClient) Patch(ctx context.Context, in *PatchPacketMirroringRequest, opts ...grpc.CallOption) (*Operation, error) {
	out := new(Operation)
	err := c.cc.Invoke(ctx, PacketMirrorings_Patch_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *packetMirroringsClient) TestIamPermissions(ctx context.Context, in *TestIamPermissionsPacketMirroringRequest, opts ...grpc.CallOption) (*TestPermissionsResponse, error) {
	out := new(TestPermissionsResponse)
	err := c.cc.Invoke(ctx, PacketMirrorings_TestIamPermissions_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PacketMirroringsServer is the server API for PacketMirrorings service.
// All implementations should embed UnimplementedPacketMirroringsServer
// for forward compatibility
type PacketMirroringsServer interface {
	// Retrieves an aggregated list of packetMirrorings. To prevent failure, Google recommends that you set the `returnPartialSuccess` parameter to `true`.
	AggregatedList(context.Context, *AggregatedListPacketMirroringsRequest) (*PacketMirroringAggregatedList, error)
	// Deletes the specified PacketMirroring resource.
	Delete(context.Context, *DeletePacketMirroringRequest) (*Operation, error)
	// Returns the specified PacketMirroring resource.
	Get(context.Context, *GetPacketMirroringRequest) (*PacketMirroring, error)
	// Creates a PacketMirroring resource in the specified project and region using the data included in the request.
	Insert(context.Context, *InsertPacketMirroringRequest) (*Operation, error)
	// Retrieves a list of PacketMirroring resources available to the specified project and region.
	List(context.Context, *ListPacketMirroringsRequest) (*PacketMirroringList, error)
	// Patches the specified PacketMirroring resource with the data included in the request. This method supports PATCH semantics and uses JSON merge patch format and processing rules.
	Patch(context.Context, *PatchPacketMirroringRequest) (*Operation, error)
	// Returns permissions that a caller has on the specified resource.
	TestIamPermissions(context.Context, *TestIamPermissionsPacketMirroringRequest) (*TestPermissionsResponse, error)
}

// UnimplementedPacketMirroringsServer should be embedded to have forward compatible implementations.
type UnimplementedPacketMirroringsServer struct {
}

func (UnimplementedPacketMirroringsServer) AggregatedList(context.Context, *AggregatedListPacketMirroringsRequest) (*PacketMirroringAggregatedList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AggregatedList not implemented")
}
func (UnimplementedPacketMirroringsServer) Delete(context.Context, *DeletePacketMirroringRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Delete not implemented")
}
func (UnimplementedPacketMirroringsServer) Get(context.Context, *GetPacketMirroringRequest) (*PacketMirroring, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Get not implemented")
}
func (UnimplementedPacketMirroringsServer) Insert(context.Context, *InsertPacketMirroringRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Insert not implemented")
}
func (UnimplementedPacketMirroringsServer) List(context.Context, *ListPacketMirroringsRequest) (*PacketMirroringList, error) {
	return nil, status.Errorf(codes.Unimplemented, "method List not implemented")
}
func (UnimplementedPacketMirroringsServer) Patch(context.Context, *PatchPacketMirroringRequest) (*Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Patch not implemented")
}
func (UnimplementedPacketMirroringsServer) TestIamPermissions(context.Context, *TestIamPermissionsPacketMirroringRequest) (*TestPermissionsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method TestIamPermissions not implemented")
}

// UnsafePacketMirroringsServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to PacketMirroringsServer will
// result in compilation errors.
type UnsafePacketMirroringsServer interface {
	mustEmbedUnimplementedPacketMirroringsServer()
}

func RegisterPacketMirroringsServer(s grpc.ServiceRegistrar, srv PacketMirroringsServer) {
	s.Regi