// Code generated by the FlatBuffers compiler. DO NOT EDIT.

package fbs

import (
	flatbuffers "github.com/google/flatbuffers/go"
)

/// Callable, executes a job defined by regarding app
type CallableT struct {
	Name string
	Index uint32
	Arguments []string
	Id string
	Alias string
	Sync *SyncPointsT
	Watchdog CallableWdgConfig
}

func (t *CallableT) Pack(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	if t == nil { return 0 }
	nameOffset := builder.CreateString(t.Name)
	argumentsOffset := flatbuffers.UOffsetT(0)
	if t.Arguments != nil {
		argumentsLength := len(t.Arguments)
		argumentsOffsets := make([]flatbuffers.UOffsetT, argumentsLength)
		for j := 0; j < argumentsLength; j++ {
			argumentsOffsets[j] = builder.CreateString(t.Arguments[j])
		}
		CallableStartArgumentsVector(builder, argumentsLength)
		for j := argumentsLength - 1; j >= 0; j-- {
			builder.PrependUOffsetT(argumentsOffsets[j])
		}
		argumentsOffset = builder.EndVector(argumentsLength)
	}
	idOffset := builder.CreateString(t.Id)
	aliasOffset := builder.CreateString(t.Alias)
	syncOffset := t.Sync.Pack(builder)
	CallableStart(builder)
	CallableAddName(builder, nameOffset)
	CallableAddIndex(builder, t.Index)
	CallableAddArguments(builder, argumentsOffset)
	CallableAddId(builder, idOffset)
	CallableAddAlias(builder, aliasOffset)
	CallableAddSync(builder, syncOffset)
	CallableAddWatchdog(builder, t.Watchdog)
	return CallableEnd(builder)
}

func (rcv *Callable) UnPackTo(t *CallableT) {
	t.Name = string(rcv.Name())
	t.Index = rcv.Index()
	argumentsLength := rcv.ArgumentsLength()
	t.Arguments = make([]string, argumentsLength)
	for j := 0; j < argumentsLength; j++ {
		t.Arguments[j] = string(rcv.Arguments(j))
	}
	t.Id = string(rcv.Id())
	t.Alias = string(rcv.Alias())
	t.Sync = rcv.Sync(nil).UnPack()
	t.Watchdog = rcv.Watchdog()
}

func (rcv *Callable) UnPack() *CallableT {
	if rcv == nil { return nil }
	t := &CallableT{}
	rcv.UnPackTo(t)
	return t
}

type Callable struct {
	_tab flatbuffers.Table
}

func GetRootAsCallable(buf []byte, offset flatbuffers.UOffsetT) *Callable {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &Callable{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsCallable(buf []byte, offset flatbuffers.UOffsetT) *Callable {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &Callable{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *Callable) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *Callable) Table() flatbuffers.Table {
	return rcv._tab
}

/// Name of callable factory provided by an installed app
func (rcv *Callable) Name() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

/// Name of callable factory provided by an installed app
/// Run index to specify the call sequence, alternatively to the use of synchronization points
/// Notes:
///   - The run index ranges from 1 (high) to maximum of data type (low)
///   - Using of run index cause disabling of synchronization points of this callable
///   - Using no synchronization points and run index value '0' cause that this callable run together with other, same configured callables, unordered at the end of the task
func (rcv *Callable) Index() uint32 {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return rcv._tab.GetUint32(o + rcv._tab.Pos)
	}
	return 0
}

/// Run index to specify the call sequence, alternatively to the use of synchronization points
/// Notes:
///   - The run index ranges from 1 (high) to maximum of data type (low)
///   - Using of run index cause disabling of synchronization points of this callable
///   - Using no synchronization points and run index value '0' cause that this callable run together with other, same configured callables, unordered at the end of the task
func (rcv *Callable) MutateIndex(n uint32) bool {
	return rcv._tab.MutateUint32Slot(6, n)
}

/// List of arguments to create the callable, for further information see application description of the callable factory
func (rcv *Callable) Arguments(j int) []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		a := rcv._tab.Vector(o)
		return rcv._tab.ByteVector(a + flatbuffers.UOffsetT(j*4))
	}
	return nil
}

func (rcv *Callable) ArgumentsLength() int {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		return rcv._tab.VectorLen(o)
	}
	return 0
}

/// List of arguments to create the callable, for further information see application description of the callable factory
/// Callable ID, used as reference, which is assigned automatically by the Scheduler [0-9]+
func (rcv *Callable) Id() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

/// Callable ID, used as reference, which is assigned automatically by the Scheduler [0-9]+
/// Alias of callable, human readable replacement of callable ID
/// The alias have match to the Data Layer compliance guide lines meaning any alphanumeric character are allowed [a-zA-Z_][a-zA-Z0-9-._]+
func (rcv *Callable) Alias() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(12))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

/// Alias of callable, human readable replacement of callable ID
/// The alias have match to the Data Layer compliance guide lines meaning any alphanumeric character are allowed [a-zA-Z_][a-zA-Z0-9-._]+
/// Synchronization points to specify the call sequence, alternatively to the use of run index
/// Notes:
///   - Using of run index cause disabling of synchronization points of this callable
///   - Using no synchronization points and run index value '0' cause that this callable run together with other, same configured callables, unordered at the end of the task
func (rcv *Callable) Sync(obj *SyncPoints) *SyncPoints {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(14))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(SyncPoints)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

/// Synchronization points to specify the call sequence, alternatively to the use of run index
/// Notes:
///   - Using of run index cause disabling of synchronization points of this callable
///   - Using no synchronization points and run index value '0' cause that this callable run together with other, same configured callables, unordered at the end of the task
/// Requirement of the callable that a watchdog is present
func (rcv *Callable) Watchdog() CallableWdgConfig {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(16))
	if o != 0 {
		return CallableWdgConfig(rcv._tab.GetInt8(o + rcv._tab.Pos))
	}
	return 3
}

/// Requirement of the callable that a watchdog is present
func (rcv *Callable) MutateWatchdog(n CallableWdgConfig) bool {
	return rcv._tab.MutateInt8Slot(16, int8(n))
}

func CallableStart(builder *flatbuffers.Builder) {
	builder.StartObject(7)
}
func CallableAddName(builder *flatbuffers.Builder, name flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(0, flatbuffers.UOffsetT(name), 0)
}
func CallableAddIndex(builder *flatbuffers.Builder, index uint32) {
	builder.PrependUint32Slot(1, index, 0)
}
func CallableAddArguments(builder *flatbuffers.Builder, arguments flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(2, flatbuffers.UOffsetT(arguments), 0)
}
func CallableStartArgumentsVector(builder *flatbuffers.Builder, numElems int) flatbuffers.UOffsetT {
	return builder.StartVector(4, numElems, 4)
}
func CallableAddId(builder *flatbuffers.Builder, id flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(3, flatbuffers.UOffsetT(id), 0)
}
func CallableAddAlias(builder *flatbuffers.Builder, alias flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(4, flatbuffers.UOffsetT(alias), 0)
}
func CallableAddSync(builder *flatbuffers.Builder, sync flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(5, flatbuffers.UOffsetT(sync), 0)
}
func CallableAddWatchdog(builder *flatbuffers.Builder, watchdog CallableWdgConfig) {
	builder.PrependInt8Slot(6, int8(watchdog), 3)
}
func CallableEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}
