// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by the Google Gen AI SDK generator DO NOT EDIT.

package genai

import (
	"context"
	"fmt"
	"iter"
	"log"
	"net/http"
	"reflect"
	"sync"
)

func batchJobDestinationFromMldev(fromObject map[string]any, parentObject map[string]any, rootObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromFileName := getValueByPath(fromObject, []string{"responsesFile"})
	if fromFileName != nil {
		setValueByPath(toObject, []string{"fileName"}, fromFileName)
	}

	fromInlinedResponses := getValueByPath(fromObject, []string{"inlinedResponses", "inlinedResponses"})
	if fromInlinedResponses != nil {
		fromInlinedResponses, err = applyConverterToSliceWithRoot(fromInlinedResponses.([]any), inlinedResponseFromMldev, rootObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"inlinedResponses"}, fromInlinedResponses)
	}

	fromInlinedEmbedContentResponses := getValueByPath(fromObject, []string{"inlinedEmbedContentResponses", "inlinedResponses"})
	if fromInlinedEmbedContentResponses != nil {
		setValueByPath(toObject, []string{"inlinedEmbedContentResponses"}, fromInlinedEmbedContentResponses)
	}

	return toObject, nil
}

func batchJobDestinationFromVertex(fromObject map[string]any, parentObject map[string]any, rootObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromFormat := getValueByPath(fromObject, []string{"predictionsFormat"})
	if fromFormat != nil {
		setValueByPath(toObject, []string{"format"}, fromFormat)
	}

	fromGcsUri := getValueByPath(fromObject, []string{"gcsDestination", "outputUriPrefix"})
	if fromGcsUri != nil {
		setValueByPath(toObject, []string{"gcsUri"}, fromGcsUri)
	}

	fromBigqueryUri := getValueByPath(fromObject, []string{"bigqueryDestination", "outputUri"})
	if fromBigqueryUri != nil {
		setValueByPath(toObject, []string{"bigqueryUri"}, fromBigqueryUri)
	}

	return toObject, nil
}

func batchJobDestinationToVertex(fromObject map[string]any, parentObject map[string]any, rootObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromFormat := getValueByPath(fromObject, []string{"format"})
	if fromFormat != nil {
		setValueByPath(toObject, []string{"predictionsFormat"}, fromFormat)
	}

	fromGcsUri := getValueByPath(fromObject, []string{"gcsUri"})
	if fromGcsUri != nil {
		setValueByPath(toObject, []string{"gcsDestination", "outputUriPrefix"}, fromGcsUri)
	}

	fromBigqueryUri := getValueByPath(fromObject, []string{"bigqueryUri"})
	if fromBigqueryUri != nil {
		setValueByPath(toObject, []string{"bigqueryDestination", "outputUri"}, fromBigqueryUri)
	}

	if getValueByPath(fromObject, []string{"fileName"}) != nil {
		return nil, fmt.Errorf("fileName parameter is not supported in Vertex AI")
	}

	if getValueByPath(fromObject, []string{"inlinedResponses"}) != nil {
		return nil, fmt.Errorf("inlinedResponses parameter is not supported in Vertex AI")
	}

	if getValueByPath(fromObject, []string{"inlinedEmbedContentResponses"}) != nil {
		return nil, fmt.Errorf("inlinedEmbedContentResponses parameter is not supported in Vertex AI")
	}

	return toObject, nil
}

func batchJobFromMldev(fromObject map[string]any, parentObject map[string]any, rootObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromName := getValueByPath(fromObject, []string{"name"})
	if fromName != nil {
		setValueByPath(toObject, []string{"name"}, fromName)
	}

	fromDisplayName := getValueByPath(fromObject, []string{"metadata", "displayName"})
	if fromDisplayName != nil {
		setValueByPath(toObject, []string{"displayName"}, fromDisplayName)
	}

	fromState := getValueByPath(fromObject, []string{"metadata", "state"})
	if fromState != nil {
		fromState, err = tJobState(fromState)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"state"}, fromState)
	}

	fromCreateTime := getValueByPath(fromObject, []string{"metadata", "createTime"})
	if fromCreateTime != nil {
		setValueByPath(toObject, []string{"createTime"}, fromCreateTime)
	}

	fromEndTime := getValueByPath(fromObject, []string{"metadata", "endTime"})
	if fromEndTime != nil {
		setValueByPath(toObject, []string{"endTime"}, fromEndTime)
	}

	fromUpdateTime := getValueByPath(fromObject, []string{"metadata", "updateTime"})
	if fromUpdateTime != nil {
		setValueByPath(toObject, []string{"updateTime"}, fromUpdateTime)
	}

	fromModel := getValueByPath(fromObject, []string{"metadata", "model"})
	if fromModel != nil {
		setValueByPath(toObject, []string{"model"}, fromModel)
	}

	fromDest := getValueByPath(fromObject, []string{"metadata", "output"})
	if fromDest != nil {
		fromDest, err = tRecvBatchJobDestination(fromDest)
		if err != nil {
			return nil, err
		}

		fromDest, err = batchJobDestinationFromMldev(fromDest.(map[string]any), toObject, rootObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"dest"}, fromDest)
	}

	return toObject, nil
}

func batchJobFromVertex(fromObject map[string]any, parentObject map[string]any, rootObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromName := getValueByPath(fromObject, []string{"name"})
	if fromName != nil {
		setValueByPath(toObject, []string{"name"}, fromName)
	}

	fromDisplayName := getValueByPath(fromObject, []string{"displayName"})
	if fromDisplayName != nil {
		setValueByPath(toObject, []string{"displayName"}, fromDisplayName)
	}

	fromState := getValueByPath(fromObject, []string{"state"})
	if fromState != nil {
		fromState, err = tJobState(fromState)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"state"}, fromState)
	}

	fromError := getValueByPath(fromObject, []string{"error"})
	if fromError != nil {
		setValueByPath(toObject, []string{"error"}, fromError)
	}

	fromCreateTime := getValueByPath(fromObject, []string{"createTime"})
	if fromCreateTime != nil {
		setValueByPath(toObject, []string{"createTime"}, fromCreateTime)
	}

	fromStartTime := getValueByPath(fromObject, []string{"startTime"})
	if fromStartTime != nil {
		setValueByPath(toObject, []string{"startTime"}, fromStartTime)
	}

	fromEndTime := getValueByPath(fromObject, []string{"endTime"})
	if fromEndTime != nil {
		setValueByPath(toObject, []string{"endTime"}, fromEndTime)
	}

	fromUpdateTime := getValueByPath(fromObject, []string{"updateTime"})
	if fromUpdateTime != nil {
		setValueByPath(toObject, []string{"updateTime"}, fromUpdateTime)
	}

	fromModel := getValueByPath(fromObject, []string{"model"})
	if fromModel != nil {
		setValueByPath(toObject, []string{"model"}, fromModel)
	}

	fromSrc := getValueByPath(fromObject, []string{"inputConfig"})
	if fromSrc != nil {
		fromSrc, err = batchJobSourceFromVertex(fromSrc.(map[string]any), toObject, rootObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"src"}, fromSrc)
	}

	fromDest := getValueByPath(fromObject, []string{"outputConfig"})
	if fromDest != nil {
		fromDest, err = tRecvBatchJobDestination(fromDest)
		if err != nil {
			return nil, err
		}

		fromDest, err = batchJobDestinationFromVertex(fromDest.(map[string]any), toObject, rootObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"dest"}, fromDest)
	}

	fromCompletionStats := getValueByPath(fromObject, []string{"completionStats"})
	if fromCompletionStats != nil {
		setValueByPath(toObject, []string{"completionStats"}, fromCompletionStats)
	}

	return toObject, nil
}

func batchJobSourceFromVertex(fromObject map[string]any, parentObject map[string]any, rootObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromFormat := getValueByPath(fromObject, []string{"instancesFormat"})
	if fromFormat != nil {
		setValueByPath(toObject, []string{"format"}, fromFormat)
	}

	fromGcsUri := getValueByPath(fromObject, []string{"gcsSource", "uris"})
	if fromGcsUri != nil {
		setValueByPath(toObject, []string{"gcsUri"}, fromGcsUri)
	}

	fromBigqueryUri := getValueByPath(fromObject, []string{"bigquerySource", "inputUri"})
	if fromBigqueryUri != nil {
		setValueByPath(toObject, []string{"bigqueryUri"}, fromBigqueryUri)
	}

	return toObject, nil
}

func batchJobSourceToMldev(ac *apiClient, fromObject map[string]any, parentObject map[string]any, rootObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)
	if getValueByPath(fromObject, []string{"format"}) != nil {
		return nil, fmt.Errorf("format parameter is not supported in Gemini API")
	}

	if getValueByPath(fromObject, []string{"gcsUri"}) != nil {
		return nil, fmt.Errorf("gcsUri parameter is not supported in Gemini API")
	}

	if getValueByPath(fromObject, []string{"bigqueryUri"}) != nil {
		return nil, fmt.Errorf("bigqueryUri parameter is not supported in Gemini API")
	}

	fromFileName := getValueByPath(fromObject, []string{"fileName"})
	if fromFileName != nil {
		setValueByPath(toObject, []string{"fileName"}, fromFileName)
	}

	fromInlinedRequests := getValueByPath(fromObject, []string{"inlinedRequests"})
	if fromInlinedRequests != nil {
		fromInlinedRequests, err = applyConverterToSliceWithClientWithRoot(ac, fromInlinedRequests.([]any), inlinedRequestToMldev, rootObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"requests", "requests"}, fromInlinedRequests)
	}

	return toObject, nil
}

func batchJobSourceToVertex(fromObject map[string]any, parentObject map[string]any, rootObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromFormat := getValueByPath(fromObject, []string{"format"})
	if fromFormat != nil {
		setValueByPath(toObject, []string{"instancesFormat"}, fromFormat)
	}

	fromGcsUri := getValueByPath(fromObject, []string{"gcsUri"})
	if fromGcsUri != nil {
		setValueByPath(toObject, []string{"gcsSource", "uris"}, fromGcsUri)
	}

	fromBigqueryUri := getValueByPath(fromObject, []string{"bigqueryUri"})
	if fromBigqueryUri != nil {
		setValueByPath(toObject, []string{"bigquerySource", "inputUri"}, fromBigqueryUri)
	}

	if getValueByPath(fromObject, []string{"fileName"}) != nil {
		return nil, fmt.Errorf("fileName parameter is not supported in Vertex AI")
	}

	if getValueByPath(fromObject, []string{"inlinedRequests"}) != nil {
		return nil, fmt.Errorf("inlinedRequests parameter is not supported in Vertex AI")
	}

	return toObject, nil
}

func cancelBatchJobParametersToMldev(ac *apiClient, fromObject map[string]any, parentObject map[string]any, rootObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromName := getValueByPath(fromObject, []string{"name"})
	if fromName != nil {
		fromName, err = tBatchJobName(ac, fromName)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"_url", "name"}, fromName)
	}

	return toObject, nil
}

func cancelBatchJobParametersToVertex(ac *apiClient, fromObject map[string]any, parentObject map[string]any, rootObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromName := getValueByPath(fromObject, []string{"name"})
	if fromName != nil {
		fromName, err = tBatchJobName(ac, fromName)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"_url", "name"}, fromName)
	}

	return toObject, nil
}

func createBatchJobConfigToMldev(fromObject map[string]any, parentObject map[string]any, rootObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromDisplayName := getValueByPath(fromObject, []string{"displayName"})
	if fromDisplayName != nil {
		setValueByPath(parentObject, []string{"batch", "displayName"}, fromDisplayName)
	}

	if getValueByPath(fromObject, []string{"dest"}) != nil {
		return nil, fmt.Errorf("dest parameter is not supported in Gemini API")
	}

	return toObject, nil
}

func createBatchJobConfigToVertex(fromObject map[string]any, parentObject map[string]any, rootObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromDisplayName := getValueByPath(fromObject, []string{"displayName"})
	if fromDisplayName != nil {
		setValueByPath(parentObject, []string{"displayName"}, fromDisplayName)
	}

	fromDest := getValueByPath(fromObject, []string{"dest"})
	if fromDest != nil {
		fromDest, err = tBatchJobDestination(fromDest)
		if err != nil {
			return nil, err
		}

		fromDest, err = batchJobDestinationToVertex(fromDest.(map[string]any), toObject, rootObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(parentObject, []string{"outputConfig"}, fromDest)
	}

	return toObject, nil
}

func createBatchJobParametersToMldev(ac *apiClient, fromObject map[string]any, parentObject map[string]any, rootObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromModel := getValueByPath(fromObject, []string{"model"})
	if fromModel != nil {
		fromModel, err = tModel(ac, fromModel)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"_url", "model"}, fromModel)
	}

	fromSrc := getValueByPath(fromObject, []string{"src"})
	if fromSrc != nil {
		fromSrc, err = tBatchJobSource(fromSrc)
		if err != nil {
			return nil, err
		}

		fromSrc, err = batchJobSourceToMldev(ac, fromSrc.(map[string]any), toObject, rootObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"batch", "inputConfig"}, fromSrc)
	}

	fromConfig := getValueByPath(fromObject, []string{"config"})
	if fromConfig != nil {
		_, err = createBatchJobConfigToMldev(fromConfig.(map[string]any), toObject, rootObject)
		if err != nil {
			return nil, err
		}
	}

	return toObject, nil
}

func createBatchJobParametersToVertex(ac *apiClient, fromObject map[string]any, parentObject map[string]any, rootObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromModel := getValueByPath(fromObject, []string{"model"})
	if fromModel != nil {
		fromModel, err = tModel(ac, fromModel)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"model"}, fromModel)
	}

	fromSrc := getValueByPath(fromObject, []string{"src"})
	if fromSrc != nil {
		fromSrc, err = tBatchJobSource(fromSrc)
		if err != nil {
			return nil, err
		}

		fromSrc, err = batchJobSourceToVertex(fromSrc.(map[string]any), toObject, rootObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"inputConfig"}, fromSrc)
	}

	fromConfig := getValueByPath(fromObject, []string{"config"})
	if fromConfig != nil {
		_, err = createBatchJobConfigToVertex(fromConfig.(map[string]any), toObject, rootObject)
		if err != nil {
			return nil, err
		}
	}

	return toObject, nil
}

func createEmbeddingsBatchJobConfigToMldev(fromObject map[string]any, parentObject map[string]any, rootObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromDisplayName := getValueByPath(fromObject, []string{"displayName"})
	if fromDisplayName != nil {
		setValueByPath(parentObject, []string{"batch", "displayName"}, fromDisplayName)
	}

	return toObject, nil
}

func createEmbeddingsBatchJobParametersToMldev(ac *apiClient, fromObject map[string]any, parentObject map[string]any, rootObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromModel := getValueByPath(fromObject, []string{"model"})
	if fromModel != nil {
		fromModel, err = tModel(ac, fromModel)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"_url", "model"}, fromModel)
	}

	fromSrc := getValueByPath(fromObject, []string{"src"})
	if fromSrc != nil {
		fromSrc, err = embeddingsBatchJobSourceToMldev(ac, fromSrc.(map[string]any), toObject, rootObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"batch", "inputConfig"}, fromSrc)
	}

	fromConfig := getValueByPath(fromObject, []string{"config"})
	if fromConfig != nil {
		_, err = createEmbeddingsBatchJobConfigToMldev(fromConfig.(map[string]any), toObject, rootObject)
		if err != nil {
			return nil, err
		}
	}

	return toObject, nil
}

func deleteBatchJobParametersToMldev(ac *apiClient, fromObject map[string]any, parentObject map[string]any, rootObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromName := getValueByPath(fromObject, []string{"name"})
	if fromName != nil {
		fromName, err = tBatchJobName(ac, fromName)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"_url", "name"}, fromName)
	}

	return toObject, nil
}

func deleteBatchJobParametersToVertex(ac *apiClient, fromObject map[string]any, parentObject map[string]any, rootObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromName := getValueByPath(fromObject, []string{"name"})
	if fromName != nil {
		fromName, err = tBatchJobName(ac, fromName)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"_url", "name"}, fromName)
	}

	return toObject, nil
}

func deleteResourceJobFromMldev(fromObject map[string]any, parentObject map[string]any, rootObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromSdkHttpResponse := getValueByPath(fromObject, []string{"sdkHttpResponse"})
	if fromSdkHttpResponse != nil {
		setValueByPath(toObject, []string{"sdkHttpResponse"}, fromSdkHttpResponse)
	}

	fromName := getValueByPath(fromObject, []string{"name"})
	if fromName != nil {
		setValueByPath(toObject, []string{"name"}, fromName)
	}

	fromDone := getValueByPath(fromObject, []string{"done"})
	if fromDone != nil {
		setValueByPath(toObject, []string{"done"}, fromDone)
	}

	fromError := getValueByPath(fromObject, []string{"error"})
	if fromError != nil {
		setValueByPath(toObject, []string{"error"}, fromError)
	}

	return toObject, nil
}

func deleteResourceJobFromVertex(fromObject map[string]any, parentObject map[string]any, rootObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromSdkHttpResponse := getValueByPath(fromObject, []string{"sdkHttpResponse"})
	if fromSdkHttpResponse != nil {
		setValueByPath(toObject, []string{"sdkHttpResponse"}, fromSdkHttpResponse)
	}

	fromName := getValueByPath(fromObject, []string{"name"})
	if fromName != nil {
		setValueByPath(toObject, []string{"name"}, fromName)
	}

	fromDone := getValueByPath(fromObject, []string{"done"})
	if fromDone != nil {
		setValueByPath(toObject, []string{"done"}, fromDone)
	}

	fromError := getValueByPath(fromObject, []string{"error"})
	if fromError != nil {
		setValueByPath(toObject, []string{"error"}, fromError)
	}

	return toObject, nil
}

func embedContentBatchToMldev(ac *apiClient, fromObject map[string]any, parentObject map[string]any, rootObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromContents := getValueByPath(fromObject, []string{"contents"})
	if fromContents != nil {
		fromContents, err = tContentsForEmbed(ac, fromContents)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"requests[]", "request", "content"}, fromContents)
	}

	fromConfig := getValueByPath(fromObject, []string{"config"})
	if fromConfig != nil {
		fromConfig, err = embedContentConfigToMldev(fromConfig.(map[string]any), toObject, rootObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"_self"}, fromConfig)
		moveValueByPath(toObject, map[string]string{"requests[].*": "requests[].request.*"})
	}

	return toObject, nil
}

func embeddingsBatchJobSourceToMldev(ac *apiClient, fromObject map[string]any, parentObject map[string]any, rootObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromFileName := getValueByPath(fromObject, []string{"fileName"})
	if fromFileName != nil {
		setValueByPath(toObject, []string{"file_name"}, fromFileName)
	}

	fromInlinedRequests := getValueByPath(fromObject, []string{"inlinedRequests"})
	if fromInlinedRequests != nil {
		fromInlinedRequests, err = embedContentBatchToMldev(ac, fromInlinedRequests.(map[string]any), toObject, rootObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"requests"}, fromInlinedRequests)
	}

	return toObject, nil
}

func getBatchJobParametersToMldev(ac *apiClient, fromObject map[string]any, parentObject map[string]any, rootObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromName := getValueByPath(fromObject, []string{"name"})
	if fromName != nil {
		fromName, err = tBatchJobName(ac, fromName)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"_url", "name"}, fromName)
	}

	return toObject, nil
}

func getBatchJobParametersToVertex(ac *apiClient, fromObject map[string]any, parentObject map[string]any, rootObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromName := getValueByPath(fromObject, []string{"name"})
	if fromName != nil {
		fromName, err = tBatchJobName(ac, fromName)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"_url", "name"}, fromName)
	}

	return toObject, nil
}

func inlinedRequestToMldev(ac *apiClient, fromObject map[string]any, parentObject map[string]any, rootObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromModel := getValueByPath(fromObject, []string{"model"})
	if fromModel != nil {
		fromModel, err = tModel(ac, fromModel)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"request", "model"}, fromModel)
	}

	fromContents := getValueByPath(fromObject, []string{"contents"})
	if fromContents != nil {
		fromContents, err = tContents(fromContents)
		if err != nil {
			return nil, err
		}

		fromContents, err = applyConverterToSliceWithRoot(fromContents.([]any), contentToMldev, rootObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"request", "contents"}, fromContents)
	}

	fromMetadata := getValueByPath(fromObject, []string{"metadata"})
	if fromMetadata != nil {
		setValueByPath(toObject, []string{"metadata"}, fromMetadata)
	}

	fromConfig := getValueByPath(fromObject, []string{"config"})
	if fromConfig != nil {
		fromConfig, err = generateContentConfigToMldev(ac, fromConfig.(map[string]any), getValueByPathOrDefault(toObject, []string{"request"}, map[string]any{}).(map[string]any), rootObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"request", "generationConfig"}, fromConfig)
	}

	return toObject, nil
}

func inlinedResponseFromMldev(fromObject map[string]any, parentObject map[string]any, rootObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromResponse := getValueByPath(fromObject, []string{"response"})
	if fromResponse != nil {
		fromResponse, err = generateContentResponseFromMldev(fromResponse.(map[string]any), toObject, rootObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"response"}, fromResponse)
	}

	fromMetadata := getValueByPath(fromObject, []string{"metadata"})
	if fromMetadata != nil {
		setValueByPath(toObject, []string{"metadata"}, fromMetadata)
	}

	fromError := getValueByPath(fromObject, []string{"error"})
	if fromError != nil {
		setValueByPath(toObject, []string{"error"}, fromError)
	}

	return toObject, nil
}

func listBatchJobsConfigToMldev(fromObject map[string]any, parentObject map[string]any, rootObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromPageSize := getValueByPath(fromObject, []string{"pageSize"})
	if fromPageSize != nil {
		setValueByPath(parentObject, []string{"_query", "pageSize"}, fromPageSize)
	}

	fromPageToken := getValueByPath(fromObject, []string{"pageToken"})
	if fromPageToken != nil {
		setValueByPath(parentObject, []string{"_query", "pageToken"}, fromPageToken)
	}

	if getValueByPath(fromObject, []string{"filter"}) != nil {
		return nil, fmt.Errorf("filter parameter is not supported in Gemini API")
	}

	return toObject, nil
}

func listBatchJobsConfigToVertex(fromObject map[string]any, parentObject map[string]any, rootObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromPageSize := getValueByPath(fromObject, []string{"pageSize"})
	if fromPageSize != nil {
		setValueByPath(parentObject, []string{"_query", "pageSize"}, fromPageSize)
	}

	fromPageToken := getValueByPath(fromObject, []string{"pageToken"})
	if fromPageToken != nil {
		setValueByPath(parentObject, []string{"_query", "pageToken"}, fromPageToken)
	}

	fromFilter := getValueByPath(fromObject, []string{"filter"})
	if fromFilter != nil {
		setValueByPath(parentObject, []string{"_query", "filter"}, fromFilter)
	}

	return toObject, nil
}

func listBatchJobsParametersToMldev(fromObject map[string]any, parentObject map[string]any, rootObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromConfig := getValueByPath(fromObject, []string{"config"})
	if fromConfig != nil {
		_, err = listBatchJobsConfigToMldev(fromConfig.(map[string]any), toObject, rootObject)
		if err != nil {
			return nil, err
		}
	}

	return toObject, nil
}

func listBatchJobsParametersToVertex(fromObject map[string]any, parentObject map[string]any, rootObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromConfig := getValueByPath(fromObject, []string{"config"})
	if fromConfig != nil {
		_, err = listBatchJobsConfigToVertex(fromConfig.(map[string]any), toObject, rootObject)
		if err != nil {
			return nil, err
		}
	}

	return toObject, nil
}

func listBatchJobsResponseFromMldev(fromObject map[string]any, parentObject map[string]any, rootObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromSdkHttpResponse := getValueByPath(fromObject, []string{"sdkHttpResponse"})
	if fromSdkHttpResponse != nil {
		setValueByPath(toObject, []string{"sdkHttpResponse"}, fromSdkHttpResponse)
	}

	fromNextPageToken := getValueByPath(fromObject, []string{"nextPageToken"})
	if fromNextPageToken != nil {
		setValueByPath(toObject, []string{"nextPageToken"}, fromNextPageToken)
	}

	fromBatchJobs := getValueByPath(fromObject, []string{"operations"})
	if fromBatchJobs != nil {
		fromBatchJobs, err = applyConverterToSliceWithRoot(fromBatchJobs.([]any), batchJobFromMldev, rootObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"batchJobs"}, fromBatchJobs)
	}

	return toObject, nil
}

func listBatchJobsResponseFromVertex(fromObject map[string]any, parentObject map[string]any, rootObject map[string]any) (toObject map[string]any, err error) {
	toObject = make(map[string]any)

	fromSdkHttpResponse := getValueByPath(fromObject, []string{"sdkHttpResponse"})
	if fromSdkHttpResponse != nil {
		setValueByPath(toObject, []string{"sdkHttpResponse"}, fromSdkHttpResponse)
	}

	fromNextPageToken := getValueByPath(fromObject, []string{"nextPageToken"})
	if fromNextPageToken != nil {
		setValueByPath(toObject, []string{"nextPageToken"}, fromNextPageToken)
	}

	fromBatchJobs := getValueByPath(fromObject, []string{"batchPredictionJobs"})
	if fromBatchJobs != nil {
		fromBatchJobs, err = applyConverterToSliceWithRoot(fromBatchJobs.([]any), batchJobFromVertex, rootObject)
		if err != nil {
			return nil, err
		}

		setValueByPath(toObject, []string{"batchJobs"}, fromBatchJobs)
	}

	return toObject, nil
}

// Batches provides methods for managing the batch jobs.
// You don't need to initiate this struct. Create a client instance via NewClient, and
// then access Batches through client.Batches field.
type Batches struct {
	apiClient *apiClient
}

func (m Batches) create(ctx context.Context, model *string, src *BatchJobSource, config *CreateBatchJobConfig) (*BatchJob, error) {
	parameterMap := make(map[string]any)

	kwargs := map[string]any{"model": model, "src": src, "config": config}
	deepMarshal(kwargs, &parameterMap)

	var httpOptions *HTTPOptions
	if config == nil || config.HTTPOptions == nil {
		httpOptions = &HTTPOptions{}
	} else {
		httpOptions = config.HTTPOptions
	}
	if httpOptions.Headers == nil {
		httpOptions.Headers = http.Header{}
	}
	var response = new(BatchJob)
	var responseMap map[string]any
	var fromConverter func(map[string]any, map[string]any, map[string]any) (map[string]any, error)
	var toConverter func(*apiClient, map[string]any, map[string]any, map[string]any) (map[string]any, error)
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		toConverter = createBatchJobParametersToVertex
		fromConverter = batchJobFromVertex
	} else {
		toConverter = createBatchJobParametersToMldev
		fromConverter = batchJobFromMldev
	}

	body, err := toConverter(m.apiClient, parameterMap, nil, parameterMap)
	if err != nil {
		return nil, err
	}
	var path string
	var urlParams map[string]any
	if _, ok := body["_url"]; ok {
		urlParams = body["_url"].(map[string]any)
		delete(body, "_url")
	}
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		path, err = formatMap("batchPredictionJobs", urlParams)
	} else {
		path, err = formatMap("{model}:batchGenerateContent", urlParams)
	}
	if err != nil {
		return nil, fmt.Errorf("invalid url params: %#v.\n%w", urlParams, err)
	}
	if _, ok := body["_query"]; ok {
		query, err := createURLQuery(body["_query"].(map[string]any))
		if err != nil {
			return nil, err
		}
		path += "?" + query
		delete(body, "_query")
	}
	responseMap, err = sendRequest(ctx, m.apiClient, path, http.MethodPost, body, httpOptions)
	if err != nil {
		return nil, err
	}
	if fromConverter != nil {
		responseMap, err = fromConverter(responseMap, nil, parameterMap)
	}
	if err != nil {
		return nil, err
	}
	err = mapToStruct(responseMap, response)
	if err != nil {
		return nil, err
	}

	if field, ok := reflect.TypeOf(response).Elem().FieldByName("SDKHTTPResponse"); ok {
		{
			if reflect.ValueOf(response).Elem().FieldByName("SDKHTTPResponse").IsValid() {
				{
					reflect.ValueOf(response).Elem().FieldByName("SDKHTTPResponse").Set(reflect.Zero(field.Type))
				}
			}
		}
	}

	return response, nil
}

func (m Batches) createEmbeddings(ctx context.Context, model *string, src *EmbeddingsBatchJobSource, config *CreateEmbeddingsBatchJobConfig) (*BatchJob, error) {
	parameterMap := make(map[string]any)

	kwargs := map[string]any{"model": model, "src": src, "config": config}
	deepMarshal(kwargs, &parameterMap)

	var httpOptions *HTTPOptions
	if config == nil || config.HTTPOptions == nil {
		httpOptions = &HTTPOptions{}
	} else {
		httpOptions = config.HTTPOptions
	}
	if httpOptions.Headers == nil {
		httpOptions.Headers = http.Header{}
	}
	var response = new(BatchJob)
	var responseMap map[string]any
	var fromConverter func(map[string]any, map[string]any, map[string]any) (map[string]any, error)
	var toConverter func(*apiClient, map[string]any, map[string]any, map[string]any) (map[string]any, error)
	if m.apiClient.clientConfig.Backend == BackendVertexAI {

		return nil, fmt.Errorf("method CreateEmbeddings is only supported in the Gemini Developer client. You can choose to use Gemini Developer client by setting ClientConfig.Backend to BackendGeminiAPI.")

	} else {
		toConverter = createEmbeddingsBatchJobParametersToMldev
		fromConverter = batchJobFromMldev
	}

	body, err := toConverter(m.apiClient, parameterMap, nil, parameterMap)
	if err != nil {
		return nil, err
	}
	var path string
	var urlParams map[string]any
	if _, ok := body["_url"]; ok {
		urlParams = body["_url"].(map[string]any)
		delete(body, "_url")
	}
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		path, err = formatMap("None", urlParams)
	} else {
		path, err = formatMap("{model}:asyncBatchEmbedContent", urlParams)
	}
	if err != nil {
		return nil, fmt.Errorf("invalid url params: %#v.\n%w", urlParams, err)
	}
	if _, ok := body["_query"]; ok {
		query, err := createURLQuery(body["_query"].(map[string]any))
		if err != nil {
			return nil, err
		}
		path += "?" + query
		delete(body, "_query")
	}
	responseMap, err = sendRequest(ctx, m.apiClient, path, http.MethodPost, body, httpOptions)
	if err != nil {
		return nil, err
	}
	if fromConverter != nil {
		responseMap, err = fromConverter(responseMap, nil, parameterMap)
	}
	if err != nil {
		return nil, err
	}
	err = mapToStruct(responseMap, response)
	if err != nil {
		return nil, err
	}

	if field, ok := reflect.TypeOf(response).Elem().FieldByName("SDKHTTPResponse"); ok {
		{
			if reflect.ValueOf(response).Elem().FieldByName("SDKHTTPResponse").IsValid() {
				{
					reflect.ValueOf(response).Elem().FieldByName("SDKHTTPResponse").Set(reflect.Zero(field.Type))
				}
			}
		}
	}

	return response, nil
}

// Get gets a batch job resource.
func (m Batches) Get(ctx context.Context, name string, config *GetBatchJobConfig) (*BatchJob, error) {
	parameterMap := make(map[string]any)

	kwargs := map[string]any{"name": name, "config": config}
	deepMarshal(kwargs, &parameterMap)

	var httpOptions *HTTPOptions
	if config == nil || config.HTTPOptions == nil {
		httpOptions = &HTTPOptions{}
	} else {
		httpOptions = config.HTTPOptions
	}
	if httpOptions.Headers == nil {
		httpOptions.Headers = http.Header{}
	}
	var response = new(BatchJob)
	var responseMap map[string]any
	var fromConverter func(map[string]any, map[string]any, map[string]any) (map[string]any, error)
	var toConverter func(*apiClient, map[string]any, map[string]any, map[string]any) (map[string]any, error)
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		toConverter = getBatchJobParametersToVertex
		fromConverter = batchJobFromVertex
	} else {
		toConverter = getBatchJobParametersToMldev
		fromConverter = batchJobFromMldev
	}

	body, err := toConverter(m.apiClient, parameterMap, nil, parameterMap)
	if err != nil {
		return nil, err
	}
	var path string
	var urlParams map[string]any
	if _, ok := body["_url"]; ok {
		urlParams = body["_url"].(map[string]any)
		delete(body, "_url")
	}
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		path, err = formatMap("batchPredictionJobs/{name}", urlParams)
	} else {
		path, err = formatMap("batches/{name}", urlParams)
	}
	if err != nil {
		return nil, fmt.Errorf("invalid url params: %#v.\n%w", urlParams, err)
	}
	if _, ok := body["_query"]; ok {
		query, err := createURLQuery(body["_query"].(map[string]any))
		if err != nil {
			return nil, err
		}
		path += "?" + query
		delete(body, "_query")
	}
	responseMap, err = sendRequest(ctx, m.apiClient, path, http.MethodGet, body, httpOptions)
	if err != nil {
		return nil, err
	}
	if fromConverter != nil {
		responseMap, err = fromConverter(responseMap, nil, parameterMap)
	}
	if err != nil {
		return nil, err
	}
	err = mapToStruct(responseMap, response)
	if err != nil {
		return nil, err
	}

	if field, ok := reflect.TypeOf(response).Elem().FieldByName("SDKHTTPResponse"); ok {
		{
			if reflect.ValueOf(response).Elem().FieldByName("SDKHTTPResponse").IsValid() {
				{
					reflect.ValueOf(response).Elem().FieldByName("SDKHTTPResponse").Set(reflect.Zero(field.Type))
				}
			}
		}
	}

	return response, nil
}

// Cancel cancels a batch job resource.
func (m Batches) Cancel(ctx context.Context, name string, config *CancelBatchJobConfig) error {
	parameterMap := make(map[string]any)

	kwargs := map[string]any{"name": name, "config": config}
	deepMarshal(kwargs, &parameterMap)

	var httpOptions *HTTPOptions
	if config == nil || config.HTTPOptions == nil {
		httpOptions = &HTTPOptions{}
	} else {
		httpOptions = config.HTTPOptions
	}
	if httpOptions.Headers == nil {
		httpOptions.Headers = http.Header{}
	}
	var toConverter func(*apiClient, map[string]any, map[string]any, map[string]any) (map[string]any, error)
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		toConverter = cancelBatchJobParametersToVertex

	} else {
		toConverter = cancelBatchJobParametersToMldev

	}

	body, err := toConverter(m.apiClient, parameterMap, nil, parameterMap)
	if err != nil {
		return err
	}
	var path string
	var urlParams map[string]any
	if _, ok := body["_url"]; ok {
		urlParams = body["_url"].(map[string]any)
		delete(body, "_url")
	}
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		path, err = formatMap("batchPredictionJobs/{name}:cancel", urlParams)
	} else {
		path, err = formatMap("batches/{name}:cancel", urlParams)
	}
	if err != nil {
		return fmt.Errorf("invalid url params: %#v.\n%w", urlParams, err)
	}
	if _, ok := body["_query"]; ok {
		query, err := createURLQuery(body["_query"].(map[string]any))
		if err != nil {
			return err
		}
		path += "?" + query
		delete(body, "_query")
	}
	_, err = sendRequest(ctx, m.apiClient, path, http.MethodPost, body, httpOptions)
	if err != nil {
		return err
	}

	return nil
}

func (m Batches) list(ctx context.Context, config *ListBatchJobsConfig) (*ListBatchJobsResponse, error) {
	parameterMap := make(map[string]any)

	kwargs := map[string]any{"config": config}
	deepMarshal(kwargs, &parameterMap)

	var httpOptions *HTTPOptions
	if config == nil || config.HTTPOptions == nil {
		httpOptions = &HTTPOptions{}
	} else {
		httpOptions = config.HTTPOptions
	}
	if httpOptions.Headers == nil {
		httpOptions.Headers = http.Header{}
	}
	var response = new(ListBatchJobsResponse)
	var responseMap map[string]any
	var fromConverter func(map[string]any, map[string]any, map[string]any) (map[string]any, error)
	var toConverter func(map[string]any, map[string]any, map[string]any) (map[string]any, error)
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		toConverter = listBatchJobsParametersToVertex
		fromConverter = listBatchJobsResponseFromVertex
	} else {
		toConverter = listBatchJobsParametersToMldev
		fromConverter = listBatchJobsResponseFromMldev
	}

	body, err := toConverter(parameterMap, nil, parameterMap)
	if err != nil {
		return nil, err
	}
	var path string
	var urlParams map[string]any
	if _, ok := body["_url"]; ok {
		urlParams = body["_url"].(map[string]any)
		delete(body, "_url")
	}
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		path, err = formatMap("batchPredictionJobs", urlParams)
	} else {
		path, err = formatMap("batches", urlParams)
	}
	if err != nil {
		return nil, fmt.Errorf("invalid url params: %#v.\n%w", urlParams, err)
	}
	if _, ok := body["_query"]; ok {
		query, err := createURLQuery(body["_query"].(map[string]any))
		if err != nil {
			return nil, err
		}
		path += "?" + query
		delete(body, "_query")
	}
	responseMap, err = sendRequest(ctx, m.apiClient, path, http.MethodGet, body, httpOptions)
	if err != nil {
		return nil, err
	}
	if fromConverter != nil {
		responseMap, err = fromConverter(responseMap, nil, parameterMap)
	}
	if err != nil {
		return nil, err
	}
	err = mapToStruct(responseMap, response)
	if err != nil {
		return nil, err
	}

	return response, nil
}

// Delete deletes a batch job resource.
func (m Batches) Delete(ctx context.Context, name string, config *DeleteBatchJobConfig) (*DeleteResourceJob, error) {
	parameterMap := make(map[string]any)

	kwargs := map[string]any{"name": name, "config": config}
	deepMarshal(kwargs, &parameterMap)

	var httpOptions *HTTPOptions
	if config == nil || config.HTTPOptions == nil {
		httpOptions = &HTTPOptions{}
	} else {
		httpOptions = config.HTTPOptions
	}
	if httpOptions.Headers == nil {
		httpOptions.Headers = http.Header{}
	}
	var response = new(DeleteResourceJob)
	var responseMap map[string]any
	var fromConverter func(map[string]any, map[string]any, map[string]any) (map[string]any, error)
	var toConverter func(*apiClient, map[string]any, map[string]any, map[string]any) (map[string]any, error)
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		toConverter = deleteBatchJobParametersToVertex
		fromConverter = deleteResourceJobFromVertex
	} else {
		toConverter = deleteBatchJobParametersToMldev
		fromConverter = deleteResourceJobFromMldev
	}

	body, err := toConverter(m.apiClient, parameterMap, nil, parameterMap)
	if err != nil {
		return nil, err
	}
	var path string
	var urlParams map[string]any
	if _, ok := body["_url"]; ok {
		urlParams = body["_url"].(map[string]any)
		delete(body, "_url")
	}
	if m.apiClient.clientConfig.Backend == BackendVertexAI {
		path, err = formatMap("batchPredictionJobs/{name}", urlParams)
	} else {
		path, err = formatMap("batches/{name}", urlParams)
	}
	if err != nil {
		return nil, fmt.Errorf("invalid url params: %#v.\n%w", urlParams, err)
	}
	if _, ok := body["_query"]; ok {
		query, err := createURLQuery(body["_query"].(map[string]any))
		if err != nil {
			return nil, err
		}
		path += "?" + query
		delete(body, "_query")
	}
	responseMap, err = sendRequest(ctx, m.apiClient, path, http.MethodDelete, body, httpOptions)
	if err != nil {
		return nil, err
	}
	if fromConverter != nil {
		responseMap, err = fromConverter(responseMap, nil, parameterMap)
	}
	if err != nil {
		return nil, err
	}
	err = mapToStruct(responseMap, response)
	if err != nil {
		return nil, err
	}

	return response, nil
}

// List retrieves a paginated list of batch_jobs resources.
func (m Batches) List(ctx context.Context, config *ListBatchJobsConfig) (Page[BatchJob], error) {
	listFunc := func(ctx context.Context, config map[string]any) ([]*BatchJob, string, *HTTPResponse, error) {
		var c ListBatchJobsConfig
		if err := mapToStruct(config, &c); err != nil {
			return nil, "", nil, err
		}
		resp, err := m.list(ctx, &c)
		if err != nil {
			return nil, "", nil, err
		}
		return resp.BatchJobs, resp.NextPageToken, resp.SDKHTTPResponse, nil
	}
	c := make(map[string]any)
	deepMarshal(config, &c)
	return newPage(ctx, "batchJobs", c, listFunc)
}

// All retrieves all batch_jobs resources.
//
// This method handles pagination internally, making multiple API calls as needed
// to fetch all entries. It returns an iterator that yields each "batchJobs"
// entry one by one. You do not need to manage pagination
// tokens or make multiple calls to retrieve all data.
func (m Batches) All(ctx context.Context) iter.Seq2[*BatchJob, error] {
	listFunc := func(ctx context.Context, config map[string]any) ([]*BatchJob, string, *HTTPResponse, error) {
		var c ListBatchJobsConfig
		if err := mapToStruct(config, &c); err != nil {
			return nil, "", nil, err
		}
		resp, err := m.list(ctx, &c)
		if err != nil {
			return nil, "", nil, err
		}
		return resp.BatchJobs, resp.NextPageToken, resp.SDKHTTPResponse, nil
	}
	p, err := newPage(ctx, "batchJobs", map[string]any{}, listFunc)
	if err != nil {
		return yieldErrorAndEndIterator[BatchJob](err)
	}
	return p.all(ctx)
}

// Create a batch job.
func (b Batches) Create(ctx context.Context, model string, src *BatchJobSource, config *CreateBatchJobConfig) (*BatchJob, error) {
	if b.apiClient.clientConfig.Backend == BackendVertexAI {
		if len(src.InlinedRequests) > 0 {
			return nil, fmt.Errorf("InlinedRequests is not supported for Vertex AI backend.")
		}
		if src.FileName != "" {
			return nil, fmt.Errorf("FileName is not supported for Vertex AI backend.")
		}
		if len(src.GCSURI) != 0 && src.BigqueryURI != "" {
			return nil, fmt.Errorf("Only one of GCSURI ([]string) and BigqueryURI (string) can be set.")
		}
		if len(src.GCSURI) == 0 && src.BigqueryURI == "" {
			return nil, fmt.Errorf("One of GCSURI ([]string) and BigqueryURI (string) must be set.")
		}
	} else {
		if src.FileName != "" && len(src.InlinedRequests) > 0 {
			return nil, fmt.Errorf("Only one of FileName and InlinedRequests can be set.")
		}
		if src.FileName == "" && len(src.InlinedRequests) == 0 {
			return nil, fmt.Errorf("one of FileName and InlinedRequests must be set.")
		}
	}
	return b.create(ctx, &model, src, config)
}

var experimentalWarningBatchesCreateEmbeddings sync.Once

// Create an embeddings batch job.
func (b Batches) CreateEmbeddings(ctx context.Context, model *string, src *EmbeddingsBatchJobSource, config *CreateEmbeddingsBatchJobConfig) (*BatchJob, error) {
	experimentalWarningBatchesCreateEmbeddings.Do(func() {
		log.Println("The SDK's CreateEmbeddings implementation is experimental, and may change in future versions.")
	})
	if b.apiClient.clientConfig.Backend == BackendVertexAI {
		return nil, fmt.Errorf("Vertex AI does not support batches.createEmbeddings.")
	}
	return b.createEmbeddings(ctx, model, src, config)
}
