package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeOrgnaizationChaincodes invokes the baas.DescribeOrgnaizationChaincodes API synchronously
// api document: https://help.aliyun.com/api/baas/describeorgnaizationchaincodes.html
func (client *Client) DescribeOrgnaizationChaincodes(request *DescribeOrgnaizationChaincodesRequest) (response *DescribeOrgnaizationChaincodesResponse, err error) {
	response = CreateDescribeOrgnaizationChaincodesResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeOrgnaizationChaincodesWithChan invokes the baas.DescribeOrgnaizationChaincodes API asynchronously
// api document: https://help.aliyun.com/api/baas/describeorgnaizationchaincodes.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeOrgnaizationChaincodesWithChan(request *DescribeOrgnaizationChaincodesRequest) (<-chan *DescribeOrgnaizationChaincodesResponse, <-chan error) {
	responseChan := make(chan *DescribeOrgnaizationChaincodesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeOrgnaizationChaincodes(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeOrgnaizationChaincodesWithCallback invokes the baas.DescribeOrgnaizationChaincodes API asynchronously
// api document: https://help.aliyun.com/api/baas/describeorgnaizationchaincodes.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeOrgnaizationChaincodesWithCallback(request *DescribeOrgnaizationChaincodesRequest, callback func(response *DescribeOrgnaizationChaincodesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeOrgnaizationChaincodesResponse
		var err error
		defer close(result)
		response, err = client.DescribeOrgnaizationChaincodes(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeOrgnaizationChaincodesRequest is the request struct for api DescribeOrgnaizationChaincodes
type DescribeOrgnaizationChaincodesRequest struct {
	*requests.RpcRequest
	OrganizationId string `position:"Body" name:"OrganizationId"`
	Location       string `position:"Body" name:"Location"`
}

// DescribeOrgnaizationChaincodesResponse is the response struct for api DescribeOrgnaizationChaincodes
type DescribeOrgnaizationChaincodesResponse struct {
	*responses.BaseResponse
	RequestId string                  `json:"RequestId" xml:"RequestId"`
	Success   bool                    `json:"Success" xml:"Success"`
	ErrorCode int                     `json:"ErrorCode" xml:"ErrorCode"`
	Result    []OrganizationChaincode `json:"Result" xml:"Result"`
}

// CreateDescribeOrgnaizationChaincodesRequest creates a request to invoke DescribeOrgnaizationChaincodes API
func CreateDescribeOrgnaizationChaincodesRequest() (request *DescribeOrgnaizationChaincodesRequest) {
	request = &DescribeOrgnaizationChaincodesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "DescribeOrgnaizationChaincodes", "", "")
	return
}

// CreateDescribeOrgnaizationChaincodesResponse creates a response to parse from DescribeOrgnaizationChaincodes response
func CreateDescribeOrgnaizationChaincodesResponse() (response *DescribeOrgnaizationChaincodesResponse) {
	response = &DescribeOrgnaizationChaincodesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
