package baas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePeerLogs invokes the baas.DescribePeerLogs API synchronously
// api document: https://help.aliyun.com/api/baas/describepeerlogs.html
func (client *Client) DescribePeerLogs(request *DescribePeerLogsRequest) (response *DescribePeerLogsResponse, err error) {
	response = CreateDescribePeerLogsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePeerLogsWithChan invokes the baas.DescribePeerLogs API asynchronously
// api document: https://help.aliyun.com/api/baas/describepeerlogs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribePeerLogsWithChan(request *DescribePeerLogsRequest) (<-chan *DescribePeerLogsResponse, <-chan error) {
	responseChan := make(chan *DescribePeerLogsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePeerLogs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePeerLogsWithCallback invokes the baas.DescribePeerLogs API asynchronously
// api document: https://help.aliyun.com/api/baas/describepeerlogs.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribePeerLogsWithCallback(request *DescribePeerLogsRequest, callback func(response *DescribePeerLogsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePeerLogsResponse
		var err error
		defer close(result)
		response, err = client.DescribePeerLogs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePeerLogsRequest is the request struct for api DescribePeerLogs
type DescribePeerLogsRequest struct {
	*requests.RpcRequest
	OrganizationId string `position:"Query" name:"OrganizationId"`
	PeerName       string `position:"Query" name:"PeerName"`
	Lines          string `position:"Query" name:"Lines"`
}

// DescribePeerLogsResponse is the response struct for api DescribePeerLogs
type DescribePeerLogsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	Result    string `json:"Result" xml:"Result"`
}

// CreateDescribePeerLogsRequest creates a request to invoke DescribePeerLogs API
func CreateDescribePeerLogsRequest() (request *DescribePeerLogsRequest) {
	request = &DescribePeerLogsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Baas", "2018-07-31", "DescribePeerLogs", "", "")
	return
}

// CreateDescribePeerLogsResponse creates a response to parse from DescribePeerLogs response
func CreateDescribePeerLogsResponse() (response *DescribePeerLogsResponse) {
	response = &DescribePeerLogsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
