package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// BindEslDeviceShelf invokes the cloudesl.BindEslDeviceShelf API synchronously
// api document: https://help.aliyun.com/api/cloudesl/bindesldeviceshelf.html
func (client *Client) BindEslDeviceShelf(request *BindEslDeviceShelfRequest) (response *BindEslDeviceShelfResponse, err error) {
	response = CreateBindEslDeviceShelfResponse()
	err = client.DoAction(request, response)
	return
}

// BindEslDeviceShelfWithChan invokes the cloudesl.BindEslDeviceShelf API asynchronously
// api document: https://help.aliyun.com/api/cloudesl/bindesldeviceshelf.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BindEslDeviceShelfWithChan(request *BindEslDeviceShelfRequest) (<-chan *BindEslDeviceShelfResponse, <-chan error) {
	responseChan := make(chan *BindEslDeviceShelfResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.BindEslDeviceShelf(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// BindEslDeviceShelfWithCallback invokes the cloudesl.BindEslDeviceShelf API asynchronously
// api document: https://help.aliyun.com/api/cloudesl/bindesldeviceshelf.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) BindEslDeviceShelfWithCallback(request *BindEslDeviceShelfRequest, callback func(response *BindEslDeviceShelfResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *BindEslDeviceShelfResponse
		var err error
		defer close(result)
		response, err = client.BindEslDeviceShelf(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// BindEslDeviceShelfRequest is the request struct for api BindEslDeviceShelf
type BindEslDeviceShelfRequest struct {
	*requests.RpcRequest
	ShelfCode  string `position:"Query" name:"ShelfCode"`
	EslBarCode string `position:"Query" name:"EslBarCode"`
	StoreId    string `position:"Query" name:"StoreId"`
}

// BindEslDeviceShelfResponse is the response struct for api BindEslDeviceShelf
type BindEslDeviceShelfResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
}

// CreateBindEslDeviceShelfRequest creates a request to invoke BindEslDeviceShelf API
func CreateBindEslDeviceShelfRequest() (request *BindEslDeviceShelfRequest) {
	request = &BindEslDeviceShelfRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2018-08-01", "BindEslDeviceShelf", "", "")
	return
}

// CreateBindEslDeviceShelfResponse creates a response to parse from BindEslDeviceShelf response
func CreateBindEslDeviceShelfResponse() (response *BindEslDeviceShelfResponse) {
	response = &BindEslDeviceShelfResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
