package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeUserRamPolicy invokes the cloudesl.DescribeUserRamPolicy API synchronously
// api document: https://help.aliyun.com/api/cloudesl/describeuserrampolicy.html
func (client *Client) DescribeUserRamPolicy(request *DescribeUserRamPolicyRequest) (response *DescribeUserRamPolicyResponse, err error) {
	response = CreateDescribeUserRamPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeUserRamPolicyWithChan invokes the cloudesl.DescribeUserRamPolicy API asynchronously
// api document: https://help.aliyun.com/api/cloudesl/describeuserrampolicy.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeUserRamPolicyWithChan(request *DescribeUserRamPolicyRequest) (<-chan *DescribeUserRamPolicyResponse, <-chan error) {
	responseChan := make(chan *DescribeUserRamPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeUserRamPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeUserRamPolicyWithCallback invokes the cloudesl.DescribeUserRamPolicy API asynchronously
// api document: https://help.aliyun.com/api/cloudesl/describeuserrampolicy.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DescribeUserRamPolicyWithCallback(request *DescribeUserRamPolicyRequest, callback func(response *DescribeUserRamPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeUserRamPolicyResponse
		var err error
		defer close(result)
		response, err = client.DescribeUserRamPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeUserRamPolicyRequest is the request struct for api DescribeUserRamPolicy
type DescribeUserRamPolicyRequest struct {
	*requests.RpcRequest
	CompanyId string `position:"Query" name:"CompanyId"`
	UserType  string `position:"Query" name:"UserType"`
	StoreId   string `position:"Query" name:"StoreId"`
}

// DescribeUserRamPolicyResponse is the response struct for api DescribeUserRamPolicy
type DescribeUserRamPolicyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	ErrorCode string `json:"ErrorCode" xml:"ErrorCode"`
	Policy    string `json:"Policy" xml:"Policy"`
}

// CreateDescribeUserRamPolicyRequest creates a request to invoke DescribeUserRamPolicy API
func CreateDescribeUserRamPolicyRequest() (request *DescribeUserRamPolicyRequest) {
	request = &DescribeUserRamPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2018-08-01", "DescribeUserRamPolicy", "", "")
	return
}

// CreateDescribeUserRamPolicyResponse creates a response to parse from DescribeUserRamPolicy response
func CreateDescribeUserRamPolicyResponse() (response *DescribeUserRamPolicyResponse) {
	response = &DescribeUserRamPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
