package cloudwf

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetGroupApChangeNameTemplate invokes the cloudwf.GetGroupApChangeNameTemplate API synchronously
// api document: https://help.aliyun.com/api/cloudwf/getgroupapchangenametemplate.html
func (client *Client) GetGroupApChangeNameTemplate(request *GetGroupApChangeNameTemplateRequest) (response *GetGroupApChangeNameTemplateResponse, err error) {
	response = CreateGetGroupApChangeNameTemplateResponse()
	err = client.DoAction(request, response)
	return
}

// GetGroupApChangeNameTemplateWithChan invokes the cloudwf.GetGroupApChangeNameTemplate API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getgroupapchangenametemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetGroupApChangeNameTemplateWithChan(request *GetGroupApChangeNameTemplateRequest) (<-chan *GetGroupApChangeNameTemplateResponse, <-chan error) {
	responseChan := make(chan *GetGroupApChangeNameTemplateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetGroupApChangeNameTemplate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetGroupApChangeNameTemplateWithCallback invokes the cloudwf.GetGroupApChangeNameTemplate API asynchronously
// api document: https://help.aliyun.com/api/cloudwf/getgroupapchangenametemplate.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetGroupApChangeNameTemplateWithCallback(request *GetGroupApChangeNameTemplateRequest, callback func(response *GetGroupApChangeNameTemplateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetGroupApChangeNameTemplateResponse
		var err error
		defer close(result)
		response, err = client.GetGroupApChangeNameTemplate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetGroupApChangeNameTemplateRequest is the request struct for api GetGroupApChangeNameTemplate
type GetGroupApChangeNameTemplateRequest struct {
	*requests.RpcRequest
}

// GetGroupApChangeNameTemplateResponse is the response struct for api GetGroupApChangeNameTemplate
type GetGroupApChangeNameTemplateResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	ErrorCode int    `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMsg  string `json:"ErrorMsg" xml:"ErrorMsg"`
}

// CreateGetGroupApChangeNameTemplateRequest creates a request to invoke GetGroupApChangeNameTemplate API
func CreateGetGroupApChangeNameTemplateRequest() (request *GetGroupApChangeNameTemplateRequest) {
	request = &GetGroupApChangeNameTemplateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudwf", "2017-03-28", "GetGroupApChangeNameTemplate", "cloudwf", "openAPI")
	return
}

// CreateGetGroupApChangeNameTemplateResponse creates a response to parse from GetGroupApChangeNameTemplate response
func CreateGetGroupApChangeNameTemplateResponse() (response *GetGroupApChangeNameTemplateResponse) {
	response = &GetGroupApChangeNameTemplateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
