package cms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAlarmHistory invokes the cms.ListAlarmHistory API synchronously
// api document: https://help.aliyun.com/api/cms/listalarmhistory.html
func (client *Client) ListAlarmHistory(request *ListAlarmHistoryRequest) (response *ListAlarmHistoryResponse, err error) {
	response = CreateListAlarmHistoryResponse()
	err = client.DoAction(request, response)
	return
}

// ListAlarmHistoryWithChan invokes the cms.ListAlarmHistory API asynchronously
// api document: https://help.aliyun.com/api/cms/listalarmhistory.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListAlarmHistoryWithChan(request *ListAlarmHistoryRequest) (<-chan *ListAlarmHistoryResponse, <-chan error) {
	responseChan := make(chan *ListAlarmHistoryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAlarmHistory(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAlarmHistoryWithCallback invokes the cms.ListAlarmHistory API asynchronously
// api document: https://help.aliyun.com/api/cms/listalarmhistory.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListAlarmHistoryWithCallback(request *ListAlarmHistoryRequest, callback func(response *ListAlarmHistoryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAlarmHistoryResponse
		var err error
		defer close(result)
		response, err = client.ListAlarmHistory(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAlarmHistoryRequest is the request struct for api ListAlarmHistory
type ListAlarmHistoryRequest struct {
	*requests.RpcRequest
	Cursor    string           `position:"Query" name:"Cursor"`
	Size      requests.Integer `position:"Query" name:"Size"`
	EndTime   string           `position:"Query" name:"EndTime"`
	Id        string           `position:"Query" name:"Id"`
	StartTime string           `position:"Query" name:"StartTime"`
}

// ListAlarmHistoryResponse is the response struct for api ListAlarmHistory
type ListAlarmHistoryResponse struct {
	*responses.BaseResponse
	Success          bool                               `json:"Success" xml:"Success"`
	Code             string                             `json:"Code" xml:"Code"`
	Message          string                             `json:"Message" xml:"Message"`
	Cursor           string                             `json:"Cursor" xml:"Cursor"`
	RequestId        string                             `json:"RequestId" xml:"RequestId"`
	AlarmHistoryList AlarmHistoryListInListAlarmHistory `json:"AlarmHistoryList" xml:"AlarmHistoryList"`
}

// CreateListAlarmHistoryRequest creates a request to invoke ListAlarmHistory API
func CreateListAlarmHistoryRequest() (request *ListAlarmHistoryRequest) {
	request = &ListAlarmHistoryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cms", "2018-03-08", "ListAlarmHistory", "cms", "openAPI")
	return
}

// CreateListAlarmHistoryResponse creates a response to parse from ListAlarmHistory response
func CreateListAlarmHistoryResponse() (response *ListAlarmHistoryResponse) {
	response = &ListAlarmHistoryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
