package domain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RefuseDemand invokes the domain.RefuseDemand API synchronously
// api document: https://help.aliyun.com/api/domain/refusedemand.html
func (client *Client) RefuseDemand(request *RefuseDemandRequest) (response *RefuseDemandResponse, err error) {
	response = CreateRefuseDemandResponse()
	err = client.DoAction(request, response)
	return
}

// RefuseDemandWithChan invokes the domain.RefuseDemand API asynchronously
// api document: https://help.aliyun.com/api/domain/refusedemand.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RefuseDemandWithChan(request *RefuseDemandRequest) (<-chan *RefuseDemandResponse, <-chan error) {
	responseChan := make(chan *RefuseDemandResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RefuseDemand(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RefuseDemandWithCallback invokes the domain.RefuseDemand API asynchronously
// api document: https://help.aliyun.com/api/domain/refusedemand.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) RefuseDemandWithCallback(request *RefuseDemandRequest, callback func(response *RefuseDemandResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RefuseDemandResponse
		var err error
		defer close(result)
		response, err = client.RefuseDemand(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RefuseDemandRequest is the request struct for api RefuseDemand
type RefuseDemandRequest struct {
	*requests.RpcRequest
	BizId   string `position:"Query" name:"BizId"`
	Message string `position:"Query" name:"Message"`
}

// RefuseDemandResponse is the response struct for api RefuseDemand
type RefuseDemandResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateRefuseDemandRequest creates a request to invoke RefuseDemand API
func CreateRefuseDemandRequest() (request *RefuseDemandRequest) {
	request = &RefuseDemandRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Domain", "2018-02-08", "RefuseDemand", "", "")
	return
}

// CreateRefuseDemandResponse creates a response to parse from RefuseDemand response
func CreateRefuseDemandResponse() (response *RefuseDemandResponse) {
	response = &RefuseDemandResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
