package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteAlertUserGroups invokes the emr.DeleteAlertUserGroups API synchronously
// api document: https://help.aliyun.com/api/emr/deletealertusergroups.html
func (client *Client) DeleteAlertUserGroups(request *DeleteAlertUserGroupsRequest) (response *DeleteAlertUserGroupsResponse, err error) {
	response = CreateDeleteAlertUserGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteAlertUserGroupsWithChan invokes the emr.DeleteAlertUserGroups API asynchronously
// api document: https://help.aliyun.com/api/emr/deletealertusergroups.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteAlertUserGroupsWithChan(request *DeleteAlertUserGroupsRequest) (<-chan *DeleteAlertUserGroupsResponse, <-chan error) {
	responseChan := make(chan *DeleteAlertUserGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteAlertUserGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteAlertUserGroupsWithCallback invokes the emr.DeleteAlertUserGroups API asynchronously
// api document: https://help.aliyun.com/api/emr/deletealertusergroups.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) DeleteAlertUserGroupsWithCallback(request *DeleteAlertUserGroupsRequest, callback func(response *DeleteAlertUserGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteAlertUserGroupsResponse
		var err error
		defer close(result)
		response, err = client.DeleteAlertUserGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteAlertUserGroupsRequest is the request struct for api DeleteAlertUserGroups
type DeleteAlertUserGroupsRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	Ids             string           `position:"Query" name:"Ids"`
}

// DeleteAlertUserGroupsResponse is the response struct for api DeleteAlertUserGroups
type DeleteAlertUserGroupsResponse struct {
	*responses.BaseResponse
	Done bool `json:"Done" xml:"Done"`
}

// CreateDeleteAlertUserGroupsRequest creates a request to invoke DeleteAlertUserGroups API
func CreateDeleteAlertUserGroupsRequest() (request *DeleteAlertUserGroupsRequest) {
	request = &DeleteAlertUserGroupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "DeleteAlertUserGroups", "emr", "openAPI")
	return
}

// CreateDeleteAlertUserGroupsResponse creates a response to parse from DeleteAlertUserGroups response
func CreateDeleteAlertUserGroupsResponse() (response *DeleteAlertUserGroupsResponse) {
	response = &DeleteAlertUserGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
