package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetHdfsCapacityStatisticInfo invokes the emr.GetHdfsCapacityStatisticInfo API synchronously
// api document: https://help.aliyun.com/api/emr/gethdfscapacitystatisticinfo.html
func (client *Client) GetHdfsCapacityStatisticInfo(request *GetHdfsCapacityStatisticInfoRequest) (response *GetHdfsCapacityStatisticInfoResponse, err error) {
	response = CreateGetHdfsCapacityStatisticInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetHdfsCapacityStatisticInfoWithChan invokes the emr.GetHdfsCapacityStatisticInfo API asynchronously
// api document: https://help.aliyun.com/api/emr/gethdfscapacitystatisticinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetHdfsCapacityStatisticInfoWithChan(request *GetHdfsCapacityStatisticInfoRequest) (<-chan *GetHdfsCapacityStatisticInfoResponse, <-chan error) {
	responseChan := make(chan *GetHdfsCapacityStatisticInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetHdfsCapacityStatisticInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetHdfsCapacityStatisticInfoWithCallback invokes the emr.GetHdfsCapacityStatisticInfo API asynchronously
// api document: https://help.aliyun.com/api/emr/gethdfscapacitystatisticinfo.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetHdfsCapacityStatisticInfoWithCallback(request *GetHdfsCapacityStatisticInfoRequest, callback func(response *GetHdfsCapacityStatisticInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetHdfsCapacityStatisticInfoResponse
		var err error
		defer close(result)
		response, err = client.GetHdfsCapacityStatisticInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetHdfsCapacityStatisticInfoRequest is the request struct for api GetHdfsCapacityStatisticInfo
type GetHdfsCapacityStatisticInfoRequest struct {
	*requests.RpcRequest
	FromDatetime    string           `position:"Query" name:"FromDatetime"`
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	ToDatetime      string           `position:"Query" name:"ToDatetime"`
}

// GetHdfsCapacityStatisticInfoResponse is the response struct for api GetHdfsCapacityStatisticInfo
type GetHdfsCapacityStatisticInfoResponse struct {
	*responses.BaseResponse
	RequestId        string           `json:"RequestId" xml:"RequestId"`
	HdfsCapacityList HdfsCapacityList `json:"HdfsCapacityList" xml:"HdfsCapacityList"`
}

// CreateGetHdfsCapacityStatisticInfoRequest creates a request to invoke GetHdfsCapacityStatisticInfo API
func CreateGetHdfsCapacityStatisticInfoRequest() (request *GetHdfsCapacityStatisticInfoRequest) {
	request = &GetHdfsCapacityStatisticInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "GetHdfsCapacityStatisticInfo", "emr", "openAPI")
	return
}

// CreateGetHdfsCapacityStatisticInfoResponse creates a response to parse from GetHdfsCapacityStatisticInfo response
func CreateGetHdfsCapacityStatisticInfoResponse() (response *GetHdfsCapacityStatisticInfoResponse) {
	response = &GetHdfsCapacityStatisticInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
