package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetOpsCommandResultOnce invokes the emr.GetOpsCommandResultOnce API synchronously
// api document: https://help.aliyun.com/api/emr/getopscommandresultonce.html
func (client *Client) GetOpsCommandResultOnce(request *GetOpsCommandResultOnceRequest) (response *GetOpsCommandResultOnceResponse, err error) {
	response = CreateGetOpsCommandResultOnceResponse()
	err = client.DoAction(request, response)
	return
}

// GetOpsCommandResultOnceWithChan invokes the emr.GetOpsCommandResultOnce API asynchronously
// api document: https://help.aliyun.com/api/emr/getopscommandresultonce.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetOpsCommandResultOnceWithChan(request *GetOpsCommandResultOnceRequest) (<-chan *GetOpsCommandResultOnceResponse, <-chan error) {
	responseChan := make(chan *GetOpsCommandResultOnceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetOpsCommandResultOnce(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetOpsCommandResultOnceWithCallback invokes the emr.GetOpsCommandResultOnce API asynchronously
// api document: https://help.aliyun.com/api/emr/getopscommandresultonce.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetOpsCommandResultOnceWithCallback(request *GetOpsCommandResultOnceRequest, callback func(response *GetOpsCommandResultOnceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetOpsCommandResultOnceResponse
		var err error
		defer close(result)
		response, err = client.GetOpsCommandResultOnce(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetOpsCommandResultOnceRequest is the request struct for api GetOpsCommandResultOnce
type GetOpsCommandResultOnceRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	TaskId          requests.Integer `position:"Query" name:"TaskId"`
}

// GetOpsCommandResultOnceResponse is the response struct for api GetOpsCommandResultOnce
type GetOpsCommandResultOnceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Content   string `json:"Content" xml:"Content"`
}

// CreateGetOpsCommandResultOnceRequest creates a request to invoke GetOpsCommandResultOnce API
func CreateGetOpsCommandResultOnceRequest() (request *GetOpsCommandResultOnceRequest) {
	request = &GetOpsCommandResultOnceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "GetOpsCommandResultOnce", "emr", "openAPI")
	return
}

// CreateGetOpsCommandResultOnceResponse creates a response to parse from GetOpsCommandResultOnce response
func CreateGetOpsCommandResultOnceResponse() (response *GetOpsCommandResultOnceResponse) {
	response = &GetOpsCommandResultOnceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
