package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MetastoreCreateKafkaTopic invokes the emr.MetastoreCreateKafkaTopic API synchronously
// api document: https://help.aliyun.com/api/emr/metastorecreatekafkatopic.html
func (client *Client) MetastoreCreateKafkaTopic(request *MetastoreCreateKafkaTopicRequest) (response *MetastoreCreateKafkaTopicResponse, err error) {
	response = CreateMetastoreCreateKafkaTopicResponse()
	err = client.DoAction(request, response)
	return
}

// MetastoreCreateKafkaTopicWithChan invokes the emr.MetastoreCreateKafkaTopic API asynchronously
// api document: https://help.aliyun.com/api/emr/metastorecreatekafkatopic.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MetastoreCreateKafkaTopicWithChan(request *MetastoreCreateKafkaTopicRequest) (<-chan *MetastoreCreateKafkaTopicResponse, <-chan error) {
	responseChan := make(chan *MetastoreCreateKafkaTopicResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MetastoreCreateKafkaTopic(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MetastoreCreateKafkaTopicWithCallback invokes the emr.MetastoreCreateKafkaTopic API asynchronously
// api document: https://help.aliyun.com/api/emr/metastorecreatekafkatopic.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MetastoreCreateKafkaTopicWithCallback(request *MetastoreCreateKafkaTopicRequest, callback func(response *MetastoreCreateKafkaTopicResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MetastoreCreateKafkaTopicResponse
		var err error
		defer close(result)
		response, err = client.MetastoreCreateKafkaTopic(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MetastoreCreateKafkaTopicRequest is the request struct for api MetastoreCreateKafkaTopic
type MetastoreCreateKafkaTopicRequest struct {
	*requests.RpcRequest
	ResourceOwnerId   requests.Integer                           `position:"Query" name:"ResourceOwnerId"`
	DataSourceId      string                                     `position:"Query" name:"DataSourceId"`
	TopicName         string                                     `position:"Query" name:"TopicName"`
	AdvancedConfig    *[]MetastoreCreateKafkaTopicAdvancedConfig `position:"Query" name:"AdvancedConfig"  type:"Repeated"`
	NumPartitions     requests.Integer                           `position:"Query" name:"NumPartitions"`
	ReplicationFactor requests.Integer                           `position:"Query" name:"ReplicationFactor"`
}

// MetastoreCreateKafkaTopicAdvancedConfig is a repeated param struct in MetastoreCreateKafkaTopicRequest
type MetastoreCreateKafkaTopicAdvancedConfig struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// MetastoreCreateKafkaTopicResponse is the response struct for api MetastoreCreateKafkaTopic
type MetastoreCreateKafkaTopicResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	TaskId    string `json:"TaskId" xml:"TaskId"`
}

// CreateMetastoreCreateKafkaTopicRequest creates a request to invoke MetastoreCreateKafkaTopic API
func CreateMetastoreCreateKafkaTopicRequest() (request *MetastoreCreateKafkaTopicRequest) {
	request = &MetastoreCreateKafkaTopicRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "MetastoreCreateKafkaTopic", "emr", "openAPI")
	return
}

// CreateMetastoreCreateKafkaTopicResponse creates a response to parse from MetastoreCreateKafkaTopic response
func CreateMetastoreCreateKafkaTopicResponse() (response *MetastoreCreateKafkaTopicResponse) {
	response = &MetastoreCreateKafkaTopicResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
