package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MetastoreListTask invokes the emr.MetastoreListTask API synchronously
// api document: https://help.aliyun.com/api/emr/metastorelisttask.html
func (client *Client) MetastoreListTask(request *MetastoreListTaskRequest) (response *MetastoreListTaskResponse, err error) {
	response = CreateMetastoreListTaskResponse()
	err = client.DoAction(request, response)
	return
}

// MetastoreListTaskWithChan invokes the emr.MetastoreListTask API asynchronously
// api document: https://help.aliyun.com/api/emr/metastorelisttask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MetastoreListTaskWithChan(request *MetastoreListTaskRequest) (<-chan *MetastoreListTaskResponse, <-chan error) {
	responseChan := make(chan *MetastoreListTaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MetastoreListTask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MetastoreListTaskWithCallback invokes the emr.MetastoreListTask API asynchronously
// api document: https://help.aliyun.com/api/emr/metastorelisttask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MetastoreListTaskWithCallback(request *MetastoreListTaskRequest, callback func(response *MetastoreListTaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MetastoreListTaskResponse
		var err error
		defer close(result)
		response, err = client.MetastoreListTask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MetastoreListTaskRequest is the request struct for api MetastoreListTask
type MetastoreListTaskRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	TaskStatus      string           `position:"Query" name:"TaskStatus"`
	TaskSourceType  string           `position:"Query" name:"TaskSourceType"`
	TaskType        string           `position:"Query" name:"TaskType"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	DataSourceId    string           `position:"Query" name:"DataSourceId"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	TaskId          string           `position:"Query" name:"TaskId"`
}

// MetastoreListTaskResponse is the response struct for api MetastoreListTask
type MetastoreListTaskResponse struct {
	*responses.BaseResponse
	RequestId  string                      `json:"RequestId" xml:"RequestId"`
	TotalCount int                         `json:"TotalCount" xml:"TotalCount"`
	PageNumber int                         `json:"PageNumber" xml:"PageNumber"`
	PageSize   int                         `json:"PageSize" xml:"PageSize"`
	TaskList   TaskListInMetastoreListTask `json:"TaskList" xml:"TaskList"`
}

// CreateMetastoreListTaskRequest creates a request to invoke MetastoreListTask API
func CreateMetastoreListTaskRequest() (request *MetastoreListTaskRequest) {
	request = &MetastoreListTaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "MetastoreListTask", "emr", "openAPI")
	return
}

// CreateMetastoreListTaskResponse creates a response to parse from MetastoreListTask response
func CreateMetastoreListTaskResponse() (response *MetastoreListTaskResponse) {
	response = &MetastoreListTaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
