package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// MetastoreUpdateKafkaTopic invokes the emr.MetastoreUpdateKafkaTopic API synchronously
// api document: https://help.aliyun.com/api/emr/metastoreupdatekafkatopic.html
func (client *Client) MetastoreUpdateKafkaTopic(request *MetastoreUpdateKafkaTopicRequest) (response *MetastoreUpdateKafkaTopicResponse, err error) {
	response = CreateMetastoreUpdateKafkaTopicResponse()
	err = client.DoAction(request, response)
	return
}

// MetastoreUpdateKafkaTopicWithChan invokes the emr.MetastoreUpdateKafkaTopic API asynchronously
// api document: https://help.aliyun.com/api/emr/metastoreupdatekafkatopic.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MetastoreUpdateKafkaTopicWithChan(request *MetastoreUpdateKafkaTopicRequest) (<-chan *MetastoreUpdateKafkaTopicResponse, <-chan error) {
	responseChan := make(chan *MetastoreUpdateKafkaTopicResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.MetastoreUpdateKafkaTopic(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// MetastoreUpdateKafkaTopicWithCallback invokes the emr.MetastoreUpdateKafkaTopic API asynchronously
// api document: https://help.aliyun.com/api/emr/metastoreupdatekafkatopic.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) MetastoreUpdateKafkaTopicWithCallback(request *MetastoreUpdateKafkaTopicRequest, callback func(response *MetastoreUpdateKafkaTopicResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *MetastoreUpdateKafkaTopicResponse
		var err error
		defer close(result)
		response, err = client.MetastoreUpdateKafkaTopic(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// MetastoreUpdateKafkaTopicRequest is the request struct for api MetastoreUpdateKafkaTopic
type MetastoreUpdateKafkaTopicRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer                           `position:"Query" name:"ResourceOwnerId"`
	TopicId         string                                     `position:"Query" name:"TopicId"`
	AdvancedConfig  *[]MetastoreUpdateKafkaTopicAdvancedConfig `position:"Query" name:"AdvancedConfig"  type:"Repeated"`
	NumPartitions   requests.Integer                           `position:"Query" name:"NumPartitions"`
}

// MetastoreUpdateKafkaTopicAdvancedConfig is a repeated param struct in MetastoreUpdateKafkaTopicRequest
type MetastoreUpdateKafkaTopicAdvancedConfig struct {
	Value string `name:"Value"`
	Key   string `name:"Key"`
}

// MetastoreUpdateKafkaTopicResponse is the response struct for api MetastoreUpdateKafkaTopic
type MetastoreUpdateKafkaTopicResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	TaskId    string `json:"TaskId" xml:"TaskId"`
}

// CreateMetastoreUpdateKafkaTopicRequest creates a request to invoke MetastoreUpdateKafkaTopic API
func CreateMetastoreUpdateKafkaTopicRequest() (request *MetastoreUpdateKafkaTopicRequest) {
	request = &MetastoreUpdateKafkaTopicRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "MetastoreUpdateKafkaTopic", "emr", "openAPI")
	return
}

// CreateMetastoreUpdateKafkaTopicResponse creates a response to parse from MetastoreUpdateKafkaTopic response
func CreateMetastoreUpdateKafkaTopicResponse() (response *MetastoreUpdateKafkaTopicResponse) {
	response = &MetastoreUpdateKafkaTopicResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
